from __future__ import annotations

import time as _t
from typing import TYPE_CHECKING

from ...core import Console

if TYPE_CHECKING:
    import argparse


def _run(_: argparse.Namespace) -> None:
    console = Console()
    # Respect configured renderer: if "terminal" then exercise TerminalSession.run
    with console.live() as live:
        if hasattr(live, "run"):
            # demo terminal app
            from ...core.rendering_cli import TerminalApp

            class DemoApp(TerminalApp):
                def __init__(self) -> None:
                    super().__init__()
                    self.n = 0

                def on_tick(self, dt: float) -> None:
                    self.n += 1
                    if self.n > 30:
                        self.should_quit = True

                def on_key(self, key: str) -> None:
                    if key:
                        self.should_quit = True

                def render(self) -> str:
                    dots = "." * (self.n % 10)
                    return f"Frame {self.n}\n{dots}"

            live.run(DemoApp(), fps=20.0)
            return
        for i in range(10):
            frame = f"Frame {i}\n" + ("." * (i % 10))
            live.update(frame)
            _t.sleep(0.1)


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("live", help="Run a simple live demo with a spinner")
    parser.set_defaults(func=_run)
