from __future__ import annotations

from typing import TYPE_CHECKING

from ... import components
from ...core import tfprint

if TYPE_CHECKING:
    import argparse


def _run(_: argparse.Namespace) -> None:
    tfprint("Available components:")
    for name in sorted(components.__all__):
        tfprint(f"  - {name}")


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("list", help="List available renderable components")
    parser.set_defaults(func=_run)
