from __future__ import annotations

from typing import TYPE_CHECKING

from ...core import tfprint
from ...templates import Showcase, Template

if TYPE_CHECKING:
    import argparse


def _run(args: argparse.Namespace) -> None:
    preset = args.preset
    if preset == "game-header":
        Template.game_header("Textforge", "Modular terminal UI toolkit")
    elif preset == "inventory":
        Template.inventory_screen(
            [
                {"name": "Iron Sword", "quantity": 1, "rarity": "common"},
                {"name": "Elixir of Insight", "quantity": 2, "rarity": "rare"},
                {"name": "Phoenix Feather", "quantity": 1, "rarity": "epic"},
            ]
        )
    elif preset == "loading":
        Template.loading_screen(progress=42, total=100)
    elif preset == "full":
        Showcase.full()
    elif preset == "dashboard":
        from ...templates import Dashboard
        Dashboard.system_overview()
    elif preset == "cli-wizard":
        from ...templates.cli_apps import CliApps
        CliApps.wizard_setup()
    elif preset == "deploy":
        from ...templates.cli_apps import CliApps
        CliApps.deploy_dashboard()
    elif preset == "all":
        Showcase.full()
        from ...templates import Dashboard
        Dashboard.system_overview()
        Template.inventory_screen([
            {"name": "Iron Sword", "quantity": 1, "rarity": "common"},
            {"name": "Elixir of Insight", "quantity": 2, "rarity": "rare"},
        ])
    else:
        tfprint("[red]Unknown demo preset.[reset]")


def register(subparsers: argparse._SubParsersAction) -> None:
    parser = subparsers.add_parser("demo", help="Run showcase demos")
    parser.add_argument(
        "--preset",
        choices=["game-header", "inventory", "loading", "full", "dashboard", "cli-wizard", "deploy", "all"],
        default="game-header",
        help="Demo preset to render",
    )
    parser.set_defaults(func=_run)
