"""Module execution entry for `python -m textforge.cli`."""

from __future__ import annotations

from .main import main as cli_main

# On Windows, proactively ensure stdin is valid before argparse or subprocess
# interactions occur under `python -m textforge.cli` in captured runs.
try:
    from ..utils.io import ensure_windows_valid_stdin

    ensure_windows_valid_stdin()
except Exception:
    pass

if __name__ == "__main__":
    # When running under Windows + capture_output, subprocess may fail before
    # importing this module due to invalid stdio handles. If we got here, try
    # to run programmatically and exit cleanly.
    try:
        import sys as _sys

        # Best-effort ensure stdin valid; already attempted at import time.
        code = cli_main(_sys.argv[1:])
        raise SystemExit(code)
    except SystemExit as _se:
        raise
    except Exception as _exc:
        print(f"Error: {_exc}", file=_sys.stderr)
        raise SystemExit(1) from _exc
