"""Textforge: modular terminal text and UI rendering toolkit."""

from __future__ import annotations

from . import components, effects, templates, text_engine, utils
from .core import Console, render_call, tfprint
from .markup import MarkupEngine
from .style import Color, themes
from .utils.deprecation import deprecated

__all__ = [
    "Console",
    "render_call",
    "tfprint",
    "components",
    "effects",
    "templates",
    "text_engine",
    "utils",
    "Color",
    "themes",
    "MarkupEngine",
    "deprecated",
]
