from __future__ import annotations

from textforge.utils.testing import snapshot_assert, snapshot_path


def test_snapshot_strip_ansi_and_env_dir(tmp_path, monkeypatch):
    monkeypatch.setenv("TEXTFORGE_SNAPSHOT_DIR", str(tmp_path))
    text = "\x1b[31mRed\x1b[0m\r\n"
    snapshot_assert("ansi/sample", text, strip_ansi=True)
    path = snapshot_path("ansi/sample")
    with open(path, encoding="utf-8") as f:
        content = f.read()
    assert content == "Red\n"


def test_snapshot_path_sanitizes_colon_and_allows_nested(tmp_path):
    # Explicit root should override environment
    name = "suite:case/sub"
    snapshot_assert(name, "X", update=True, root=str(tmp_path))
    # ':' replaced with '_' and nested dir preserved
    expected = tmp_path / "suite_case" / "sub.txt"
    assert expected.exists()
