from __future__ import annotations

import io
import logging

from textforge.utils.logging import TextforgeHandler, get_logger


def test_textforge_formatter_appends_reset():
    stream = io.StringIO()
    handler = TextforgeHandler(stream)
    logger = logging.getLogger("test-logger")
    logger.handlers[:] = [handler]
    logger.setLevel(logging.INFO)
    logger.propagate = False
    logger.info("hello")
    out = stream.getvalue()
    # Ensure a final reset is present
    assert out.endswith("\x1b[0m\n") or out.endswith("\x1b[0m")


def test_get_logger_factory_singleton_handlers():
    logger = get_logger("tfx", level=logging.DEBUG)
    logger.debug("x")
    assert any(isinstance(h, TextforgeHandler) for h in logger.handlers)
