from textforge import text_engine


def test_visible_width_tabs_and_soft_hyphen():
    # '\t' advances to next tab stop (default 4)
    assert text_engine.visible_width("a\tb", ignore_ansi=True, ignore_markup=True) == 5
    # soft hyphen has zero width in measurement
    assert text_engine.visible_width("co\u00ADoperate") == len("cooperate")


def test_measure_text_multiline():
    w, h = text_engine.measure_text("one\n\ttwo")
    assert h == 2
    # line2: tab expands to width 4, so "\ttwo" -> col 0..3 tab, then 3 chars => 7
    assert w >= 7


def test_bidi_reorder_basic():
    # Mix simple Latin and a right-to-left script (Hebrew letters)
    txt = "abc \u05D0\u05D1\u05D2 def"  # alef-bet-gimel
    reordered = text_engine.bidi_reorder(txt)
    assert isinstance(reordered, str)
