﻿import io
from contextlib import redirect_stdout

from textforge.templates.business import Business


def _capture(fn, *args, **kwargs):
    buf = io.StringIO()
    with redirect_stdout(buf):
        fn(*args, **kwargs)
    return buf.getvalue()


def test_business_invoice_outputs_total():
    rows = [('Widget', 2, 9.5), ('Service', 1, 15.0)]
    output = _capture(Business.invoice, 'Acme Co', 'INV-1', rows, width=40)
    assert 'Total Due' in output


def test_business_report_card_lists_items():
    output = _capture(Business.report_card, 'Summary', {'Sales': '$100', 'Users': '12'})
    assert 'Sales' in output
