from __future__ import annotations

from textforge.plugins import PluginRegistry


def test_plugin_registry_load_entry_points_does_not_crash_without_eps(monkeypatch):
    # Simulate absence of importlib.metadata.entry_points
    try:
        import textforge.plugins as plugins_mod
    except Exception:
        plugins_mod = None
    if plugins_mod is None:
        return

    monkeypatch.setattr(plugins_mod, "entry_points", None, raising=False)
    count = PluginRegistry.load_entry_points()
    assert isinstance(count, int)
    assert count == 0
