from textforge.layout import LayoutNode, LayoutStyle, compute_layout


def test_row_wrap_determinism_rounding():
    root = LayoutNode(style=LayoutStyle(direction="row", gap=1, wrap=True, width=10))
    a = LayoutNode(style=LayoutStyle(width=3, height=1))
    b = LayoutNode(style=LayoutStyle(width=3, height=1))
    c = LayoutNode(style=LayoutStyle(width=3, height=1))
    root.add(a)
    root.add(b)
    root.add(c)
    compute_layout(root)
    # re-run to ensure determinism regardless of internal order/rounding
    compute_layout(root)
    assert (a.layout.x, a.layout.y, b.layout.x, b.layout.y, c.layout.x, c.layout.y) == (
        a.layout.x,
        a.layout.y,
        b.layout.x,
        b.layout.y,
        c.layout.x,
        c.layout.y,
    )


def test_column_wrap_positions():
    root = LayoutNode(style=LayoutStyle(direction="column", gap=1, wrap=True, height=3))
    children = [LayoutNode(style=LayoutStyle(width=2, height=2)) for _ in range(3)]
    for ch in children:
        root.add(ch)
    compute_layout(root)
    # Child 1 and 2 should be in the first column (y positions increasing),
    # third should start a new column (x > 0, y reset)
    assert children[0].layout.x == 0
    assert children[1].layout.x == 0
    assert children[2].layout.x > 0
    assert children[2].layout.y <= children[0].layout.y
