from __future__ import annotations

from textforge.utils.jupyter import display_ansi_html, display_ansi_svg


def test_jupyter_display_gracefully_falls_back_when_ipython_missing(monkeypatch, capsys):
    # Simulate ImportError for IPython.display
    import builtins

    original_import = builtins.__import__

    def fake_import(name, *args, **kwargs):
        if name.startswith("IPython.display") or name == "IPython":
            raise ImportError("No IPython in test")
        return original_import(name, *args, **kwargs)

    monkeypatch.setattr(builtins, "__import__", fake_import)

    text = "\x1b[36mHello\x1b[0m"
    display_ansi_html(text)
    display_ansi_svg(text)
    out = capsys.readouterr().out
    assert "Hello" in out  # ANSI should be stripped in fallback
