from textforge import text_engine


def test_emoji_zwj_sequence_width_and_clustering():
    family = "👩\u200d👩\u200d👧\u200d👦"
    clusters = list(text_engine.iter_graphemes(family))
    # Should treat as a sequence of multiple graphemes connected with ZWJ; commonly a single cluster
    assert len(clusters) >= 1
    # Total width should be at least 2 cells
    assert text_engine.visible_width(family) >= 2


def test_combining_marks_cluster_width():
    s = "e\u0301"  # e + combining acute accent
    clusters = list(text_engine.iter_graphemes(s))
    assert len(clusters) == 1
    assert text_engine.visible_width(s) == 1
