import io
from contextlib import redirect_stdout

from textforge.dsl import run as dsl_run


def _capture(src: str) -> str:
    buf = io.StringIO()
    with redirect_stdout(buf):
        dsl_run(src)
    return buf.getvalue()


def test_dsl_quoted_args_and_spaces():
    out = _capture('Title text="Hello World" width=40 color="primary"')
    assert "Hello" in out and "World" in out


def test_dsl_booleans_and_numbers():
    out = _capture('ProgressBar current=5 maximum=10 show_percentage=true show_numbers=false')
    assert "50%" in out or "5/10" not in out  # percentage may be present; numbers may be hidden


def test_dsl_arrays_and_nested_objects():
    out = _capture('ListElement items=["One","Two Three","Four"] width=40')
    assert "One" in out and "Two Three" in out


def test_dsl_json_object_value():
    out = _capture('Meter value=64.3 thresholds={"0.0":"green","0.6":"yellow","0.8":"red"}')
    assert "64.3" in out or "%" in out
