from __future__ import annotations

import subprocess
import sys


def _run(*args: str) -> tuple[int, str, str]:
    proc = subprocess.run([sys.executable, *args], capture_output=True, text=True)
    return proc.returncode, proc.stdout, proc.stderr


def test_python_m_textforge_list_smoke():
    code, out, err = _run("-m", "textforge", "list")
    # Should run and print available components
    assert code in (0, 1, 2)
    assert "Available components" in out


def test_python_m_textforge_cli_list_smoke():
    code, out, err = _run("-m", "textforge.cli", "list")
    assert code in (0, 1, 2)
    assert "Available components" in out
