import io
from contextlib import redirect_stdout

from textforge.cli.main import main as cli_main


def _run_and_capture(*argv: str) -> str:
    buf = io.StringIO()
    with redirect_stdout(buf):
        try:
            cli_main(list(argv))
        except SystemExit:
            # In case argparse decides to exit
            pass
    return buf.getvalue()


def test_demo_game_header_outputs_title():
    out = _run_and_capture("demo", "--preset", "game-header")
    assert out
    assert "Textforge" in out or "TEXTFORGE" in out


def test_demo_inventory_outputs_inventory():
    out = _run_and_capture("demo", "--preset", "inventory")
    assert "INVENTORY" in out


def test_demo_loading_outputs_loading():
    out = _run_and_capture("demo", "--preset", "loading")
    assert "Loading" in out


def test_demo_full_outputs_showcase():
    out = _run_and_capture("demo", "--preset", "full")
    assert "TEXTFORGE SHOWCASE" in out


def test_demo_dashboard_outputs_header():
    out = _run_and_capture("demo", "--preset", "dashboard")
    assert "SYSTEM OVERVIEW" in out


def test_demo_cli_wizard_outputs_wizard():
    out = _run_and_capture("demo", "--preset", "cli-wizard")
    assert "SETUP WIZARD" in out


def test_demo_deploy_outputs_deployment():
    out = _run_and_capture("demo", "--preset", "deploy")
    assert "DEPLOYMENT" in out


def test_demo_all_outputs_multiple_sections():
    out = _run_and_capture("demo", "--preset", "all")
    assert any(s in out for s in ["TEXTFORGE SHOWCASE", "SYSTEM OVERVIEW", "INVENTORY"])
