﻿from textforge.utils.accessibility import AccessibilityAPI, AccessibilityNode


def setup_function(_):
    AccessibilityAPI.clear()


def test_register_and_export_accessibility_node():
    child = AccessibilityNode(role='button', name='Confirm', description='Confirms selection')
    node = AccessibilityAPI.register_node(
        'status',
        role='status',
        name='Sync state',
        description='Background sync idle',
        state={'busy': False},
        shortcuts=['ctrl+s'],
        children=[child],
    )
    aria = node.aria_attributes()
    assert aria['role'] == 'status'
    assert aria['aria-label'] == 'Sync state'
    registry = AccessibilityAPI.export_registry()
    assert 'status' in registry
    summary = AccessibilityAPI.describe_registry()
    assert 'Sync state' in summary
    assert 'button' in summary


def test_annotate_progress_sets_state():
    node = AccessibilityAPI.annotate_progress('progress', label='Upload', current=40, maximum=80, unit='files')
    assert node.state['valuenow'] == '40.0'
    aria = node.aria_attributes()
    assert aria['role'] == 'progressbar'
    assert 'Upload' in aria['aria-label']


def test_compose_alt_text_truncates():
    text = AccessibilityAPI.compose_alt_text('Panel', ['line1', 'line2', 'line3'], max_lines=2)
    assert text.startswith('Panel:')
    assert '...' in text
