import random
import time

from textforge import components as C
from textforge import tfprint


def main() -> None:
    tfprint(C.title("LOG VIEWER", width=80, symbol_style="rounded", color="primary"))
    lines: list[str] = []
    levels = ["info", "warning", "error", "success"]
    for i in range(10):
        lvl = random.choice(levels)
        lines.append(f"[{lvl}] {time.strftime('%H:%M:%S')} event {i:03d}: demo line")
    tfprint(C.console_panel(lines, width=80, height=10, border_style="box"))


if __name__ == "__main__":
    main()
