import random
import time

from textforge import Console, tfprint
from textforge import components as C


def make_frame() -> str:
    parts: list[str] = []
    # Build a frame by capturing tfprint of renderables (public API)
    parts.append(Console().capture(tfprint, C.title("LIVE PROCESS MONITOR", width=80, symbol_style="rounded", color="accent")))
    cpu = random.randint(0, 100)
    mem = random.randint(0, 100)
    parts.append(Console().capture(tfprint, C.progress_bar(cpu, 100, label="CPU", color="warning", width=60)))
    parts.append(Console().capture(tfprint, C.progress_bar(mem, 100, label="Memory", color="info", width=60)))
    return "\n".join(parts)


def main() -> None:
    console = Console.for_stdout()
    with console.live() as live:
        start = time.time()
        while time.time() - start < 3.0:
            live.update(make_frame())
            time.sleep(0.2)
    tfprint(C.toast("Monitoring finished", tone="success", width=40))


if __name__ == "__main__":
    main()
