# Textforge Refactor Plan

## Current Capabilities in `main.py`
| Feature | Implementation | Proposed Module(s) | Notes |
| --- | --- | --- | --- |
| ANSI color helpers | `Color.get_color`, `hex_to_ansi`, `rgb_to_ansi`, `hex_to_bg_ansi`, `rgb_to_bg_ansi` | `textforge.colors`, `textforge.utils.color_math` | Normalize API, add palette registry |
| Inline markup parsing | `Color.apply_inline_markup` | `textforge.markup.parser`, `textforge.markup.tokens` | Replace regex pipeline with proper tokenizer |
| Gradient utilities | `Color.gradient`, `create_gradient_text`, `rainbow_text` | `textforge.effects.gradient` | Support multi-stop gradients and easing |
| Symbol presets | `Symbols.get_symbols` and constants | `textforge.symbols` | Provide theme-aware glyph sets |
| Text layout helpers | `wrap_text`, `wrap_text_advanced`, `center_text`, `justify_text`, `indent_text`, `truncate_text`, `get_visible_length`, `strip_ansi`, `format_text`, `box_text` | `textforge.layout.text` | Consolidate width calc and wrapping strategies |
| Titles & headings | `Title.render` | `textforge.components.title` | Expose presets, size variants |
| Paragraphs | `Paragraph.render` | `textforge.components.paragraph` | Add spacing/theming controls |
| Lists | `ListElement.render` | `textforge.components.listing` | Support nested/ordered/checkbox lists |
| Boxes & borders | `Box.render` | `textforge.components.box`, `textforge.style.borders` | Extract border styles with registry |
| Progress bars | `ProgressBar.render` | `textforge.components.progress` | Add indeterminate/stacked modes |
| Dividers | `Divider.render` | `textforge.components.divider` | Provide pattern presets |
| Tables | `Table.render` | `textforge.components.table`, `textforge.layout.table` | Add cell alignment, merging, streaming |
| Status bars | `StatusBar.render` | `textforge.components.status` | Support live updates & meters |
| Cards | `Card.render` | `textforge.components.card` | Theme aware panel styles |
| Badges | `Badge.render` | `textforge.components.badge` | Provide tone presets & icons |
| Charts | `Chart.bar_chart` | `textforge.components.charts.bar` | Generalize to pie/line/sparkline |
| Columns | `Columns.render` | `textforge.layout.columns` | Responsive sizing, gap control |
| Trees | `Tree.render` | `textforge.components.tree` | Virtualized render, expand/collapse |
| Banners | `Banner.render` | `textforge.components.banner` | ASCII art font integration |
| Animations | `Animation.typewriter`, `Animation.fade_in` | `textforge.effects.animation` | Async-friendly animation engine |
| Templates | `Template.*` suite | `textforge.templates.*` | Break into template packs |
| Menus | `Menu.render`, `HorizontalMenu.render` | `textforge.components.menu`, `textforge.components.menu.horizontal` | Support input handling, focus |
| Panels | `Panel.render` | `textforge.components.panel` | Theme aware surfaces |
| Grids | `Grid.render` | `textforge.layout.grid` | Auto-fit, responsive breakpoints |
| Spinners | `Spinner.render` | `textforge.components.spinner` | Provide frame registry |
| Dialogs | `Dialog.render` | `textforge.components.dialog` | Add overlay/backdrop support |
| Comparisons | `Comparison.render` | `textforge.components.comparison` | Diff highlighting |
| Ratings | `Rating.render` | `textforge.components.rating` | Custom glyphs, partial fills |
| Breadcrumbs | `Breadcrumbs.render` | `textforge.components.navigation.breadcrumbs` | Provide separator styles |
| Key-value blocks | `KeyValue.render` | `textforge.components.key_value` | Column alignment, wrapping |
| Block quotes | `BlockQuote.render` | `textforge.components.quote` | Citation metadata |
| Step lists | `Steps.render` | `textforge.components.steps` | Progress indicators |
| Segmented bars | `SegmentedBar.render` | `textforge.components.segmented_bar` | Dynamic segment theming |
| Meters | `Meter.render` | `textforge.components.meter` | Threshold palettes, gauges |
| Utility functions | `box_text`, `wrap_text`, etc. | `textforge.utils.*` | Centralize helpers for reuse |

## Modular Package Layout (Proposed)
- `textforge/__init__.py`: public API surface exposing `tfprint`, renderables, registry access.
- `textforge/console.py`: lightweight rendering orchestrator with output adapters.
- `textforge/colors.py`: canonical color registry, conversion helpers, palettes.
- `textforge/style/`: border styles, themes, typography tokens, spacing scale.
- `textforge/layout/`: text measuring, wrapping, column/grid engines.
- `textforge/markup/`: tokenizer, parser, renderer, custom tag registration.
- `textforge/effects/`: animations, transitions, easing, gradient engines.
- `textforge/components/`: subpackages per component family (text, data, status, navigation, feedback).
- `textforge/templates/`: opinionated templates grouped by vertical (games, business, cli dashboards).
- `textforge/cli/`: argparse/typer powered command surface (`textforge` CLI, component scaffolding, preview server).
- `textforge/utils/`: generic helpers (strings, ansi, alignment, validation).
- `textforge/testing/`: render snapshot utilities for projects integrating Textforge.

## Core API Direction
- Introduce `tfprint(*renderables, style=None, console=None, **options)` as ergonomic entry point with f-string-esque interpolation via `[|]` mini-language.
- Provide `Renderable` protocol and base classes for composable components.
- Implement `Console` abstraction with adapters (stdout, rich-style live console, log files, Jupyter).
- Add declarative `Style` objects for color/effect bundles and theme inheritance.
- Enable plugin system (`textforge.plugins`) for user supplied components, themes, converters.

## High-Priority Expansion Backlog
- Live rendering engine with diff-based updates & background tasks.
- Layout engine with constraint solving, responsive breakpoints, and flex/grid mixins.
- Markdown/commonmark parser integration with Textforge components.
- SVG/HTML export pipeline for documentation & web previews.
- Configurable animation timelines, asynchronous playback, and frame scheduler.
- Accessibility features: screen-reader alternative text, WCAG-aware palettes.
- Input handling toolkit (keyboard/controller) for interactive menus/dialogs.
- Data visualizations: line/area charts, sparklines, heatmaps, mini-maps.
- Logging integration (structured log formatting, log levels, sinks).
- Theme packs for games, enterprise dashboards, monitoring, sci-fi terminals.
- CLI utilities: component browser, template generator, theming scaffolder, live preview server.
- Internationalization: bidi text handling, localized templates, pluralization rules.
- Virtual DOM layer for stateful applications and incremental updates.

## Immediate Next Steps
1. Extract foundational utilities (`colors`, `markup`, `layout`) into dedicated modules.
2. Define public API (`tfprint`, `Console`, `Renderable`) and update tests/examples.
3. Move component classes into subpackages, grouping by domain and reducing duplication.
4. Flesh out CLI entry point (`textforge` command) with preview, inspect, and scaffold verbs.
5. Replace `main.py` with package entry script and update packaging metadata.
