# Component Gallery

This gallery is generated from real components using the `Showcase` template.

- Render width: 80 columns
- Formats: ANSI, HTML, SVG, PDF

## Available Templates

Textforge provides several pre-built templates for different use cases:

### Showcase (`textforge.templates.Showcase`)
The comprehensive component gallery demonstrating all available UI components:
- **Typography**: Titles, paragraphs, lists, block quotes, steps
- **Status**: Progress bars, meters, spinners, segmented bars, various gauges
- **Data**: Tables, charts (bar, sparkline, area, histogram), key-value pairs, code blocks
- **Containers**: Boxes, cards, panels, dialogs with various layouts
- **Layout**: Columns, grids, tree structures
- **Navigation**: Breadcrumbs, menus, tabs, accordions, horizontal menus
- **Feedback**: Toasts, snackbars, alert banners, badges, ratings, console panels
- **Decorative**: ASCII art, banners, dividers, tooltips
- **Interactive**: Checkboxes, radio buttons, sliders, form elements (static previews)
- **Visual**: Graph canvases, waveforms, spectrograms, mini-maps, grid maps

### Business (`textforge.templates.Business`)
Business-oriented templates for reports and documentation:
- **Report Cards**: Formatted key-value summaries with titles and sections
- **Invoices**: Structured billing documents with company info, item tables, and totals
- **KPI Summaries**: Metric dashboards with visual indicators

### Dashboard (`textforge.templates.Dashboard`)
System monitoring and metrics dashboards:
- **System Overview**: CPU, memory, disk usage with progress bars and meters
- **Service Status**: Tables of services with versions and status indicators
- **Grid Layouts**: Multi-column metric displays

### Game (`textforge.templates.Template`)
Game UI templates for RPGs and interactive applications:
- **Game Headers**: Styled banners with titles and subtitles
- **Combat Status**: Player vs enemy health bars and status displays
- **Inventory Screens**: Item lists with rarity indicators and quantities
- **Loading Screens**: Progress indicators with custom messages

### CLI Apps (`textforge.templates.cli_apps.CliApps`)
Command-line application templates:
- **Wizard Setup**: Multi-step setup wizards with progress tracking
- **Deploy Dashboard**: Deployment status with service monitoring and build progress

## CLI Demo Commands

Textforge includes a `demo` CLI command with various presets for quick previews:

```bash
textforge demo --preset <preset_name>
```

Available presets:
- **`game-header`** (default): Game-style header banner with title and subtitle
- **`inventory`**: RPG inventory screen with items, quantities, and rarity indicators
- **`loading`**: Loading screen with progress bar and status message
- **`full`**: Complete showcase of all components (same as generated gallery)
- **`dashboard`**: System monitoring dashboard with metrics and status tables
- **`cli-wizard`**: Setup wizard interface with steps and progress tracking
- **`deploy`**: Deployment dashboard with service status and build progress
- **`all`**: Runs multiple demos sequentially (showcase, dashboard, inventory)

## Example Scripts

The `examples/` directory contains runnable Python scripts demonstrating various use cases:

- **`dashboard.py`**: System monitoring dashboard using the Dashboard template
- **`game_hud.py`**: Game UI elements including headers, combat status, and inventory screens
- **`interactive_menu.py`**: Interactive navigation menus and selection interfaces
- **`live_monitor.py`**: Real-time data monitoring with live updates and animations
- **`log_viewer.py`**: Log file viewer with filtering and search capabilities

Run any example with:
```bash
python examples/<script_name>.py
```

## How to regenerate

```bash
python tools/generate_gallery.py --out docs/gallery --width 80
```

Artifacts will appear under `docs/gallery/`:

### Output Formats

- **`showcase.ansi.txt`**: Plain text with ANSI color codes - view in terminal with `cat docs/gallery/showcase.ansi.txt` or use tools like `less -R`
- **`showcase.html`**: Standalone HTML file with embedded CSS - open in any web browser for rich formatting
- **`showcase.svg`**: Scalable vector graphics - perfect for embedding in documentation or high-DPI displays
- **`showcase.pdf`**: Portable document format - ideal for sharing printable versions or including in reports

### Viewing Options

- **Terminal**: Use `cat` or `less -R` for ANSI files, or run `textforge demo --preset full` for interactive preview
- **Web Browser**: Open HTML/SVG files directly for styled previews
- **PDF Viewer**: Use any PDF reader to view the formatted document
- **Documentation**: Embed HTML/SVG in web docs, or link to PDF downloads

All formats preserve the exact same visual layout and styling, allowing you to choose the best format for your use case.
