Textforge Compatibility Matrix

## Python Version Requirements

- **Python 3.14+**: Required (no older versions supported)
- Type hints used throughout codebase with strict mypy checking

## Operating System Support

### Windows
- **Full Support**: Primary development platform
- **Terminal Emulators**: ConHost, Windows Terminal, PowerShell
- **GUI Backend**: Native Win32 windowing system
- **Legacy Support**: Automatic ASCII fallback for cp1252/cp437 encodings
- **Optional Dependencies**: `colorama>=0.4.6` for enhanced legacy Windows console support

### Linux
- **Full Support**: Complete feature parity
- **Terminal Emulators**: xterm, GNOME Terminal, Alacritty
- **Input Handling**: POSIX pty-based input processing
- **Package Managers**: pip, conda, system packages

### macOS
- **Full Support**: Compatible with macOS terminal ecosystem
- **Terminal Emulators**: Terminal.app, iTerm2
- **Package Managers**: pip, conda, Homebrew

## Rendering Backends

### CLI/Terminal Backend (Default)
- **Cross-platform**: Works on all supported operating systems
- **Live Updates**: Diff-based terminal updates via `Console.live()`
- **Interactive Sessions**: Mouse and keyboard input handling
- **Unicode Support**: Full grapheme-aware rendering

### GUI Backend
- **Platform**: Windows-only (Win32 API)
- **Features**: Native window rendering, OpenGL acceleration
- **Threading**: Dedicated UI thread with message pump
- **Fallback**: Graceful fallback to terminal mode if GUI unavailable

### Jupyter Integration
- **Optional Dependency**: `ipython>=8`
- **Display Modes**: Automatic ANSI-to-HTML/SVG conversion
- **Fallback**: Plain text output when rich display unavailable

## Export Formats

- **HTML**: Full ANSI-to-HTML conversion
- **SVG**: Vector graphics export with text positioning
- **PDF**: Basic PDF generation
- **Plain Text**: ANSI sequence stripping for logs/CI

## Unicode and Text Handling

### Grapheme Support
- **Unicode Graphemes**: Proper handling of multi-codepoint characters
- **Emoji Width**: Detection and measurement (some terminals render emoji as width 1 vs 2)
- **Bidirectional Text**: Full bidi reordering support
- **Combining Characters**: Proper width calculation for complex scripts

### ASCII Fallback
- **Environment Variable**: `TEXTFORGE_ASCII_MODE=1` forces ASCII mode
- **Programmatic Control**: `Symbols.set_ascii_mode(True)`
- **Auto-detection**: Automatic fallback for legacy encodings (cp1252/cp437)
- **Component Support**: Many components accept `ascii_mode` parameter

## Terminal Compatibility

### ANSI Support
- **Color Codes**: Full 256-color and truecolor support where available
- **Text Effects**: Bold, italic, underline, strikethrough
- **Non-TTY Handling**: Automatic ANSI stripping for CI/logs/pipes
- **File Output**: `Console.for_file()` for clean file writing

### Terminal Detection
- **TTY Detection**: Automatic behavior adjustment for interactive vs non-interactive
- **Encoding Detection**: Runtime encoding detection for symbol selection
- **Capability Detection**: Terminal feature detection and graceful degradation

## Optional Dependencies

- **legacy_windows**: Enhanced Windows console support with colorama
- **jupyter**: IPython integration for notebook environments

## Development and Testing

### Build System
- **Setuptools**: Standard Python packaging
- **Type Checking**: mypy with strict settings
- **Linting**: ruff formatter and linter
- **Testing**: pytest with coverage reporting

### CI/CD
- **Cross-platform Testing**: Windows, Linux, macOS
- **Performance Benchmarks**: Built-in benchmarking suite
- **Snapshot Testing**: Visual regression testing

## Known Limitations

- GUI backend currently Windows-only (Win32 implementation)
- Some emoji may display with incorrect width on certain terminals
- Legacy Windows consoles may require ASCII mode for proper rendering
- PDF export is basic and may need enhancement for complex layouts

## Migration Notes

- **From Rich/Textual**: Textforge provides similar functionality with a component-based architecture
- **Terminal Requirements**: Modern terminal with ANSI support recommended
- **Legacy Systems**: ASCII mode available for constrained environments
