# CLI Reference

The `textforge` command bundles utilities for browsing components, running demos, exporting, and more.

## Commands

### Core Commands

- `list`: List all available renderable components
- `demo --preset {game-header,inventory,loading,full,dashboard,cli-wizard,deploy,all}`: Run interactive demos and showcases (default: game-header)
- `typewriter MESSAGE [--delay DELAY] [--color COLOR]`: Play a typewriter animation with optional delay (default: 0.05) and color
- `preview PATH`: Render and display a markdown file using Textforge's markdown renderer

### Export & Development

- `export [-f {html,svg,text,pdf}] [-o OUTPUT]`: Convert ANSI text from stdin to specified format (default: html). PDF requires explicit --output file
- `live`: Run a simple live demo with animated frames and spinner
- `dsl [-f FILE]`: Execute the Textforge DSL. Reads from file or stdin if no file specified

### Utilities

- `theme list`: List all available themes
- `markup list-tags`: List globally registered custom markup tags
- `plugins list`: List registered plugins (discovers entry points automatically)
- `new NAME [--dir DIR]`: Scaffold a new Textforge project with basic structure (default dir: current directory)
- `bench [--micro] [--metrics] [--python EXE] [--no-bench]`: Run benchmark suites and performance metrics. Use --micro for focused tests, --metrics for timing data

## Examples

### Basic Usage

```bash
# List all available components
textforge list

# Run the full interactive demo showcase
textforge demo --preset full

# Preview a markdown file
textforge preview README.md

# Create a typewriter animation
textforge typewriter "Hello, Textforge!" --delay 0.1 --color green
```

### Export Examples

```bash
# Export ANSI text to HTML
textforge export -f html < input.ansi > output.html

# Export to SVG with output file
textforge export -f svg -o output.svg < input.ansi

# Export to PDF (requires explicit output file)
textforge export -f pdf -o document.pdf < input.ansi

# Export to plain text
textforge export -f text < input.ansi > output.txt
```

### Development & Utilities

```bash
# Scaffold a new project
textforge new my-project --dir ./projects

# Run benchmarks with performance metrics
textforge bench --metrics

# Run micro-benchmarks only
textforge bench --micro

# List available themes
textforge theme list

# List custom markup tags
textforge markup list-tags

# List registered plugins
textforge plugins list

# Execute DSL from file
textforge dsl -f script.tf

# Execute DSL from stdin
echo "title('Hello')" | textforge dsl
```

### Advanced Usage

```bash
# Run live demo with animation
textforge live

# Run all demo presets in sequence
textforge demo --preset all

# Benchmark with specific Python executable
textforge bench --metrics --python python3.11
```
