# Architecture Overview

## Core Architecture

textforge/
  core/           - console, renderables, vdom/diff, rendering backends
  components/     - UI components (containers, data, decorative, feedback, interactive, layout, navigation, status, typography, visual)
  effects/        - animations, transitions
  export/         - html/svg/pdf/plain + render_tree utilities
  layout/         - layout engine and grid computation
  markup/         - markup processing engine
  style/          - themes, colors, borders, gradients, palettes, tokens
  templates/      - app-level templates (business, dashboard, game, showcase)
  utils/          - helpers: i18n, io, logging, accessibility, config, etc.
  cli/            - command-line interface and subcommands
  dsl.py          - scripting DSL for component invocation
  plugins.py      - plugin registry and entry point discovery
  renderables/    - base renderable classes and protocols
  text_engine.py  - unicode-aware text processing (graphemes, width, bidi)
  api.py          - stable API aggregator for 1.x

## Core Rendering System

- **textforge.core.Console** is the main rendering coordinator, handling output streams, markup processing, and theme management.
- **textforge.core.vdom** provides virtual DOM utilities with line-diffing for efficient live rendering updates.
- **Rendering Backends**: Separate implementations for CLI (`rendering_cli/`) and GUI (`rendering_gui/`) environments.
  - CLI backend includes terminal sessions, mouse handling, and window management.
  - GUI backend includes OpenGL rendering, threading, and platform-specific windowing (Win32).
- **Renderable Protocol**: Components implement a standard interface for rendering and measurement via the Console.

## Component Architecture

Components are organized into logical categories:

- **containers/**: Box, Card, Dialog, Panel, ScrollablePanel
- **data/**: Chart, CodeBlock, Comparison, KeyValue, Table
- **decorative/**: AsciiArt, Banner, Divider, Tooltip
- **feedback/**: AlertBanner, Badge, ConsolePanel, Rating, Snackbar, Toast
- **interactive/**: Checkbox, Form, Radio, Slider, Toggle
- **layout/**: Columns, Grid, Tree
- **navigation/**: Accordion, Breadcrumbs, HorizontalMenu, Menu, Tabs
- **status/**: Compass, GaugeDial, Meter, ProgressBar, SegmentedBar, Spinner, StatusBar, Thermometer, WeatherIndicator
- **typography/**: BlockQuote, ListElement, Paragraph, Steps, Title
- **visual/**: GraphCanvas, GridMap, ImageBlock, MiniMap, Spectrogram, Waveform

## Export System

Multi-format export capabilities:
- **html.py**: ANSI-to-HTML conversion
- **svg.py**: ANSI-to-SVG conversion
- **pdf.py**: ANSI-to-PDF conversion
- **plain.py**: ANSI-to-plain-text conversion
- **render_tree.py**: Render tree utilities for structured output

## Style System

Comprehensive styling infrastructure:
- **colors.py**: Color management and ANSI color support
- **themes.py**: Theme management system
- **borders.py**: Border styling
- **gradients.py**: Gradient effects
- **palette.py**: Color palettes
- **tokens.py**: Design tokens
- **ansi.py**: ANSI escape sequence handling

## Text Processing Engine

Unicode-aware text handling:
- **graphemes.py**: Grapheme iteration and width calculation
- **width.py**: Text measurement and ANSI/markup stripping
- **bidi.py**: Bidirectional text reordering

## CLI System

Command-line interface with multiple subcommands:
- **commands/**: bench_cmd, demo, dsl_cmd, export_cmd, list_cmd, live_cmd, markup_cmd, new, plugins_cmd, preview, theme, typewriter_cmd
- **main.py**: CLI entry point
- **errors.py**: CLI error handling

## Plugin System

Extensible plugin architecture:
- Runtime registration API
- Entry point discovery via `importlib.metadata`
- Group: `textforge.plugins`

## Layout Engine

Advanced layout computation:
- **engine.py**: Core layout algorithms (LayoutNode, LayoutResult, LayoutStyle)
- **utils.py**: Layout utility functions
- Grid-based layout computation

## Effects System

Animation and transition framework:
- **animation.py**: Animation classes and timeline management
- **transitions.py**: Transition effects

## Markup Engine

Text markup processing:
- **engine.py**: MarkupEngine for parsing and rendering markup
- **markdown.py**: Markdown-specific processing

## Utility Modules

Comprehensive utility library:
- **accessibility.py**: Accessibility helpers
- **config.py**: Configuration management
- **i18n.py**: Internationalization support
- **input.py**: Input handling
- **logging.py**: Logging utilities
- **testing.py**: Testing helpers
- **text.py**: Text processing utilities
- Additional utilities: bench, debug_overlay, deprecation, io, jupyter, lint, profiling, traceback

## API Design

- **Public API**: Re-exported at package root (`textforge/__init__.py`) and via stable `textforge.api` module
- **Stable API**: Versioned API surface for 1.x compatibility
- **DSL**: Scripting interface for component invocation with Python literal syntax
- **Templates**: Pre-built application templates for common use cases

## Key Design Principles

- **Separation of Concerns**: Clear module boundaries and single responsibilities
- **Composition over Inheritance**: Component system favors composition
- **Pure Functions**: Preference for side-effect-free functions where possible
- **Platform Compatibility**: Support for multiple operating systems and rendering backends
- **Extensibility**: Plugin system and modular architecture enable extensions
- **Type Safety**: Comprehensive type hints throughout the codebase

