﻿# API Reference

Refer to `textforge.api` for the stable 1.x interface; the package root re-exports common symbols for convenience.
Internal modules are prefixed with underscores or documented as internal; do not rely on them for 1.x compatibility.

## Console & Core
- `Console`, `tfprint`, `Renderable`, `render_call`, `composite`, `lazy`
- Live updates: `Console.live()`
- Console utilities: `use_console`, `CallableRenderable`, `CompositeRenderable`, `LazyRenderable`, `Measure`
- VDOM diffing: `textforge.core.render_tree` (`Node`, `diff_lines`, `diff_changes`, `apply_changes`)

## Style & Themes
- `Color` (color resolution and inline markup)
- `ThemeManager` and `Theme` in `textforge.style.themes` (register, set_current, get_current, context management)
- Style submodules: `ansi`, `borders`, `gradients`, `palette`, `tokens`

## Components (`textforge.components`)
- Typography: `Title`, `Paragraph`, `ListElement`, `BlockQuote`, `Steps`
- Status: `ProgressBar`, `SegmentedBar`, `Spinner`, `StatusBar`, `Thermometer`, `Compass`, `GaugeDial`, `WeatherIndicator`, `Meter`
- Containers: `Box`, `Card`, `Panel`, `Dialog`, `ScrollablePanel`
- Data: `Table`, `Chart`, `Comparison`, `KeyValue`, `CodeBlock`
- Layout: `Columns`, `Grid`, `Tree`
- Feedback: `Toast`, `ToastManager`, `Snackbar`, `AlertBanner`, `ConsolePanel`, `Badge`, `Rating`
- Navigation: `Menu`, `Tabs`, `Accordion`, `Breadcrumbs`, `HorizontalMenu`
- Visual: `GraphCanvas`, `Waveform`, `Spectrogram`, `ImageBlock`, `MiniMap`, `GridMap`
- Decorative: `AsciiArt`, `Banner`, `Divider`, `Tooltip`
- Interactive: `Checkbox`, `Form`, `Radio`, `Slider`, `Toggle`
- Lower-case helper functions mirror class names (e.g., `progress_bar`, `table`).

## Templates (`textforge.templates`)
- Pre-built templates: `Showcase`, `Dashboard`, `Business`
- Base template class: `Template`

## Export (`textforge.export`)
- ANSI render pipeline: `render_to_ansi(obj, *, markup=True, safe_mode=False) -> str`
- Derived exporters: `render_to_html(obj, *, markup=True, safe_mode=False)`, `render_to_svg(obj, *, markup=True, safe_mode=False)`
- Direct converters: `ansi_to_html`, `ansi_to_svg`, `ansi_to_text`, `ansi_to_pdf`
- All exporters sanitize output to prevent injection; `safe_mode=True` disables markup evaluation and renders markup literals.

## Effects (`textforge.effects`)
- Animation: `Animation` class with typewriter effects, fade transitions, and frame-based animations
- Transitions: `Transition` class for color fades and blink effects with easing

## Layout Engine (`textforge.layout`)
- Layout computation: `LayoutNode`, `LayoutResult`, `LayoutStyle`, `compute_layout`, `compute_grid`

## CLI Commands (`textforge.cli`)
- Available subcommands: `demo`, `export`, `list`, `live`, `markup`, `new`, `plugins`, `preview`, `theme`, `typewriter`, `bench`, `dsl`

## Plugins (`textforge.plugins`)
- Plugin registry: `PluginRegistry` with runtime registration and entry point discovery
- Entry point group: `textforge.plugins`

## DSL (`textforge.dsl`)
- Component invocation DSL: Parse and render components from simple string syntax
- Supports quoted args, booleans, arrays, objects, and nested structures

## i18n (`textforge.utils.i18n`)
- Translation system: `Translator`, `get_translator`, `set_locale`, `register_translations`, `t`

## Accessibility API (`textforge.utils.accessibility`)
- Color utilities: `is_contrast_sufficient`, `simulate_color_blind`, `ensure_min_contrast`
- Semantic metadata: `AccessibilityNode` with ARIA attributes and screen reader support

## Testing Utilities (`textforge.utils.testing`)
- Snapshot testing: `snapshot_assert`, `snapshot_path` for regression testing of rendered output

## Markup (`textforge.markup.engine`)
- `MarkupEngine(safe_mode=False)` with escaping, nested tags, and custom tag registry.
- When `safe_mode=True`, square/curly-brace markup sequences are escaped and not interpreted.

## Utilities (`textforge.utils`)
- Text processing: `box_text`, `center_text`, `create_gradient_text`, `create_multi_gradient_text`, `background_gradient_text`, `format_text`, `get_visible_length`, `indent_text`, `justify_text`, `rainbow_text`, `strip_ansi`, `truncate_text`, `wrap_text`, `wrap_text_advanced`
- IO: `read_text`, `write_text`, `read_stdin`, `iter_stdin_lines`, `read_key`
- i18n: `Translator`, `get_translator`, `set_locale`, `register_translations`, `t`
- Accessibility: `AccessibilityAPI`, color contrast utilities, `AccessibilityNode`
- Testing: `snapshot_assert`, `snapshot_path` for regression testing
- Deprecation: `deprecated` decorator (also available as `textforge.deprecated`)

## Internal modules (subject to change)

- `textforge.core.backends` (backend selection and streams)
- `textforge.core.rendering_cli` (low-level live rendering implementation)
- `textforge.export.render_tree` (internal render pipeline utilities)
- `textforge.markup.markdown` (markdown-to-components adapter)

These modules are not part of the stable 1.x public API. Prefer `textforge.api` and the package root re-exports.
