# Textforge

Textforge is a modular terminal text and UI rendering toolkit for Python 3.14. It distills a monolithic prototype into a composable package with components, effects, templates, and a friendly `tfprint` API.

## Quick start

```python
from textforge import tfprint, components as C

tfprint('[cyan]Welcome to Textforge[reset]')
tfprint(C.progress_bar(current=72, maximum=100, label='Loading', color='green'))
```

Install: `pip install textforge`

## Feature matrix

| Area | Status | Notes |
| --- | --- | --- |
| Markup engine | ✅ | Color/effect tags, escaping, custom tags via `MarkupEngine` |
| Components | ✅ | 30+ (typography, containers, data, status, nav, visual, interactive) |
| Layout | ✅ | Columns, grid, measurement hooks; deterministic results |
| Text engine | ✅ | Graphemes, emoji width, bidi; soft hyphen and tabs |
| Themes | ✅ | `ThemeManager` with palette tokens and per-thread overrides |
| Exporters | ✅ | ANSI → HTML, SVG, Text, PDF (basic) |
| Live updates | ✅ | `Console.live()` with diff-based updates |
| Templates | ✅ | `Showcase`, `Dashboard`, `Business`, CLI app presets |
| CLI | ✅ | `list`, `demo`, `preview`, `export`, `typewriter`, `new`, `bench`, `plugins`, `dsl`, `theme` |
| Accessibility | ✅ | `utils/accessibility` integration points |
| Plugins | ✅ | Runtime registry (`PluginRegistry`); entry-point discovery planned |
| Jupyter | ✅ | Basic integration utilities in `utils/jupyter.py` |

## Gallery

Generated from real components. See `docs/GALLERY.md` for details and more formats.

![Showcase (SVG)](docs/gallery/showcase.svg)

Links: [`HTML`](docs/gallery/showcase.html) • [`ANSI`](docs/gallery/showcase.ansi.txt) • [`PDF`](docs/gallery/showcase.pdf)

Generate locally:

```bash
python tools/generate_gallery.py --out docs/gallery
```

## CLI usage

```bash
textforge list
textforge demo --preset game-header
textforge demo --preset inventory
textforge demo --preset loading
textforge demo --preset full
textforge demo --preset dashboard
textforge demo --preset all
textforge theme list
textforge typewriter "Forging text..." --delay 0.03 --color cyan
textforge preview README.md
textforge export -f html < some_ansi.txt > out.html
textforge new myproj
```

See `docs/CLI.md` for the full command reference and examples.

## Documentation

- API: `docs/API_REFERENCE.md`
- Usage guide: `docs/USAGE_GUIDE.md`
- Examples: `docs/EXAMPLES.md`
- Markup language: `docs/MARKUP.md`
- Theming: `docs/THEMING.md`
- Plugin API: `docs/PLUGINS.md`
- CLI guide: `docs/CLI.md`
- Migration notes: `docs/MIGRATION.md`
- Architecture: `docs/ARCHITECTURE.md`

## License

See `pyproject.toml` for license metadata.
