import FINE as fn
import pandas as pd


def getSimultaneosChargeDischarge(esM, compName, threshold=0.0):
    """
    Get operation time series in which simultaneous charging and discharging occurs.

    :param esM: EnergySystemModel instance representing the energy system in which the component should be modeled.
    :type esM: EnergySystemModel class instance
    :param compName: component name
    :type compName: string
    :param threshold: threshold for check of simultaneous operation
    :type threshold: float
    :return: simultaneousOperation: Dictionary with region as keys and pd.DataFrame as value, in which timesteps
        with simultaneous charge and discharge are listed.
    :type simultaneousChargeDischarge: dict
    """
    storageModel = esM.componentModelingDict["StorageModel"]
    tsCharge = storageModel.chargeOperationVariablesOptimum.loc[compName]
    tsDischarge = storageModel.dischargeOperationVariablesOptimum.loc[compName]
    simultaneousOperation = dict()
    for region in tsCharge.index:
        _tsCharge = tsCharge.loc[region]
        _tsDischarge = tsDischarge.loc[region]
        _tsCharge = _tsCharge.rename("Charge")
        _tsDischarge = _tsDischarge.rename("Discharge")
        simultaneousOperation[region] = pd.concat([_tsCharge, _tsDischarge], axis=1)
        simultaneousOperation[region] = \
            simultaneousOperation[region][simultaneousOperation[region] > threshold].dropna()
    # If no simultaneous charge and discharge occurs ts[region][ts[region] > 0] will only return nan values. After
    # dropping them
    return simultaneousOperation