import { ApiObject, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
/**
 * (experimental) MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration
 */
export declare class KubeMutatingWebhookConfiguration extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeMutatingWebhookConfigurationProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeMutatingWebhookConfigurationProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList
 */
export declare class KubeMutatingWebhookConfigurationList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeMutatingWebhookConfigurationListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeMutatingWebhookConfigurationListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration
 */
export declare class KubeValidatingWebhookConfiguration extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeValidatingWebhookConfigurationProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeValidatingWebhookConfigurationProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList
 */
export declare class KubeValidatingWebhookConfigurationList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeValidatingWebhookConfigurationListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeValidatingWebhookConfigurationListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.
 *
 * Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 MutatingWebhookConfiguration instead.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration
 */
export declare class KubeMutatingWebhookConfigurationV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeMutatingWebhookConfigurationV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeMutatingWebhookConfigurationV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList
 */
export declare class KubeMutatingWebhookConfigurationListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeMutatingWebhookConfigurationListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeMutatingWebhookConfigurationListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.
 *
 * Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 ValidatingWebhookConfiguration instead.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration
 */
export declare class KubeValidatingWebhookConfigurationV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeValidatingWebhookConfigurationV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeValidatingWebhookConfigurationV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList
 */
export declare class KubeValidatingWebhookConfigurationListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeValidatingWebhookConfigurationListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeValidatingWebhookConfigurationListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Storage version of a specific resource.
 *
 * @experimental
 * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersion
 */
export declare class KubeStorageVersionV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apiserverinternal.v1alpha1.StorageVersion".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apiserverinternal.v1alpha1.StorageVersion".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeStorageVersionV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.apiserverinternal.v1alpha1.StorageVersion" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeStorageVersionV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) A list of StorageVersions.
 *
 * @experimental
 * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList
 */
export declare class KubeStorageVersionListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeStorageVersionListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeStorageVersionListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ControllerRevision implements an immutable snapshot of state data.
 *
 * Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ControllerRevision
 */
export declare class KubeControllerRevision extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevision".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevision".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeControllerRevisionProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.ControllerRevision" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeControllerRevisionProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ControllerRevisionList
 */
export declare class KubeControllerRevisionList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevisionList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevisionList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeControllerRevisionListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.ControllerRevisionList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeControllerRevisionListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) DaemonSet represents the configuration of a daemon set.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DaemonSet
 */
export declare class KubeDaemonSet extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSet".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSet".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeDaemonSetProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.DaemonSet" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeDaemonSetProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) DaemonSetList is a collection of daemon sets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DaemonSetList
 */
export declare class KubeDaemonSetList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSetList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSetList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeDaemonSetListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.DaemonSetList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeDaemonSetListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Deployment enables declarative updates for Pods and ReplicaSets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.Deployment
 */
export declare class KubeDeployment extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.Deployment".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.Deployment".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeDeploymentProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.Deployment" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeDeploymentProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) DeploymentList is a list of Deployments.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DeploymentList
 */
export declare class KubeDeploymentList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.DeploymentList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DeploymentList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeDeploymentListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.DeploymentList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeDeploymentListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ReplicaSet ensures that a specified number of pod replicas are running at any given time.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ReplicaSet
 */
export declare class KubeReplicaSet extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.ReplicaSet".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ReplicaSet".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeReplicaSetProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.ReplicaSet" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeReplicaSetProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ReplicaSetList is a collection of ReplicaSets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ReplicaSetList
 */
export declare class KubeReplicaSetList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.ReplicaSetList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ReplicaSetList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeReplicaSetListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.ReplicaSetList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeReplicaSetListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) StatefulSet represents a set of pods with consistent identities.
 *
 * Identities are defined as:
 * - Network: A single stable DNS and hostname.
 * - Storage: As many VolumeClaims as requested.
 * The StatefulSet guarantees that a given network identity will always map to the same storage identity.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.StatefulSet
 */
export declare class KubeStatefulSet extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.StatefulSet".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.StatefulSet".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeStatefulSetProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.StatefulSet" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeStatefulSetProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) StatefulSetList is a collection of StatefulSets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.StatefulSetList
 */
export declare class KubeStatefulSetList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.StatefulSetList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.StatefulSetList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeStatefulSetListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.apps.v1.StatefulSetList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeStatefulSetListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) TokenRequest requests a token for a given service account.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1.TokenRequest
 */
export declare class KubeTokenRequest extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authentication.v1.TokenRequest".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authentication.v1.TokenRequest".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeTokenRequestProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.authentication.v1.TokenRequest" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeTokenRequestProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) TokenReview attempts to authenticate a token to a known user.
 *
 * Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1.TokenReview
 */
export declare class KubeTokenReview extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authentication.v1.TokenReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authentication.v1.TokenReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeTokenReviewProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.authentication.v1.TokenReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeTokenReviewProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) TokenReview attempts to authenticate a token to a known user.
 *
 * Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1beta1.TokenReview
 */
export declare class KubeTokenReviewV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authentication.v1beta1.TokenReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authentication.v1beta1.TokenReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeTokenReviewV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.authentication.v1beta1.TokenReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeTokenReviewV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
 *
 * Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.LocalSubjectAccessReview
 */
export declare class KubeLocalSubjectAccessReview extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeLocalSubjectAccessReviewProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1.LocalSubjectAccessReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeLocalSubjectAccessReviewProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) SelfSubjectAccessReview checks whether or the current user can perform an action.
 *
 * Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SelfSubjectAccessReview
 */
export declare class KubeSelfSubjectAccessReview extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1.SelfSubjectAccessReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.SelfSubjectAccessReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeSelfSubjectAccessReviewProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1.SelfSubjectAccessReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeSelfSubjectAccessReviewProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
 *
 * The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SelfSubjectRulesReview
 */
export declare class KubeSelfSubjectRulesReview extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1.SelfSubjectRulesReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.SelfSubjectRulesReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeSelfSubjectRulesReviewProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1.SelfSubjectRulesReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeSelfSubjectRulesReviewProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) SubjectAccessReview checks whether or not a user or group can perform an action.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SubjectAccessReview
 */
export declare class KubeSubjectAccessReview extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1.SubjectAccessReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.SubjectAccessReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeSubjectAccessReviewProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1.SubjectAccessReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeSubjectAccessReviewProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
 *
 * Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview
 */
export declare class KubeLocalSubjectAccessReviewV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeLocalSubjectAccessReviewV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeLocalSubjectAccessReviewV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) SelfSubjectAccessReview checks whether or the current user can perform an action.
 *
 * Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview
 */
export declare class KubeSelfSubjectAccessReviewV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeSelfSubjectAccessReviewV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeSelfSubjectAccessReviewV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
 *
 * The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview
 */
export declare class KubeSelfSubjectRulesReviewV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeSelfSubjectRulesReviewV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeSelfSubjectRulesReviewV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) SubjectAccessReview checks whether or not a user or group can perform an action.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReview
 */
export declare class KubeSubjectAccessReviewV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.SubjectAccessReview".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.SubjectAccessReview".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeSubjectAccessReviewV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.authorization.v1beta1.SubjectAccessReview" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeSubjectAccessReviewV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) configuration of a horizontal pod autoscaler.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler
 */
export declare class KubeHorizontalPodAutoscaler extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeHorizontalPodAutoscalerProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) list of horizontal pod autoscaler objects.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList
 */
export declare class KubeHorizontalPodAutoscalerList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeHorizontalPodAutoscalerListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Scale represents a scaling request for a resource.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.Scale
 */
export declare class KubeScale extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.Scale".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.Scale".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeScaleProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.autoscaling.v1.Scale" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeScaleProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler
 */
export declare class KubeHorizontalPodAutoscalerV2Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeHorizontalPodAutoscalerV2Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerV2Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList
 */
export declare class KubeHorizontalPodAutoscalerListV2Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeHorizontalPodAutoscalerListV2Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListV2Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler
 */
export declare class KubeHorizontalPodAutoscalerV2Beta2 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeHorizontalPodAutoscalerV2Beta2Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerV2Beta2Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList
 */
export declare class KubeHorizontalPodAutoscalerListV2Beta2 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeHorizontalPodAutoscalerListV2Beta2Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListV2Beta2Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CronJob represents the configuration of a single cron job.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.CronJob
 */
export declare class KubeCronJob extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJob".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJob".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeCronJobProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.batch.v1.CronJob" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeCronJobProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CronJobList is a collection of cron jobs.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.CronJobList
 */
export declare class KubeCronJobList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJobList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJobList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCronJobListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.batch.v1.CronJobList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCronJobListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Job represents the configuration of a single job.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.Job
 */
export declare class KubeJob extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1.Job".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1.Job".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeJobProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.batch.v1.Job" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeJobProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) JobList is a collection of jobs.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.JobList
 */
export declare class KubeJobList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1.JobList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1.JobList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeJobListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.batch.v1.JobList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeJobListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CronJob represents the configuration of a single cron job.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1beta1.CronJob
 */
export declare class KubeCronJobV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJob".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJob".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeCronJobV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.batch.v1beta1.CronJob" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeCronJobV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CronJobList is a collection of cron jobs.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1beta1.CronJobList
 */
export declare class KubeCronJobListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJobList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJobList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCronJobListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.batch.v1beta1.CronJobList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCronJobListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.
 *
 * Kubelets use this API to obtain:
 * 1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
 * 2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).
 *
 * This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1.CertificateSigningRequest
 */
export declare class KubeCertificateSigningRequest extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequest".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequest".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCertificateSigningRequestProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.certificates.v1.CertificateSigningRequest" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCertificateSigningRequestProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CertificateSigningRequestList is a collection of CertificateSigningRequest objects.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1.CertificateSigningRequestList
 */
export declare class KubeCertificateSigningRequestList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequestList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequestList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCertificateSigningRequestListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.certificates.v1.CertificateSigningRequestList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCertificateSigningRequestListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Describes a certificate signing request.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequest
 */
export declare class KubeCertificateSigningRequestV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.certificates.v1beta1.CertificateSigningRequest".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.certificates.v1beta1.CertificateSigningRequest".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeCertificateSigningRequestV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.certificates.v1beta1.CertificateSigningRequest" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeCertificateSigningRequestV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * @experimental
 * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestList
 */
export declare class KubeCertificateSigningRequestListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCertificateSigningRequestListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCertificateSigningRequestListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Lease defines a lease concept.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1.Lease
 */
export declare class KubeLease extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1.Lease".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.Lease".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeLeaseProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.coordination.v1.Lease" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeLeaseProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) LeaseList is a list of Lease objects.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1.LeaseList
 */
export declare class KubeLeaseList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1.LeaseList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.LeaseList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeLeaseListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.coordination.v1.LeaseList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeLeaseListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Lease defines a lease concept.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1beta1.Lease
 */
export declare class KubeLeaseV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1beta1.Lease".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1beta1.Lease".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeLeaseV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.coordination.v1beta1.Lease" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeLeaseV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) LeaseList is a list of Lease objects.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1beta1.LeaseList
 */
export declare class KubeLeaseListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1beta1.LeaseList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1beta1.LeaseList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeLeaseListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.coordination.v1beta1.LeaseList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeLeaseListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Binding ties one object to another;
 *
 * for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Binding
 */
export declare class KubeBinding extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Binding".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Binding".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeBindingProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.Binding" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeBindingProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ComponentStatus (and ComponentStatusList) holds the cluster validation info.
 *
 * Deprecated: This API is deprecated in v1.19+
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ComponentStatus
 */
export declare class KubeComponentStatus extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatus".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatus".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeComponentStatusProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ComponentStatus" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeComponentStatusProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Status of all the conditions for the component as a list of ComponentStatus objects.
 *
 * Deprecated: This API is deprecated in v1.19+
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ComponentStatusList
 */
export declare class KubeComponentStatusList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatusList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatusList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeComponentStatusListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ComponentStatusList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeComponentStatusListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ConfigMap holds configuration data for pods to consume.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ConfigMap
 */
export declare class KubeConfigMap extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMap".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMap".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeConfigMapProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ConfigMap" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeConfigMapProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ConfigMapList is a resource containing a list of ConfigMap objects.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ConfigMapList
 */
export declare class KubeConfigMapList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMapList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMapList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeConfigMapListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ConfigMapList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeConfigMapListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Endpoints is a collection of endpoints that implement the actual service.
 *
 * Example:
 * Name: "mysvc",
 * Subsets: [
 *   {
 *     Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
 *     Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
 *   },
 *   {
 *     Addresses: [{"ip": "10.10.3.3"}],
 *     Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
 *   },
 * ]
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Endpoints
 */
export declare class KubeEndpoints extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Endpoints".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Endpoints".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeEndpointsProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.Endpoints" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeEndpointsProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) EndpointsList is a list of endpoints.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EndpointsList
 */
export declare class KubeEndpointsList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.EndpointsList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.EndpointsList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEndpointsListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.EndpointsList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEndpointsListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) A list of ephemeral containers used with the Pod ephemeralcontainers subresource.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EphemeralContainers
 */
export declare class KubeEphemeralContainers extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.EphemeralContainers".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.EphemeralContainers".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEphemeralContainersProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.EphemeralContainers" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEphemeralContainersProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Event is a report of an event somewhere in the cluster.
 *
 * It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
 *
 * @experimental
 * @schema io.k8s.api.events.v1.Event
 */
export declare class KubeEvent extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.events.v1.Event".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.events.v1.Event".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEventProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.events.v1.Event" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEventProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) EventList is a list of Event objects.
 *
 * @experimental
 * @schema io.k8s.api.events.v1.EventList
 */
export declare class KubeEventList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.events.v1.EventList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.events.v1.EventList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEventListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.events.v1.EventList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEventListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) LimitRange sets resource usage limits for each kind of resource in a Namespace.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LimitRange
 */
export declare class KubeLimitRange extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRange".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRange".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeLimitRangeProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.LimitRange" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeLimitRangeProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) LimitRangeList is a list of LimitRange items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LimitRangeList
 */
export declare class KubeLimitRangeList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRangeList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRangeList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeLimitRangeListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.LimitRangeList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeLimitRangeListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Namespace provides a scope for Names.
 *
 * Use of multiple namespaces is optional.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Namespace
 */
export declare class KubeNamespace extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Namespace".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Namespace".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeNamespaceProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.Namespace" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeNamespaceProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) NamespaceList is a list of Namespaces.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NamespaceList
 */
export declare class KubeNamespaceList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.NamespaceList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.NamespaceList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeNamespaceListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.NamespaceList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeNamespaceListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Node is a worker node in Kubernetes.
 *
 * Each node will have a unique identifier in the cache (i.e. in etcd).
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Node
 */
export declare class KubeNode extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Node".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Node".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeNodeProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.Node" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeNodeProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) NodeList is the whole list of all Nodes which have been registered with master.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NodeList
 */
export declare class KubeNodeList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.NodeList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.NodeList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeNodeListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.NodeList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeNodeListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PersistentVolume (PV) is a storage resource provisioned by an administrator.
 *
 * It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolume
 */
export declare class KubePersistentVolume extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolume".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolume".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePersistentVolumeProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.PersistentVolume" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePersistentVolumeProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PersistentVolumeClaim is a user's request for and claim to a persistent volume.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeClaim
 */
export declare class KubePersistentVolumeClaim extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaim".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaim".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePersistentVolumeClaimProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.PersistentVolumeClaim" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePersistentVolumeClaimProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeClaimList
 */
export declare class KubePersistentVolumeClaimList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaimList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaimList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePersistentVolumeClaimListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.PersistentVolumeClaimList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePersistentVolumeClaimListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PersistentVolumeList is a list of PersistentVolume items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeList
 */
export declare class KubePersistentVolumeList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePersistentVolumeListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.PersistentVolumeList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePersistentVolumeListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Pod is a collection of containers that can run on a host.
 *
 * This resource is created by clients and scheduled onto hosts.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Pod
 */
export declare class KubePod extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Pod".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Pod".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePodProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.Pod" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePodProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodList is a list of Pods.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodList
 */
export declare class KubePodList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PodList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePodListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.PodList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePodListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodTemplate describes a template for creating copies of a predefined pod.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodTemplate
 */
export declare class KubePodTemplate extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplate".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplate".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePodTemplateProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.PodTemplate" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePodTemplateProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodTemplateList is a list of PodTemplates.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodTemplateList
 */
export declare class KubePodTemplateList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplateList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplateList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePodTemplateListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.PodTemplateList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePodTemplateListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ReplicationController represents the configuration of a replication controller.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ReplicationController
 */
export declare class KubeReplicationController extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ReplicationController".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ReplicationController".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeReplicationControllerProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ReplicationController" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeReplicationControllerProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ReplicationControllerList is a collection of replication controllers.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ReplicationControllerList
 */
export declare class KubeReplicationControllerList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ReplicationControllerList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ReplicationControllerList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeReplicationControllerListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ReplicationControllerList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeReplicationControllerListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ResourceQuota sets aggregate quota restrictions enforced per namespace.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ResourceQuota
 */
export declare class KubeResourceQuota extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ResourceQuota".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ResourceQuota".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeResourceQuotaProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ResourceQuota" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeResourceQuotaProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ResourceQuotaList is a list of ResourceQuota items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ResourceQuotaList
 */
export declare class KubeResourceQuotaList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ResourceQuotaList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ResourceQuotaList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeResourceQuotaListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ResourceQuotaList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeResourceQuotaListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Secret holds secret data of a certain type.
 *
 * The total bytes of the values in the Data field must be less than MaxSecretSize bytes.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Secret
 */
export declare class KubeSecret extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Secret".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Secret".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeSecretProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.Secret" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeSecretProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) SecretList is a list of Secret.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.SecretList
 */
export declare class KubeSecretList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.SecretList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.SecretList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeSecretListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.SecretList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeSecretListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Service
 */
export declare class KubeService extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Service".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Service".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeServiceProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.Service" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeServiceProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServiceAccount
 */
export declare class KubeServiceAccount extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ServiceAccount".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ServiceAccount".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeServiceAccountProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ServiceAccount" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeServiceAccountProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ServiceAccountList is a list of ServiceAccount objects.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServiceAccountList
 */
export declare class KubeServiceAccountList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ServiceAccountList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ServiceAccountList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeServiceAccountListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ServiceAccountList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeServiceAccountListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ServiceList holds a list of services.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServiceList
 */
export declare class KubeServiceList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ServiceList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ServiceList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeServiceListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.core.v1.ServiceList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeServiceListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) EndpointSlice represents a subset of the endpoints that implement a service.
 *
 * For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1.EndpointSlice
 */
export declare class KubeEndpointSlice extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSlice".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSlice".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEndpointSliceProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.discovery.v1.EndpointSlice" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEndpointSliceProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) EndpointSliceList represents a list of endpoint slices.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1.EndpointSliceList
 */
export declare class KubeEndpointSliceList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSliceList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSliceList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEndpointSliceListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.discovery.v1.EndpointSliceList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEndpointSliceListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) EndpointSlice represents a subset of the endpoints that implement a service.
 *
 * For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.EndpointSlice
 */
export declare class KubeEndpointSliceV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSlice".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSlice".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEndpointSliceV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.discovery.v1beta1.EndpointSlice" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEndpointSliceV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) EndpointSliceList represents a list of endpoint slices.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.EndpointSliceList
 */
export declare class KubeEndpointSliceListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSliceList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSliceList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEndpointSliceListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.discovery.v1beta1.EndpointSliceList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEndpointSliceListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Event is a report of an event somewhere in the cluster.
 *
 * It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
 *
 * @experimental
 * @schema io.k8s.api.events.v1beta1.Event
 */
export declare class KubeEventV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.Event".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.Event".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEventV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.events.v1beta1.Event" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEventV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) EventList is a list of Event objects.
 *
 * @experimental
 * @schema io.k8s.api.events.v1beta1.EventList
 */
export declare class KubeEventListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.EventList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.EventList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeEventListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.events.v1beta1.EventList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeEventListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.
 *
 * An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.Ingress
 */
export declare class KubeIngressV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.Ingress".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.Ingress".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeIngressV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1beta1.Ingress" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeIngressV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) IngressList is a collection of Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressList
 */
export declare class KubeIngressListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.IngressList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.IngressList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeIngressListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1beta1.IngressList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeIngressListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) FlowSchema defines the schema of a group of flows.
 *
 * Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchema
 */
export declare class KubeFlowSchemaV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.FlowSchema".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.FlowSchema".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeFlowSchemaV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.flowcontrol.v1beta1.FlowSchema" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeFlowSchemaV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) FlowSchemaList is a list of FlowSchema objects.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaList
 */
export declare class KubeFlowSchemaListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.FlowSchemaList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.FlowSchemaList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeFlowSchemaListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.flowcontrol.v1beta1.FlowSchemaList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeFlowSchemaListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PriorityLevelConfiguration represents the configuration of a priority level.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration
 */
export declare class KubePriorityLevelConfigurationV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePriorityLevelConfigurationV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePriorityLevelConfigurationV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PriorityLevelConfigurationList is a list of PriorityLevelConfiguration objects.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList
 */
export declare class KubePriorityLevelConfigurationListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePriorityLevelConfigurationListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePriorityLevelConfigurationListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.
 *
 * An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.Ingress
 */
export declare class KubeIngress extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.Ingress".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.Ingress".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeIngressProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1.Ingress" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeIngressProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) IngressClass represents the class of the Ingress, referenced by the Ingress Spec.
 *
 * The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressClass
 */
export declare class KubeIngressClass extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeIngressClassProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1.IngressClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeIngressClassProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) IngressClassList is a collection of IngressClasses.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressClassList
 */
export declare class KubeIngressClassList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeIngressClassListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1.IngressClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeIngressClassListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) IngressList is a collection of Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressList
 */
export declare class KubeIngressList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeIngressListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1.IngressList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeIngressListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) NetworkPolicy describes what network traffic is allowed for a set of Pods.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.NetworkPolicy
 */
export declare class KubeNetworkPolicy extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicy".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicy".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeNetworkPolicyProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1.NetworkPolicy" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeNetworkPolicyProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) NetworkPolicyList is a list of NetworkPolicy objects.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.NetworkPolicyList
 */
export declare class KubeNetworkPolicyList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicyList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicyList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeNetworkPolicyListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1.NetworkPolicyList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeNetworkPolicyListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) IngressClass represents the class of the Ingress, referenced by the Ingress Spec.
 *
 * The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressClass
 */
export declare class KubeIngressClassV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.IngressClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.IngressClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeIngressClassV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1beta1.IngressClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeIngressClassV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) IngressClassList is a collection of IngressClasses.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressClassList
 */
export declare class KubeIngressClassListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.IngressClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.IngressClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeIngressClassListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.networking.v1beta1.IngressClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeIngressClassListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RuntimeClass defines a class of container runtime supported in the cluster.
 *
 * The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://kubernetes.io/docs/concepts/containers/runtime-class/
 *
 * @experimental
 * @schema io.k8s.api.node.v1.RuntimeClass
 */
export declare class KubeRuntimeClass extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.node.v1.RuntimeClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.node.v1.RuntimeClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRuntimeClassProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.node.v1.RuntimeClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRuntimeClassProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RuntimeClassList is a list of RuntimeClass objects.
 *
 * @experimental
 * @schema io.k8s.api.node.v1.RuntimeClassList
 */
export declare class KubeRuntimeClassList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.node.v1.RuntimeClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.node.v1.RuntimeClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRuntimeClassListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.node.v1.RuntimeClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRuntimeClassListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RuntimeClass defines a class of container runtime supported in the cluster.
 *
 * The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md
 *
 * @experimental
 * @schema io.k8s.api.node.v1alpha1.RuntimeClass
 */
export declare class KubeRuntimeClassV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.node.v1alpha1.RuntimeClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.node.v1alpha1.RuntimeClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRuntimeClassV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.node.v1alpha1.RuntimeClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRuntimeClassV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RuntimeClassList is a list of RuntimeClass objects.
 *
 * @experimental
 * @schema io.k8s.api.node.v1alpha1.RuntimeClassList
 */
export declare class KubeRuntimeClassListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.node.v1alpha1.RuntimeClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.node.v1alpha1.RuntimeClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRuntimeClassListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.node.v1alpha1.RuntimeClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRuntimeClassListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RuntimeClass defines a class of container runtime supported in the cluster.
 *
 * The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md
 *
 * @experimental
 * @schema io.k8s.api.node.v1beta1.RuntimeClass
 */
export declare class KubeRuntimeClassV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.node.v1beta1.RuntimeClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.node.v1beta1.RuntimeClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRuntimeClassV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.node.v1beta1.RuntimeClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRuntimeClassV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RuntimeClassList is a list of RuntimeClass objects.
 *
 * @experimental
 * @schema io.k8s.api.node.v1beta1.RuntimeClassList
 */
export declare class KubeRuntimeClassListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.node.v1beta1.RuntimeClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.node.v1beta1.RuntimeClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRuntimeClassListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.node.v1beta1.RuntimeClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRuntimeClassListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1.PodDisruptionBudget
 */
export declare class KubePodDisruptionBudget extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1.PodDisruptionBudget".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1.PodDisruptionBudget".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePodDisruptionBudgetProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.policy.v1.PodDisruptionBudget" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePodDisruptionBudgetProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1.PodDisruptionBudgetList
 */
export declare class KubePodDisruptionBudgetList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1.PodDisruptionBudgetList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1.PodDisruptionBudgetList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePodDisruptionBudgetListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.policy.v1.PodDisruptionBudgetList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePodDisruptionBudgetListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Eviction evicts a pod from its node subject to certain policies and safety constraints.
 *
 * This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.Eviction
 */
export declare class KubeEvictionV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.Eviction".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.Eviction".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeEvictionV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.policy.v1beta1.Eviction" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeEvictionV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudget
 */
export declare class KubePodDisruptionBudgetV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePodDisruptionBudgetV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.policy.v1beta1.PodDisruptionBudget" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePodDisruptionBudgetV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetList
 */
export declare class KubePodDisruptionBudgetListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePodDisruptionBudgetListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePodDisruptionBudgetListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.
 *
 * Deprecated in 1.21.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicy
 */
export declare class KubePodSecurityPolicyV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubePodSecurityPolicyV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.policy.v1beta1.PodSecurityPolicy" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubePodSecurityPolicyV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PodSecurityPolicyList is a list of PodSecurityPolicy objects.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicyList
 */
export declare class KubePodSecurityPolicyListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePodSecurityPolicyListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.policy.v1beta1.PodSecurityPolicyList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePodSecurityPolicyListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRole
 */
export declare class KubeClusterRole extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRole".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRole".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeClusterRoleProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.ClusterRole" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeClusterRoleProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleBinding references a ClusterRole, but not contain it.
 *
 * It can reference a ClusterRole in the global namespace, and adds who information via Subject.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRoleBinding
 */
export declare class KubeClusterRoleBinding extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBinding".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBinding".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleBindingProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.ClusterRoleBinding" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleBindingProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRoleBindingList
 */
export declare class KubeClusterRoleBindingList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBindingList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBindingList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleBindingListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.ClusterRoleBindingList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleBindingListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleList is a collection of ClusterRoles.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRoleList
 */
export declare class KubeClusterRoleList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.ClusterRoleList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.Role
 */
export declare class KubeRole extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.Role".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.Role".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeRoleProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.Role" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeRoleProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleBinding references a role, but does not contain it.
 *
 * It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.RoleBinding
 */
export declare class KubeRoleBinding extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.RoleBinding".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.RoleBinding".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleBindingProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.RoleBinding" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleBindingProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleBindingList is a collection of RoleBindings.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.RoleBindingList
 */
export declare class KubeRoleBindingList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.RoleBindingList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.RoleBindingList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleBindingListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.RoleBindingList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleBindingListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleList is a collection of Roles.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.RoleList
 */
export declare class KubeRoleList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.RoleList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.RoleList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1.RoleList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRole, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRole
 */
export declare class KubeClusterRoleV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRole".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRole".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeClusterRoleV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRole" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeClusterRoleV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleBinding references a ClusterRole, but not contain it.
 *
 * It can reference a ClusterRole in the global namespace, and adds who information via Subject. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBinding
 */
export declare class KubeClusterRoleBindingV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleBindingV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleBindingV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBindings, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList
 */
export declare class KubeClusterRoleBindingListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleBindingListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleBindingListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleList is a collection of ClusterRoles.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoles, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleList
 */
export declare class KubeClusterRoleListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 Role, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.Role
 */
export declare class KubeRoleV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.Role".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.Role".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeRoleV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.Role" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeRoleV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleBinding references a role, but does not contain it.
 *
 * It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.RoleBinding
 */
export declare class KubeRoleBindingV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.RoleBinding".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.RoleBinding".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleBindingV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.RoleBinding" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleBindingV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleBindingList is a collection of RoleBindings Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBindingList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.RoleBindingList
 */
export declare class KubeRoleBindingListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.RoleBindingList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.RoleBindingList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleBindingListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.RoleBindingList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleBindingListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleList is a collection of Roles.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.RoleList
 */
export declare class KubeRoleListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.RoleList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.RoleList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1alpha1.RoleList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRole, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRole
 */
export declare class KubeClusterRoleV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRole".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRole".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeClusterRoleV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRole" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeClusterRoleV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleBinding references a ClusterRole, but not contain it.
 *
 * It can reference a ClusterRole in the global namespace, and adds who information via Subject. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBinding
 */
export declare class KubeClusterRoleBindingV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleBinding".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleBinding".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleBindingV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleBinding" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleBindingV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBindingList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBindingList
 */
export declare class KubeClusterRoleBindingListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleBindingListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleBindingListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) ClusterRoleList is a collection of ClusterRoles.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoles, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRoleList
 */
export declare class KubeClusterRoleListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeClusterRoleListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeClusterRoleListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 Role, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.Role
 */
export declare class KubeRoleV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.Role".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.Role".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeRoleV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.Role" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeRoleV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleBinding references a role, but does not contain it.
 *
 * It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.RoleBinding
 */
export declare class KubeRoleBindingV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.RoleBinding".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.RoleBinding".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleBindingV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.RoleBinding" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleBindingV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleBindingList is a collection of RoleBindings Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBindingList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.RoleBindingList
 */
export declare class KubeRoleBindingListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.RoleBindingList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.RoleBindingList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleBindingListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.RoleBindingList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleBindingListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) RoleList is a collection of Roles Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.RoleList
 */
export declare class KubeRoleListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.RoleList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.RoleList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeRoleListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.rbac.v1beta1.RoleList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeRoleListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PriorityClass defines mapping from a priority class name to the priority integer value.
 *
 * The value can be any valid integer.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1.PriorityClass
 */
export declare class KubePriorityClass extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePriorityClassProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.scheduling.v1.PriorityClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePriorityClassProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PriorityClassList is a collection of priority classes.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1.PriorityClassList
 */
export declare class KubePriorityClassList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePriorityClassListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.scheduling.v1.PriorityClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePriorityClassListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1alpha1.PriorityClass
 */
export declare class KubePriorityClassV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.scheduling.v1alpha1.PriorityClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePriorityClassV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.scheduling.v1alpha1.PriorityClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePriorityClassV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PriorityClassList is a collection of priority classes.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1alpha1.PriorityClassList
 */
export declare class KubePriorityClassListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.scheduling.v1alpha1.PriorityClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePriorityClassListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.scheduling.v1alpha1.PriorityClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePriorityClassListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1beta1.PriorityClass
 */
export declare class KubePriorityClassV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.scheduling.v1beta1.PriorityClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1beta1.PriorityClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePriorityClassV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.scheduling.v1beta1.PriorityClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePriorityClassV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) PriorityClassList is a collection of priority classes.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1beta1.PriorityClassList
 */
export declare class KubePriorityClassListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.scheduling.v1beta1.PriorityClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1beta1.PriorityClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubePriorityClassListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.scheduling.v1beta1.PriorityClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubePriorityClassListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.
 *
 * Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSIDriver
 */
export declare class KubeCsiDriver extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriver".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriver".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiDriverProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.CSIDriver" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiDriverProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIDriverList is a collection of CSIDriver objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSIDriverList
 */
export declare class KubeCsiDriverList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriverList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriverList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiDriverListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.CSIDriverList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiDriverListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSINode holds information about all CSI drivers installed on a node.
 *
 * CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSINode
 */
export declare class KubeCsiNode extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINode".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINode".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiNodeProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.CSINode" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiNodeProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSINodeList is a collection of CSINode objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSINodeList
 */
export declare class KubeCsiNodeList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINodeList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINodeList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiNodeListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.CSINodeList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiNodeListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
 *
 * StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.StorageClass
 */
export declare class KubeStorageClass extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.StorageClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.StorageClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeStorageClassProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.StorageClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeStorageClassProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) StorageClassList is a collection of storage classes.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.StorageClassList
 */
export declare class KubeStorageClassList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.StorageClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.StorageClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeStorageClassListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.StorageClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeStorageClassListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
 *
 * VolumeAttachment objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.VolumeAttachment
 */
export declare class KubeVolumeAttachment extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.VolumeAttachment".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.VolumeAttachment".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeVolumeAttachmentProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.VolumeAttachment" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeVolumeAttachmentProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) VolumeAttachmentList is a collection of VolumeAttachment objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.VolumeAttachmentList
 */
export declare class KubeVolumeAttachmentList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1.VolumeAttachmentList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1.VolumeAttachmentList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeVolumeAttachmentListProps): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1.VolumeAttachmentList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeVolumeAttachmentListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIStorageCapacity stores the result of one CSI GetCapacity call.
 *
 * For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.
 *
 * For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"
 *
 * The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero
 *
 * The producer of these objects can decide which approach is more suitable.
 *
 * They are consumed by the kube-scheduler if the CSIStorageCapacity beta feature gate is enabled there and a CSI driver opts into capacity-aware scheduling with CSIDriver.StorageCapacity.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacity
 */
export declare class KubeCsiStorageCapacityV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.CSIStorageCapacity".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.CSIStorageCapacity".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiStorageCapacityV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1alpha1.CSIStorageCapacity" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiStorageCapacityV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIStorageCapacityList is a collection of CSIStorageCapacity objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacityList
 */
export declare class KubeCsiStorageCapacityListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.CSIStorageCapacityList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.CSIStorageCapacityList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiStorageCapacityListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1alpha1.CSIStorageCapacityList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiStorageCapacityListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
 *
 * VolumeAttachment objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.VolumeAttachment
 */
export declare class KubeVolumeAttachmentV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.VolumeAttachment".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.VolumeAttachment".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeVolumeAttachmentV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1alpha1.VolumeAttachment" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeVolumeAttachmentV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) VolumeAttachmentList is a collection of VolumeAttachment objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentList
 */
export declare class KubeVolumeAttachmentListV1Alpha1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.VolumeAttachmentList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.VolumeAttachmentList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeVolumeAttachmentListV1Alpha1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1alpha1.VolumeAttachmentList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeVolumeAttachmentListV1Alpha1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.
 *
 * CSI drivers do not need to create the CSIDriver object directly. Instead they may use the cluster-driver-registrar sidecar container. When deployed with a CSI driver it automatically creates a CSIDriver object representing the driver. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIDriver
 */
export declare class KubeCsiDriverV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIDriver".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIDriver".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiDriverV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.CSIDriver" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiDriverV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIDriverList is a collection of CSIDriver objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIDriverList
 */
export declare class KubeCsiDriverListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIDriverList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIDriverList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiDriverListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.CSIDriverList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiDriverListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) DEPRECATED - This group version of CSINode is deprecated by storage/v1/CSINode.
 *
 * See the release notes for more information. CSINode holds information about all CSI drivers installed on a node. CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSINode
 */
export declare class KubeCsiNodeV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSINode".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSINode".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiNodeV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.CSINode" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiNodeV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSINodeList is a collection of CSINode objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSINodeList
 */
export declare class KubeCsiNodeListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSINodeList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSINodeList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiNodeListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.CSINodeList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiNodeListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIStorageCapacity stores the result of one CSI GetCapacity call.
 *
 * For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.
 *
 * For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"
 *
 * The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero
 *
 * The producer of these objects can decide which approach is more suitable.
 *
 * They are consumed by the kube-scheduler if the CSIStorageCapacity beta feature gate is enabled there and a CSI driver opts into capacity-aware scheduling with CSIDriver.StorageCapacity.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacity
 */
export declare class KubeCsiStorageCapacityV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacity".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacity".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiStorageCapacityV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.CSIStorageCapacity" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiStorageCapacityV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CSIStorageCapacityList is a collection of CSIStorageCapacity objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacityList
 */
export declare class KubeCsiStorageCapacityListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCsiStorageCapacityListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.CSIStorageCapacityList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCsiStorageCapacityListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
 *
 * StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.StorageClass
 */
export declare class KubeStorageClassV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.StorageClass".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.StorageClass".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeStorageClassV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.StorageClass" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeStorageClassV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) StorageClassList is a collection of storage classes.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.StorageClassList
 */
export declare class KubeStorageClassListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.StorageClassList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.StorageClassList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeStorageClassListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.StorageClassList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeStorageClassListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
 *
 * VolumeAttachment objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.VolumeAttachment
 */
export declare class KubeVolumeAttachmentV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.VolumeAttachment".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.VolumeAttachment".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeVolumeAttachmentV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.VolumeAttachment" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeVolumeAttachmentV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) VolumeAttachmentList is a collection of VolumeAttachment objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentList
 */
export declare class KubeVolumeAttachmentListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.VolumeAttachmentList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.VolumeAttachmentList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeVolumeAttachmentListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.api.storage.v1beta1.VolumeAttachmentList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeVolumeAttachmentListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CustomResourceDefinition represents a resource that should be exposed on the API server.
 *
 * Its name MUST be in the format <.spec.name>.<.spec.group>.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition
 */
export declare class KubeCustomResourceDefinition extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCustomResourceDefinitionProps): any;
    /**
     * (experimental) Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCustomResourceDefinitionProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList
 */
export declare class KubeCustomResourceDefinitionList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCustomResourceDefinitionListProps): any;
    /**
     * (experimental) Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCustomResourceDefinitionListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CustomResourceDefinition represents a resource that should be exposed on the API server.
 *
 * Its name MUST be in the format <.spec.name>.<.spec.group>. Deprecated in v1.16, planned for removal in v1.22. Use apiextensions.k8s.io/v1 CustomResourceDefinition instead.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition
 */
export declare class KubeCustomResourceDefinitionV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCustomResourceDefinitionV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCustomResourceDefinitionV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList
 */
export declare class KubeCustomResourceDefinitionListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeCustomResourceDefinitionListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeCustomResourceDefinitionListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) Status is a return value for calls that don't return other objects.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Status
 */
export declare class KubeStatus extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.apimachinery.pkg.apis.meta.v1.Status".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.apimachinery.pkg.apis.meta.v1.Status".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeStatusProps): any;
    /**
     * (experimental) Defines a "io.k8s.apimachinery.pkg.apis.meta.v1.Status" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeStatusProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) APIService represents a server for a particular GroupVersion.
 *
 * Name must be "version.group".
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
 */
export declare class KubeApiService extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeApiServiceProps): any;
    /**
     * (experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeApiServiceProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) APIServiceList is a list of APIService objects.
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
 */
export declare class KubeApiServiceList extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeApiServiceListProps): any;
    /**
     * (experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeApiServiceListProps);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) APIService represents a server for a particular GroupVersion.
 *
 * Name must be "version.group".
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService
 */
export declare class KubeApiServiceV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props?: KubeApiServiceV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubeApiServiceV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) APIServiceList is a list of APIService objects.
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList
 */
export declare class KubeApiServiceListV1Beta1 extends ApiObject {
    /**
     * (experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList".
     *
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: KubeApiServiceListV1Beta1Props): any;
    /**
     * (experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubeApiServiceListV1Beta1Props);
    /**
     * (experimental) Renders the object to Kubernetes JSON.
     *
     * @experimental
     */
    toJson(): any;
}
/**
 * (experimental) MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration
 */
export interface KubeMutatingWebhookConfigurationProps {
    /**
     * (experimental) Standard object metadata;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Webhooks is a list of webhooks and the affected resources and operations.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration#webhooks
     */
    readonly webhooks?: MutatingWebhook[];
}
/**
 * Converts an object of type 'KubeMutatingWebhookConfigurationProps' to JSON representation.
 */
export declare function toJson_KubeMutatingWebhookConfigurationProps(obj: KubeMutatingWebhookConfigurationProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList
 */
export interface KubeMutatingWebhookConfigurationListProps {
    /**
     * (experimental) List of MutatingWebhookConfiguration.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList#items
     */
    readonly items: KubeMutatingWebhookConfigurationProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeMutatingWebhookConfigurationListProps' to JSON representation.
 */
export declare function toJson_KubeMutatingWebhookConfigurationListProps(obj: KubeMutatingWebhookConfigurationListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration
 */
export interface KubeValidatingWebhookConfigurationProps {
    /**
     * (experimental) Standard object metadata;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Webhooks is a list of webhooks and the affected resources and operations.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration#webhooks
     */
    readonly webhooks?: ValidatingWebhook[];
}
/**
 * Converts an object of type 'KubeValidatingWebhookConfigurationProps' to JSON representation.
 */
export declare function toJson_KubeValidatingWebhookConfigurationProps(obj: KubeValidatingWebhookConfigurationProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList
 */
export interface KubeValidatingWebhookConfigurationListProps {
    /**
     * (experimental) List of ValidatingWebhookConfiguration.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList#items
     */
    readonly items: KubeValidatingWebhookConfigurationProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeValidatingWebhookConfigurationListProps' to JSON representation.
 */
export declare function toJson_KubeValidatingWebhookConfigurationListProps(obj: KubeValidatingWebhookConfigurationListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.
 *
 * Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 MutatingWebhookConfiguration instead.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration
 */
export interface KubeMutatingWebhookConfigurationV1Beta1Props {
    /**
     * (experimental) Standard object metadata;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Webhooks is a list of webhooks and the affected resources and operations.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration#webhooks
     */
    readonly webhooks?: MutatingWebhookV1Beta1[];
}
/**
 * Converts an object of type 'KubeMutatingWebhookConfigurationV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeMutatingWebhookConfigurationV1Beta1Props(obj: KubeMutatingWebhookConfigurationV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList
 */
export interface KubeMutatingWebhookConfigurationListV1Beta1Props {
    /**
     * (experimental) List of MutatingWebhookConfiguration.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList#items
     */
    readonly items: KubeMutatingWebhookConfigurationV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeMutatingWebhookConfigurationListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeMutatingWebhookConfigurationListV1Beta1Props(obj: KubeMutatingWebhookConfigurationListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.
 *
 * Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 ValidatingWebhookConfiguration instead.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration
 */
export interface KubeValidatingWebhookConfigurationV1Beta1Props {
    /**
     * (experimental) Standard object metadata;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Webhooks is a list of webhooks and the affected resources and operations.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfiguration#webhooks
     */
    readonly webhooks?: ValidatingWebhookV1Beta1[];
}
/**
 * Converts an object of type 'KubeValidatingWebhookConfigurationV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeValidatingWebhookConfigurationV1Beta1Props(obj: KubeValidatingWebhookConfigurationV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList
 */
export interface KubeValidatingWebhookConfigurationListV1Beta1Props {
    /**
     * (experimental) List of ValidatingWebhookConfiguration.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList#items
     */
    readonly items: KubeValidatingWebhookConfigurationV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhookConfigurationList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeValidatingWebhookConfigurationListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeValidatingWebhookConfigurationListV1Beta1Props(obj: KubeValidatingWebhookConfigurationListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Storage version of a specific resource.
 *
 * @experimental
 * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersion
 */
export interface KubeStorageVersionV1Alpha1Props {
    /**
     * (experimental) The name is <group>.<resource>.
     *
     * @experimental
     * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersion#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec is an empty spec.
     *
     * It is here to comply with Kubernetes API style.
     *
     * @experimental
     * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersion#spec
     */
    readonly spec: any;
}
/**
 * Converts an object of type 'KubeStorageVersionV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeStorageVersionV1Alpha1Props(obj: KubeStorageVersionV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) A list of StorageVersions.
 *
 * @experimental
 * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList
 */
export interface KubeStorageVersionListV1Alpha1Props {
    /**
     * @experimental
     * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList#items
     */
    readonly items: KubeStorageVersionV1Alpha1Props[];
    /**
     * @experimental
     * @schema io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeStorageVersionListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeStorageVersionListV1Alpha1Props(obj: KubeStorageVersionListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ControllerRevision implements an immutable snapshot of state data.
 *
 * Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ControllerRevision
 */
export interface KubeControllerRevisionProps {
    /**
     * (experimental) Data is the serialized representation of the state.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ControllerRevision#data
     */
    readonly data?: any;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ControllerRevision#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Revision indicates the revision of the state represented by Data.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ControllerRevision#revision
     */
    readonly revision: number;
}
/**
 * Converts an object of type 'KubeControllerRevisionProps' to JSON representation.
 */
export declare function toJson_KubeControllerRevisionProps(obj: KubeControllerRevisionProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ControllerRevisionList
 */
export interface KubeControllerRevisionListProps {
    /**
     * (experimental) Items is the list of ControllerRevisions.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ControllerRevisionList#items
     */
    readonly items: KubeControllerRevisionProps[];
    /**
     * (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ControllerRevisionList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeControllerRevisionListProps' to JSON representation.
 */
export declare function toJson_KubeControllerRevisionListProps(obj: KubeControllerRevisionListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) DaemonSet represents the configuration of a daemon set.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DaemonSet
 */
export interface KubeDaemonSetProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSet#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) The desired behavior of this daemon set.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSet#spec
     */
    readonly spec?: DaemonSetSpec;
}
/**
 * Converts an object of type 'KubeDaemonSetProps' to JSON representation.
 */
export declare function toJson_KubeDaemonSetProps(obj: KubeDaemonSetProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) DaemonSetList is a collection of daemon sets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DaemonSetList
 */
export interface KubeDaemonSetListProps {
    /**
     * (experimental) A list of daemon sets.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetList#items
     */
    readonly items: KubeDaemonSetProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeDaemonSetListProps' to JSON representation.
 */
export declare function toJson_KubeDaemonSetListProps(obj: KubeDaemonSetListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Deployment enables declarative updates for Pods and ReplicaSets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.Deployment
 */
export interface KubeDeploymentProps {
    /**
     * (experimental) Standard object metadata.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.Deployment#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of the Deployment.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.Deployment#spec
     */
    readonly spec?: DeploymentSpec;
}
/**
 * Converts an object of type 'KubeDeploymentProps' to JSON representation.
 */
export declare function toJson_KubeDeploymentProps(obj: KubeDeploymentProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) DeploymentList is a list of Deployments.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DeploymentList
 */
export interface KubeDeploymentListProps {
    /**
     * (experimental) Items is the list of Deployments.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentList#items
     */
    readonly items: KubeDeploymentProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeDeploymentListProps' to JSON representation.
 */
export declare function toJson_KubeDeploymentListProps(obj: KubeDeploymentListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ReplicaSet ensures that a specified number of pod replicas are running at any given time.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ReplicaSet
 */
export interface KubeReplicaSetProps {
    /**
     * (experimental) If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages.
     *
     * Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSet#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the specification of the desired behavior of the ReplicaSet.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSet#spec
     */
    readonly spec?: ReplicaSetSpec;
}
/**
 * Converts an object of type 'KubeReplicaSetProps' to JSON representation.
 */
export declare function toJson_KubeReplicaSetProps(obj: KubeReplicaSetProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ReplicaSetList is a collection of ReplicaSets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ReplicaSetList
 */
export interface KubeReplicaSetListProps {
    /**
     * (experimental) List of ReplicaSets.
     *
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSetList#items
     */
    readonly items: KubeReplicaSetProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSetList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeReplicaSetListProps' to JSON representation.
 */
export declare function toJson_KubeReplicaSetListProps(obj: KubeReplicaSetListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) StatefulSet represents a set of pods with consistent identities.
 *
 * Identities are defined as:
 * - Network: A single stable DNS and hostname.
 * - Storage: As many VolumeClaims as requested.
 * The StatefulSet guarantees that a given network identity will always map to the same storage identity.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.StatefulSet
 */
export interface KubeStatefulSetProps {
    /**
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSet#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the desired identities of pods in this set.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSet#spec
     */
    readonly spec?: StatefulSetSpec;
}
/**
 * Converts an object of type 'KubeStatefulSetProps' to JSON representation.
 */
export declare function toJson_KubeStatefulSetProps(obj: KubeStatefulSetProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) StatefulSetList is a collection of StatefulSets.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.StatefulSetList
 */
export interface KubeStatefulSetListProps {
    /**
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetList#items
     */
    readonly items: KubeStatefulSetProps[];
    /**
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeStatefulSetListProps' to JSON representation.
 */
export declare function toJson_KubeStatefulSetListProps(obj: KubeStatefulSetListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenRequest requests a token for a given service account.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1.TokenRequest
 */
export interface KubeTokenRequestProps {
    /**
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenRequest#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenRequest#spec
     */
    readonly spec: TokenRequestSpec;
}
/**
 * Converts an object of type 'KubeTokenRequestProps' to JSON representation.
 */
export declare function toJson_KubeTokenRequestProps(obj: KubeTokenRequestProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenReview attempts to authenticate a token to a known user.
 *
 * Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1.TokenReview
 */
export interface KubeTokenReviewProps {
    /**
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenReview#spec
     */
    readonly spec: TokenReviewSpec;
}
/**
 * Converts an object of type 'KubeTokenReviewProps' to JSON representation.
 */
export declare function toJson_KubeTokenReviewProps(obj: KubeTokenReviewProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenReview attempts to authenticate a token to a known user.
 *
 * Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1beta1.TokenReview
 */
export interface KubeTokenReviewV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.authentication.v1beta1.TokenReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1beta1.TokenReview#spec
     */
    readonly spec: TokenReviewSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeTokenReviewV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeTokenReviewV1Beta1Props(obj: KubeTokenReviewV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
 *
 * Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.LocalSubjectAccessReview
 */
export interface KubeLocalSubjectAccessReviewProps {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1.LocalSubjectAccessReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.LocalSubjectAccessReview#spec
     */
    readonly spec: SubjectAccessReviewSpec;
}
/**
 * Converts an object of type 'KubeLocalSubjectAccessReviewProps' to JSON representation.
 */
export declare function toJson_KubeLocalSubjectAccessReviewProps(obj: KubeLocalSubjectAccessReviewProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) SelfSubjectAccessReview checks whether or the current user can perform an action.
 *
 * Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SelfSubjectAccessReview
 */
export interface KubeSelfSubjectAccessReviewProps {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1.SelfSubjectAccessReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * user and groups must be empty
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SelfSubjectAccessReview#spec
     */
    readonly spec: SelfSubjectAccessReviewSpec;
}
/**
 * Converts an object of type 'KubeSelfSubjectAccessReviewProps' to JSON representation.
 */
export declare function toJson_KubeSelfSubjectAccessReviewProps(obj: KubeSelfSubjectAccessReviewProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
 *
 * The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SelfSubjectRulesReview
 */
export interface KubeSelfSubjectRulesReviewProps {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1.SelfSubjectRulesReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SelfSubjectRulesReview#spec
     */
    readonly spec: SelfSubjectRulesReviewSpec;
}
/**
 * Converts an object of type 'KubeSelfSubjectRulesReviewProps' to JSON representation.
 */
export declare function toJson_KubeSelfSubjectRulesReviewProps(obj: KubeSelfSubjectRulesReviewProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) SubjectAccessReview checks whether or not a user or group can perform an action.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SubjectAccessReview
 */
export interface KubeSubjectAccessReviewProps {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReview#spec
     */
    readonly spec: SubjectAccessReviewSpec;
}
/**
 * Converts an object of type 'KubeSubjectAccessReviewProps' to JSON representation.
 */
export declare function toJson_KubeSubjectAccessReviewProps(obj: KubeSubjectAccessReviewProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.
 *
 * Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview
 */
export interface KubeLocalSubjectAccessReviewV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview#spec
     */
    readonly spec: SubjectAccessReviewSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeLocalSubjectAccessReviewV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeLocalSubjectAccessReviewV1Beta1Props(obj: KubeLocalSubjectAccessReviewV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) SelfSubjectAccessReview checks whether or the current user can perform an action.
 *
 * Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview
 */
export interface KubeSelfSubjectAccessReviewV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * user and groups must be empty
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SelfSubjectAccessReview#spec
     */
    readonly spec: SelfSubjectAccessReviewSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeSelfSubjectAccessReviewV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeSelfSubjectAccessReviewV1Beta1Props(obj: KubeSelfSubjectAccessReviewV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.
 *
 * The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview
 */
export interface KubeSelfSubjectRulesReviewV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SelfSubjectRulesReview#spec
     */
    readonly spec: SelfSubjectRulesReviewSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeSelfSubjectRulesReviewV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeSelfSubjectRulesReviewV1Beta1Props(obj: KubeSelfSubjectRulesReviewV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) SubjectAccessReview checks whether or not a user or group can perform an action.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReview
 */
export interface KubeSubjectAccessReviewV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReview#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec holds information about the request being evaluated.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReview#spec
     */
    readonly spec: SubjectAccessReviewSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeSubjectAccessReviewV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeSubjectAccessReviewV1Beta1Props(obj: KubeSubjectAccessReviewV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) configuration of a horizontal pod autoscaler.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler
 */
export interface KubeHorizontalPodAutoscalerProps {
    /**
     * (experimental) Standard object metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) behaviour of autoscaler.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler#spec
     */
    readonly spec?: HorizontalPodAutoscalerSpec;
}
/**
 * Converts an object of type 'KubeHorizontalPodAutoscalerProps' to JSON representation.
 */
export declare function toJson_KubeHorizontalPodAutoscalerProps(obj: KubeHorizontalPodAutoscalerProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) list of horizontal pod autoscaler objects.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList
 */
export interface KubeHorizontalPodAutoscalerListProps {
    /**
     * (experimental) list of horizontal pod autoscaler objects.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList#items
     */
    readonly items: KubeHorizontalPodAutoscalerProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeHorizontalPodAutoscalerListProps' to JSON representation.
 */
export declare function toJson_KubeHorizontalPodAutoscalerListProps(obj: KubeHorizontalPodAutoscalerListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Scale represents a scaling request for a resource.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.Scale
 */
export interface KubeScaleProps {
    /**
     * (experimental) Standard object metadata;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.Scale#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) defines the behavior of the scale.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.Scale#spec
     */
    readonly spec?: ScaleSpec;
}
/**
 * Converts an object of type 'KubeScaleProps' to JSON representation.
 */
export declare function toJson_KubeScaleProps(obj: KubeScaleProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler
 */
export interface KubeHorizontalPodAutoscalerV2Beta1Props {
    /**
     * (experimental) metadata is the standard object metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec is the specification for the behaviour of the autoscaler.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler#spec
     */
    readonly spec?: HorizontalPodAutoscalerSpecV2Beta1;
}
/**
 * Converts an object of type 'KubeHorizontalPodAutoscalerV2Beta1Props' to JSON representation.
 */
export declare function toJson_KubeHorizontalPodAutoscalerV2Beta1Props(obj: KubeHorizontalPodAutoscalerV2Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList
 */
export interface KubeHorizontalPodAutoscalerListV2Beta1Props {
    /**
     * (experimental) items is the list of horizontal pod autoscaler objects.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList#items
     */
    readonly items: KubeHorizontalPodAutoscalerV2Beta1Props[];
    /**
     * (experimental) metadata is the standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeHorizontalPodAutoscalerListV2Beta1Props' to JSON representation.
 */
export declare function toJson_KubeHorizontalPodAutoscalerListV2Beta1Props(obj: KubeHorizontalPodAutoscalerListV2Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler
 */
export interface KubeHorizontalPodAutoscalerV2Beta2Props {
    /**
     * (experimental) metadata is the standard object metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec is the specification for the behaviour of the autoscaler.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler#spec
     */
    readonly spec?: HorizontalPodAutoscalerSpecV2Beta2;
}
/**
 * Converts an object of type 'KubeHorizontalPodAutoscalerV2Beta2Props' to JSON representation.
 */
export declare function toJson_KubeHorizontalPodAutoscalerV2Beta2Props(obj: KubeHorizontalPodAutoscalerV2Beta2Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList
 */
export interface KubeHorizontalPodAutoscalerListV2Beta2Props {
    /**
     * (experimental) items is the list of horizontal pod autoscaler objects.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList#items
     */
    readonly items: KubeHorizontalPodAutoscalerV2Beta2Props[];
    /**
     * (experimental) metadata is the standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeHorizontalPodAutoscalerListV2Beta2Props' to JSON representation.
 */
export declare function toJson_KubeHorizontalPodAutoscalerListV2Beta2Props(obj: KubeHorizontalPodAutoscalerListV2Beta2Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CronJob represents the configuration of a single cron job.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.CronJob
 */
export interface KubeCronJobProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJob#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of a cron job, including the schedule.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJob#spec
     */
    readonly spec?: CronJobSpec;
}
/**
 * Converts an object of type 'KubeCronJobProps' to JSON representation.
 */
export declare function toJson_KubeCronJobProps(obj: KubeCronJobProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CronJobList is a collection of cron jobs.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.CronJobList
 */
export interface KubeCronJobListProps {
    /**
     * (experimental) items is the list of CronJobs.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobList#items
     */
    readonly items: KubeCronJobProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCronJobListProps' to JSON representation.
 */
export declare function toJson_KubeCronJobListProps(obj: KubeCronJobListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Job represents the configuration of a single job.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.Job
 */
export interface KubeJobProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.Job#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of a job.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.Job#spec
     */
    readonly spec?: JobSpec;
}
/**
 * Converts an object of type 'KubeJobProps' to JSON representation.
 */
export declare function toJson_KubeJobProps(obj: KubeJobProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) JobList is a collection of jobs.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.JobList
 */
export interface KubeJobListProps {
    /**
     * (experimental) items is the list of Jobs.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobList#items
     */
    readonly items: KubeJobProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeJobListProps' to JSON representation.
 */
export declare function toJson_KubeJobListProps(obj: KubeJobListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CronJob represents the configuration of a single cron job.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1beta1.CronJob
 */
export interface KubeCronJobV1Beta1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJob#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of a cron job, including the schedule.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJob#spec
     */
    readonly spec?: CronJobSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeCronJobV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCronJobV1Beta1Props(obj: KubeCronJobV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CronJobList is a collection of cron jobs.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1beta1.CronJobList
 */
export interface KubeCronJobListV1Beta1Props {
    /**
     * (experimental) items is the list of CronJobs.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobList#items
     */
    readonly items: KubeCronJobV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCronJobListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCronJobListV1Beta1Props(obj: KubeCronJobListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.
 *
 * Kubelets use this API to obtain:
 * 1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
 * 2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).
 *
 * This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1.CertificateSigningRequest
 */
export interface KubeCertificateSigningRequestProps {
    /**
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequest#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec contains the certificate request, and is immutable after creation.
     *
     * Only the request, signerName, and usages fields can be set on creation. Other fields are derived by Kubernetes and cannot be modified by users.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequest#spec
     */
    readonly spec: CertificateSigningRequestSpec;
}
/**
 * Converts an object of type 'KubeCertificateSigningRequestProps' to JSON representation.
 */
export declare function toJson_KubeCertificateSigningRequestProps(obj: KubeCertificateSigningRequestProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CertificateSigningRequestList is a collection of CertificateSigningRequest objects.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1.CertificateSigningRequestList
 */
export interface KubeCertificateSigningRequestListProps {
    /**
     * (experimental) items is a collection of CertificateSigningRequest objects.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestList#items
     */
    readonly items: KubeCertificateSigningRequestProps[];
    /**
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCertificateSigningRequestListProps' to JSON representation.
 */
export declare function toJson_KubeCertificateSigningRequestListProps(obj: KubeCertificateSigningRequestListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Describes a certificate signing request.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequest
 */
export interface KubeCertificateSigningRequestV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequest#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) The certificate request itself and any additional information.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequest#spec
     */
    readonly spec?: CertificateSigningRequestSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeCertificateSigningRequestV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCertificateSigningRequestV1Beta1Props(obj: KubeCertificateSigningRequestV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * @experimental
 * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestList
 */
export interface KubeCertificateSigningRequestListV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestList#items
     */
    readonly items: KubeCertificateSigningRequestV1Beta1Props[];
    /**
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCertificateSigningRequestListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCertificateSigningRequestListV1Beta1Props(obj: KubeCertificateSigningRequestListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Lease defines a lease concept.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1.Lease
 */
export interface KubeLeaseProps {
    /**
     * (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.Lease#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the Lease.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.Lease#spec
     */
    readonly spec?: LeaseSpec;
}
/**
 * Converts an object of type 'KubeLeaseProps' to JSON representation.
 */
export declare function toJson_KubeLeaseProps(obj: KubeLeaseProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) LeaseList is a list of Lease objects.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1.LeaseList
 */
export interface KubeLeaseListProps {
    /**
     * (experimental) Items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.LeaseList#items
     */
    readonly items: KubeLeaseProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.LeaseList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeLeaseListProps' to JSON representation.
 */
export declare function toJson_KubeLeaseListProps(obj: KubeLeaseListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Lease defines a lease concept.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1beta1.Lease
 */
export interface KubeLeaseV1Beta1Props {
    /**
     * (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.Lease#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the Lease.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.Lease#spec
     */
    readonly spec?: LeaseSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeLeaseV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeLeaseV1Beta1Props(obj: KubeLeaseV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) LeaseList is a list of Lease objects.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1beta1.LeaseList
 */
export interface KubeLeaseListV1Beta1Props {
    /**
     * (experimental) Items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.LeaseList#items
     */
    readonly items: KubeLeaseV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.LeaseList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeLeaseListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeLeaseListV1Beta1Props(obj: KubeLeaseListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Binding ties one object to another;
 *
 * for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Binding
 */
export interface KubeBindingProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Binding#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) The target object that you want to bind to the standard object.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Binding#target
     */
    readonly target: ObjectReference;
}
/**
 * Converts an object of type 'KubeBindingProps' to JSON representation.
 */
export declare function toJson_KubeBindingProps(obj: KubeBindingProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ComponentStatus (and ComponentStatusList) holds the cluster validation info.
 *
 * Deprecated: This API is deprecated in v1.19+
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ComponentStatus
 */
export interface KubeComponentStatusProps {
    /**
     * (experimental) List of component conditions observed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentStatus#conditions
     */
    readonly conditions?: ComponentCondition[];
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentStatus#metadata
     */
    readonly metadata?: ObjectMeta;
}
/**
 * Converts an object of type 'KubeComponentStatusProps' to JSON representation.
 */
export declare function toJson_KubeComponentStatusProps(obj: KubeComponentStatusProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Status of all the conditions for the component as a list of ComponentStatus objects.
 *
 * Deprecated: This API is deprecated in v1.19+
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ComponentStatusList
 */
export interface KubeComponentStatusListProps {
    /**
     * (experimental) List of ComponentStatus objects.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentStatusList#items
     */
    readonly items: KubeComponentStatusProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentStatusList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeComponentStatusListProps' to JSON representation.
 */
export declare function toJson_KubeComponentStatusListProps(obj: KubeComponentStatusListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ConfigMap holds configuration data for pods to consume.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ConfigMap
 */
export interface KubeConfigMapProps {
    /**
     * (experimental) BinaryData contains the binary data.
     *
     * Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ConfigMap#binaryData
     */
    readonly binaryData?: {
        [key: string]: string;
    };
    /**
     * (experimental) Data contains the configuration data.
     *
     * Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ConfigMap#data
     */
    readonly data?: {
        [key: string]: string;
    };
    /**
     * (experimental) Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified).
     *
     * If not set to true, the field can be modified at any time. Defaulted to nil.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ConfigMap#immutable
     */
    readonly immutable?: boolean;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ConfigMap#metadata
     */
    readonly metadata?: ObjectMeta;
}
/**
 * Converts an object of type 'KubeConfigMapProps' to JSON representation.
 */
export declare function toJson_KubeConfigMapProps(obj: KubeConfigMapProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ConfigMapList is a resource containing a list of ConfigMap objects.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ConfigMapList
 */
export interface KubeConfigMapListProps {
    /**
     * (experimental) Items is the list of ConfigMaps.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ConfigMapList#items
     */
    readonly items: KubeConfigMapProps[];
    /**
     * (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ConfigMapList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeConfigMapListProps' to JSON representation.
 */
export declare function toJson_KubeConfigMapListProps(obj: KubeConfigMapListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Endpoints is a collection of endpoints that implement the actual service.
 *
 * Example:
 * Name: "mysvc",
 * Subsets: [
 * {
 * Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
 * Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
 * },
 * {
 * Addresses: [{"ip": "10.10.3.3"}],
 * Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
 * },
 * ]
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Endpoints
 */
export interface KubeEndpointsProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Endpoints#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) The set of all endpoints is the union of all subsets.
     *
     * Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Endpoints#subsets
     */
    readonly subsets?: EndpointSubset[];
}
/**
 * Converts an object of type 'KubeEndpointsProps' to JSON representation.
 */
export declare function toJson_KubeEndpointsProps(obj: KubeEndpointsProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointsList is a list of endpoints.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EndpointsList
 */
export interface KubeEndpointsListProps {
    /**
     * (experimental) List of endpoints.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointsList#items
     */
    readonly items: KubeEndpointsProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointsList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeEndpointsListProps' to JSON representation.
 */
export declare function toJson_KubeEndpointsListProps(obj: KubeEndpointsListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) A list of ephemeral containers used with the Pod ephemeralcontainers subresource.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EphemeralContainers
 */
export interface KubeEphemeralContainersProps {
    /**
     * (experimental) A list of ephemeral containers associated with this pod.
     *
     * New ephemeral containers may be appended to this list, but existing ephemeral containers may not be removed or modified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainers#ephemeralContainers
     */
    readonly ephemeralContainers: EphemeralContainer[];
    /**
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainers#metadata
     */
    readonly metadata?: ObjectMeta;
}
/**
 * Converts an object of type 'KubeEphemeralContainersProps' to JSON representation.
 */
export declare function toJson_KubeEphemeralContainersProps(obj: KubeEphemeralContainersProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Event is a report of an event somewhere in the cluster.
 *
 * It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
 *
 * @experimental
 * @schema io.k8s.api.events.v1.Event
 */
export interface KubeEventProps {
    /**
     * (experimental) action is what action was taken/failed regarding to the regarding object.
     *
     * It is machine-readable. This field cannot be empty for new Events and it can have at most 128 characters.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#action
     */
    readonly action?: string;
    /**
     * (experimental) deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#deprecatedCount
     */
    readonly deprecatedCount?: number;
    /**
     * (experimental) deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#deprecatedFirstTimestamp
     */
    readonly deprecatedFirstTimestamp?: Date;
    /**
     * (experimental) deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#deprecatedLastTimestamp
     */
    readonly deprecatedLastTimestamp?: Date;
    /**
     * (experimental) deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#deprecatedSource
     */
    readonly deprecatedSource?: EventSource;
    /**
     * (experimental) eventTime is the time when this Event was first observed.
     *
     * It is required.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#eventTime
     */
    readonly eventTime: Date;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) note is a human-readable description of the status of this operation.
     *
     * Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#note
     */
    readonly note?: string;
    /**
     * (experimental) reason is why the action was taken.
     *
     * It is human-readable. This field cannot be empty for new Events and it can have at most 128 characters.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#reason
     */
    readonly reason?: string;
    /**
     * (experimental) regarding contains the object this Event is about.
     *
     * In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#regarding
     */
    readonly regarding?: ObjectReference;
    /**
     * (experimental) related is the optional secondary object for more complex actions.
     *
     * E.g. when regarding object triggers a creation or deletion of related object.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#related
     */
    readonly related?: ObjectReference;
    /**
     * (experimental) reportingController is the name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. This field cannot be empty for new Events.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#reportingController
     */
    readonly reportingController?: string;
    /**
     * (experimental) reportingInstance is the ID of the controller instance, e.g. `kubelet-xyzf`. This field cannot be empty for new Events and it can have at most 128 characters.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#reportingInstance
     */
    readonly reportingInstance?: string;
    /**
     * (experimental) series is data about the Event series this event represents or nil if it's a singleton Event.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#series
     */
    readonly series?: EventSeries;
    /**
     * (experimental) type is the type of this event (Normal, Warning), new types could be added in the future.
     *
     * It is machine-readable. This field cannot be empty for new Events.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.Event#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'KubeEventProps' to JSON representation.
 */
export declare function toJson_KubeEventProps(obj: KubeEventProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) EventList is a list of Event objects.
 *
 * @experimental
 * @schema io.k8s.api.events.v1.EventList
 */
export interface KubeEventListProps {
    /**
     * (experimental) items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.EventList#items
     */
    readonly items: KubeEventProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.events.v1.EventList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeEventListProps' to JSON representation.
 */
export declare function toJson_KubeEventListProps(obj: KubeEventListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) LimitRange sets resource usage limits for each kind of resource in a Namespace.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LimitRange
 */
export interface KubeLimitRangeProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRange#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the limits enforced.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRange#spec
     */
    readonly spec?: LimitRangeSpec;
}
/**
 * Converts an object of type 'KubeLimitRangeProps' to JSON representation.
 */
export declare function toJson_KubeLimitRangeProps(obj: KubeLimitRangeProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) LimitRangeList is a list of LimitRange items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LimitRangeList
 */
export interface KubeLimitRangeListProps {
    /**
     * (experimental) Items is a list of LimitRange objects.
     *
     * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeList#items
     */
    readonly items: KubeLimitRangeProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeLimitRangeListProps' to JSON representation.
 */
export declare function toJson_KubeLimitRangeListProps(obj: KubeLimitRangeListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Namespace provides a scope for Names.
 *
 * Use of multiple namespaces is optional.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Namespace
 */
export interface KubeNamespaceProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Namespace#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the behavior of the Namespace.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Namespace#spec
     */
    readonly spec?: NamespaceSpec;
}
/**
 * Converts an object of type 'KubeNamespaceProps' to JSON representation.
 */
export declare function toJson_KubeNamespaceProps(obj: KubeNamespaceProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) NamespaceList is a list of Namespaces.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NamespaceList
 */
export interface KubeNamespaceListProps {
    /**
     * (experimental) Items is the list of Namespace objects in the list.
     *
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NamespaceList#items
     */
    readonly items: KubeNamespaceProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NamespaceList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeNamespaceListProps' to JSON representation.
 */
export declare function toJson_KubeNamespaceListProps(obj: KubeNamespaceListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Node is a worker node in Kubernetes.
 *
 * Each node will have a unique identifier in the cache (i.e. in etcd).
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Node
 */
export interface KubeNodeProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Node#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the behavior of a node.
     *
     * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Node#spec
     */
    readonly spec?: NodeSpec;
}
/**
 * Converts an object of type 'KubeNodeProps' to JSON representation.
 */
export declare function toJson_KubeNodeProps(obj: KubeNodeProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) NodeList is the whole list of all Nodes which have been registered with master.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NodeList
 */
export interface KubeNodeListProps {
    /**
     * (experimental) List of nodes.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeList#items
     */
    readonly items: KubeNodeProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeNodeListProps' to JSON representation.
 */
export declare function toJson_KubeNodeListProps(obj: KubeNodeListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PersistentVolume (PV) is a storage resource provisioned by an administrator.
 *
 * It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolume
 */
export interface KubePersistentVolumeProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolume#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines a specification of a persistent volume owned by the cluster.
     *
     * Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolume#spec
     */
    readonly spec?: PersistentVolumeSpec;
}
/**
 * Converts an object of type 'KubePersistentVolumeProps' to JSON representation.
 */
export declare function toJson_KubePersistentVolumeProps(obj: KubePersistentVolumeProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PersistentVolumeClaim is a user's request for and claim to a persistent volume.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeClaim
 */
export interface KubePersistentVolumeClaimProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaim#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the desired characteristics of a volume requested by a pod author.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaim#spec
     */
    readonly spec?: PersistentVolumeClaimSpec;
}
/**
 * Converts an object of type 'KubePersistentVolumeClaimProps' to JSON representation.
 */
export declare function toJson_KubePersistentVolumeClaimProps(obj: KubePersistentVolumeClaimProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeClaimList
 */
export interface KubePersistentVolumeClaimListProps {
    /**
     * (experimental) A list of persistent volume claims.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimList#items
     */
    readonly items: KubePersistentVolumeClaimProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePersistentVolumeClaimListProps' to JSON representation.
 */
export declare function toJson_KubePersistentVolumeClaimListProps(obj: KubePersistentVolumeClaimListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PersistentVolumeList is a list of PersistentVolume items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeList
 */
export interface KubePersistentVolumeListProps {
    /**
     * (experimental) List of persistent volumes.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeList#items
     */
    readonly items: KubePersistentVolumeProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePersistentVolumeListProps' to JSON representation.
 */
export declare function toJson_KubePersistentVolumeListProps(obj: KubePersistentVolumeListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Pod is a collection of containers that can run on a host.
 *
 * This resource is created by clients and scheduled onto hosts.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Pod
 */
export interface KubePodProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Pod#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of the pod.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Pod#spec
     */
    readonly spec?: PodSpec;
}
/**
 * Converts an object of type 'KubePodProps' to JSON representation.
 */
export declare function toJson_KubePodProps(obj: KubePodProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodList is a list of Pods.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodList
 */
export interface KubePodListProps {
    /**
     * (experimental) List of pods.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodList#items
     */
    readonly items: KubePodProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePodListProps' to JSON representation.
 */
export declare function toJson_KubePodListProps(obj: KubePodListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodTemplate describes a template for creating copies of a predefined pod.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodTemplate
 */
export interface KubePodTemplateProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodTemplate#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Template defines the pods that will be created from this pod template.
     *
     * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodTemplate#template
     */
    readonly template?: PodTemplateSpec;
}
/**
 * Converts an object of type 'KubePodTemplateProps' to JSON representation.
 */
export declare function toJson_KubePodTemplateProps(obj: KubePodTemplateProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodTemplateList is a list of PodTemplates.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodTemplateList
 */
export interface KubePodTemplateListProps {
    /**
     * (experimental) List of pod templates.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodTemplateList#items
     */
    readonly items: KubePodTemplateProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodTemplateList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePodTemplateListProps' to JSON representation.
 */
export declare function toJson_KubePodTemplateListProps(obj: KubePodTemplateListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ReplicationController represents the configuration of a replication controller.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ReplicationController
 */
export interface KubeReplicationControllerProps {
    /**
     * (experimental) If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages.
     *
     * Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationController#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the specification of the desired behavior of the replication controller.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationController#spec
     */
    readonly spec?: ReplicationControllerSpec;
}
/**
 * Converts an object of type 'KubeReplicationControllerProps' to JSON representation.
 */
export declare function toJson_KubeReplicationControllerProps(obj: KubeReplicationControllerProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ReplicationControllerList is a collection of replication controllers.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ReplicationControllerList
 */
export interface KubeReplicationControllerListProps {
    /**
     * (experimental) List of replication controllers.
     *
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationControllerList#items
     */
    readonly items: KubeReplicationControllerProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationControllerList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeReplicationControllerListProps' to JSON representation.
 */
export declare function toJson_KubeReplicationControllerListProps(obj: KubeReplicationControllerListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ResourceQuota sets aggregate quota restrictions enforced per namespace.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ResourceQuota
 */
export interface KubeResourceQuotaProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceQuota#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the desired quota.
     *
     * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceQuota#spec
     */
    readonly spec?: ResourceQuotaSpec;
}
/**
 * Converts an object of type 'KubeResourceQuotaProps' to JSON representation.
 */
export declare function toJson_KubeResourceQuotaProps(obj: KubeResourceQuotaProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ResourceQuotaList is a list of ResourceQuota items.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ResourceQuotaList
 */
export interface KubeResourceQuotaListProps {
    /**
     * (experimental) Items is a list of ResourceQuota objects.
     *
     * More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceQuotaList#items
     */
    readonly items: KubeResourceQuotaProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceQuotaList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeResourceQuotaListProps' to JSON representation.
 */
export declare function toJson_KubeResourceQuotaListProps(obj: KubeResourceQuotaListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Secret holds secret data of a certain type.
 *
 * The total bytes of the values in the Data field must be less than MaxSecretSize bytes.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Secret
 */
export interface KubeSecretProps {
    /**
     * (experimental) Data contains the secret data.
     *
     * Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Secret#data
     */
    readonly data?: {
        [key: string]: string;
    };
    /**
     * (experimental) Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).
     *
     * If not set to true, the field can be modified at any time. Defaulted to nil.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Secret#immutable
     */
    readonly immutable?: boolean;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Secret#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) stringData allows specifying non-binary secret data in string form.
     *
     * It is provided as a write-only input field for convenience. All keys and values are merged into the data field on write, overwriting any existing values. The stringData field is never output when reading from the API.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Secret#stringData
     */
    readonly stringData?: {
        [key: string]: string;
    };
    /**
     * (experimental) Used to facilitate programmatic handling of secret data.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Secret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'KubeSecretProps' to JSON representation.
 */
export declare function toJson_KubeSecretProps(obj: KubeSecretProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) SecretList is a list of Secret.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.SecretList
 */
export interface KubeSecretListProps {
    /**
     * (experimental) Items is a list of secret objects.
     *
     * More info: https://kubernetes.io/docs/concepts/configuration/secret
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecretList#items
     */
    readonly items: KubeSecretProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecretList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeSecretListProps' to JSON representation.
 */
export declare function toJson_KubeSecretListProps(obj: KubeSecretListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Service
 */
export interface KubeServiceProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Service#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec defines the behavior of a service.
     *
     * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Service#spec
     */
    readonly spec?: ServiceSpec;
}
/**
 * Converts an object of type 'KubeServiceProps' to JSON representation.
 */
export declare function toJson_KubeServiceProps(obj: KubeServiceProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServiceAccount
 */
export interface KubeServiceAccountProps {
    /**
     * (experimental) AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted.
     *
     * Can be overridden at the pod level.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceAccount#automountServiceAccountToken
     */
    readonly automountServiceAccountToken?: boolean;
    /**
     * (experimental) ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount.
     *
     * ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceAccount#imagePullSecrets
     */
    readonly imagePullSecrets?: LocalObjectReference[];
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceAccount#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount.
     *
     * More info: https://kubernetes.io/docs/concepts/configuration/secret
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceAccount#secrets
     */
    readonly secrets?: ObjectReference[];
}
/**
 * Converts an object of type 'KubeServiceAccountProps' to JSON representation.
 */
export declare function toJson_KubeServiceAccountProps(obj: KubeServiceAccountProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ServiceAccountList is a list of ServiceAccount objects.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServiceAccountList
 */
export interface KubeServiceAccountListProps {
    /**
     * (experimental) List of ServiceAccounts.
     *
     * More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceAccountList#items
     */
    readonly items: KubeServiceAccountProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceAccountList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeServiceAccountListProps' to JSON representation.
 */
export declare function toJson_KubeServiceAccountListProps(obj: KubeServiceAccountListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ServiceList holds a list of services.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServiceList
 */
export interface KubeServiceListProps {
    /**
     * (experimental) List of services.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceList#items
     */
    readonly items: KubeServiceProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeServiceListProps' to JSON representation.
 */
export declare function toJson_KubeServiceListProps(obj: KubeServiceListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointSlice represents a subset of the endpoints that implement a service.
 *
 * For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1.EndpointSlice
 */
export interface KubeEndpointSliceProps {
    /**
     * (experimental) addressType specifies the type of address carried by this EndpointSlice.
     *
     * All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointSlice#addressType
     */
    readonly addressType: string;
    /**
     * (experimental) endpoints is a list of unique endpoints in this slice.
     *
     * Each slice may include a maximum of 1000 endpoints.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointSlice#endpoints
     */
    readonly endpoints: Endpoint[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointSlice#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) ports specifies the list of network ports exposed by each endpoint in this slice.
     *
     * Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointSlice#ports
     */
    readonly ports?: EndpointPort[];
}
/**
 * Converts an object of type 'KubeEndpointSliceProps' to JSON representation.
 */
export declare function toJson_KubeEndpointSliceProps(obj: KubeEndpointSliceProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointSliceList represents a list of endpoint slices.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1.EndpointSliceList
 */
export interface KubeEndpointSliceListProps {
    /**
     * (experimental) List of endpoint slices.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointSliceList#items
     */
    readonly items: KubeEndpointSliceProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointSliceList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeEndpointSliceListProps' to JSON representation.
 */
export declare function toJson_KubeEndpointSliceListProps(obj: KubeEndpointSliceListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointSlice represents a subset of the endpoints that implement a service.
 *
 * For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.EndpointSlice
 */
export interface KubeEndpointSliceV1Beta1Props {
    /**
     * (experimental) addressType specifies the type of address carried by this EndpointSlice.
     *
     * All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointSlice#addressType
     */
    readonly addressType: string;
    /**
     * (experimental) endpoints is a list of unique endpoints in this slice.
     *
     * Each slice may include a maximum of 1000 endpoints.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointSlice#endpoints
     */
    readonly endpoints: EndpointV1Beta1[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointSlice#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) ports specifies the list of network ports exposed by each endpoint in this slice.
     *
     * Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointSlice#ports
     */
    readonly ports?: EndpointPortV1Beta1[];
}
/**
 * Converts an object of type 'KubeEndpointSliceV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeEndpointSliceV1Beta1Props(obj: KubeEndpointSliceV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointSliceList represents a list of endpoint slices.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.EndpointSliceList
 */
export interface KubeEndpointSliceListV1Beta1Props {
    /**
     * (experimental) List of endpoint slices.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointSliceList#items
     */
    readonly items: KubeEndpointSliceV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointSliceList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeEndpointSliceListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeEndpointSliceListV1Beta1Props(obj: KubeEndpointSliceListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Event is a report of an event somewhere in the cluster.
 *
 * It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
 *
 * @experimental
 * @schema io.k8s.api.events.v1beta1.Event
 */
export interface KubeEventV1Beta1Props {
    /**
     * (experimental) action is what action was taken/failed regarding to the regarding object.
     *
     * It is machine-readable. This field can have at most 128 characters.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#action
     */
    readonly action?: string;
    /**
     * (experimental) deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#deprecatedCount
     */
    readonly deprecatedCount?: number;
    /**
     * (experimental) deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#deprecatedFirstTimestamp
     */
    readonly deprecatedFirstTimestamp?: Date;
    /**
     * (experimental) deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#deprecatedLastTimestamp
     */
    readonly deprecatedLastTimestamp?: Date;
    /**
     * (experimental) deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#deprecatedSource
     */
    readonly deprecatedSource?: EventSource;
    /**
     * (experimental) eventTime is the time when this Event was first observed.
     *
     * It is required.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#eventTime
     */
    readonly eventTime: Date;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) note is a human-readable description of the status of this operation.
     *
     * Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#note
     */
    readonly note?: string;
    /**
     * (experimental) reason is why the action was taken.
     *
     * It is human-readable. This field can have at most 128 characters.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#reason
     */
    readonly reason?: string;
    /**
     * (experimental) regarding contains the object this Event is about.
     *
     * In most cases it's an Object reporting controller implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#regarding
     */
    readonly regarding?: ObjectReference;
    /**
     * (experimental) related is the optional secondary object for more complex actions.
     *
     * E.g. when regarding object triggers a creation or deletion of related object.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#related
     */
    readonly related?: ObjectReference;
    /**
     * (experimental) reportingController is the name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. This field cannot be empty for new Events.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#reportingController
     */
    readonly reportingController?: string;
    /**
     * (experimental) reportingInstance is the ID of the controller instance, e.g. `kubelet-xyzf`. This field cannot be empty for new Events and it can have at most 128 characters.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#reportingInstance
     */
    readonly reportingInstance?: string;
    /**
     * (experimental) series is data about the Event series this event represents or nil if it's a singleton Event.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#series
     */
    readonly series?: EventSeriesV1Beta1;
    /**
     * (experimental) type is the type of this event (Normal, Warning), new types could be added in the future.
     *
     * It is machine-readable.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.Event#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'KubeEventV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeEventV1Beta1Props(obj: KubeEventV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) EventList is a list of Event objects.
 *
 * @experimental
 * @schema io.k8s.api.events.v1beta1.EventList
 */
export interface KubeEventListV1Beta1Props {
    /**
     * (experimental) items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.EventList#items
     */
    readonly items: KubeEventV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.EventList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeEventListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeEventListV1Beta1Props(obj: KubeEventListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.
 *
 * An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.Ingress
 */
export interface KubeIngressV1Beta1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.Ingress#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec is the desired state of the Ingress.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.Ingress#spec
     */
    readonly spec?: IngressSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeIngressV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeIngressV1Beta1Props(obj: KubeIngressV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressList is a collection of Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressList
 */
export interface KubeIngressListV1Beta1Props {
    /**
     * (experimental) Items is the list of Ingress.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressList#items
     */
    readonly items: KubeIngressV1Beta1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeIngressListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeIngressListV1Beta1Props(obj: KubeIngressListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) FlowSchema defines the schema of a group of flows.
 *
 * Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchema
 */
export interface KubeFlowSchemaV1Beta1Props {
    /**
     * (experimental) `metadata` is the standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchema#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) `spec` is the specification of the desired behavior of a FlowSchema.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchema#spec
     */
    readonly spec?: FlowSchemaSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeFlowSchemaV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeFlowSchemaV1Beta1Props(obj: KubeFlowSchemaV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) FlowSchemaList is a list of FlowSchema objects.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaList
 */
export interface KubeFlowSchemaListV1Beta1Props {
    /**
     * (experimental) `items` is a list of FlowSchemas.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaList#items
     */
    readonly items: KubeFlowSchemaV1Beta1Props[];
    /**
     * (experimental) `metadata` is the standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeFlowSchemaListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeFlowSchemaListV1Beta1Props(obj: KubeFlowSchemaListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityLevelConfiguration represents the configuration of a priority level.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration
 */
export interface KubePriorityLevelConfigurationV1Beta1Props {
    /**
     * (experimental) `metadata` is the standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) `spec` is the specification of the desired behavior of a "request-priority".
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration#spec
     */
    readonly spec?: PriorityLevelConfigurationSpecV1Beta1;
}
/**
 * Converts an object of type 'KubePriorityLevelConfigurationV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePriorityLevelConfigurationV1Beta1Props(obj: KubePriorityLevelConfigurationV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityLevelConfigurationList is a list of PriorityLevelConfiguration objects.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList
 */
export interface KubePriorityLevelConfigurationListV1Beta1Props {
    /**
     * (experimental) `items` is a list of request-priorities.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList#items
     */
    readonly items: KubePriorityLevelConfigurationV1Beta1Props[];
    /**
     * (experimental) `metadata` is the standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePriorityLevelConfigurationListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePriorityLevelConfigurationListV1Beta1Props(obj: KubePriorityLevelConfigurationListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.
 *
 * An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.Ingress
 */
export interface KubeIngressProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.Ingress#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec is the desired state of the Ingress.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.Ingress#spec
     */
    readonly spec?: IngressSpec;
}
/**
 * Converts an object of type 'KubeIngressProps' to JSON representation.
 */
export declare function toJson_KubeIngressProps(obj: KubeIngressProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClass represents the class of the Ingress, referenced by the Ingress Spec.
 *
 * The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressClass
 */
export interface KubeIngressClassProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec is the desired state of the IngressClass.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClass#spec
     */
    readonly spec?: IngressClassSpec;
}
/**
 * Converts an object of type 'KubeIngressClassProps' to JSON representation.
 */
export declare function toJson_KubeIngressClassProps(obj: KubeIngressClassProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClassList is a collection of IngressClasses.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressClassList
 */
export interface KubeIngressClassListProps {
    /**
     * (experimental) Items is the list of IngressClasses.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassList#items
     */
    readonly items: KubeIngressClassProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeIngressClassListProps' to JSON representation.
 */
export declare function toJson_KubeIngressClassListProps(obj: KubeIngressClassListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressList is a collection of Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressList
 */
export interface KubeIngressListProps {
    /**
     * (experimental) Items is the list of Ingress.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressList#items
     */
    readonly items: KubeIngressProps[];
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeIngressListProps' to JSON representation.
 */
export declare function toJson_KubeIngressListProps(obj: KubeIngressListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) NetworkPolicy describes what network traffic is allowed for a set of Pods.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.NetworkPolicy
 */
export interface KubeNetworkPolicyProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicy#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior for this NetworkPolicy.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicy#spec
     */
    readonly spec?: NetworkPolicySpec;
}
/**
 * Converts an object of type 'KubeNetworkPolicyProps' to JSON representation.
 */
export declare function toJson_KubeNetworkPolicyProps(obj: KubeNetworkPolicyProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) NetworkPolicyList is a list of NetworkPolicy objects.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.NetworkPolicyList
 */
export interface KubeNetworkPolicyListProps {
    /**
     * (experimental) Items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicyList#items
     */
    readonly items: KubeNetworkPolicyProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicyList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeNetworkPolicyListProps' to JSON representation.
 */
export declare function toJson_KubeNetworkPolicyListProps(obj: KubeNetworkPolicyListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClass represents the class of the Ingress, referenced by the Ingress Spec.
 *
 * The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressClass
 */
export interface KubeIngressClassV1Beta1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec is the desired state of the IngressClass.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClass#spec
     */
    readonly spec?: IngressClassSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeIngressClassV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeIngressClassV1Beta1Props(obj: KubeIngressClassV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClassList is a collection of IngressClasses.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressClassList
 */
export interface KubeIngressClassListV1Beta1Props {
    /**
     * (experimental) Items is the list of IngressClasses.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassList#items
     */
    readonly items: KubeIngressClassV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeIngressClassListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeIngressClassListV1Beta1Props(obj: KubeIngressClassListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClass defines a class of container runtime supported in the cluster.
 *
 * The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://kubernetes.io/docs/concepts/containers/runtime-class/
 *
 * @experimental
 * @schema io.k8s.api.node.v1.RuntimeClass
 */
export interface KubeRuntimeClassProps {
    /**
     * (experimental) Handler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class.
     *
     * The possible values are specific to the node & CRI configuration.  It is assumed that all handlers are available on every node, and handlers of the same name are equivalent on every node. For example, a handler called "runc" might specify that the runc OCI runtime (using native Linux containers) will be used to run the containers in a pod. The Handler must be lowercase, conform to the DNS Label (RFC 1123) requirements, and is immutable.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.RuntimeClass#handler
     */
    readonly handler: string;
    /**
     * (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.RuntimeClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Overhead represents the resource overhead associated with running a pod for a given RuntimeClass.
     *
     * For more details, see
     * https://kubernetes.io/docs/concepts/scheduling-eviction/pod-overhead/
     * This field is in beta starting v1.18 and is only honored by servers that enable the PodOverhead feature.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.RuntimeClass#overhead
     */
    readonly overhead?: Overhead;
    /**
     * (experimental) Scheduling holds the scheduling constraints to ensure that pods running with this RuntimeClass are scheduled to nodes that support it.
     *
     * If scheduling is nil, this RuntimeClass is assumed to be supported by all nodes.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.RuntimeClass#scheduling
     */
    readonly scheduling?: Scheduling;
}
/**
 * Converts an object of type 'KubeRuntimeClassProps' to JSON representation.
 */
export declare function toJson_KubeRuntimeClassProps(obj: KubeRuntimeClassProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClassList is a list of RuntimeClass objects.
 *
 * @experimental
 * @schema io.k8s.api.node.v1.RuntimeClassList
 */
export interface KubeRuntimeClassListProps {
    /**
     * (experimental) Items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.RuntimeClassList#items
     */
    readonly items: KubeRuntimeClassProps[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.node.v1.RuntimeClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRuntimeClassListProps' to JSON representation.
 */
export declare function toJson_KubeRuntimeClassListProps(obj: KubeRuntimeClassListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClass defines a class of container runtime supported in the cluster.
 *
 * The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md
 *
 * @experimental
 * @schema io.k8s.api.node.v1alpha1.RuntimeClass
 */
export interface KubeRuntimeClassV1Alpha1Props {
    /**
     * (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.RuntimeClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the RuntimeClass More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.RuntimeClass#spec
     */
    readonly spec: RuntimeClassSpecV1Alpha1;
}
/**
 * Converts an object of type 'KubeRuntimeClassV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeRuntimeClassV1Alpha1Props(obj: KubeRuntimeClassV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClassList is a list of RuntimeClass objects.
 *
 * @experimental
 * @schema io.k8s.api.node.v1alpha1.RuntimeClassList
 */
export interface KubeRuntimeClassListV1Alpha1Props {
    /**
     * (experimental) Items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.RuntimeClassList#items
     */
    readonly items: KubeRuntimeClassV1Alpha1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.RuntimeClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRuntimeClassListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeRuntimeClassListV1Alpha1Props(obj: KubeRuntimeClassListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClass defines a class of container runtime supported in the cluster.
 *
 * The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are (currently) manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md
 *
 * @experimental
 * @schema io.k8s.api.node.v1beta1.RuntimeClass
 */
export interface KubeRuntimeClassV1Beta1Props {
    /**
     * (experimental) Handler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class.
     *
     * The possible values are specific to the node & CRI configuration.  It is assumed that all handlers are available on every node, and handlers of the same name are equivalent on every node. For example, a handler called "runc" might specify that the runc OCI runtime (using native Linux containers) will be used to run the containers in a pod. The Handler must be lowercase, conform to the DNS Label (RFC 1123) requirements, and is immutable.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.RuntimeClass#handler
     */
    readonly handler: string;
    /**
     * (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.RuntimeClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Overhead represents the resource overhead associated with running a pod for a given RuntimeClass.
     *
     * For more details, see https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.15, and is only honored by servers that enable the PodOverhead feature.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.RuntimeClass#overhead
     */
    readonly overhead?: OverheadV1Beta1;
    /**
     * (experimental) Scheduling holds the scheduling constraints to ensure that pods running with this RuntimeClass are scheduled to nodes that support it.
     *
     * If scheduling is nil, this RuntimeClass is assumed to be supported by all nodes.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.RuntimeClass#scheduling
     */
    readonly scheduling?: SchedulingV1Beta1;
}
/**
 * Converts an object of type 'KubeRuntimeClassV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeRuntimeClassV1Beta1Props(obj: KubeRuntimeClassV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClassList is a list of RuntimeClass objects.
 *
 * @experimental
 * @schema io.k8s.api.node.v1beta1.RuntimeClassList
 */
export interface KubeRuntimeClassListV1Beta1Props {
    /**
     * (experimental) Items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.RuntimeClassList#items
     */
    readonly items: KubeRuntimeClassV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.RuntimeClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRuntimeClassListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeRuntimeClassListV1Beta1Props(obj: KubeRuntimeClassListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1.PodDisruptionBudget
 */
export interface KubePodDisruptionBudgetProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.policy.v1.PodDisruptionBudget#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of the PodDisruptionBudget.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1.PodDisruptionBudget#spec
     */
    readonly spec?: PodDisruptionBudgetSpec;
}
/**
 * Converts an object of type 'KubePodDisruptionBudgetProps' to JSON representation.
 */
export declare function toJson_KubePodDisruptionBudgetProps(obj: KubePodDisruptionBudgetProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1.PodDisruptionBudgetList
 */
export interface KubePodDisruptionBudgetListProps {
    /**
     * (experimental) Items is a list of PodDisruptionBudgets.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1.PodDisruptionBudgetList#items
     */
    readonly items: KubePodDisruptionBudgetProps[];
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.policy.v1.PodDisruptionBudgetList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePodDisruptionBudgetListProps' to JSON representation.
 */
export declare function toJson_KubePodDisruptionBudgetListProps(obj: KubePodDisruptionBudgetListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Eviction evicts a pod from its node subject to certain policies and safety constraints.
 *
 * This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.Eviction
 */
export interface KubeEvictionV1Beta1Props {
    /**
     * (experimental) DeleteOptions may be provided.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.Eviction#deleteOptions
     */
    readonly deleteOptions?: DeleteOptions;
    /**
     * (experimental) ObjectMeta describes the pod that is being evicted.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.Eviction#metadata
     */
    readonly metadata?: ObjectMeta;
}
/**
 * Converts an object of type 'KubeEvictionV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeEvictionV1Beta1Props(obj: KubeEvictionV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudget
 */
export interface KubePodDisruptionBudgetV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudget#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of the PodDisruptionBudget.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudget#spec
     */
    readonly spec?: PodDisruptionBudgetSpecV1Beta1;
}
/**
 * Converts an object of type 'KubePodDisruptionBudgetV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePodDisruptionBudgetV1Beta1Props(obj: KubePodDisruptionBudgetV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetList
 */
export interface KubePodDisruptionBudgetListV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetList#items
     */
    readonly items: KubePodDisruptionBudgetV1Beta1Props[];
    /**
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePodDisruptionBudgetListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePodDisruptionBudgetListV1Beta1Props(obj: KubePodDisruptionBudgetListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.
 *
 * Deprecated in 1.21.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicy
 */
export interface KubePodSecurityPolicyV1Beta1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicy#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec defines the policy enforced.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicy#spec
     */
    readonly spec?: PodSecurityPolicySpecV1Beta1;
}
/**
 * Converts an object of type 'KubePodSecurityPolicyV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePodSecurityPolicyV1Beta1Props(obj: KubePodSecurityPolicyV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodSecurityPolicyList is a list of PodSecurityPolicy objects.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicyList
 */
export interface KubePodSecurityPolicyListV1Beta1Props {
    /**
     * (experimental) items is a list of schema objects.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicyList#items
     */
    readonly items: KubePodSecurityPolicyV1Beta1Props[];
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicyList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePodSecurityPolicyListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePodSecurityPolicyListV1Beta1Props(obj: KubePodSecurityPolicyListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRole
 */
export interface KubeClusterRoleProps {
    /**
     * (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.
     *
     * If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRole#aggregationRule
     */
    readonly aggregationRule?: AggregationRule;
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRole#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Rules holds all the PolicyRules for this ClusterRole.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRole#rules
     */
    readonly rules?: PolicyRule[];
}
/**
 * Converts an object of type 'KubeClusterRoleProps' to JSON representation.
 */
export declare function toJson_KubeClusterRoleProps(obj: KubeClusterRoleProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleBinding references a ClusterRole, but not contain it.
 *
 * It can reference a ClusterRole in the global namespace, and adds who information via Subject.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRoleBinding
 */
export interface KubeClusterRoleBindingProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRoleBinding#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) RoleRef can only reference a ClusterRole in the global namespace.
     *
     * If the RoleRef cannot be resolved, the Authorizer must return an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRoleBinding#roleRef
     */
    readonly roleRef: RoleRef;
    /**
     * (experimental) Subjects holds references to the objects the role applies to.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRoleBinding#subjects
     */
    readonly subjects?: Subject[];
}
/**
 * Converts an object of type 'KubeClusterRoleBindingProps' to JSON representation.
 */
export declare function toJson_KubeClusterRoleBindingProps(obj: KubeClusterRoleBindingProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRoleBindingList
 */
export interface KubeClusterRoleBindingListProps {
    /**
     * (experimental) Items is a list of ClusterRoleBindings.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRoleBindingList#items
     */
    readonly items: KubeClusterRoleBindingProps[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRoleBindingList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeClusterRoleBindingListProps' to JSON representation.
 */
export declare function toJson_KubeClusterRoleBindingListProps(obj: KubeClusterRoleBindingListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleList is a collection of ClusterRoles.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.ClusterRoleList
 */
export interface KubeClusterRoleListProps {
    /**
     * (experimental) Items is a list of ClusterRoles.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRoleList#items
     */
    readonly items: KubeClusterRoleProps[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.ClusterRoleList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeClusterRoleListProps' to JSON representation.
 */
export declare function toJson_KubeClusterRoleListProps(obj: KubeClusterRoleListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.Role
 */
export interface KubeRoleProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.Role#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Rules holds all the PolicyRules for this Role.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.Role#rules
     */
    readonly rules?: PolicyRule[];
}
/**
 * Converts an object of type 'KubeRoleProps' to JSON representation.
 */
export declare function toJson_KubeRoleProps(obj: KubeRoleProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleBinding references a role, but does not contain it.
 *
 * It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.RoleBinding
 */
export interface KubeRoleBindingProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleBinding#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace.
     *
     * If the RoleRef cannot be resolved, the Authorizer must return an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleBinding#roleRef
     */
    readonly roleRef: RoleRef;
    /**
     * (experimental) Subjects holds references to the objects the role applies to.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleBinding#subjects
     */
    readonly subjects?: Subject[];
}
/**
 * Converts an object of type 'KubeRoleBindingProps' to JSON representation.
 */
export declare function toJson_KubeRoleBindingProps(obj: KubeRoleBindingProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleBindingList is a collection of RoleBindings.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.RoleBindingList
 */
export interface KubeRoleBindingListProps {
    /**
     * (experimental) Items is a list of RoleBindings.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleBindingList#items
     */
    readonly items: KubeRoleBindingProps[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleBindingList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRoleBindingListProps' to JSON representation.
 */
export declare function toJson_KubeRoleBindingListProps(obj: KubeRoleBindingListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleList is a collection of Roles.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.RoleList
 */
export interface KubeRoleListProps {
    /**
     * (experimental) Items is a list of Roles.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleList#items
     */
    readonly items: KubeRoleProps[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRoleListProps' to JSON representation.
 */
export declare function toJson_KubeRoleListProps(obj: KubeRoleListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRole, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRole
 */
export interface KubeClusterRoleV1Alpha1Props {
    /**
     * (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.
     *
     * If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRole#aggregationRule
     */
    readonly aggregationRule?: AggregationRuleV1Alpha1;
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRole#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Rules holds all the PolicyRules for this ClusterRole.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRole#rules
     */
    readonly rules?: PolicyRuleV1Alpha1[];
}
/**
 * Converts an object of type 'KubeClusterRoleV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleV1Alpha1Props(obj: KubeClusterRoleV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleBinding references a ClusterRole, but not contain it.
 *
 * It can reference a ClusterRole in the global namespace, and adds who information via Subject. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBinding
 */
export interface KubeClusterRoleBindingV1Alpha1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBinding#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) RoleRef can only reference a ClusterRole in the global namespace.
     *
     * If the RoleRef cannot be resolved, the Authorizer must return an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBinding#roleRef
     */
    readonly roleRef: RoleRefV1Alpha1;
    /**
     * (experimental) Subjects holds references to the objects the role applies to.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBinding#subjects
     */
    readonly subjects?: SubjectV1Alpha1[];
}
/**
 * Converts an object of type 'KubeClusterRoleBindingV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleBindingV1Alpha1Props(obj: KubeClusterRoleBindingV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBindings, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList
 */
export interface KubeClusterRoleBindingListV1Alpha1Props {
    /**
     * (experimental) Items is a list of ClusterRoleBindings.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList#items
     */
    readonly items: KubeClusterRoleBindingV1Alpha1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeClusterRoleBindingListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleBindingListV1Alpha1Props(obj: KubeClusterRoleBindingListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleList is a collection of ClusterRoles.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoles, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleList
 */
export interface KubeClusterRoleListV1Alpha1Props {
    /**
     * (experimental) Items is a list of ClusterRoles.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleList#items
     */
    readonly items: KubeClusterRoleV1Alpha1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.ClusterRoleList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeClusterRoleListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleListV1Alpha1Props(obj: KubeClusterRoleListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 Role, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.Role
 */
export interface KubeRoleV1Alpha1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.Role#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Rules holds all the PolicyRules for this Role.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.Role#rules
     */
    readonly rules?: PolicyRuleV1Alpha1[];
}
/**
 * Converts an object of type 'KubeRoleV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeRoleV1Alpha1Props(obj: KubeRoleV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleBinding references a role, but does not contain it.
 *
 * It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.RoleBinding
 */
export interface KubeRoleBindingV1Alpha1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleBinding#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace.
     *
     * If the RoleRef cannot be resolved, the Authorizer must return an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleBinding#roleRef
     */
    readonly roleRef: RoleRefV1Alpha1;
    /**
     * (experimental) Subjects holds references to the objects the role applies to.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleBinding#subjects
     */
    readonly subjects?: SubjectV1Alpha1[];
}
/**
 * Converts an object of type 'KubeRoleBindingV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeRoleBindingV1Alpha1Props(obj: KubeRoleBindingV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleBindingList is a collection of RoleBindings Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBindingList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.RoleBindingList
 */
export interface KubeRoleBindingListV1Alpha1Props {
    /**
     * (experimental) Items is a list of RoleBindings.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleBindingList#items
     */
    readonly items: KubeRoleBindingV1Alpha1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleBindingList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRoleBindingListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeRoleBindingListV1Alpha1Props(obj: KubeRoleBindingListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleList is a collection of Roles.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.RoleList
 */
export interface KubeRoleListV1Alpha1Props {
    /**
     * (experimental) Items is a list of Roles.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleList#items
     */
    readonly items: KubeRoleV1Alpha1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRoleListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeRoleListV1Alpha1Props(obj: KubeRoleListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRole, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRole
 */
export interface KubeClusterRoleV1Beta1Props {
    /**
     * (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.
     *
     * If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRole#aggregationRule
     */
    readonly aggregationRule?: AggregationRuleV1Beta1;
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRole#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Rules holds all the PolicyRules for this ClusterRole.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRole#rules
     */
    readonly rules?: PolicyRuleV1Beta1[];
}
/**
 * Converts an object of type 'KubeClusterRoleV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleV1Beta1Props(obj: KubeClusterRoleV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleBinding references a ClusterRole, but not contain it.
 *
 * It can reference a ClusterRole in the global namespace, and adds who information via Subject. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBinding
 */
export interface KubeClusterRoleBindingV1Beta1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBinding#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) RoleRef can only reference a ClusterRole in the global namespace.
     *
     * If the RoleRef cannot be resolved, the Authorizer must return an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBinding#roleRef
     */
    readonly roleRef: RoleRefV1Beta1;
    /**
     * (experimental) Subjects holds references to the objects the role applies to.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBinding#subjects
     */
    readonly subjects?: SubjectV1Beta1[];
}
/**
 * Converts an object of type 'KubeClusterRoleBindingV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleBindingV1Beta1Props(obj: KubeClusterRoleBindingV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBindingList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBindingList
 */
export interface KubeClusterRoleBindingListV1Beta1Props {
    /**
     * (experimental) Items is a list of ClusterRoleBindings.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBindingList#items
     */
    readonly items: KubeClusterRoleBindingV1Beta1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRoleBindingList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeClusterRoleBindingListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleBindingListV1Beta1Props(obj: KubeClusterRoleBindingListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ClusterRoleList is a collection of ClusterRoles.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoles, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.ClusterRoleList
 */
export interface KubeClusterRoleListV1Beta1Props {
    /**
     * (experimental) Items is a list of ClusterRoles.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRoleList#items
     */
    readonly items: KubeClusterRoleV1Beta1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.ClusterRoleList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeClusterRoleListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeClusterRoleListV1Beta1Props(obj: KubeClusterRoleListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
 *
 * Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 Role, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.Role
 */
export interface KubeRoleV1Beta1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.Role#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Rules holds all the PolicyRules for this Role.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.Role#rules
     */
    readonly rules?: PolicyRuleV1Beta1[];
}
/**
 * Converts an object of type 'KubeRoleV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeRoleV1Beta1Props(obj: KubeRoleV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleBinding references a role, but does not contain it.
 *
 * It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBinding, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.RoleBinding
 */
export interface KubeRoleBindingV1Beta1Props {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleBinding#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) RoleRef can reference a Role in the current namespace or a ClusterRole in the global namespace.
     *
     * If the RoleRef cannot be resolved, the Authorizer must return an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleBinding#roleRef
     */
    readonly roleRef: RoleRefV1Beta1;
    /**
     * (experimental) Subjects holds references to the objects the role applies to.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleBinding#subjects
     */
    readonly subjects?: SubjectV1Beta1[];
}
/**
 * Converts an object of type 'KubeRoleBindingV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeRoleBindingV1Beta1Props(obj: KubeRoleBindingV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleBindingList is a collection of RoleBindings Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBindingList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.RoleBindingList
 */
export interface KubeRoleBindingListV1Beta1Props {
    /**
     * (experimental) Items is a list of RoleBindings.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleBindingList#items
     */
    readonly items: KubeRoleBindingV1Beta1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleBindingList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRoleBindingListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeRoleBindingListV1Beta1Props(obj: KubeRoleBindingListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleList is a collection of Roles Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleList, and will no longer be served in v1.22.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.RoleList
 */
export interface KubeRoleListV1Beta1Props {
    /**
     * (experimental) Items is a list of Roles.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleList#items
     */
    readonly items: KubeRoleV1Beta1Props[];
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeRoleListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeRoleListV1Beta1Props(obj: KubeRoleListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityClass defines mapping from a priority class name to the priority integer value.
 *
 * The value can be any valid integer.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1.PriorityClass
 */
export interface KubePriorityClassProps {
    /**
     * (experimental) description is an arbitrary string that usually provides guidelines on when this priority class should be used.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1.PriorityClass#description
     */
    readonly description?: string;
    /**
     * (experimental) globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class.
     *
     * Only one PriorityClass can be marked as `globalDefault`. However, if more than one PriorityClasses exists with their `globalDefault` field set to true, the smallest value of such global default PriorityClasses will be used as the default priority.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1.PriorityClass#globalDefault
     */
    readonly globalDefault?: boolean;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1.PriorityClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) PreemptionPolicy is the Policy for preempting pods with lower priority.
     *
     * One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     *
     * @default PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     * @experimental
     * @schema io.k8s.api.scheduling.v1.PriorityClass#preemptionPolicy
     */
    readonly preemptionPolicy?: string;
    /**
     * (experimental) The value of this priority class.
     *
     * This is the actual priority that pods receive when they have the name of this class in their pod spec.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1.PriorityClass#value
     */
    readonly value: number;
}
/**
 * Converts an object of type 'KubePriorityClassProps' to JSON representation.
 */
export declare function toJson_KubePriorityClassProps(obj: KubePriorityClassProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityClassList is a collection of priority classes.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1.PriorityClassList
 */
export interface KubePriorityClassListProps {
    /**
     * (experimental) items is the list of PriorityClasses.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1.PriorityClassList#items
     */
    readonly items: KubePriorityClassProps[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1.PriorityClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePriorityClassListProps' to JSON representation.
 */
export declare function toJson_KubePriorityClassListProps(obj: KubePriorityClassListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1alpha1.PriorityClass
 */
export interface KubePriorityClassV1Alpha1Props {
    /**
     * (experimental) description is an arbitrary string that usually provides guidelines on when this priority class should be used.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1alpha1.PriorityClass#description
     */
    readonly description?: string;
    /**
     * (experimental) globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class.
     *
     * Only one PriorityClass can be marked as `globalDefault`. However, if more than one PriorityClasses exists with their `globalDefault` field set to true, the smallest value of such global default PriorityClasses will be used as the default priority.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1alpha1.PriorityClass#globalDefault
     */
    readonly globalDefault?: boolean;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1alpha1.PriorityClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) PreemptionPolicy is the Policy for preempting pods with lower priority.
     *
     * One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     *
     * @default PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     * @experimental
     * @schema io.k8s.api.scheduling.v1alpha1.PriorityClass#preemptionPolicy
     */
    readonly preemptionPolicy?: string;
    /**
     * (experimental) The value of this priority class.
     *
     * This is the actual priority that pods receive when they have the name of this class in their pod spec.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1alpha1.PriorityClass#value
     */
    readonly value: number;
}
/**
 * Converts an object of type 'KubePriorityClassV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubePriorityClassV1Alpha1Props(obj: KubePriorityClassV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityClassList is a collection of priority classes.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1alpha1.PriorityClassList
 */
export interface KubePriorityClassListV1Alpha1Props {
    /**
     * (experimental) items is the list of PriorityClasses.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1alpha1.PriorityClassList#items
     */
    readonly items: KubePriorityClassV1Alpha1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1alpha1.PriorityClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePriorityClassListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubePriorityClassListV1Alpha1Props(obj: KubePriorityClassListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1beta1.PriorityClass
 */
export interface KubePriorityClassV1Beta1Props {
    /**
     * (experimental) description is an arbitrary string that usually provides guidelines on when this priority class should be used.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1beta1.PriorityClass#description
     */
    readonly description?: string;
    /**
     * (experimental) globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class.
     *
     * Only one PriorityClass can be marked as `globalDefault`. However, if more than one PriorityClasses exists with their `globalDefault` field set to true, the smallest value of such global default PriorityClasses will be used as the default priority.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1beta1.PriorityClass#globalDefault
     */
    readonly globalDefault?: boolean;
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1beta1.PriorityClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) PreemptionPolicy is the Policy for preempting pods with lower priority.
     *
     * One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     *
     * @default PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     * @experimental
     * @schema io.k8s.api.scheduling.v1beta1.PriorityClass#preemptionPolicy
     */
    readonly preemptionPolicy?: string;
    /**
     * (experimental) The value of this priority class.
     *
     * This is the actual priority that pods receive when they have the name of this class in their pod spec.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1beta1.PriorityClass#value
     */
    readonly value: number;
}
/**
 * Converts an object of type 'KubePriorityClassV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePriorityClassV1Beta1Props(obj: KubePriorityClassV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityClassList is a collection of priority classes.
 *
 * @experimental
 * @schema io.k8s.api.scheduling.v1beta1.PriorityClassList
 */
export interface KubePriorityClassListV1Beta1Props {
    /**
     * (experimental) items is the list of PriorityClasses.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1beta1.PriorityClassList#items
     */
    readonly items: KubePriorityClassV1Beta1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.scheduling.v1beta1.PriorityClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubePriorityClassListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubePriorityClassListV1Beta1Props(obj: KubePriorityClassListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.
 *
 * Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSIDriver
 */
export interface KubeCsiDriverProps {
    /**
     * (experimental) Standard object metadata.
     *
     * metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriver#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the CSI Driver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriver#spec
     */
    readonly spec: CsiDriverSpec;
}
/**
 * Converts an object of type 'KubeCsiDriverProps' to JSON representation.
 */
export declare function toJson_KubeCsiDriverProps(obj: KubeCsiDriverProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIDriverList is a collection of CSIDriver objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSIDriverList
 */
export interface KubeCsiDriverListProps {
    /**
     * (experimental) items is the list of CSIDriver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverList#items
     */
    readonly items: KubeCsiDriverProps[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCsiDriverListProps' to JSON representation.
 */
export declare function toJson_KubeCsiDriverListProps(obj: KubeCsiDriverListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSINode holds information about all CSI drivers installed on a node.
 *
 * CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSINode
 */
export interface KubeCsiNodeProps {
    /**
     * (experimental) metadata.name must be the Kubernetes node name.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINode#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec is the specification of CSINode.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINode#spec
     */
    readonly spec: CsiNodeSpec;
}
/**
 * Converts an object of type 'KubeCsiNodeProps' to JSON representation.
 */
export declare function toJson_KubeCsiNodeProps(obj: KubeCsiNodeProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSINodeList is a collection of CSINode objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSINodeList
 */
export interface KubeCsiNodeListProps {
    /**
     * (experimental) items is the list of CSINode.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINodeList#items
     */
    readonly items: KubeCsiNodeProps[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINodeList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCsiNodeListProps' to JSON representation.
 */
export declare function toJson_KubeCsiNodeListProps(obj: KubeCsiNodeListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
 *
 * StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.StorageClass
 */
export interface KubeStorageClassProps {
    /**
     * (experimental) AllowVolumeExpansion shows whether the storage class allow volume expand.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#allowVolumeExpansion
     */
    readonly allowVolumeExpansion?: boolean;
    /**
     * (experimental) Restrict the node topologies where volumes can be dynamically provisioned.
     *
     * Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#allowedTopologies
     */
    readonly allowedTopologies?: TopologySelectorTerm[];
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#mountOptions
     */
    readonly mountOptions?: string[];
    /**
     * (experimental) Parameters holds the parameters for the provisioner that should create volumes of this storage class.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#parameters
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * (experimental) Provisioner indicates the type of the provisioner.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#provisioner
     */
    readonly provisioner: string;
    /**
     * (experimental) Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy.
     *
     * Defaults to Delete.
     *
     * @default Delete.
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#reclaimPolicy
     */
    readonly reclaimPolicy?: string;
    /**
     * (experimental) VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.
     *
     * When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClass#volumeBindingMode
     */
    readonly volumeBindingMode?: string;
}
/**
 * Converts an object of type 'KubeStorageClassProps' to JSON representation.
 */
export declare function toJson_KubeStorageClassProps(obj: KubeStorageClassProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) StorageClassList is a collection of storage classes.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.StorageClassList
 */
export interface KubeStorageClassListProps {
    /**
     * (experimental) Items is the list of StorageClasses.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClassList#items
     */
    readonly items: KubeStorageClassProps[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.StorageClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeStorageClassListProps' to JSON representation.
 */
export declare function toJson_KubeStorageClassListProps(obj: KubeStorageClassListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
 *
 * VolumeAttachment objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.VolumeAttachment
 */
export interface KubeVolumeAttachmentProps {
    /**
     * (experimental) Standard object metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachment#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired attach/detach volume behavior.
     *
     * Populated by the Kubernetes system.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachment#spec
     */
    readonly spec: VolumeAttachmentSpec;
}
/**
 * Converts an object of type 'KubeVolumeAttachmentProps' to JSON representation.
 */
export declare function toJson_KubeVolumeAttachmentProps(obj: KubeVolumeAttachmentProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentList is a collection of VolumeAttachment objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.VolumeAttachmentList
 */
export interface KubeVolumeAttachmentListProps {
    /**
     * (experimental) Items is the list of VolumeAttachments.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachmentList#items
     */
    readonly items: KubeVolumeAttachmentProps[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachmentList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeVolumeAttachmentListProps' to JSON representation.
 */
export declare function toJson_KubeVolumeAttachmentListProps(obj: KubeVolumeAttachmentListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIStorageCapacity stores the result of one CSI GetCapacity call.
 *
 * For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.
 *
 * For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"
 *
 * The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero
 *
 * The producer of these objects can decide which approach is more suitable.
 *
 * They are consumed by the kube-scheduler if the CSIStorageCapacity beta feature gate is enabled there and a CSI driver opts into capacity-aware scheduling with CSIDriver.StorageCapacity.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacity
 */
export interface KubeCsiStorageCapacityV1Alpha1Props {
    /**
     * (experimental) Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.
     *
     * The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable and treated like zero capacity.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacity#capacity
     */
    readonly capacity?: Quantity;
    /**
     * (experimental) MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.
     *
     * This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacity#maximumVolumeSize
     */
    readonly maximumVolumeSize?: Quantity;
    /**
     * (experimental) Standard object's metadata.
     *
     * The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-<uuid>, a generated name, or a reverse-domain name which ends with the unique CSI driver name.
     *
     * Objects are namespaced.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacity#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) NodeTopology defines which nodes have access to the storage for which capacity was reported.
     *
     * If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacity#nodeTopology
     */
    readonly nodeTopology?: LabelSelector;
    /**
     * (experimental) The name of the StorageClass that the reported capacity applies to.
     *
     * It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacity#storageClassName
     */
    readonly storageClassName: string;
}
/**
 * Converts an object of type 'KubeCsiStorageCapacityV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeCsiStorageCapacityV1Alpha1Props(obj: KubeCsiStorageCapacityV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIStorageCapacityList is a collection of CSIStorageCapacity objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacityList
 */
export interface KubeCsiStorageCapacityListV1Alpha1Props {
    /**
     * (experimental) Items is the list of CSIStorageCapacity objects.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacityList#items
     */
    readonly items: KubeCsiStorageCapacityV1Alpha1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.CSIStorageCapacityList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCsiStorageCapacityListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeCsiStorageCapacityListV1Alpha1Props(obj: KubeCsiStorageCapacityListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
 *
 * VolumeAttachment objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.VolumeAttachment
 */
export interface KubeVolumeAttachmentV1Alpha1Props {
    /**
     * (experimental) Standard object metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachment#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired attach/detach volume behavior.
     *
     * Populated by the Kubernetes system.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachment#spec
     */
    readonly spec: VolumeAttachmentSpecV1Alpha1;
}
/**
 * Converts an object of type 'KubeVolumeAttachmentV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeVolumeAttachmentV1Alpha1Props(obj: KubeVolumeAttachmentV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentList is a collection of VolumeAttachment objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentList
 */
export interface KubeVolumeAttachmentListV1Alpha1Props {
    /**
     * (experimental) Items is the list of VolumeAttachments.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentList#items
     */
    readonly items: KubeVolumeAttachmentV1Alpha1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeVolumeAttachmentListV1Alpha1Props' to JSON representation.
 */
export declare function toJson_KubeVolumeAttachmentListV1Alpha1Props(obj: KubeVolumeAttachmentListV1Alpha1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.
 *
 * CSI drivers do not need to create the CSIDriver object directly. Instead they may use the cluster-driver-registrar sidecar container. When deployed with a CSI driver it automatically creates a CSIDriver object representing the driver. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIDriver
 */
export interface KubeCsiDriverV1Beta1Props {
    /**
     * (experimental) Standard object metadata.
     *
     * metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriver#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the CSI Driver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriver#spec
     */
    readonly spec: CsiDriverSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeCsiDriverV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCsiDriverV1Beta1Props(obj: KubeCsiDriverV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIDriverList is a collection of CSIDriver objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIDriverList
 */
export interface KubeCsiDriverListV1Beta1Props {
    /**
     * (experimental) items is the list of CSIDriver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverList#items
     */
    readonly items: KubeCsiDriverV1Beta1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCsiDriverListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCsiDriverListV1Beta1Props(obj: KubeCsiDriverListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) DEPRECATED - This group version of CSINode is deprecated by storage/v1/CSINode.
 *
 * See the release notes for more information. CSINode holds information about all CSI drivers installed on a node. CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSINode
 */
export interface KubeCsiNodeV1Beta1Props {
    /**
     * (experimental) metadata.name must be the Kubernetes node name.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINode#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec is the specification of CSINode.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINode#spec
     */
    readonly spec: CsiNodeSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeCsiNodeV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCsiNodeV1Beta1Props(obj: KubeCsiNodeV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSINodeList is a collection of CSINode objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSINodeList
 */
export interface KubeCsiNodeListV1Beta1Props {
    /**
     * (experimental) items is the list of CSINode.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINodeList#items
     */
    readonly items: KubeCsiNodeV1Beta1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINodeList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCsiNodeListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCsiNodeListV1Beta1Props(obj: KubeCsiNodeListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIStorageCapacity stores the result of one CSI GetCapacity call.
 *
 * For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.
 *
 * For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"
 *
 * The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero
 *
 * The producer of these objects can decide which approach is more suitable.
 *
 * They are consumed by the kube-scheduler if the CSIStorageCapacity beta feature gate is enabled there and a CSI driver opts into capacity-aware scheduling with CSIDriver.StorageCapacity.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacity
 */
export interface KubeCsiStorageCapacityV1Beta1Props {
    /**
     * (experimental) Capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.
     *
     * The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable and treated like zero capacity.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacity#capacity
     */
    readonly capacity?: Quantity;
    /**
     * (experimental) MaximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.
     *
     * This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacity#maximumVolumeSize
     */
    readonly maximumVolumeSize?: Quantity;
    /**
     * (experimental) Standard object's metadata.
     *
     * The name has no particular meaning. It must be be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-<uuid>, a generated name, or a reverse-domain name which ends with the unique CSI driver name.
     *
     * Objects are namespaced.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacity#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) NodeTopology defines which nodes have access to the storage for which capacity was reported.
     *
     * If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacity#nodeTopology
     */
    readonly nodeTopology?: LabelSelector;
    /**
     * (experimental) The name of the StorageClass that the reported capacity applies to.
     *
     * It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacity#storageClassName
     */
    readonly storageClassName: string;
}
/**
 * Converts an object of type 'KubeCsiStorageCapacityV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCsiStorageCapacityV1Beta1Props(obj: KubeCsiStorageCapacityV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIStorageCapacityList is a collection of CSIStorageCapacity objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacityList
 */
export interface KubeCsiStorageCapacityListV1Beta1Props {
    /**
     * (experimental) Items is the list of CSIStorageCapacity objects.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacityList#items
     */
    readonly items: KubeCsiStorageCapacityV1Beta1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIStorageCapacityList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCsiStorageCapacityListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCsiStorageCapacityListV1Beta1Props(obj: KubeCsiStorageCapacityListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.
 *
 * StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.StorageClass
 */
export interface KubeStorageClassV1Beta1Props {
    /**
     * (experimental) AllowVolumeExpansion shows whether the storage class allow volume expand.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#allowVolumeExpansion
     */
    readonly allowVolumeExpansion?: boolean;
    /**
     * (experimental) Restrict the node topologies where volumes can be dynamically provisioned.
     *
     * Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#allowedTopologies
     */
    readonly allowedTopologies?: TopologySelectorTerm[];
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#mountOptions
     */
    readonly mountOptions?: string[];
    /**
     * (experimental) Parameters holds the parameters for the provisioner that should create volumes of this storage class.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#parameters
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * (experimental) Provisioner indicates the type of the provisioner.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#provisioner
     */
    readonly provisioner: string;
    /**
     * (experimental) Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy.
     *
     * Defaults to Delete.
     *
     * @default Delete.
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#reclaimPolicy
     */
    readonly reclaimPolicy?: string;
    /**
     * (experimental) VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.
     *
     * When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClass#volumeBindingMode
     */
    readonly volumeBindingMode?: string;
}
/**
 * Converts an object of type 'KubeStorageClassV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeStorageClassV1Beta1Props(obj: KubeStorageClassV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) StorageClassList is a collection of storage classes.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.StorageClassList
 */
export interface KubeStorageClassListV1Beta1Props {
    /**
     * (experimental) Items is the list of StorageClasses.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClassList#items
     */
    readonly items: KubeStorageClassV1Beta1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.StorageClassList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeStorageClassListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeStorageClassListV1Beta1Props(obj: KubeStorageClassListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.
 *
 * VolumeAttachment objects are non-namespaced.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.VolumeAttachment
 */
export interface KubeVolumeAttachmentV1Beta1Props {
    /**
     * (experimental) Standard object metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachment#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired attach/detach volume behavior.
     *
     * Populated by the Kubernetes system.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachment#spec
     */
    readonly spec: VolumeAttachmentSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeVolumeAttachmentV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeVolumeAttachmentV1Beta1Props(obj: KubeVolumeAttachmentV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentList is a collection of VolumeAttachment objects.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentList
 */
export interface KubeVolumeAttachmentListV1Beta1Props {
    /**
     * (experimental) Items is the list of VolumeAttachments.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentList#items
     */
    readonly items: KubeVolumeAttachmentV1Beta1Props[];
    /**
     * (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeVolumeAttachmentListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeVolumeAttachmentListV1Beta1Props(obj: KubeVolumeAttachmentListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinition represents a resource that should be exposed on the API server.
 *
 * Its name MUST be in the format <.spec.name>.<.spec.group>.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition
 */
export interface KubeCustomResourceDefinitionProps {
    /**
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec describes how the user wants the resources to appear.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition#spec
     */
    readonly spec: CustomResourceDefinitionSpec;
}
/**
 * Converts an object of type 'KubeCustomResourceDefinitionProps' to JSON representation.
 */
export declare function toJson_KubeCustomResourceDefinitionProps(obj: KubeCustomResourceDefinitionProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList
 */
export interface KubeCustomResourceDefinitionListProps {
    /**
     * (experimental) items list individual CustomResourceDefinition objects.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList#items
     */
    readonly items: KubeCustomResourceDefinitionProps[];
    /**
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCustomResourceDefinitionListProps' to JSON representation.
 */
export declare function toJson_KubeCustomResourceDefinitionListProps(obj: KubeCustomResourceDefinitionListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinition represents a resource that should be exposed on the API server.
 *
 * Its name MUST be in the format <.spec.name>.<.spec.group>. Deprecated in v1.16, planned for removal in v1.22. Use apiextensions.k8s.io/v1 CustomResourceDefinition instead.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition
 */
export interface KubeCustomResourceDefinitionV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) spec describes how the user wants the resources to appear.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition#spec
     */
    readonly spec: CustomResourceDefinitionSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeCustomResourceDefinitionV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCustomResourceDefinitionV1Beta1Props(obj: KubeCustomResourceDefinitionV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList
 */
export interface KubeCustomResourceDefinitionListV1Beta1Props {
    /**
     * (experimental) items list individual CustomResourceDefinition objects.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList#items
     */
    readonly items: KubeCustomResourceDefinitionV1Beta1Props[];
    /**
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeCustomResourceDefinitionListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeCustomResourceDefinitionListV1Beta1Props(obj: KubeCustomResourceDefinitionListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) Status is a return value for calls that don't return other objects.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Status
 */
export interface KubeStatusProps {
    /**
     * (experimental) Suggested HTTP return code for this status, 0 if not set.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Status#code
     */
    readonly code?: number;
    /**
     * (experimental) Extended data associated with the reason.
     *
     * Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Status#details
     */
    readonly details?: StatusDetails;
    /**
     * (experimental) A human-readable description of the status of this operation.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Status#message
     */
    readonly message?: string;
    /**
     * (experimental) Standard list metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Status#metadata
     */
    readonly metadata?: ListMeta;
    /**
     * (experimental) A machine-readable description of why this operation is in the "Failure" status.
     *
     * If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Status#reason
     */
    readonly reason?: string;
}
/**
 * Converts an object of type 'KubeStatusProps' to JSON representation.
 */
export declare function toJson_KubeStatusProps(obj: KubeStatusProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) APIService represents a server for a particular GroupVersion.
 *
 * Name must be "version.group".
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
 */
export interface KubeApiServiceProps {
    /**
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec contains information for locating and communicating with a server.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#spec
     */
    readonly spec?: ApiServiceSpec;
}
/**
 * Converts an object of type 'KubeApiServiceProps' to JSON representation.
 */
export declare function toJson_KubeApiServiceProps(obj: KubeApiServiceProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) APIServiceList is a list of APIService objects.
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
 */
export interface KubeApiServiceListProps {
    /**
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#items
     */
    readonly items: KubeApiServiceProps[];
    /**
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeApiServiceListProps' to JSON representation.
 */
export declare function toJson_KubeApiServiceListProps(obj: KubeApiServiceListProps | undefined): Record<string, any> | undefined;
/**
 * (experimental) APIService represents a server for a particular GroupVersion.
 *
 * Name must be "version.group".
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService
 */
export interface KubeApiServiceV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Spec contains information for locating and communicating with a server.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService#spec
     */
    readonly spec?: ApiServiceSpecV1Beta1;
}
/**
 * Converts an object of type 'KubeApiServiceV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeApiServiceV1Beta1Props(obj: KubeApiServiceV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) APIServiceList is a list of APIService objects.
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList
 */
export interface KubeApiServiceListV1Beta1Props {
    /**
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList#items
     */
    readonly items: KubeApiServiceV1Beta1Props[];
    /**
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList#metadata
     */
    readonly metadata?: ListMeta;
}
/**
 * Converts an object of type 'KubeApiServiceListV1Beta1Props' to JSON representation.
 */
export declare function toJson_KubeApiServiceListV1Beta1Props(obj: KubeApiServiceListV1Beta1Props | undefined): Record<string, any> | undefined;
/**
 * (experimental) ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
 */
export interface ObjectMeta {
    /**
     * (experimental) Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * (experimental) The name of the cluster which the object belongs to.
     *
     * This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#clusterName
     */
    readonly clusterName?: string;
    /**
     * (experimental) CreationTimestamp is a timestamp representing the server time when this object was created.
     *
     * It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.
     *
     * Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#creationTimestamp
     */
    readonly creationTimestamp?: Date;
    /**
     * (experimental) Number of seconds allowed for this object to gracefully terminate before it will be removed from the system.
     *
     * Only set when deletionTimestamp is also set. May only be shortened. Read-only.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#deletionGracePeriodSeconds
     */
    readonly deletionGracePeriodSeconds?: number;
    /**
     * (experimental) DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted.
     *
     * This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.
     *
     * Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#deletionTimestamp
     */
    readonly deletionTimestamp?: Date;
    /**
     * (experimental) Must be empty before the object is deleted from the registry.
     *
     * Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#finalizers
     */
    readonly finalizers?: string[];
    /**
     * (experimental) GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided.
     *
     * If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.
     *
     * If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header).
     *
     * Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#generateName
     */
    readonly generateName?: string;
    /**
     * (experimental) A sequence number representing a specific generation of the desired state.
     *
     * Populated by the system. Read-only.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#generation
     */
    readonly generation?: number;
    /**
     * (experimental) Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * (experimental) ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow.
     *
     * This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#managedFields
     */
    readonly managedFields?: ManagedFieldsEntry[];
    /**
     * (experimental) Name must be unique within a namespace.
     *
     * Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#name
     */
    readonly name?: string;
    /**
     * (experimental) Namespace defines the space within which each name must be unique.
     *
     * An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.
     *
     * Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#namespace
     */
    readonly namespace?: string;
    /**
     * (experimental) List of objects depended by this object.
     *
     * If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#ownerReferences
     */
    readonly ownerReferences?: OwnerReference[];
    /**
     * (experimental) An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed.
     *
     * May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.
     *
     * Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#resourceVersion
     */
    readonly resourceVersion?: string;
    /**
     * (experimental) SelfLink is a URL representing this object. Populated by the system. Read-only.
     *
     * DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#selfLink
     */
    readonly selfLink?: string;
    /**
     * (experimental) UID is the unique in time and space value for this object.
     *
     * It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.
     *
     * Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta#uid
     */
    readonly uid?: string;
}
/**
 * Converts an object of type 'ObjectMeta' to JSON representation.
 */
export declare function toJson_ObjectMeta(obj: ObjectMeta | undefined): Record<string, any> | undefined;
/**
 * (experimental) MutatingWebhook describes an admission webhook and the resources and operations it applies to.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook
 */
export interface MutatingWebhook {
    /**
     * (experimental) AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects.
     *
     * API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#admissionReviewVersions
     */
    readonly admissionReviewVersions: string[];
    /**
     * (experimental) ClientConfig defines how to communicate with the hook.
     *
     * Required
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#clientConfig
     */
    readonly clientConfig: WebhookClientConfig;
    /**
     * (experimental) FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail.
     *
     * Defaults to Fail.
     *
     * @default Fail.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#failurePolicy
     */
    readonly failurePolicy?: string;
    /**
     * (experimental) matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
     *
     * - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
     *
     * - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
     *
     * Defaults to "Equivalent"
     *
     * @default Equivalent"
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#matchPolicy
     */
    readonly matchPolicy?: string;
    /**
     * (experimental) The name of the admission webhook.
     *
     * Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#name
     */
    readonly name: string;
    /**
     * (experimental) NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector.
     *
     * If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
     *
     * For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "runlevel",
     * "operator": "NotIn",
     * "values": [
     * "0",
     * "1"
     * ]
     * }
     * ]
     * }
     *
     * If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "environment",
     * "operator": "In",
     * "values": [
     * "prod",
     * "staging"
     * ]
     * }
     * ]
     * }
     *
     * See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
     *
     * Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#namespaceSelector
     */
    readonly namespaceSelector?: LabelSelector;
    /**
     * (experimental) ObjectSelector decides whether to run the webhook based on if the object has matching labels.
     *
     * objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#objectSelector
     */
    readonly objectSelector?: LabelSelector;
    /**
     * (experimental) reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation.
     *
     * Allowed values are "Never" and "IfNeeded".
     *
     * Never: the webhook will not be called more than once in a single admission evaluation.
     *
     * IfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.
     *
     * Defaults to "Never".
     *
     * @default Never".
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#reinvocationPolicy
     */
    readonly reinvocationPolicy?: string;
    /**
     * (experimental) Rules describes what operations on what resources/subresources the webhook cares about.
     *
     * The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#rules
     */
    readonly rules?: RuleWithOperations[];
    /**
     * (experimental) SideEffects states whether this webhook has side effects.
     *
     * Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#sideEffects
     */
    readonly sideEffects: string;
    /**
     * (experimental) TimeoutSeconds specifies the timeout for this webhook.
     *
     * After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.
     *
     * @default 10 seconds.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.MutatingWebhook#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'MutatingWebhook' to JSON representation.
 */
export declare function toJson_MutatingWebhook(obj: MutatingWebhook | undefined): Record<string, any> | undefined;
/**
 * (experimental) ListMeta describes metadata that synthetic resources must have, including lists and various status objects.
 *
 * A resource may have only one of {ObjectMeta, ListMeta}.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta
 */
export interface ListMeta {
    /**
     * (experimental) continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available.
     *
     * The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta#continue
     */
    readonly continue?: string;
    /**
     * (experimental) remainingItemCount is the number of subsequent items in the list which are not included in this list response.
     *
     * If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta#remainingItemCount
     */
    readonly remainingItemCount?: number;
    /**
     * (experimental) String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed.
     *
     * Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta#resourceVersion
     */
    readonly resourceVersion?: string;
    /**
     * (experimental) selfLink is a URL representing this object. Populated by the system. Read-only.
     *
     * DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta#selfLink
     */
    readonly selfLink?: string;
}
/**
 * Converts an object of type 'ListMeta' to JSON representation.
 */
export declare function toJson_ListMeta(obj: ListMeta | undefined): Record<string, any> | undefined;
/**
 * (experimental) ValidatingWebhook describes an admission webhook and the resources and operations it applies to.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook
 */
export interface ValidatingWebhook {
    /**
     * (experimental) AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects.
     *
     * API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#admissionReviewVersions
     */
    readonly admissionReviewVersions: string[];
    /**
     * (experimental) ClientConfig defines how to communicate with the hook.
     *
     * Required
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#clientConfig
     */
    readonly clientConfig: WebhookClientConfig;
    /**
     * (experimental) FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail.
     *
     * Defaults to Fail.
     *
     * @default Fail.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#failurePolicy
     */
    readonly failurePolicy?: string;
    /**
     * (experimental) matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
     *
     * - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
     *
     * - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
     *
     * Defaults to "Equivalent"
     *
     * @default Equivalent"
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#matchPolicy
     */
    readonly matchPolicy?: string;
    /**
     * (experimental) The name of the admission webhook.
     *
     * Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#name
     */
    readonly name: string;
    /**
     * (experimental) NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector.
     *
     * If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
     *
     * For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "runlevel",
     * "operator": "NotIn",
     * "values": [
     * "0",
     * "1"
     * ]
     * }
     * ]
     * }
     *
     * If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "environment",
     * "operator": "In",
     * "values": [
     * "prod",
     * "staging"
     * ]
     * }
     * ]
     * }
     *
     * See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.
     *
     * Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#namespaceSelector
     */
    readonly namespaceSelector?: LabelSelector;
    /**
     * (experimental) ObjectSelector decides whether to run the webhook based on if the object has matching labels.
     *
     * objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#objectSelector
     */
    readonly objectSelector?: LabelSelector;
    /**
     * (experimental) Rules describes what operations on what resources/subresources the webhook cares about.
     *
     * The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#rules
     */
    readonly rules?: RuleWithOperations[];
    /**
     * (experimental) SideEffects states whether this webhook has side effects.
     *
     * Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#sideEffects
     */
    readonly sideEffects: string;
    /**
     * (experimental) TimeoutSeconds specifies the timeout for this webhook.
     *
     * After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.
     *
     * @default 10 seconds.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.ValidatingWebhook#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'ValidatingWebhook' to JSON representation.
 */
export declare function toJson_ValidatingWebhook(obj: ValidatingWebhook | undefined): Record<string, any> | undefined;
/**
 * (experimental) MutatingWebhook describes an admission webhook and the resources and operations it applies to.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook
 */
export interface MutatingWebhookV1Beta1 {
    /**
     * (experimental) AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects.
     *
     * API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
     *
     * @default v1beta1']`.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#admissionReviewVersions
     */
    readonly admissionReviewVersions?: string[];
    /**
     * (experimental) ClientConfig defines how to communicate with the hook.
     *
     * Required
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#clientConfig
     */
    readonly clientConfig: WebhookClientConfigV1Beta1;
    /**
     * (experimental) FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail.
     *
     * Defaults to Ignore.
     *
     * @default Ignore.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#failurePolicy
     */
    readonly failurePolicy?: string;
    /**
     * (experimental) matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
     *
     * - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
     *
     * - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
     *
     * Defaults to "Exact"
     *
     * @default Exact"
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#matchPolicy
     */
    readonly matchPolicy?: string;
    /**
     * (experimental) The name of the admission webhook.
     *
     * Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#name
     */
    readonly name: string;
    /**
     * (experimental) NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector.
     *
     * If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
     *
     * For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "runlevel",
     * "operator": "NotIn",
     * "values": [
     * "0",
     * "1"
     * ]
     * }
     * ]
     * }
     *
     * If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "environment",
     * "operator": "In",
     * "values": [
     * "prod",
     * "staging"
     * ]
     * }
     * ]
     * }
     *
     * See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.
     *
     * Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#namespaceSelector
     */
    readonly namespaceSelector?: LabelSelector;
    /**
     * (experimental) ObjectSelector decides whether to run the webhook based on if the object has matching labels.
     *
     * objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#objectSelector
     */
    readonly objectSelector?: LabelSelector;
    /**
     * (experimental) reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation.
     *
     * Allowed values are "Never" and "IfNeeded".
     *
     * Never: the webhook will not be called more than once in a single admission evaluation.
     *
     * IfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.
     *
     * Defaults to "Never".
     *
     * @default Never".
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#reinvocationPolicy
     */
    readonly reinvocationPolicy?: string;
    /**
     * (experimental) Rules describes what operations on what resources/subresources the webhook cares about.
     *
     * The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#rules
     */
    readonly rules?: RuleWithOperationsV1Beta1[];
    /**
     * (experimental) SideEffects states whether this webhook has side effects.
     *
     * Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
     *
     * @default Unknown.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#sideEffects
     */
    readonly sideEffects?: string;
    /**
     * (experimental) TimeoutSeconds specifies the timeout for this webhook.
     *
     * After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
     *
     * @default 30 seconds.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.MutatingWebhook#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'MutatingWebhookV1Beta1' to JSON representation.
 */
export declare function toJson_MutatingWebhookV1Beta1(obj: MutatingWebhookV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) ValidatingWebhook describes an admission webhook and the resources and operations it applies to.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook
 */
export interface ValidatingWebhookV1Beta1 {
    /**
     * (experimental) AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects.
     *
     * API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.
     *
     * @default v1beta1']`.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#admissionReviewVersions
     */
    readonly admissionReviewVersions?: string[];
    /**
     * (experimental) ClientConfig defines how to communicate with the hook.
     *
     * Required
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#clientConfig
     */
    readonly clientConfig: WebhookClientConfigV1Beta1;
    /**
     * (experimental) FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail.
     *
     * Defaults to Ignore.
     *
     * @default Ignore.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#failurePolicy
     */
    readonly failurePolicy?: string;
    /**
     * (experimental) matchPolicy defines how the "rules" list is used to match incoming requests. Allowed values are "Exact" or "Equivalent".
     *
     * - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.
     *
     * - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and "rules" only included `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.
     *
     * Defaults to "Exact"
     *
     * @default Exact"
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#matchPolicy
     */
    readonly matchPolicy?: string;
    /**
     * (experimental) The name of the admission webhook.
     *
     * Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where "imagepolicy" is the name of the webhook, and kubernetes.io is the name of the organization. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#name
     */
    readonly name: string;
    /**
     * (experimental) NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector.
     *
     * If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.
     *
     * For example, to run the webhook on any objects whose namespace is not associated with "runlevel" of "0" or "1";  you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "runlevel",
     * "operator": "NotIn",
     * "values": [
     * "0",
     * "1"
     * ]
     * }
     * ]
     * }
     *
     * If instead you want to only run the webhook on any objects whose namespace is associated with the "environment" of "prod" or "staging"; you will set the selector as follows: "namespaceSelector": {
     * "matchExpressions": [
     * {
     * "key": "environment",
     * "operator": "In",
     * "values": [
     * "prod",
     * "staging"
     * ]
     * }
     * ]
     * }
     *
     * See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.
     *
     * Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#namespaceSelector
     */
    readonly namespaceSelector?: LabelSelector;
    /**
     * (experimental) ObjectSelector decides whether to run the webhook based on if the object has matching labels.
     *
     * objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.
     *
     * @default the empty LabelSelector, which matches everything.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#objectSelector
     */
    readonly objectSelector?: LabelSelector;
    /**
     * (experimental) Rules describes what operations on what resources/subresources the webhook cares about.
     *
     * The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#rules
     */
    readonly rules?: RuleWithOperationsV1Beta1[];
    /**
     * (experimental) SideEffects states whether this webhook has side effects.
     *
     * Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.
     *
     * @default Unknown.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#sideEffects
     */
    readonly sideEffects?: string;
    /**
     * (experimental) TimeoutSeconds specifies the timeout for this webhook.
     *
     * After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.
     *
     * @default 30 seconds.
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.ValidatingWebhook#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'ValidatingWebhookV1Beta1' to JSON representation.
 */
export declare function toJson_ValidatingWebhookV1Beta1(obj: ValidatingWebhookV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) DaemonSetSpec is the specification of a daemon set.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DaemonSetSpec
 */
export interface DaemonSetSpec {
    /**
     * (experimental) The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available.
     *
     * Defaults to 0 (pod will be considered available as soon as it is ready).
     *
     * @default 0 (pod will be considered available as soon as it is ready).
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetSpec#minReadySeconds
     */
    readonly minReadySeconds?: number;
    /**
     * (experimental) The number of old history to retain to allow rollback.
     *
     * This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
     *
     * @default 10.
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetSpec#revisionHistoryLimit
     */
    readonly revisionHistoryLimit?: number;
    /**
     * (experimental) A label query over pods that are managed by the daemon set.
     *
     * Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetSpec#selector
     */
    readonly selector: LabelSelector;
    /**
     * (experimental) An object that describes the pod that will be created.
     *
     * The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetSpec#template
     */
    readonly template: PodTemplateSpec;
    /**
     * (experimental) An update strategy to replace existing DaemonSet pods with new pods.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetSpec#updateStrategy
     */
    readonly updateStrategy?: DaemonSetUpdateStrategy;
}
/**
 * Converts an object of type 'DaemonSetSpec' to JSON representation.
 */
export declare function toJson_DaemonSetSpec(obj: DaemonSetSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) DeploymentSpec is the specification of the desired behavior of the Deployment.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DeploymentSpec
 */
export interface DeploymentSpec {
    /**
     * (experimental) Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.
     *
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     *
     * @default 0 (pod will be considered available as soon as it is ready)
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#minReadySeconds
     */
    readonly minReadySeconds?: number;
    /**
     * (experimental) Indicates that the deployment is paused.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#paused
     */
    readonly paused?: boolean;
    /**
     * (experimental) The maximum time in seconds for a deployment to make progress before it is considered to be failed.
     *
     * The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
     *
     * @default 600s.
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#progressDeadlineSeconds
     */
    readonly progressDeadlineSeconds?: number;
    /**
     * (experimental) Number of desired pods.
     *
     * This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
     *
     * @default 1.
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#replicas
     */
    readonly replicas?: number;
    /**
     * (experimental) The number of old ReplicaSets to retain to allow rollback.
     *
     * This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
     *
     * @default 10.
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#revisionHistoryLimit
     */
    readonly revisionHistoryLimit?: number;
    /**
     * (experimental) Label selector for pods.
     *
     * Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#selector
     */
    readonly selector: LabelSelector;
    /**
     * (experimental) The deployment strategy to use to replace existing pods with new ones.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#strategy
     */
    readonly strategy?: DeploymentStrategy;
    /**
     * (experimental) Template describes the pods that will be created.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentSpec#template
     */
    readonly template: PodTemplateSpec;
}
/**
 * Converts an object of type 'DeploymentSpec' to JSON representation.
 */
export declare function toJson_DeploymentSpec(obj: DeploymentSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) ReplicaSetSpec is the specification of a ReplicaSet.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.ReplicaSetSpec
 */
export interface ReplicaSetSpec {
    /**
     * (experimental) Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.
     *
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     *
     * @default 0 (pod will be considered available as soon as it is ready)
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSetSpec#minReadySeconds
     */
    readonly minReadySeconds?: number;
    /**
     * (experimental) Replicas is the number of desired replicas.
     *
     * This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     *
     * @default 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSetSpec#replicas
     */
    readonly replicas?: number;
    /**
     * (experimental) Selector is a label query over pods that should match the replica count.
     *
     * Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSetSpec#selector
     */
    readonly selector: LabelSelector;
    /**
     * (experimental) Template is the object that describes the pod that will be created if insufficient replicas are detected.
     *
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.ReplicaSetSpec#template
     */
    readonly template?: PodTemplateSpec;
}
/**
 * Converts an object of type 'ReplicaSetSpec' to JSON representation.
 */
export declare function toJson_ReplicaSetSpec(obj: ReplicaSetSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) A StatefulSetSpec is the specification of a StatefulSet.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.StatefulSetSpec
 */
export interface StatefulSetSpec {
    /**
     * (experimental) podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down.
     *
     * The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#podManagementPolicy
     */
    readonly podManagementPolicy?: string;
    /**
     * (experimental) replicas is the desired number of replicas of the given Template.
     *
     * These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#replicas
     */
    readonly replicas?: number;
    /**
     * (experimental) revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history.
     *
     * The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#revisionHistoryLimit
     */
    readonly revisionHistoryLimit?: number;
    /**
     * (experimental) selector is a label query over pods that should match the replica count.
     *
     * It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#selector
     */
    readonly selector: LabelSelector;
    /**
     * (experimental) serviceName is the name of the service that governs this StatefulSet.
     *
     * This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#serviceName
     */
    readonly serviceName: string;
    /**
     * (experimental) template is the object that describes the pod that will be created if insufficient replicas are detected.
     *
     * Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#template
     */
    readonly template: PodTemplateSpec;
    /**
     * (experimental) updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#updateStrategy
     */
    readonly updateStrategy?: StatefulSetUpdateStrategy;
    /**
     * (experimental) volumeClaimTemplates is a list of claims that pods are allowed to reference.
     *
     * The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetSpec#volumeClaimTemplates
     */
    readonly volumeClaimTemplates?: KubePersistentVolumeClaimProps[];
}
/**
 * Converts an object of type 'StatefulSetSpec' to JSON representation.
 */
export declare function toJson_StatefulSetSpec(obj: StatefulSetSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenRequestSpec contains client provided parameters of a token request.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1.TokenRequestSpec
 */
export interface TokenRequestSpec {
    /**
     * (experimental) Audiences are the intendend audiences of the token.
     *
     * A recipient of a token must identitfy themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenRequestSpec#audiences
     */
    readonly audiences: string[];
    /**
     * (experimental) BoundObjectRef is a reference to an object that the token will be bound to.
     *
     * The token will only be valid for as long as the bound object exists. NOTE: The API server's TokenReview endpoint will validate the BoundObjectRef, but other audiences may not. Keep ExpirationSeconds small if you want prompt revocation.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenRequestSpec#boundObjectRef
     */
    readonly boundObjectRef?: BoundObjectReference;
    /**
     * (experimental) ExpirationSeconds is the requested duration of validity of the request.
     *
     * The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenRequestSpec#expirationSeconds
     */
    readonly expirationSeconds?: number;
}
/**
 * Converts an object of type 'TokenRequestSpec' to JSON representation.
 */
export declare function toJson_TokenRequestSpec(obj: TokenRequestSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenReviewSpec is a description of the token authentication request.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1.TokenReviewSpec
 */
export interface TokenReviewSpec {
    /**
     * (experimental) Audiences is a list of the identifiers that the resource server presented with the token identifies as.
     *
     * Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenReviewSpec#audiences
     */
    readonly audiences?: string[];
    /**
     * (experimental) Token is the opaque bearer token.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.TokenReviewSpec#token
     */
    readonly token?: string;
}
/**
 * Converts an object of type 'TokenReviewSpec' to JSON representation.
 */
export declare function toJson_TokenReviewSpec(obj: TokenReviewSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenReviewSpec is a description of the token authentication request.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1beta1.TokenReviewSpec
 */
export interface TokenReviewSpecV1Beta1 {
    /**
     * (experimental) Audiences is a list of the identifiers that the resource server presented with the token identifies as.
     *
     * Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1beta1.TokenReviewSpec#audiences
     */
    readonly audiences?: string[];
    /**
     * (experimental) Token is the opaque bearer token.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1beta1.TokenReviewSpec#token
     */
    readonly token?: string;
}
/**
 * Converts an object of type 'TokenReviewSpecV1Beta1' to JSON representation.
 */
export declare function toJson_TokenReviewSpecV1Beta1(obj: TokenReviewSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) SubjectAccessReviewSpec is a description of the access request.
 *
 * Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SubjectAccessReviewSpec
 */
export interface SubjectAccessReviewSpec {
    /**
     * (experimental) Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReviewSpec#extra
     */
    readonly extra?: {
        [key: string]: string[];
    };
    /**
     * (experimental) Groups is the groups you're testing for.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReviewSpec#groups
     */
    readonly groups?: string[];
    /**
     * (experimental) NonResourceAttributes describes information for a non-resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReviewSpec#nonResourceAttributes
     */
    readonly nonResourceAttributes?: NonResourceAttributes;
    /**
     * (experimental) ResourceAuthorizationAttributes describes information for a resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReviewSpec#resourceAttributes
     */
    readonly resourceAttributes?: ResourceAttributes;
    /**
     * (experimental) UID information about the requesting user.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReviewSpec#uid
     */
    readonly uid?: string;
    /**
     * (experimental) User is the user you're testing for.
     *
     * If you specify "User" but not "Groups", then is it interpreted as "What if User were not a member of any groups
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SubjectAccessReviewSpec#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'SubjectAccessReviewSpec' to JSON representation.
 */
export declare function toJson_SubjectAccessReviewSpec(obj: SubjectAccessReviewSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) SelfSubjectAccessReviewSpec is a description of the access request.
 *
 * Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec
 */
export interface SelfSubjectAccessReviewSpec {
    /**
     * (experimental) NonResourceAttributes describes information for a non-resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec#nonResourceAttributes
     */
    readonly nonResourceAttributes?: NonResourceAttributes;
    /**
     * (experimental) ResourceAuthorizationAttributes describes information for a resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec#resourceAttributes
     */
    readonly resourceAttributes?: ResourceAttributes;
}
/**
 * Converts an object of type 'SelfSubjectAccessReviewSpec' to JSON representation.
 */
export declare function toJson_SelfSubjectAccessReviewSpec(obj: SelfSubjectAccessReviewSpec | undefined): Record<string, any> | undefined;
/**
 * @experimental
 * @schema io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec
 */
export interface SelfSubjectRulesReviewSpec {
    /**
     * (experimental) Namespace to evaluate rules for.
     *
     * Required.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'SelfSubjectRulesReviewSpec' to JSON representation.
 */
export declare function toJson_SelfSubjectRulesReviewSpec(obj: SelfSubjectRulesReviewSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) SubjectAccessReviewSpec is a description of the access request.
 *
 * Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReviewSpec
 */
export interface SubjectAccessReviewSpecV1Beta1 {
    /**
     * (experimental) Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReviewSpec#extra
     */
    readonly extra?: {
        [key: string]: string[];
    };
    /**
     * (experimental) Groups is the groups you're testing for.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReviewSpec#group
     */
    readonly group?: string[];
    /**
     * (experimental) NonResourceAttributes describes information for a non-resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReviewSpec#nonResourceAttributes
     */
    readonly nonResourceAttributes?: NonResourceAttributesV1Beta1;
    /**
     * (experimental) ResourceAuthorizationAttributes describes information for a resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReviewSpec#resourceAttributes
     */
    readonly resourceAttributes?: ResourceAttributesV1Beta1;
    /**
     * (experimental) UID information about the requesting user.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReviewSpec#uid
     */
    readonly uid?: string;
    /**
     * (experimental) User is the user you're testing for.
     *
     * If you specify "User" but not "Group", then is it interpreted as "What if User were not a member of any groups
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SubjectAccessReviewSpec#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'SubjectAccessReviewSpecV1Beta1' to JSON representation.
 */
export declare function toJson_SubjectAccessReviewSpecV1Beta1(obj: SubjectAccessReviewSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) SelfSubjectAccessReviewSpec is a description of the access request.
 *
 * Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SelfSubjectAccessReviewSpec
 */
export interface SelfSubjectAccessReviewSpecV1Beta1 {
    /**
     * (experimental) NonResourceAttributes describes information for a non-resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SelfSubjectAccessReviewSpec#nonResourceAttributes
     */
    readonly nonResourceAttributes?: NonResourceAttributesV1Beta1;
    /**
     * (experimental) ResourceAuthorizationAttributes describes information for a resource access request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SelfSubjectAccessReviewSpec#resourceAttributes
     */
    readonly resourceAttributes?: ResourceAttributesV1Beta1;
}
/**
 * Converts an object of type 'SelfSubjectAccessReviewSpecV1Beta1' to JSON representation.
 */
export declare function toJson_SelfSubjectAccessReviewSpecV1Beta1(obj: SelfSubjectAccessReviewSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.SelfSubjectRulesReviewSpec
 */
export interface SelfSubjectRulesReviewSpecV1Beta1 {
    /**
     * (experimental) Namespace to evaluate rules for.
     *
     * Required.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.SelfSubjectRulesReviewSpec#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'SelfSubjectRulesReviewSpecV1Beta1' to JSON representation.
 */
export declare function toJson_SelfSubjectRulesReviewSpecV1Beta1(obj: SelfSubjectRulesReviewSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) specification of a horizontal pod autoscaler.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec
 */
export interface HorizontalPodAutoscalerSpec {
    /**
     * (experimental) upper limit for the number of pods that can be set by the autoscaler;
     *
     * cannot be smaller than MinReplicas.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#maxReplicas
     */
    readonly maxReplicas: number;
    /**
     * (experimental) minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.
     *
     * It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#minReplicas
     */
    readonly minReplicas?: number;
    /**
     * (experimental) reference to scaled resource;
     *
     * horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#scaleTargetRef
     */
    readonly scaleTargetRef: CrossVersionObjectReference;
    /**
     * (experimental) target average CPU utilization (represented as a percentage of requested CPU) over all the pods;
     *
     * if not specified the default autoscaling policy will be used.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec#targetCPUUtilizationPercentage
     */
    readonly targetCpuUtilizationPercentage?: number;
}
/**
 * Converts an object of type 'HorizontalPodAutoscalerSpec' to JSON representation.
 */
export declare function toJson_HorizontalPodAutoscalerSpec(obj: HorizontalPodAutoscalerSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) ScaleSpec describes the attributes of a scale subresource.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.ScaleSpec
 */
export interface ScaleSpec {
    /**
     * (experimental) desired number of instances for the scaled object.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.ScaleSpec#replicas
     */
    readonly replicas?: number;
}
/**
 * Converts an object of type 'ScaleSpec' to JSON representation.
 */
export declare function toJson_ScaleSpec(obj: ScaleSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec
 */
export interface HorizontalPodAutoscalerSpecV2Beta1 {
    /**
     * (experimental) maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.
     *
     * It cannot be less that minReplicas.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#maxReplicas
     */
    readonly maxReplicas: number;
    /**
     * (experimental) metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).
     *
     * The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#metrics
     */
    readonly metrics?: MetricSpecV2Beta1[];
    /**
     * (experimental) minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.
     *
     * It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#minReplicas
     */
    readonly minReplicas?: number;
    /**
     * (experimental) scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec#scaleTargetRef
     */
    readonly scaleTargetRef: CrossVersionObjectReferenceV2Beta1;
}
/**
 * Converts an object of type 'HorizontalPodAutoscalerSpecV2Beta1' to JSON representation.
 */
export declare function toJson_HorizontalPodAutoscalerSpecV2Beta1(obj: HorizontalPodAutoscalerSpecV2Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec
 */
export interface HorizontalPodAutoscalerSpecV2Beta2 {
    /**
     * (experimental) behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
     *
     * If not set, the default HPAScalingRules for scale up and scale down are used.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#behavior
     */
    readonly behavior?: HorizontalPodAutoscalerBehaviorV2Beta2;
    /**
     * (experimental) maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.
     *
     * It cannot be less that minReplicas.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#maxReplicas
     */
    readonly maxReplicas: number;
    /**
     * (experimental) metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).
     *
     * The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#metrics
     */
    readonly metrics?: MetricSpecV2Beta2[];
    /**
     * (experimental) minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.
     *
     * It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#minReplicas
     */
    readonly minReplicas?: number;
    /**
     * (experimental) scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#scaleTargetRef
     */
    readonly scaleTargetRef: CrossVersionObjectReferenceV2Beta2;
}
/**
 * Converts an object of type 'HorizontalPodAutoscalerSpecV2Beta2' to JSON representation.
 */
export declare function toJson_HorizontalPodAutoscalerSpecV2Beta2(obj: HorizontalPodAutoscalerSpecV2Beta2 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CronJobSpec describes how the job execution will look like and when it will actually run.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.CronJobSpec
 */
export interface CronJobSpec {
    /**
     * (experimental) Specifies how to treat concurrent executions of a Job.
     *
     * Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobSpec#concurrencyPolicy
     */
    readonly concurrencyPolicy?: string;
    /**
     * (experimental) The number of failed finished jobs to retain.
     *
     * Value must be non-negative integer. Defaults to 1.
     *
     * @default 1.
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobSpec#failedJobsHistoryLimit
     */
    readonly failedJobsHistoryLimit?: number;
    /**
     * (experimental) Specifies the job that will be created when executing a CronJob.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobSpec#jobTemplate
     */
    readonly jobTemplate: JobTemplateSpec;
    /**
     * (experimental) The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobSpec#schedule
     */
    readonly schedule: string;
    /**
     * (experimental) Optional deadline in seconds for starting the job if it misses scheduled time for any reason.
     *
     * Missed jobs executions will be counted as failed ones.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobSpec#startingDeadlineSeconds
     */
    readonly startingDeadlineSeconds?: number;
    /**
     * (experimental) The number of successful finished jobs to retain.
     *
     * Value must be non-negative integer. Defaults to 3.
     *
     * @default 3.
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobSpec#successfulJobsHistoryLimit
     */
    readonly successfulJobsHistoryLimit?: number;
    /**
     * (experimental) This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.
     *
     * Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.batch.v1.CronJobSpec#suspend
     */
    readonly suspend?: boolean;
}
/**
 * Converts an object of type 'CronJobSpec' to JSON representation.
 */
export declare function toJson_CronJobSpec(obj: CronJobSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) JobSpec describes how the job execution will look like.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.JobSpec
 */
export interface JobSpec {
    /**
     * (experimental) Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it;
     *
     * value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#activeDeadlineSeconds
     */
    readonly activeDeadlineSeconds?: number;
    /**
     * (experimental) Specifies the number of retries before marking this job failed.
     *
     * Defaults to 6
     *
     * @default 6
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#backoffLimit
     */
    readonly backoffLimit?: number;
    /**
     * (experimental) CompletionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.
     *
     * `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.
     *
     * `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5.
     *
     * This field is alpha-level and is only honored by servers that enable the IndexedJob feature gate. More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, the controller skips updates for the Job.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#completionMode
     */
    readonly completionMode?: string;
    /**
     * (experimental) Specifies the desired number of successfully finished pods the job should be run with.
     *
     * Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#completions
     */
    readonly completions?: number;
    /**
     * (experimental) manualSelector controls generation of pod labels and pod selectors.
     *
     * Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#manualSelector
     */
    readonly manualSelector?: boolean;
    /**
     * (experimental) Specifies the maximum desired number of pods the job should run at any given time.
     *
     * The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#parallelism
     */
    readonly parallelism?: number;
    /**
     * (experimental) A label query over pods that should match the pod count.
     *
     * Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#selector
     */
    readonly selector?: LabelSelector;
    /**
     * (experimental) Suspend specifies whether the Job controller should create Pods or not.
     *
     * If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. This is an alpha field and requires the SuspendJob feature gate to be enabled; otherwise this field may not be set to true. Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#suspend
     */
    readonly suspend?: boolean;
    /**
     * (experimental) Describes the pod that will be created when executing a job.
     *
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#template
     */
    readonly template: PodTemplateSpec;
    /**
     * (experimental) ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed).
     *
     * If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the TTLAfterFinished feature.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobSpec#ttlSecondsAfterFinished
     */
    readonly ttlSecondsAfterFinished?: number;
}
/**
 * Converts an object of type 'JobSpec' to JSON representation.
 */
export declare function toJson_JobSpec(obj: JobSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) CronJobSpec describes how the job execution will look like and when it will actually run.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1beta1.CronJobSpec
 */
export interface CronJobSpecV1Beta1 {
    /**
     * (experimental) Specifies how to treat concurrent executions of a Job.
     *
     * Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobSpec#concurrencyPolicy
     */
    readonly concurrencyPolicy?: string;
    /**
     * (experimental) The number of failed finished jobs to retain.
     *
     * This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
     *
     * @default 1.
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobSpec#failedJobsHistoryLimit
     */
    readonly failedJobsHistoryLimit?: number;
    /**
     * (experimental) Specifies the job that will be created when executing a CronJob.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobSpec#jobTemplate
     */
    readonly jobTemplate: JobTemplateSpecV1Beta1;
    /**
     * (experimental) The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobSpec#schedule
     */
    readonly schedule: string;
    /**
     * (experimental) Optional deadline in seconds for starting the job if it misses scheduled time for any reason.
     *
     * Missed jobs executions will be counted as failed ones.
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobSpec#startingDeadlineSeconds
     */
    readonly startingDeadlineSeconds?: number;
    /**
     * (experimental) The number of successful finished jobs to retain.
     *
     * This is a pointer to distinguish between explicit zero and not specified. Defaults to 3.
     *
     * @default 3.
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobSpec#successfulJobsHistoryLimit
     */
    readonly successfulJobsHistoryLimit?: number;
    /**
     * (experimental) This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.
     *
     * Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.CronJobSpec#suspend
     */
    readonly suspend?: boolean;
}
/**
 * Converts an object of type 'CronJobSpecV1Beta1' to JSON representation.
 */
export declare function toJson_CronJobSpecV1Beta1(obj: CronJobSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CertificateSigningRequestSpec contains the certificate request.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec
 */
export interface CertificateSigningRequestSpec {
    /**
     * (experimental) extra contains extra attributes of the user that created the CertificateSigningRequest.
     *
     * Populated by the API server on creation and immutable.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec#extra
     */
    readonly extra?: {
        [key: string]: string[];
    };
    /**
     * (experimental) groups contains group membership of the user that created the CertificateSigningRequest.
     *
     * Populated by the API server on creation and immutable.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec#groups
     */
    readonly groups?: string[];
    /**
     * (experimental) request contains an x509 certificate signing request encoded in a "CERTIFICATE REQUEST" PEM block.
     *
     * When serialized as JSON or YAML, the data is additionally base64-encoded.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec#request
     */
    readonly request: string;
    /**
     * (experimental) signerName indicates the requested signer, and is a qualified name.
     *
     * List/watch requests for CertificateSigningRequests can filter on this field using a "spec.signerName=NAME" fieldSelector.
     *
     * Well-known Kubernetes signers are:
     * 1. "kubernetes.io/kube-apiserver-client": issues client certificates that can be used to authenticate to kube-apiserver.
     * Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the "csrsigning" controller in kube-controller-manager.
     * 2. "kubernetes.io/kube-apiserver-client-kubelet": issues client certificates that kubelets use to authenticate to kube-apiserver.
     * Requests for this signer can be auto-approved by the "csrapproving" controller in kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
     * 3. "kubernetes.io/kubelet-serving" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.
     * Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
     *
     * More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers
     *
     * Custom signerNames can also be specified. The signer defines:
     * 1. Trust distribution: how trust (CA bundles) are distributed.
     * 2. Permitted subjects: and behavior when a disallowed subject is requested.
     * 3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.
     * 4. Required, permitted, or forbidden key usages / extended key usages.
     * 5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.
     * 6. Whether or not requests for CA certificates are allowed.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec#signerName
     */
    readonly signerName: string;
    /**
     * (experimental) uid contains the uid of the user that created the CertificateSigningRequest.
     *
     * Populated by the API server on creation and immutable.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec#uid
     */
    readonly uid?: string;
    /**
     * (experimental) usages specifies a set of key usages requested in the issued certificate.
     *
     * Requests for TLS client certificates typically request: "digital signature", "key encipherment", "client auth".
     *
     * Requests for TLS serving certificates typically request: "key encipherment", "digital signature", "server auth".
     *
     * Valid values are:
     * "signing", "digital signature", "content commitment",
     * "key encipherment", "key agreement", "data encipherment",
     * "cert sign", "crl sign", "encipher only", "decipher only", "any",
     * "server auth", "client auth",
     * "code signing", "email protection", "s/mime",
     * "ipsec end system", "ipsec tunnel", "ipsec user",
     * "timestamping", "ocsp signing", "microsoft sgc", "netscape sgc"
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec#usages
     */
    readonly usages?: string[];
    /**
     * (experimental) username contains the name of the user that created the CertificateSigningRequest.
     *
     * Populated by the API server on creation and immutable.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1.CertificateSigningRequestSpec#username
     */
    readonly username?: string;
}
/**
 * Converts an object of type 'CertificateSigningRequestSpec' to JSON representation.
 */
export declare function toJson_CertificateSigningRequestSpec(obj: CertificateSigningRequestSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) This information is immutable after the request is created.
 *
 * Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
 *
 * @experimental
 * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec
 */
export interface CertificateSigningRequestSpecV1Beta1 {
    /**
     * (experimental) Extra information about the requesting user.
     *
     * See user.Info interface for details.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#extra
     */
    readonly extra?: {
        [key: string]: string[];
    };
    /**
     * (experimental) Group information about the requesting user.
     *
     * See user.Info interface for details.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#groups
     */
    readonly groups?: string[];
    /**
     * (experimental) Base64-encoded PKCS#10 CSR data.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#request
     */
    readonly request: string;
    /**
     * (experimental) Requested signer for the request.
     *
     * It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
     * 1. If it's a kubelet client certificate, it is assigned
     * "kubernetes.io/kube-apiserver-client-kubelet".
     * 2. If it's a kubelet serving certificate, it is assigned
     * "kubernetes.io/kubelet-serving".
     * 3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
     * Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#signerName
     */
    readonly signerName?: string;
    /**
     * (experimental) UID information about the requesting user.
     *
     * See user.Info interface for details.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#uid
     */
    readonly uid?: string;
    /**
     * (experimental) allowedUsages specifies a set of usage contexts the key will be valid for.
     *
     * See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
     * https://tools.ietf.org/html/rfc5280#section-4.2.1.12
     * Valid values are:
     * "signing",
     * "digital signature",
     * "content commitment",
     * "key encipherment",
     * "key agreement",
     * "data encipherment",
     * "cert sign",
     * "crl sign",
     * "encipher only",
     * "decipher only",
     * "any",
     * "server auth",
     * "client auth",
     * "code signing",
     * "email protection",
     * "s/mime",
     * "ipsec end system",
     * "ipsec tunnel",
     * "ipsec user",
     * "timestamping",
     * "ocsp signing",
     * "microsoft sgc",
     * "netscape sgc"
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#usages
     */
    readonly usages?: string[];
    /**
     * (experimental) Information about the requesting user.
     *
     * See user.Info interface for details.
     *
     * @experimental
     * @schema io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#username
     */
    readonly username?: string;
}
/**
 * Converts an object of type 'CertificateSigningRequestSpecV1Beta1' to JSON representation.
 */
export declare function toJson_CertificateSigningRequestSpecV1Beta1(obj: CertificateSigningRequestSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) LeaseSpec is a specification of a Lease.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1.LeaseSpec
 */
export interface LeaseSpec {
    /**
     * (experimental) acquireTime is a time when the current lease was acquired.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.LeaseSpec#acquireTime
     */
    readonly acquireTime?: Date;
    /**
     * (experimental) holderIdentity contains the identity of the holder of a current lease.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.LeaseSpec#holderIdentity
     */
    readonly holderIdentity?: string;
    /**
     * (experimental) leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it.
     *
     * This is measure against time of last observed RenewTime.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.LeaseSpec#leaseDurationSeconds
     */
    readonly leaseDurationSeconds?: number;
    /**
     * (experimental) leaseTransitions is the number of transitions of a lease between holders.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.LeaseSpec#leaseTransitions
     */
    readonly leaseTransitions?: number;
    /**
     * (experimental) renewTime is a time when the current holder of a lease has last updated the lease.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1.LeaseSpec#renewTime
     */
    readonly renewTime?: Date;
}
/**
 * Converts an object of type 'LeaseSpec' to JSON representation.
 */
export declare function toJson_LeaseSpec(obj: LeaseSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) LeaseSpec is a specification of a Lease.
 *
 * @experimental
 * @schema io.k8s.api.coordination.v1beta1.LeaseSpec
 */
export interface LeaseSpecV1Beta1 {
    /**
     * (experimental) acquireTime is a time when the current lease was acquired.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.LeaseSpec#acquireTime
     */
    readonly acquireTime?: Date;
    /**
     * (experimental) holderIdentity contains the identity of the holder of a current lease.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.LeaseSpec#holderIdentity
     */
    readonly holderIdentity?: string;
    /**
     * (experimental) leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it.
     *
     * This is measure against time of last observed RenewTime.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.LeaseSpec#leaseDurationSeconds
     */
    readonly leaseDurationSeconds?: number;
    /**
     * (experimental) leaseTransitions is the number of transitions of a lease between holders.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.LeaseSpec#leaseTransitions
     */
    readonly leaseTransitions?: number;
    /**
     * (experimental) renewTime is a time when the current holder of a lease has last updated the lease.
     *
     * @experimental
     * @schema io.k8s.api.coordination.v1beta1.LeaseSpec#renewTime
     */
    readonly renewTime?: Date;
}
/**
 * Converts an object of type 'LeaseSpecV1Beta1' to JSON representation.
 */
export declare function toJson_LeaseSpecV1Beta1(obj: LeaseSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) ObjectReference contains enough information to let you inspect or modify the referred object.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ObjectReference
 */
export interface ObjectReference {
    /**
     * (experimental) API version of the referent.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ObjectReference#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ObjectReference#fieldPath
     */
    readonly fieldPath?: string;
    /**
     * (experimental) Kind of the referent.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ObjectReference#kind
     */
    readonly kind?: string;
    /**
     * (experimental) Name of the referent.
     *
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ObjectReference#name
     */
    readonly name?: string;
    /**
     * (experimental) Namespace of the referent.
     *
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ObjectReference#namespace
     */
    readonly namespace?: string;
    /**
     * (experimental) Specific resourceVersion to which this reference is made, if any.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ObjectReference#resourceVersion
     */
    readonly resourceVersion?: string;
    /**
     * (experimental) UID of the referent.
     *
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ObjectReference#uid
     */
    readonly uid?: string;
}
/**
 * Converts an object of type 'ObjectReference' to JSON representation.
 */
export declare function toJson_ObjectReference(obj: ObjectReference | undefined): Record<string, any> | undefined;
/**
 * (experimental) Information about the condition of a component.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ComponentCondition
 */
export interface ComponentCondition {
    /**
     * (experimental) Condition error code for a component.
     *
     * For example, a health check error code.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentCondition#error
     */
    readonly error?: string;
    /**
     * (experimental) Message about the condition for a component.
     *
     * For example, information about a health check.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentCondition#message
     */
    readonly message?: string;
    /**
     * (experimental) Status of the condition for a component.
     *
     * Valid values for "Healthy": "True", "False", or "Unknown".
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentCondition#status
     */
    readonly status: string;
    /**
     * (experimental) Type of condition for a component.
     *
     * Valid value: "Healthy"
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ComponentCondition#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'ComponentCondition' to JSON representation.
 */
export declare function toJson_ComponentCondition(obj: ComponentCondition | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointSubset is a group of addresses with a common set of ports.
 *
 * The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:
 * {
 * Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
 * Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
 * }
 * The resulting set of endpoints can be viewed as:
 * a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
 * b: [ 10.10.1.1:309, 10.10.2.2:309 ]
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EndpointSubset
 */
export interface EndpointSubset {
    /**
     * (experimental) IP addresses which offer the related ports that are marked as ready.
     *
     * These endpoints should be considered safe for load balancers and clients to utilize.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointSubset#addresses
     */
    readonly addresses?: EndpointAddress[];
    /**
     * (experimental) IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointSubset#notReadyAddresses
     */
    readonly notReadyAddresses?: EndpointAddress[];
    /**
     * (experimental) Port numbers available on the related IP addresses.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointSubset#ports
     */
    readonly ports?: EndpointPort[];
}
/**
 * Converts an object of type 'EndpointSubset' to JSON representation.
 */
export declare function toJson_EndpointSubset(obj: EndpointSubset | undefined): Record<string, any> | undefined;
/**
 * (experimental) An EphemeralContainer is a container that may be added temporarily to an existing pod for user-initiated activities such as debugging.
 *
 * Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a pod is removed or restarted. If an ephemeral container causes a pod to exceed its resource allocation, the pod may be evicted. Ephemeral containers may not be added by directly updating the pod spec. They must be added via the pod's ephemeralcontainers subresource, and they will appear in the pod spec once added. This is an alpha feature enabled by the EphemeralContainers feature flag.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EphemeralContainer
 */
export interface EphemeralContainer {
    /**
     * (experimental) Arguments to the entrypoint.
     *
     * The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#args
     */
    readonly args?: string[];
    /**
     * (experimental) Entrypoint array.
     *
     * Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#command
     */
    readonly command?: string[];
    /**
     * (experimental) List of environment variables to set in the container.
     *
     * Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#env
     */
    readonly env?: EnvVar[];
    /**
     * (experimental) List of sources to populate environment variables in the container.
     *
     * The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#envFrom
     */
    readonly envFrom?: EnvFromSource[];
    /**
     * (experimental) Docker image name.
     *
     * More info: https://kubernetes.io/docs/concepts/containers/images
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#image
     */
    readonly image?: string;
    /**
     * (experimental) Image pull policy.
     *
     * One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
     *
     * @default Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * (experimental) Lifecycle is not allowed for ephemeral containers.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#lifecycle
     */
    readonly lifecycle?: Lifecycle;
    /**
     * (experimental) Probes are not allowed for ephemeral containers.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#livenessProbe
     */
    readonly livenessProbe?: Probe;
    /**
     * (experimental) Name of the ephemeral container specified as a DNS_LABEL.
     *
     * This name must be unique among all containers, init containers and ephemeral containers.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#name
     */
    readonly name: string;
    /**
     * (experimental) Ports are not allowed for ephemeral containers.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#ports
     */
    readonly ports?: ContainerPort[];
    /**
     * (experimental) Probes are not allowed for ephemeral containers.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#readinessProbe
     */
    readonly readinessProbe?: Probe;
    /**
     * (experimental) Resources are not allowed for ephemeral containers.
     *
     * Ephemeral containers use spare resources already allocated to the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#resources
     */
    readonly resources?: ResourceRequirements;
    /**
     * (experimental) SecurityContext is not allowed for ephemeral containers.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#securityContext
     */
    readonly securityContext?: SecurityContext;
    /**
     * (experimental) Probes are not allowed for ephemeral containers.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#startupProbe
     */
    readonly startupProbe?: Probe;
    /**
     * (experimental) Whether this container should allocate a buffer for stdin in the container runtime.
     *
     * If this is not set, reads from stdin in the container will always result in EOF. Default is false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#stdin
     */
    readonly stdin?: boolean;
    /**
     * (experimental) Whether the container runtime should close the stdin channel after it has been opened by a single attach.
     *
     * When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
     *
     * @default false
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#stdinOnce
     */
    readonly stdinOnce?: boolean;
    /**
     * (experimental) If set, the name of the container from PodSpec that this ephemeral container targets.
     *
     * The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container is run in whatever namespaces are shared for the pod. Note that the container runtime must support this feature.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#targetContainerName
     */
    readonly targetContainerName?: string;
    /**
     * (experimental) Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.
     *
     * Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
     *
     * @default dev/termination-log. Cannot be updated.
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#terminationMessagePath
     */
    readonly terminationMessagePath?: string;
    /**
     * (experimental) Indicate how the termination message should be populated.
     *
     * File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
     *
     * @default File. Cannot be updated.
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#terminationMessagePolicy
     */
    readonly terminationMessagePolicy?: string;
    /**
     * (experimental) Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.
     *
     * Default is false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#tty
     */
    readonly tty?: boolean;
    /**
     * (experimental) volumeDevices is the list of block devices to be used by the container.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#volumeDevices
     */
    readonly volumeDevices?: VolumeDevice[];
    /**
     * (experimental) Pod volumes to mount into the container's filesystem.
     *
     * Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#volumeMounts
     */
    readonly volumeMounts?: VolumeMount[];
    /**
     * (experimental) Container's working directory.
     *
     * If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EphemeralContainer#workingDir
     */
    readonly workingDir?: string;
}
/**
 * Converts an object of type 'EphemeralContainer' to JSON representation.
 */
export declare function toJson_EphemeralContainer(obj: EphemeralContainer | undefined): Record<string, any> | undefined;
/**
 * (experimental) EventSource contains information for an event.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EventSource
 */
export interface EventSource {
    /**
     * (experimental) Component from which the event is generated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EventSource#component
     */
    readonly component?: string;
    /**
     * (experimental) Node name on which the event is generated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EventSource#host
     */
    readonly host?: string;
}
/**
 * Converts an object of type 'EventSource' to JSON representation.
 */
export declare function toJson_EventSource(obj: EventSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. How often to update the EventSeries is up to the event reporters. The default event reporter in "k8s.io/client-go/tools/events/event_broadcaster.go" shows how this struct is updated on heartbeats and can guide customized reporter implementations.
 *
 * @experimental
 * @schema io.k8s.api.events.v1.EventSeries
 */
export interface EventSeries {
    /**
     * (experimental) count is the number of occurrences in this series up to the last heartbeat time.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.EventSeries#count
     */
    readonly count: number;
    /**
     * (experimental) lastObservedTime is the time when last Event from the series was seen before last heartbeat.
     *
     * @experimental
     * @schema io.k8s.api.events.v1.EventSeries#lastObservedTime
     */
    readonly lastObservedTime: Date;
}
/**
 * Converts an object of type 'EventSeries' to JSON representation.
 */
export declare function toJson_EventSeries(obj: EventSeries | undefined): Record<string, any> | undefined;
/**
 * (experimental) LimitRangeSpec defines a min/max usage limit for resources that match on kind.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LimitRangeSpec
 */
export interface LimitRangeSpec {
    /**
     * (experimental) Limits is the list of LimitRangeItem objects that are enforced.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeSpec#limits
     */
    readonly limits: LimitRangeItem[];
}
/**
 * Converts an object of type 'LimitRangeSpec' to JSON representation.
 */
export declare function toJson_LimitRangeSpec(obj: LimitRangeSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) NamespaceSpec describes the attributes on a Namespace.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NamespaceSpec
 */
export interface NamespaceSpec {
    /**
     * (experimental) Finalizers is an opaque list of values that must be empty to permanently remove object from storage.
     *
     * More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NamespaceSpec#finalizers
     */
    readonly finalizers?: string[];
}
/**
 * Converts an object of type 'NamespaceSpec' to JSON representation.
 */
export declare function toJson_NamespaceSpec(obj: NamespaceSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) NodeSpec describes the attributes that a node is created with.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NodeSpec
 */
export interface NodeSpec {
    /**
     * (experimental) If specified, the source to get node configuration from The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeSpec#configSource
     */
    readonly configSource?: NodeConfigSource;
    /**
     * (experimental) Deprecated.
     *
     * Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeSpec#externalID
     */
    readonly externalId?: string;
    /**
     * (experimental) PodCIDR represents the pod IP range assigned to the node.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeSpec#podCIDR
     */
    readonly podCidr?: string;
    /**
     * (experimental) podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node.
     *
     * If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeSpec#podCIDRs
     */
    readonly podCidRs?: string[];
    /**
     * (experimental) ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeSpec#providerID
     */
    readonly providerId?: string;
    /**
     * (experimental) If specified, the node's taints.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeSpec#taints
     */
    readonly taints?: Taint[];
    /**
     * (experimental) Unschedulable controls node schedulability of new pods.
     *
     * By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeSpec#unschedulable
     */
    readonly unschedulable?: boolean;
}
/**
 * Converts an object of type 'NodeSpec' to JSON representation.
 */
export declare function toJson_NodeSpec(obj: NodeSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) PersistentVolumeSpec is the specification of a persistent volume.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeSpec
 */
export interface PersistentVolumeSpec {
    /**
     * (experimental) AccessModes contains all ways the volume can be mounted.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * (experimental) AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#awsElasticBlockStore
     */
    readonly awsElasticBlockStore?: AwsElasticBlockStoreVolumeSource;
    /**
     * (experimental) AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#azureDisk
     */
    readonly azureDisk?: AzureDiskVolumeSource;
    /**
     * (experimental) AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#azureFile
     */
    readonly azureFile?: AzureFilePersistentVolumeSource;
    /**
     * (experimental) A description of the persistent volume's resources and capacity.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#capacity
     */
    readonly capacity?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) CephFS represents a Ceph FS mount on the host that shares a pod's lifetime.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#cephfs
     */
    readonly cephfs?: CephFsPersistentVolumeSource;
    /**
     * (experimental) Cinder represents a cinder volume attached and mounted on kubelets host machine.
     *
     * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#cinder
     */
    readonly cinder?: CinderPersistentVolumeSource;
    /**
     * (experimental) ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
     *
     * Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#claimRef
     */
    readonly claimRef?: ObjectReference;
    /**
     * (experimental) CSI represents storage that is handled by an external CSI driver (Beta feature).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#csi
     */
    readonly csi?: CsiPersistentVolumeSource;
    /**
     * (experimental) FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#fc
     */
    readonly fc?: FcVolumeSource;
    /**
     * (experimental) FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#flexVolume
     */
    readonly flexVolume?: FlexPersistentVolumeSource;
    /**
     * (experimental) Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage.
     *
     * This depends on the Flocker control service being running
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#flocker
     */
    readonly flocker?: FlockerVolumeSource;
    /**
     * (experimental) GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#gcePersistentDisk
     */
    readonly gcePersistentDisk?: GcePersistentDiskVolumeSource;
    /**
     * (experimental) Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod.
     *
     * Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#glusterfs
     */
    readonly glusterfs?: GlusterfsPersistentVolumeSource;
    /**
     * (experimental) HostPath represents a directory on the host.
     *
     * Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#hostPath
     */
    readonly hostPath?: HostPathVolumeSource;
    /**
     * (experimental) ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * Provisioned by an admin.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#iscsi
     */
    readonly iscsi?: IscsiPersistentVolumeSource;
    /**
     * (experimental) Local represents directly-attached storage with node affinity.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#local
     */
    readonly local?: LocalVolumeSource;
    /**
     * (experimental) A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#mountOptions
     */
    readonly mountOptions?: string[];
    /**
     * (experimental) NFS represents an NFS mount on the host.
     *
     * Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#nfs
     */
    readonly nfs?: NfsVolumeSource;
    /**
     * (experimental) NodeAffinity defines constraints that limit what nodes this volume can be accessed from.
     *
     * This field influences the scheduling of pods that use this volume.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#nodeAffinity
     */
    readonly nodeAffinity?: VolumeNodeAffinity;
    /**
     * (experimental) What happens to a persistent volume when released from its claim.
     *
     * Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#persistentVolumeReclaimPolicy
     */
    readonly persistentVolumeReclaimPolicy?: string;
    /**
     * (experimental) PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#photonPersistentDisk
     */
    readonly photonPersistentDisk?: PhotonPersistentDiskVolumeSource;
    /**
     * (experimental) PortworxVolume represents a portworx volume attached and mounted on kubelets host machine.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#portworxVolume
     */
    readonly portworxVolume?: PortworxVolumeSource;
    /**
     * (experimental) Quobyte represents a Quobyte mount on the host that shares a pod's lifetime.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#quobyte
     */
    readonly quobyte?: QuobyteVolumeSource;
    /**
     * (experimental) RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.
     *
     * More info: https://examples.k8s.io/volumes/rbd/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#rbd
     */
    readonly rbd?: RbdPersistentVolumeSource;
    /**
     * (experimental) ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#scaleIO
     */
    readonly scaleIo?: ScaleIoPersistentVolumeSource;
    /**
     * (experimental) Name of StorageClass to which this persistent volume belongs.
     *
     * Empty value means that this volume does not belong to any StorageClass.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * (experimental) StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#storageos
     */
    readonly storageos?: StorageOsPersistentVolumeSource;
    /**
     * (experimental) volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state.
     *
     * Value of Filesystem is implied when not included in spec.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * (experimental) VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeSpec#vsphereVolume
     */
    readonly vsphereVolume?: VsphereVirtualDiskVolumeSource;
}
/**
 * Converts an object of type 'PersistentVolumeSpec' to JSON representation.
 */
export declare function toJson_PersistentVolumeSpec(obj: PersistentVolumeSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec
 */
export interface PersistentVolumeClaimSpec {
    /**
     * (experimental) AccessModes contains the desired access modes the volume should have.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * (experimental) This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec#dataSource
     */
    readonly dataSource?: TypedLocalObjectReference;
    /**
     * (experimental) Resources represents the minimum resources the volume should have.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec#resources
     */
    readonly resources?: ResourceRequirements;
    /**
     * (experimental) A label query over volumes to consider for binding.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec#selector
     */
    readonly selector?: LabelSelector;
    /**
     * (experimental) Name of the StorageClass required by the claim.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * (experimental) volumeMode defines what type of volume is required by the claim.
     *
     * Value of Filesystem is implied when not included in claim spec.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * (experimental) VolumeName is the binding reference to the PersistentVolume backing this claim.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PersistentVolumeClaimSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'PersistentVolumeClaimSpec' to JSON representation.
 */
export declare function toJson_PersistentVolumeClaimSpec(obj: PersistentVolumeClaimSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodSpec is a description of a pod.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodSpec
 */
export interface PodSpec {
    /**
     * (experimental) Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers.
     *
     * Value must be a positive integer.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#activeDeadlineSeconds
     */
    readonly activeDeadlineSeconds?: number;
    /**
     * (experimental) If specified, the pod's scheduling constraints.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#affinity
     */
    readonly affinity?: Affinity;
    /**
     * (experimental) AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#automountServiceAccountToken
     */
    readonly automountServiceAccountToken?: boolean;
    /**
     * (experimental) List of containers belonging to the pod.
     *
     * Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#containers
     */
    readonly containers: Container[];
    /**
     * (experimental) Specifies the DNS parameters of a pod.
     *
     * Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#dnsConfig
     */
    readonly dnsConfig?: PodDnsConfig;
    /**
     * (experimental) Set DNS policy for the pod.
     *
     * Defaults to "ClusterFirst". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.
     *
     * @default ClusterFirst". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#dnsPolicy
     */
    readonly dnsPolicy?: string;
    /**
     * (experimental) EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links.
     *
     * Optional: Defaults to true.
     *
     * @default true.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#enableServiceLinks
     */
    readonly enableServiceLinks?: boolean;
    /**
     * (experimental) List of ephemeral containers run in this pod.
     *
     * Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#ephemeralContainers
     */
    readonly ephemeralContainers?: EphemeralContainer[];
    /**
     * (experimental) HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified.
     *
     * This is only valid for non-hostNetwork pods.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#hostAliases
     */
    readonly hostAliases?: HostAlias[];
    /**
     * (experimental) Use the host's ipc namespace.
     *
     * Optional: Default to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#hostIPC
     */
    readonly hostIpc?: boolean;
    /**
     * (experimental) Host networking requested for this pod.
     *
     * Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#hostNetwork
     */
    readonly hostNetwork?: boolean;
    /**
     * (experimental) Use the host's pid namespace.
     *
     * Optional: Default to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#hostPID
     */
    readonly hostPid?: boolean;
    /**
     * (experimental) Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#hostname
     */
    readonly hostname?: string;
    /**
     * (experimental) ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec.
     *
     * If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#imagePullSecrets
     */
    readonly imagePullSecrets?: LocalObjectReference[];
    /**
     * (experimental) List of initialization containers belonging to the pod.
     *
     * Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#initContainers
     */
    readonly initContainers?: Container[];
    /**
     * (experimental) NodeName is a request to schedule this pod onto a specific node.
     *
     * If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#nodeName
     */
    readonly nodeName?: string;
    /**
     * (experimental) NodeSelector is a selector which must be true for the pod to fit on a node.
     *
     * Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * (experimental) Overhead represents the resource overhead associated with running a pod for a given RuntimeClass.
     *
     * This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#overhead
     */
    readonly overhead?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) PreemptionPolicy is the Policy for preempting pods with lower priority.
     *
     * One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     *
     * @default PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#preemptionPolicy
     */
    readonly preemptionPolicy?: string;
    /**
     * (experimental) The priority value.
     *
     * Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#priority
     */
    readonly priority?: number;
    /**
     * (experimental) If specified, indicates the pod's priority.
     *
     * "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#priorityClassName
     */
    readonly priorityClassName?: string;
    /**
     * (experimental) If specified, all readiness gates will be evaluated for pod readiness.
     *
     * A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to "True" More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#readinessGates
     */
    readonly readinessGates?: PodReadinessGate[];
    /**
     * (experimental) Restart policy for all containers within the pod.
     *
     * One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
     *
     * @default Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#restartPolicy
     */
    readonly restartPolicy?: string;
    /**
     * (experimental) RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the "legacy" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#runtimeClassName
     */
    readonly runtimeClassName?: string;
    /**
     * (experimental) If specified, the pod will be dispatched by specified scheduler.
     *
     * If not specified, the pod will be dispatched by default scheduler.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#schedulerName
     */
    readonly schedulerName?: string;
    /**
     * (experimental) SecurityContext holds pod-level security attributes and common container settings.
     *
     * Optional: Defaults to empty.  See type description for default values of each field.
     *
     * @default empty.  See type description for default values of each field.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#securityContext
     */
    readonly securityContext?: PodSecurityContext;
    /**
     * (experimental) DeprecatedServiceAccount is a depreciated alias for ServiceAccountName.
     *
     * Deprecated: Use serviceAccountName instead.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#serviceAccount
     */
    readonly serviceAccount?: string;
    /**
     * (experimental) ServiceAccountName is the name of the ServiceAccount to use to run this pod.
     *
     * More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * (experimental) If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default).
     *
     * In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#setHostnameAsFQDN
     */
    readonly setHostnameAsFqdn?: boolean;
    /**
     * (experimental) Share a single process namespace between all of the containers in a pod.
     *
     * When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#shareProcessNamespace
     */
    readonly shareProcessNamespace?: boolean;
    /**
     * (experimental) If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>". If not specified, the pod will not have a domainname at all.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#subdomain
     */
    readonly subdomain?: string;
    /**
     * (experimental) Optional duration in seconds the pod needs to terminate gracefully.
     *
     * May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.
     *
     * @default 30 seconds.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#terminationGracePeriodSeconds
     */
    readonly terminationGracePeriodSeconds?: number;
    /**
     * (experimental) If specified, the pod's tolerations.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#tolerations
     */
    readonly tolerations?: Toleration[];
    /**
     * (experimental) TopologySpreadConstraints describes how a group of pods ought to spread across topology domains.
     *
     * Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TopologySpreadConstraint[];
    /**
     * (experimental) List of volumes that can be mounted by containers belonging to the pod.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSpec#volumes
     */
    readonly volumes?: Volume[];
}
/**
 * Converts an object of type 'PodSpec' to JSON representation.
 */
export declare function toJson_PodSpec(obj: PodSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodTemplateSpec describes the data a pod should have when created from a template.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodTemplateSpec
 */
export interface PodTemplateSpec {
    /**
     * (experimental) Standard object's metadata.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodTemplateSpec#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of the pod.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodTemplateSpec#spec
     */
    readonly spec?: PodSpec;
}
/**
 * Converts an object of type 'PodTemplateSpec' to JSON representation.
 */
export declare function toJson_PodTemplateSpec(obj: PodTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) ReplicationControllerSpec is the specification of a replication controller.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ReplicationControllerSpec
 */
export interface ReplicationControllerSpec {
    /**
     * (experimental) Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.
     *
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     *
     * @default 0 (pod will be considered available as soon as it is ready)
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationControllerSpec#minReadySeconds
     */
    readonly minReadySeconds?: number;
    /**
     * (experimental) Replicas is the number of desired replicas.
     *
     * This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
     *
     * @default 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationControllerSpec#replicas
     */
    readonly replicas?: number;
    /**
     * (experimental) Selector is a label query over pods that should match the Replicas count.
     *
     * If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationControllerSpec#selector
     */
    readonly selector?: {
        [key: string]: string;
    };
    /**
     * (experimental) Template is the object that describes the pod that will be created if insufficient replicas are detected.
     *
     * This takes precedence over a TemplateRef. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ReplicationControllerSpec#template
     */
    readonly template?: PodTemplateSpec;
}
/**
 * Converts an object of type 'ReplicationControllerSpec' to JSON representation.
 */
export declare function toJson_ReplicationControllerSpec(obj: ReplicationControllerSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ResourceQuotaSpec
 */
export interface ResourceQuotaSpec {
    /**
     * (experimental) hard is the set of desired hard limits for each named resource.
     *
     * More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceQuotaSpec#hard
     */
    readonly hard?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values.
     *
     * For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceQuotaSpec#scopeSelector
     */
    readonly scopeSelector?: ScopeSelector;
    /**
     * (experimental) A collection of filters that must match each object tracked by a quota.
     *
     * If not specified, the quota matches all objects.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceQuotaSpec#scopes
     */
    readonly scopes?: string[];
}
/**
 * Converts an object of type 'ResourceQuotaSpec' to JSON representation.
 */
export declare function toJson_ResourceQuotaSpec(obj: ResourceQuotaSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) ServiceSpec describes the attributes that a user creates on a service.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServiceSpec
 */
export interface ServiceSpec {
    /**
     * (experimental) allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.
     *
     * Default is "true". It may be set to "false" if the cluster load-balancer does not rely on NodePorts. allocateLoadBalancerNodePorts may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type. This field is alpha-level and is only honored by servers that enable the ServiceLBNodePortControl feature.
     *
     * @default true". It may be set to "false" if the cluster load-balancer does not rely on NodePorts. allocateLoadBalancerNodePorts may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type. This field is alpha-level and is only honored by servers that enable the ServiceLBNodePortControl feature.
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#allocateLoadBalancerNodePorts
     */
    readonly allocateLoadBalancerNodePorts?: boolean;
    /**
     * (experimental) clusterIP is the IP address of the service and is usually assigned randomly.
     *
     * If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address. Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#clusterIP
     */
    readonly clusterIp?: string;
    /**
     * (experimental) ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.
     *
     * If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are "None", empty string (""), or a valid IP address.  Setting this to "None" makes a "headless service" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
     *
     * Unless the "IPv6DualStack" feature gate is enabled, this field is limited to one value, which must be the same as the clusterIP field.  If the feature gate is enabled, this field may hold a maximum of two entries (dual-stack IPs, in either order).  These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#clusterIPs
     */
    readonly clusterIPs?: string[];
    /**
     * (experimental) externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.
     *
     * These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#externalIPs
     */
    readonly externalIPs?: string[];
    /**
     * (experimental) externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be "ExternalName".
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#externalName
     */
    readonly externalName?: string;
    /**
     * (experimental) externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints.
     *
     * "Local" preserves the client source IP and avoids a second hop for LoadBalancer and Nodeport type services, but risks potentially imbalanced traffic spreading. "Cluster" obscures the client source IP and may cause a second hop to another node, but should have good overall load-spreading.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#externalTrafficPolicy
     */
    readonly externalTrafficPolicy?: string;
    /**
     * (experimental) healthCheckNodePort specifies the healthcheck nodePort for the service.
     *
     * This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#healthCheckNodePort
     */
    readonly healthCheckNodePort?: number;
    /**
     * (experimental) InternalTrafficPolicy specifies if the cluster internal traffic should be routed to all endpoints or node-local endpoints only.
     *
     * "Cluster" routes internal traffic to a Service to all endpoints. "Local" routes traffic to node-local endpoints only, traffic is dropped if no node-local endpoints are ready. The default value is "Cluster".
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#internalTrafficPolicy
     */
    readonly internalTrafficPolicy?: string;
    /**
     * (experimental) IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service, and is gated by the "IPv6DualStack" feature gate.  This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail.  This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service.  Valid values are "IPv4" and "IPv6".  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to "headless" services.  This field will be wiped when updating a Service to type ExternalName.
     *
     * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#ipFamilies
     */
    readonly ipFamilies?: string[];
    /**
     * (experimental) IPFamilyPolicy represents the dual-stack-ness requested or required by this Service, and is gated by the "IPv6DualStack" feature gate.
     *
     * If there is no value provided, then this field will be set to SingleStack. Services can be "SingleStack" (a single IP family), "PreferDualStack" (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or "RequireDualStack" (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field.  This field will be wiped when updating a service to type ExternalName.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#ipFamilyPolicy
     */
    readonly ipFamilyPolicy?: string;
    /**
     * (experimental) loadBalancerClass is the class of the load balancer implementation this Service belongs to.
     *
     * If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. "internal-vip" or "example.com/internal-vip". Unprefixed names are reserved for end-users. This field can only be set when the Service type is 'LoadBalancer'. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type 'LoadBalancer'. Once set, it can not be changed. This field will be wiped when a service is updated to a non 'LoadBalancer' type.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#loadBalancerClass
     */
    readonly loadBalancerClass?: string;
    /**
     * (experimental) Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field.
     *
     * This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#loadBalancerIP
     */
    readonly loadBalancerIp?: string;
    /**
     * (experimental) If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs.
     *
     * This field will be ignored if the cloud-provider does not support the feature." More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#loadBalancerSourceRanges
     */
    readonly loadBalancerSourceRanges?: string[];
    /**
     * (experimental) The list of ports that are exposed by this service.
     *
     * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#ports
     */
    readonly ports?: ServicePort[];
    /**
     * (experimental) publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready.
     *
     * The primary use case for setting this field is for a StatefulSet's Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered "ready" even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#publishNotReadyAddresses
     */
    readonly publishNotReadyAddresses?: boolean;
    /**
     * (experimental) Route service traffic to pods with label keys and values matching this selector.
     *
     * If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#selector
     */
    readonly selector?: {
        [key: string]: string;
    };
    /**
     * (experimental) Supports "ClientIP" and "None".
     *
     * Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     *
     * @default None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#sessionAffinity
     */
    readonly sessionAffinity?: string;
    /**
     * (experimental) sessionAffinityConfig contains the configurations of session affinity.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#sessionAffinityConfig
     */
    readonly sessionAffinityConfig?: SessionAffinityConfig;
    /**
     * (experimental) topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local.
     *
     * Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value "*" may be used to mean "any topology". This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied. This field is alpha-level and is only honored by servers that enable the ServiceTopology feature. This field is deprecated and will be removed in a future version.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#topologyKeys
     */
    readonly topologyKeys?: string[];
    /**
     * (experimental) type determines how the Service is exposed.
     *
     * Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. "ExternalName" aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     *
     * @default ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. "ExternalName" aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     * @experimental
     * @schema io.k8s.api.core.v1.ServiceSpec#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'ServiceSpec' to JSON representation.
 */
export declare function toJson_ServiceSpec(obj: ServiceSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LocalObjectReference
 */
export interface LocalObjectReference {
    /**
     * (experimental) Name of the referent.
     *
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LocalObjectReference#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'LocalObjectReference' to JSON representation.
 */
export declare function toJson_LocalObjectReference(obj: LocalObjectReference | undefined): Record<string, any> | undefined;
/**
 * (experimental) Endpoint represents a single logical "backend" implementing a service.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1.Endpoint
 */
export interface Endpoint {
    /**
     * (experimental) addresses of this endpoint.
     *
     * The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#addresses
     */
    readonly addresses: string[];
    /**
     * (experimental) conditions contains information about the current status of the endpoint.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#conditions
     */
    readonly conditions?: EndpointConditions;
    /**
     * (experimental) deprecatedTopology contains topology information part of the v1beta1 API.
     *
     * This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24).  While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#deprecatedTopology
     */
    readonly deprecatedTopology?: {
        [key: string]: string;
    };
    /**
     * (experimental) hints contains information associated with how an endpoint should be consumed.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#hints
     */
    readonly hints?: EndpointHints;
    /**
     * (experimental) hostname of this endpoint.
     *
     * This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#hostname
     */
    readonly hostname?: string;
    /**
     * (experimental) nodeName represents the name of the Node hosting this endpoint.
     *
     * This can be used to determine endpoints local to a Node. This field can be enabled with the EndpointSliceNodeName feature gate.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#nodeName
     */
    readonly nodeName?: string;
    /**
     * (experimental) targetRef is a reference to a Kubernetes object that represents this endpoint.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#targetRef
     */
    readonly targetRef?: ObjectReference;
    /**
     * (experimental) zone is the name of the Zone this endpoint exists in.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.Endpoint#zone
     */
    readonly zone?: string;
}
/**
 * Converts an object of type 'Endpoint' to JSON representation.
 */
export declare function toJson_Endpoint(obj: Endpoint | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointPort is a tuple that describes a single port.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EndpointPort
 */
export interface EndpointPort {
    /**
     * (experimental) The application protocol for this port.
     *
     * This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. This is a beta field that is guarded by the ServiceAppProtocol feature gate and enabled by default.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointPort#appProtocol
     */
    readonly appProtocol?: string;
    /**
     * (experimental) The name of this port.
     *
     * This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointPort#name
     */
    readonly name?: string;
    /**
     * (experimental) The port number of the endpoint.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointPort#port
     */
    readonly port: number;
    /**
     * (experimental) The IP protocol for this port.
     *
     * Must be UDP, TCP, or SCTP. Default is TCP.
     *
     * @default TCP.
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointPort#protocol
     */
    readonly protocol?: string;
}
/**
 * Converts an object of type 'EndpointPort' to JSON representation.
 */
export declare function toJson_EndpointPort(obj: EndpointPort | undefined): Record<string, any> | undefined;
/**
 * (experimental) Endpoint represents a single logical "backend" implementing a service.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.Endpoint
 */
export interface EndpointV1Beta1 {
    /**
     * (experimental) addresses of this endpoint.
     *
     * The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.Endpoint#addresses
     */
    readonly addresses: string[];
    /**
     * (experimental) conditions contains information about the current status of the endpoint.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.Endpoint#conditions
     */
    readonly conditions?: EndpointConditionsV1Beta1;
    /**
     * (experimental) hints contains information associated with how an endpoint should be consumed.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.Endpoint#hints
     */
    readonly hints?: EndpointHintsV1Beta1;
    /**
     * (experimental) hostname of this endpoint.
     *
     * This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.Endpoint#hostname
     */
    readonly hostname?: string;
    /**
     * (experimental) nodeName represents the name of the Node hosting this endpoint.
     *
     * This can be used to determine endpoints local to a Node. This field can be enabled with the EndpointSliceNodeName feature gate.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.Endpoint#nodeName
     */
    readonly nodeName?: string;
    /**
     * (experimental) targetRef is a reference to a Kubernetes object that represents this endpoint.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.Endpoint#targetRef
     */
    readonly targetRef?: ObjectReference;
    /**
     * (experimental) topology contains arbitrary topology information associated with the endpoint.
     *
     * These key/value pairs must conform with the label format. https://kubernetes.io/docs/concepts/overview/working-with-objects/labels Topology may include a maximum of 16 key/value pairs. This includes, but is not limited to the following well known keys: * kubernetes.io/hostname: the value indicates the hostname of the node
     * where the endpoint is located. This should match the corresponding
     * node label.
     * * topology.kubernetes.io/zone: the value indicates the zone where the
     * endpoint is located. This should match the corresponding node label.
     * * topology.kubernetes.io/region: the value indicates the region where the
     * endpoint is located. This should match the corresponding node label.
     * This field is deprecated and will be removed in future api versions.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.Endpoint#topology
     */
    readonly topology?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'EndpointV1Beta1' to JSON representation.
 */
export declare function toJson_EndpointV1Beta1(obj: EndpointV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointPort represents a Port used by an EndpointSlice.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.EndpointPort
 */
export interface EndpointPortV1Beta1 {
    /**
     * (experimental) The application protocol for this port.
     *
     * This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointPort#appProtocol
     */
    readonly appProtocol?: string;
    /**
     * (experimental) The name of this port.
     *
     * All ports in an EndpointSlice must have a unique name. If the EndpointSlice is dervied from a Kubernetes service, this corresponds to the Service.ports[].name. Name must either be an empty string or pass DNS_LABEL validation: * must be no more than 63 characters long. * must consist of lower case alphanumeric characters or '-'. * must start and end with an alphanumeric character. Default is empty string.
     *
     * @default empty string.
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointPort#name
     */
    readonly name?: string;
    /**
     * (experimental) The port number of the endpoint.
     *
     * If this is not specified, ports are not restricted and must be interpreted in the context of the specific consumer.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointPort#port
     */
    readonly port?: number;
    /**
     * (experimental) The IP protocol for this port.
     *
     * Must be UDP, TCP, or SCTP. Default is TCP.
     *
     * @default TCP.
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointPort#protocol
     */
    readonly protocol?: string;
}
/**
 * Converts an object of type 'EndpointPortV1Beta1' to JSON representation.
 */
export declare function toJson_EndpointPortV1Beta1(obj: EndpointPortV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
 *
 * @experimental
 * @schema io.k8s.api.events.v1beta1.EventSeries
 */
export interface EventSeriesV1Beta1 {
    /**
     * (experimental) count is the number of occurrences in this series up to the last heartbeat time.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.EventSeries#count
     */
    readonly count: number;
    /**
     * (experimental) lastObservedTime is the time when last Event from the series was seen before last heartbeat.
     *
     * @experimental
     * @schema io.k8s.api.events.v1beta1.EventSeries#lastObservedTime
     */
    readonly lastObservedTime: Date;
}
/**
 * Converts an object of type 'EventSeriesV1Beta1' to JSON representation.
 */
export declare function toJson_EventSeriesV1Beta1(obj: EventSeriesV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressSpec describes the Ingress the user wishes to exist.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressSpec
 */
export interface IngressSpecV1Beta1 {
    /**
     * (experimental) A default backend capable of servicing requests that don't match any rule.
     *
     * At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressSpec#backend
     */
    readonly backend?: IngressBackendV1Beta1;
    /**
     * (experimental) IngressClassName is the name of the IngressClass cluster resource.
     *
     * The associated IngressClass defines which controller will implement the resource. This replaces the deprecated `kubernetes.io/ingress.class` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressSpec#ingressClassName
     */
    readonly ingressClassName?: string;
    /**
     * (experimental) A list of host rules used to configure the Ingress.
     *
     * If unspecified, or no rule matches, all traffic is sent to the default backend.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressSpec#rules
     */
    readonly rules?: IngressRuleV1Beta1[];
    /**
     * (experimental) TLS configuration.
     *
     * Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressSpec#tls
     */
    readonly tls?: IngressTlsv1Beta1[];
}
/**
 * Converts an object of type 'IngressSpecV1Beta1' to JSON representation.
 */
export declare function toJson_IngressSpecV1Beta1(obj: IngressSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) FlowSchemaSpec describes how the FlowSchema's specification looks like.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec
 */
export interface FlowSchemaSpecV1Beta1 {
    /**
     * (experimental) `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema.
     *
     * `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#distinguisherMethod
     */
    readonly distinguisherMethod?: FlowDistinguisherMethodV1Beta1;
    /**
     * (experimental) `matchingPrecedence` is used to choose among the FlowSchemas that match a given request.
     *
     * The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#matchingPrecedence
     */
    readonly matchingPrecedence?: number;
    /**
     * (experimental) `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster.
     *
     * If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#priorityLevelConfiguration
     */
    readonly priorityLevelConfiguration: PriorityLevelConfigurationReferenceV1Beta1;
    /**
     * (experimental) `rules` describes which requests will match this flow schema.
     *
     * This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec#rules
     */
    readonly rules?: PolicyRulesWithSubjectsV1Beta1[];
}
/**
 * Converts an object of type 'FlowSchemaSpecV1Beta1' to JSON representation.
 */
export declare function toJson_FlowSchemaSpecV1Beta1(obj: FlowSchemaSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityLevelConfigurationSpec specifies the configuration of a priority level.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationSpec
 */
export interface PriorityLevelConfigurationSpecV1Beta1 {
    /**
     * (experimental) `limited` specifies how requests are handled for a Limited priority level.
     *
     * This field must be non-empty if and only if `type` is `"Limited"`.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationSpec#limited
     */
    readonly limited?: LimitedPriorityLevelConfigurationV1Beta1;
    /**
     * (experimental) `type` indicates whether this priority level is subject to limitation on request execution.
     *
     * A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationSpec#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'PriorityLevelConfigurationSpecV1Beta1' to JSON representation.
 */
export declare function toJson_PriorityLevelConfigurationSpecV1Beta1(obj: PriorityLevelConfigurationSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressSpec describes the Ingress the user wishes to exist.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressSpec
 */
export interface IngressSpec {
    /**
     * (experimental) DefaultBackend is the backend that should handle requests that don't match any rule.
     *
     * If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressSpec#defaultBackend
     */
    readonly defaultBackend?: IngressBackend;
    /**
     * (experimental) IngressClassName is the name of the IngressClass cluster resource.
     *
     * The associated IngressClass defines which controller will implement the resource. This replaces the deprecated `kubernetes.io/ingress.class` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressSpec#ingressClassName
     */
    readonly ingressClassName?: string;
    /**
     * (experimental) A list of host rules used to configure the Ingress.
     *
     * If unspecified, or no rule matches, all traffic is sent to the default backend.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressSpec#rules
     */
    readonly rules?: IngressRule[];
    /**
     * (experimental) TLS configuration.
     *
     * Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressSpec#tls
     */
    readonly tls?: IngressTls[];
}
/**
 * Converts an object of type 'IngressSpec' to JSON representation.
 */
export declare function toJson_IngressSpec(obj: IngressSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClassSpec provides information about the class of an Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressClassSpec
 */
export interface IngressClassSpec {
    /**
     * (experimental) Controller refers to the name of the controller that should handle this class.
     *
     * This allows for different "flavors" that are controlled by the same controller. For example, you may have different Parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassSpec#controller
     */
    readonly controller?: string;
    /**
     * (experimental) Parameters is a link to a custom resource containing additional configuration for the controller.
     *
     * This is optional if the controller does not require extra parameters.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassSpec#parameters
     */
    readonly parameters?: IngressClassParametersReference;
}
/**
 * Converts an object of type 'IngressClassSpec' to JSON representation.
 */
export declare function toJson_IngressClassSpec(obj: IngressClassSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) NetworkPolicySpec provides the specification of a NetworkPolicy.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.NetworkPolicySpec
 */
export interface NetworkPolicySpec {
    /**
     * (experimental) List of egress rules to be applied to the selected pods.
     *
     * Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicySpec#egress
     */
    readonly egress?: NetworkPolicyEgressRule[];
    /**
     * (experimental) List of ingress rules to be applied to the selected pods.
     *
     * Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicySpec#ingress
     */
    readonly ingress?: NetworkPolicyIngressRule[];
    /**
     * (experimental) Selects the pods to which this NetworkPolicy object applies.
     *
     * The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicySpec#podSelector
     */
    readonly podSelector: LabelSelector;
    /**
     * (experimental) List of rule types that the NetworkPolicy relates to.
     *
     * Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an Egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicySpec#policyTypes
     */
    readonly policyTypes?: string[];
}
/**
 * Converts an object of type 'NetworkPolicySpec' to JSON representation.
 */
export declare function toJson_NetworkPolicySpec(obj: NetworkPolicySpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClassSpec provides information about the class of an Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressClassSpec
 */
export interface IngressClassSpecV1Beta1 {
    /**
     * (experimental) Controller refers to the name of the controller that should handle this class.
     *
     * This allows for different "flavors" that are controlled by the same controller. For example, you may have different Parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassSpec#controller
     */
    readonly controller?: string;
    /**
     * (experimental) Parameters is a link to a custom resource containing additional configuration for the controller.
     *
     * This is optional if the controller does not require extra parameters.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassSpec#parameters
     */
    readonly parameters?: IngressClassParametersReferenceV1Beta1;
}
/**
 * Converts an object of type 'IngressClassSpecV1Beta1' to JSON representation.
 */
export declare function toJson_IngressClassSpecV1Beta1(obj: IngressClassSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) Overhead structure represents the resource overhead associated with running a pod.
 *
 * @experimental
 * @schema io.k8s.api.node.v1.Overhead
 */
export interface Overhead {
    /**
     * (experimental) PodFixed represents the fixed resource overhead associated with running a pod.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.Overhead#podFixed
     */
    readonly podFixed?: {
        [key: string]: Quantity;
    };
}
/**
 * Converts an object of type 'Overhead' to JSON representation.
 */
export declare function toJson_Overhead(obj: Overhead | undefined): Record<string, any> | undefined;
/**
 * (experimental) Scheduling specifies the scheduling constraints for nodes supporting a RuntimeClass.
 *
 * @experimental
 * @schema io.k8s.api.node.v1.Scheduling
 */
export interface Scheduling {
    /**
     * (experimental) nodeSelector lists labels that must be present on nodes that support this RuntimeClass.
     *
     * Pods using this RuntimeClass can only be scheduled to a node matched by this selector. The RuntimeClass nodeSelector is merged with a pod's existing nodeSelector. Any conflicts will cause the pod to be rejected in admission.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.Scheduling#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * (experimental) tolerations are appended (excluding duplicates) to pods running with this RuntimeClass during admission, effectively unioning the set of nodes tolerated by the pod and the RuntimeClass.
     *
     * @experimental
     * @schema io.k8s.api.node.v1.Scheduling#tolerations
     */
    readonly tolerations?: Toleration[];
}
/**
 * Converts an object of type 'Scheduling' to JSON representation.
 */
export declare function toJson_Scheduling(obj: Scheduling | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClassSpec is a specification of a RuntimeClass.
 *
 * It contains parameters that are required to describe the RuntimeClass to the Container Runtime Interface (CRI) implementation, as well as any other components that need to understand how the pod will be run. The RuntimeClassSpec is immutable.
 *
 * @experimental
 * @schema io.k8s.api.node.v1alpha1.RuntimeClassSpec
 */
export interface RuntimeClassSpecV1Alpha1 {
    /**
     * (experimental) Overhead represents the resource overhead associated with running a pod for a given RuntimeClass.
     *
     * For more details, see https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.15, and is only honored by servers that enable the PodOverhead feature.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.RuntimeClassSpec#overhead
     */
    readonly overhead?: OverheadV1Alpha1;
    /**
     * (experimental) RuntimeHandler specifies the underlying runtime and configuration that the CRI implementation will use to handle pods of this class.
     *
     * The possible values are specific to the node & CRI configuration.  It is assumed that all handlers are available on every node, and handlers of the same name are equivalent on every node. For example, a handler called "runc" might specify that the runc OCI runtime (using native Linux containers) will be used to run the containers in a pod. The RuntimeHandler must be lowercase, conform to the DNS Label (RFC 1123) requirements, and is immutable.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.RuntimeClassSpec#runtimeHandler
     */
    readonly runtimeHandler: string;
    /**
     * (experimental) Scheduling holds the scheduling constraints to ensure that pods running with this RuntimeClass are scheduled to nodes that support it.
     *
     * If scheduling is nil, this RuntimeClass is assumed to be supported by all nodes.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.RuntimeClassSpec#scheduling
     */
    readonly scheduling?: SchedulingV1Alpha1;
}
/**
 * Converts an object of type 'RuntimeClassSpecV1Alpha1' to JSON representation.
 */
export declare function toJson_RuntimeClassSpecV1Alpha1(obj: RuntimeClassSpecV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) Overhead structure represents the resource overhead associated with running a pod.
 *
 * @experimental
 * @schema io.k8s.api.node.v1beta1.Overhead
 */
export interface OverheadV1Beta1 {
    /**
     * (experimental) PodFixed represents the fixed resource overhead associated with running a pod.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.Overhead#podFixed
     */
    readonly podFixed?: {
        [key: string]: Quantity;
    };
}
/**
 * Converts an object of type 'OverheadV1Beta1' to JSON representation.
 */
export declare function toJson_OverheadV1Beta1(obj: OverheadV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) Scheduling specifies the scheduling constraints for nodes supporting a RuntimeClass.
 *
 * @experimental
 * @schema io.k8s.api.node.v1beta1.Scheduling
 */
export interface SchedulingV1Beta1 {
    /**
     * (experimental) nodeSelector lists labels that must be present on nodes that support this RuntimeClass.
     *
     * Pods using this RuntimeClass can only be scheduled to a node matched by this selector. The RuntimeClass nodeSelector is merged with a pod's existing nodeSelector. Any conflicts will cause the pod to be rejected in admission.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.Scheduling#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * (experimental) tolerations are appended (excluding duplicates) to pods running with this RuntimeClass during admission, effectively unioning the set of nodes tolerated by the pod and the RuntimeClass.
     *
     * @experimental
     * @schema io.k8s.api.node.v1beta1.Scheduling#tolerations
     */
    readonly tolerations?: Toleration[];
}
/**
 * Converts an object of type 'SchedulingV1Beta1' to JSON representation.
 */
export declare function toJson_SchedulingV1Beta1(obj: SchedulingV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1.PodDisruptionBudgetSpec
 */
export interface PodDisruptionBudgetSpec {
    /**
     * (experimental) An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".
     *
     * @experimental
     * @schema io.k8s.api.policy.v1.PodDisruptionBudgetSpec#maxUnavailable
     */
    readonly maxUnavailable?: IntOrString;
    /**
     * (experimental) An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%".
     *
     * @experimental
     * @schema io.k8s.api.policy.v1.PodDisruptionBudgetSpec#minAvailable
     */
    readonly minAvailable?: IntOrString;
    /**
     * (experimental) Label query over pods whose evictions are managed by the disruption budget.
     *
     * A null selector will match no pods, while an empty ({}) selector will select all pods within the namespace.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1.PodDisruptionBudgetSpec#selector
     */
    readonly selector?: LabelSelector;
}
/**
 * Converts an object of type 'PodDisruptionBudgetSpec' to JSON representation.
 */
export declare function toJson_PodDisruptionBudgetSpec(obj: PodDisruptionBudgetSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) DeleteOptions may be provided when deleting an API object.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions
 */
export interface DeleteOptions {
    /**
     * (experimental) APIVersion defines the versioned schema of this representation of an object.
     *
     * Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) When present, indicates that modifications should not be persisted.
     *
     * An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#dryRun
     */
    readonly dryRun?: string[];
    /**
     * (experimental) The duration in seconds before the object should be deleted.
     *
     * Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     *
     * @default a per object value if not specified. zero means delete immediately.
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#gracePeriodSeconds
     */
    readonly gracePeriodSeconds?: number;
    /**
     * (experimental) Kind is a string value representing the REST resource this object represents.
     *
     * Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#kind
     */
    readonly kind?: IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind;
    /**
     * (experimental) Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#orphanDependents
     */
    readonly orphanDependents?: boolean;
    /**
     * (experimental) Must be fulfilled before a deletion is carried out.
     *
     * If not possible, a 409 Conflict status will be returned.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#preconditions
     */
    readonly preconditions?: Preconditions;
    /**
     * (experimental) Whether and how garbage collection will be performed.
     *
     * Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#propagationPolicy
     */
    readonly propagationPolicy?: string;
}
/**
 * Converts an object of type 'DeleteOptions' to JSON representation.
 */
export declare function toJson_DeleteOptions(obj: DeleteOptions | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetSpec
 */
export interface PodDisruptionBudgetSpecV1Beta1 {
    /**
     * (experimental) An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetSpec#maxUnavailable
     */
    readonly maxUnavailable?: IntOrString;
    /**
     * (experimental) An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%".
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetSpec#minAvailable
     */
    readonly minAvailable?: IntOrString;
    /**
     * (experimental) Label query over pods whose evictions are managed by the disruption budget.
     *
     * A null selector selects no pods. An empty selector ({}) also selects no pods, which differs from standard behavior of selecting all pods. In policy/v1, an empty selector will select all pods in the namespace.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodDisruptionBudgetSpec#selector
     */
    readonly selector?: LabelSelector;
}
/**
 * Converts an object of type 'PodDisruptionBudgetSpecV1Beta1' to JSON representation.
 */
export declare function toJson_PodDisruptionBudgetSpecV1Beta1(obj: PodDisruptionBudgetSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodSecurityPolicySpec defines the policy enforced.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec
 */
export interface PodSecurityPolicySpecV1Beta1 {
    /**
     * (experimental) allowPrivilegeEscalation determines if a pod can request to allow privilege escalation.
     *
     * If unspecified, defaults to true.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#allowPrivilegeEscalation
     */
    readonly allowPrivilegeEscalation?: boolean;
    /**
     * (experimental) AllowedCSIDrivers is an allowlist of inline CSI drivers that must be explicitly set to be embedded within a pod spec.
     *
     * An empty value indicates that any CSI driver can be used for inline ephemeral volumes. This is a beta field, and is only honored if the API server enables the CSIInlineVolume feature gate.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#allowedCSIDrivers
     */
    readonly allowedCsiDrivers?: AllowedCsiDriverV1Beta1[];
    /**
     * (experimental) allowedCapabilities is a list of capabilities that can be requested to add to the container.
     *
     * Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#allowedCapabilities
     */
    readonly allowedCapabilities?: string[];
    /**
     * (experimental) allowedFlexVolumes is an allowlist of Flexvolumes.
     *
     * Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the "volumes" field.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#allowedFlexVolumes
     */
    readonly allowedFlexVolumes?: AllowedFlexVolumeV1Beta1[];
    /**
     * (experimental) allowedHostPaths is an allowlist of host paths.
     *
     * Empty indicates that all host paths may be used.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#allowedHostPaths
     */
    readonly allowedHostPaths?: AllowedHostPathV1Beta1[];
    /**
     * (experimental) AllowedProcMountTypes is an allowlist of allowed ProcMountTypes.
     *
     * Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#allowedProcMountTypes
     */
    readonly allowedProcMountTypes?: string[];
    /**
     * (experimental) allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none.
     *
     * Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to allowlist all allowed unsafe sysctls explicitly to avoid rejection.
     *
     * Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#allowedUnsafeSysctls
     */
    readonly allowedUnsafeSysctls?: string[];
    /**
     * (experimental) defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.
     *
     * You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#defaultAddCapabilities
     */
    readonly defaultAddCapabilities?: string[];
    /**
     * (experimental) defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#defaultAllowPrivilegeEscalation
     */
    readonly defaultAllowPrivilegeEscalation?: boolean;
    /**
     * (experimental) forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none.
     *
     * Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.
     *
     * Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#forbiddenSysctls
     */
    readonly forbiddenSysctls?: string[];
    /**
     * (experimental) fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#fsGroup
     */
    readonly fsGroup: FsGroupStrategyOptionsV1Beta1;
    /**
     * (experimental) hostIPC determines if the policy allows the use of HostIPC in the pod spec.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#hostIPC
     */
    readonly hostIpc?: boolean;
    /**
     * (experimental) hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#hostNetwork
     */
    readonly hostNetwork?: boolean;
    /**
     * (experimental) hostPID determines if the policy allows the use of HostPID in the pod spec.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#hostPID
     */
    readonly hostPid?: boolean;
    /**
     * (experimental) hostPorts determines which host port ranges are allowed to be exposed.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#hostPorts
     */
    readonly hostPorts?: HostPortRangeV1Beta1[];
    /**
     * (experimental) privileged determines if a pod can request to be run as privileged.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#privileged
     */
    readonly privileged?: boolean;
    /**
     * (experimental) readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.
     *
     * If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#readOnlyRootFilesystem
     */
    readonly readOnlyRootFilesystem?: boolean;
    /**
     * (experimental) requiredDropCapabilities are the capabilities that will be dropped from the container.
     *
     * These are required to be dropped and cannot be added.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#requiredDropCapabilities
     */
    readonly requiredDropCapabilities?: string[];
    /**
     * (experimental) RunAsGroup is the strategy that will dictate the allowable RunAsGroup values that may be set.
     *
     * If this field is omitted, the pod's RunAsGroup can take any value. This field requires the RunAsGroup feature gate to be enabled.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#runAsGroup
     */
    readonly runAsGroup?: RunAsGroupStrategyOptionsV1Beta1;
    /**
     * (experimental) runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#runAsUser
     */
    readonly runAsUser: RunAsUserStrategyOptionsV1Beta1;
    /**
     * (experimental) runtimeClass is the strategy that will dictate the allowable RuntimeClasses for a pod.
     *
     * If this field is omitted, the pod's runtimeClassName field is unrestricted. Enforcement of this field depends on the RuntimeClass feature gate being enabled.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#runtimeClass
     */
    readonly runtimeClass?: RuntimeClassStrategyOptionsV1Beta1;
    /**
     * (experimental) seLinux is the strategy that will dictate the allowable labels that may be set.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#seLinux
     */
    readonly seLinux: SeLinuxStrategyOptionsV1Beta1;
    /**
     * (experimental) supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#supplementalGroups
     */
    readonly supplementalGroups: SupplementalGroupsStrategyOptionsV1Beta1;
    /**
     * (experimental) volumes is an allowlist of volume plugins.
     *
     * Empty indicates that no volumes may be used. To allow all volumes you may use '*'.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.PodSecurityPolicySpec#volumes
     */
    readonly volumes?: string[];
}
/**
 * Converts an object of type 'PodSecurityPolicySpecV1Beta1' to JSON representation.
 */
export declare function toJson_PodSecurityPolicySpecV1Beta1(obj: PodSecurityPolicySpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.AggregationRule
 */
export interface AggregationRule {
    /**
     * (experimental) ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules.
     *
     * If any of the selectors match, then the ClusterRole's permissions will be added
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.AggregationRule#clusterRoleSelectors
     */
    readonly clusterRoleSelectors?: LabelSelector[];
}
/**
 * Converts an object of type 'AggregationRule' to JSON representation.
 */
export declare function toJson_AggregationRule(obj: AggregationRule | undefined): Record<string, any> | undefined;
/**
 * (experimental) PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.PolicyRule
 */
export interface PolicyRule {
    /**
     * (experimental) APIGroups is the name of the APIGroup that contains the resources.
     *
     * If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.PolicyRule#apiGroups
     */
    readonly apiGroups?: string[];
    /**
     * (experimental) NonResourceURLs is a set of partial urls that a user should have access to.
     *
     * *s are allowed, but only as the full, final step in the path Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as "pods" or "secrets") or non-resource URL paths (such as "/api"),  but not both.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.PolicyRule#nonResourceURLs
     */
    readonly nonResourceUrLs?: string[];
    /**
     * (experimental) ResourceNames is an optional white list of names that the rule applies to.
     *
     * An empty set means that everything is allowed.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.PolicyRule#resourceNames
     */
    readonly resourceNames?: string[];
    /**
     * (experimental) Resources is a list of resources this rule applies to.
     *
     * ResourceAll represents all resources.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.PolicyRule#resources
     */
    readonly resources?: string[];
    /**
     * (experimental) Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.
     *
     * VerbAll represents all kinds.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.PolicyRule#verbs
     */
    readonly verbs: string[];
}
/**
 * Converts an object of type 'PolicyRule' to JSON representation.
 */
export declare function toJson_PolicyRule(obj: PolicyRule | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleRef contains information that points to the role being used.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.RoleRef
 */
export interface RoleRef {
    /**
     * (experimental) APIGroup is the group for the resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleRef#apiGroup
     */
    readonly apiGroup: string;
    /**
     * (experimental) Kind is the type of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleRef#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name is the name of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.RoleRef#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'RoleRef' to JSON representation.
 */
export declare function toJson_RoleRef(obj: RoleRef | undefined): Record<string, any> | undefined;
/**
 * (experimental) Subject contains a reference to the object or user identities a role binding applies to.
 *
 * This can either hold a direct API object reference, or a value for non-objects such as user and group names.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1.Subject
 */
export interface Subject {
    /**
     * (experimental) APIGroup holds the API group of the referenced subject.
     *
     * Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
     *
     * @default for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
     * @experimental
     * @schema io.k8s.api.rbac.v1.Subject#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * (experimental) Kind of object being referenced.
     *
     * Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.Subject#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name of the object being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.Subject#name
     */
    readonly name: string;
    /**
     * (experimental) Namespace of the referenced object.
     *
     * If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1.Subject#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'Subject' to JSON representation.
 */
export declare function toJson_Subject(obj: Subject | undefined): Record<string, any> | undefined;
/**
 * (experimental) AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.AggregationRule
 */
export interface AggregationRuleV1Alpha1 {
    /**
     * (experimental) ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules.
     *
     * If any of the selectors match, then the ClusterRole's permissions will be added
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.AggregationRule#clusterRoleSelectors
     */
    readonly clusterRoleSelectors?: LabelSelector[];
}
/**
 * Converts an object of type 'AggregationRuleV1Alpha1' to JSON representation.
 */
export declare function toJson_AggregationRuleV1Alpha1(obj: AggregationRuleV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.PolicyRule
 */
export interface PolicyRuleV1Alpha1 {
    /**
     * (experimental) APIGroups is the name of the APIGroup that contains the resources.
     *
     * If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.PolicyRule#apiGroups
     */
    readonly apiGroups?: string[];
    /**
     * (experimental) NonResourceURLs is a set of partial urls that a user should have access to.
     *
     * *s are allowed, but only as the full, final step in the path Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as "pods" or "secrets") or non-resource URL paths (such as "/api"),  but not both.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.PolicyRule#nonResourceURLs
     */
    readonly nonResourceUrLs?: string[];
    /**
     * (experimental) ResourceNames is an optional white list of names that the rule applies to.
     *
     * An empty set means that everything is allowed.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.PolicyRule#resourceNames
     */
    readonly resourceNames?: string[];
    /**
     * (experimental) Resources is a list of resources this rule applies to.
     *
     * ResourceAll represents all resources.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.PolicyRule#resources
     */
    readonly resources?: string[];
    /**
     * (experimental) Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.
     *
     * VerbAll represents all kinds.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.PolicyRule#verbs
     */
    readonly verbs: string[];
}
/**
 * Converts an object of type 'PolicyRuleV1Alpha1' to JSON representation.
 */
export declare function toJson_PolicyRuleV1Alpha1(obj: PolicyRuleV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleRef contains information that points to the role being used.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.RoleRef
 */
export interface RoleRefV1Alpha1 {
    /**
     * (experimental) APIGroup is the group for the resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleRef#apiGroup
     */
    readonly apiGroup: string;
    /**
     * (experimental) Kind is the type of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleRef#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name is the name of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.RoleRef#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'RoleRefV1Alpha1' to JSON representation.
 */
export declare function toJson_RoleRefV1Alpha1(obj: RoleRefV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) Subject contains a reference to the object or user identities a role binding applies to.
 *
 * This can either hold a direct API object reference, or a value for non-objects such as user and group names.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1alpha1.Subject
 */
export interface SubjectV1Alpha1 {
    /**
     * (experimental) APIVersion holds the API group and version of the referenced subject.
     *
     * Defaults to "v1" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io/v1alpha1" for User and Group subjects.
     *
     * @default v1" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io/v1alpha1" for User and Group subjects.
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.Subject#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) Kind of object being referenced.
     *
     * Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.Subject#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name of the object being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.Subject#name
     */
    readonly name: string;
    /**
     * (experimental) Namespace of the referenced object.
     *
     * If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1alpha1.Subject#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'SubjectV1Alpha1' to JSON representation.
 */
export declare function toJson_SubjectV1Alpha1(obj: SubjectV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.AggregationRule
 */
export interface AggregationRuleV1Beta1 {
    /**
     * (experimental) ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules.
     *
     * If any of the selectors match, then the ClusterRole's permissions will be added
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.AggregationRule#clusterRoleSelectors
     */
    readonly clusterRoleSelectors?: LabelSelector[];
}
/**
 * Converts an object of type 'AggregationRuleV1Beta1' to JSON representation.
 */
export declare function toJson_AggregationRuleV1Beta1(obj: AggregationRuleV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.PolicyRule
 */
export interface PolicyRuleV1Beta1 {
    /**
     * (experimental) APIGroups is the name of the APIGroup that contains the resources.
     *
     * If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.PolicyRule#apiGroups
     */
    readonly apiGroups?: string[];
    /**
     * (experimental) NonResourceURLs is a set of partial urls that a user should have access to.
     *
     * *s are allowed, but only as the full, final step in the path Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as "pods" or "secrets") or non-resource URL paths (such as "/api"),  but not both.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.PolicyRule#nonResourceURLs
     */
    readonly nonResourceUrLs?: string[];
    /**
     * (experimental) ResourceNames is an optional white list of names that the rule applies to.
     *
     * An empty set means that everything is allowed.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.PolicyRule#resourceNames
     */
    readonly resourceNames?: string[];
    /**
     * (experimental) Resources is a list of resources this rule applies to.
     *
     * '*' represents all resources in the specified apiGroups. '_/foo' represents the subresource 'foo' for all resources in the specified apiGroups.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.PolicyRule#resources
     */
    readonly resources?: string[];
    /**
     * (experimental) Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule.
     *
     * VerbAll represents all kinds.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.PolicyRule#verbs
     */
    readonly verbs: string[];
}
/**
 * Converts an object of type 'PolicyRuleV1Beta1' to JSON representation.
 */
export declare function toJson_PolicyRuleV1Beta1(obj: PolicyRuleV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) RoleRef contains information that points to the role being used.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.RoleRef
 */
export interface RoleRefV1Beta1 {
    /**
     * (experimental) APIGroup is the group for the resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleRef#apiGroup
     */
    readonly apiGroup: string;
    /**
     * (experimental) Kind is the type of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleRef#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name is the name of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.RoleRef#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'RoleRefV1Beta1' to JSON representation.
 */
export declare function toJson_RoleRefV1Beta1(obj: RoleRefV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) Subject contains a reference to the object or user identities a role binding applies to.
 *
 * This can either hold a direct API object reference, or a value for non-objects such as user and group names.
 *
 * @experimental
 * @schema io.k8s.api.rbac.v1beta1.Subject
 */
export interface SubjectV1Beta1 {
    /**
     * (experimental) APIGroup holds the API group of the referenced subject.
     *
     * Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
     *
     * @default for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.Subject#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * (experimental) Kind of object being referenced.
     *
     * Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.Subject#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name of the object being referenced.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.Subject#name
     */
    readonly name: string;
    /**
     * (experimental) Namespace of the referenced object.
     *
     * If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
     *
     * @experimental
     * @schema io.k8s.api.rbac.v1beta1.Subject#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'SubjectV1Beta1' to JSON representation.
 */
export declare function toJson_SubjectV1Beta1(obj: SubjectV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIDriverSpec is the specification of a CSIDriver.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSIDriverSpec
 */
export interface CsiDriverSpec {
    /**
     * (experimental) attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting.
     *
     * The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.
     *
     * This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverSpec#attachRequired
     */
    readonly attachRequired?: boolean;
    /**
     * (experimental) Defines if the underlying volume supports changing ownership and permission of the volume before being mounted.
     *
     * Refer to the specific FSGroupPolicy values for additional details. This field is alpha-level, and is only honored by servers that enable the CSIVolumeFSGroupPolicy feature gate.
     *
     * This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverSpec#fsGroupPolicy
     */
    readonly fsGroupPolicy?: string;
    /**
     * (experimental) If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume defined by a CSIVolumeSource, otherwise "false".
     *
     * "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.
     *
     * This field is immutable.
     *
     * @default false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverSpec#podInfoOnMount
     */
    readonly podInfoOnMount?: boolean;
    /**
     * (experimental) RequiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume.
     *
     * This field defaults to false.
     *
     * Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
     *
     * This is a beta feature and only available when the CSIServiceAccountToken feature is enabled.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverSpec#requiresRepublish
     */
    readonly requiresRepublish?: boolean;
    /**
     * (experimental) If set to true, storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information.
     *
     * The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.
     *
     * Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.
     *
     * This field is immutable.
     *
     * This is a beta field and only available when the CSIStorageCapacity feature is enabled. The default is false.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverSpec#storageCapacity
     */
    readonly storageCapacity?: boolean;
    /**
     * (experimental) TokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication.
     *
     * Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
     * "<audience>": {
     * "token": <token>,
     * "expirationTimestamp": <expiration timestamp in RFC3339>,
     * },
     * ...
     * }
     *
     * Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
     *
     * This is a beta feature and only available when the CSIServiceAccountToken feature is enabled.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverSpec#tokenRequests
     */
    readonly tokenRequests?: TokenRequest[];
    /**
     * (experimental) volumeLifecycleModes defines what kind of volumes this CSI volume driver supports.
     *
     * The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism. The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume. For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future. This field is beta.
     *
     * This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSIDriverSpec#volumeLifecycleModes
     */
    readonly volumeLifecycleModes?: string[];
}
/**
 * Converts an object of type 'CsiDriverSpec' to JSON representation.
 */
export declare function toJson_CsiDriverSpec(obj: CsiDriverSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSINodeSpec holds information about the specification of all CSI drivers installed on a node.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSINodeSpec
 */
export interface CsiNodeSpec {
    /**
     * (experimental) drivers is a list of information of all CSI Drivers existing on a node.
     *
     * If all drivers in the list are uninstalled, this can become empty.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINodeSpec#drivers
     */
    readonly drivers: CsiNodeDriver[];
}
/**
 * Converts an object of type 'CsiNodeSpec' to JSON representation.
 */
export declare function toJson_CsiNodeSpec(obj: CsiNodeSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) A topology selector term represents the result of label queries.
 *
 * A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.TopologySelectorTerm
 */
export interface TopologySelectorTerm {
    /**
     * (experimental) A list of topology selector requirements by labels.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TopologySelectorTerm#matchLabelExpressions
     */
    readonly matchLabelExpressions?: TopologySelectorLabelRequirement[];
}
/**
 * Converts an object of type 'TopologySelectorTerm' to JSON representation.
 */
export declare function toJson_TopologySelectorTerm(obj: TopologySelectorTerm | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentSpec is the specification of a VolumeAttachment request.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.VolumeAttachmentSpec
 */
export interface VolumeAttachmentSpec {
    /**
     * (experimental) Attacher indicates the name of the volume driver that MUST handle this request.
     *
     * This is the name returned by GetPluginName().
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachmentSpec#attacher
     */
    readonly attacher: string;
    /**
     * (experimental) The node that the volume should be attached to.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachmentSpec#nodeName
     */
    readonly nodeName: string;
    /**
     * (experimental) Source represents the volume that should be attached.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachmentSpec#source
     */
    readonly source: VolumeAttachmentSource;
}
/**
 * Converts an object of type 'VolumeAttachmentSpec' to JSON representation.
 */
export declare function toJson_VolumeAttachmentSpec(obj: VolumeAttachmentSpec | undefined): Record<string, any> | undefined;
/**
 * @experimental
 * @schema io.k8s.apimachinery.pkg.api.resource.Quantity
 */
export declare class Quantity {
    readonly value: any;
    /**
     * @experimental
     */
    static fromString(value: string): Quantity;
    /**
     * @experimental
     */
    static fromNumber(value: number): Quantity;
    private constructor();
}
/**
 * (experimental) A label selector is a label query over a set of resources.
 *
 * The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
 */
export interface LabelSelector {
    /**
     * (experimental) matchExpressions is a list of label selector requirements.
     *
     * The requirements are ANDed.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector#matchExpressions
     */
    readonly matchExpressions?: LabelSelectorRequirement[];
    /**
     * (experimental) matchLabels is a map of {key,value} pairs.
     *
     * A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'LabelSelector' to JSON representation.
 */
export declare function toJson_LabelSelector(obj: LabelSelector | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentSpec is the specification of a VolumeAttachment request.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentSpec
 */
export interface VolumeAttachmentSpecV1Alpha1 {
    /**
     * (experimental) Attacher indicates the name of the volume driver that MUST handle this request.
     *
     * This is the name returned by GetPluginName().
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentSpec#attacher
     */
    readonly attacher: string;
    /**
     * (experimental) The node that the volume should be attached to.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentSpec#nodeName
     */
    readonly nodeName: string;
    /**
     * (experimental) Source represents the volume that should be attached.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentSpec#source
     */
    readonly source: VolumeAttachmentSourceV1Alpha1;
}
/**
 * Converts an object of type 'VolumeAttachmentSpecV1Alpha1' to JSON representation.
 */
export declare function toJson_VolumeAttachmentSpecV1Alpha1(obj: VolumeAttachmentSpecV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSIDriverSpec is the specification of a CSIDriver.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec
 */
export interface CsiDriverSpecV1Beta1 {
    /**
     * (experimental) attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting.
     *
     * The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.
     *
     * This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec#attachRequired
     */
    readonly attachRequired?: boolean;
    /**
     * (experimental) Defines if the underlying volume supports changing ownership and permission of the volume before being mounted.
     *
     * Refer to the specific FSGroupPolicy values for additional details. This field is alpha-level, and is only honored by servers that enable the CSIVolumeFSGroupPolicy feature gate.
     *
     * This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec#fsGroupPolicy
     */
    readonly fsGroupPolicy?: string;
    /**
     * (experimental) If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume defined by a CSIVolumeSource, otherwise "false".
     *
     * "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.
     *
     * This field is immutable.
     *
     * @default false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec#podInfoOnMount
     */
    readonly podInfoOnMount?: boolean;
    /**
     * (experimental) RequiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume.
     *
     * This field defaults to false.
     *
     * Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
     *
     * This is a beta feature and only available when the CSIServiceAccountToken feature is enabled.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec#requiresRepublish
     */
    readonly requiresRepublish?: boolean;
    /**
     * (experimental) If set to true, storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information.
     *
     * The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.
     *
     * Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.
     *
     * This field is immutable.
     *
     * This is a beta field and only available when the CSIStorageCapacity feature is enabled. The default is false.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec#storageCapacity
     */
    readonly storageCapacity?: boolean;
    /**
     * (experimental) TokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication.
     *
     * Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
     * "<audience>": {
     * "token": <token>,
     * "expirationTimestamp": <expiration timestamp in RFC3339>,
     * },
     * ...
     * }
     *
     * Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
     *
     * This is a beta feature and only available when the CSIServiceAccountToken feature is enabled.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec#tokenRequests
     */
    readonly tokenRequests?: TokenRequestV1Beta1[];
    /**
     * (experimental) VolumeLifecycleModes defines what kind of volumes this CSI volume driver supports.
     *
     * The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism. The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume. For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.
     *
     * This field is immutable.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSIDriverSpec#volumeLifecycleModes
     */
    readonly volumeLifecycleModes?: string[];
}
/**
 * Converts an object of type 'CsiDriverSpecV1Beta1' to JSON representation.
 */
export declare function toJson_CsiDriverSpecV1Beta1(obj: CsiDriverSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSINodeSpec holds information about the specification of all CSI drivers installed on a node.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSINodeSpec
 */
export interface CsiNodeSpecV1Beta1 {
    /**
     * (experimental) drivers is a list of information of all CSI Drivers existing on a node.
     *
     * If all drivers in the list are uninstalled, this can become empty.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINodeSpec#drivers
     */
    readonly drivers: CsiNodeDriverV1Beta1[];
}
/**
 * Converts an object of type 'CsiNodeSpecV1Beta1' to JSON representation.
 */
export declare function toJson_CsiNodeSpecV1Beta1(obj: CsiNodeSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentSpec is the specification of a VolumeAttachment request.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentSpec
 */
export interface VolumeAttachmentSpecV1Beta1 {
    /**
     * (experimental) Attacher indicates the name of the volume driver that MUST handle this request.
     *
     * This is the name returned by GetPluginName().
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentSpec#attacher
     */
    readonly attacher: string;
    /**
     * (experimental) The node that the volume should be attached to.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentSpec#nodeName
     */
    readonly nodeName: string;
    /**
     * (experimental) Source represents the volume that should be attached.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentSpec#source
     */
    readonly source: VolumeAttachmentSourceV1Beta1;
}
/**
 * Converts an object of type 'VolumeAttachmentSpecV1Beta1' to JSON representation.
 */
export declare function toJson_VolumeAttachmentSpecV1Beta1(obj: VolumeAttachmentSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionSpec describes how a user wants their resource to appear.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec
 */
export interface CustomResourceDefinitionSpec {
    /**
     * (experimental) conversion defines conversion settings for the CRD.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#conversion
     */
    readonly conversion?: CustomResourceConversion;
    /**
     * (experimental) group is the API group of the defined custom resource.
     *
     * The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#group
     */
    readonly group: string;
    /**
     * (experimental) names specify the resource and kind names for the custom resource.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#names
     */
    readonly names: CustomResourceDefinitionNames;
    /**
     * (experimental) preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage.
     *
     * apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#preserveUnknownFields
     */
    readonly preserveUnknownFields?: boolean;
    /**
     * (experimental) scope indicates whether the defined custom resource is cluster- or namespace-scoped.
     *
     * Allowed values are `Cluster` and `Namespaced`.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#scope
     */
    readonly scope: string;
    /**
     * (experimental) versions is the list of all API versions of the defined custom resource.
     *
     * Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec#versions
     */
    readonly versions: CustomResourceDefinitionVersion[];
}
/**
 * Converts an object of type 'CustomResourceDefinitionSpec' to JSON representation.
 */
export declare function toJson_CustomResourceDefinitionSpec(obj: CustomResourceDefinitionSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionSpec describes how a user wants their resource to appear.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec
 */
export interface CustomResourceDefinitionSpecV1Beta1 {
    /**
     * (experimental) additionalPrinterColumns specifies additional columns returned in Table output.
     *
     * See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If present, this field configures columns for all versions. Top-level and per-version columns are mutually exclusive. If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#additionalPrinterColumns
     */
    readonly additionalPrinterColumns?: CustomResourceColumnDefinitionV1Beta1[];
    /**
     * (experimental) conversion defines conversion settings for the CRD.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#conversion
     */
    readonly conversion?: CustomResourceConversionV1Beta1;
    /**
     * (experimental) group is the API group of the defined custom resource.
     *
     * The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#group
     */
    readonly group: string;
    /**
     * (experimental) names specify the resource and kind names for the custom resource.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#names
     */
    readonly names: CustomResourceDefinitionNamesV1Beta1;
    /**
     * (experimental) preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage.
     *
     * apiVersion, kind, metadata and known fields inside metadata are always preserved. If false, schemas must be defined for all versions. Defaults to true in v1beta for backwards compatibility. Deprecated: will be required to be false in v1. Preservation of unknown fields can be specified in the validation schema using the `x-kubernetes-preserve-unknown-fields: true` extension. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.
     *
     * @default true in v1beta for backwards compatibility. Deprecated: will be required to be false in v1. Preservation of unknown fields can be specified in the validation schema using the `x-kubernetes-preserve-unknown-fields: true` extension. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#preserveUnknownFields
     */
    readonly preserveUnknownFields?: boolean;
    /**
     * (experimental) scope indicates whether the defined custom resource is cluster- or namespace-scoped.
     *
     * Allowed values are `Cluster` and `Namespaced`. Default is `Namespaced`.
     *
     * @default Namespaced`.
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#scope
     */
    readonly scope: string;
    /**
     * (experimental) subresources specify what subresources the defined custom resource has.
     *
     * If present, this field configures subresources for all versions. Top-level and per-version subresources are mutually exclusive.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#subresources
     */
    readonly subresources?: CustomResourceSubresourcesV1Beta1;
    /**
     * (experimental) validation describes the schema used for validation and pruning of the custom resource.
     *
     * If present, this validation schema is used to validate all versions. Top-level and per-version schemas are mutually exclusive.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#validation
     */
    readonly validation?: CustomResourceValidationV1Beta1;
    /**
     * (experimental) version is the API version of the defined custom resource.
     *
     * The custom resources are served under `/apis/<group>/<version>/...`. Must match the name of the first item in the `versions` list if `version` and `versions` are both specified. Optional if `versions` is specified. Deprecated: use `versions` instead.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#version
     */
    readonly version?: string;
    /**
     * (experimental) versions is the list of all API versions of the defined custom resource.
     *
     * Optional if `version` is specified. The name of the first item in the `versions` list must match the `version` field if `version` and `versions` are both specified. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#versions
     */
    readonly versions?: CustomResourceDefinitionVersionV1Beta1[];
}
/**
 * Converts an object of type 'CustomResourceDefinitionSpecV1Beta1' to JSON representation.
 */
export declare function toJson_CustomResourceDefinitionSpecV1Beta1(obj: CustomResourceDefinitionSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response.
 *
 * The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails
 */
export interface StatusDetails {
    /**
     * (experimental) The Causes array includes more details associated with the StatusReason failure.
     *
     * Not all StatusReasons may provide detailed causes.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails#causes
     */
    readonly causes?: StatusCause[];
    /**
     * (experimental) The group attribute of the resource associated with the status StatusReason.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails#group
     */
    readonly group?: string;
    /**
     * (experimental) The kind attribute of the resource associated with the status StatusReason.
     *
     * On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails#kind
     */
    readonly kind?: string;
    /**
     * (experimental) The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails#name
     */
    readonly name?: string;
    /**
     * (experimental) If specified, the time in seconds before the operation should be retried.
     *
     * Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails#retryAfterSeconds
     */
    readonly retryAfterSeconds?: number;
    /**
     * (experimental) UID of the resource.
     *
     * (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails#uid
     */
    readonly uid?: string;
}
/**
 * Converts an object of type 'StatusDetails' to JSON representation.
 */
export declare function toJson_StatusDetails(obj: StatusDetails | undefined): Record<string, any> | undefined;
/**
 * (experimental) APIServiceSpec contains information for locating and communicating with a server.
 *
 * Only https is supported, though you are able to disable certificate verification.
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec
 */
export interface ApiServiceSpec {
    /**
     * (experimental) CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.
     *
     * If unspecified, system trust roots on the apiserver are used.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#caBundle
     */
    readonly caBundle?: string;
    /**
     * (experimental) Group is the API group name this server hosts.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#group
     */
    readonly group?: string;
    /**
     * (experimental) GroupPriorityMininum is the priority this group should have at least.
     *
     * Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#groupPriorityMinimum
     */
    readonly groupPriorityMinimum: number;
    /**
     * (experimental) InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server.
     *
     * This is strongly discouraged.  You should use the CABundle instead.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#insecureSkipTLSVerify
     */
    readonly insecureSkipTlsVerify?: boolean;
    /**
     * (experimental) Service is a reference to the service for this API server.
     *
     * It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#service
     */
    readonly service?: ServiceReference;
    /**
     * (experimental) Version is the API version this server hosts.
     *
     * For example, "v1"
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#version
     */
    readonly version?: string;
    /**
     * (experimental) VersionPriority controls the ordering of this API version inside of its group.
     *
     * Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceSpec#versionPriority
     */
    readonly versionPriority: number;
}
/**
 * Converts an object of type 'ApiServiceSpec' to JSON representation.
 */
export declare function toJson_ApiServiceSpec(obj: ApiServiceSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) APIServiceSpec contains information for locating and communicating with a server.
 *
 * Only https is supported, though you are able to disable certificate verification.
 *
 * @experimental
 * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec
 */
export interface ApiServiceSpecV1Beta1 {
    /**
     * (experimental) CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.
     *
     * If unspecified, system trust roots on the apiserver are used.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#caBundle
     */
    readonly caBundle?: string;
    /**
     * (experimental) Group is the API group name this server hosts.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#group
     */
    readonly group?: string;
    /**
     * (experimental) GroupPriorityMininum is the priority this group should have at least.
     *
     * Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#groupPriorityMinimum
     */
    readonly groupPriorityMinimum: number;
    /**
     * (experimental) InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server.
     *
     * This is strongly discouraged.  You should use the CABundle instead.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#insecureSkipTLSVerify
     */
    readonly insecureSkipTlsVerify?: boolean;
    /**
     * (experimental) Service is a reference to the service for this API server.
     *
     * It must communicate on port 443. If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#service
     */
    readonly service?: ServiceReferenceV1Beta1;
    /**
     * (experimental) Version is the API version this server hosts.
     *
     * For example, "v1"
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#version
     */
    readonly version?: string;
    /**
     * (experimental) VersionPriority controls the ordering of this API version inside of its group.
     *
     * Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
     *
     * @experimental
     * @schema io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#versionPriority
     */
    readonly versionPriority: number;
}
/**
 * Converts an object of type 'ApiServiceSpecV1Beta1' to JSON representation.
 */
export declare function toJson_ApiServiceSpecV1Beta1(obj: ApiServiceSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
 */
export interface ManagedFieldsEntry {
    /**
     * (experimental) APIVersion defines the version of this resource that this field set applies to.
     *
     * The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) FieldsType is the discriminator for the different fields format and version.
     *
     * There is currently only one possible value: "FieldsV1"
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry#fieldsType
     */
    readonly fieldsType?: string;
    /**
     * (experimental) FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry#fieldsV1
     */
    readonly fieldsV1?: any;
    /**
     * (experimental) Manager is an identifier of the workflow managing these fields.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry#manager
     */
    readonly manager?: string;
    /**
     * (experimental) Operation is the type of operation which lead to this ManagedFieldsEntry being created.
     *
     * The only valid values for this field are 'Apply' and 'Update'.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry#operation
     */
    readonly operation?: string;
    /**
     * (experimental) Time is timestamp of when these fields were set.
     *
     * It should always be empty if Operation is 'Apply'
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry#time
     */
    readonly time?: Date;
}
/**
 * Converts an object of type 'ManagedFieldsEntry' to JSON representation.
 */
export declare function toJson_ManagedFieldsEntry(obj: ManagedFieldsEntry | undefined): Record<string, any> | undefined;
/**
 * (experimental) OwnerReference contains enough information to let you identify an owning object.
 *
 * An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
 */
export interface OwnerReference {
    /**
     * (experimental) API version of the referent.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference#apiVersion
     */
    readonly apiVersion: string;
    /**
     * (experimental) If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed.
     *
     * Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
     *
     * @default false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference#blockOwnerDeletion
     */
    readonly blockOwnerDeletion?: boolean;
    /**
     * (experimental) If true, this reference points to the managing controller.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference#controller
     */
    readonly controller?: boolean;
    /**
     * (experimental) Kind of the referent.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name of the referent.
     *
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference#name
     */
    readonly name: string;
    /**
     * (experimental) UID of the referent.
     *
     * More info: http://kubernetes.io/docs/user-guide/identifiers#uids
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference#uid
     */
    readonly uid: string;
}
/**
 * Converts an object of type 'OwnerReference' to JSON representation.
 */
export declare function toJson_OwnerReference(obj: OwnerReference | undefined): Record<string, any> | undefined;
/**
 * (experimental) WebhookClientConfig contains the information to make a TLS connection with the webhook.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.WebhookClientConfig
 */
export interface WebhookClientConfig {
    /**
     * (experimental) `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate.
     *
     * If unspecified, system trust roots on the apiserver are used.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.WebhookClientConfig#caBundle
     */
    readonly caBundle?: string;
    /**
     * (experimental) `service` is a reference to the service for this webhook. Either `service` or `url` must be specified.
     *
     * If the webhook is running within the cluster, then you should use `service`.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.WebhookClientConfig#service
     */
    readonly service?: ServiceReference;
    /**
     * (experimental) `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`).
     *
     * Exactly one of `url` or `service` must be specified.
     *
     * The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
     *
     * Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
     *
     * The scheme must be "https"; the URL must begin with "https://".
     *
     * A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
     *
     * Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.WebhookClientConfig#url
     */
    readonly url?: string;
}
/**
 * Converts an object of type 'WebhookClientConfig' to JSON representation.
 */
export declare function toJson_WebhookClientConfig(obj: WebhookClientConfig | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuleWithOperations is a tuple of Operations and Resources.
 *
 * It is recommended to make sure that all the tuple expansions are valid.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1.RuleWithOperations
 */
export interface RuleWithOperations {
    /**
     * (experimental) APIGroups is the API groups the resources belong to.
     *
     * '*' is all groups. If '*' is present, the length of the slice must be one. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.RuleWithOperations#apiGroups
     */
    readonly apiGroups?: string[];
    /**
     * (experimental) APIVersions is the API versions the resources belong to.
     *
     * '*' is all versions. If '*' is present, the length of the slice must be one. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.RuleWithOperations#apiVersions
     */
    readonly apiVersions?: string[];
    /**
     * (experimental) Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added.
     *
     * If '*' is present, the length of the slice must be one. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.RuleWithOperations#operations
     */
    readonly operations?: string[];
    /**
     * (experimental) Resources is a list of resources this rule applies to.
     *
     * For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '_/scale' means all scale subresources. '_/*' means all resources and their subresources.
     *
     * If wildcard is present, the validation rule will ensure resources do not overlap with each other.
     *
     * Depending on the enclosing object, subresources might not be allowed. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.RuleWithOperations#resources
     */
    readonly resources?: string[];
    /**
     * (experimental) scope specifies the scope of this rule.
     *
     * Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
     *
     * @default .
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1.RuleWithOperations#scope
     */
    readonly scope?: string;
}
/**
 * Converts an object of type 'RuleWithOperations' to JSON representation.
 */
export declare function toJson_RuleWithOperations(obj: RuleWithOperations | undefined): Record<string, any> | undefined;
/**
 * (experimental) WebhookClientConfig contains the information to make a TLS connection with the webhook.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.WebhookClientConfig
 */
export interface WebhookClientConfigV1Beta1 {
    /**
     * (experimental) `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate.
     *
     * If unspecified, system trust roots on the apiserver are used.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.WebhookClientConfig#caBundle
     */
    readonly caBundle?: string;
    /**
     * (experimental) `service` is a reference to the service for this webhook. Either `service` or `url` must be specified.
     *
     * If the webhook is running within the cluster, then you should use `service`.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.WebhookClientConfig#service
     */
    readonly service?: ServiceReferenceV1Beta1;
    /**
     * (experimental) `url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`).
     *
     * Exactly one of `url` or `service` must be specified.
     *
     * The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
     *
     * Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
     *
     * The scheme must be "https"; the URL must begin with "https://".
     *
     * A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
     *
     * Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.WebhookClientConfig#url
     */
    readonly url?: string;
}
/**
 * Converts an object of type 'WebhookClientConfigV1Beta1' to JSON representation.
 */
export declare function toJson_WebhookClientConfigV1Beta1(obj: WebhookClientConfigV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuleWithOperations is a tuple of Operations and Resources.
 *
 * It is recommended to make sure that all the tuple expansions are valid.
 *
 * @experimental
 * @schema io.k8s.api.admissionregistration.v1beta1.RuleWithOperations
 */
export interface RuleWithOperationsV1Beta1 {
    /**
     * (experimental) APIGroups is the API groups the resources belong to.
     *
     * '*' is all groups. If '*' is present, the length of the slice must be one. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.RuleWithOperations#apiGroups
     */
    readonly apiGroups?: string[];
    /**
     * (experimental) APIVersions is the API versions the resources belong to.
     *
     * '*' is all versions. If '*' is present, the length of the slice must be one. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.RuleWithOperations#apiVersions
     */
    readonly apiVersions?: string[];
    /**
     * (experimental) Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added.
     *
     * If '*' is present, the length of the slice must be one. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.RuleWithOperations#operations
     */
    readonly operations?: string[];
    /**
     * (experimental) Resources is a list of resources this rule applies to.
     *
     * For example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '_/scale' means all scale subresources. '_/*' means all resources and their subresources.
     *
     * If wildcard is present, the validation rule will ensure resources do not overlap with each other.
     *
     * Depending on the enclosing object, subresources might not be allowed. Required.
     *
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.RuleWithOperations#resources
     */
    readonly resources?: string[];
    /**
     * (experimental) scope specifies the scope of this rule.
     *
     * Valid values are "Cluster", "Namespaced", and "*" "Cluster" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. "Namespaced" means that only namespaced resources will match this rule. "*" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is "*".
     *
     * @default .
     * @experimental
     * @schema io.k8s.api.admissionregistration.v1beta1.RuleWithOperations#scope
     */
    readonly scope?: string;
}
/**
 * Converts an object of type 'RuleWithOperationsV1Beta1' to JSON representation.
 */
export declare function toJson_RuleWithOperationsV1Beta1(obj: RuleWithOperationsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DaemonSetUpdateStrategy
 */
export interface DaemonSetUpdateStrategy {
    /**
     * (experimental) Rolling update config params.
     *
     * Present only if type = "RollingUpdate".
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetUpdateStrategy#rollingUpdate
     */
    readonly rollingUpdate?: RollingUpdateDaemonSet;
    /**
     * (experimental) Type of daemon set update.
     *
     * Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
     *
     * @default RollingUpdate.
     * @experimental
     * @schema io.k8s.api.apps.v1.DaemonSetUpdateStrategy#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'DaemonSetUpdateStrategy' to JSON representation.
 */
export declare function toJson_DaemonSetUpdateStrategy(obj: DaemonSetUpdateStrategy | undefined): Record<string, any> | undefined;
/**
 * (experimental) DeploymentStrategy describes how to replace existing pods with new ones.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.DeploymentStrategy
 */
export interface DeploymentStrategy {
    /**
     * (experimental) Rolling update config params.
     *
     * Present only if DeploymentStrategyType = RollingUpdate.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentStrategy#rollingUpdate
     */
    readonly rollingUpdate?: RollingUpdateDeployment;
    /**
     * (experimental) Type of deployment.
     *
     * Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     *
     * @default RollingUpdate.
     * @experimental
     * @schema io.k8s.api.apps.v1.DeploymentStrategy#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'DeploymentStrategy' to JSON representation.
 */
export declare function toJson_DeploymentStrategy(obj: DeploymentStrategy | undefined): Record<string, any> | undefined;
/**
 * (experimental) StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates.
 *
 * It includes any additional parameters necessary to perform the update for the indicated strategy.
 *
 * @experimental
 * @schema io.k8s.api.apps.v1.StatefulSetUpdateStrategy
 */
export interface StatefulSetUpdateStrategy {
    /**
     * (experimental) RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
     *
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetUpdateStrategy#rollingUpdate
     */
    readonly rollingUpdate?: RollingUpdateStatefulSetStrategy;
    /**
     * (experimental) Type indicates the type of the StatefulSetUpdateStrategy.
     *
     * Default is RollingUpdate.
     *
     * @default RollingUpdate.
     * @experimental
     * @schema io.k8s.api.apps.v1.StatefulSetUpdateStrategy#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'StatefulSetUpdateStrategy' to JSON representation.
 */
export declare function toJson_StatefulSetUpdateStrategy(obj: StatefulSetUpdateStrategy | undefined): Record<string, any> | undefined;
/**
 * (experimental) BoundObjectReference is a reference to an object that a token is bound to.
 *
 * @experimental
 * @schema io.k8s.api.authentication.v1.BoundObjectReference
 */
export interface BoundObjectReference {
    /**
     * (experimental) API version of the referent.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.BoundObjectReference#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) Kind of the referent.
     *
     * Valid kinds are 'Pod' and 'Secret'.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.BoundObjectReference#kind
     */
    readonly kind?: string;
    /**
     * (experimental) Name of the referent.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.BoundObjectReference#name
     */
    readonly name?: string;
    /**
     * (experimental) UID of the referent.
     *
     * @experimental
     * @schema io.k8s.api.authentication.v1.BoundObjectReference#uid
     */
    readonly uid?: string;
}
/**
 * Converts an object of type 'BoundObjectReference' to JSON representation.
 */
export declare function toJson_BoundObjectReference(obj: BoundObjectReference | undefined): Record<string, any> | undefined;
/**
 * (experimental) NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.NonResourceAttributes
 */
export interface NonResourceAttributes {
    /**
     * (experimental) Path is the URL path of the request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.NonResourceAttributes#path
     */
    readonly path?: string;
    /**
     * (experimental) Verb is the standard HTTP verb.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.NonResourceAttributes#verb
     */
    readonly verb?: string;
}
/**
 * Converts an object of type 'NonResourceAttributes' to JSON representation.
 */
export declare function toJson_NonResourceAttributes(obj: NonResourceAttributes | undefined): Record<string, any> | undefined;
/**
 * (experimental) ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1.ResourceAttributes
 */
export interface ResourceAttributes {
    /**
     * (experimental) Group is the API Group of the Resource.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.ResourceAttributes#group
     */
    readonly group?: string;
    /**
     * (experimental) Name is the name of the resource being requested for a "get" or deleted for a "delete".
     *
     * "" (empty) means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.ResourceAttributes#name
     */
    readonly name?: string;
    /**
     * (experimental) Namespace is the namespace of the action being requested.
     *
     * Currently, there is no distinction between no namespace and all namespaces "" (empty) is defaulted for LocalSubjectAccessReviews "" (empty) is empty for cluster-scoped resources "" (empty) means "all" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.ResourceAttributes#namespace
     */
    readonly namespace?: string;
    /**
     * (experimental) Resource is one of the existing resource types.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.ResourceAttributes#resource
     */
    readonly resource?: string;
    /**
     * (experimental) Subresource is one of the existing resource types.
     *
     * "" means none.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.ResourceAttributes#subresource
     */
    readonly subresource?: string;
    /**
     * (experimental) Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.ResourceAttributes#verb
     */
    readonly verb?: string;
    /**
     * (experimental) Version is the API Version of the Resource.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1.ResourceAttributes#version
     */
    readonly version?: string;
}
/**
 * Converts an object of type 'ResourceAttributes' to JSON representation.
 */
export declare function toJson_ResourceAttributes(obj: ResourceAttributes | undefined): Record<string, any> | undefined;
/**
 * (experimental) NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.NonResourceAttributes
 */
export interface NonResourceAttributesV1Beta1 {
    /**
     * (experimental) Path is the URL path of the request.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.NonResourceAttributes#path
     */
    readonly path?: string;
    /**
     * (experimental) Verb is the standard HTTP verb.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.NonResourceAttributes#verb
     */
    readonly verb?: string;
}
/**
 * Converts an object of type 'NonResourceAttributesV1Beta1' to JSON representation.
 */
export declare function toJson_NonResourceAttributesV1Beta1(obj: NonResourceAttributesV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface.
 *
 * @experimental
 * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes
 */
export interface ResourceAttributesV1Beta1 {
    /**
     * (experimental) Group is the API Group of the Resource.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes#group
     */
    readonly group?: string;
    /**
     * (experimental) Name is the name of the resource being requested for a "get" or deleted for a "delete".
     *
     * "" (empty) means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes#name
     */
    readonly name?: string;
    /**
     * (experimental) Namespace is the namespace of the action being requested.
     *
     * Currently, there is no distinction between no namespace and all namespaces "" (empty) is defaulted for LocalSubjectAccessReviews "" (empty) is empty for cluster-scoped resources "" (empty) means "all" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes#namespace
     */
    readonly namespace?: string;
    /**
     * (experimental) Resource is one of the existing resource types.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes#resource
     */
    readonly resource?: string;
    /**
     * (experimental) Subresource is one of the existing resource types.
     *
     * "" means none.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes#subresource
     */
    readonly subresource?: string;
    /**
     * (experimental) Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes#verb
     */
    readonly verb?: string;
    /**
     * (experimental) Version is the API Version of the Resource.
     *
     * "*" means all.
     *
     * @experimental
     * @schema io.k8s.api.authorization.v1beta1.ResourceAttributes#version
     */
    readonly version?: string;
}
/**
 * Converts an object of type 'ResourceAttributesV1Beta1' to JSON representation.
 */
export declare function toJson_ResourceAttributesV1Beta1(obj: ResourceAttributesV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CrossVersionObjectReference contains enough information to let you identify the referred resource.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v1.CrossVersionObjectReference
 */
export interface CrossVersionObjectReference {
    /**
     * (experimental) API version of the referent.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.CrossVersionObjectReference#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) Kind of the referent;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.CrossVersionObjectReference#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name of the referent;
     *
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v1.CrossVersionObjectReference#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'CrossVersionObjectReference' to JSON representation.
 */
export declare function toJson_CrossVersionObjectReference(obj: CrossVersionObjectReference | undefined): Record<string, any> | undefined;
/**
 * (experimental) MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta1.MetricSpec
 */
export interface MetricSpecV2Beta1 {
    /**
     * (experimental) container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.MetricSpec#containerResource
     */
    readonly containerResource?: ContainerResourceMetricSourceV2Beta1;
    /**
     * (experimental) external refers to a global metric that is not associated with any Kubernetes object.
     *
     * It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.MetricSpec#external
     */
    readonly external?: ExternalMetricSourceV2Beta1;
    /**
     * (experimental) object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.MetricSpec#object
     */
    readonly object?: ObjectMetricSourceV2Beta1;
    /**
     * (experimental) pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
     *
     * The values will be averaged together before being compared to the target value.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.MetricSpec#pods
     */
    readonly pods?: PodsMetricSourceV2Beta1;
    /**
     * (experimental) resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.MetricSpec#resource
     */
    readonly resource?: ResourceMetricSourceV2Beta1;
    /**
     * (experimental) type is the type of metric source.
     *
     * It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.MetricSpec#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'MetricSpecV2Beta1' to JSON representation.
 */
export declare function toJson_MetricSpecV2Beta1(obj: MetricSpecV2Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CrossVersionObjectReference contains enough information to let you identify the referred resource.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference
 */
export interface CrossVersionObjectReferenceV2Beta1 {
    /**
     * (experimental) API version of the referent.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) Kind of the referent;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name of the referent;
     *
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta1.CrossVersionObjectReference#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'CrossVersionObjectReferenceV2Beta1' to JSON representation.
 */
export declare function toJson_CrossVersionObjectReferenceV2Beta1(obj: CrossVersionObjectReferenceV2Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior
 */
export interface HorizontalPodAutoscalerBehaviorV2Beta2 {
    /**
     * (experimental) scaleDown is scaling policy for scaling Down.
     *
     * If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior#scaleDown
     */
    readonly scaleDown?: HpaScalingRulesV2Beta2;
    /**
     * (experimental) scaleUp is scaling policy for scaling Up.
     *
     * If not set, the default value is the higher of:
     * * increase no more than 4 pods per 60 seconds
     * * double the number of pods per 60 seconds
     * No stabilization is used.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior#scaleUp
     */
    readonly scaleUp?: HpaScalingRulesV2Beta2;
}
/**
 * Converts an object of type 'HorizontalPodAutoscalerBehaviorV2Beta2' to JSON representation.
 */
export declare function toJson_HorizontalPodAutoscalerBehaviorV2Beta2(obj: HorizontalPodAutoscalerBehaviorV2Beta2 | undefined): Record<string, any> | undefined;
/**
 * (experimental) MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.MetricSpec
 */
export interface MetricSpecV2Beta2 {
    /**
     * (experimental) container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.MetricSpec#containerResource
     */
    readonly containerResource?: ContainerResourceMetricSourceV2Beta2;
    /**
     * (experimental) external refers to a global metric that is not associated with any Kubernetes object.
     *
     * It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.MetricSpec#external
     */
    readonly external?: ExternalMetricSourceV2Beta2;
    /**
     * (experimental) object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.MetricSpec#object
     */
    readonly object?: ObjectMetricSourceV2Beta2;
    /**
     * (experimental) pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
     *
     * The values will be averaged together before being compared to the target value.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.MetricSpec#pods
     */
    readonly pods?: PodsMetricSourceV2Beta2;
    /**
     * (experimental) resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.MetricSpec#resource
     */
    readonly resource?: ResourceMetricSourceV2Beta2;
    /**
     * (experimental) type is the type of metric source.
     *
     * It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.MetricSpec#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'MetricSpecV2Beta2' to JSON representation.
 */
export declare function toJson_MetricSpecV2Beta2(obj: MetricSpecV2Beta2 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CrossVersionObjectReference contains enough information to let you identify the referred resource.
 *
 * @experimental
 * @schema io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference
 */
export interface CrossVersionObjectReferenceV2Beta2 {
    /**
     * (experimental) API version of the referent.
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * (experimental) Kind of the referent;
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name of the referent;
     *
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * @experimental
     * @schema io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'CrossVersionObjectReferenceV2Beta2' to JSON representation.
 */
export declare function toJson_CrossVersionObjectReferenceV2Beta2(obj: CrossVersionObjectReferenceV2Beta2 | undefined): Record<string, any> | undefined;
/**
 * (experimental) JobTemplateSpec describes the data a Job should have when created from a template.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1.JobTemplateSpec
 */
export interface JobTemplateSpec {
    /**
     * (experimental) Standard object's metadata of the jobs created from this template.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobTemplateSpec#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of the job.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.batch.v1.JobTemplateSpec#spec
     */
    readonly spec?: JobSpec;
}
/**
 * Converts an object of type 'JobTemplateSpec' to JSON representation.
 */
export declare function toJson_JobTemplateSpec(obj: JobTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * (experimental) JobTemplateSpec describes the data a Job should have when created from a template.
 *
 * @experimental
 * @schema io.k8s.api.batch.v1beta1.JobTemplateSpec
 */
export interface JobTemplateSpecV1Beta1 {
    /**
     * (experimental) Standard object's metadata of the jobs created from this template.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.JobTemplateSpec#metadata
     */
    readonly metadata?: ObjectMeta;
    /**
     * (experimental) Specification of the desired behavior of the job.
     *
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     *
     * @experimental
     * @schema io.k8s.api.batch.v1beta1.JobTemplateSpec#spec
     */
    readonly spec?: JobSpec;
}
/**
 * Converts an object of type 'JobTemplateSpecV1Beta1' to JSON representation.
 */
export declare function toJson_JobTemplateSpecV1Beta1(obj: JobTemplateSpecV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointAddress is a tuple that describes single IP address.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EndpointAddress
 */
export interface EndpointAddress {
    /**
     * (experimental) The Hostname of this endpoint.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointAddress#hostname
     */
    readonly hostname?: string;
    /**
     * (experimental) The IP of this endpoint.
     *
     * May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointAddress#ip
     */
    readonly ip: string;
    /**
     * (experimental) Optional: Node hosting this endpoint.
     *
     * This can be used to determine endpoints local to a node.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointAddress#nodeName
     */
    readonly nodeName?: string;
    /**
     * (experimental) Reference to object providing the endpoint.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EndpointAddress#targetRef
     */
    readonly targetRef?: ObjectReference;
}
/**
 * Converts an object of type 'EndpointAddress' to JSON representation.
 */
export declare function toJson_EndpointAddress(obj: EndpointAddress | undefined): Record<string, any> | undefined;
/**
 * (experimental) EnvVar represents an environment variable present in a Container.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EnvVar
 */
export interface EnvVar {
    /**
     * (experimental) Name of the environment variable.
     *
     * Must be a C_IDENTIFIER.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EnvVar#name
     */
    readonly name: string;
    /**
     * (experimental) Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables.
     *
     * If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
     *
     * @default .
     * @experimental
     * @schema io.k8s.api.core.v1.EnvVar#value
     */
    readonly value?: string;
    /**
     * (experimental) Source for the environment variable's value.
     *
     * Cannot be used if value is not empty.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EnvVar#valueFrom
     */
    readonly valueFrom?: EnvVarSource;
}
/**
 * Converts an object of type 'EnvVar' to JSON representation.
 */
export declare function toJson_EnvVar(obj: EnvVar | undefined): Record<string, any> | undefined;
/**
 * (experimental) EnvFromSource represents the source of a set of ConfigMaps.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.EnvFromSource
 */
export interface EnvFromSource {
    /**
     * (experimental) The ConfigMap to select from.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EnvFromSource#configMapRef
     */
    readonly configMapRef?: ConfigMapEnvSource;
    /**
     * (experimental) An optional identifier to prepend to each key in the ConfigMap.
     *
     * Must be a C_IDENTIFIER.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EnvFromSource#prefix
     */
    readonly prefix?: string;
    /**
     * (experimental) The Secret to select from.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.EnvFromSource#secretRef
     */
    readonly secretRef?: SecretEnvSource;
}
/**
 * Converts an object of type 'EnvFromSource' to JSON representation.
 */
export declare function toJson_EnvFromSource(obj: EnvFromSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Lifecycle describes actions that the management system should take in response to container lifecycle events.
 *
 * For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Lifecycle
 */
export interface Lifecycle {
    /**
     * (experimental) PostStart is called immediately after a container is created.
     *
     * If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Lifecycle#postStart
     */
    readonly postStart?: Handler;
    /**
     * (experimental) PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc.
     *
     * The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Lifecycle#preStop
     */
    readonly preStop?: Handler;
}
/**
 * Converts an object of type 'Lifecycle' to JSON representation.
 */
export declare function toJson_Lifecycle(obj: Lifecycle | undefined): Record<string, any> | undefined;
/**
 * (experimental) Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Probe
 */
export interface Probe {
    /**
     * (experimental) One and only one of the following should be specified.
     *
     * Exec specifies the action to take.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#exec
     */
    readonly exec?: ExecAction;
    /**
     * (experimental) Minimum consecutive failures for the probe to be considered failed after having succeeded.
     *
     * Defaults to 3. Minimum value is 1.
     *
     * @default 3. Minimum value is 1.
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * (experimental) HTTPGet specifies the http request to perform.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#httpGet
     */
    readonly httpGet?: HttpGetAction;
    /**
     * (experimental) Number of seconds after the container has started before liveness probes are initiated.
     *
     * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * (experimental) How often (in seconds) to perform the probe.
     *
     * Default to 10 seconds. Minimum value is 1.
     *
     * @default 10 seconds. Minimum value is 1.
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * (experimental) Minimum consecutive successes for the probe to be considered successful after having failed.
     *
     * Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
     *
     * @default 1. Must be 1 for liveness and startup. Minimum value is 1.
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * (experimental) TCPSocket specifies an action involving a TCP port.
     *
     * TCP hooks not yet supported
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#tcpSocket
     */
    readonly tcpSocket?: TcpSocketAction;
    /**
     * (experimental) Optional duration in seconds the pod needs to terminate gracefully upon probe failure.
     *
     * The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#terminationGracePeriodSeconds
     */
    readonly terminationGracePeriodSeconds?: number;
    /**
     * (experimental) Number of seconds after which the probe times out.
     *
     * Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @default 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     * @experimental
     * @schema io.k8s.api.core.v1.Probe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'Probe' to JSON representation.
 */
export declare function toJson_Probe(obj: Probe | undefined): Record<string, any> | undefined;
/**
 * (experimental) ContainerPort represents a network port in a single container.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ContainerPort
 */
export interface ContainerPort {
    /**
     * (experimental) Number of port to expose on the pod's IP address.
     *
     * This must be a valid port number, 0 < x < 65536.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ContainerPort#containerPort
     */
    readonly containerPort: number;
    /**
     * (experimental) What host IP to bind the external port to.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ContainerPort#hostIP
     */
    readonly hostIp?: string;
    /**
     * (experimental) Number of port to expose on the host.
     *
     * If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ContainerPort#hostPort
     */
    readonly hostPort?: number;
    /**
     * (experimental) If specified, this must be an IANA_SVC_NAME and unique within the pod.
     *
     * Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ContainerPort#name
     */
    readonly name?: string;
    /**
     * (experimental) Protocol for port.
     *
     * Must be UDP, TCP, or SCTP. Defaults to "TCP".
     *
     * @default TCP".
     * @experimental
     * @schema io.k8s.api.core.v1.ContainerPort#protocol
     */
    readonly protocol?: string;
}
/**
 * Converts an object of type 'ContainerPort' to JSON representation.
 */
export declare function toJson_ContainerPort(obj: ContainerPort | undefined): Record<string, any> | undefined;
/**
 * (experimental) ResourceRequirements describes the compute resource requirements.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ResourceRequirements
 */
export interface ResourceRequirements {
    /**
     * (experimental) Limits describes the maximum amount of compute resources allowed.
     *
     * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceRequirements#limits
     */
    readonly limits?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) Requests describes the minimum amount of compute resources required.
     *
     * If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ResourceRequirements#requests
     */
    readonly requests?: {
        [key: string]: Quantity;
    };
}
/**
 * Converts an object of type 'ResourceRequirements' to JSON representation.
 */
export declare function toJson_ResourceRequirements(obj: ResourceRequirements | undefined): Record<string, any> | undefined;
/**
 * (experimental) SecurityContext holds security configuration that will be applied to a container.
 *
 * Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.SecurityContext
 */
export interface SecurityContext {
    /**
     * (experimental) AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process.
     *
     * This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#allowPrivilegeEscalation
     */
    readonly allowPrivilegeEscalation?: boolean;
    /**
     * (experimental) The capabilities to add/drop when running containers.
     *
     * Defaults to the default set of capabilities granted by the container runtime.
     *
     * @default the default set of capabilities granted by the container runtime.
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#capabilities
     */
    readonly capabilities?: Capabilities;
    /**
     * (experimental) Run container in privileged mode.
     *
     * Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#privileged
     */
    readonly privileged?: boolean;
    /**
     * (experimental) procMount denotes the type of proc mount to use for the containers.
     *
     * The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#procMount
     */
    readonly procMount?: string;
    /**
     * (experimental) Whether this container has a read-only root filesystem.
     *
     * Default is false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#readOnlyRootFilesystem
     */
    readonly readOnlyRootFilesystem?: boolean;
    /**
     * (experimental) The GID to run the entrypoint of the container process.
     *
     * Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * (experimental) Indicates that the container must run as a non-root user.
     *
     * If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * (experimental) The UID to run the entrypoint of the container process.
     *
     * Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @default user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * (experimental) The SELinux context to be applied to the container.
     *
     * If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: SeLinuxOptions;
    /**
     * (experimental) The seccomp options to use by this container.
     *
     * If seccomp options are provided at both the pod & container level, the container options override the pod options.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#seccompProfile
     */
    readonly seccompProfile?: SeccompProfile;
    /**
     * (experimental) The Windows specific settings applied to all containers.
     *
     * If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SecurityContext#windowsOptions
     */
    readonly windowsOptions?: WindowsSecurityContextOptions;
}
/**
 * Converts an object of type 'SecurityContext' to JSON representation.
 */
export declare function toJson_SecurityContext(obj: SecurityContext | undefined): Record<string, any> | undefined;
/**
 * (experimental) volumeDevice describes a mapping of a raw block device within a container.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.VolumeDevice
 */
export interface VolumeDevice {
    /**
     * (experimental) devicePath is the path inside of the container that the device will be mapped to.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeDevice#devicePath
     */
    readonly devicePath: string;
    /**
     * (experimental) name must match the name of a persistentVolumeClaim in the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeDevice#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'VolumeDevice' to JSON representation.
 */
export declare function toJson_VolumeDevice(obj: VolumeDevice | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeMount describes a mounting of a Volume within a container.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.VolumeMount
 */
export interface VolumeMount {
    /**
     * (experimental) Path within the container at which the volume should be mounted.
     *
     * Must not contain ':'.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeMount#mountPath
     */
    readonly mountPath: string;
    /**
     * (experimental) mountPropagation determines how mounts are propagated from the host to container and the other way around.
     *
     * When not set, MountPropagationNone is used. This field is beta in 1.10.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeMount#mountPropagation
     */
    readonly mountPropagation?: string;
    /**
     * (experimental) This must match the Name of a Volume.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeMount#name
     */
    readonly name: string;
    /**
     * (experimental) Mounted read-only if true, read-write otherwise (false or unspecified).
     *
     * Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeMount#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Path within the volume from which the container's volume should be mounted.
     *
     * Defaults to "" (volume's root).
     *
     * @default volume's root).
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeMount#subPath
     */
    readonly subPath?: string;
    /**
     * (experimental) Expanded path within the volume from which the container's volume should be mounted.
     *
     * Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive.
     *
     * @default volume's root). SubPathExpr and SubPath are mutually exclusive.
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeMount#subPathExpr
     */
    readonly subPathExpr?: string;
}
/**
 * Converts an object of type 'VolumeMount' to JSON representation.
 */
export declare function toJson_VolumeMount(obj: VolumeMount | undefined): Record<string, any> | undefined;
/**
 * (experimental) LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LimitRangeItem
 */
export interface LimitRangeItem {
    /**
     * (experimental) Default resource requirement limit value by resource name if resource limit is omitted.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeItem#default
     */
    readonly default?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeItem#defaultRequest
     */
    readonly defaultRequest?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) Max usage constraints on this kind by resource name.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeItem#max
     */
    readonly max?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value;
     *
     * this represents the max burst for the named resource.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeItem#maxLimitRequestRatio
     */
    readonly maxLimitRequestRatio?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) Min usage constraints on this kind by resource name.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeItem#min
     */
    readonly min?: {
        [key: string]: Quantity;
    };
    /**
     * (experimental) Type of resource that this limit applies to.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LimitRangeItem#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'LimitRangeItem' to JSON representation.
 */
export declare function toJson_LimitRangeItem(obj: LimitRangeItem | undefined): Record<string, any> | undefined;
/**
 * (experimental) NodeConfigSource specifies a source of node configuration.
 *
 * Exactly one subfield (excluding metadata) must be non-nil.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NodeConfigSource
 */
export interface NodeConfigSource {
    /**
     * (experimental) ConfigMap is a reference to a Node's ConfigMap.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NodeConfigSource#configMap
     */
    readonly configMap?: ConfigMapNodeConfigSource;
}
/**
 * Converts an object of type 'NodeConfigSource' to JSON representation.
 */
export declare function toJson_NodeConfigSource(obj: NodeConfigSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Taint
 */
export interface Taint {
    /**
     * (experimental) Required.
     *
     * The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Taint#effect
     */
    readonly effect: string;
    /**
     * (experimental) Required.
     *
     * The taint key to be applied to a node.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Taint#key
     */
    readonly key: string;
    /**
     * (experimental) TimeAdded represents the time at which the taint was added.
     *
     * It is only written for NoExecute taints.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Taint#timeAdded
     */
    readonly timeAdded?: Date;
    /**
     * (experimental) The taint value corresponding to the taint key.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Taint#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'Taint' to JSON representation.
 */
export declare function toJson_Taint(obj: Taint | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Persistent Disk resource in AWS.
 *
 * An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource
 */
export interface AwsElasticBlockStoreVolumeSource {
    /**
     * (experimental) Filesystem type of the volume that you want to mount.
     *
     * Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) The partition in the volume that you want to mount.
     *
     * If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#partition
     */
    readonly partition?: number;
    /**
     * (experimental) Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".
     *
     * If omitted, the default is "false". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Unique ID of the persistent disk resource in AWS (Amazon EBS volume).
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'AwsElasticBlockStoreVolumeSource' to JSON representation.
 */
export declare function toJson_AwsElasticBlockStoreVolumeSource(obj: AwsElasticBlockStoreVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.AzureDiskVolumeSource
 */
export interface AzureDiskVolumeSource {
    /**
     * (experimental) Host Caching mode: None, Read Only, Read Write.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureDiskVolumeSource#cachingMode
     */
    readonly cachingMode?: string;
    /**
     * (experimental) The Name of the data disk in the blob storage.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureDiskVolumeSource#diskName
     */
    readonly diskName: string;
    /**
     * (experimental) The URI the data disk in the blob storage.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureDiskVolumeSource#diskURI
     */
    readonly diskUri: string;
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureDiskVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set).
     *
     * defaults to shared
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureDiskVolumeSource#kind
     */
    readonly kind?: string;
    /**
     * (experimental) Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @experimental
     * @schema io.k8s.api.core.v1.AzureDiskVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'AzureDiskVolumeSource' to JSON representation.
 */
export declare function toJson_AzureDiskVolumeSource(obj: AzureDiskVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.AzureFilePersistentVolumeSource
 */
export interface AzureFilePersistentVolumeSource {
    /**
     * (experimental) Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @experimental
     * @schema io.k8s.api.core.v1.AzureFilePersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) the name of secret that contains Azure Storage Account Name and Key.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretName
     */
    readonly secretName: string;
    /**
     * (experimental) the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretNamespace
     */
    readonly secretNamespace?: string;
    /**
     * (experimental) Share Name.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.AzureFilePersistentVolumeSource#shareName
     */
    readonly shareName: string;
}
/**
 * Converts an object of type 'AzureFilePersistentVolumeSource' to JSON representation.
 */
export declare function toJson_AzureFilePersistentVolumeSource(obj: AzureFilePersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.CephFSPersistentVolumeSource
 */
export interface CephFsPersistentVolumeSource {
    /**
     * (experimental) Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CephFSPersistentVolumeSource#monitors
     */
    readonly monitors: string[];
    /**
     * (experimental) Optional: Used as the mounted root, rather than the full Ceph tree, default is /.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CephFSPersistentVolumeSource#path
     */
    readonly path?: string;
    /**
     * (experimental) Optional: Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     * @experimental
     * @schema io.k8s.api.core.v1.CephFSPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretFile
     */
    readonly secretFile?: string;
    /**
     * (experimental) Optional: SecretRef is reference to the authentication secret for User, default is empty.
     *
     * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretRef
     */
    readonly secretRef?: SecretReference;
    /**
     * (experimental) Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CephFSPersistentVolumeSource#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'CephFsPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_CephFsPersistentVolumeSource(obj: CephFsPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a cinder volume resource in Openstack.
 *
 * A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.CinderPersistentVolumeSource
 */
export interface CinderPersistentVolumeSource {
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CinderPersistentVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Optional: Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     * @experimental
     * @schema io.k8s.api.core.v1.CinderPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Optional: points to a secret object containing parameters used to connect to OpenStack.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CinderPersistentVolumeSource#secretRef
     */
    readonly secretRef?: SecretReference;
    /**
     * (experimental) volume id used to identify the volume in cinder.
     *
     * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CinderPersistentVolumeSource#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'CinderPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_CinderPersistentVolumeSource(obj: CinderPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents storage that is managed by an external CSI volume driver (Beta feature).
 *
 * @experimental
 * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource
 */
export interface CsiPersistentVolumeSource {
    /**
     * (experimental) ControllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call.
     *
     * This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerExpandSecretRef
     */
    readonly controllerExpandSecretRef?: SecretReference;
    /**
     * (experimental) ControllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls.
     *
     * This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerPublishSecretRef
     */
    readonly controllerPublishSecretRef?: SecretReference;
    /**
     * (experimental) Driver is the name of the driver to use for this volume.
     *
     * Required.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#driver
     */
    readonly driver: string;
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.
     *
     * This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#nodePublishSecretRef
     */
    readonly nodePublishSecretRef?: SecretReference;
    /**
     * (experimental) NodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls.
     *
     * This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#nodeStageSecretRef
     */
    readonly nodeStageSecretRef?: SecretReference;
    /**
     * (experimental) Optional: The value to pass to ControllerPublishVolumeRequest.
     *
     * Defaults to false (read/write).
     *
     * @default false (read/write).
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Attributes of the volume to publish.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeAttributes
     */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
    /**
     * (experimental) VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls.
     *
     * Required.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeHandle
     */
    readonly volumeHandle: string;
}
/**
 * Converts an object of type 'CsiPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_CsiPersistentVolumeSource(obj: CsiPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Fibre Channel volume.
 *
 * Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.FCVolumeSource
 */
export interface FcVolumeSource {
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FCVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Optional: FC target lun number.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FCVolumeSource#lun
     */
    readonly lun?: number;
    /**
     * (experimental) Optional: Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @experimental
     * @schema io.k8s.api.core.v1.FCVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Optional: FC target worldwide names (WWNs).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FCVolumeSource#targetWWNs
     */
    readonly targetWwNs?: string[];
    /**
     * (experimental) Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FCVolumeSource#wwids
     */
    readonly wwids?: string[];
}
/**
 * Converts an object of type 'FcVolumeSource' to JSON representation.
 */
export declare function toJson_FcVolumeSource(obj: FcVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.FlexPersistentVolumeSource
 */
export interface FlexPersistentVolumeSource {
    /**
     * (experimental) Driver is the name of the driver to use for this volume.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FlexPersistentVolumeSource#driver
     */
    readonly driver: string;
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FlexPersistentVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Optional: Extra command options if any.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FlexPersistentVolumeSource#options
     */
    readonly options?: {
        [key: string]: string;
    };
    /**
     * (experimental) Optional: Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @experimental
     * @schema io.k8s.api.core.v1.FlexPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.
     *
     * This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FlexPersistentVolumeSource#secretRef
     */
    readonly secretRef?: SecretReference;
}
/**
 * Converts an object of type 'FlexPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_FlexPersistentVolumeSource(obj: FlexPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Flocker volume mounted by the Flocker agent.
 *
 * One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.FlockerVolumeSource
 */
export interface FlockerVolumeSource {
    /**
     * (experimental) Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FlockerVolumeSource#datasetName
     */
    readonly datasetName?: string;
    /**
     * (experimental) UUID of the dataset.
     *
     * This is unique identifier of a Flocker dataset
     *
     * @experimental
     * @schema io.k8s.api.core.v1.FlockerVolumeSource#datasetUUID
     */
    readonly datasetUuid?: string;
}
/**
 * Converts an object of type 'FlockerVolumeSource' to JSON representation.
 */
export declare function toJson_FlockerVolumeSource(obj: FlockerVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Persistent Disk resource in Google Compute Engine.
 *
 * A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.GCEPersistentDiskVolumeSource
 */
export interface GcePersistentDiskVolumeSource {
    /**
     * (experimental) Filesystem type of the volume that you want to mount.
     *
     * Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @experimental
     * @schema io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) The partition in the volume that you want to mount.
     *
     * If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @experimental
     * @schema io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#partition
     */
    readonly partition?: number;
    /**
     * (experimental) Unique name of the PD resource in GCE.
     *
     * Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @experimental
     * @schema io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#pdName
     */
    readonly pdName: string;
    /**
     * (experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @default false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     * @experimental
     * @schema io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'GcePersistentDiskVolumeSource' to JSON representation.
 */
export declare function toJson_GcePersistentDiskVolumeSource(obj: GcePersistentDiskVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Glusterfs mount that lasts the lifetime of a pod.
 *
 * Glusterfs volumes do not support ownership management or SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.GlusterfsPersistentVolumeSource
 */
export interface GlusterfsPersistentVolumeSource {
    /**
     * (experimental) EndpointsName is the endpoint name that details Glusterfs topology.
     *
     * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     *
     * @experimental
     * @schema io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpoints
     */
    readonly endpoints: string;
    /**
     * (experimental) EndpointsNamespace is the namespace that contains Glusterfs endpoint.
     *
     * If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     *
     * @experimental
     * @schema io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpointsNamespace
     */
    readonly endpointsNamespace?: string;
    /**
     * (experimental) Path is the Glusterfs volume path.
     *
     * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     *
     * @experimental
     * @schema io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#path
     */
    readonly path: string;
    /**
     * (experimental) ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.
     *
     * Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     *
     * @default false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     * @experimental
     * @schema io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'GlusterfsPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_GlusterfsPersistentVolumeSource(obj: GlusterfsPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a host path mapped into a pod.
 *
 * Host path volumes do not support ownership management or SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.HostPathVolumeSource
 */
export interface HostPathVolumeSource {
    /**
     * (experimental) Path of the directory on the host.
     *
     * If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     *
     * @experimental
     * @schema io.k8s.api.core.v1.HostPathVolumeSource#path
     */
    readonly path: string;
    /**
     * (experimental) Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath.
     *
     * @default More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     * @experimental
     * @schema io.k8s.api.core.v1.HostPathVolumeSource#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'HostPathVolumeSource' to JSON representation.
 */
export declare function toJson_HostPathVolumeSource(obj: HostPathVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) ISCSIPersistentVolumeSource represents an ISCSI disk.
 *
 * ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource
 */
export interface IscsiPersistentVolumeSource {
    /**
     * (experimental) whether support iSCSI Discovery CHAP authentication.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthDiscovery
     */
    readonly chapAuthDiscovery?: boolean;
    /**
     * (experimental) whether support iSCSI Session CHAP authentication.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthSession
     */
    readonly chapAuthSession?: boolean;
    /**
     * (experimental) Filesystem type of the volume that you want to mount.
     *
     * Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Custom iSCSI Initiator Name.
     *
     * If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#initiatorName
     */
    readonly initiatorName?: string;
    /**
     * (experimental) Target iSCSI Qualified Name.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iqn
     */
    readonly iqn: string;
    /**
     * (experimental) iSCSI Interface Name that uses an iSCSI transport.
     *
     * Defaults to 'default' (tcp).
     *
     * @default default' (tcp).
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iscsiInterface
     */
    readonly iscsiInterface?: string;
    /**
     * (experimental) iSCSI Target Lun number.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#lun
     */
    readonly lun: number;
    /**
     * (experimental) iSCSI Target Portal List.
     *
     * The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#portals
     */
    readonly portals?: string[];
    /**
     * (experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) CHAP Secret for iSCSI target and initiator authentication.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#secretRef
     */
    readonly secretRef?: SecretReference;
    /**
     * (experimental) iSCSI Target Portal.
     *
     * The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ISCSIPersistentVolumeSource#targetPortal
     */
    readonly targetPortal: string;
}
/**
 * Converts an object of type 'IscsiPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_IscsiPersistentVolumeSource(obj: IscsiPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Local represents directly-attached storage with node affinity (Beta feature).
 *
 * @experimental
 * @schema io.k8s.api.core.v1.LocalVolumeSource
 */
export interface LocalVolumeSource {
    /**
     * (experimental) Filesystem type to mount.
     *
     * It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a fileystem if unspecified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LocalVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) The full path to the volume on the node.
     *
     * It can be either a directory or block device (disk, partition, ...).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.LocalVolumeSource#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'LocalVolumeSource' to JSON representation.
 */
export declare function toJson_LocalVolumeSource(obj: LocalVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents an NFS mount that lasts the lifetime of a pod.
 *
 * NFS volumes do not support ownership management or SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.NFSVolumeSource
 */
export interface NfsVolumeSource {
    /**
     * (experimental) Path that is exported by the NFS server.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NFSVolumeSource#path
     */
    readonly path: string;
    /**
     * (experimental) ReadOnly here will force the NFS export to be mounted with read-only permissions.
     *
     * Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @default false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     * @experimental
     * @schema io.k8s.api.core.v1.NFSVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Server is the hostname or IP address of the NFS server.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @experimental
     * @schema io.k8s.api.core.v1.NFSVolumeSource#server
     */
    readonly server: string;
}
/**
 * Converts an object of type 'NfsVolumeSource' to JSON representation.
 */
export declare function toJson_NfsVolumeSource(obj: NfsVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.VolumeNodeAffinity
 */
export interface VolumeNodeAffinity {
    /**
     * (experimental) Required specifies hard node constraints that must be met.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VolumeNodeAffinity#required
     */
    readonly required?: NodeSelector;
}
/**
 * Converts an object of type 'VolumeNodeAffinity' to JSON representation.
 */
export declare function toJson_VolumeNodeAffinity(obj: VolumeNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Photon Controller persistent disk resource.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource
 */
export interface PhotonPersistentDiskVolumeSource {
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) ID that identifies Photon Controller persistent disk.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource#pdID
     */
    readonly pdId: string;
}
/**
 * Converts an object of type 'PhotonPersistentDiskVolumeSource' to JSON representation.
 */
export declare function toJson_PhotonPersistentDiskVolumeSource(obj: PhotonPersistentDiskVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) PortworxVolumeSource represents a Portworx volume resource.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PortworxVolumeSource
 */
export interface PortworxVolumeSource {
    /**
     * (experimental) FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system.
     *
     * Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PortworxVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @experimental
     * @schema io.k8s.api.core.v1.PortworxVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) VolumeID uniquely identifies a Portworx volume.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PortworxVolumeSource#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'PortworxVolumeSource' to JSON representation.
 */
export declare function toJson_PortworxVolumeSource(obj: PortworxVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Quobyte mount that lasts the lifetime of a pod.
 *
 * Quobyte volumes do not support ownership management or SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.QuobyteVolumeSource
 */
export interface QuobyteVolumeSource {
    /**
     * (experimental) Group to map volume access to Default is no group.
     *
     * @default no group
     * @experimental
     * @schema io.k8s.api.core.v1.QuobyteVolumeSource#group
     */
    readonly group?: string;
    /**
     * (experimental) ReadOnly here will force the Quobyte volume to be mounted with read-only permissions.
     *
     * Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.QuobyteVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.QuobyteVolumeSource#registry
     */
    readonly registry: string;
    /**
     * (experimental) Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.QuobyteVolumeSource#tenant
     */
    readonly tenant?: string;
    /**
     * (experimental) User to map volume access to Defaults to serivceaccount user.
     *
     * @default serivceaccount user
     * @experimental
     * @schema io.k8s.api.core.v1.QuobyteVolumeSource#user
     */
    readonly user?: string;
    /**
     * (experimental) Volume is a string that references an already created Quobyte volume by name.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.QuobyteVolumeSource#volume
     */
    readonly volume: string;
}
/**
 * Converts an object of type 'QuobyteVolumeSource' to JSON representation.
 */
export declare function toJson_QuobyteVolumeSource(obj: QuobyteVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a Rados Block Device mount that lasts the lifetime of a pod.
 *
 * RBD volumes support ownership management and SELinux relabeling.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource
 */
export interface RbdPersistentVolumeSource {
    /**
     * (experimental) Filesystem type of the volume that you want to mount.
     *
     * Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
     *
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) The rados image name.
     *
     * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#image
     */
    readonly image: string;
    /**
     * (experimental) Keyring is the path to key ring for RBDUser.
     *
     * Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#keyring
     */
    readonly keyring?: string;
    /**
     * (experimental) A collection of Ceph monitors.
     *
     * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#monitors
     */
    readonly monitors: string[];
    /**
     * (experimental) The rados pool name.
     *
     * Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#pool
     */
    readonly pool?: string;
    /**
     * (experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) SecretRef is name of the authentication secret for RBDUser.
     *
     * If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#secretRef
     */
    readonly secretRef?: SecretReference;
    /**
     * (experimental) The rados user name.
     *
     * Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @experimental
     * @schema io.k8s.api.core.v1.RBDPersistentVolumeSource#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'RbdPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_RbdPersistentVolumeSource(obj: RbdPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource
 */
export interface ScaleIoPersistentVolumeSource {
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs"
     *
     * @default xfs"
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) The host address of the ScaleIO API Gateway.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#gateway
     */
    readonly gateway: string;
    /**
     * (experimental) The name of the ScaleIO Protection Domain for the configured storage.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#protectionDomain
     */
    readonly protectionDomain?: string;
    /**
     * (experimental) Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) SecretRef references to the secret for ScaleIO user and other sensitive information.
     *
     * If this is not provided, Login operation will fail.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#secretRef
     */
    readonly secretRef: SecretReference;
    /**
     * (experimental) Flag to enable/disable SSL communication with Gateway, default false.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#sslEnabled
     */
    readonly sslEnabled?: boolean;
    /**
     * (experimental) Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
     *
     * Default is ThinProvisioned.
     *
     * @default ThinProvisioned.
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#storageMode
     */
    readonly storageMode?: string;
    /**
     * (experimental) The ScaleIO Storage Pool associated with the protection domain.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#storagePool
     */
    readonly storagePool?: string;
    /**
     * (experimental) The name of the storage system as configured in ScaleIO.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#system
     */
    readonly system: string;
    /**
     * (experimental) The name of a volume already created in the ScaleIO system that is associated with this volume source.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScaleIOPersistentVolumeSource#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'ScaleIoPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_ScaleIoPersistentVolumeSource(obj: ScaleIoPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a StorageOS persistent volume resource.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.StorageOSPersistentVolumeSource
 */
export interface StorageOsPersistentVolumeSource {
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.StorageOSPersistentVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Defaults to false (read/write).
     *
     * ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @experimental
     * @schema io.k8s.api.core.v1.StorageOSPersistentVolumeSource#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) SecretRef specifies the secret to use for obtaining the StorageOS API credentials.
     *
     * If not specified, default values will be attempted.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.StorageOSPersistentVolumeSource#secretRef
     */
    readonly secretRef?: ObjectReference;
    /**
     * (experimental) VolumeName is the human-readable name of the StorageOS volume.
     *
     * Volume names are only unique within a namespace.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.StorageOSPersistentVolumeSource#volumeName
     */
    readonly volumeName?: string;
    /**
     * (experimental) VolumeNamespace specifies the scope of the volume within StorageOS.
     *
     * If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.StorageOSPersistentVolumeSource#volumeNamespace
     */
    readonly volumeNamespace?: string;
}
/**
 * Converts an object of type 'StorageOsPersistentVolumeSource' to JSON representation.
 */
export declare function toJson_StorageOsPersistentVolumeSource(obj: StorageOsPersistentVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) Represents a vSphere volume resource.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource
 */
export interface VsphereVirtualDiskVolumeSource {
    /**
     * (experimental) Filesystem type to mount.
     *
     * Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource#fsType
     */
    readonly fsType?: string;
    /**
     * (experimental) Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource#storagePolicyID
     */
    readonly storagePolicyId?: string;
    /**
     * (experimental) Storage Policy Based Management (SPBM) profile name.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource#storagePolicyName
     */
    readonly storagePolicyName?: string;
    /**
     * (experimental) Path that identifies vSphere volume vmdk.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource#volumePath
     */
    readonly volumePath: string;
}
/**
 * Converts an object of type 'VsphereVirtualDiskVolumeSource' to JSON representation.
 */
export declare function toJson_VsphereVirtualDiskVolumeSource(obj: VsphereVirtualDiskVolumeSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.TypedLocalObjectReference
 */
export interface TypedLocalObjectReference {
    /**
     * (experimental) APIGroup is the group for the resource being referenced.
     *
     * If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TypedLocalObjectReference#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * (experimental) Kind is the type of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TypedLocalObjectReference#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name is the name of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TypedLocalObjectReference#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TypedLocalObjectReference' to JSON representation.
 */
export declare function toJson_TypedLocalObjectReference(obj: TypedLocalObjectReference | undefined): Record<string, any> | undefined;
/**
 * (experimental) Affinity is a group of affinity scheduling rules.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Affinity
 */
export interface Affinity {
    /**
     * (experimental) Describes node affinity scheduling rules for the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Affinity#nodeAffinity
     */
    readonly nodeAffinity?: NodeAffinity;
    /**
     * (experimental) Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Affinity#podAffinity
     */
    readonly podAffinity?: PodAffinity;
    /**
     * (experimental) Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Affinity#podAntiAffinity
     */
    readonly podAntiAffinity?: PodAntiAffinity;
}
/**
 * Converts an object of type 'Affinity' to JSON representation.
 */
export declare function toJson_Affinity(obj: Affinity | undefined): Record<string, any> | undefined;
/**
 * (experimental) A single application container that you want to run within a pod.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Container
 */
export interface Container {
    /**
     * (experimental) Arguments to the entrypoint.
     *
     * The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#args
     */
    readonly args?: string[];
    /**
     * (experimental) Entrypoint array.
     *
     * Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#command
     */
    readonly command?: string[];
    /**
     * (experimental) List of environment variables to set in the container.
     *
     * Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#env
     */
    readonly env?: EnvVar[];
    /**
     * (experimental) List of sources to populate environment variables in the container.
     *
     * The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#envFrom
     */
    readonly envFrom?: EnvFromSource[];
    /**
     * (experimental) Docker image name.
     *
     * More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#image
     */
    readonly image?: string;
    /**
     * (experimental) Image pull policy.
     *
     * One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
     *
     * @default Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
     * @experimental
     * @schema io.k8s.api.core.v1.Container#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * (experimental) Actions that the management system should take in response to container lifecycle events.
     *
     * Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#lifecycle
     */
    readonly lifecycle?: Lifecycle;
    /**
     * (experimental) Periodic probe of container liveness.
     *
     * Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#livenessProbe
     */
    readonly livenessProbe?: Probe;
    /**
     * (experimental) Name of the container specified as a DNS_LABEL.
     *
     * Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#name
     */
    readonly name: string;
    /**
     * (experimental) List of ports to expose from the container.
     *
     * Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#ports
     */
    readonly ports?: ContainerPort[];
    /**
     * (experimental) Periodic probe of container service readiness.
     *
     * Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#readinessProbe
     */
    readonly readinessProbe?: Probe;
    /**
     * (experimental) Compute Resources required by this container.
     *
     * Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#resources
     */
    readonly resources?: ResourceRequirements;
    /**
     * (experimental) Security options the pod should run with.
     *
     * More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#securityContext
     */
    readonly securityContext?: SecurityContext;
    /**
     * (experimental) StartupProbe indicates that the Pod has successfully initialized.
     *
     * If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#startupProbe
     */
    readonly startupProbe?: Probe;
    /**
     * (experimental) Whether this container should allocate a buffer for stdin in the container runtime.
     *
     * If this is not set, reads from stdin in the container will always result in EOF. Default is false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.Container#stdin
     */
    readonly stdin?: boolean;
    /**
     * (experimental) Whether the container runtime should close the stdin channel after it has been opened by a single attach.
     *
     * When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
     *
     * @default false
     * @experimental
     * @schema io.k8s.api.core.v1.Container#stdinOnce
     */
    readonly stdinOnce?: boolean;
    /**
     * (experimental) Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.
     *
     * Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
     *
     * @default dev/termination-log. Cannot be updated.
     * @experimental
     * @schema io.k8s.api.core.v1.Container#terminationMessagePath
     */
    readonly terminationMessagePath?: string;
    /**
     * (experimental) Indicate how the termination message should be populated.
     *
     * File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
     *
     * @default File. Cannot be updated.
     * @experimental
     * @schema io.k8s.api.core.v1.Container#terminationMessagePolicy
     */
    readonly terminationMessagePolicy?: string;
    /**
     * (experimental) Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.
     *
     * Default is false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.api.core.v1.Container#tty
     */
    readonly tty?: boolean;
    /**
     * (experimental) volumeDevices is the list of block devices to be used by the container.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#volumeDevices
     */
    readonly volumeDevices?: VolumeDevice[];
    /**
     * (experimental) Pod volumes to mount into the container's filesystem.
     *
     * Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#volumeMounts
     */
    readonly volumeMounts?: VolumeMount[];
    /**
     * (experimental) Container's working directory.
     *
     * If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Container#workingDir
     */
    readonly workingDir?: string;
}
/**
 * Converts an object of type 'Container' to JSON representation.
 */
export declare function toJson_Container(obj: Container | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodDNSConfig
 */
export interface PodDnsConfig {
    /**
     * (experimental) A list of DNS name server IP addresses.
     *
     * This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodDNSConfig#nameservers
     */
    readonly nameservers?: string[];
    /**
     * (experimental) A list of DNS resolver options.
     *
     * This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodDNSConfig#options
     */
    readonly options?: PodDnsConfigOption[];
    /**
     * (experimental) A list of DNS search domains for host-name lookup.
     *
     * This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodDNSConfig#searches
     */
    readonly searches?: string[];
}
/**
 * Converts an object of type 'PodDnsConfig' to JSON representation.
 */
export declare function toJson_PodDnsConfig(obj: PodDnsConfig | undefined): Record<string, any> | undefined;
/**
 * (experimental) HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.HostAlias
 */
export interface HostAlias {
    /**
     * (experimental) Hostnames for the above IP address.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.HostAlias#hostnames
     */
    readonly hostnames?: string[];
    /**
     * (experimental) IP address of the host file entry.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.HostAlias#ip
     */
    readonly ip?: string;
}
/**
 * Converts an object of type 'HostAlias' to JSON representation.
 */
export declare function toJson_HostAlias(obj: HostAlias | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodReadinessGate contains the reference to a pod condition.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodReadinessGate
 */
export interface PodReadinessGate {
    /**
     * (experimental) ConditionType refers to a condition in the pod's condition list with matching type.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodReadinessGate#conditionType
     */
    readonly conditionType: string;
}
/**
 * Converts an object of type 'PodReadinessGate' to JSON representation.
 */
export declare function toJson_PodReadinessGate(obj: PodReadinessGate | undefined): Record<string, any> | undefined;
/**
 * (experimental) PodSecurityContext holds pod-level security attributes and common container settings.
 *
 * Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.PodSecurityContext
 */
export interface PodSecurityContext {
    /**
     * (experimental) A special supplemental group that applies to all containers in a pod.
     *
     * Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:
     *
     * 1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----
     *
     * If unset, the Kubelet will not modify the ownership and permissions of any volume.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * (experimental) fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod.
     *
     * This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are "OnRootMismatch" and "Always". If not specified, "Always" is used.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * (experimental) The GID to run the entrypoint of the container process.
     *
     * Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * (experimental) Indicates that the container must run as a non-root user.
     *
     * If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * (experimental) The UID to run the entrypoint of the container process.
     *
     * Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     *
     * @default user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * (experimental) The SELinux context to be applied to all containers.
     *
     * If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: SeLinuxOptions;
    /**
     * (experimental) The seccomp options to use by the containers in this pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#seccompProfile
     */
    readonly seccompProfile?: SeccompProfile;
    /**
     * (experimental) A list of groups applied to the first process run in each container, in addition to the container's primary GID.
     *
     * If unspecified, no groups will be added to any container.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * (experimental) Sysctls hold a list of namespaced sysctls used for the pod.
     *
     * Pods with unsupported sysctls (by the container runtime) might fail to launch.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#sysctls
     */
    readonly sysctls?: Sysctl[];
    /**
     * (experimental) The Windows specific settings applied to all containers.
     *
     * If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.PodSecurityContext#windowsOptions
     */
    readonly windowsOptions?: WindowsSecurityContextOptions;
}
/**
 * Converts an object of type 'PodSecurityContext' to JSON representation.
 */
export declare function toJson_PodSecurityContext(obj: PodSecurityContext | undefined): Record<string, any> | undefined;
/**
 * (experimental) The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Toleration
 */
export interface Toleration {
    /**
     * (experimental) Effect indicates the taint effect to match.
     *
     * Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Toleration#effect
     */
    readonly effect?: string;
    /**
     * (experimental) Key is the taint key that the toleration applies to.
     *
     * Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Toleration#key
     */
    readonly key?: string;
    /**
     * (experimental) Operator represents a key's relationship to the value.
     *
     * Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
     *
     * @default Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
     * @experimental
     * @schema io.k8s.api.core.v1.Toleration#operator
     */
    readonly operator?: string;
    /**
     * (experimental) TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint.
     *
     * By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Toleration#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * (experimental) Value is the taint value the toleration matches to.
     *
     * If the operator is Exists, the value should be empty, otherwise just a regular string.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Toleration#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'Toleration' to JSON representation.
 */
export declare function toJson_Toleration(obj: Toleration | undefined): Record<string, any> | undefined;
/**
 * (experimental) TopologySpreadConstraint specifies how to spread matching pods among the given topology.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.TopologySpreadConstraint
 */
export interface TopologySpreadConstraint {
    /**
     * (experimental) LabelSelector is used to find matching pods.
     *
     * Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TopologySpreadConstraint#labelSelector
     */
    readonly labelSelector?: LabelSelector;
    /**
     * (experimental) MaxSkew describes the degree to which pods may be unevenly distributed.
     *
     * When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TopologySpreadConstraint#maxSkew
     */
    readonly maxSkew: number;
    /**
     * (experimental) TopologyKey is the key of node labels.
     *
     * Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a "bucket", and try to put balanced number of pods into each bucket. It's a required field.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TopologySpreadConstraint#topologyKey
     */
    readonly topologyKey: string;
    /**
     * (experimental) WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint.
     *
     * - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,
     * but giving higher precedence to topologies that would help reduce the
     * skew.
     * A constraint is considered "Unsatisfiable" for an incoming pod if and only if every possible node assigment for that pod would violate "MaxSkew" on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TopologySpreadConstraint#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TopologySpreadConstraint' to JSON representation.
 */
export declare function toJson_TopologySpreadConstraint(obj: TopologySpreadConstraint | undefined): Record<string, any> | undefined;
/**
 * (experimental) Volume represents a named volume in a pod that may be accessed by any container in the pod.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.Volume
 */
export interface Volume {
    /**
     * (experimental) AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#awsElasticBlockStore
     */
    readonly awsElasticBlockStore?: AwsElasticBlockStoreVolumeSource;
    /**
     * (experimental) AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#azureDisk
     */
    readonly azureDisk?: AzureDiskVolumeSource;
    /**
     * (experimental) AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#azureFile
     */
    readonly azureFile?: AzureFileVolumeSource;
    /**
     * (experimental) CephFS represents a Ceph FS mount on the host that shares a pod's lifetime.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#cephfs
     */
    readonly cephfs?: CephFsVolumeSource;
    /**
     * (experimental) Cinder represents a cinder volume attached and mounted on kubelets host machine.
     *
     * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#cinder
     */
    readonly cinder?: CinderVolumeSource;
    /**
     * (experimental) ConfigMap represents a configMap that should populate this volume.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#configMap
     */
    readonly configMap?: ConfigMapVolumeSource;
    /**
     * (experimental) CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#csi
     */
    readonly csi?: CsiVolumeSource;
    /**
     * (experimental) DownwardAPI represents downward API about the pod that should populate this volume.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#downwardAPI
     */
    readonly downwardApi?: DownwardApiVolumeSource;
    /**
     * (experimental) EmptyDir represents a temporary directory that shares a pod's lifetime.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#emptyDir
     */
    readonly emptyDir?: EmptyDirVolumeSource;
    /**
     * (experimental) Ephemeral represents a volume that is handled by a cluster storage driver.
     *
     * The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
     *
     * Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
     * tracking are needed,
     * c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
     * a PersistentVolumeClaim (see EphemeralVolumeSource for more
     * information on the connection between this volume type
     * and PersistentVolumeClaim).
     *
     * Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
     *
     * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
     *
     * A pod can use both types of ephemeral volumes and persistent volumes at the same time.
     *
     * This is a beta feature and only available when the GenericEphemeralVolume feature gate is enabled.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#ephemeral
     */
    readonly ephemeral?: EphemeralVolumeSource;
    /**
     * (experimental) FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#fc
     */
    readonly fc?: FcVolumeSource;
    /**
     * (experimental) FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#flexVolume
     */
    readonly flexVolume?: FlexVolumeSource;
    /**
     * (experimental) Flocker represents a Flocker volume attached to a kubelet's host machine.
     *
     * This depends on the Flocker control service being running
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#flocker
     */
    readonly flocker?: FlockerVolumeSource;
    /**
     * (experimental) GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#gcePersistentDisk
     */
    readonly gcePersistentDisk?: GcePersistentDiskVolumeSource;
    /**
     * (experimental) GitRepo represents a git repository at a particular revision.
     *
     * DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#gitRepo
     */
    readonly gitRepo?: GitRepoVolumeSource;
    /**
     * (experimental) Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime.
     *
     * More info: https://examples.k8s.io/volumes/glusterfs/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#glusterfs
     */
    readonly glusterfs?: GlusterfsVolumeSource;
    /**
     * (experimental) HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container.
     *
     * This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#hostPath
     */
    readonly hostPath?: HostPathVolumeSource;
    /**
     * (experimental) ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * More info: https://examples.k8s.io/volumes/iscsi/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#iscsi
     */
    readonly iscsi?: IscsiVolumeSource;
    /**
     * (experimental) Volume's name.
     *
     * Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#name
     */
    readonly name: string;
    /**
     * (experimental) NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#nfs
     */
    readonly nfs?: NfsVolumeSource;
    /**
     * (experimental) PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#persistentVolumeClaim
     */
    readonly persistentVolumeClaim?: PersistentVolumeClaimVolumeSource;
    /**
     * (experimental) PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#photonPersistentDisk
     */
    readonly photonPersistentDisk?: PhotonPersistentDiskVolumeSource;
    /**
     * (experimental) PortworxVolume represents a portworx volume attached and mounted on kubelets host machine.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#portworxVolume
     */
    readonly portworxVolume?: PortworxVolumeSource;
    /**
     * (experimental) Items for all in one resources secrets, configmaps, and downward API.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#projected
     */
    readonly projected?: ProjectedVolumeSource;
    /**
     * (experimental) Quobyte represents a Quobyte mount on the host that shares a pod's lifetime.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#quobyte
     */
    readonly quobyte?: QuobyteVolumeSource;
    /**
     * (experimental) RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.
     *
     * More info: https://examples.k8s.io/volumes/rbd/README.md
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#rbd
     */
    readonly rbd?: RbdVolumeSource;
    /**
     * (experimental) ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#scaleIO
     */
    readonly scaleIo?: ScaleIoVolumeSource;
    /**
     * (experimental) Secret represents a secret that should populate this volume.
     *
     * More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#secret
     */
    readonly secret?: SecretVolumeSource;
    /**
     * (experimental) StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#storageos
     */
    readonly storageos?: StorageOsVolumeSource;
    /**
     * (experimental) VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.Volume#vsphereVolume
     */
    readonly vsphereVolume?: VsphereVirtualDiskVolumeSource;
}
/**
 * Converts an object of type 'Volume' to JSON representation.
 */
export declare function toJson_Volume(obj: Volume | undefined): Record<string, any> | undefined;
/**
 * (experimental) A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ScopeSelector
 */
export interface ScopeSelector {
    /**
     * (experimental) A list of scope selector requirements by scope of the resources.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ScopeSelector#matchExpressions
     */
    readonly matchExpressions?: ScopedResourceSelectorRequirement[];
}
/**
 * Converts an object of type 'ScopeSelector' to JSON representation.
 */
export declare function toJson_ScopeSelector(obj: ScopeSelector | undefined): Record<string, any> | undefined;
/**
 * (experimental) ServicePort contains information on service's port.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.ServicePort
 */
export interface ServicePort {
    /**
     * (experimental) The application protocol for this port.
     *
     * This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. This is a beta field that is guarded by the ServiceAppProtocol feature gate and enabled by default.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServicePort#appProtocol
     */
    readonly appProtocol?: string;
    /**
     * (experimental) The name of this port within the service.
     *
     * This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. When considering the endpoints for a Service, this must match the 'name' field in the EndpointPort. Optional if only one ServicePort is defined on this service.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServicePort#name
     */
    readonly name?: string;
    /**
     * (experimental) The port on each node on which this service is exposed when type is NodePort or LoadBalancer.
     *
     * Usually assigned by the system. If a value is specified, in-range, and not in use it will be used, otherwise the operation will fail.  If not specified, a port will be allocated if this Service requires one.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type from NodePort to ClusterIP). More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServicePort#nodePort
     */
    readonly nodePort?: number;
    /**
     * (experimental) The port that will be exposed by this service.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServicePort#port
     */
    readonly port: number;
    /**
     * (experimental) The IP protocol for this port.
     *
     * Supports "TCP", "UDP", and "SCTP". Default is TCP.
     *
     * @default TCP.
     * @experimental
     * @schema io.k8s.api.core.v1.ServicePort#protocol
     */
    readonly protocol?: string;
    /**
     * (experimental) Number or name of the port to access on the pods targeted by the service.
     *
     * Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
     *
     * @experimental
     * @schema io.k8s.api.core.v1.ServicePort#targetPort
     */
    readonly targetPort?: IntOrString;
}
/**
 * Converts an object of type 'ServicePort' to JSON representation.
 */
export declare function toJson_ServicePort(obj: ServicePort | undefined): Record<string, any> | undefined;
/**
 * (experimental) SessionAffinityConfig represents the configurations of session affinity.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.SessionAffinityConfig
 */
export interface SessionAffinityConfig {
    /**
     * (experimental) clientIP contains the configurations of Client IP based session affinity.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.SessionAffinityConfig#clientIP
     */
    readonly clientIp?: ClientIpConfig;
}
/**
 * Converts an object of type 'SessionAffinityConfig' to JSON representation.
 */
export declare function toJson_SessionAffinityConfig(obj: SessionAffinityConfig | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointConditions represents the current condition of an endpoint.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1.EndpointConditions
 */
export interface EndpointConditions {
    /**
     * (experimental) ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint.
     *
     * A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointConditions#ready
     */
    readonly ready?: boolean;
    /**
     * (experimental) serving is identical to ready except that it is set regardless of the terminating state of endpoints.
     *
     * This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointConditions#serving
     */
    readonly serving?: boolean;
    /**
     * (experimental) terminating indicates that this endpoint is terminating.
     *
     * A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointConditions#terminating
     */
    readonly terminating?: boolean;
}
/**
 * Converts an object of type 'EndpointConditions' to JSON representation.
 */
export declare function toJson_EndpointConditions(obj: EndpointConditions | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointHints provides hints describing how an endpoint should be consumed.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1.EndpointHints
 */
export interface EndpointHints {
    /**
     * (experimental) forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1.EndpointHints#forZones
     */
    readonly forZones?: ForZone[];
}
/**
 * Converts an object of type 'EndpointHints' to JSON representation.
 */
export declare function toJson_EndpointHints(obj: EndpointHints | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointConditions represents the current condition of an endpoint.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.EndpointConditions
 */
export interface EndpointConditionsV1Beta1 {
    /**
     * (experimental) ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint.
     *
     * A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be "true" for terminating endpoints.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointConditions#ready
     */
    readonly ready?: boolean;
    /**
     * (experimental) serving is identical to ready except that it is set regardless of the terminating state of endpoints.
     *
     * This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointConditions#serving
     */
    readonly serving?: boolean;
    /**
     * (experimental) terminating indicates that this endpoint is terminating.
     *
     * A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointConditions#terminating
     */
    readonly terminating?: boolean;
}
/**
 * Converts an object of type 'EndpointConditionsV1Beta1' to JSON representation.
 */
export declare function toJson_EndpointConditionsV1Beta1(obj: EndpointConditionsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) EndpointHints provides hints describing how an endpoint should be consumed.
 *
 * @experimental
 * @schema io.k8s.api.discovery.v1beta1.EndpointHints
 */
export interface EndpointHintsV1Beta1 {
    /**
     * (experimental) forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing.
     *
     * May contain a maximum of 8 entries.
     *
     * @experimental
     * @schema io.k8s.api.discovery.v1beta1.EndpointHints#forZones
     */
    readonly forZones?: ForZoneV1Beta1[];
}
/**
 * Converts an object of type 'EndpointHintsV1Beta1' to JSON representation.
 */
export declare function toJson_EndpointHintsV1Beta1(obj: EndpointHintsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressBackend describes all endpoints for a given service and port.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressBackend
 */
export interface IngressBackendV1Beta1 {
    /**
     * (experimental) Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object.
     *
     * If resource is specified, serviceName and servicePort must not be specified.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressBackend#resource
     */
    readonly resource?: TypedLocalObjectReference;
    /**
     * (experimental) Specifies the name of the referenced service.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressBackend#serviceName
     */
    readonly serviceName?: string;
    /**
     * (experimental) Specifies the port of the referenced service.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressBackend#servicePort
     */
    readonly servicePort?: IntOrString;
}
/**
 * Converts an object of type 'IngressBackendV1Beta1' to JSON representation.
 */
export declare function toJson_IngressBackendV1Beta1(obj: IngressBackendV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressRule represents the rules mapping the paths under a specified host to the related backend services.
 *
 * Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressRule
 */
export interface IngressRuleV1Beta1 {
    /**
     * (experimental) Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     *
     * Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     * the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * Currently the port of an Ingress is implicitly :80 for http and
     * :443 for https.
     * Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
     *
     * Host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressRule#host
     */
    readonly host?: string;
    /**
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressRule#http
     */
    readonly http?: HttpIngressRuleValueV1Beta1;
}
/**
 * Converts an object of type 'IngressRuleV1Beta1' to JSON representation.
 */
export declare function toJson_IngressRuleV1Beta1(obj: IngressRuleV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressTLS describes the transport layer security associated with an Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressTLS
 */
export interface IngressTlsv1Beta1 {
    /**
     * (experimental) Hosts are a list of hosts included in the TLS certificate.
     *
     * The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
     *
     * @default the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressTLS#hosts
     */
    readonly hosts?: string[];
    /**
     * (experimental) SecretName is the name of the secret used to terminate TLS traffic on port 443.
     *
     * Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressTLS#secretName
     */
    readonly secretName?: string;
}
/**
 * Converts an object of type 'IngressTlsv1Beta1' to JSON representation.
 */
export declare function toJson_IngressTlsv1Beta1(obj: IngressTlsv1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) FlowDistinguisherMethod specifies the method of a flow distinguisher.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod
 */
export interface FlowDistinguisherMethodV1Beta1 {
    /**
     * (experimental) `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace".
     *
     * Required.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'FlowDistinguisherMethodV1Beta1' to JSON representation.
 */
export declare function toJson_FlowDistinguisherMethodV1Beta1(obj: FlowDistinguisherMethodV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) PriorityLevelConfigurationReference contains information that points to the "request-priority" being used.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference
 */
export interface PriorityLevelConfigurationReferenceV1Beta1 {
    /**
     * (experimental) `name` is the name of the priority level configuration being referenced Required.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'PriorityLevelConfigurationReferenceV1Beta1' to JSON representation.
 */
export declare function toJson_PriorityLevelConfigurationReferenceV1Beta1(obj: PriorityLevelConfigurationReferenceV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver.
 *
 * The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects
 */
export interface PolicyRulesWithSubjectsV1Beta1 {
    /**
     * (experimental) `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects#nonResourceRules
     */
    readonly nonResourceRules?: NonResourcePolicyRuleV1Beta1[];
    /**
     * (experimental) `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource.
     *
     * At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects#resourceRules
     */
    readonly resourceRules?: ResourcePolicyRuleV1Beta1[];
    /**
     * (experimental) subjects is the list of normal user, serviceaccount, or group that this rule cares about.
     *
     * There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects#subjects
     */
    readonly subjects: SubjectV1Beta1[];
}
/**
 * Converts an object of type 'PolicyRulesWithSubjectsV1Beta1' to JSON representation.
 */
export declare function toJson_PolicyRulesWithSubjectsV1Beta1(obj: PolicyRulesWithSubjectsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits.
 *
 * It addresses two issues:
 * * How are requests for this priority level limited?
 * * What should be done with requests that exceed the limit?
 *
 * @experimental
 * @schema io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration
 */
export interface LimitedPriorityLevelConfigurationV1Beta1 {
    /**
     * (experimental) `assuredConcurrencyShares` (ACS) configures the execution limit, which is a limit on the number of requests of this priority level that may be exeucting at a given time.
     *
     * ACS must be a positive number. The server's concurrency limit (SCL) is divided among the concurrency-controlled priority levels in proportion to their assured concurrency shares. This produces the assured concurrency value (ACV) --- the number of requests that may be executing at a time --- for each such priority level:
     *
     * ACV(l) = ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )
     *
     * bigger numbers of ACS mean more reserved concurrent requests (at the expense of every other PL). This field has a default value of 30.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration#assuredConcurrencyShares
     */
    readonly assuredConcurrencyShares?: number;
    /**
     * (experimental) `limitResponse` indicates what to do with requests that can not be executed right now.
     *
     * @experimental
     * @schema io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration#limitResponse
     */
    readonly limitResponse?: LimitResponseV1Beta1;
}
/**
 * Converts an object of type 'LimitedPriorityLevelConfigurationV1Beta1' to JSON representation.
 */
export declare function toJson_LimitedPriorityLevelConfigurationV1Beta1(obj: LimitedPriorityLevelConfigurationV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressBackend describes all endpoints for a given service and port.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressBackend
 */
export interface IngressBackend {
    /**
     * (experimental) Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object.
     *
     * If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressBackend#resource
     */
    readonly resource?: TypedLocalObjectReference;
    /**
     * (experimental) Service references a Service as a Backend.
     *
     * This is a mutually exclusive setting with "Resource".
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressBackend#service
     */
    readonly service?: IngressServiceBackend;
}
/**
 * Converts an object of type 'IngressBackend' to JSON representation.
 */
export declare function toJson_IngressBackend(obj: IngressBackend | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressRule represents the rules mapping the paths under a specified host to the related backend services.
 *
 * Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressRule
 */
export interface IngressRule {
    /**
     * (experimental) Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     *
     * Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     * the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * Currently the port of an Ingress is implicitly :80 for http and
     * :443 for https.
     * Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
     *
     * Host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressRule#host
     */
    readonly host?: string;
    /**
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressRule#http
     */
    readonly http?: HttpIngressRuleValue;
}
/**
 * Converts an object of type 'IngressRule' to JSON representation.
 */
export declare function toJson_IngressRule(obj: IngressRule | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressTLS describes the transport layer security associated with an Ingress.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressTLS
 */
export interface IngressTls {
    /**
     * (experimental) Hosts are a list of hosts included in the TLS certificate.
     *
     * The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
     *
     * @default the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressTLS#hosts
     */
    readonly hosts?: string[];
    /**
     * (experimental) SecretName is the name of the secret used to terminate TLS traffic on port 443.
     *
     * Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressTLS#secretName
     */
    readonly secretName?: string;
}
/**
 * Converts an object of type 'IngressTls' to JSON representation.
 */
export declare function toJson_IngressTls(obj: IngressTls | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClassParametersReference identifies an API object.
 *
 * This can be used to specify a cluster or namespace-scoped resource.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.IngressClassParametersReference
 */
export interface IngressClassParametersReference {
    /**
     * (experimental) APIGroup is the group for the resource being referenced.
     *
     * If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassParametersReference#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * (experimental) Kind is the type of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassParametersReference#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name is the name of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassParametersReference#name
     */
    readonly name: string;
    /**
     * (experimental) Namespace is the namespace of the resource being referenced.
     *
     * This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassParametersReference#namespace
     */
    readonly namespace?: string;
    /**
     * (experimental) Scope represents if this refers to a cluster or namespace scoped resource.
     *
     * This may be set to "Cluster" (default) or "Namespace". Field can be enabled with IngressClassNamespacedParams feature gate.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.IngressClassParametersReference#scope
     */
    readonly scope?: string;
}
/**
 * Converts an object of type 'IngressClassParametersReference' to JSON representation.
 */
export declare function toJson_IngressClassParametersReference(obj: IngressClassParametersReference | undefined): Record<string, any> | undefined;
/**
 * (experimental) NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector.
 *
 * The traffic must match both ports and to. This type is beta-level in 1.8
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.NetworkPolicyEgressRule
 */
export interface NetworkPolicyEgressRule {
    /**
     * (experimental) List of destination ports for outgoing traffic.
     *
     * Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicyEgressRule#ports
     */
    readonly ports?: NetworkPolicyPort[];
    /**
     * (experimental) List of destinations for outgoing traffic of pods selected for this rule.
     *
     * Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicyEgressRule#to
     */
    readonly to?: NetworkPolicyPeer[];
}
/**
 * Converts an object of type 'NetworkPolicyEgressRule' to JSON representation.
 */
export declare function toJson_NetworkPolicyEgressRule(obj: NetworkPolicyEgressRule | undefined): Record<string, any> | undefined;
/**
 * (experimental) NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector.
 *
 * The traffic must match both ports and from.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1.NetworkPolicyIngressRule
 */
export interface NetworkPolicyIngressRule {
    /**
     * (experimental) List of sources which should be able to access the pods selected for this rule.
     *
     * Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicyIngressRule#from
     */
    readonly from?: NetworkPolicyPeer[];
    /**
     * (experimental) List of ports which should be made accessible on the pods selected for this rule.
     *
     * Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1.NetworkPolicyIngressRule#ports
     */
    readonly ports?: NetworkPolicyPort[];
}
/**
 * Converts an object of type 'NetworkPolicyIngressRule' to JSON representation.
 */
export declare function toJson_NetworkPolicyIngressRule(obj: NetworkPolicyIngressRule | undefined): Record<string, any> | undefined;
/**
 * (experimental) IngressClassParametersReference identifies an API object.
 *
 * This can be used to specify a cluster or namespace-scoped resource.
 *
 * @experimental
 * @schema io.k8s.api.networking.v1beta1.IngressClassParametersReference
 */
export interface IngressClassParametersReferenceV1Beta1 {
    /**
     * (experimental) APIGroup is the group for the resource being referenced.
     *
     * If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassParametersReference#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * (experimental) Kind is the type of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassParametersReference#kind
     */
    readonly kind: string;
    /**
     * (experimental) Name is the name of resource being referenced.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassParametersReference#name
     */
    readonly name: string;
    /**
     * (experimental) Namespace is the namespace of the resource being referenced.
     *
     * This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassParametersReference#namespace
     */
    readonly namespace?: string;
    /**
     * (experimental) Scope represents if this refers to a cluster or namespace scoped resource.
     *
     * This may be set to "Cluster" (default) or "Namespace". Field can be enabled with IngressClassNamespacedParams feature gate.
     *
     * @experimental
     * @schema io.k8s.api.networking.v1beta1.IngressClassParametersReference#scope
     */
    readonly scope?: string;
}
/**
 * Converts an object of type 'IngressClassParametersReferenceV1Beta1' to JSON representation.
 */
export declare function toJson_IngressClassParametersReferenceV1Beta1(obj: IngressClassParametersReferenceV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) Overhead structure represents the resource overhead associated with running a pod.
 *
 * @experimental
 * @schema io.k8s.api.node.v1alpha1.Overhead
 */
export interface OverheadV1Alpha1 {
    /**
     * (experimental) PodFixed represents the fixed resource overhead associated with running a pod.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.Overhead#podFixed
     */
    readonly podFixed?: {
        [key: string]: Quantity;
    };
}
/**
 * Converts an object of type 'OverheadV1Alpha1' to JSON representation.
 */
export declare function toJson_OverheadV1Alpha1(obj: OverheadV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) Scheduling specifies the scheduling constraints for nodes supporting a RuntimeClass.
 *
 * @experimental
 * @schema io.k8s.api.node.v1alpha1.Scheduling
 */
export interface SchedulingV1Alpha1 {
    /**
     * (experimental) nodeSelector lists labels that must be present on nodes that support this RuntimeClass.
     *
     * Pods using this RuntimeClass can only be scheduled to a node matched by this selector. The RuntimeClass nodeSelector is merged with a pod's existing nodeSelector. Any conflicts will cause the pod to be rejected in admission.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.Scheduling#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * (experimental) tolerations are appended (excluding duplicates) to pods running with this RuntimeClass during admission, effectively unioning the set of nodes tolerated by the pod and the RuntimeClass.
     *
     * @experimental
     * @schema io.k8s.api.node.v1alpha1.Scheduling#tolerations
     */
    readonly tolerations?: Toleration[];
}
/**
 * Converts an object of type 'SchedulingV1Alpha1' to JSON representation.
 */
export declare function toJson_SchedulingV1Alpha1(obj: SchedulingV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * @experimental
 * @schema io.k8s.apimachinery.pkg.util.intstr.IntOrString
 */
export declare class IntOrString {
    readonly value: any;
    /**
     * @experimental
     */
    static fromString(value: string): IntOrString;
    /**
     * @experimental
     */
    static fromNumber(value: number): IntOrString;
    private constructor();
}
/**
 * Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *
 * @schema IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind
 */
export declare enum IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind {
    /**
     * (experimental) Kind is a string value representing the REST resource this object represents.
     *
     * Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     *
     * @experimental
     * @schema IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind
     */
    DELETE_OPTIONS = "DeleteOptions"
}
/**
 * (experimental) Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions
 */
export interface Preconditions {
    /**
     * (experimental) Specifies the target ResourceVersion.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions#resourceVersion
     */
    readonly resourceVersion?: string;
    /**
     * (experimental) Specifies the target UID.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions#uid
     */
    readonly uid?: string;
}
/**
 * Converts an object of type 'Preconditions' to JSON representation.
 */
export declare function toJson_Preconditions(obj: Preconditions | undefined): Record<string, any> | undefined;
/**
 * (experimental) AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.AllowedCSIDriver
 */
export interface AllowedCsiDriverV1Beta1 {
    /**
     * (experimental) Name is the registered name of the CSI driver.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.AllowedCSIDriver#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'AllowedCsiDriverV1Beta1' to JSON representation.
 */
export declare function toJson_AllowedCsiDriverV1Beta1(obj: AllowedCsiDriverV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) AllowedFlexVolume represents a single Flexvolume that is allowed to be used.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.AllowedFlexVolume
 */
export interface AllowedFlexVolumeV1Beta1 {
    /**
     * (experimental) driver is the name of the Flexvolume driver.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.AllowedFlexVolume#driver
     */
    readonly driver: string;
}
/**
 * Converts an object of type 'AllowedFlexVolumeV1Beta1' to JSON representation.
 */
export declare function toJson_AllowedFlexVolumeV1Beta1(obj: AllowedFlexVolumeV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use.
 *
 * It requires the path prefix to be defined.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.AllowedHostPath
 */
export interface AllowedHostPathV1Beta1 {
    /**
     * (experimental) pathPrefix is the path prefix that the host volume must match.
     *
     * It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.
     *
     * Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.AllowedHostPath#pathPrefix
     */
    readonly pathPrefix?: string;
    /**
     * (experimental) when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.AllowedHostPath#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'AllowedHostPathV1Beta1' to JSON representation.
 */
export declare function toJson_AllowedHostPathV1Beta1(obj: AllowedHostPathV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) FSGroupStrategyOptions defines the strategy type and options used to create the strategy.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.FSGroupStrategyOptions
 */
export interface FsGroupStrategyOptionsV1Beta1 {
    /**
     * (experimental) ranges are the allowed ranges of fs groups.
     *
     * If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.FSGroupStrategyOptions#ranges
     */
    readonly ranges?: IdRangeV1Beta1[];
    /**
     * (experimental) rule is the strategy that will dictate what FSGroup is used in the SecurityContext.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.FSGroupStrategyOptions#rule
     */
    readonly rule?: string;
}
/**
 * Converts an object of type 'FsGroupStrategyOptionsV1Beta1' to JSON representation.
 */
export declare function toJson_FsGroupStrategyOptionsV1Beta1(obj: FsGroupStrategyOptionsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.
 *
 * It requires both the start and end to be defined.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.HostPortRange
 */
export interface HostPortRangeV1Beta1 {
    /**
     * (experimental) max is the end of the range, inclusive.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.HostPortRange#max
     */
    readonly max: number;
    /**
     * (experimental) min is the start of the range, inclusive.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.HostPortRange#min
     */
    readonly min: number;
}
/**
 * Converts an object of type 'HostPortRangeV1Beta1' to JSON representation.
 */
export declare function toJson_HostPortRangeV1Beta1(obj: HostPortRangeV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.RunAsGroupStrategyOptions
 */
export interface RunAsGroupStrategyOptionsV1Beta1 {
    /**
     * (experimental) ranges are the allowed ranges of gids that may be used.
     *
     * If you would like to force a single gid then supply a single range with the same start and end. Required for MustRunAs.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.RunAsGroupStrategyOptions#ranges
     */
    readonly ranges?: IdRangeV1Beta1[];
    /**
     * (experimental) rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.RunAsGroupStrategyOptions#rule
     */
    readonly rule: string;
}
/**
 * Converts an object of type 'RunAsGroupStrategyOptionsV1Beta1' to JSON representation.
 */
export declare function toJson_RunAsGroupStrategyOptionsV1Beta1(obj: RunAsGroupStrategyOptionsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.RunAsUserStrategyOptions
 */
export interface RunAsUserStrategyOptionsV1Beta1 {
    /**
     * (experimental) ranges are the allowed ranges of uids that may be used.
     *
     * If you would like to force a single uid then supply a single range with the same start and end. Required for MustRunAs.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.RunAsUserStrategyOptions#ranges
     */
    readonly ranges?: IdRangeV1Beta1[];
    /**
     * (experimental) rule is the strategy that will dictate the allowable RunAsUser values that may be set.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.RunAsUserStrategyOptions#rule
     */
    readonly rule: string;
}
/**
 * Converts an object of type 'RunAsUserStrategyOptionsV1Beta1' to JSON representation.
 */
export declare function toJson_RunAsUserStrategyOptionsV1Beta1(obj: RunAsUserStrategyOptionsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.RuntimeClassStrategyOptions
 */
export interface RuntimeClassStrategyOptionsV1Beta1 {
    /**
     * (experimental) allowedRuntimeClassNames is an allowlist of RuntimeClass names that may be specified on a pod.
     *
     * A value of "*" means that any RuntimeClass name is allowed, and must be the only item in the list. An empty list requires the RuntimeClassName field to be unset.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.RuntimeClassStrategyOptions#allowedRuntimeClassNames
     */
    readonly allowedRuntimeClassNames: string[];
    /**
     * (experimental) defaultRuntimeClassName is the default RuntimeClassName to set on the pod.
     *
     * The default MUST be allowed by the allowedRuntimeClassNames list. A value of nil does not mutate the Pod.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.RuntimeClassStrategyOptions#defaultRuntimeClassName
     */
    readonly defaultRuntimeClassName?: string;
}
/**
 * Converts an object of type 'RuntimeClassStrategyOptionsV1Beta1' to JSON representation.
 */
export declare function toJson_RuntimeClassStrategyOptionsV1Beta1(obj: RuntimeClassStrategyOptionsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) SELinuxStrategyOptions defines the strategy type and any options used to create the strategy.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.SELinuxStrategyOptions
 */
export interface SeLinuxStrategyOptionsV1Beta1 {
    /**
     * (experimental) rule is the strategy that will dictate the allowable labels that may be set.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.SELinuxStrategyOptions#rule
     */
    readonly rule: string;
    /**
     * (experimental) seLinuxOptions required to run as;
     *
     * required for MustRunAs More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.SELinuxStrategyOptions#seLinuxOptions
     */
    readonly seLinuxOptions?: SeLinuxOptions;
}
/**
 * Converts an object of type 'SeLinuxStrategyOptionsV1Beta1' to JSON representation.
 */
export declare function toJson_SeLinuxStrategyOptionsV1Beta1(obj: SeLinuxStrategyOptionsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.
 *
 * @experimental
 * @schema io.k8s.api.policy.v1beta1.SupplementalGroupsStrategyOptions
 */
export interface SupplementalGroupsStrategyOptionsV1Beta1 {
    /**
     * (experimental) ranges are the allowed ranges of supplemental groups.
     *
     * If you would like to force a single supplemental group then supply a single range with the same start and end. Required for MustRunAs.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.SupplementalGroupsStrategyOptions#ranges
     */
    readonly ranges?: IdRangeV1Beta1[];
    /**
     * (experimental) rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.
     *
     * @experimental
     * @schema io.k8s.api.policy.v1beta1.SupplementalGroupsStrategyOptions#rule
     */
    readonly rule?: string;
}
/**
 * Converts an object of type 'SupplementalGroupsStrategyOptionsV1Beta1' to JSON representation.
 */
export declare function toJson_SupplementalGroupsStrategyOptionsV1Beta1(obj: SupplementalGroupsStrategyOptionsV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenRequest contains parameters of a service account token.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.TokenRequest
 */
export interface TokenRequest {
    /**
     * (experimental) Audience is the intended audience of the token in "TokenRequestSpec".
     *
     * It will default to the audiences of kube apiserver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.TokenRequest#audience
     */
    readonly audience: string;
    /**
     * (experimental) ExpirationSeconds is the duration of validity of the token in "TokenRequestSpec".
     *
     * It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.TokenRequest#expirationSeconds
     */
    readonly expirationSeconds?: number;
}
/**
 * Converts an object of type 'TokenRequest' to JSON representation.
 */
export declare function toJson_TokenRequest(obj: TokenRequest | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSINodeDriver holds information about the specification of one CSI driver installed on a node.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.CSINodeDriver
 */
export interface CsiNodeDriver {
    /**
     * (experimental) allocatable represents the volume resources of a node that are available for scheduling.
     *
     * This field is beta.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINodeDriver#allocatable
     */
    readonly allocatable?: VolumeNodeResources;
    /**
     * (experimental) This is the name of the CSI driver that this object refers to.
     *
     * This MUST be the same name returned by the CSI GetPluginName() call for that driver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINodeDriver#name
     */
    readonly name: string;
    /**
     * (experimental) nodeID of the node from the driver point of view.
     *
     * This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINodeDriver#nodeID
     */
    readonly nodeId: string;
    /**
     * (experimental) topologyKeys is the list of keys supported by the driver.
     *
     * When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.CSINodeDriver#topologyKeys
     */
    readonly topologyKeys?: string[];
}
/**
 * Converts an object of type 'CsiNodeDriver' to JSON representation.
 */
export declare function toJson_CsiNodeDriver(obj: CsiNodeDriver | undefined): Record<string, any> | undefined;
/**
 * (experimental) A topology selector requirement is a selector that matches given label.
 *
 * This is an alpha feature and may change in the future.
 *
 * @experimental
 * @schema io.k8s.api.core.v1.TopologySelectorLabelRequirement
 */
export interface TopologySelectorLabelRequirement {
    /**
     * (experimental) The label key that the selector applies to.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TopologySelectorLabelRequirement#key
     */
    readonly key: string;
    /**
     * (experimental) An array of string values.
     *
     * One value must match the label to be selected. Each entry in Values is ORed.
     *
     * @experimental
     * @schema io.k8s.api.core.v1.TopologySelectorLabelRequirement#values
     */
    readonly values: string[];
}
/**
 * Converts an object of type 'TopologySelectorLabelRequirement' to JSON representation.
 */
export declare function toJson_TopologySelectorLabelRequirement(obj: TopologySelectorLabelRequirement | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentSource represents a volume that should be attached.
 *
 * Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1.VolumeAttachmentSource
 */
export interface VolumeAttachmentSource {
    /**
     * (experimental) inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource.
     *
     * This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachmentSource#inlineVolumeSpec
     */
    readonly inlineVolumeSpec?: PersistentVolumeSpec;
    /**
     * (experimental) Name of the persistent volume to attach.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1.VolumeAttachmentSource#persistentVolumeName
     */
    readonly persistentVolumeName?: string;
}
/**
 * Converts an object of type 'VolumeAttachmentSource' to JSON representation.
 */
export declare function toJson_VolumeAttachmentSource(obj: VolumeAttachmentSource | undefined): Record<string, any> | undefined;
/**
 * (experimental) A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
 */
export interface LabelSelectorRequirement {
    /**
     * (experimental) key is the label key that the selector applies to.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement#key
     */
    readonly key: string;
    /**
     * (experimental) operator represents a key's relationship to a set of values.
     *
     * Valid operators are In, NotIn, Exists and DoesNotExist.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement#operator
     */
    readonly operator: string;
    /**
     * (experimental) values is an array of string values.
     *
     * If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'LabelSelectorRequirement' to JSON representation.
 */
export declare function toJson_LabelSelectorRequirement(obj: LabelSelectorRequirement | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentSource represents a volume that should be attached.
 *
 * Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentSource
 */
export interface VolumeAttachmentSourceV1Alpha1 {
    /**
     * (experimental) inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource.
     *
     * This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and is only honored by servers that enabled the CSIMigration feature.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentSource#inlineVolumeSpec
     */
    readonly inlineVolumeSpec?: PersistentVolumeSpec;
    /**
     * (experimental) Name of the persistent volume to attach.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1alpha1.VolumeAttachmentSource#persistentVolumeName
     */
    readonly persistentVolumeName?: string;
}
/**
 * Converts an object of type 'VolumeAttachmentSourceV1Alpha1' to JSON representation.
 */
export declare function toJson_VolumeAttachmentSourceV1Alpha1(obj: VolumeAttachmentSourceV1Alpha1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) TokenRequest contains parameters of a service account token.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.TokenRequest
 */
export interface TokenRequestV1Beta1 {
    /**
     * (experimental) Audience is the intended audience of the token in "TokenRequestSpec".
     *
     * It will default to the audiences of kube apiserver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.TokenRequest#audience
     */
    readonly audience: string;
    /**
     * (experimental) ExpirationSeconds is the duration of validity of the token in "TokenRequestSpec".
     *
     * It has the same default value of "ExpirationSeconds" in "TokenRequestSpec"
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.TokenRequest#expirationSeconds
     */
    readonly expirationSeconds?: number;
}
/**
 * Converts an object of type 'TokenRequestV1Beta1' to JSON representation.
 */
export declare function toJson_TokenRequestV1Beta1(obj: TokenRequestV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CSINodeDriver holds information about the specification of one CSI driver installed on a node.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.CSINodeDriver
 */
export interface CsiNodeDriverV1Beta1 {
    /**
     * (experimental) allocatable represents the volume resources of a node that are available for scheduling.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINodeDriver#allocatable
     */
    readonly allocatable?: VolumeNodeResourcesV1Beta1;
    /**
     * (experimental) This is the name of the CSI driver that this object refers to.
     *
     * This MUST be the same name returned by the CSI GetPluginName() call for that driver.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINodeDriver#name
     */
    readonly name: string;
    /**
     * (experimental) nodeID of the node from the driver point of view.
     *
     * This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINodeDriver#nodeID
     */
    readonly nodeId: string;
    /**
     * (experimental) topologyKeys is the list of keys supported by the driver.
     *
     * When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.CSINodeDriver#topologyKeys
     */
    readonly topologyKeys?: string[];
}
/**
 * Converts an object of type 'CsiNodeDriverV1Beta1' to JSON representation.
 */
export declare function toJson_CsiNodeDriverV1Beta1(obj: CsiNodeDriverV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) VolumeAttachmentSource represents a volume that should be attached.
 *
 * Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
 *
 * @experimental
 * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentSource
 */
export interface VolumeAttachmentSourceV1Beta1 {
    /**
     * (experimental) inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource.
     *
     * This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentSource#inlineVolumeSpec
     */
    readonly inlineVolumeSpec?: PersistentVolumeSpec;
    /**
     * (experimental) Name of the persistent volume to attach.
     *
     * @experimental
     * @schema io.k8s.api.storage.v1beta1.VolumeAttachmentSource#persistentVolumeName
     */
    readonly persistentVolumeName?: string;
}
/**
 * Converts an object of type 'VolumeAttachmentSourceV1Beta1' to JSON representation.
 */
export declare function toJson_VolumeAttachmentSourceV1Beta1(obj: VolumeAttachmentSourceV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceConversion describes how to convert different versions of a CR.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion
 */
export interface CustomResourceConversion {
    /**
     * (experimental) strategy specifies how custom resources are converted between versions.
     *
     * Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information
     * is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion#strategy
     */
    readonly strategy: string;
    /**
     * (experimental) webhook describes how to call the conversion webhook.
     *
     * Required when `strategy` is set to `Webhook`.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion#webhook
     */
    readonly webhook?: WebhookConversion;
}
/**
 * Converts an object of type 'CustomResourceConversion' to JSON representation.
 */
export declare function toJson_CustomResourceConversion(obj: CustomResourceConversion | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames
 */
export interface CustomResourceDefinitionNames {
    /**
     * (experimental) categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#categories
     */
    readonly categories?: string[];
    /**
     * (experimental) kind is the serialized kind of the resource.
     *
     * It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#kind
     */
    readonly kind: string;
    /**
     * (experimental) listKind is the serialized kind of the list for this resource.
     *
     * Defaults to "`kind`List".
     *
     * @default kind`List".
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#listKind
     */
    readonly listKind?: string;
    /**
     * (experimental) plural is the plural name of the resource to serve.
     *
     * The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#plural
     */
    readonly plural: string;
    /**
     * (experimental) shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`.
     *
     * It must be all lowercase.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#shortNames
     */
    readonly shortNames?: string[];
    /**
     * (experimental) singular is the singular name of the resource.
     *
     * It must be all lowercase. Defaults to lowercased `kind`.
     *
     * @default lowercased `kind`.
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames#singular
     */
    readonly singular?: string;
}
/**
 * Converts an object of type 'CustomResourceDefinitionNames' to JSON representation.
 */
export declare function toJson_CustomResourceDefinitionNames(obj: CustomResourceDefinitionNames | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionVersion describes a version for CRD.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion
 */
export interface CustomResourceDefinitionVersion {
    /**
     * (experimental) additionalPrinterColumns specifies additional columns returned in Table output.
     *
     * See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#additionalPrinterColumns
     */
    readonly additionalPrinterColumns?: CustomResourceColumnDefinition[];
    /**
     * (experimental) deprecated indicates this version of the custom resource API is deprecated.
     *
     * When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#deprecated
     */
    readonly deprecated?: boolean;
    /**
     * (experimental) deprecationWarning overrides the default warning returned to API clients.
     *
     * May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#deprecationWarning
     */
    readonly deprecationWarning?: string;
    /**
     * (experimental) name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#name
     */
    readonly name: string;
    /**
     * (experimental) schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#schema
     */
    readonly schema?: CustomResourceValidation;
    /**
     * (experimental) served is a flag enabling/disabling this version from being served via REST APIs.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#served
     */
    readonly served: boolean;
    /**
     * (experimental) storage indicates this version should be used when persisting custom resources to storage.
     *
     * There must be exactly one version with storage=true.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#storage
     */
    readonly storage: boolean;
    /**
     * (experimental) subresources specify what subresources this version of the defined custom resource have.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion#subresources
     */
    readonly subresources?: CustomResourceSubresources;
}
/**
 * Converts an object of type 'CustomResourceDefinitionVersion' to JSON representation.
 */
export declare function toJson_CustomResourceDefinitionVersion(obj: CustomResourceDefinitionVersion | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceColumnDefinition specifies a column for server side printing.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition
 */
export interface CustomResourceColumnDefinitionV1Beta1 {
    /**
     * (experimental) JSONPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#JSONPath
     */
    readonly jsonPath: string;
    /**
     * (experimental) description is a human readable description of this column.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#description
     */
    readonly description?: string;
    /**
     * (experimental) format is an optional OpenAPI type definition for this column.
     *
     * The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#format
     */
    readonly format?: string;
    /**
     * (experimental) name is a human readable name for the column.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#name
     */
    readonly name: string;
    /**
     * (experimental) priority is an integer defining the relative importance of this column compared to others.
     *
     * Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#priority
     */
    readonly priority?: number;
    /**
     * (experimental) type is an OpenAPI type definition for this column.
     *
     * See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CustomResourceColumnDefinitionV1Beta1' to JSON representation.
 */
export declare function toJson_CustomResourceColumnDefinitionV1Beta1(obj: CustomResourceColumnDefinitionV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceConversion describes how to convert different versions of a CR.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion
 */
export interface CustomResourceConversionV1Beta1 {
    /**
     * (experimental) conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects.
     *
     * The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Defaults to `["v1beta1"]`.
     *
     * @default v1beta1"]`.
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion#conversionReviewVersions
     */
    readonly conversionReviewVersions?: string[];
    /**
     * (experimental) strategy specifies how custom resources are converted between versions.
     *
     * Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information
     * is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhookClientConfig to be set.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion#strategy
     */
    readonly strategy: string;
    /**
     * (experimental) webhookClientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
     *
     * Required when `strategy` is set to `Webhook`.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion#webhookClientConfig
     */
    readonly webhookClientConfig?: WebhookClientConfigV1Beta1;
}
/**
 * Converts an object of type 'CustomResourceConversionV1Beta1' to JSON representation.
 */
export declare function toJson_CustomResourceConversionV1Beta1(obj: CustomResourceConversionV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames
 */
export interface CustomResourceDefinitionNamesV1Beta1 {
    /**
     * (experimental) categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#categories
     */
    readonly categories?: string[];
    /**
     * (experimental) kind is the serialized kind of the resource.
     *
     * It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#kind
     */
    readonly kind: string;
    /**
     * (experimental) listKind is the serialized kind of the list for this resource.
     *
     * Defaults to "`kind`List".
     *
     * @default kind`List".
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#listKind
     */
    readonly listKind?: string;
    /**
     * (experimental) plural is the plural name of the resource to serve.
     *
     * The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#plural
     */
    readonly plural: string;
    /**
     * (experimental) shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`.
     *
     * It must be all lowercase.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#shortNames
     */
    readonly shortNames?: string[];
    /**
     * (experimental) singular is the singular name of the resource.
     *
     * It must be all lowercase. Defaults to lowercased `kind`.
     *
     * @default lowercased `kind`.
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#singular
     */
    readonly singular?: string;
}
/**
 * Converts an object of type 'CustomResourceDefinitionNamesV1Beta1' to JSON representation.
 */
export declare function toJson_CustomResourceDefinitionNamesV1Beta1(obj: CustomResourceDefinitionNamesV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceSubresources defines the status and scale subresources for CustomResources.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresources
 */
export interface CustomResourceSubresourcesV1Beta1 {
    /**
     * (experimental) scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresources#scale
     */
    readonly scale?: CustomResourceSubresourceScaleV1Beta1;
    /**
     * (experimental) status indicates the custom resource should serve a `/status` subresource.
     *
     * When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresources#status
     */
    readonly status?: any;
}
/**
 * Converts an object of type 'CustomResourceSubresourcesV1Beta1' to JSON representation.
 */
export declare function toJson_CustomResourceSubresourcesV1Beta1(obj: CustomResourceSubresourcesV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceValidation is a list of validation methods for CustomResources.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceValidation
 */
export interface CustomResourceValidationV1Beta1 {
    /**
     * (experimental) openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceValidation#openAPIV3Schema
     */
    readonly openApiv3Schema?: JsonSchemaPropsV1Beta1;
}
/**
 * Converts an object of type 'CustomResourceValidationV1Beta1' to JSON representation.
 */
export declare function toJson_CustomResourceValidationV1Beta1(obj: CustomResourceValidationV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) CustomResourceDefinitionVersion describes a version for CRD.
 *
 * @experimental
 * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion
 */
export interface CustomResourceDefinitionVersionV1Beta1 {
    /**
     * (experimental) additionalPrinterColumns specifies additional columns returned in Table output.
     *
     * See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead). If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#additionalPrinterColumns
     */
    readonly additionalPrinterColumns?: CustomResourceColumnDefinitionV1Beta1[];
    /**
     * (experimental) deprecated indicates this version of the custom resource API is deprecated.
     *
     * When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
     *
     * @default false.
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#deprecated
     */
    readonly deprecated?: boolean;
    /**
     * (experimental) deprecationWarning overrides the default warning returned to API clients.
     *
     * May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#deprecationWarning
     */
    readonly deprecationWarning?: string;
    /**
     * (experimental) name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#name
     */
    readonly name: string;
    /**
     * (experimental) schema describes the schema used for validation and pruning of this version of the custom resource.
     *
     * Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead).
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#schema
     */
    readonly schema?: CustomResourceValidationV1Beta1;
    /**
     * (experimental) served is a flag enabling/disabling this version from being served via REST APIs.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#served
     */
    readonly served: boolean;
    /**
     * (experimental) storage indicates this version should be used when persisting custom resources to storage.
     *
     * There must be exactly one version with storage=true.
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#storage
     */
    readonly storage: boolean;
    /**
     * (experimental) subresources specify what subresources this version of the defined custom resource have.
     *
     * Top-level and per-version subresources are mutually exclusive. Per-version subresources must not all be set to identical values (top-level subresources should be used instead).
     *
     * @experimental
     * @schema io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#subresources
     */
    readonly subresources?: CustomResourceSubresourcesV1Beta1;
}
/**
 * Converts an object of type 'CustomResourceDefinitionVersionV1Beta1' to JSON representation.
 */
export declare function toJson_CustomResourceDefinitionVersionV1Beta1(obj: CustomResourceDefinitionVersionV1Beta1 | undefined): Record<string, any> | undefined;
/**
 * (experimental) StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.
 *
 * @experimental
 * @schema io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause
 */
export interface StatusCause {
    /**
     * (experimental) The field of the resource that has caused this error, as named by its JSON serialization.
     *
     * May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.
     *
     * Examples:
     * "name" - the field "name" on the current resource
     * "items[0].name" - the field "name" on the first array entry in "items"
     *
     * @experimental
     * @schema io.k8s.apimachinery.pkg.apis.meta.v1.S