/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.overlay.OverlayTextChecker;
import com.adobe.epubcheck.overlay.SmilClock;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.vocab.AggregateVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.adobe.epubcheck.vocab.VocabUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OverlayHandler
implements XMLHandler {
    private static Map<String, Vocab> RESERVED_VOCABS = ImmutableMap.of((Object)"", (Object)AggregateVocab.of(StructureVocab.VOCAB, StructureVocab.UNCHECKED_VOCAB));
    private static Map<String, Vocab> KNOWN_VOCAB_URIS = ImmutableMap.of();
    private static Set<String> DEFAULT_VOCAB_URIS = ImmutableSet.of((Object)"http://www.idpf.org/epub/vocab/structure/#");
    private final ValidationContext context;
    private final String path;
    private final Report report;
    private final XMLParser parser;
    private boolean checkedUnsupportedXMLVersion;
    private Map<String, Vocab> vocabs = RESERVED_VOCABS;
    private Set<String> resourceRefs = new HashSet<String>();
    private final Set<PackageVocabs.ITEM_PROPERTIES> requiredProperties = EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class);

    public OverlayHandler(ValidationContext context, XMLParser parser) {
        this.context = context;
        this.path = context.path;
        this.report = context.report;
        this.parser = parser;
        this.checkedUnsupportedXMLVersion = false;
    }

    @Override
    public void startElement() {
        String name;
        if (!this.checkedUnsupportedXMLVersion) {
            HandlerUtil.checkXMLVersion(this.parser);
            this.checkedUnsupportedXMLVersion = true;
        }
        XMLElement e = this.parser.getCurrentElement();
        switch (name = e.getName()) {
            case "smil": {
                this.vocabs = VocabUtil.parsePrefixDeclaration(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), RESERVED_VOCABS, KNOWN_VOCAB_URIS, DEFAULT_VOCAB_URIS, this.report, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
                break;
            }
            case "body": 
            case "seq": 
            case "par": {
                this.processGlobalAttrs(e);
                break;
            }
            case "text": {
                this.processTextSrc(e);
                break;
            }
            case "audio": {
                this.processAudioSrc(e);
                this.checkTime(e.getAttribute("clipBegin"), e.getAttribute("clipEnd"));
            }
        }
    }

    private void checkTime(String clipBegin, String clipEnd) {
        SmilClock end;
        SmilClock start;
        if (clipEnd == null) {
            return;
        }
        if (clipBegin == null) {
            clipBegin = "0";
        }
        try {
            start = new SmilClock(clipBegin);
            end = new SmilClock(clipEnd);
        }
        catch (Exception ex) {
            return;
        }
        if (start.compareTo(end) == 1) {
            this.report.message(MessageId.MED_008, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
        } else if (start.equals(end)) {
            this.report.message(MessageId.MED_009, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
        }
    }

    private void checkType(String type) {
        Set<Property> propList = VocabUtil.parsePropertyList(type, this.vocabs, this.context, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()));
        for (Property property : propList) {
            if (!"http://www.idpf.org/epub/vocab/structure/#".equals(property.getVocabURI())) continue;
            try {
                property.toEnum();
            }
            catch (UnsupportedOperationException ex) {
                this.report.message(MessageId.OPF_088, this.parser.getLocation(), property.getName());
            }
        }
    }

    private void processTextSrc(XMLElement e) {
        String src = e.getAttribute("src");
        this.processRef(src, XRefChecker.Type.HYPERLINK);
        String resolvedSrc = PathUtil.resolveRelativeReference(this.path, src);
        if (this.context.xrefChecker.isPresent()) {
            ((XRefChecker)this.context.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), resolvedSrc, XRefChecker.Type.OVERLAY_TEXT_LINK);
        }
    }

    private void processAudioSrc(XMLElement e) {
        String src = e.getAttribute("src");
        this.processRef(src, XRefChecker.Type.AUDIO);
        if (src != null && PathUtil.isRemote(src)) {
            this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
        }
    }

    private void processRef(String ref, XRefChecker.Type type) {
        if (ref != null && this.context.xrefChecker.isPresent()) {
            ref = PathUtil.resolveRelativeReference(this.path, ref);
            if (type == XRefChecker.Type.AUDIO) {
                String mimeType = ((XRefChecker)this.context.xrefChecker.get()).getMimeType(ref);
                if (mimeType != null && !OPFChecker30.isBlessedAudioType(mimeType)) {
                    this.report.message(MessageId.MED_005, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), ref, mimeType);
                }
            } else {
                this.checkFragment(ref);
                String uniqueResource = PathUtil.removeFragment(ref);
                if (!Strings.isNullOrEmpty((String)uniqueResource) && !((OverlayTextChecker)this.context.overlayTextChecker.get()).add(uniqueResource, ((OPFItem)this.context.opfItem.get()).getId())) {
                    this.report.message(MessageId.MED_011, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), ref);
                }
            }
            ((XRefChecker)this.context.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ref, type);
        }
    }

    private void processGlobalAttrs(XMLElement e) {
        if (!e.getName().equals("audio")) {
            this.processRef(e.getAttributeNS("http://www.idpf.org/2007/ops", "textref"), XRefChecker.Type.HYPERLINK);
        }
        this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void endElement() {
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if (name.equals("smil")) {
            this.checkItemReferences();
            this.checkProperties();
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    private void checkItemReferences() {
        if (this.resourceRefs.isEmpty()) {
            return;
        }
    }

    private void checkFragment(String ref) {
        String frag = PathUtil.getFragment(ref.trim());
        if (ref.indexOf("#") == -1 || Strings.isNullOrEmpty((String)frag)) {
            this.report.message(MessageId.MED_014, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
        }
    }

    protected void checkProperties() {
        if (!this.context.ocf.isPresent()) {
            return;
        }
        Set<PackageVocabs.ITEM_PROPERTIES> itemProps = Property.filter(this.context.properties, PackageVocabs.ITEM_PROPERTIES.class);
        for (PackageVocabs.ITEM_PROPERTIES requiredProperty : Sets.difference(this.requiredProperties, itemProps)) {
            this.report.message(MessageId.OPF_014, EPUBLocation.create(this.path), PackageVocabs.ITEM_VOCAB.getName(requiredProperty));
        }
    }
}

