/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.XmlDocParser;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.epubpackage.MetadataElement;
import com.adobe.epubcheck.ctc.epubpackage.PackageManifest;
import com.adobe.epubcheck.ctc.epubpackage.PackageSpine;
import com.adobe.epubcheck.ctc.epubpackage.SpineItem;
import com.adobe.epubcheck.util.EPUBVersion;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PackageReader {
    private static final String containerEntry = "META-INF/container.xml";
    private ZipFile zip;
    private Report report;
    private String version;
    private EpubPackage epack;
    private String mainPackageFile;

    public PackageReader(ZipFile zip, Report report) {
        this.zip = zip;
        this.report = report;
    }

    public EpubPackage readPackageData() {
        Vector<String> pathToRootFile = this.getPathToRootFile();
        XmlDocParser p = new XmlDocParser(this.zip, this.report);
        for (String path : pathToRootFile) {
            this.setMainPackageFile(path);
            Document doc = p.parseDocument(path);
            if (doc == null) continue;
            this.epack = new EpubPackage(path, this.zip, doc);
            this.epack.setPackageMainFile(this.getMainPackageFile());
            this.epack.setVersion(this.getEpubVersion(doc));
            this.getMetadata(doc, this.epack);
            this.getManifest(doc, this.epack);
            this.getSpine(doc, this.epack);
        }
        return this.epack;
    }

    String getMainPackageFile() {
        return this.mainPackageFile;
    }

    void setMainPackageFile(String mainPackageFile) {
        this.mainPackageFile = mainPackageFile;
    }

    private Vector<String> getPathToRootFile() {
        Vector<String> rootFiles = new Vector<String>();
        XmlDocParser p = new XmlDocParser(this.zip, this.report);
        Document doc = p.parseDocument(containerEntry);
        if (doc != null) {
            NodeList nList = doc.getElementsByTagName("rootfiles");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node n = nList.item(i);
                if (n.getNodeName().compareToIgnoreCase("rootfiles") != 0) continue;
                NodeList cn = n.getChildNodes();
                for (int j = 0; j < cn.getLength(); ++j) {
                    NamedNodeMap attr;
                    Node path;
                    Node currentNode = cn.item(j);
                    if (currentNode.getNodeName().compareToIgnoreCase("rootfile") != 0 || (path = (attr = currentNode.getAttributes()).getNamedItem("full-path")) == null || path.getNodeValue().isEmpty()) continue;
                    String nodeValue = path.getNodeValue();
                    rootFiles.add(nodeValue);
                }
            }
        }
        return rootFiles;
    }

    private void getMetadata(Document doc, EpubPackage epack) {
        NodeList nList = doc.getElementsByTagNameNS("http://www.idpf.org/2007/opf", "metadata");
        if (nList.getLength() > 0) {
            Node metadata = nList.item(0);
            NodeList metaNodes = metadata.getChildNodes();
            for (int i = 0; i < metaNodes.getLength(); ++i) {
                String nodeName = metaNodes.item(i).getLocalName();
                if (nodeName == null || nodeName.startsWith("#")) continue;
                MetadataElement meta = new MetadataElement();
                Node n = metaNodes.item(i);
                meta.setName(n.getNodeName());
                if (n.hasChildNodes()) {
                    meta.setValue(n.getFirstChild().getNodeValue());
                } else {
                    meta.setValue(n.getNodeValue());
                }
                NamedNodeMap attrs = metaNodes.item(i).getAttributes();
                for (int a = 0; a < attrs.getLength(); ++a) {
                    if (attrs.item(a).getNodeName().compareToIgnoreCase("elementLineNumber") == 0 || attrs.item(a).getNodeName().compareToIgnoreCase("elementColumnNumber") == 0) continue;
                    meta.addAttribute(attrs.item(a).getNodeName(), attrs.item(a).getNodeValue());
                }
                epack.getMetadata().addMetaElement(meta);
            }
        }
    }

    private void getManifest(Document doc, EpubPackage epack) {
        NodeList nList = doc.getElementsByTagNameNS("http://www.idpf.org/2007/opf", "manifest");
        for (int i = 0; i < nList.getLength(); ++i) {
            Node n = nList.item(i);
            String ln = n.getLocalName();
            if (ln.compareToIgnoreCase("manifest") != 0) continue;
            PackageManifest manifest = new PackageManifest();
            epack.setManifest(manifest);
            NodeList cn = n.getChildNodes();
            for (int j = 0; j < cn.getLength(); ++j) {
                Node idNode;
                Node propertiesNode;
                Node mediaTypeNode;
                Node currentNode = cn.item(j);
                String childName = currentNode.getLocalName();
                if (childName == null || childName.compareToIgnoreCase("item") != 0) continue;
                ManifestItem item = new ManifestItem();
                NamedNodeMap attr = currentNode.getAttributes();
                Node hrefNode = attr.getNamedItem("href");
                if (hrefNode != null) {
                    String hrefValue = hrefNode.getNodeValue();
                    item.setHref(hrefValue);
                }
                if ((mediaTypeNode = attr.getNamedItem("media-type")) != null) {
                    String mediaTypeValue = mediaTypeNode.getNodeValue();
                    item.setMediaType(mediaTypeValue);
                }
                if ((propertiesNode = attr.getNamedItem("properties")) != null) {
                    String propertiesValue = propertiesNode.getNodeValue();
                    item.setProperties(propertiesValue);
                }
                if ((idNode = attr.getNamedItem("id")) != null) {
                    String idValue = idNode.getNodeValue();
                    item.setId(idValue);
                }
                manifest.addItem(item);
            }
        }
    }

    private void getSpine(Document doc, EpubPackage epack) {
        NodeList nList = doc.getElementsByTagNameNS("http://www.idpf.org/2007/opf", "spine");
        for (int i = 0; i < nList.getLength(); ++i) {
            Node pageProgressionDirectionNode;
            Node tocNode;
            Node n = nList.item(i);
            String ln = n.getLocalName();
            if (ln.compareToIgnoreCase("spine") != 0) continue;
            PackageSpine spine = new PackageSpine();
            epack.setSpine(spine);
            NamedNodeMap spineAttrs = n.getAttributes();
            Node idNode = spineAttrs.getNamedItem("id");
            if (idNode != null) {
                spine.setId(idNode.getNodeValue());
            }
            if ((tocNode = spineAttrs.getNamedItem("toc")) != null) {
                spine.setToc(tocNode.getNodeValue());
            }
            if ((pageProgressionDirectionNode = spineAttrs.getNamedItem("page-progression-direction")) != null) {
                spine.setPageProgressionDirection(pageProgressionDirectionNode.getNodeValue());
            }
            NodeList cn = n.getChildNodes();
            for (int j = 0; j < cn.getLength(); ++j) {
                Node propertiesNode;
                Node linearNode;
                Node idSpineNode;
                Node currentNode = cn.item(j);
                String itemRefName = currentNode.getLocalName();
                if (itemRefName == null || "itemref".compareToIgnoreCase(itemRefName) != 0) continue;
                SpineItem item = new SpineItem();
                NamedNodeMap attr = currentNode.getAttributes();
                Node idrefNode = attr.getNamedItem("idref");
                if (idrefNode != null) {
                    String idRef = idrefNode.getNodeValue();
                    if (idRef == null || idRef.length() <= 0) continue;
                    item.setIdref(idrefNode.getNodeValue());
                }
                if ((idSpineNode = attr.getNamedItem("id")) != null) {
                    item.setId(idSpineNode.getNodeValue());
                }
                if ((linearNode = attr.getNamedItem("linear")) != null) {
                    item.setLinear(linearNode.getNodeValue());
                }
                if ((propertiesNode = attr.getNamedItem("properties")) != null) {
                    item.setProperties(propertiesNode.getNodeValue());
                }
                spine.addItem(item);
            }
        }
    }

    private EPUBVersion getEpubVersion(Document doc) {
        NodeList packageNode = doc.getElementsByTagNameNS("http://www.idpf.org/2007/opf", "package");
        if (packageNode == null) {
            return EPUBVersion.Unknown;
        }
        Node firstItem = packageNode.item(0);
        if (firstItem == null) {
            return EPUBVersion.Unknown;
        }
        NamedNodeMap packageNodeAttr = firstItem.getAttributes();
        if (packageNodeAttr == null) {
            return EPUBVersion.Unknown;
        }
        Node node = packageNodeAttr.getNamedItem("version");
        if (node != null) {
            this.version = node.getNodeValue();
        }
        if (this.version != null && this.version.startsWith("3")) {
            return EPUBVersion.VERSION_3;
        }
        if (this.version != null && this.version.startsWith("2")) {
            return EPUBVersion.VERSION_2;
        }
        return EPUBVersion.Unknown;
    }
}

