#!/usr/bin/env python
# encoding: utf-8
"""
Predictor.py

Created by Wim Vranken on 1st May 2020, as wrapper around original Disomine code
Note that the original DisoMine code was upgraded to Python3.7 and simplified by taking out redundant code for production version
The DisoMine code was also modified to better work in conjunction with the data structures used here.
Copyright (c) 2020- Wim Vranken. All rights reserved.
"""

from b2bTools.general.Io import B2bIo
from b2bTools.nmr.shiftCrypt.shiftCrypt import Standalone

class ShiftCrypt(B2bIo):

  version = '1.0'
  scriptName = "b2bTools.nmr.shiftCrypt.Predictor"
  name = "ShiftCrypt"

  def __init__(self):
    # Additional info for writing files
    self.references = ['doi: 10.1038/s41467-019-10322-w', 'doi: 10.1093/nar/gkaa391']
    self.infoTexts = ['Generated by ShiftCrypt', 'See http://bio2byte.be']

    self.informationPerPredictor = {
      self.name: {
        'references': self.references,
        'info':       ";".join(self.infoTexts),
        'version':    self.version,
        'origin':     self.scriptName
      }
    }

  def predictShifts(self, proteinShifts, modelClass='2'):

    """
    :param proteinShifts: Shift information for a protein
    """

    shiftCrypt = Standalone()

    # TODO: Should here test which model is best suited!

    shiftCrypt.loadModel(modelClass, None)

    encryptedValues = shiftCrypt.encryptProteinShifts(proteinShifts)
    shiftCryptResults = shiftCrypt.organiseData(encryptedValues,proteinShifts)

    if not shiftCryptResults:
      print("ShiftCrypt failed....")

    return shiftCryptResults
