# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['ded']
install_requires = \
['ruamel.yaml>=0.16.10,<0.17.0']

entry_points = \
{'console_scripts': ['ded = ded:run']}

setup_kwargs = {
    'name': 'ded',
    'version': '0.1.4',
    'description': 'Helm dependency deduplication post-renderer',
    'long_description': '# ded\n\n<center><img src="grumpy.png" alt="Grumpy Ded"/></center>\n<center>Helm dependency deduplication post-renderer</center>\n\n## Installation\n\n```shell\npip install ded\n```\n\n## Usage\n\nThis program collects all pre-rendered manifests from Helm and post-renders only those unique amongst them.\n\nThe uniqueness is determined based on the default or supplied YAML keys. The keys must exist in all of the supplied documents.\n\nInvoke as `--post-renderer` during helm install/upgrade.\n\n`ded` determines uniquiness based on values of the `kind` and `metadata.name` fields of each manifests. You can specify non-default keys by which the pre-rendered manifests from helm must be deduplicated:\n\n```shell\n  ded --key metadata.namespace\n```\n\n**IMPORTANT**: The keys used to determine uniquiness must be present in every manifest or `ded` will exit with code 1 and `helm install` or `helm upgrade` will consequently fail.\n\n## Examples\n\nThe example below will filter all manifests based on values of `kind` and `metadata.name` fields.\n\n```shell\nhelm install release-name your-chart/ --post-renderer ded\n```\n\nSo, if there are 2 manifests in your Helm chart release with the same values on these fields, then only one of them will be left.\n\nManifest A:\n\n```Yaml\napiVersion: v1\nkind: ConfigMap\nmetadata:\n  name: foo-cm\ndata:\n  onedata: test\n```\n\nManifest B:\n\n```yaml\napiVersion: v1\nkind: ConfigMap\nmetadata:\n  name: foo-cm\ndata:\n  twodata: test-test\n```\n\nIn the example above only the first occuring manifest will make it to the output of the post-renderer.\n\nOr invoke with a different set of keys:\n\n```shell\nhelm install release-name your-chart/ --post-renderer ded --key metadata.name\n```\n\nMore keys:\n\n```shell\nhelm install release-name your-chart/ --post-renderer ded -k metadata.name --k data.onedata\n```\n\n## Why `ded`?\n\n1. Because it\'s a shorthand for `deduplication`\n2. Because *"ded"* means grandpa in *Russian*. And I was grumpy as hell when I was trying to deduplicate manifests generated by Helm.\n3. Because dealing with subcharts and dependencies in Helm makes you a little *dead* inside.\n\nHelm is ❤️\n',
    'author': 'vduseev',
    'author_email': 'vagiz.d@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vduseev/ded',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
