# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SyntheticMonitoringInstallationArgs', 'SyntheticMonitoringInstallation']

@pulumi.input_type
class SyntheticMonitoringInstallationArgs:
    def __init__(__self__, *,
                 logs_instance_id: pulumi.Input[int],
                 metrics_instance_id: pulumi.Input[int],
                 metrics_publisher_key: pulumi.Input[str],
                 stack_id: pulumi.Input[int]):
        """
        The set of arguments for constructing a SyntheticMonitoringInstallation resource.
        :param pulumi.Input[int] logs_instance_id: The ID of the logs instance to install SM on (stack's `logs_user_id` attribute).
        :param pulumi.Input[int] metrics_instance_id: The ID of the metrics instance to install SM on (stack's `prometheus_user_id` attribute).
        :param pulumi.Input[str] metrics_publisher_key: The Cloud API Key with the `MetricsPublisher` role used to publish metrics to the SM API
        :param pulumi.Input[int] stack_id: The ID of the stack to install SM on.
        """
        pulumi.set(__self__, "logs_instance_id", logs_instance_id)
        pulumi.set(__self__, "metrics_instance_id", metrics_instance_id)
        pulumi.set(__self__, "metrics_publisher_key", metrics_publisher_key)
        pulumi.set(__self__, "stack_id", stack_id)

    @property
    @pulumi.getter(name="logsInstanceId")
    def logs_instance_id(self) -> pulumi.Input[int]:
        """
        The ID of the logs instance to install SM on (stack's `logs_user_id` attribute).
        """
        return pulumi.get(self, "logs_instance_id")

    @logs_instance_id.setter
    def logs_instance_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "logs_instance_id", value)

    @property
    @pulumi.getter(name="metricsInstanceId")
    def metrics_instance_id(self) -> pulumi.Input[int]:
        """
        The ID of the metrics instance to install SM on (stack's `prometheus_user_id` attribute).
        """
        return pulumi.get(self, "metrics_instance_id")

    @metrics_instance_id.setter
    def metrics_instance_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "metrics_instance_id", value)

    @property
    @pulumi.getter(name="metricsPublisherKey")
    def metrics_publisher_key(self) -> pulumi.Input[str]:
        """
        The Cloud API Key with the `MetricsPublisher` role used to publish metrics to the SM API
        """
        return pulumi.get(self, "metrics_publisher_key")

    @metrics_publisher_key.setter
    def metrics_publisher_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "metrics_publisher_key", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[int]:
        """
        The ID of the stack to install SM on.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "stack_id", value)


@pulumi.input_type
class _SyntheticMonitoringInstallationState:
    def __init__(__self__, *,
                 logs_instance_id: Optional[pulumi.Input[int]] = None,
                 metrics_instance_id: Optional[pulumi.Input[int]] = None,
                 metrics_publisher_key: Optional[pulumi.Input[str]] = None,
                 sm_access_token: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SyntheticMonitoringInstallation resources.
        :param pulumi.Input[int] logs_instance_id: The ID of the logs instance to install SM on (stack's `logs_user_id` attribute).
        :param pulumi.Input[int] metrics_instance_id: The ID of the metrics instance to install SM on (stack's `prometheus_user_id` attribute).
        :param pulumi.Input[str] metrics_publisher_key: The Cloud API Key with the `MetricsPublisher` role used to publish metrics to the SM API
        :param pulumi.Input[str] sm_access_token: Generated token to access the SM API.
        :param pulumi.Input[int] stack_id: The ID of the stack to install SM on.
        """
        if logs_instance_id is not None:
            pulumi.set(__self__, "logs_instance_id", logs_instance_id)
        if metrics_instance_id is not None:
            pulumi.set(__self__, "metrics_instance_id", metrics_instance_id)
        if metrics_publisher_key is not None:
            pulumi.set(__self__, "metrics_publisher_key", metrics_publisher_key)
        if sm_access_token is not None:
            pulumi.set(__self__, "sm_access_token", sm_access_token)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)

    @property
    @pulumi.getter(name="logsInstanceId")
    def logs_instance_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the logs instance to install SM on (stack's `logs_user_id` attribute).
        """
        return pulumi.get(self, "logs_instance_id")

    @logs_instance_id.setter
    def logs_instance_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "logs_instance_id", value)

    @property
    @pulumi.getter(name="metricsInstanceId")
    def metrics_instance_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the metrics instance to install SM on (stack's `prometheus_user_id` attribute).
        """
        return pulumi.get(self, "metrics_instance_id")

    @metrics_instance_id.setter
    def metrics_instance_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "metrics_instance_id", value)

    @property
    @pulumi.getter(name="metricsPublisherKey")
    def metrics_publisher_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud API Key with the `MetricsPublisher` role used to publish metrics to the SM API
        """
        return pulumi.get(self, "metrics_publisher_key")

    @metrics_publisher_key.setter
    def metrics_publisher_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics_publisher_key", value)

    @property
    @pulumi.getter(name="smAccessToken")
    def sm_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Generated token to access the SM API.
        """
        return pulumi.get(self, "sm_access_token")

    @sm_access_token.setter
    def sm_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sm_access_token", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the stack to install SM on.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stack_id", value)


class SyntheticMonitoringInstallation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logs_instance_id: Optional[pulumi.Input[int]] = None,
                 metrics_instance_id: Optional[pulumi.Input[int]] = None,
                 metrics_publisher_key: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Sets up Synthetic Monitoring on a Grafana cloud stack and generates a token.
        Once a Grafana Cloud stack is created, a user can either use this resource or go into the UI to install synthetic monitoring.
        This resource cannot be imported but it can be used on an existing Synthetic Monitoring installation without issues.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/synthetic-monitoring/installation/)
        * [API documentation](https://github.com/grafana/synthetic-monitoring-api-go-client/blob/main/docs/API.md#apiv1registerinstall)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        sm_stack_cloud_stack = grafana.CloudStack("smStackCloudStack",
            slug="<stack-slug>",
            region_slug="us")
        metrics_publish = grafana.CloudApiKey("metricsPublish",
            role="MetricsPublisher",
            cloud_org_slug="<org-slug>")
        sm_stack_synthetic_monitoring_installation = grafana.SyntheticMonitoringInstallation("smStackSyntheticMonitoringInstallation",
            stack_id=sm_stack_cloud_stack.id,
            metrics_instance_id=sm_stack_cloud_stack.prometheus_user_id,
            logs_instance_id=sm_stack_cloud_stack.logs_user_id,
            metrics_publisher_key=metrics_publish.key)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] logs_instance_id: The ID of the logs instance to install SM on (stack's `logs_user_id` attribute).
        :param pulumi.Input[int] metrics_instance_id: The ID of the metrics instance to install SM on (stack's `prometheus_user_id` attribute).
        :param pulumi.Input[str] metrics_publisher_key: The Cloud API Key with the `MetricsPublisher` role used to publish metrics to the SM API
        :param pulumi.Input[int] stack_id: The ID of the stack to install SM on.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticMonitoringInstallationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sets up Synthetic Monitoring on a Grafana cloud stack and generates a token.
        Once a Grafana Cloud stack is created, a user can either use this resource or go into the UI to install synthetic monitoring.
        This resource cannot be imported but it can be used on an existing Synthetic Monitoring installation without issues.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/synthetic-monitoring/installation/)
        * [API documentation](https://github.com/grafana/synthetic-monitoring-api-go-client/blob/main/docs/API.md#apiv1registerinstall)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        sm_stack_cloud_stack = grafana.CloudStack("smStackCloudStack",
            slug="<stack-slug>",
            region_slug="us")
        metrics_publish = grafana.CloudApiKey("metricsPublish",
            role="MetricsPublisher",
            cloud_org_slug="<org-slug>")
        sm_stack_synthetic_monitoring_installation = grafana.SyntheticMonitoringInstallation("smStackSyntheticMonitoringInstallation",
            stack_id=sm_stack_cloud_stack.id,
            metrics_instance_id=sm_stack_cloud_stack.prometheus_user_id,
            logs_instance_id=sm_stack_cloud_stack.logs_user_id,
            metrics_publisher_key=metrics_publish.key)
        ```

        :param str resource_name: The name of the resource.
        :param SyntheticMonitoringInstallationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticMonitoringInstallationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logs_instance_id: Optional[pulumi.Input[int]] = None,
                 metrics_instance_id: Optional[pulumi.Input[int]] = None,
                 metrics_publisher_key: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticMonitoringInstallationArgs.__new__(SyntheticMonitoringInstallationArgs)

            if logs_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'logs_instance_id'")
            __props__.__dict__["logs_instance_id"] = logs_instance_id
            if metrics_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'metrics_instance_id'")
            __props__.__dict__["metrics_instance_id"] = metrics_instance_id
            if metrics_publisher_key is None and not opts.urn:
                raise TypeError("Missing required property 'metrics_publisher_key'")
            __props__.__dict__["metrics_publisher_key"] = None if metrics_publisher_key is None else pulumi.Output.secret(metrics_publisher_key)
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            __props__.__dict__["sm_access_token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["metricsPublisherKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SyntheticMonitoringInstallation, __self__).__init__(
            'grafana:index/syntheticMonitoringInstallation:SyntheticMonitoringInstallation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            logs_instance_id: Optional[pulumi.Input[int]] = None,
            metrics_instance_id: Optional[pulumi.Input[int]] = None,
            metrics_publisher_key: Optional[pulumi.Input[str]] = None,
            sm_access_token: Optional[pulumi.Input[str]] = None,
            stack_id: Optional[pulumi.Input[int]] = None) -> 'SyntheticMonitoringInstallation':
        """
        Get an existing SyntheticMonitoringInstallation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] logs_instance_id: The ID of the logs instance to install SM on (stack's `logs_user_id` attribute).
        :param pulumi.Input[int] metrics_instance_id: The ID of the metrics instance to install SM on (stack's `prometheus_user_id` attribute).
        :param pulumi.Input[str] metrics_publisher_key: The Cloud API Key with the `MetricsPublisher` role used to publish metrics to the SM API
        :param pulumi.Input[str] sm_access_token: Generated token to access the SM API.
        :param pulumi.Input[int] stack_id: The ID of the stack to install SM on.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticMonitoringInstallationState.__new__(_SyntheticMonitoringInstallationState)

        __props__.__dict__["logs_instance_id"] = logs_instance_id
        __props__.__dict__["metrics_instance_id"] = metrics_instance_id
        __props__.__dict__["metrics_publisher_key"] = metrics_publisher_key
        __props__.__dict__["sm_access_token"] = sm_access_token
        __props__.__dict__["stack_id"] = stack_id
        return SyntheticMonitoringInstallation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="logsInstanceId")
    def logs_instance_id(self) -> pulumi.Output[int]:
        """
        The ID of the logs instance to install SM on (stack's `logs_user_id` attribute).
        """
        return pulumi.get(self, "logs_instance_id")

    @property
    @pulumi.getter(name="metricsInstanceId")
    def metrics_instance_id(self) -> pulumi.Output[int]:
        """
        The ID of the metrics instance to install SM on (stack's `prometheus_user_id` attribute).
        """
        return pulumi.get(self, "metrics_instance_id")

    @property
    @pulumi.getter(name="metricsPublisherKey")
    def metrics_publisher_key(self) -> pulumi.Output[str]:
        """
        The Cloud API Key with the `MetricsPublisher` role used to publish metrics to the SM API
        """
        return pulumi.get(self, "metrics_publisher_key")

    @property
    @pulumi.getter(name="smAccessToken")
    def sm_access_token(self) -> pulumi.Output[str]:
        """
        Generated token to access the SM API.
        """
        return pulumi.get(self, "sm_access_token")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[int]:
        """
        The ID of the stack to install SM on.
        """
        return pulumi.get(self, "stack_id")

