# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDataSourceResult',
    'AwaitableGetDataSourceResult',
    'get_data_source',
    'get_data_source_output',
]

@pulumi.output_type
class GetDataSourceResult:
    """
    A collection of values returned by getDataSource.
    """
    def __init__(__self__, access_mode=None, basic_auth_enabled=None, basic_auth_username=None, database_name=None, id=None, is_default=None, json_data_encoded=None, name=None, type=None, uid=None, url=None, username=None):
        if access_mode and not isinstance(access_mode, str):
            raise TypeError("Expected argument 'access_mode' to be a str")
        pulumi.set(__self__, "access_mode", access_mode)
        if basic_auth_enabled and not isinstance(basic_auth_enabled, bool):
            raise TypeError("Expected argument 'basic_auth_enabled' to be a bool")
        pulumi.set(__self__, "basic_auth_enabled", basic_auth_enabled)
        if basic_auth_username and not isinstance(basic_auth_username, str):
            raise TypeError("Expected argument 'basic_auth_username' to be a str")
        pulumi.set(__self__, "basic_auth_username", basic_auth_username)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if json_data_encoded and not isinstance(json_data_encoded, str):
            raise TypeError("Expected argument 'json_data_encoded' to be a str")
        pulumi.set(__self__, "json_data_encoded", json_data_encoded)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> str:
        """
        The method by which Grafana will access the data source: `proxy` or `direct`.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="basicAuthEnabled")
    def basic_auth_enabled(self) -> bool:
        """
        Whether to enable basic auth for the data source.
        """
        return pulumi.get(self, "basic_auth_enabled")

    @property
    @pulumi.getter(name="basicAuthUsername")
    def basic_auth_username(self) -> str:
        """
        Basic auth username.
        """
        return pulumi.get(self, "basic_auth_username")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        (Required by some data source types) The name of the database to use on the selected data source server.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Whether to set the data source as default. This should only be `true` to a single data source.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="jsonDataEncoded")
    def json_data_encoded(self) -> str:
        """
        Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "json_data_encoded")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The data source type. Must be one of the supported data source keywords.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> str:
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL for the data source. The type of URL required varies depending on the chosen data source type.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Required by some data source types) The username to use to authenticate to the data source.
        """
        return pulumi.get(self, "username")


class AwaitableGetDataSourceResult(GetDataSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourceResult(
            access_mode=self.access_mode,
            basic_auth_enabled=self.basic_auth_enabled,
            basic_auth_username=self.basic_auth_username,
            database_name=self.database_name,
            id=self.id,
            is_default=self.is_default,
            json_data_encoded=self.json_data_encoded,
            name=self.name,
            type=self.type,
            uid=self.uid,
            url=self.url,
            username=self.username)


def get_data_source(id: Optional[str] = None,
                    name: Optional[str] = None,
                    uid: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourceResult:
    """
    Get details about a Grafana Datasource querying by either name, uid or ID

    ## Example Usage

    ```python
    import pulumi
    import json
    import lbrlabs_pulumi_grafana as grafana
    import pulumi_grafana as grafana

    prometheus = grafana.DataSource("prometheus",
        type="prometheus",
        uid="prometheus-ds-test-uid",
        url="https://my-instance.com",
        basic_auth_enabled=True,
        basic_auth_username="username",
        json_data_encoded=json.dumps({
            "httpMethod": "POST",
            "prometheusType": "Mimir",
            "prometheusVersion": "2.4.0",
        }),
        secure_json_data_encoded=json.dumps({
            "basicAuthPassword": "password",
        }))
    from_name = grafana.get_data_source_output(name=prometheus.name)
    from_id = grafana.get_data_source_output(id=prometheus.id)
    from_uid = grafana.get_data_source_output(uid=prometheus.uid)
    ```


    :param str id: The ID of this resource.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['uid'] = uid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:index/getDataSource:getDataSource', __args__, opts=opts, typ=GetDataSourceResult).value

    return AwaitableGetDataSourceResult(
        access_mode=__ret__.access_mode,
        basic_auth_enabled=__ret__.basic_auth_enabled,
        basic_auth_username=__ret__.basic_auth_username,
        database_name=__ret__.database_name,
        id=__ret__.id,
        is_default=__ret__.is_default,
        json_data_encoded=__ret__.json_data_encoded,
        name=__ret__.name,
        type=__ret__.type,
        uid=__ret__.uid,
        url=__ret__.url,
        username=__ret__.username)


@_utilities.lift_output_func(get_data_source)
def get_data_source_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           uid: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataSourceResult]:
    """
    Get details about a Grafana Datasource querying by either name, uid or ID

    ## Example Usage

    ```python
    import pulumi
    import json
    import lbrlabs_pulumi_grafana as grafana
    import pulumi_grafana as grafana

    prometheus = grafana.DataSource("prometheus",
        type="prometheus",
        uid="prometheus-ds-test-uid",
        url="https://my-instance.com",
        basic_auth_enabled=True,
        basic_auth_username="username",
        json_data_encoded=json.dumps({
            "httpMethod": "POST",
            "prometheusType": "Mimir",
            "prometheusVersion": "2.4.0",
        }),
        secure_json_data_encoded=json.dumps({
            "basicAuthPassword": "password",
        }))
    from_name = grafana.get_data_source_output(name=prometheus.name)
    from_id = grafana.get_data_source_output(id=prometheus.id)
    from_uid = grafana.get_data_source_output(uid=prometheus.uid)
    ```


    :param str id: The ID of this resource.
    """
    ...
