# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetDashboardsResult',
    'AwaitableGetDashboardsResult',
    'get_dashboards',
    'get_dashboards_output',
]

@pulumi.output_type
class GetDashboardsResult:
    """
    A collection of values returned by getDashboards.
    """
    def __init__(__self__, dashboards=None, folder_ids=None, id=None, limit=None, tags=None):
        if dashboards and not isinstance(dashboards, list):
            raise TypeError("Expected argument 'dashboards' to be a list")
        pulumi.set(__self__, "dashboards", dashboards)
        if folder_ids and not isinstance(folder_ids, list):
            raise TypeError("Expected argument 'folder_ids' to be a list")
        pulumi.set(__self__, "folder_ids", folder_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def dashboards(self) -> Sequence['outputs.GetDashboardsDashboardResult']:
        return pulumi.get(self, "dashboards")

    @property
    @pulumi.getter(name="folderIds")
    def folder_ids(self) -> Optional[Sequence[int]]:
        """
        Numerical IDs of Grafana folders containing dashboards. Specify to filter for dashboards by folder (eg. `[0]` for General folder), or leave blank to get all dashboards in all folders.
        """
        return pulumi.get(self, "folder_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        """
        Maximum number of dashboard search results to return. Defaults to `5000`.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        List of string Grafana dashboard tags to search for, eg. `["prod"]`. Used only as search input, i.e., attribute value will remain unchanged.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDashboardsResult(GetDashboardsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDashboardsResult(
            dashboards=self.dashboards,
            folder_ids=self.folder_ids,
            id=self.id,
            limit=self.limit,
            tags=self.tags)


def get_dashboards(folder_ids: Optional[Sequence[int]] = None,
                   limit: Optional[int] = None,
                   tags: Optional[Sequence[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDashboardsResult:
    """
    Datasource for retrieving all dashboards. Specify list of folder IDs to search in for dashboards.

    * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/)
    * [Folder/Dashboard Search HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/folder_dashboard_search/)
    * [Dashboard HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/dashboard/)


    :param Sequence[int] folder_ids: Numerical IDs of Grafana folders containing dashboards. Specify to filter for dashboards by folder (eg. `[0]` for General folder), or leave blank to get all dashboards in all folders.
    :param int limit: Maximum number of dashboard search results to return. Defaults to `5000`.
    :param Sequence[str] tags: List of string Grafana dashboard tags to search for, eg. `["prod"]`. Used only as search input, i.e., attribute value will remain unchanged.
    """
    __args__ = dict()
    __args__['folderIds'] = folder_ids
    __args__['limit'] = limit
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:index/getDashboards:getDashboards', __args__, opts=opts, typ=GetDashboardsResult).value

    return AwaitableGetDashboardsResult(
        dashboards=__ret__.dashboards,
        folder_ids=__ret__.folder_ids,
        id=__ret__.id,
        limit=__ret__.limit,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_dashboards)
def get_dashboards_output(folder_ids: Optional[pulumi.Input[Optional[Sequence[int]]]] = None,
                          limit: Optional[pulumi.Input[Optional[int]]] = None,
                          tags: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDashboardsResult]:
    """
    Datasource for retrieving all dashboards. Specify list of folder IDs to search in for dashboards.

    * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/)
    * [Folder/Dashboard Search HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/folder_dashboard_search/)
    * [Dashboard HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/dashboard/)


    :param Sequence[int] folder_ids: Numerical IDs of Grafana folders containing dashboards. Specify to filter for dashboards by folder (eg. `[0]` for General folder), or leave blank to get all dashboards in all folders.
    :param int limit: Maximum number of dashboard search results to return. Defaults to `5000`.
    :param Sequence[str] tags: List of string Grafana dashboard tags to search for, eg. `["prod"]`. Used only as search input, i.e., attribute value will remain unchanged.
    """
    ...
