# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CloudStackArgs', 'CloudStack']

@pulumi.input_type
class CloudStackArgs:
    def __init__(__self__, *,
                 slug: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region_slug: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CloudStack resource.
        :param pulumi.Input[str] slug: Subdomain that the Grafana instance will be available at (i.e. setting slug to “\\n\\n” will make the instance
               available at “https://\\n\\n.grafana.net".
        :param pulumi.Input[str] description: Description of stack.
        :param pulumi.Input[str] name: Name of stack. Conventionally matches the url of the instance (e.g. “\\n\\n.grafana.net”).
        :param pulumi.Input[str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/reference/cloud-api/#list-regions.
        :param pulumi.Input[str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        pulumi.set(__self__, "slug", slug)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_slug is not None:
            pulumi.set(__self__, "region_slug", region_slug)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if wait_for_readiness is not None:
            pulumi.set(__self__, "wait_for_readiness", wait_for_readiness)
        if wait_for_readiness_timeout is not None:
            pulumi.set(__self__, "wait_for_readiness_timeout", wait_for_readiness_timeout)

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Input[str]:
        """
        Subdomain that the Grafana instance will be available at (i.e. setting slug to “\\n\\n” will make the instance
        available at “https://\\n\\n.grafana.net".
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: pulumi.Input[str]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of stack. Conventionally matches the url of the instance (e.g. “\\n\\n.grafana.net”).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> Optional[pulumi.Input[str]]:
        """
        Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region_slug")

    @region_slug.setter
    def region_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_slug", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="waitForReadiness")
    def wait_for_readiness(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_readiness")

    @wait_for_readiness.setter
    def wait_for_readiness(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_readiness", value)

    @property
    @pulumi.getter(name="waitForReadinessTimeout")
    def wait_for_readiness_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        return pulumi.get(self, "wait_for_readiness_timeout")

    @wait_for_readiness_timeout.setter
    def wait_for_readiness_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_for_readiness_timeout", value)


@pulumi.input_type
class _CloudStackState:
    def __init__(__self__, *,
                 alertmanager_name: Optional[pulumi.Input[str]] = None,
                 alertmanager_status: Optional[pulumi.Input[str]] = None,
                 alertmanager_url: Optional[pulumi.Input[str]] = None,
                 alertmanager_user_id: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 graphite_name: Optional[pulumi.Input[str]] = None,
                 graphite_status: Optional[pulumi.Input[str]] = None,
                 graphite_url: Optional[pulumi.Input[str]] = None,
                 graphite_user_id: Optional[pulumi.Input[int]] = None,
                 logs_name: Optional[pulumi.Input[str]] = None,
                 logs_status: Optional[pulumi.Input[str]] = None,
                 logs_url: Optional[pulumi.Input[str]] = None,
                 logs_user_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[int]] = None,
                 org_name: Optional[pulumi.Input[str]] = None,
                 org_slug: Optional[pulumi.Input[str]] = None,
                 prometheus_name: Optional[pulumi.Input[str]] = None,
                 prometheus_remote_endpoint: Optional[pulumi.Input[str]] = None,
                 prometheus_remote_write_endpoint: Optional[pulumi.Input[str]] = None,
                 prometheus_status: Optional[pulumi.Input[str]] = None,
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 prometheus_user_id: Optional[pulumi.Input[int]] = None,
                 region_slug: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 traces_name: Optional[pulumi.Input[str]] = None,
                 traces_status: Optional[pulumi.Input[str]] = None,
                 traces_url: Optional[pulumi.Input[str]] = None,
                 traces_user_id: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudStack resources.
        :param pulumi.Input[str] alertmanager_name: Name of the Alertmanager instance configured for this stack.
        :param pulumi.Input[str] alertmanager_status: Status of the Alertmanager instance configured for this stack.
        :param pulumi.Input[str] alertmanager_url: Base URL of the Alertmanager instance configured for this stack.
        :param pulumi.Input[int] alertmanager_user_id: User ID of the Alertmanager instance configured for this stack.
        :param pulumi.Input[str] description: Description of stack.
        :param pulumi.Input[str] name: Name of stack. Conventionally matches the url of the instance (e.g. “\\n\\n.grafana.net”).
        :param pulumi.Input[int] org_id: Organization id to assign to this stack.
        :param pulumi.Input[str] org_name: Organization name to assign to this stack.
        :param pulumi.Input[str] org_slug: Organization slug to assign to this stack.
        :param pulumi.Input[str] prometheus_name: Prometheus name for this instance.
        :param pulumi.Input[str] prometheus_remote_endpoint: Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        :param pulumi.Input[str] prometheus_remote_write_endpoint: Use this URL to send prometheus metrics to Grafana cloud
        :param pulumi.Input[str] prometheus_status: Prometheus status for this instance.
        :param pulumi.Input[str] prometheus_url: Prometheus url for this instance.
        :param pulumi.Input[int] prometheus_user_id: Prometheus user ID. Used for e.g. remote_write.
        :param pulumi.Input[str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/reference/cloud-api/#list-regions.
        :param pulumi.Input[str] slug: Subdomain that the Grafana instance will be available at (i.e. setting slug to “\\n\\n” will make the instance
               available at “https://\\n\\n.grafana.net".
        :param pulumi.Input[str] status: Status of the stack.
        :param pulumi.Input[str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        if alertmanager_name is not None:
            pulumi.set(__self__, "alertmanager_name", alertmanager_name)
        if alertmanager_status is not None:
            pulumi.set(__self__, "alertmanager_status", alertmanager_status)
        if alertmanager_url is not None:
            pulumi.set(__self__, "alertmanager_url", alertmanager_url)
        if alertmanager_user_id is not None:
            pulumi.set(__self__, "alertmanager_user_id", alertmanager_user_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if graphite_name is not None:
            pulumi.set(__self__, "graphite_name", graphite_name)
        if graphite_status is not None:
            pulumi.set(__self__, "graphite_status", graphite_status)
        if graphite_url is not None:
            pulumi.set(__self__, "graphite_url", graphite_url)
        if graphite_user_id is not None:
            pulumi.set(__self__, "graphite_user_id", graphite_user_id)
        if logs_name is not None:
            pulumi.set(__self__, "logs_name", logs_name)
        if logs_status is not None:
            pulumi.set(__self__, "logs_status", logs_status)
        if logs_url is not None:
            pulumi.set(__self__, "logs_url", logs_url)
        if logs_user_id is not None:
            pulumi.set(__self__, "logs_user_id", logs_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if org_name is not None:
            pulumi.set(__self__, "org_name", org_name)
        if org_slug is not None:
            pulumi.set(__self__, "org_slug", org_slug)
        if prometheus_name is not None:
            pulumi.set(__self__, "prometheus_name", prometheus_name)
        if prometheus_remote_endpoint is not None:
            pulumi.set(__self__, "prometheus_remote_endpoint", prometheus_remote_endpoint)
        if prometheus_remote_write_endpoint is not None:
            pulumi.set(__self__, "prometheus_remote_write_endpoint", prometheus_remote_write_endpoint)
        if prometheus_status is not None:
            pulumi.set(__self__, "prometheus_status", prometheus_status)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if prometheus_user_id is not None:
            pulumi.set(__self__, "prometheus_user_id", prometheus_user_id)
        if region_slug is not None:
            pulumi.set(__self__, "region_slug", region_slug)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if traces_name is not None:
            pulumi.set(__self__, "traces_name", traces_name)
        if traces_status is not None:
            pulumi.set(__self__, "traces_status", traces_status)
        if traces_url is not None:
            pulumi.set(__self__, "traces_url", traces_url)
        if traces_user_id is not None:
            pulumi.set(__self__, "traces_user_id", traces_user_id)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if wait_for_readiness is not None:
            pulumi.set(__self__, "wait_for_readiness", wait_for_readiness)
        if wait_for_readiness_timeout is not None:
            pulumi.set(__self__, "wait_for_readiness_timeout", wait_for_readiness_timeout)

    @property
    @pulumi.getter(name="alertmanagerName")
    def alertmanager_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_name")

    @alertmanager_name.setter
    def alertmanager_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alertmanager_name", value)

    @property
    @pulumi.getter(name="alertmanagerStatus")
    def alertmanager_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_status")

    @alertmanager_status.setter
    def alertmanager_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alertmanager_status", value)

    @property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_url")

    @alertmanager_url.setter
    def alertmanager_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alertmanager_url", value)

    @property
    @pulumi.getter(name="alertmanagerUserId")
    def alertmanager_user_id(self) -> Optional[pulumi.Input[int]]:
        """
        User ID of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_user_id")

    @alertmanager_user_id.setter
    def alertmanager_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alertmanager_user_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="graphiteName")
    def graphite_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "graphite_name")

    @graphite_name.setter
    def graphite_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graphite_name", value)

    @property
    @pulumi.getter(name="graphiteStatus")
    def graphite_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "graphite_status")

    @graphite_status.setter
    def graphite_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graphite_status", value)

    @property
    @pulumi.getter(name="graphiteUrl")
    def graphite_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "graphite_url")

    @graphite_url.setter
    def graphite_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graphite_url", value)

    @property
    @pulumi.getter(name="graphiteUserId")
    def graphite_user_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "graphite_user_id")

    @graphite_user_id.setter
    def graphite_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "graphite_user_id", value)

    @property
    @pulumi.getter(name="logsName")
    def logs_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logs_name")

    @logs_name.setter
    def logs_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_name", value)

    @property
    @pulumi.getter(name="logsStatus")
    def logs_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logs_status")

    @logs_status.setter
    def logs_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_status", value)

    @property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logs_url")

    @logs_url.setter
    def logs_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_url", value)

    @property
    @pulumi.getter(name="logsUserId")
    def logs_user_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "logs_user_id")

    @logs_user_id.setter
    def logs_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "logs_user_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of stack. Conventionally matches the url of the instance (e.g. “\\n\\n.grafana.net”).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[int]]:
        """
        Organization id to assign to this stack.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="orgName")
    def org_name(self) -> Optional[pulumi.Input[str]]:
        """
        Organization name to assign to this stack.
        """
        return pulumi.get(self, "org_name")

    @org_name.setter
    def org_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_name", value)

    @property
    @pulumi.getter(name="orgSlug")
    def org_slug(self) -> Optional[pulumi.Input[str]]:
        """
        Organization slug to assign to this stack.
        """
        return pulumi.get(self, "org_slug")

    @org_slug.setter
    def org_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_slug", value)

    @property
    @pulumi.getter(name="prometheusName")
    def prometheus_name(self) -> Optional[pulumi.Input[str]]:
        """
        Prometheus name for this instance.
        """
        return pulumi.get(self, "prometheus_name")

    @prometheus_name.setter
    def prometheus_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_name", value)

    @property
    @pulumi.getter(name="prometheusRemoteEndpoint")
    def prometheus_remote_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        """
        return pulumi.get(self, "prometheus_remote_endpoint")

    @prometheus_remote_endpoint.setter
    def prometheus_remote_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_remote_endpoint", value)

    @property
    @pulumi.getter(name="prometheusRemoteWriteEndpoint")
    def prometheus_remote_write_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Use this URL to send prometheus metrics to Grafana cloud
        """
        return pulumi.get(self, "prometheus_remote_write_endpoint")

    @prometheus_remote_write_endpoint.setter
    def prometheus_remote_write_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_remote_write_endpoint", value)

    @property
    @pulumi.getter(name="prometheusStatus")
    def prometheus_status(self) -> Optional[pulumi.Input[str]]:
        """
        Prometheus status for this instance.
        """
        return pulumi.get(self, "prometheus_status")

    @prometheus_status.setter
    def prometheus_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_status", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[str]]:
        """
        Prometheus url for this instance.
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_url", value)

    @property
    @pulumi.getter(name="prometheusUserId")
    def prometheus_user_id(self) -> Optional[pulumi.Input[int]]:
        """
        Prometheus user ID. Used for e.g. remote_write.
        """
        return pulumi.get(self, "prometheus_user_id")

    @prometheus_user_id.setter
    def prometheus_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prometheus_user_id", value)

    @property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> Optional[pulumi.Input[str]]:
        """
        Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region_slug")

    @region_slug.setter
    def region_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_slug", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        Subdomain that the Grafana instance will be available at (i.e. setting slug to “\\n\\n” will make the instance
        available at “https://\\n\\n.grafana.net".
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the stack.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tracesName")
    def traces_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "traces_name")

    @traces_name.setter
    def traces_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traces_name", value)

    @property
    @pulumi.getter(name="tracesStatus")
    def traces_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "traces_status")

    @traces_status.setter
    def traces_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traces_status", value)

    @property
    @pulumi.getter(name="tracesUrl")
    def traces_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "traces_url")

    @traces_url.setter
    def traces_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traces_url", value)

    @property
    @pulumi.getter(name="tracesUserId")
    def traces_user_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "traces_user_id")

    @traces_user_id.setter
    def traces_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traces_user_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="waitForReadiness")
    def wait_for_readiness(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_readiness")

    @wait_for_readiness.setter
    def wait_for_readiness(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_readiness", value)

    @property
    @pulumi.getter(name="waitForReadinessTimeout")
    def wait_for_readiness_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        return pulumi.get(self, "wait_for_readiness_timeout")

    @wait_for_readiness_timeout.setter
    def wait_for_readiness_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_for_readiness_timeout", value)


class CloudStack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region_slug: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/reference/cloud-api/#stacks/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        test = grafana.CloudStack("test",
            description="Test Grafana Cloud Stack",
            region_slug="eu",
            slug="gcloudstacktest")
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/cloudStack:CloudStack stack_name {{stack_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of stack.
        :param pulumi.Input[str] name: Name of stack. Conventionally matches the url of the instance (e.g. “\\n\\n.grafana.net”).
        :param pulumi.Input[str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/reference/cloud-api/#list-regions.
        :param pulumi.Input[str] slug: Subdomain that the Grafana instance will be available at (i.e. setting slug to “\\n\\n” will make the instance
               available at “https://\\n\\n.grafana.net".
        :param pulumi.Input[str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudStackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/reference/cloud-api/#stacks/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        test = grafana.CloudStack("test",
            description="Test Grafana Cloud Stack",
            region_slug="eu",
            slug="gcloudstacktest")
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/cloudStack:CloudStack stack_name {{stack_id}}
        ```

        :param str resource_name: The name of the resource.
        :param CloudStackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudStackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region_slug: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 wait_for_readiness: Optional[pulumi.Input[bool]] = None,
                 wait_for_readiness_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudStackArgs.__new__(CloudStackArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region_slug"] = region_slug
            if slug is None and not opts.urn:
                raise TypeError("Missing required property 'slug'")
            __props__.__dict__["slug"] = slug
            __props__.__dict__["url"] = url
            __props__.__dict__["wait_for_readiness"] = wait_for_readiness
            __props__.__dict__["wait_for_readiness_timeout"] = wait_for_readiness_timeout
            __props__.__dict__["alertmanager_name"] = None
            __props__.__dict__["alertmanager_status"] = None
            __props__.__dict__["alertmanager_url"] = None
            __props__.__dict__["alertmanager_user_id"] = None
            __props__.__dict__["graphite_name"] = None
            __props__.__dict__["graphite_status"] = None
            __props__.__dict__["graphite_url"] = None
            __props__.__dict__["graphite_user_id"] = None
            __props__.__dict__["logs_name"] = None
            __props__.__dict__["logs_status"] = None
            __props__.__dict__["logs_url"] = None
            __props__.__dict__["logs_user_id"] = None
            __props__.__dict__["org_id"] = None
            __props__.__dict__["org_name"] = None
            __props__.__dict__["org_slug"] = None
            __props__.__dict__["prometheus_name"] = None
            __props__.__dict__["prometheus_remote_endpoint"] = None
            __props__.__dict__["prometheus_remote_write_endpoint"] = None
            __props__.__dict__["prometheus_status"] = None
            __props__.__dict__["prometheus_url"] = None
            __props__.__dict__["prometheus_user_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["traces_name"] = None
            __props__.__dict__["traces_status"] = None
            __props__.__dict__["traces_url"] = None
            __props__.__dict__["traces_user_id"] = None
        super(CloudStack, __self__).__init__(
            'grafana:index/cloudStack:CloudStack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alertmanager_name: Optional[pulumi.Input[str]] = None,
            alertmanager_status: Optional[pulumi.Input[str]] = None,
            alertmanager_url: Optional[pulumi.Input[str]] = None,
            alertmanager_user_id: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            graphite_name: Optional[pulumi.Input[str]] = None,
            graphite_status: Optional[pulumi.Input[str]] = None,
            graphite_url: Optional[pulumi.Input[str]] = None,
            graphite_user_id: Optional[pulumi.Input[int]] = None,
            logs_name: Optional[pulumi.Input[str]] = None,
            logs_status: Optional[pulumi.Input[str]] = None,
            logs_url: Optional[pulumi.Input[str]] = None,
            logs_user_id: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[int]] = None,
            org_name: Optional[pulumi.Input[str]] = None,
            org_slug: Optional[pulumi.Input[str]] = None,
            prometheus_name: Optional[pulumi.Input[str]] = None,
            prometheus_remote_endpoint: Optional[pulumi.Input[str]] = None,
            prometheus_remote_write_endpoint: Optional[pulumi.Input[str]] = None,
            prometheus_status: Optional[pulumi.Input[str]] = None,
            prometheus_url: Optional[pulumi.Input[str]] = None,
            prometheus_user_id: Optional[pulumi.Input[int]] = None,
            region_slug: Optional[pulumi.Input[str]] = None,
            slug: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            traces_name: Optional[pulumi.Input[str]] = None,
            traces_status: Optional[pulumi.Input[str]] = None,
            traces_url: Optional[pulumi.Input[str]] = None,
            traces_user_id: Optional[pulumi.Input[int]] = None,
            url: Optional[pulumi.Input[str]] = None,
            wait_for_readiness: Optional[pulumi.Input[bool]] = None,
            wait_for_readiness_timeout: Optional[pulumi.Input[str]] = None) -> 'CloudStack':
        """
        Get an existing CloudStack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alertmanager_name: Name of the Alertmanager instance configured for this stack.
        :param pulumi.Input[str] alertmanager_status: Status of the Alertmanager instance configured for this stack.
        :param pulumi.Input[str] alertmanager_url: Base URL of the Alertmanager instance configured for this stack.
        :param pulumi.Input[int] alertmanager_user_id: User ID of the Alertmanager instance configured for this stack.
        :param pulumi.Input[str] description: Description of stack.
        :param pulumi.Input[str] name: Name of stack. Conventionally matches the url of the instance (e.g. “\\n\\n.grafana.net”).
        :param pulumi.Input[int] org_id: Organization id to assign to this stack.
        :param pulumi.Input[str] org_name: Organization name to assign to this stack.
        :param pulumi.Input[str] org_slug: Organization slug to assign to this stack.
        :param pulumi.Input[str] prometheus_name: Prometheus name for this instance.
        :param pulumi.Input[str] prometheus_remote_endpoint: Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        :param pulumi.Input[str] prometheus_remote_write_endpoint: Use this URL to send prometheus metrics to Grafana cloud
        :param pulumi.Input[str] prometheus_status: Prometheus status for this instance.
        :param pulumi.Input[str] prometheus_url: Prometheus url for this instance.
        :param pulumi.Input[int] prometheus_user_id: Prometheus user ID. Used for e.g. remote_write.
        :param pulumi.Input[str] region_slug: Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/reference/cloud-api/#list-regions.
        :param pulumi.Input[str] slug: Subdomain that the Grafana instance will be available at (i.e. setting slug to “\\n\\n” will make the instance
               available at “https://\\n\\n.grafana.net".
        :param pulumi.Input[str] status: Status of the stack.
        :param pulumi.Input[str] url: Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        :param pulumi.Input[bool] wait_for_readiness: Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        :param pulumi.Input[str] wait_for_readiness_timeout: How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudStackState.__new__(_CloudStackState)

        __props__.__dict__["alertmanager_name"] = alertmanager_name
        __props__.__dict__["alertmanager_status"] = alertmanager_status
        __props__.__dict__["alertmanager_url"] = alertmanager_url
        __props__.__dict__["alertmanager_user_id"] = alertmanager_user_id
        __props__.__dict__["description"] = description
        __props__.__dict__["graphite_name"] = graphite_name
        __props__.__dict__["graphite_status"] = graphite_status
        __props__.__dict__["graphite_url"] = graphite_url
        __props__.__dict__["graphite_user_id"] = graphite_user_id
        __props__.__dict__["logs_name"] = logs_name
        __props__.__dict__["logs_status"] = logs_status
        __props__.__dict__["logs_url"] = logs_url
        __props__.__dict__["logs_user_id"] = logs_user_id
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["org_name"] = org_name
        __props__.__dict__["org_slug"] = org_slug
        __props__.__dict__["prometheus_name"] = prometheus_name
        __props__.__dict__["prometheus_remote_endpoint"] = prometheus_remote_endpoint
        __props__.__dict__["prometheus_remote_write_endpoint"] = prometheus_remote_write_endpoint
        __props__.__dict__["prometheus_status"] = prometheus_status
        __props__.__dict__["prometheus_url"] = prometheus_url
        __props__.__dict__["prometheus_user_id"] = prometheus_user_id
        __props__.__dict__["region_slug"] = region_slug
        __props__.__dict__["slug"] = slug
        __props__.__dict__["status"] = status
        __props__.__dict__["traces_name"] = traces_name
        __props__.__dict__["traces_status"] = traces_status
        __props__.__dict__["traces_url"] = traces_url
        __props__.__dict__["traces_user_id"] = traces_user_id
        __props__.__dict__["url"] = url
        __props__.__dict__["wait_for_readiness"] = wait_for_readiness
        __props__.__dict__["wait_for_readiness_timeout"] = wait_for_readiness_timeout
        return CloudStack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertmanagerName")
    def alertmanager_name(self) -> pulumi.Output[str]:
        """
        Name of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_name")

    @property
    @pulumi.getter(name="alertmanagerStatus")
    def alertmanager_status(self) -> pulumi.Output[str]:
        """
        Status of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_status")

    @property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> pulumi.Output[str]:
        """
        Base URL of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_url")

    @property
    @pulumi.getter(name="alertmanagerUserId")
    def alertmanager_user_id(self) -> pulumi.Output[int]:
        """
        User ID of the Alertmanager instance configured for this stack.
        """
        return pulumi.get(self, "alertmanager_user_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of stack.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="graphiteName")
    def graphite_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "graphite_name")

    @property
    @pulumi.getter(name="graphiteStatus")
    def graphite_status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "graphite_status")

    @property
    @pulumi.getter(name="graphiteUrl")
    def graphite_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "graphite_url")

    @property
    @pulumi.getter(name="graphiteUserId")
    def graphite_user_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "graphite_user_id")

    @property
    @pulumi.getter(name="logsName")
    def logs_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "logs_name")

    @property
    @pulumi.getter(name="logsStatus")
    def logs_status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "logs_status")

    @property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "logs_url")

    @property
    @pulumi.getter(name="logsUserId")
    def logs_user_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "logs_user_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of stack. Conventionally matches the url of the instance (e.g. “\\n\\n.grafana.net”).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[int]:
        """
        Organization id to assign to this stack.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="orgName")
    def org_name(self) -> pulumi.Output[str]:
        """
        Organization name to assign to this stack.
        """
        return pulumi.get(self, "org_name")

    @property
    @pulumi.getter(name="orgSlug")
    def org_slug(self) -> pulumi.Output[str]:
        """
        Organization slug to assign to this stack.
        """
        return pulumi.get(self, "org_slug")

    @property
    @pulumi.getter(name="prometheusName")
    def prometheus_name(self) -> pulumi.Output[str]:
        """
        Prometheus name for this instance.
        """
        return pulumi.get(self, "prometheus_name")

    @property
    @pulumi.getter(name="prometheusRemoteEndpoint")
    def prometheus_remote_endpoint(self) -> pulumi.Output[str]:
        """
        Use this URL to query hosted metrics data e.g. Prometheus data source in Grafana
        """
        return pulumi.get(self, "prometheus_remote_endpoint")

    @property
    @pulumi.getter(name="prometheusRemoteWriteEndpoint")
    def prometheus_remote_write_endpoint(self) -> pulumi.Output[str]:
        """
        Use this URL to send prometheus metrics to Grafana cloud
        """
        return pulumi.get(self, "prometheus_remote_write_endpoint")

    @property
    @pulumi.getter(name="prometheusStatus")
    def prometheus_status(self) -> pulumi.Output[str]:
        """
        Prometheus status for this instance.
        """
        return pulumi.get(self, "prometheus_status")

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> pulumi.Output[str]:
        """
        Prometheus url for this instance.
        """
        return pulumi.get(self, "prometheus_url")

    @property
    @pulumi.getter(name="prometheusUserId")
    def prometheus_user_id(self) -> pulumi.Output[int]:
        """
        Prometheus user ID. Used for e.g. remote_write.
        """
        return pulumi.get(self, "prometheus_user_id")

    @property
    @pulumi.getter(name="regionSlug")
    def region_slug(self) -> pulumi.Output[Optional[str]]:
        """
        Region slug to assign to this stack. Changing region will destroy the existing stack and create a new one in the desired region. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region_slug")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        Subdomain that the Grafana instance will be available at (i.e. setting slug to “\\n\\n” will make the instance
        available at “https://\\n\\n.grafana.net".
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the stack.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tracesName")
    def traces_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "traces_name")

    @property
    @pulumi.getter(name="tracesStatus")
    def traces_status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "traces_status")

    @property
    @pulumi.getter(name="tracesUrl")
    def traces_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "traces_url")

    @property
    @pulumi.getter(name="tracesUserId")
    def traces_user_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "traces_user_id")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        Custom URL for the Grafana instance. Must have a CNAME setup to point to `.grafana.net` before creating the stack
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="waitForReadiness")
    def wait_for_readiness(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to wait for readiness of the stack after creating it. The check is a HEAD request to the stack URL (Grafana instance). Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_readiness")

    @property
    @pulumi.getter(name="waitForReadinessTimeout")
    def wait_for_readiness_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        How long to wait for readiness (if enabled). Defaults to `5m0s`.
        """
        return pulumi.get(self, "wait_for_readiness_timeout")

