/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import org.capnproto.FromPointerBuilder;
import org.capnproto.SegmentBuilder;
import org.capnproto.SetPointerBuilder;
import org.capnproto.StructBuilder;

public class ListBuilder {
    final SegmentBuilder segment;
    final int ptr;
    final int elementCount;
    final int step;
    final int structDataSize;
    final short structPointerCount;

    public ListBuilder(SegmentBuilder segmentBuilder, int n2, int n3, int n4, int n5, short s2) {
        this.segment = segmentBuilder;
        this.ptr = n2;
        this.elementCount = n3;
        this.step = n4;
        this.structDataSize = n5;
        this.structPointerCount = s2;
    }

    public int size() {
        return this.elementCount;
    }

    protected boolean _getBooleanElement(int n2) {
        long l2 = (long)n2 * (long)this.step;
        byte by = this.segment.buffer.get(this.ptr + (int)(l2 / 8L));
        return (by & 1 << (int)(l2 % 8L)) != 0;
    }

    protected byte _getByteElement(int n2) {
        return this.segment.buffer.get(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected short _getShortElement(int n2) {
        return this.segment.buffer.getShort(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected int _getIntElement(int n2) {
        return this.segment.buffer.getInt(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected long _getLongElement(int n2) {
        return this.segment.buffer.getLong(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected float _getFloatElement(int n2) {
        return this.segment.buffer.getFloat(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected double _getDoubleElement(int n2) {
        return this.segment.buffer.getDouble(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected void _setBooleanElement(int n2, boolean bl) {
        long l2 = n2 * this.step;
        byte by = (byte)(l2 % 8L);
        int n3 = (int)((long)this.ptr + l2 / 8L);
        byte by2 = this.segment.buffer.get(n3);
        this.segment.buffer.put(n3, (byte)(by2 & ~(1 << by) | (bl ? (byte)1 : 0) << by));
    }

    protected void _setByteElement(int n2, byte by) {
        this.segment.buffer.put(this.ptr + (int)((long)n2 * (long)this.step / 8L), by);
    }

    protected void _setShortElement(int n2, short s2) {
        this.segment.buffer.putShort(this.ptr + (int)((long)n2 * (long)this.step / 8L), s2);
    }

    protected void _setIntElement(int n2, int n3) {
        this.segment.buffer.putInt(this.ptr + (int)((long)n2 * (long)this.step / 8L), n3);
    }

    protected void _setLongElement(int n2, long l2) {
        this.segment.buffer.putLong(this.ptr + (int)((long)n2 * (long)this.step / 8L), l2);
    }

    protected void _setFloatElement(int n2, float f2) {
        this.segment.buffer.putFloat(this.ptr + (int)((long)n2 * (long)this.step / 8L), f2);
    }

    protected void _setDoubleElement(int n2, double d2) {
        this.segment.buffer.putDouble(this.ptr + (int)((long)n2 * (long)this.step / 8L), d2);
    }

    protected final <T> T _getStructElement(StructBuilder.Factory<T> factory, int n2) {
        long l2 = (long)n2 * (long)this.step;
        int n3 = this.ptr + (int)(l2 / 8L);
        int n4 = (n3 + this.structDataSize / 8) / 8;
        return factory.constructBuilder(this.segment, n3, n4, this.structDataSize, this.structPointerCount);
    }

    protected final <T> T _getPointerElement(FromPointerBuilder<T> fromPointerBuilder, int n2) {
        return fromPointerBuilder.fromPointerBuilder(this.segment, (this.ptr + (int)((long)n2 * (long)this.step / 8L)) / 8);
    }

    protected final <T> T _initPointerElement(FromPointerBuilder<T> fromPointerBuilder, int n2, int n3) {
        return fromPointerBuilder.initFromPointerBuilder(this.segment, (this.ptr + (int)((long)n2 * (long)this.step / 8L)) / 8, n3);
    }

    protected final <Builder, Reader> void _setPointerElement(SetPointerBuilder<Builder, Reader> setPointerBuilder, int n2, Reader Reader2) {
        setPointerBuilder.setPointerBuilder(this.segment, (this.ptr + (int)((long)n2 * (long)this.step / 8L)) / 8, Reader2);
    }

    public static interface Factory<T> {
        public T constructBuilder(SegmentBuilder var1, int var2, int var3, int var4, int var5, short var6);
    }
}

