# Generated by Django 5.0 on 2023-12-18 20:45

import django_admin_keycloak.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="KeycloakProvider",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("active", models.BooleanField(default=True, verbose_name="active")),
                ("slug", models.SlugField(unique=True, verbose_name="slug")),
                ("name", models.CharField(max_length=128, verbose_name="name")),
                ("server_url", models.URLField(verbose_name="server url")),
                (
                    "realm_name",
                    models.CharField(max_length=128, verbose_name="realm name"),
                ),
                (
                    "client_id",
                    models.CharField(max_length=128, verbose_name="client id"),
                ),
                (
                    "client_secret_key",
                    models.CharField(
                        blank=True,
                        max_length=128,
                        null=True,
                        verbose_name="client secret key",
                    ),
                ),
                (
                    "redirect_uri",
                    models.CharField(
                        default="/",
                        help_text="The redirect URI for user is not staff",
                        max_length=256,
                        verbose_name="redirect_uri",
                    ),
                ),
                (
                    "role_super_user",
                    models.CharField(
                        default="superuser",
                        max_length=128,
                        verbose_name="superuser role",
                    ),
                ),
                (
                    "role_staff_user",
                    models.CharField(
                        default="staff", max_length=128, verbose_name="staff user role"
                    ),
                ),
                (
                    "options",
                    models.JSONField(
                        default=django_admin_keycloak.models._default_options,
                        help_text="Available options list see https://python-keycloak.readthedocs.io/",
                        verbose_name="options",
                    ),
                ),
            ],
            options={
                "verbose_name": "Keycloak Provider",
                "verbose_name_plural": "Keycloak Provider",
                "db_table": "keycloak_provider",
            },
        ),
    ]
