"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Specifies the type responses the lambda returns.
 *
 * @experimental
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * (experimental) Authorize Http Api routes via a lambda function.
 *
 * @experimental
 */
class HttpLambdaAuthorizer {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c, _d;
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const id = this.props.authorizerName;
            const responseTypes = (_b = this.props.responseTypes) !== null && _b !== void 0 ? _b : [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.LAMBDA,
                authorizerName: this.props.authorizerName,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.props.handler),
                resultsCacheTtl: (_d = this.props.resultsCacheTtl) !== null && _d !== void 0 ? _d : aws_cdk_lib_1.Duration.minutes(5),
            });
            this.props.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpLambdaAuthorizer", version: "2.0.0-alpha.5" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNEVBUXlDO0FBQ3pDLGlEQUF1RDtBQUV2RCw2Q0FBcUQ7Ozs7OztBQUdyRCxJQUFZLHNCQU1YO0FBTkQsV0FBWSxzQkFBc0I7SUFFaEMsdUVBQU0sQ0FBQTtJQUdOLGlFQUFHLENBQUE7QUFDTCxDQUFDLEVBTlcsc0JBQXNCLEdBQXRCLDhCQUFzQixLQUF0Qiw4QkFBc0IsUUFNakM7Ozs7OztBQXNCRCxNQUFhLG9CQUFvQjs7OztJQUkvQixZQUE2QixLQUFnQztRQUFoQyxVQUFLLEdBQUwsS0FBSyxDQUEyQjtJQUM3RCxDQUFDOzs7Ozs7SUFFTSxJQUFJLENBQUMsT0FBdUM7O1FBQ2pELElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxLQUFLLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3hFLE1BQU0sSUFBSSxLQUFLLENBQUMsb0RBQW9ELENBQUMsQ0FBQztTQUN2RTtRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ3BCLE1BQU0sRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDO1lBRXJDLE1BQU0sYUFBYSxTQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxtQ0FBSSxDQUFDLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQy9FLE1BQU0scUJBQXFCLEdBQUcsYUFBYSxDQUFDLFFBQVEsQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLENBQUMsSUFBSSxTQUFTLENBQUM7WUFFakcsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQztZQUNyQyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksdUNBQWMsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtnQkFDdEQsT0FBTyxFQUFFLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTztnQkFDOUIsY0FBYyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxtQ0FBSTtvQkFDM0MsK0JBQStCO2lCQUNoQztnQkFDRCxJQUFJLEVBQUUsMkNBQWtCLENBQUMsTUFBTTtnQkFDL0IsY0FBYyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYztnQkFDekMscUJBQXFCO2dCQUNyQixvQkFBb0IsRUFBRSxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsaURBQXdCLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxpREFBd0IsQ0FBQyxXQUFXO2dCQUN6SCxhQUFhLEVBQUUsbUJBQW1CLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUM7Z0JBQ3RELGVBQWUsUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsbUNBQUksc0JBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO2FBQ25FLENBQUMsQ0FBQztZQUVILElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxHQUFHLG1CQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRTtnQkFDekYsS0FBSyxFQUFFLE9BQU8sQ0FBQyxLQUFLO2dCQUNwQixTQUFTLEVBQUUsSUFBSSwwQkFBZ0IsQ0FBQywwQkFBMEIsQ0FBQztnQkFDM0QsU0FBUyxFQUFFLG1CQUFLLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxTQUFTLENBQUM7b0JBQzNDLE9BQU8sRUFBRSxhQUFhO29CQUN0QixRQUFRLEVBQUUsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSztvQkFDckMsWUFBWSxFQUFFLGVBQWUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLEVBQUU7aUJBQzVELENBQUM7YUFDSCxDQUFDLENBQUM7U0FDSjtRQUVELE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZO1lBQzFDLGlCQUFpQixFQUFFLFFBQVE7U0FDNUIsQ0FBQztJQUNKLENBQUM7O0FBL0NILG9EQWdEQzs7O0FBRUQ7O0dBRUc7QUFDSCxTQUFTLG1CQUFtQixDQUFDLE9BQWtCO0lBQzdDLE9BQU8sT0FBTyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxTQUFTLGVBQWUsbUJBQUssQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxxQ0FBcUMsT0FBTyxDQUFDLFdBQVcsY0FBYyxDQUFDO0FBQ3pKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBIdHRwQXV0aG9yaXplcixcbiAgSHR0cEF1dGhvcml6ZXJUeXBlLFxuICBIdHRwUm91dGVBdXRob3JpemVyQmluZE9wdGlvbnMsXG4gIEh0dHBSb3V0ZUF1dGhvcml6ZXJDb25maWcsXG4gIElIdHRwUm91dGVBdXRob3JpemVyLFxuICBBdXRob3JpemVyUGF5bG9hZFZlcnNpb24sXG4gIElIdHRwQXBpLFxufSBmcm9tICdAYXdzLWNkay9hd3MtYXBpZ2F0ZXdheXYyLWFscGhhJztcbmltcG9ydCB7IFNlcnZpY2VQcmluY2lwYWwgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IElGdW5jdGlvbiB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgU3RhY2ssIER1cmF0aW9uLCBOYW1lcyB9IGZyb20gJ2F3cy1jZGstbGliJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gSHR0cExhbWJkYVJlc3BvbnNlVHlwZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFNJTVBMRSxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIElBTSxcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cExhbWJkYUF1dGhvcml6ZXJQcm9wcyB7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXV0aG9yaXplck5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpZGVudGl0eVNvdXJjZT86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBoYW5kbGVyOiBJRnVuY3Rpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlc3VsdHNDYWNoZVR0bD86IER1cmF0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlc3BvbnNlVHlwZXM/OiBIdHRwTGFtYmRhUmVzcG9uc2VUeXBlW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBIdHRwTGFtYmRhQXV0aG9yaXplciBpbXBsZW1lbnRzIElIdHRwUm91dGVBdXRob3JpemVyIHtcbiAgcHJpdmF0ZSBhdXRob3JpemVyPzogSHR0cEF1dGhvcml6ZXI7XG4gIHByaXZhdGUgaHR0cEFwaT86IElIdHRwQXBpO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEh0dHBMYW1iZGFBdXRob3JpemVyUHJvcHMpIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKG9wdGlvbnM6IEh0dHBSb3V0ZUF1dGhvcml6ZXJCaW5kT3B0aW9ucyk6IEh0dHBSb3V0ZUF1dGhvcml6ZXJDb25maWcge1xuICAgIGlmICh0aGlzLmh0dHBBcGkgJiYgKHRoaXMuaHR0cEFwaS5hcGlJZCAhPT0gb3B0aW9ucy5yb3V0ZS5odHRwQXBpLmFwaUlkKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdDYW5ub3QgYXR0YWNoIHRoZSBzYW1lIGF1dGhvcml6ZXIgdG8gbXVsdGlwbGUgQXBpcycpO1xuICAgIH1cblxuICAgIGlmICghdGhpcy5hdXRob3JpemVyKSB7XG4gICAgICBjb25zdCBpZCA9IHRoaXMucHJvcHMuYXV0aG9yaXplck5hbWU7XG5cbiAgICAgIGNvbnN0IHJlc3BvbnNlVHlwZXMgPSB0aGlzLnByb3BzLnJlc3BvbnNlVHlwZXMgPz8gW0h0dHBMYW1iZGFSZXNwb25zZVR5cGUuSUFNXTtcbiAgICAgIGNvbnN0IGVuYWJsZVNpbXBsZVJlc3BvbnNlcyA9IHJlc3BvbnNlVHlwZXMuaW5jbHVkZXMoSHR0cExhbWJkYVJlc3BvbnNlVHlwZS5TSU1QTEUpIHx8IHVuZGVmaW5lZDtcblxuICAgICAgdGhpcy5odHRwQXBpID0gb3B0aW9ucy5yb3V0ZS5odHRwQXBpO1xuICAgICAgdGhpcy5hdXRob3JpemVyID0gbmV3IEh0dHBBdXRob3JpemVyKG9wdGlvbnMuc2NvcGUsIGlkLCB7XG4gICAgICAgIGh0dHBBcGk6IG9wdGlvbnMucm91dGUuaHR0cEFwaSxcbiAgICAgICAgaWRlbnRpdHlTb3VyY2U6IHRoaXMucHJvcHMuaWRlbnRpdHlTb3VyY2UgPz8gW1xuICAgICAgICAgICckcmVxdWVzdC5oZWFkZXIuQXV0aG9yaXphdGlvbicsXG4gICAgICAgIF0sXG4gICAgICAgIHR5cGU6IEh0dHBBdXRob3JpemVyVHlwZS5MQU1CREEsXG4gICAgICAgIGF1dGhvcml6ZXJOYW1lOiB0aGlzLnByb3BzLmF1dGhvcml6ZXJOYW1lLFxuICAgICAgICBlbmFibGVTaW1wbGVSZXNwb25zZXMsXG4gICAgICAgIHBheWxvYWRGb3JtYXRWZXJzaW9uOiBlbmFibGVTaW1wbGVSZXNwb25zZXMgPyBBdXRob3JpemVyUGF5bG9hZFZlcnNpb24uVkVSU0lPTl8yXzAgOiBBdXRob3JpemVyUGF5bG9hZFZlcnNpb24uVkVSU0lPTl8xXzAsXG4gICAgICAgIGF1dGhvcml6ZXJVcmk6IGxhbWJkYUF1dGhvcml6ZXJBcm4odGhpcy5wcm9wcy5oYW5kbGVyKSxcbiAgICAgICAgcmVzdWx0c0NhY2hlVHRsOiB0aGlzLnByb3BzLnJlc3VsdHNDYWNoZVR0bCA/PyBEdXJhdGlvbi5taW51dGVzKDUpLFxuICAgICAgfSk7XG5cbiAgICAgIHRoaXMucHJvcHMuaGFuZGxlci5hZGRQZXJtaXNzaW9uKGAke05hbWVzLm5vZGVVbmlxdWVJZCh0aGlzLmF1dGhvcml6ZXIubm9kZSl9LVBlcm1pc3Npb25gLCB7XG4gICAgICAgIHNjb3BlOiBvcHRpb25zLnNjb3BlLFxuICAgICAgICBwcmluY2lwYWw6IG5ldyBTZXJ2aWNlUHJpbmNpcGFsKCdhcGlnYXRld2F5LmFtYXpvbmF3cy5jb20nKSxcbiAgICAgICAgc291cmNlQXJuOiBTdGFjay5vZihvcHRpb25zLnJvdXRlKS5mb3JtYXRBcm4oe1xuICAgICAgICAgIHNlcnZpY2U6ICdleGVjdXRlLWFwaScsXG4gICAgICAgICAgcmVzb3VyY2U6IG9wdGlvbnMucm91dGUuaHR0cEFwaS5hcGlJZCxcbiAgICAgICAgICByZXNvdXJjZU5hbWU6IGBhdXRob3JpemVycy8ke3RoaXMuYXV0aG9yaXplci5hdXRob3JpemVySWR9YCxcbiAgICAgICAgfSksXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgYXV0aG9yaXplcklkOiB0aGlzLmF1dGhvcml6ZXIuYXV0aG9yaXplcklkLFxuICAgICAgYXV0aG9yaXphdGlvblR5cGU6ICdDVVNUT00nLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBjb25zdHJ1Y3RzIHRoZSBhdXRob3JpemVyVVJJQXJuLlxuICovXG5mdW5jdGlvbiBsYW1iZGFBdXRob3JpemVyQXJuKGhhbmRsZXI6IElGdW5jdGlvbikge1xuICByZXR1cm4gYGFybjoke1N0YWNrLm9mKGhhbmRsZXIpLnBhcnRpdGlvbn06YXBpZ2F0ZXdheToke1N0YWNrLm9mKGhhbmRsZXIpLnJlZ2lvbn06bGFtYmRhOnBhdGgvMjAxNS0wMy0zMS9mdW5jdGlvbnMvJHtoYW5kbGVyLmZ1bmN0aW9uQXJufS9pbnZvY2F0aW9uc2A7XG59XG4iXX0=