# Copyright 2015 Cisco Systems, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

""" This is an auto-generated module containing ManagedObject Meta information. """

from .imccoremeta import ImcVersion
from .imccoremeta import MoMeta


class VersionMeta:
    """ This class contains all the ImcVersion supported by this package."""
    Version151f = ImcVersion("1.5(1f)")
    Version151x = ImcVersion("1.5(1x)")
    Version152 = ImcVersion("152")
    Version153 = ImcVersion("153")
    Version154 = ImcVersion("154")
    Version2010b = ImcVersion("2.0(10b)")
    Version2013e = ImcVersion("2.0(13e)")
    Version201a = ImcVersion("2.0(1a)")
    Version202c = ImcVersion("2.0(2c)")
    Version203d = ImcVersion("2.0(3d)")
    Version204c = ImcVersion("2.0(4c)")
    Version208d = ImcVersion("2.0(8d)")
    Version209c = ImcVersion("2.0(9c)")
    Version301c = ImcVersion("3.0(1c)")
    Version302b = ImcVersion("3.0(2b)")
    Version303a = ImcVersion("3.0(3a)")
    Version304a = ImcVersion("3.0(4a)")
    Version311d = ImcVersion("3.1(1d)")
    Version312b = ImcVersion("3.1(2b)")
    Version401a = ImcVersion("4.0(1a)")
    Version402c = ImcVersion("4.0(2c)")
    Version404b = ImcVersion("4.0(4b)")
    Version411c = ImcVersion("4.1(1c)")
    Version411d = ImcVersion("4.1(1d)")
    Version412a = ImcVersion("4.1(2a)")
    Version413a = ImcVersion("4.1(3a)")
    Version421a = ImcVersion("4.2(1a)")

MO_CLASS_ID = frozenset([
    "AaaLdap",
    "AaaLdapRoleGroup",
    "AaaSession",
    "AaaTacacsPlus",
    "AaaTacacsPlusServer",
    "AaaUser",
    "AaaUserAuthPrecedence",
    "AaaUserEp",
    "AaaUserPasswordExpiration",
    "AaaUserPolicy",
    "AaaUserSSHKey",
    "ActivatePIDCatalog",
    "AdaptorCfgBackup",
    "AdaptorCfgImporter",
    "AdaptorConnectorInfo",
    "AdaptorEthCompQueueProfile",
    "AdaptorEthGenProfile",
    "AdaptorEthISCSIProfile",
    "AdaptorEthInterruptProfile",
    "AdaptorEthMultiQueueProfile",
    "AdaptorEthOffloadProfile",
    "AdaptorEthRdmaProfile",
    "AdaptorEthRecvQueueProfile",
    "AdaptorEthUSNICProfile",
    "AdaptorEthWorkQueueProfile",
    "AdaptorExtEthIf",
    "AdaptorExtIpV6RssHashProfile",
    "AdaptorFcBootTable",
    "AdaptorFcCdbWorkQueueProfile",
    "AdaptorFcErrorRecoveryProfile",
    "AdaptorFcGenProfile",
    "AdaptorFcInterruptProfile",
    "AdaptorFcPersistentBindings",
    "AdaptorFcPortFLogiProfile",
    "AdaptorFcPortPLogiProfile",
    "AdaptorFcPortProfile",
    "AdaptorFcRecvQueueProfile",
    "AdaptorFcWorkQueueProfile",
    "AdaptorGenProfile",
    "AdaptorHostEthIf",
    "AdaptorHostFcIf",
    "AdaptorIpV4RssHashProfile",
    "AdaptorIpV6RssHashProfile",
    "AdaptorLinkTraining",
    "AdaptorPortProfiles",
    "AdaptorRssProfile",
    "AdaptorUnit",
    "AdvancedPowerProfile",
    "BiosBOT",
    "BiosBootDev",
    "BiosBootDevGrp",
    "BiosBootDevPrecision",
    "BiosBootMode",
    "BiosPassword",
    "BiosPlatformDefaults",
    "BiosProfile",
    "BiosProfileManagement",
    "BiosProfileToken",
    "BiosSettings",
    "BiosUnit",
    "BiosVfASPMSupport",
    "BiosVfAdjacentCacheLinePrefetch",
    "BiosVfAdvancedMemTest",
    "BiosVfAltitude",
    "BiosVfAssertNMIOnPERR",
    "BiosVfAssertNMIOnSERR",
    "BiosVfAutoCCState",
    "BiosVfAutonumousCstateEnable",
    "BiosVfBmeDmaMitigation",
    "BiosVfBootOptionNumRetry",
    "BiosVfBootOptionReCoolDown",
    "BiosVfBootOptionRetry",
    "BiosVfBootPerformanceMode",
    "BiosVfBurstAndPostponedRefresh",
    "BiosVfCDNEnable",
    "BiosVfCDNSupport",
    "BiosVfCPUEnergyPerformance",
    "BiosVfCPUFrequencyFloor",
    "BiosVfCPUPerformance",
    "BiosVfCPUPowerManagement",
    "BiosVfCRQos",
    "BiosVfCbsCmnApbdis",
    "BiosVfCbsCmnCpuCpb",
    "BiosVfCbsCmnCpuGenDowncoreCtrl",
    "BiosVfCbsCmnCpuGlobalCstateCtrl",
    "BiosVfCbsCmnCpuL1StreamHwPrefetcher",
    "BiosVfCbsCmnCpuL2StreamHwPrefetcher",
    "BiosVfCbsCmnCpuSmee",
    "BiosVfCbsCmnCpuStreamingStoresCtrl",
    "BiosVfCbsCmnDeterminismSlider",
    "BiosVfCbsCmnEfficiencyModeEn",
    "BiosVfCbsCmnFixedSocPstate",
    "BiosVfCbsCmnGnbNbIOMMU",
    "BiosVfCbsCmnGnbSMUCPPC",
    "BiosVfCbsCmnGnbSMUDfCstates",
    "BiosVfCbsCmnMemCtrlBankGroupSwapDdr4",
    "BiosVfCbsCmnMemMapBankInterleaveDdr4",
    "BiosVfCbsCmncTDPCtl",
    "BiosVfCbsCpuCcdCtrlSsp",
    "BiosVfCbsCpuCoreCtrl",
    "BiosVfCbsCpuSmtCtrl",
    "BiosVfCbsDbgCpuSnpMemCover",
    "BiosVfCbsDbgCpuSnpMemSizeCover",
    "BiosVfCbsDfCmnAcpiSratL3Numa",
    "BiosVfCbsDfCmnDramNps",
    "BiosVfCbsDfCmnMemIntlv",
    "BiosVfCbsDfCmnMemIntlvSize",
    "BiosVfCbsSevSnpSupport",
    "BiosVfCiscoAdaptiveMemTraining",
    "BiosVfCiscoDebugLevel",
    "BiosVfCiscoOpromLaunchOptimization",
    "BiosVfCiscoXgmiMaxSpeed",
    "BiosVfCkeLowPolicy",
    "BiosVfClosedLoopThermThrotl",
    "BiosVfCmciEnable",
    "BiosVfConfigTDP",
    "BiosVfConfigTDPLevel",
    "BiosVfConsoleRedirection",
    "BiosVfCoreMultiProcessing",
    "BiosVfCrfastgoConfig",
    "BiosVfDCPMMFirmwareDowngrade",
    "BiosVfDCUPrefetch",
    "BiosVfDRAMClockThrottling",
    "BiosVfDemandScrub",
    "BiosVfDirectCacheAccess",
    "BiosVfDramRefreshRate",
    "BiosVfDramSwThermalThrottling",
    "BiosVfEPPEnable",
    "BiosVfEPPProfile",
    "BiosVfEadrSupport",
    "BiosVfEdpcEn",
    "BiosVfEnableClockSpreadSpec",
    "BiosVfEnableMktme",
    "BiosVfEnableTme",
    "BiosVfEnergyEfficientTurbo",
    "BiosVfEngPerfTuning",
    "BiosVfEnhancedIntelSpeedStepTech",
    "BiosVfEpochUpdate",
    "BiosVfExecuteDisableBit",
    "BiosVfExtendedAPIC",
    "BiosVfFRB2Enable",
    "BiosVfHWPMEnable",
    "BiosVfHardwarePrefetch",
    "BiosVfIMCInterleave",
    "BiosVfIOHResource",
    "BiosVfIPV4HTTP",
    "BiosVfIPV4PXE",
    "BiosVfIPV6HTTP",
    "BiosVfIPV6PXE",
    "BiosVfIntelDynamicSpeedSelect",
    "BiosVfIntelHyperThreadingTech",
    "BiosVfIntelSpeedSelect",
    "BiosVfIntelTurboBoostTech",
    "BiosVfIntelVTForDirectedIO",
    "BiosVfIntelVirtualizationTechnology",
    "BiosVfIohErrorEn",
    "BiosVfKTIPrefetch",
    "BiosVfLLCPrefetch",
    "BiosVfLOMPortOptionROM",
    "BiosVfLegacyUSBSupport",
    "BiosVfLvDIMMSupport",
    "BiosVfMMCFGBase",
    "BiosVfMemoryBandwidthBoost",
    "BiosVfMemoryInterleave",
    "BiosVfMemoryMappedIOAbove4GB",
    "BiosVfMemoryRefreshRate",
    "BiosVfMemorySizeLimit",
    "BiosVfMemoryThermalThrottling",
    "BiosVfMirroringMode",
    "BiosVfNUMAOptimized",
    "BiosVfNetworkStack",
    "BiosVfNvmdimmPerformConfig",
    "BiosVfOSBootWatchdogTimer",
    "BiosVfOSBootWatchdogTimerPolicy",
    "BiosVfOSBootWatchdogTimerTimeout",
    "BiosVfOnboardNIC",
    "BiosVfOnboardStorage",
    "BiosVfOnboardStorageSWStack",
    "BiosVfOperationMode",
    "BiosVfOutOfBandMgmtPort",
    "BiosVfPCIOptionROMs",
    "BiosVfPCISlotOptionROMEnable",
    "BiosVfPCIeRASSupport",
    "BiosVfPCIeSSDHotPlugSupport",
    "BiosVfPOSTErrorPause",
    "BiosVfPSata",
    "BiosVfPStateCoordType",
    "BiosVfPackageCStateLimit",
    "BiosVfPanicHighWatermark",
    "BiosVfPartialCacheLineSparing",
    "BiosVfPartialMirrorModeConfig",
    "BiosVfPartialMirrorPercent",
    "BiosVfPartialMirrorValue1",
    "BiosVfPartialMirrorValue2",
    "BiosVfPartialMirrorValue3",
    "BiosVfPartialMirrorValue4",
    "BiosVfPatrolScrub",
    "BiosVfPatrolScrubDuration",
    "BiosVfPchUsb30Mode",
    "BiosVfPciRomClp",
    "BiosVfPcieARISupport",
    "BiosVfPciePllSsc",
    "BiosVfPostPackageRepair",
    "BiosVfPowerOnPasswordSupport",
    "BiosVfProcessorC1E",
    "BiosVfProcessorC3Report",
    "BiosVfProcessorC6Report",
    "BiosVfProcessorCState",
    "BiosVfPwrPerfTuning",
    "BiosVfQPIConfig",
    "BiosVfQpiLinkSpeed",
    "BiosVfQpiSnoopMode",
    "BiosVfResumeOnACPowerLoss",
    "BiosVfSEV",
    "BiosVfSMEE",
    "BiosVfSataModeSelect",
    "BiosVfSelectMemoryRASConfiguration",
    "BiosVfSelectPprType",
    "BiosVfSerialPortAEnable",
    "BiosVfSgx",
    "BiosVfSgxEpoch",
    "BiosVfSgxLePubKeyHash",
    "BiosVfSinglePCTLEnable",
    "BiosVfSmtMode",
    "BiosVfSnoopyModeFor2LM",
    "BiosVfSnoopyModeForAD",
    "BiosVfSparingMode",
    "BiosVfSrIov",
    "BiosVfSubNumaClustering",
    "BiosVfSvmMode",
    "BiosVfTPMControl",
    "BiosVfTPMSupport",
    "BiosVfTSME",
    "BiosVfTXTSupport",
    "BiosVfUCSMBootOrderRuleControl",
    "BiosVfUFSDisable",
    "BiosVfUSBBootConfig",
    "BiosVfUSBEmulation",
    "BiosVfUSBPortsConfig",
    "BiosVfUmaBasedClustering",
    "BiosVfUsbXhciSupport",
    "BiosVfVMDEnable",
    "BiosVfVgaPriority",
    "BiosVfVolMemoryMode",
    "BiosVfWorkLoadConfig",
    "BiosVfXPTPrefetch",
    "CertificateManagement",
    "CloudDeviceConnectorEp",
    "CloudMgmtSvc",
    "CommHttp",
    "CommHttps",
    "CommIpmiLan",
    "CommKvm",
    "CommMailAlert",
    "CommNtpProvider",
    "CommRedfish",
    "CommSavedVMediaMap",
    "CommSnmp",
    "CommSnmpConfigCommit",
    "CommSnmpTrap",
    "CommSnmpUser",
    "CommSsh",
    "CommSvcEp",
    "CommSyslog",
    "CommSyslogClient",
    "CommVMedia",
    "CommVMediaMap",
    "ComputeBoard",
    "ComputeMbPowerStats",
    "ComputeRackUnit",
    "ComputeRackUnitMbTempStats",
    "CurrentCertificate",
    "DownloadClientCertificate",
    "DownloadClientPrivateKey",
    "DownloadLdapCACertificate",
    "DownloadRootCACertificate",
    "EndPoint",
    "EndPointCertificateChain",
    "EndPointRootCACertificate",
    "EndPointRootCACertificateInfo",
    "EquipmentFan",
    "EquipmentFanModule",
    "EquipmentIndicatorLed",
    "EquipmentLocatorLed",
    "EquipmentPsu",
    "EquipmentPsuColdRedundancy",
    "EquipmentPsuFan",
    "EquipmentRackEnclosure",
    "EquipmentTpm",
    "Error",
    "EventManagement",
    "ExportClientCertificate",
    "ExportClientPrivateKey",
    "ExportLdapCACertificate",
    "ExportRootCACertificate",
    "FanPolicy",
    "FaultInst",
    "FirmwareBootDefinition",
    "FirmwareBootUnit",
    "FirmwareRunning",
    "FirmwareUpdatable",
    "GenerateCertificateSigningRequest",
    "GenerateRandomPassword",
    "GeneratedStorageControllerKeyId",
    "GpuInventory",
    "GraphicsCard",
    "HuuController",
    "HuuFirmwareCatalog",
    "HuuFirmwareCatalogComponent",
    "HuuFirmwareComponent",
    "HuuFirmwareRunning",
    "HuuFirmwareUpdateCancel",
    "HuuFirmwareUpdateStatus",
    "HuuFirmwareUpdater",
    "HuuUpdateComponentStatus",
    "IodController",
    "IodSnapshotCancel",
    "IodSnapshotStart",
    "IodSnapshotStatus",
    "IpBlocking",
    "IpFiltering",
    "KmipManagement",
    "KmipServer",
    "KmipServerLogin",
    "LdapCACertificate",
    "LdapCACertificateManagement",
    "LsbootBootSecurity",
    "LsbootCdd",
    "LsbootDef",
    "LsbootDevPrecision",
    "LsbootEfi",
    "LsbootEmbeddedStorage",
    "LsbootHdd",
    "LsbootHttp",
    "LsbootIscsi",
    "LsbootLan",
    "LsbootLocalStorage",
    "LsbootNVMe",
    "LsbootPchStorage",
    "LsbootPxe",
    "LsbootSan",
    "LsbootSd",
    "LsbootStorage",
    "LsbootUefiShell",
    "LsbootUsb",
    "LsbootVMedia",
    "LsbootVirtualMedia",
    "MailRecipient",
    "MctpCertificateManagement",
    "MemoryArray",
    "MemoryPersistentMemoryBackup",
    "MemoryPersistentMemoryConfigResult",
    "MemoryPersistentMemoryConfiguration",
    "MemoryPersistentMemoryDimms",
    "MemoryPersistentMemoryGoal",
    "MemoryPersistentMemoryImporter",
    "MemoryPersistentMemoryLocalSecurity",
    "MemoryPersistentMemoryLogicalConfiguration",
    "MemoryPersistentMemoryLogicalNamespace",
    "MemoryPersistentMemoryNamespace",
    "MemoryPersistentMemoryNamespaceConfigResult",
    "MemoryPersistentMemoryRegion",
    "MemoryPersistentMemorySecurity",
    "MemoryPersistentMemoryUnit",
    "MemoryUnit",
    "MemoryUnitEnvStats",
    "MgmtBackup",
    "MgmtController",
    "MgmtIf",
    "MgmtImporter",
    "MgmtInventory",
    "MoInvKv",
    "MoKvInvHolder",
    "NetworkAdapterEthIf",
    "NetworkAdapterUnit",
    "OneTimeBootDevice",
    "OneTimePrecisionBootDevice",
    "OsiCancel",
    "OsiController",
    "OsiStart",
    "OsiStatus",
    "PciEquipSlot",
    "PciLink",
    "PciSwitch",
    "PidCatalog",
    "PidCatalogCpu",
    "PidCatalogDimm",
    "PidCatalogHdd",
    "PidCatalogPCIAdapter",
    "PlatformEventFilters",
    "PowerBudget",
    "PowerMonitor",
    "ProcessorEnvStats",
    "ProcessorUnit",
    "PsuRedundancyPolicy",
    "RackUnitPersonality",
    "SecureLdap",
    "SelfEncryptStorageController",
    "ServerUtilization",
    "SolIf",
    "StandardPowerProfile",
    "StorageController",
    "StorageControllerHealth",
    "StorageControllerNVMe",
    "StorageControllerNextConsistencyCheckSchedule",
    "StorageControllerNextPatrolReadSchedule",
    "StorageControllerProps",
    "StorageControllerSettings",
    "StorageFlexFlashController",
    "StorageFlexFlashControllerProps",
    "StorageFlexFlashOperationalProfile",
    "StorageFlexFlashPhysicalDrive",
    "StorageFlexFlashVirtualDrive",
    "StorageFlexFlashVirtualDriveImageMap",
    "StorageFlexMMC",
    "StorageFlexMMCDownloadFile",
    "StorageFlexMMCFile",
    "StorageFlexUtilController",
    "StorageFlexUtilHealth",
    "StorageFlexUtilOperationalProfile",
    "StorageFlexUtilPhysicalDrive",
    "StorageFlexUtilVirtualDrive",
    "StorageFlexUtilVirtualDriveImageMap",
    "StorageLocalDisk",
    "StorageLocalDiskProps",
    "StorageLocalDiskSlotEp",
    "StorageLocalDiskUsage",
    "StorageNVMePhysicalDrive",
    "StorageOperation",
    "StorageRaidBattery",
    "StorageSasExpander",
    "StorageUnusedLocalDisk",
    "StorageVirtualDrive",
    "StorageVirtualDriveCreatorUsingUnusedPhysicalDrive",
    "StorageVirtualDriveCreatorUsingVirtualDriveGroup",
    "StorageVirtualDriveWithDriveGroupSpace",
    "SuggestedStorageControllerSecurityKey",
    "SysdebugMEpLog",
    "SysdebugTechSupportExport",
    "SystemBoardUnit",
    "SystemIOController",
    "TopRoot",
    "TopSystem",
    "UploadBiosProfile",
    "UploadCertificate",
    "UploadEndPointRootCACertificate",
    "UploadExternalCertificate",
    "UploadExternalPrivateKey",
    "UploadPIDCatalog",
    "VicBackupAll",
    "VicImporterAll",
    "X86LiveDebug",
    "AdapterSecureUpdate",
    "AutoPowerProfile",
    "BmcResetReason",
    "ChassisPIDCatalog",
    "ChassisPowerBudget",
    "ChassisPowerMonitor",
    "ChassisPowerUtilization",
    "CommEpIpmiLan",
    "CommSvcRack",
    "ComputeServerNode",
    "ComputeServerNodeMbTempStats",
    "ComputeServerRef",
    "ComputeSharedIOMbPowerStats",
    "ComputeSharedIOMbTempStats",
    "CustomPowerProfile",
    "EquipmentChassis",
    "EquipmentChassisLocatorLed",
    "EquipmentSharedIOModule",
    "EquipmentSystemIOController",
    "GraphicsCardTemperature",
    "IoControllerNVMePhysicalDrive",
    "IoExpander",
    "MgmtBackupServer",
    "MgmtImporterServer",
    "SiocResetReason",
    "StorageEnclosure",
    "StorageEnclosureDisk",
    "StorageEnclosureDiskFwHelper",
    "StorageEnclosureDiskSlotEp",
    "StorageEnclosureDiskSlotZoneHelper",
    "StorageLocalDiskEp",
    "StorageSasUplink",
    "SystemIOControllerNVMe",
    "ThermalPowerProfile",
    ])


MO_CLASS_META = {
    "classic": {
        "AaaLdap": MoMeta("AaaLdap", "aaaLdap", "ldap-ext", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['aaaLdapRoleGroup', 'ldapCACertificateManagement', 'secureLdap'], ["Get", "Set"]),
        "AaaLdapRoleGroup": MoMeta("AaaLdapRoleGroup", "aaaLdapRoleGroup", "rolegroup-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaLdap'], [], ["Get", "Set"]),
        "AaaSession": MoMeta("AaaSession", "aaaSession", "term-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['aaaUserEp'], [], ["Get"]),
        "AaaTacacsPlus": MoMeta("AaaTacacsPlus", "aaaTacacsPlus", "tacacs-ext", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['aaaTacacsPlusServer'], [None]),
        "AaaTacacsPlusServer": MoMeta("AaaTacacsPlusServer", "aaaTacacsPlusServer", "server-[id]", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaTacacsPlus'], [], [None]),
        "AaaUser": MoMeta("AaaUser", "aaaUser", "user-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaUserEp'], ['aaaUserSSHKey'], ["Get", "Set"]),
        "AaaUserAuthPrecedence": MoMeta("AaaUserAuthPrecedence", "aaaUserAuthPrecedence", "auth-precedence", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['aaaUserEp'], [], [None]),
        "AaaUserEp": MoMeta("AaaUserEp", "aaaUserEp", "user-ext", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['aaaSession', 'aaaUser', 'aaaUserAuthPrecedence', 'aaaUserPasswordExpiration', 'aaaUserPolicy', 'generateRandomPassword'], ["Get"]),
        "AaaUserPasswordExpiration": MoMeta("AaaUserPasswordExpiration", "aaaUserPasswordExpiration", "password-expiration", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "user"], ['aaaUserEp'], [], ["Get", "Set"]),
        "AaaUserPolicy": MoMeta("AaaUserPolicy", "aaaUserPolicy", "policy", VersionMeta.Version209c, "InputOutput", 0x1, [], ["admin", "user"], ['aaaUserEp'], [], ["Get", "Set"]),
        "AaaUserSSHKey": MoMeta("AaaUserSSHKey", "aaaUserSSHKey", "ssh-key-[id]", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaUser'], [], [None]),
        "ActivatePIDCatalog": MoMeta("ActivatePIDCatalog", "activatePIDCatalog", "activate-catalog", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get", "Set"]),
        "AdaptorCfgBackup": MoMeta("AdaptorCfgBackup", "adaptorCfgBackup", "export-config", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Get", "Set"]),
        "AdaptorCfgImporter": MoMeta("AdaptorCfgImporter", "adaptorCfgImporter", "import-config", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Get", "Set"]),
        "AdaptorConnectorInfo": MoMeta("AdaptorConnectorInfo", "adaptorConnectorInfo", "connector-info", VersionMeta.Version204c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorExtEthIf'], [], ["Get"]),
        "AdaptorEthCompQueueProfile": MoMeta("AdaptorEthCompQueueProfile", "adaptorEthCompQueueProfile", "eth-comp-q", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthGenProfile": MoMeta("AdaptorEthGenProfile", "adaptorEthGenProfile", "general", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthISCSIProfile": MoMeta("AdaptorEthISCSIProfile", "adaptorEthISCSIProfile", "ethiscsi", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Add", "Get", "Remove", "Set"]),
        "AdaptorEthInterruptProfile": MoMeta("AdaptorEthInterruptProfile", "adaptorEthInterruptProfile", "eth-int", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthMultiQueueProfile": MoMeta("AdaptorEthMultiQueueProfile", "adaptorEthMultiQueueProfile", "eth-multi-q", VersionMeta.Version402c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], [None]),
        "AdaptorEthOffloadProfile": MoMeta("AdaptorEthOffloadProfile", "adaptorEthOffloadProfile", "eth-offload", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthRdmaProfile": MoMeta("AdaptorEthRdmaProfile", "adaptorEthRdmaProfile", "rdmaprofile", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthRecvQueueProfile": MoMeta("AdaptorEthRecvQueueProfile", "adaptorEthRecvQueueProfile", "eth-rcv-q", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthUSNICProfile": MoMeta("AdaptorEthUSNICProfile", "adaptorEthUSNICProfile", "ethusnic", VersionMeta.Version151x, "InputOutput", 0x1, [], ["admin"], ['adaptorHostEthIf'], [], ["Get", "Remove", "Set"]),
        "AdaptorEthWorkQueueProfile": MoMeta("AdaptorEthWorkQueueProfile", "adaptorEthWorkQueueProfile", "eth-work-q", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorExtEthIf": MoMeta("AdaptorExtEthIf", "adaptorExtEthIf", "ext-eth-[port_id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], ['adaptorConnectorInfo', 'adaptorLinkTraining', 'adaptorPortProfiles'], ["Get", "Set"]),
        "AdaptorExtIpV6RssHashProfile": MoMeta("AdaptorExtIpV6RssHashProfile", "adaptorExtIpV6RssHashProfile", "ext-ipv6-rss-hash", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorFcBootTable": MoMeta("AdaptorFcBootTable", "adaptorFcBootTable", "fcboot-[index]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Add", "Get", "Set"]),
        "AdaptorFcCdbWorkQueueProfile": MoMeta("AdaptorFcCdbWorkQueueProfile", "adaptorFcCdbWorkQueueProfile", "fc-cdb-work-q", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcErrorRecoveryProfile": MoMeta("AdaptorFcErrorRecoveryProfile", "adaptorFcErrorRecoveryProfile", "fc-err-rec", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcGenProfile": MoMeta("AdaptorFcGenProfile", "adaptorFcGenProfile", "general", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcInterruptProfile": MoMeta("AdaptorFcInterruptProfile", "adaptorFcInterruptProfile", "fc-int", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcPersistentBindings": MoMeta("AdaptorFcPersistentBindings", "adaptorFcPersistentBindings", "perbi-[index]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get"]),
        "AdaptorFcPortFLogiProfile": MoMeta("AdaptorFcPortFLogiProfile", "adaptorFcPortFLogiProfile", "fc-port-flogi", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcPortPLogiProfile": MoMeta("AdaptorFcPortPLogiProfile", "adaptorFcPortPLogiProfile", "fc-port-plogi", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcPortProfile": MoMeta("AdaptorFcPortProfile", "adaptorFcPortProfile", "fc-port", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcRecvQueueProfile": MoMeta("AdaptorFcRecvQueueProfile", "adaptorFcRecvQueueProfile", "fc-rcv-q", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcWorkQueueProfile": MoMeta("AdaptorFcWorkQueueProfile", "adaptorFcWorkQueueProfile", "fc-work-q", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorGenProfile": MoMeta("AdaptorGenProfile", "adaptorGenProfile", "general", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Get", "Set"]),
        "AdaptorHostEthIf": MoMeta("AdaptorHostEthIf", "adaptorHostEthIf", "host-eth-[name]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Add", "Get", "Remove", "Set"]),
        "AdaptorHostFcIf": MoMeta("AdaptorHostFcIf", "adaptorHostFcIf", "host-fc-[name]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], ['adaptorFcPersistentBindings'], ["Add", "Get", "Remove", "Set"]),
        "AdaptorIpV4RssHashProfile": MoMeta("AdaptorIpV4RssHashProfile", "adaptorIpV4RssHashProfile", "ipv4-rss-hash", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorIpV6RssHashProfile": MoMeta("AdaptorIpV6RssHashProfile", "adaptorIpV6RssHashProfile", "ipv6-rss-hash", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorLinkTraining": MoMeta("AdaptorLinkTraining", "adaptorLinkTraining", "link-training", VersionMeta.Version204c, "InputOutput", 0x1, [], ["admin", "user"], ['adaptorExtEthIf'], [], ["Get", "Set"]),
        "AdaptorPortProfiles": MoMeta("AdaptorPortProfiles", "adaptorPortProfiles", "port-profiles", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorExtEthIf'], [], ["Get"]),
        "AdaptorRssProfile": MoMeta("AdaptorRssProfile", "adaptorRssProfile", "rss", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorUnit": MoMeta("AdaptorUnit", "adaptorUnit", "adaptor-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['adaptorCfgBackup', 'adaptorCfgImporter', 'adaptorExtEthIf', 'adaptorHostEthIf', 'adaptorHostFcIf', 'faultInst', 'mgmtController'], ["Get", "Set"]),
        "AdvancedPowerProfile": MoMeta("AdvancedPowerProfile", "advancedPowerProfile", "advpwrprof", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['powerBudget'], [], ["Get", "Set"]),
        "BiosBOT": MoMeta("BiosBOT", "biosBOT", "bdgep", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], ['biosBootDevGrp', 'biosBootDevPrecision', 'biosBootMode'], ["Get"]),
        "BiosBootDev": MoMeta("BiosBootDev", "biosBootDev", "bdv-[order]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosBootDevGrp'], [], ["Get"]),
        "BiosBootDevGrp": MoMeta("BiosBootDevGrp", "biosBootDevGrp", "bdg-[order]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosBOT'], ['biosBootDev'], ["Get"]),
        "BiosBootDevPrecision": MoMeta("BiosBootDevPrecision", "biosBootDevPrecision", "bdvp-[order]", VersionMeta.Version201a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosBOT'], [], ["Get"]),
        "BiosBootMode": MoMeta("BiosBootMode", "biosBootMode", "boot-mode", VersionMeta.Version201a, "OutputOnly", 0x1, [], ["admin", "user"], ['biosBOT'], [], ["Get"]),
        "BiosPassword": MoMeta("BiosPassword", "biosPassword", "bios-pw", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
        "BiosPlatformDefaults": MoMeta("BiosPlatformDefaults", "biosPlatformDefaults", "bios-defaults", VersionMeta.Version151x, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], ['biosVfASPMSupport', 'biosVfAdjacentCacheLinePrefetch', 'biosVfAdvancedMemTest', 'biosVfAltitude', 'biosVfAssertNMIOnPERR', 'biosVfAssertNMIOnSERR', 'biosVfAutoCCState', 'biosVfAutonumousCstateEnable', 'biosVfBmeDmaMitigation', 'biosVfBootOptionNumRetry', 'biosVfBootOptionReCoolDown', 'biosVfBootOptionRetry', 'biosVfBootPerformanceMode', 'biosVfBurstAndPostponedRefresh', 'biosVfCDNEnable', 'biosVfCDNSupport', 'biosVfCPUEnergyPerformance', 'biosVfCPUFrequencyFloor', 'biosVfCPUPerformance', 'biosVfCPUPowerManagement', 'biosVfCRQos', 'biosVfCbsCmnApbdis', 'biosVfCbsCmnCpuCpb', 'biosVfCbsCmnCpuGenDowncoreCtrl', 'biosVfCbsCmnCpuGlobalCstateCtrl', 'biosVfCbsCmnCpuL1StreamHwPrefetcher', 'biosVfCbsCmnCpuL2StreamHwPrefetcher', 'biosVfCbsCmnCpuSmee', 'biosVfCbsCmnCpuStreamingStoresCtrl', 'biosVfCbsCmnDeterminismSlider', 'biosVfCbsCmnEfficiencyModeEn', 'biosVfCbsCmnFixedSocPstate', 'biosVfCbsCmnGnbNbIOMMU', 'biosVfCbsCmnGnbSMUCPPC', 'biosVfCbsCmnGnbSMUDfCstates', 'biosVfCbsCmnMemCtrlBankGroupSwapDdr4', 'biosVfCbsCmnMemMapBankInterleaveDdr4', 'biosVfCbsCmncTDPCtl', 'biosVfCbsCpuCcdCtrlSsp', 'biosVfCbsCpuCoreCtrl', 'biosVfCbsCpuSmtCtrl', 'biosVfCbsDbgCpuSnpMemCover', 'biosVfCbsDbgCpuSnpMemSizeCover', 'biosVfCbsDfCmnAcpiSratL3Numa', 'biosVfCbsDfCmnDramNps', 'biosVfCbsDfCmnMemIntlv', 'biosVfCbsDfCmnMemIntlvSize', 'biosVfCbsSevSnpSupport', 'biosVfCiscoAdaptiveMemTraining', 'biosVfCiscoDebugLevel', 'biosVfCiscoOpromLaunchOptimization', 'biosVfCiscoXgmiMaxSpeed', 'biosVfCkeLowPolicy', 'biosVfClosedLoopThermThrotl', 'biosVfCmciEnable', 'biosVfConfigTDP', 'biosVfConfigTDPLevel', 'biosVfConsoleRedirection', 'biosVfCoreMultiProcessing', 'biosVfCrfastgoConfig', 'biosVfDCPMMFirmwareDowngrade', 'biosVfDCUPrefetch', 'biosVfDRAMClockThrottling', 'biosVfDemandScrub', 'biosVfDirectCacheAccess', 'biosVfDramRefreshRate', 'biosVfDramSwThermalThrottling', 'biosVfEPPEnable', 'biosVfEPPProfile', 'biosVfEadrSupport', 'biosVfEdpcEn', 'biosVfEnableClockSpreadSpec', 'biosVfEnableMktme', 'biosVfEnableTme', 'biosVfEnergyEfficientTurbo', 'biosVfEngPerfTuning', 'biosVfEnhancedIntelSpeedStepTech', 'biosVfEpochUpdate', 'biosVfExecuteDisableBit', 'biosVfExtendedAPIC', 'biosVfFRB2Enable', 'biosVfHWPMEnable', 'biosVfHardwarePrefetch', 'biosVfIMCInterleave', 'biosVfIOHResource', 'biosVfIPV4HTTP', 'biosVfIPV4PXE', 'biosVfIPV6HTTP', 'biosVfIPV6PXE', 'biosVfIntelDynamicSpeedSelect', 'biosVfIntelHyperThreadingTech', 'biosVfIntelSpeedSelect', 'biosVfIntelTurboBoostTech', 'biosVfIntelVTForDirectedIO', 'biosVfIntelVirtualizationTechnology', 'biosVfIohErrorEn', 'biosVfKTIPrefetch', 'biosVfLLCPrefetch', 'biosVfLOMPortOptionROM', 'biosVfLegacyUSBSupport', 'biosVfLvDIMMSupport', 'biosVfMMCFGBase', 'biosVfMemoryBandwidthBoost', 'biosVfMemoryInterleave', 'biosVfMemoryMappedIOAbove4GB', 'biosVfMemoryRefreshRate', 'biosVfMemorySizeLimit', 'biosVfMemoryThermalThrottling', 'biosVfMirroringMode', 'biosVfNUMAOptimized', 'biosVfNetworkStack', 'biosVfNvmdimmPerformConfig', 'biosVfOSBootWatchdogTimer', 'biosVfOSBootWatchdogTimerPolicy', 'biosVfOSBootWatchdogTimerTimeout', 'biosVfOnboardNIC', 'biosVfOnboardStorage', 'biosVfOnboardStorageSWStack', 'biosVfOperationMode', 'biosVfOutOfBandMgmtPort', 'biosVfPCIOptionROMs', 'biosVfPCISlotOptionROMEnable', 'biosVfPCIeRASSupport', 'biosVfPCIeSSDHotPlugSupport', 'biosVfPOSTErrorPause', 'biosVfPSata', 'biosVfPStateCoordType', 'biosVfPackageCStateLimit', 'biosVfPanicHighWatermark', 'biosVfPartialCacheLineSparing', 'biosVfPartialMirrorModeConfig', 'biosVfPartialMirrorPercent', 'biosVfPartialMirrorValue1', 'biosVfPartialMirrorValue2', 'biosVfPartialMirrorValue3', 'biosVfPartialMirrorValue4', 'biosVfPatrolScrub', 'biosVfPatrolScrubDuration', 'biosVfPchUsb30Mode', 'biosVfPciRomClp', 'biosVfPcieARISupport', 'biosVfPciePllSsc', 'biosVfPostPackageRepair', 'biosVfPowerOnPasswordSupport', 'biosVfProcessorC1E', 'biosVfProcessorC3Report', 'biosVfProcessorC6Report', 'biosVfProcessorCState', 'biosVfPwrPerfTuning', 'biosVfQPIConfig', 'biosVfQpiLinkSpeed', 'biosVfQpiSnoopMode', 'biosVfSEV', 'biosVfSMEE', 'biosVfSataModeSelect', 'biosVfSelectMemoryRASConfiguration', 'biosVfSelectPprType', 'biosVfSerialPortAEnable', 'biosVfSgx', 'biosVfSgxEpoch', 'biosVfSgxLePubKeyHash', 'biosVfSinglePCTLEnable', 'biosVfSmtMode', 'biosVfSnoopyModeFor2LM', 'biosVfSnoopyModeForAD', 'biosVfSparingMode', 'biosVfSrIov', 'biosVfSubNumaClustering', 'biosVfSvmMode', 'biosVfTPMControl', 'biosVfTPMSupport', 'biosVfTSME', 'biosVfTXTSupport', 'biosVfUCSMBootOrderRuleControl', 'biosVfUFSDisable', 'biosVfUSBBootConfig', 'biosVfUSBEmulation', 'biosVfUSBPortsConfig', 'biosVfUmaBasedClustering', 'biosVfUsbXhciSupport', 'biosVfVMDEnable', 'biosVfVgaPriority', 'biosVfVolMemoryMode', 'biosVfWorkLoadConfig', 'biosVfXPTPrefetch'], ["Get"]),
        "BiosProfile": MoMeta("BiosProfile", "biosProfile", "bios-profile-[name]", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosProfileManagement'], ['biosProfileToken'], ["Get", "Set"]),
        "BiosProfileManagement": MoMeta("BiosProfileManagement", "biosProfileManagement", "profile-mgmt", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], ['biosProfile', 'uploadBiosProfile'], ["Get", "Set"]),
        "BiosProfileToken": MoMeta("BiosProfileToken", "biosProfileToken", "token-[name]", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosProfile'], [], ["Get"]),
        "BiosSettings": MoMeta("BiosSettings", "biosSettings", "bios-settings", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], [], ["Get"]),
        "BiosUnit": MoMeta("BiosUnit", "biosUnit", "bios", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['biosBOT', 'biosPlatformDefaults', 'biosProfileManagement', 'biosSettings', 'firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable'], ["Get", "Set"]),
        "BiosVfASPMSupport": MoMeta("BiosVfASPMSupport", "biosVfASPMSupport", "ASPM-Support", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAdjacentCacheLinePrefetch": MoMeta("BiosVfAdjacentCacheLinePrefetch", "biosVfAdjacentCacheLinePrefetch", "Adjacent-Cache-Line-Prefetch", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAdvancedMemTest": MoMeta("BiosVfAdvancedMemTest", "biosVfAdvancedMemTest", "Advanced-Memory-Test", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfAltitude": MoMeta("BiosVfAltitude", "biosVfAltitude", "Altitude-Param", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAssertNMIOnPERR": MoMeta("BiosVfAssertNMIOnPERR", "biosVfAssertNMIOnPERR", "Assert-NMI-on-PERR", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAssertNMIOnSERR": MoMeta("BiosVfAssertNMIOnSERR", "biosVfAssertNMIOnSERR", "Assert-NMI-on-SERR", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAutoCCState": MoMeta("BiosVfAutoCCState", "biosVfAutoCCState", "auto-cc-state", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfAutonumousCstateEnable": MoMeta("BiosVfAutonumousCstateEnable", "biosVfAutonumousCstateEnable", "Autonumous-Cstate-Enable", VersionMeta.Version2010b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfBmeDmaMitigation": MoMeta("BiosVfBmeDmaMitigation", "biosVfBmeDmaMitigation", "bme-dma-mitigation", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfBootOptionNumRetry": MoMeta("BiosVfBootOptionNumRetry", "biosVfBootOptionNumRetry", "Boot-option-num-retry", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfBootOptionReCoolDown": MoMeta("BiosVfBootOptionReCoolDown", "biosVfBootOptionReCoolDown", "Boot-option-cool-down-retry", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfBootOptionRetry": MoMeta("BiosVfBootOptionRetry", "biosVfBootOptionRetry", "Boot-option-retry", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfBootPerformanceMode": MoMeta("BiosVfBootPerformanceMode", "biosVfBootPerformanceMode", "Boot-Performance-Mode", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfBurstAndPostponedRefresh": MoMeta("BiosVfBurstAndPostponedRefresh", "biosVfBurstAndPostponedRefresh", "burst-and-postponed-refresh", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCDNEnable": MoMeta("BiosVfCDNEnable", "biosVfCDNEnable", "CDN-Enable", VersionMeta.Version204c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCDNSupport": MoMeta("BiosVfCDNSupport", "biosVfCDNSupport", "CDN-Support", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUEnergyPerformance": MoMeta("BiosVfCPUEnergyPerformance", "biosVfCPUEnergyPerformance", "CPU-EngPerfBias", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUFrequencyFloor": MoMeta("BiosVfCPUFrequencyFloor", "biosVfCPUFrequencyFloor", "CPU-FreqFloor", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUPerformance": MoMeta("BiosVfCPUPerformance", "biosVfCPUPerformance", "CPU-Performance", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUPowerManagement": MoMeta("BiosVfCPUPowerManagement", "biosVfCPUPowerManagement", "CPU-PowerManagement", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCRQos": MoMeta("BiosVfCRQos", "biosVfCRQos", "CR-Qos", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnApbdis": MoMeta("BiosVfCbsCmnApbdis", "biosVfCbsCmnApbdis", "apbdis", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnCpuCpb": MoMeta("BiosVfCbsCmnCpuCpb", "biosVfCbsCmnCpuCpb", "cpu-cpb", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnCpuGenDowncoreCtrl": MoMeta("BiosVfCbsCmnCpuGenDowncoreCtrl", "biosVfCbsCmnCpuGenDowncoreCtrl", "downcore-ctrl", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnCpuGlobalCstateCtrl": MoMeta("BiosVfCbsCmnCpuGlobalCstateCtrl", "biosVfCbsCmnCpuGlobalCstateCtrl", "cpu-cstate", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnCpuL1StreamHwPrefetcher": MoMeta("BiosVfCbsCmnCpuL1StreamHwPrefetcher", "biosVfCbsCmnCpuL1StreamHwPrefetcher", "cpu-l1-prefetch", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnCpuL2StreamHwPrefetcher": MoMeta("BiosVfCbsCmnCpuL2StreamHwPrefetcher", "biosVfCbsCmnCpuL2StreamHwPrefetcher", "cpu-l2-prefetch", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnCpuSmee": MoMeta("BiosVfCbsCmnCpuSmee", "biosVfCbsCmnCpuSmee", "cpu-smee", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnCpuStreamingStoresCtrl": MoMeta("BiosVfCbsCmnCpuStreamingStoresCtrl", "biosVfCbsCmnCpuStreamingStoresCtrl", "streaming-stores-control", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnDeterminismSlider": MoMeta("BiosVfCbsCmnDeterminismSlider", "biosVfCbsCmnDeterminismSlider", "cpu-detslider", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnEfficiencyModeEn": MoMeta("BiosVfCbsCmnEfficiencyModeEn", "biosVfCbsCmnEfficiencyModeEn", "Efficiency-Mode-En", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnFixedSocPstate": MoMeta("BiosVfCbsCmnFixedSocPstate", "biosVfCbsCmnFixedSocPstate", "fixed-soc-pstate", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnGnbNbIOMMU": MoMeta("BiosVfCbsCmnGnbNbIOMMU", "biosVfCbsCmnGnbNbIOMMU", "io-mmu", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnGnbSMUCPPC": MoMeta("BiosVfCbsCmnGnbSMUCPPC", "biosVfCbsCmnGnbSMUCPPC", "Smu-Cppc", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnGnbSMUDfCstates": MoMeta("BiosVfCbsCmnGnbSMUDfCstates", "biosVfCbsCmnGnbSMUDfCstates", "df-c-states", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnMemCtrlBankGroupSwapDdr4": MoMeta("BiosVfCbsCmnMemCtrlBankGroupSwapDdr4", "biosVfCbsCmnMemCtrlBankGroupSwapDdr4", "bank-groupswap", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmnMemMapBankInterleaveDdr4": MoMeta("BiosVfCbsCmnMemMapBankInterleaveDdr4", "biosVfCbsCmnMemMapBankInterleaveDdr4", "chipset-interleave", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCmncTDPCtl": MoMeta("BiosVfCbsCmncTDPCtl", "biosVfCbsCmncTDPCtl", "ctdp-control", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCpuCcdCtrlSsp": MoMeta("BiosVfCbsCpuCcdCtrlSsp", "biosVfCbsCpuCcdCtrlSsp", "ccd-control", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCpuCoreCtrl": MoMeta("BiosVfCbsCpuCoreCtrl", "biosVfCbsCpuCoreCtrl", "downcore-control", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsCpuSmtCtrl": MoMeta("BiosVfCbsCpuSmtCtrl", "biosVfCbsCpuSmtCtrl", "cpu-smt-mode", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsDbgCpuSnpMemCover": MoMeta("BiosVfCbsDbgCpuSnpMemCover", "biosVfCbsDbgCpuSnpMemCover", "Cpu-Snp-Mem-Cover", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsDbgCpuSnpMemSizeCover": MoMeta("BiosVfCbsDbgCpuSnpMemSizeCover", "biosVfCbsDbgCpuSnpMemSizeCover", "Cpu-Snp-Mem-Size-Cover", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsDfCmnAcpiSratL3Numa": MoMeta("BiosVfCbsDfCmnAcpiSratL3Numa", "biosVfCbsDfCmnAcpiSratL3Numa", "strat-l3-numa", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsDfCmnDramNps": MoMeta("BiosVfCbsDfCmnDramNps", "biosVfCbsDfCmnDramNps", "nodes-per-socket", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsDfCmnMemIntlv": MoMeta("BiosVfCbsDfCmnMemIntlv", "biosVfCbsDfCmnMemIntlv", "mem-interleave", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsDfCmnMemIntlvSize": MoMeta("BiosVfCbsDfCmnMemIntlvSize", "biosVfCbsDfCmnMemIntlvSize", "mem-size-interleave", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCbsSevSnpSupport": MoMeta("BiosVfCbsSevSnpSupport", "biosVfCbsSevSnpSupport", "Sev-Snp-Support", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCiscoAdaptiveMemTraining": MoMeta("BiosVfCiscoAdaptiveMemTraining", "biosVfCiscoAdaptiveMemTraining", "Cisco-Adap-Mem", VersionMeta.Version402c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCiscoDebugLevel": MoMeta("BiosVfCiscoDebugLevel", "biosVfCiscoDebugLevel", "Cisco-Debug-Level", VersionMeta.Version402c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCiscoOpromLaunchOptimization": MoMeta("BiosVfCiscoOpromLaunchOptimization", "biosVfCiscoOpromLaunchOptimization", "Cisco-Opromlaunch-Optimize", VersionMeta.Version402c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCiscoXgmiMaxSpeed": MoMeta("BiosVfCiscoXgmiMaxSpeed", "biosVfCiscoXgmiMaxSpeed", "xgmi-max-speed", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCkeLowPolicy": MoMeta("BiosVfCkeLowPolicy", "biosVfCkeLowPolicy", "Cke-Low-Policy", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfClosedLoopThermThrotl": MoMeta("BiosVfClosedLoopThermThrotl", "biosVfClosedLoopThermThrotl", "Closed-Loop-Therm-Throtl", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCmciEnable": MoMeta("BiosVfCmciEnable", "biosVfCmciEnable", "Cmci-Enable", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfConfigTDP": MoMeta("BiosVfConfigTDP", "biosVfConfigTDP", "Config-TDP", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfConfigTDPLevel": MoMeta("BiosVfConfigTDPLevel", "biosVfConfigTDPLevel", "Configurable-TDP-Level", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfConsoleRedirection": MoMeta("BiosVfConsoleRedirection", "biosVfConsoleRedirection", "Console-redirection", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCoreMultiProcessing": MoMeta("BiosVfCoreMultiProcessing", "biosVfCoreMultiProcessing", "Core-MultiProcessing", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCrfastgoConfig": MoMeta("BiosVfCrfastgoConfig", "biosVfCrfastgoConfig", "CR-FastGo-Config", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfDCPMMFirmwareDowngrade": MoMeta("BiosVfDCPMMFirmwareDowngrade", "biosVfDCPMMFirmwareDowngrade", "DCPMM-Firmware-Downgrade", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfDCUPrefetch": MoMeta("BiosVfDCUPrefetch", "biosVfDCUPrefetch", "DCU-Prefetch", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDRAMClockThrottling": MoMeta("BiosVfDRAMClockThrottling", "biosVfDRAMClockThrottling", "DRAM-Clock-Throttling", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDemandScrub": MoMeta("BiosVfDemandScrub", "biosVfDemandScrub", "Demand-Scrub-Param", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDirectCacheAccess": MoMeta("BiosVfDirectCacheAccess", "biosVfDirectCacheAccess", "Direct-Cache-Access", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDramRefreshRate": MoMeta("BiosVfDramRefreshRate", "biosVfDramRefreshRate", "dram-refresh-rate", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDramSwThermalThrottling": MoMeta("BiosVfDramSwThermalThrottling", "biosVfDramSwThermalThrottling", "DRAM-SW-Thermal-Throttling", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEPPEnable": MoMeta("BiosVfEPPEnable", "biosVfEPPEnable", "Processor-EPP-Enable", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEPPProfile": MoMeta("BiosVfEPPProfile", "biosVfEPPProfile", "epp-profile", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEadrSupport": MoMeta("BiosVfEadrSupport", "biosVfEadrSupport", "eADR-Support", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEdpcEn": MoMeta("BiosVfEdpcEn", "biosVfEdpcEn", "Edpc-En", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEnableClockSpreadSpec": MoMeta("BiosVfEnableClockSpreadSpec", "biosVfEnableClockSpreadSpec", "External-SSC-Enable", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEnableMktme": MoMeta("BiosVfEnableMktme", "biosVfEnableMktme", "Enable-Mktme", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEnableTme": MoMeta("BiosVfEnableTme", "biosVfEnableTme", "Enable-Time", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEnergyEfficientTurbo": MoMeta("BiosVfEnergyEfficientTurbo", "biosVfEnergyEfficientTurbo", "energy-efficient-turbo", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEngPerfTuning": MoMeta("BiosVfEngPerfTuning", "biosVfEngPerfTuning", "Eng-Perf-Tuning", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfEnhancedIntelSpeedStepTech": MoMeta("BiosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedIntelSpeedStepTech", "Enhanced-Intel-SpeedStep-Tech", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfEpochUpdate": MoMeta("BiosVfEpochUpdate", "biosVfEpochUpdate", "Epoch-Update", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfExecuteDisableBit": MoMeta("BiosVfExecuteDisableBit", "biosVfExecuteDisableBit", "Execute-Disable-Bit", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfExtendedAPIC": MoMeta("BiosVfExtendedAPIC", "biosVfExtendedAPIC", "Extended-APIC", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfFRB2Enable": MoMeta("BiosVfFRB2Enable", "biosVfFRB2Enable", "FRB2-Enable", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfHWPMEnable": MoMeta("BiosVfHWPMEnable", "biosVfHWPMEnable", "HWPM-Enable", VersionMeta.Version2010b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfHardwarePrefetch": MoMeta("BiosVfHardwarePrefetch", "biosVfHardwarePrefetch", "Hardware-Prefetch", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIMCInterleave": MoMeta("BiosVfIMCInterleave", "biosVfIMCInterleave", "imc-interleave", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIOHResource": MoMeta("BiosVfIOHResource", "biosVfIOHResource", "ioh-resource", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIPV4HTTP": MoMeta("BiosVfIPV4HTTP", "biosVfIPV4HTTP", "IPV4-HTTP-Support", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIPV4PXE": MoMeta("BiosVfIPV4PXE", "biosVfIPV4PXE", "IPv4-Pxe", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIPV6HTTP": MoMeta("BiosVfIPV6HTTP", "biosVfIPV6HTTP", "IPV6-HTTP-Support", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIPV6PXE": MoMeta("BiosVfIPV6PXE", "biosVfIPV6PXE", "IPv6-Pxe", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelDynamicSpeedSelect": MoMeta("BiosVfIntelDynamicSpeedSelect", "biosVfIntelDynamicSpeedSelect", "Intel-Dynamic-Speed-Select", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIntelHyperThreadingTech": MoMeta("BiosVfIntelHyperThreadingTech", "biosVfIntelHyperThreadingTech", "Intel-HyperThreading-Tech", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelSpeedSelect": MoMeta("BiosVfIntelSpeedSelect", "biosVfIntelSpeedSelect", "Intel-Speed-Select", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIntelTurboBoostTech": MoMeta("BiosVfIntelTurboBoostTech", "biosVfIntelTurboBoostTech", "Intel-Turbo-Boost-Tech", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelVTForDirectedIO": MoMeta("BiosVfIntelVTForDirectedIO", "biosVfIntelVTForDirectedIO", "Intel-VT-for-directed-IO", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelVirtualizationTechnology": MoMeta("BiosVfIntelVirtualizationTechnology", "biosVfIntelVirtualizationTechnology", "Intel-Virtualization-Technology", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIohErrorEn": MoMeta("BiosVfIohErrorEn", "biosVfIohErrorEn", "Ioh-Error-En", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfKTIPrefetch": MoMeta("BiosVfKTIPrefetch", "biosVfKTIPrefetch", "kti-prefetch", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLLCPrefetch": MoMeta("BiosVfLLCPrefetch", "biosVfLLCPrefetch", "LLC-Prefetch", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLOMPortOptionROM": MoMeta("BiosVfLOMPortOptionROM", "biosVfLOMPortOptionROM", "LOMPort-OptionROM", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLegacyUSBSupport": MoMeta("BiosVfLegacyUSBSupport", "biosVfLegacyUSBSupport", "LegacyUSB-Support", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLvDIMMSupport": MoMeta("BiosVfLvDIMMSupport", "biosVfLvDIMMSupport", "LvDIMM-Support", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMMCFGBase": MoMeta("BiosVfMMCFGBase", "biosVfMMCFGBase", "MMCFG-Base", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMemoryBandwidthBoost": MoMeta("BiosVfMemoryBandwidthBoost", "biosVfMemoryBandwidthBoost", "Memory-Bandwidth-Boost", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfMemoryInterleave": MoMeta("BiosVfMemoryInterleave", "biosVfMemoryInterleave", "Memory-Interleave", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMemoryMappedIOAbove4GB": MoMeta("BiosVfMemoryMappedIOAbove4GB", "biosVfMemoryMappedIOAbove4GB", "Memory-mapped-IO-above-4GB", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMemoryRefreshRate": MoMeta("BiosVfMemoryRefreshRate", "biosVfMemoryRefreshRate", "Memory-Refresh-Rate", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfMemorySizeLimit": MoMeta("BiosVfMemorySizeLimit", "biosVfMemorySizeLimit", "Memory-Size-Limit", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfMemoryThermalThrottling": MoMeta("BiosVfMemoryThermalThrottling", "biosVfMemoryThermalThrottling", "Memory-Thermal-Throttling-Mode", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfMirroringMode": MoMeta("BiosVfMirroringMode", "biosVfMirroringMode", "Mirroring-Mode", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfNUMAOptimized": MoMeta("BiosVfNUMAOptimized", "biosVfNUMAOptimized", "NUMA-optimized", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfNetworkStack": MoMeta("BiosVfNetworkStack", "biosVfNetworkStack", "Network-Stack", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfNvmdimmPerformConfig": MoMeta("BiosVfNvmdimmPerformConfig", "biosVfNvmdimmPerformConfig", "NVM-Performance-Setting", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfOSBootWatchdogTimer": MoMeta("BiosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimer", "OS-Boot-Watchdog-Timer-Param", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOSBootWatchdogTimerPolicy": MoMeta("BiosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerPolicy", "OS-Boot-Watchdog-Timer-Policy", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOSBootWatchdogTimerTimeout": MoMeta("BiosVfOSBootWatchdogTimerTimeout", "biosVfOSBootWatchdogTimerTimeout", "OS-Boot-Watchdog-Timer-Time-Out", VersionMeta.Version151x, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOnboardNIC": MoMeta("BiosVfOnboardNIC", "biosVfOnboardNIC", "Onboard-NIC", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOnboardStorage": MoMeta("BiosVfOnboardStorage", "biosVfOnboardStorage", "Onboard-Storage", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOnboardStorageSWStack": MoMeta("BiosVfOnboardStorageSWStack", "biosVfOnboardStorageSWStack", "Onboard-SCU-Storage-SWStack", VersionMeta.Version151x, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOperationMode": MoMeta("BiosVfOperationMode", "biosVfOperationMode", "Operation-Mode", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfOutOfBandMgmtPort": MoMeta("BiosVfOutOfBandMgmtPort", "biosVfOutOfBandMgmtPort", "OoB-MgmtPort", VersionMeta.Version154, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPCIOptionROMs": MoMeta("BiosVfPCIOptionROMs", "biosVfPCIOptionROMs", "PCI-OptionROMs", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPCISlotOptionROMEnable": MoMeta("BiosVfPCISlotOptionROMEnable", "biosVfPCISlotOptionROMEnable", "PCI-Slot-OptionROM-Enable", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPCIeRASSupport": MoMeta("BiosVfPCIeRASSupport", "biosVfPCIeRASSupport", "PCIe-RAS-Support", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPCIeSSDHotPlugSupport": MoMeta("BiosVfPCIeSSDHotPlugSupport", "biosVfPCIeSSDHotPlugSupport", "PCIeSSDHotPlugSupport", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPOSTErrorPause": MoMeta("BiosVfPOSTErrorPause", "biosVfPOSTErrorPause", "POST-error-pause", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPSata": MoMeta("BiosVfPSata", "biosVfPSata", "PSata", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPStateCoordType": MoMeta("BiosVfPStateCoordType", "biosVfPStateCoordType", "p-state-coord", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPackageCStateLimit": MoMeta("BiosVfPackageCStateLimit", "biosVfPackageCStateLimit", "Package-CState-Limit", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPanicHighWatermark": MoMeta("BiosVfPanicHighWatermark", "biosVfPanicHighWatermark", "Panic-and-High-Watermark", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialCacheLineSparing": MoMeta("BiosVfPartialCacheLineSparing", "biosVfPartialCacheLineSparing", "Partial-Cache-Line-Sparing", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorModeConfig": MoMeta("BiosVfPartialMirrorModeConfig", "biosVfPartialMirrorModeConfig", "Partial-Mirror-Mode", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorPercent": MoMeta("BiosVfPartialMirrorPercent", "biosVfPartialMirrorPercent", "Partial-Mirror-Percent", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue1": MoMeta("BiosVfPartialMirrorValue1", "biosVfPartialMirrorValue1", "Partial-Mirror-Value1", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue2": MoMeta("BiosVfPartialMirrorValue2", "biosVfPartialMirrorValue2", "Partial-Mirror-Value2", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue3": MoMeta("BiosVfPartialMirrorValue3", "biosVfPartialMirrorValue3", "Partial-Mirror-Value3", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue4": MoMeta("BiosVfPartialMirrorValue4", "biosVfPartialMirrorValue4", "Partial-Mirror-Value4", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPatrolScrub": MoMeta("BiosVfPatrolScrub", "biosVfPatrolScrub", "Patrol-Scrub-Param", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPatrolScrubDuration": MoMeta("BiosVfPatrolScrubDuration", "biosVfPatrolScrubDuration", "Patrol-Scrub-Duration", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPchUsb30Mode": MoMeta("BiosVfPchUsb30Mode", "biosVfPchUsb30Mode", "PchUsb30-Mode", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPciRomClp": MoMeta("BiosVfPciRomClp", "biosVfPciRomClp", "pci-rom-clp", VersionMeta.Version204c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPcieARISupport": MoMeta("BiosVfPcieARISupport", "biosVfPcieARISupport", "PCIe-ARI-Support", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPciePllSsc": MoMeta("BiosVfPciePllSsc", "biosVfPciePllSsc", "PCIe-PLL-SSC", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPostPackageRepair": MoMeta("BiosVfPostPackageRepair", "biosVfPostPackageRepair", "post-package-repair", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPowerOnPasswordSupport": MoMeta("BiosVfPowerOnPasswordSupport", "biosVfPowerOnPasswordSupport", "POP-Support", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorC1E": MoMeta("BiosVfProcessorC1E", "biosVfProcessorC1E", "Processor-C1E", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorC3Report": MoMeta("BiosVfProcessorC3Report", "biosVfProcessorC3Report", "Processor-C3-Report", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorC6Report": MoMeta("BiosVfProcessorC6Report", "biosVfProcessorC6Report", "Processor-C6-Report", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorCState": MoMeta("BiosVfProcessorCState", "biosVfProcessorCState", "Processor-C-State", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPwrPerfTuning": MoMeta("BiosVfPwrPerfTuning", "biosVfPwrPerfTuning", "Pwr-Perf-Tuning", VersionMeta.Version204c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfQPIConfig": MoMeta("BiosVfQPIConfig", "biosVfQPIConfig", "QPI-Config", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfQpiLinkSpeed": MoMeta("BiosVfQpiLinkSpeed", "biosVfQpiLinkSpeed", "UPI-Link-Frequency-Select", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfQpiSnoopMode": MoMeta("BiosVfQpiSnoopMode", "biosVfQpiSnoopMode", "QPI-Snoop-Mode", VersionMeta.Version204c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfResumeOnACPowerLoss": MoMeta("BiosVfResumeOnACPowerLoss", "biosVfResumeOnACPowerLoss", "Resume-on-AC-power-loss", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get", "Set"]),
        "BiosVfSEV": MoMeta("BiosVfSEV", "biosVfSEV", "SEV", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSMEE": MoMeta("BiosVfSMEE", "biosVfSMEE", "smee", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSataModeSelect": MoMeta("BiosVfSataModeSelect", "biosVfSataModeSelect", "Pch-Sata-Mode", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSelectMemoryRASConfiguration": MoMeta("BiosVfSelectMemoryRASConfiguration", "biosVfSelectMemoryRASConfiguration", "SelectMemory-RAS-configuration", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSelectPprType": MoMeta("BiosVfSelectPprType", "biosVfSelectPprType", "select-ppr-type", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSerialPortAEnable": MoMeta("BiosVfSerialPortAEnable", "biosVfSerialPortAEnable", "Serial-port-A-enable", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSgx": MoMeta("BiosVfSgx", "biosVfSgx", "Enable-Sgx", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSgxEpoch": MoMeta("BiosVfSgxEpoch", "biosVfSgxEpoch", "Sgx-Epoch", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSgxLePubKeyHash": MoMeta("BiosVfSgxLePubKeyHash", "biosVfSgxLePubKeyHash", "Sgx-Le-PubKeyHash", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSinglePCTLEnable": MoMeta("BiosVfSinglePCTLEnable", "biosVfSinglePCTLEnable", "Single-PCTL-Enable", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSmtMode": MoMeta("BiosVfSmtMode", "biosVfSmtMode", "smt-mode", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSnoopyModeFor2LM": MoMeta("BiosVfSnoopyModeFor2LM", "biosVfSnoopyModeFor2LM", "Snoopy-mode-for-2LM", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSnoopyModeForAD": MoMeta("BiosVfSnoopyModeForAD", "biosVfSnoopyModeForAD", "Snoopy-mode-for-AD", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSparingMode": MoMeta("BiosVfSparingMode", "biosVfSparingMode", "Sparing-Mode", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSrIov": MoMeta("BiosVfSrIov", "biosVfSrIov", "sr-iov", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSubNumaClustering": MoMeta("BiosVfSubNumaClustering", "biosVfSubNumaClustering", "sub-numa-cluster", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSvmMode": MoMeta("BiosVfSvmMode", "biosVfSvmMode", "svm-mode", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfTPMControl": MoMeta("BiosVfTPMControl", "biosVfTPMControl", "TPM-Control", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfTPMSupport": MoMeta("BiosVfTPMSupport", "biosVfTPMSupport", "TPM-Support", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfTSME": MoMeta("BiosVfTSME", "biosVfTSME", "TSME", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfTXTSupport": MoMeta("BiosVfTXTSupport", "biosVfTXTSupport", "TXT-Support", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfUCSMBootOrderRuleControl": MoMeta("BiosVfUCSMBootOrderRuleControl", "biosVfUCSMBootOrderRuleControl", "Boot-Order-Rules", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUFSDisable": MoMeta("BiosVfUFSDisable", "biosVfUFSDisable", "Uncore-Frequency-Scaling", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfUSBBootConfig": MoMeta("BiosVfUSBBootConfig", "biosVfUSBBootConfig", "USB-Boot-Config", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUSBEmulation": MoMeta("BiosVfUSBEmulation", "biosVfUSBEmulation", "USBEmulation-Support", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUSBPortsConfig": MoMeta("BiosVfUSBPortsConfig", "biosVfUSBPortsConfig", "USB-Ports-Config", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUmaBasedClustering": MoMeta("BiosVfUmaBasedClustering", "biosVfUmaBasedClustering", "Uma-based-clustering", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfUsbXhciSupport": MoMeta("BiosVfUsbXhciSupport", "biosVfUsbXhciSupport", "UsbXhci-Support", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfVMDEnable": MoMeta("BiosVfVMDEnable", "biosVfVMDEnable", "VMDEnable", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfVgaPriority": MoMeta("BiosVfVgaPriority", "biosVfVgaPriority", "VgaPriority", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfVolMemoryMode": MoMeta("BiosVfVolMemoryMode", "biosVfVolMemoryMode", "Vol-Memory-Mode", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfWorkLoadConfig": MoMeta("BiosVfWorkLoadConfig", "biosVfWorkLoadConfig", "work-load-config", VersionMeta.Version204c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfXPTPrefetch": MoMeta("BiosVfXPTPrefetch", "biosVfXPTPrefetch", "xpt-prefetch", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "CertificateManagement": MoMeta("CertificateManagement", "certificateManagement", "cert-mgmt", VersionMeta.Version209c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['currentCertificate', 'generateCertificateSigningRequest', 'uploadCertificate', 'uploadExternalCertificate', 'uploadExternalPrivateKey'], ["Get"]),
        "CloudDeviceConnectorEp": MoMeta("CloudDeviceConnectorEp", "cloudDeviceConnectorEp", "device-connector", VersionMeta.Version402c, "OutputOnly", 0x1, [], ["read-only"], ['cloudMgmtSvc'], ['faultInst', 'mgmtController'], [None]),
        "CloudMgmtSvc": MoMeta("CloudMgmtSvc", "cloudMgmtSvc", "cloud-mgmt", VersionMeta.Version402c, "OutputOnly", 0x1, [], ["read-only"], ['topSystem'], ['cloudDeviceConnectorEp'], [None]),
        "CommHttp": MoMeta("CommHttp", "commHttp", "http-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommHttps": MoMeta("CommHttps", "commHttps", "https-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommIpmiLan": MoMeta("CommIpmiLan", "commIpmiLan", "ipmi-lan-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommKvm": MoMeta("CommKvm", "commKvm", "kvm-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommMailAlert": MoMeta("CommMailAlert", "commMailAlert", "mail-alert-svc", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], ['mailRecipient'], ["Get", "Set"]),
        "CommNtpProvider": MoMeta("CommNtpProvider", "commNtpProvider", "ntp-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommRedfish": MoMeta("CommRedfish", "commRedfish", "redfish-svc", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommSavedVMediaMap": MoMeta("CommSavedVMediaMap", "commSavedVMediaMap", "saved-vmmap-[volume_name]", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commVMedia'], [], ["Get", "Remove", "Set"]),
        "CommSnmp": MoMeta("CommSnmp", "commSnmp", "snmp-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], ['commSnmpConfigCommit', 'commSnmpTrap', 'commSnmpUser'], ["Get", "Set"]),
        "CommSnmpConfigCommit": MoMeta("CommSnmpConfigCommit", "commSnmpConfigCommit", "snmp-config-commit", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSnmp'], [], [None]),
        "CommSnmpTrap": MoMeta("CommSnmpTrap", "commSnmpTrap", "snmp-trap-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSnmp'], [], ["Get", "Set"]),
        "CommSnmpUser": MoMeta("CommSnmpUser", "commSnmpUser", "snmpv3-user-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSnmp'], [], ["Get", "Set"]),
        "CommSsh": MoMeta("CommSsh", "commSsh", "ssh-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommSvcEp": MoMeta("CommSvcEp", "commSvcEp", "svc-ext", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['commHttp', 'commHttps', 'commIpmiLan', 'commKvm', 'commMailAlert', 'commNtpProvider', 'commRedfish', 'commSnmp', 'commSsh', 'commSyslog', 'commVMedia'], ["Get"]),
        "CommSyslog": MoMeta("CommSyslog", "commSyslog", "syslog", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], ['commSyslogClient'], ["Get", "Set"]),
        "CommSyslogClient": MoMeta("CommSyslogClient", "commSyslogClient", "client-[name]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSyslog'], [], ["Get"]),
        "CommVMedia": MoMeta("CommVMedia", "commVMedia", "vmedia-svc", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], ['commSavedVMediaMap', 'commVMediaMap'], ["Get", "Set"]),
        "CommVMediaMap": MoMeta("CommVMediaMap", "commVMediaMap", "vmmap-[volume_name]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commVMedia'], [], ["Add", "Get"]),
        "ComputeBoard": MoMeta("ComputeBoard", "computeBoard", "board", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['biosVfResumeOnACPowerLoss', 'computeMbPowerStats', 'computeRackUnitMbTempStats', 'equipmentTpm', 'fanPolicy', 'faultInst', 'graphicsCard', 'memoryArray', 'memoryPersistentMemoryConfiguration', 'memoryPersistentMemoryLogicalConfiguration', 'pciSwitch', 'pidCatalog', 'processorUnit', 'psuRedundancyPolicy', 'storageController', 'storageControllerNVMe', 'storageFlexFlashController', 'storageFlexMMC', 'storageFlexUtilController', 'storageLocalDiskSlotEp'], ["Get"]),
        "ComputeMbPowerStats": MoMeta("ComputeMbPowerStats", "computeMbPowerStats", "power-stats", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get"]),
        "ComputeRackUnit": MoMeta("ComputeRackUnit", "computeRackUnit", "rack-unit-[server_id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "user"], ['topSystem'], ['adaptorUnit', 'biosUnit', 'computeBoard', 'equipmentFanModule', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPsu', 'equipmentPsuColdRedundancy', 'eventManagement', 'faultInst', 'lsbootDef', 'lsbootDevPrecision', 'mgmtController', 'moKvInvHolder', 'networkAdapterUnit', 'oneTimeBootDevice', 'oneTimePrecisionBootDevice', 'pciEquipSlot', 'powerBudget', 'powerMonitor', 'rackUnitPersonality', 'serverUtilization', 'solIf', 'sysdebugTechSupportExport', 'systemIOController', 'x86LiveDebug'], ["Get", "Set"]),
        "ComputeRackUnitMbTempStats": MoMeta("ComputeRackUnitMbTempStats", "computeRackUnitMbTempStats", "temp-stats", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get"]),
        "CurrentCertificate": MoMeta("CurrentCertificate", "currentCertificate", "curr-cert", VersionMeta.Version209c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "DownloadClientCertificate": MoMeta("DownloadClientCertificate", "downloadClientCertificate", "kmip-client-cert-download", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "DownloadClientPrivateKey": MoMeta("DownloadClientPrivateKey", "downloadClientPrivateKey", "kmip-private-key-download", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "DownloadLdapCACertificate": MoMeta("DownloadLdapCACertificate", "downloadLdapCACertificate", "ldap-ca-cert-download", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['ldapCACertificateManagement'], [], ["Get"]),
        "DownloadRootCACertificate": MoMeta("DownloadRootCACertificate", "downloadRootCACertificate", "kmip-ca-cert-download", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "EndPoint": MoMeta("EndPoint", "endPoint", "ep-[slot_id]", VersionMeta.Version421a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['mctpCertificateManagement'], ['endPointCertificateChain'], [None]),
        "EndPointCertificateChain": MoMeta("EndPointCertificateChain", "endPointCertificateChain", "cert-chain-[depth]", VersionMeta.Version421a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['endPoint'], [], [None]),
        "EndPointRootCACertificate": MoMeta("EndPointRootCACertificate", "endPointRootCACertificate", "end-point-cert-[certificate_id]", VersionMeta.Version421a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['mctpCertificateManagement'], ['endPointRootCACertificateInfo'], [None]),
        "EndPointRootCACertificateInfo": MoMeta("EndPointRootCACertificateInfo", "endPointRootCACertificateInfo", "info", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['endPointRootCACertificate'], [], [None]),
        "EquipmentFan": MoMeta("EquipmentFan", "equipmentFan", "fan-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentFanModule'], ['faultInst'], ["Get"]),
        "EquipmentFanModule": MoMeta("EquipmentFanModule", "equipmentFanModule", "fan-module-[tray]-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['equipmentFan'], ["Get"]),
        "EquipmentIndicatorLed": MoMeta("EquipmentIndicatorLed", "equipmentIndicatorLed", "indicator-led-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get"]),
        "EquipmentLocatorLed": MoMeta("EquipmentLocatorLed", "equipmentLocatorLed", "locator-led", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get", "Set"]),
        "EquipmentPsu": MoMeta("EquipmentPsu", "equipmentPsu", "psu-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['equipmentPsuFan', 'faultInst'], ["Get"]),
        "EquipmentPsuColdRedundancy": MoMeta("EquipmentPsuColdRedundancy", "equipmentPsuColdRedundancy", "psu-cold-redundancy", VersionMeta.Version204c, "InputOutput", 0x1, [], ["admin"], ['computeRackUnit'], [], ["Get", "Set"]),
        "EquipmentPsuFan": MoMeta("EquipmentPsuFan", "equipmentPsuFan", "fan-[id]", VersionMeta.Version202c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentPsu'], [], ["Get"]),
        "EquipmentRackEnclosure": MoMeta("EquipmentRackEnclosure", "equipmentRackEnclosure", "sys/rack-enclosure-1", VersionMeta.Version401a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], [], [None]),
        "EquipmentTpm": MoMeta("EquipmentTpm", "equipmentTpm", "tpm", VersionMeta.Version201a, "OutputOnly", 0x1, [], ["read-only"], ['computeBoard'], [], ["Get"]),
        "Error": MoMeta("Error", "error", "", VersionMeta.Version151f, "OutputOnly", 0x1, [], [""], [], [], [None]),
        "EventManagement": MoMeta("EventManagement", "eventManagement", "event-management", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['platformEventFilters'], ["Get", "Set"]),
        "ExportClientCertificate": MoMeta("ExportClientCertificate", "exportClientCertificate", "kmip-client-cert-export", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "ExportClientPrivateKey": MoMeta("ExportClientPrivateKey", "exportClientPrivateKey", "kmip-private-key-export", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "ExportLdapCACertificate": MoMeta("ExportLdapCACertificate", "exportLdapCACertificate", "ldap-ca-cert-export", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['ldapCACertificateManagement'], [], ["Get"]),
        "ExportRootCACertificate": MoMeta("ExportRootCACertificate", "exportRootCACertificate", "kmip-ca-cert-export", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "FanPolicy": MoMeta("FanPolicy", "fanPolicy", "fan-policy", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get", "Set"]),
        "FaultInst": MoMeta("FaultInst", "faultInst", "fault-[code]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit', 'cloudDeviceConnectorEp', 'computeBoard', 'computeRackUnit', 'equipmentFan', 'equipmentPsu', 'memoryArray', 'memoryUnit', 'mgmtIf', 'pciEquipSlot', 'pciSwitch', 'powerBudget', 'processorUnit', 'storageController', 'storageControllerNVMe', 'storageFlexFlashController', 'storageFlexFlashPhysicalDrive', 'storageFlexFlashVirtualDrive', 'storageFlexUtilController', 'storageFlexUtilPhysicalDrive', 'storageFlexUtilVirtualDrive', 'storageLocalDisk', 'storageNVMePhysicalDrive', 'storageRaidBattery', 'storageVirtualDrive', 'sysdebugMEpLog'], [], ["Get"]),
        "FirmwareBootDefinition": MoMeta("FirmwareBootDefinition", "firmwareBootDefinition", "fw-boot-def", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit', 'mgmtController', 'storageController', 'systemIOController'], ['firmwareBootUnit'], ["Get"]),
        "FirmwareBootUnit": MoMeta("FirmwareBootUnit", "firmwareBootUnit", "bootunit-[type]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['firmwareBootDefinition'], [], ["Get", "Set"]),
        "FirmwareRunning": MoMeta("FirmwareRunning", "firmwareRunning", "fw-[deployment]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit', 'mgmtController', 'storageController', 'storageControllerNVMe', 'systemIOController'], [], ["Get"]),
        "FirmwareUpdatable": MoMeta("FirmwareUpdatable", "firmwareUpdatable", "fw-updatable", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosUnit', 'mgmtController', 'systemIOController'], [], ["Get"]),
        "GenerateCertificateSigningRequest": MoMeta("GenerateCertificateSigningRequest", "generateCertificateSigningRequest", "gen-csr-req", VersionMeta.Version209c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "GenerateRandomPassword": MoMeta("GenerateRandomPassword", "generateRandomPassword", "generate-random-pwd", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["admin", "user"], ['aaaUserEp'], [], ["Get"]),
        "GeneratedStorageControllerKeyId": MoMeta("GeneratedStorageControllerKeyId", "generatedStorageControllerKeyId", "gen-key-id", VersionMeta.Version209c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "GpuInventory": MoMeta("GpuInventory", "gpuInventory", "gpu-inv-[id]", VersionMeta.Version303a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pciEquipSlot'], [], ["Get"]),
        "GraphicsCard": MoMeta("GraphicsCard", "graphicsCard", "graphics-card-[id]", VersionMeta.Version402c, "OutputOnly", 0x1, [], ["read-only"], ['computeBoard'], [], [None]),
        "HuuController": MoMeta("HuuController", "huuController", "huu", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['huuFirmwareCatalog', 'huuFirmwareRunning', 'huuFirmwareUpdateCancel', 'huuFirmwareUpdater'], ["Get"]),
        "HuuFirmwareCatalog": MoMeta("HuuFirmwareCatalog", "huuFirmwareCatalog", "firmwareCatalog", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuController'], ['huuFirmwareCatalogComponent'], ["Get"]),
        "HuuFirmwareCatalogComponent": MoMeta("HuuFirmwareCatalogComponent", "huuFirmwareCatalogComponent", "id-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareCatalog'], [], ["Get"]),
        "HuuFirmwareComponent": MoMeta("HuuFirmwareComponent", "huuFirmwareComponent", "component-[component]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareRunning'], [], ["Get"]),
        "HuuFirmwareRunning": MoMeta("HuuFirmwareRunning", "huuFirmwareRunning", "currentFirmware", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuController'], ['huuFirmwareComponent'], ["Get"]),
        "HuuFirmwareUpdateCancel": MoMeta("HuuFirmwareUpdateCancel", "huuFirmwareUpdateCancel", "firmwareUpdateCancel", VersionMeta.Version152, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['huuController'], [], ["Get", "Set"]),
        "HuuFirmwareUpdateStatus": MoMeta("HuuFirmwareUpdateStatus", "huuFirmwareUpdateStatus", "updateStatus", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareUpdater'], ['huuUpdateComponentStatus'], ["Get"]),
        "HuuFirmwareUpdater": MoMeta("HuuFirmwareUpdater", "huuFirmwareUpdater", "firmwareUpdater", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['huuController'], [], ["Get"]),
        "HuuUpdateComponentStatus": MoMeta("HuuUpdateComponentStatus", "huuUpdateComponentStatus", "component-[component]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareUpdateStatus'], [], ["Get"]),
        "IodController": MoMeta("IodController", "iodController", "iod", VersionMeta.Version151x, "OutputOnly", 0x1, [], ["read-only"], ['topSystem'], ['iodSnapshotCancel', 'iodSnapshotStart', 'iodSnapshotStatus'], ["Get"]),
        "IodSnapshotCancel": MoMeta("IodSnapshotCancel", "iodSnapshotCancel", "snapshotCancel", VersionMeta.Version151x, "InputOutput", 0x1, [], ["admin"], ['iodController'], [], [None]),
        "IodSnapshotStart": MoMeta("IodSnapshotStart", "iodSnapshotStart", "snapshotStart", VersionMeta.Version151x, "InputOutput", 0x1, [], ["admin"], ['iodController'], [], [None]),
        "IodSnapshotStatus": MoMeta("IodSnapshotStatus", "iodSnapshotStatus", "snapshotStatus", VersionMeta.Version151x, "OutputOnly", 0x1, [], ["read-only"], ['iodController'], [], ["Get"]),
        "IpBlocking": MoMeta("IpBlocking", "ipBlocking", "ip-block", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mgmtIf'], [], ["Get", "Set"]),
        "IpFiltering": MoMeta("IpFiltering", "ipFiltering", "ip-filter", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mgmtIf'], [], ["Get", "Set"]),
        "KmipManagement": MoMeta("KmipManagement", "kmipManagement", "kmip-mgmt", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['downloadClientCertificate', 'downloadClientPrivateKey', 'downloadRootCACertificate', 'exportClientCertificate', 'exportClientPrivateKey', 'exportRootCACertificate', 'kmipServer', 'kmipServerLogin'], ["Get", "Set"]),
        "KmipServer": MoMeta("KmipServer", "kmipServer", "kmip-server-[id]", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], ["Get", "Set"]),
        "KmipServerLogin": MoMeta("KmipServerLogin", "kmipServerLogin", "kmip-login", VersionMeta.Version302b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], ["Get", "Set"]),
        "LdapCACertificate": MoMeta("LdapCACertificate", "ldapCACertificate", "ldap-ca-cert", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "user"], ['ldapCACertificateManagement'], [], ["Get", "Set"]),
        "LdapCACertificateManagement": MoMeta("LdapCACertificateManagement", "ldapCACertificateManagement", "ldap-ca-cert-mgmt", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "user"], ['aaaLdap'], ['downloadLdapCACertificate', 'exportLdapCACertificate', 'ldapCACertificate'], ["Get", "Set"]),
        "LsbootBootSecurity": MoMeta("LsbootBootSecurity", "lsbootBootSecurity", "boot-security", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "user"], ['lsbootDef'], [], ["Get", "Set"]),
        "LsbootCdd": MoMeta("LsbootCdd", "lsbootCdd", "cdd-[name]", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Get", "Set"]),
        "LsbootDef": MoMeta("LsbootDef", "lsbootDef", "boot-policy", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['lsbootBootSecurity', 'lsbootEfi', 'lsbootLan', 'lsbootStorage', 'lsbootVirtualMedia'], ["Get", "Set"]),
        "LsbootDevPrecision": MoMeta("LsbootDevPrecision", "lsbootDevPrecision", "boot-precision", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['lsbootCdd', 'lsbootEmbeddedStorage', 'lsbootHdd', 'lsbootHttp', 'lsbootIscsi', 'lsbootNVMe', 'lsbootPchStorage', 'lsbootPxe', 'lsbootSan', 'lsbootSd', 'lsbootUefiShell', 'lsbootUsb', 'lsbootVMedia'], ["Get", "Set"]),
        "LsbootEfi": MoMeta("LsbootEfi", "lsbootEfi", "efi-read-only", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootEmbeddedStorage": MoMeta("LsbootEmbeddedStorage", "lsbootEmbeddedStorage", "embeddedstorage-[name]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], [None]),
        "LsbootHdd": MoMeta("LsbootHdd", "lsbootHdd", "hdd-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootHttp": MoMeta("LsbootHttp", "lsbootHttp", "http-[name]", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], [None]),
        "LsbootIscsi": MoMeta("LsbootIscsi", "lsbootIscsi", "iscsi-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootLan": MoMeta("LsbootLan", "lsbootLan", "lan-read-only", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootLocalStorage": MoMeta("LsbootLocalStorage", "lsbootLocalStorage", "local-storage", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootStorage'], [], ["Get"]),
        "LsbootNVMe": MoMeta("LsbootNVMe", "lsbootNVMe", "nvme-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Get", "Set"]),
        "LsbootPchStorage": MoMeta("LsbootPchStorage", "lsbootPchStorage", "pchstorage-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootPxe": MoMeta("LsbootPxe", "lsbootPxe", "pxe-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootSan": MoMeta("LsbootSan", "lsbootSan", "san-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootSd": MoMeta("LsbootSd", "lsbootSd", "sd-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootStorage": MoMeta("LsbootStorage", "lsbootStorage", "storage-read-write", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootUefiShell": MoMeta("LsbootUefiShell", "lsbootUefiShell", "uefishell-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootUsb": MoMeta("LsbootUsb", "lsbootUsb", "usb-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootVMedia": MoMeta("LsbootVMedia", "lsbootVMedia", "vm-[name]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootVirtualMedia": MoMeta("LsbootVirtualMedia", "lsbootVirtualMedia", "vm-[access]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get"]),
        "MailRecipient": MoMeta("MailRecipient", "mailRecipient", "mail-recipient-[id]", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commMailAlert'], [], ["Get", "Remove", "Set"]),
        "MctpCertificateManagement": MoMeta("MctpCertificateManagement", "mctpCertificateManagement", "mctp-cert-mgmt", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['endPoint', 'endPointRootCACertificate', 'uploadEndPointRootCACertificate'], [None]),
        "MemoryArray": MoMeta("MemoryArray", "memoryArray", "memarray-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'memoryPersistentMemoryUnit', 'memoryUnit'], ["Get", "Set"]),
        "MemoryPersistentMemoryBackup": MoMeta("MemoryPersistentMemoryBackup", "memoryPersistentMemoryBackup", "export-config", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], [], [None]),
        "MemoryPersistentMemoryConfigResult": MoMeta("MemoryPersistentMemoryConfigResult", "memoryPersistentMemoryConfigResult", "cfg-result", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], ['memoryPersistentMemoryNamespaceConfigResult'], [None]),
        "MemoryPersistentMemoryConfiguration": MoMeta("MemoryPersistentMemoryConfiguration", "memoryPersistentMemoryConfiguration", "pmemory-config", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['memoryPersistentMemoryBackup', 'memoryPersistentMemoryConfigResult', 'memoryPersistentMemoryImporter', 'memoryPersistentMemoryRegion'], [None]),
        "MemoryPersistentMemoryDimms": MoMeta("MemoryPersistentMemoryDimms", "memoryPersistentMemoryDimms", "pmemory-dimms-[socket_id]", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], [], [None]),
        "MemoryPersistentMemoryGoal": MoMeta("MemoryPersistentMemoryGoal", "memoryPersistentMemoryGoal", "goal-[socket_id]", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], [], [None]),
        "MemoryPersistentMemoryImporter": MoMeta("MemoryPersistentMemoryImporter", "memoryPersistentMemoryImporter", "import-config", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], [], [None]),
        "MemoryPersistentMemoryLocalSecurity": MoMeta("MemoryPersistentMemoryLocalSecurity", "memoryPersistentMemoryLocalSecurity", "local", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemorySecurity'], [], [None]),
        "MemoryPersistentMemoryLogicalConfiguration": MoMeta("MemoryPersistentMemoryLogicalConfiguration", "memoryPersistentMemoryLogicalConfiguration", "pmemory-lconfig", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['memoryPersistentMemoryDimms', 'memoryPersistentMemoryGoal', 'memoryPersistentMemoryLogicalNamespace', 'memoryPersistentMemorySecurity'], [None]),
        "MemoryPersistentMemoryLogicalNamespace": MoMeta("MemoryPersistentMemoryLogicalNamespace", "memoryPersistentMemoryLogicalNamespace", "lns-[name]", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], [], [None]),
        "MemoryPersistentMemoryNamespace": MoMeta("MemoryPersistentMemoryNamespace", "memoryPersistentMemoryNamespace", "ns-[uuid]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryRegion'], [], [None]),
        "MemoryPersistentMemoryNamespaceConfigResult": MoMeta("MemoryPersistentMemoryNamespaceConfigResult", "memoryPersistentMemoryNamespaceConfigResult", "nscr-[name]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfigResult'], [], [None]),
        "MemoryPersistentMemoryRegion": MoMeta("MemoryPersistentMemoryRegion", "memoryPersistentMemoryRegion", "region-[id]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], ['memoryPersistentMemoryNamespace'], [None]),
        "MemoryPersistentMemorySecurity": MoMeta("MemoryPersistentMemorySecurity", "memoryPersistentMemorySecurity", "pmemory-security", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], ['memoryPersistentMemoryLocalSecurity'], [None]),
        "MemoryPersistentMemoryUnit": MoMeta("MemoryPersistentMemoryUnit", "memoryPersistentMemoryUnit", "pmem-[id]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryArray'], [], [None]),
        "MemoryUnit": MoMeta("MemoryUnit", "memoryUnit", "mem-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryArray'], ['faultInst', 'memoryUnitEnvStats'], ["Get"]),
        "MemoryUnitEnvStats": MoMeta("MemoryUnitEnvStats", "memoryUnitEnvStats", "dimm-env-stats", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryUnit'], [], ["Get"]),
        "MgmtBackup": MoMeta("MgmtBackup", "mgmtBackup", "export-config", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], [], [None]),
        "MgmtController": MoMeta("MgmtController", "mgmtController", "mgmt", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit', 'cloudDeviceConnectorEp', 'computeRackUnit', 'storageSasExpander'], ['firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable', 'mgmtIf', 'sysdebugMEpLog'], ["Get"]),
        "MgmtIf": MoMeta("MgmtIf", "mgmtIf", "if-1", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mgmtController'], ['faultInst', 'ipBlocking', 'ipFiltering'], ["Get", "Set"]),
        "MgmtImporter": MoMeta("MgmtImporter", "mgmtImporter", "import-config", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], [], [None]),
        "MgmtInventory": MoMeta("MgmtInventory", "mgmtInventory", "inventory", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], [], [None]),
        "MoInvKv": MoMeta("MoInvKv", "moInvKv", "kv-[key]", VersionMeta.Version401a, "OutputOnly", 0x1, [], ["read-only"], ['moKvInvHolder'], [], [None]),
        "MoKvInvHolder": MoMeta("MoKvInvHolder", "moKvInvHolder", "inv-kv-hostOs", VersionMeta.Version401a, "OutputOnly", 0x1, [], ["read-only"], ['computeRackUnit'], ['moInvKv'], [None]),
        "NetworkAdapterEthIf": MoMeta("NetworkAdapterEthIf", "networkAdapterEthIf", "eth-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['networkAdapterUnit'], [], ["Get"]),
        "NetworkAdapterUnit": MoMeta("NetworkAdapterUnit", "networkAdapterUnit", "network-adapter-[slot]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['networkAdapterEthIf'], ["Get"]),
        "OneTimeBootDevice": MoMeta("OneTimeBootDevice", "oneTimeBootDevice", "boot-one-time", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get", "Set"]),
        "OneTimePrecisionBootDevice": MoMeta("OneTimePrecisionBootDevice", "oneTimePrecisionBootDevice", "one-time-precision-boot", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get", "Set"]),
        "OsiCancel": MoMeta("OsiCancel", "osiCancel", "osiCancel", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin"], ['osiController'], [], [None]),
        "OsiController": MoMeta("OsiController", "osiController", "osi", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["read-only"], ['topSystem'], ['osiCancel', 'osiStart', 'osiStatus'], ["Get"]),
        "OsiStart": MoMeta("OsiStart", "osiStart", "osiStart", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin"], ['osiController'], [], ["Get"]),
        "OsiStatus": MoMeta("OsiStatus", "osiStatus", "osiStatus", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["read-only"], ['osiController'], [], ["Get"]),
        "PciEquipSlot": MoMeta("PciEquipSlot", "pciEquipSlot", "equipped-slot-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['faultInst', 'gpuInventory'], ["Get"]),
        "PciLink": MoMeta("PciLink", "pciLink", "pci-link-[adapter]", VersionMeta.Version402c, "OutputOnly", 0x1, [], ["read-only"], ['pciSwitch'], [], [None]),
        "PciSwitch": MoMeta("PciSwitch", "pciSwitch", "pci-switch-[id]", VersionMeta.Version402c, "OutputOnly", 0x1, [], ["read-only"], ['computeBoard'], ['faultInst', 'pciLink'], [None]),
        "PidCatalog": MoMeta("PidCatalog", "pidCatalog", "pid", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['activatePIDCatalog', 'pidCatalogCpu', 'pidCatalogDimm', 'pidCatalogHdd', 'pidCatalogPCIAdapter', 'uploadPIDCatalog'], ["Get"]),
        "PidCatalogCpu": MoMeta("PidCatalogCpu", "pidCatalogCpu", "pid-cpu-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PidCatalogDimm": MoMeta("PidCatalogDimm", "pidCatalogDimm", "pid-dimm-[name]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PidCatalogHdd": MoMeta("PidCatalogHdd", "pidCatalogHdd", "pid-hdd-[disk]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PidCatalogPCIAdapter": MoMeta("PidCatalogPCIAdapter", "pidCatalogPCIAdapter", "pid-pciadapter-[slot]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PlatformEventFilters": MoMeta("PlatformEventFilters", "platformEventFilters", "pef-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['eventManagement'], [], ["Get", "Set"]),
        "PowerBudget": MoMeta("PowerBudget", "powerBudget", "budget", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], ['advancedPowerProfile', 'faultInst', 'standardPowerProfile'], ["Get", "Set"]),
        "PowerMonitor": MoMeta("PowerMonitor", "powerMonitor", "pwrmonitor-[domain]", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get"]),
        "ProcessorEnvStats": MoMeta("ProcessorEnvStats", "processorEnvStats", "env-stats", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['processorUnit'], [], ["Get"]),
        "ProcessorUnit": MoMeta("ProcessorUnit", "processorUnit", "cpu-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'processorEnvStats'], ["Get"]),
        "PsuRedundancyPolicy": MoMeta("PsuRedundancyPolicy", "psuRedundancyPolicy", "psu-redundancy-policy", VersionMeta.Version401a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], [None]),
        "RackUnitPersonality": MoMeta("RackUnitPersonality", "rackUnitPersonality", "personality-[id]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], [None]),
        "SecureLdap": MoMeta("SecureLdap", "secureLdap", "secure-ldap", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaLdap'], [], [None]),
        "SelfEncryptStorageController": MoMeta("SelfEncryptStorageController", "selfEncryptStorageController", "ctr-self-encrypt", VersionMeta.Version209c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get", "Set"]),
        "ServerUtilization": MoMeta("ServerUtilization", "serverUtilization", "utilization", VersionMeta.Version202c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get"]),
        "SolIf": MoMeta("SolIf", "solIf", "sol-if", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get", "Set"]),
        "StandardPowerProfile": MoMeta("StandardPowerProfile", "standardPowerProfile", "stdpwrprof", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['powerBudget'], [], ["Get", "Set"]),
        "StorageController": MoMeta("StorageController", "storageController", "storage-[type]-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'generatedStorageControllerKeyId', 'selfEncryptStorageController', 'storageControllerHealth', 'storageControllerNextConsistencyCheckSchedule', 'storageControllerNextPatrolReadSchedule', 'storageControllerProps', 'storageControllerSettings', 'storageLocalDisk', 'storageLocalDiskProps', 'storageRaidBattery', 'storageVirtualDrive', 'storageVirtualDriveCreatorUsingUnusedPhysicalDrive', 'storageVirtualDriveCreatorUsingVirtualDriveGroup', 'suggestedStorageControllerSecurityKey'], ["Get", "Set"]),
        "StorageControllerHealth": MoMeta("StorageControllerHealth", "storageControllerHealth", "controller-health", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "StorageControllerNVMe": MoMeta("StorageControllerNVMe", "storageControllerNVMe", "storage-NVMe-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'firmwareRunning', 'storageNVMePhysicalDrive'], ["Get"]),
        "StorageControllerNextConsistencyCheckSchedule": MoMeta("StorageControllerNextConsistencyCheckSchedule", "storageControllerNextConsistencyCheckSchedule", "consistency-check", VersionMeta.Version401a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], [None]),
        "StorageControllerNextPatrolReadSchedule": MoMeta("StorageControllerNextPatrolReadSchedule", "storageControllerNextPatrolReadSchedule", "patrol-read", VersionMeta.Version401a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], [None]),
        "StorageControllerProps": MoMeta("StorageControllerProps", "storageControllerProps", "controller-props", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "StorageControllerSettings": MoMeta("StorageControllerSettings", "storageControllerSettings", "controller-settings", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "StorageFlexFlashController": MoMeta("StorageFlexFlashController", "storageFlexFlashController", "storage-flexflash-[id]", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'storageFlexFlashControllerProps', 'storageFlexFlashOperationalProfile', 'storageFlexFlashPhysicalDrive', 'storageFlexFlashVirtualDrive', 'storageFlexFlashVirtualDriveImageMap'], ["Get", "Set"]),
        "StorageFlexFlashControllerProps": MoMeta("StorageFlexFlashControllerProps", "storageFlexFlashControllerProps", "flexflashcontroller-props", VersionMeta.Version202c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], [], ["Get"]),
        "StorageFlexFlashOperationalProfile": MoMeta("StorageFlexFlashOperationalProfile", "storageFlexFlashOperationalProfile", "oper-profile", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], [], ["Get", "Set"]),
        "StorageFlexFlashPhysicalDrive": MoMeta("StorageFlexFlashPhysicalDrive", "storageFlexFlashPhysicalDrive", "card-[physical_drive_id]", VersionMeta.Version202c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], ['faultInst'], ["Get"]),
        "StorageFlexFlashVirtualDrive": MoMeta("StorageFlexFlashVirtualDrive", "storageFlexFlashVirtualDrive", "vd-[partition_id]", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], ['faultInst'], ["Get", "Set"]),
        "StorageFlexFlashVirtualDriveImageMap": MoMeta("StorageFlexFlashVirtualDriveImageMap", "storageFlexFlashVirtualDriveImageMap", "vdrive-map-[virtual_drive]", VersionMeta.Version202c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], [], ["Get", "Set"]),
        "StorageFlexMMC": MoMeta("StorageFlexMMC", "storageFlexMMC", "storage-flexmmc", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['storageFlexMMCDownloadFile', 'storageFlexMMCFile'], [None]),
        "StorageFlexMMCDownloadFile": MoMeta("StorageFlexMMCDownloadFile", "storageFlexMMCDownloadFile", "download-file", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexMMC'], [], [None]),
        "StorageFlexMMCFile": MoMeta("StorageFlexMMCFile", "storageFlexMMCFile", "file-[file_id]", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexMMC'], [], [None]),
        "StorageFlexUtilController": MoMeta("StorageFlexUtilController", "storageFlexUtilController", "storage-flexutil-[id]", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'storageFlexUtilHealth', 'storageFlexUtilOperationalProfile', 'storageFlexUtilPhysicalDrive', 'storageFlexUtilVirtualDrive', 'storageFlexUtilVirtualDriveImageMap'], ["Get", "Set"]),
        "StorageFlexUtilHealth": MoMeta("StorageFlexUtilHealth", "storageFlexUtilHealth", "health", VersionMeta.Version304a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageFlexUtilController'], [], ["Get"]),
        "StorageFlexUtilOperationalProfile": MoMeta("StorageFlexUtilOperationalProfile", "storageFlexUtilOperationalProfile", "oper-profile", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexUtilController'], [], ["Get", "Set"]),
        "StorageFlexUtilPhysicalDrive": MoMeta("StorageFlexUtilPhysicalDrive", "storageFlexUtilPhysicalDrive", "card-[physical_drive]", VersionMeta.Version304a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageFlexUtilController'], ['faultInst'], ["Get"]),
        "StorageFlexUtilVirtualDrive": MoMeta("StorageFlexUtilVirtualDrive", "storageFlexUtilVirtualDrive", "vd-[partition_name]", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexUtilController'], ['faultInst'], ["Get", "Set"]),
        "StorageFlexUtilVirtualDriveImageMap": MoMeta("StorageFlexUtilVirtualDriveImageMap", "storageFlexUtilVirtualDriveImageMap", "vdrive-map-[virtual_drive]", VersionMeta.Version304a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexUtilController'], [], ["Get", "Set"]),
        "StorageLocalDisk": MoMeta("StorageLocalDisk", "storageLocalDisk", "pd-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], ['faultInst', 'storageLocalDiskProps', 'storageOperation'], ["Get", "Set"]),
        "StorageLocalDiskProps": MoMeta("StorageLocalDiskProps", "storageLocalDiskProps", "general-props", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController', 'storageLocalDisk'], [], ["Get"]),
        "StorageLocalDiskSlotEp": MoMeta("StorageLocalDiskSlotEp", "storageLocalDiskSlotEp", "disk-[id]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get"]),
        "StorageLocalDiskUsage": MoMeta("StorageLocalDiskUsage", "storageLocalDiskUsage", "pd-[physical_drive]", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageVirtualDrive'], [], ["Get"]),
        "StorageNVMePhysicalDrive": MoMeta("StorageNVMePhysicalDrive", "storageNVMePhysicalDrive", "pd-[id]", VersionMeta.Version401a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageControllerNVMe'], ['faultInst'], ["Get"]),
        "StorageOperation": MoMeta("StorageOperation", "storageOperation", "storage-operation", VersionMeta.Version201a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageLocalDisk', 'storageVirtualDrive'], [], ["Get"]),
        "StorageRaidBattery": MoMeta("StorageRaidBattery", "storageRaidBattery", "raid-battery", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], ['faultInst'], ["Get", "Set"]),
        "StorageSasExpander": MoMeta("StorageSasExpander", "storageSasExpander", "sas-expander-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["read-only"], ['topSystem'], ['mgmtController'], ["Get"]),
        "StorageUnusedLocalDisk": MoMeta("StorageUnusedLocalDisk", "storageUnusedLocalDisk", "pd-[id]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageVirtualDriveCreatorUsingUnusedPhysicalDrive'], [], ["Get"]),
        "StorageVirtualDrive": MoMeta("StorageVirtualDrive", "storageVirtualDrive", "vd-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], ['faultInst', 'storageLocalDiskUsage', 'storageOperation'], ["Get", "Remove", "Set"]),
        "StorageVirtualDriveCreatorUsingUnusedPhysicalDrive": MoMeta("StorageVirtualDriveCreatorUsingUnusedPhysicalDrive", "storageVirtualDriveCreatorUsingUnusedPhysicalDrive", "virtual-drive-create", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin"], ['storageController'], ['storageUnusedLocalDisk'], ["Get", "Set"]),
        "StorageVirtualDriveCreatorUsingVirtualDriveGroup": MoMeta("StorageVirtualDriveCreatorUsingVirtualDriveGroup", "storageVirtualDriveCreatorUsingVirtualDriveGroup", "virtual-drive-carve", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin"], ['storageController'], ['storageVirtualDriveWithDriveGroupSpace'], ["Get", "Set"]),
        "StorageVirtualDriveWithDriveGroupSpace": MoMeta("StorageVirtualDriveWithDriveGroupSpace", "storageVirtualDriveWithDriveGroupSpace", "vd-[id]", VersionMeta.Version201a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageVirtualDriveCreatorUsingVirtualDriveGroup'], [], ["Get"]),
        "SuggestedStorageControllerSecurityKey": MoMeta("SuggestedStorageControllerSecurityKey", "suggestedStorageControllerSecurityKey", "suggested-sec-key", VersionMeta.Version209c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "SysdebugMEpLog": MoMeta("SysdebugMEpLog", "sysdebugMEpLog", "log-[type]-[id]", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mgmtController'], ['faultInst'], ["Get", "Set"]),
        "SysdebugTechSupportExport": MoMeta("SysdebugTechSupportExport", "sysdebugTechSupportExport", "tech-support", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], [None]),
        "SystemBoardUnit": MoMeta("SystemBoardUnit", "systemBoardUnit", "sys-board-unit", VersionMeta.Version311d, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], [], ["Get"]),
        "SystemIOController": MoMeta("SystemIOController", "systemIOController", "sioc-[id]", VersionMeta.Version202c, "OutputOnly", 0x1, [], ["read-only"], ['computeRackUnit'], ['firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable'], ["Get"]),
        "TopRoot": MoMeta("TopRoot", "topRoot", "", VersionMeta.Version151f, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], [], ['topSystem'], ["Get"]),
        "TopSystem": MoMeta("TopSystem", "topSystem", "sys", VersionMeta.Version151f, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topRoot'], ['aaaLdap', 'aaaTacacsPlus', 'aaaUserEp', 'certificateManagement', 'cloudMgmtSvc', 'commSvcEp', 'computeRackUnit', 'equipmentRackEnclosure', 'huuController', 'iodController', 'kmipManagement', 'mctpCertificateManagement', 'mgmtBackup', 'mgmtImporter', 'mgmtInventory', 'osiController', 'storageSasExpander', 'systemBoardUnit', 'vicBackupAll', 'vicImporterAll'], ["Get", "Set"]),
        "UploadBiosProfile": MoMeta("UploadBiosProfile", "uploadBiosProfile", "upload-bios-profile", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosProfileManagement'], [], [None]),
        "UploadCertificate": MoMeta("UploadCertificate", "uploadCertificate", "upload-cert", VersionMeta.Version209c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "UploadEndPointRootCACertificate": MoMeta("UploadEndPointRootCACertificate", "uploadEndPointRootCACertificate", "upload-end-point-cert", VersionMeta.Version421a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mctpCertificateManagement'], [], [None]),
        "UploadExternalCertificate": MoMeta("UploadExternalCertificate", "uploadExternalCertificate", "external-cert-upload", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "UploadExternalPrivateKey": MoMeta("UploadExternalPrivateKey", "uploadExternalPrivateKey", "external-pvt-key-upload", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "UploadPIDCatalog": MoMeta("UploadPIDCatalog", "uploadPIDCatalog", "upload-catalog", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "VicBackupAll": MoMeta("VicBackupAll", "vicBackupAll", "vic-all-exportconfig", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], [], ["Get", "Set"]),
        "VicImporterAll": MoMeta("VicImporterAll", "vicImporterAll", "vic-all-importconfig", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], [], ["Get", "Set"]),
        "X86LiveDebug": MoMeta("X86LiveDebug", "x86LiveDebug", "live-debug", VersionMeta.Version311d, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeRackUnit'], [], ["Get"]),
    },

    "modular": {
        "AaaLdap": MoMeta("AaaLdap", "aaaLdap", "ldap-ext", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['aaaLdapRoleGroup', 'ldapCACertificateManagement', 'secureLdap'], ["Get", "Set"]),
        "AaaLdapRoleGroup": MoMeta("AaaLdapRoleGroup", "aaaLdapRoleGroup", "rolegroup-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaLdap'], [], ["Get", "Set"]),
        "AaaSession": MoMeta("AaaSession", "aaaSession", "term-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['aaaUserEp'], [], ["Get"]),
        "AaaTacacsPlus": MoMeta("AaaTacacsPlus", "aaaTacacsPlus", "tacacs-ext", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['aaaTacacsPlusServer'], [None]),
        "AaaTacacsPlusServer": MoMeta("AaaTacacsPlusServer", "aaaTacacsPlusServer", "server-[id]", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaTacacsPlus'], [], [None]),
        "AaaUser": MoMeta("AaaUser", "aaaUser", "user-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaUserEp'], ['aaaUserSSHKey'], ["Get", "Set"]),
        "AaaUserAuthPrecedence": MoMeta("AaaUserAuthPrecedence", "aaaUserAuthPrecedence", "auth-precedence", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['aaaUserEp'], [], [None]),
        "AaaUserEp": MoMeta("AaaUserEp", "aaaUserEp", "user-ext", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['aaaSession', 'aaaUser', 'aaaUserAuthPrecedence', 'aaaUserPasswordExpiration', 'aaaUserPolicy', 'generateRandomPassword'], ["Get"]),
        "AaaUserPasswordExpiration": MoMeta("AaaUserPasswordExpiration", "aaaUserPasswordExpiration", "password-expiration", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "user"], ['aaaUserEp'], [], ["Get", "Set"]),
        "AaaUserPolicy": MoMeta("AaaUserPolicy", "aaaUserPolicy", "policy", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "user"], ['aaaUserEp'], [], ["Get", "Set"]),
        "AaaUserSSHKey": MoMeta("AaaUserSSHKey", "aaaUserSSHKey", "ssh-key-[id]", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaUser'], [], [None]),
        "ActivatePIDCatalog": MoMeta("ActivatePIDCatalog", "activatePIDCatalog", "activate-catalog", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get", "Set"]),
        "AdaptorCfgBackup": MoMeta("AdaptorCfgBackup", "adaptorCfgBackup", "export-config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Get", "Set"]),
        "AdaptorCfgImporter": MoMeta("AdaptorCfgImporter", "adaptorCfgImporter", "import-config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Get", "Set"]),
        "AdaptorConnectorInfo": MoMeta("AdaptorConnectorInfo", "adaptorConnectorInfo", "connector-info", VersionMeta.Version303a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorExtEthIf'], [], ["Get"]),
        "AdaptorEthCompQueueProfile": MoMeta("AdaptorEthCompQueueProfile", "adaptorEthCompQueueProfile", "eth-comp-q", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthGenProfile": MoMeta("AdaptorEthGenProfile", "adaptorEthGenProfile", "general", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthISCSIProfile": MoMeta("AdaptorEthISCSIProfile", "adaptorEthISCSIProfile", "ethiscsi", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Add", "Get", "Remove", "Set"]),
        "AdaptorEthInterruptProfile": MoMeta("AdaptorEthInterruptProfile", "adaptorEthInterruptProfile", "eth-int", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthMultiQueueProfile": MoMeta("AdaptorEthMultiQueueProfile", "adaptorEthMultiQueueProfile", "eth-multi-q", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], [None]),
        "AdaptorEthOffloadProfile": MoMeta("AdaptorEthOffloadProfile", "adaptorEthOffloadProfile", "eth-offload", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthRdmaProfile": MoMeta("AdaptorEthRdmaProfile", "adaptorEthRdmaProfile", "rdmaprofile", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthRecvQueueProfile": MoMeta("AdaptorEthRecvQueueProfile", "adaptorEthRecvQueueProfile", "eth-rcv-q", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorEthUSNICProfile": MoMeta("AdaptorEthUSNICProfile", "adaptorEthUSNICProfile", "ethusnic", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['adaptorHostEthIf'], [], ["Get", "Remove", "Set"]),
        "AdaptorEthWorkQueueProfile": MoMeta("AdaptorEthWorkQueueProfile", "adaptorEthWorkQueueProfile", "eth-work-q", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorExtEthIf": MoMeta("AdaptorExtEthIf", "adaptorExtEthIf", "ext-eth-[port_id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], ['adaptorConnectorInfo', 'adaptorLinkTraining', 'adaptorPortProfiles'], ["Get", "Set"]),
        "AdaptorExtIpV6RssHashProfile": MoMeta("AdaptorExtIpV6RssHashProfile", "adaptorExtIpV6RssHashProfile", "ext-ipv6-rss-hash", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorFcBootTable": MoMeta("AdaptorFcBootTable", "adaptorFcBootTable", "fcboot-[index]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Add", "Get", "Set"]),
        "AdaptorFcCdbWorkQueueProfile": MoMeta("AdaptorFcCdbWorkQueueProfile", "adaptorFcCdbWorkQueueProfile", "fc-cdb-work-q", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcErrorRecoveryProfile": MoMeta("AdaptorFcErrorRecoveryProfile", "adaptorFcErrorRecoveryProfile", "fc-err-rec", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcGenProfile": MoMeta("AdaptorFcGenProfile", "adaptorFcGenProfile", "general", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcInterruptProfile": MoMeta("AdaptorFcInterruptProfile", "adaptorFcInterruptProfile", "fc-int", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcPersistentBindings": MoMeta("AdaptorFcPersistentBindings", "adaptorFcPersistentBindings", "perbi-[index]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get"]),
        "AdaptorFcPortFLogiProfile": MoMeta("AdaptorFcPortFLogiProfile", "adaptorFcPortFLogiProfile", "fc-port-flogi", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcPortPLogiProfile": MoMeta("AdaptorFcPortPLogiProfile", "adaptorFcPortPLogiProfile", "fc-port-plogi", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcPortProfile": MoMeta("AdaptorFcPortProfile", "adaptorFcPortProfile", "fc-port", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcRecvQueueProfile": MoMeta("AdaptorFcRecvQueueProfile", "adaptorFcRecvQueueProfile", "fc-rcv-q", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorFcWorkQueueProfile": MoMeta("AdaptorFcWorkQueueProfile", "adaptorFcWorkQueueProfile", "fc-work-q", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostFcIf'], [], ["Get", "Set"]),
        "AdaptorGenProfile": MoMeta("AdaptorGenProfile", "adaptorGenProfile", "general", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Get", "Set"]),
        "AdaptorHostEthIf": MoMeta("AdaptorHostEthIf", "adaptorHostEthIf", "host-eth-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], [], ["Add", "Get", "Remove", "Set"]),
        "AdaptorHostFcIf": MoMeta("AdaptorHostFcIf", "adaptorHostFcIf", "host-fc-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit'], ['adaptorFcPersistentBindings'], ["Add", "Get", "Remove", "Set"]),
        "AdaptorIpV4RssHashProfile": MoMeta("AdaptorIpV4RssHashProfile", "adaptorIpV4RssHashProfile", "ipv4-rss-hash", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorIpV6RssHashProfile": MoMeta("AdaptorIpV6RssHashProfile", "adaptorIpV6RssHashProfile", "ipv6-rss-hash", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorLinkTraining": MoMeta("AdaptorLinkTraining", "adaptorLinkTraining", "link-training", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "user"], ['adaptorExtEthIf'], [], ["Get", "Set"]),
        "AdaptorPortProfiles": MoMeta("AdaptorPortProfiles", "adaptorPortProfiles", "port-profiles", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorExtEthIf'], [], ["Get"]),
        "AdaptorRssProfile": MoMeta("AdaptorRssProfile", "adaptorRssProfile", "rss", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['adaptorHostEthIf'], [], ["Get", "Set"]),
        "AdaptorUnit": MoMeta("AdaptorUnit", "adaptorUnit", "adaptor-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['adaptorCfgBackup', 'adaptorCfgImporter', 'adaptorExtEthIf', 'adaptorHostEthIf', 'adaptorHostFcIf', 'faultInst', 'mgmtController'], ["Get", "Set"]),
        "BiosBOT": MoMeta("BiosBOT", "biosBOT", "bdgep", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], ['biosBootDevGrp', 'biosBootDevPrecision', 'biosBootMode'], ["Get"]),
        "BiosBootDev": MoMeta("BiosBootDev", "biosBootDev", "bdv-[order]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosBootDevGrp'], [], ["Get"]),
        "BiosBootDevGrp": MoMeta("BiosBootDevGrp", "biosBootDevGrp", "bdg-[order]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosBOT'], ['biosBootDev'], ["Get"]),
        "BiosBootDevPrecision": MoMeta("BiosBootDevPrecision", "biosBootDevPrecision", "bdvp-[order]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosBOT'], [], ["Get"]),
        "BiosBootMode": MoMeta("BiosBootMode", "biosBootMode", "boot-mode", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "user"], ['biosBOT'], [], ["Get"]),
        "BiosPlatformDefaults": MoMeta("BiosPlatformDefaults", "biosPlatformDefaults", "bios-defaults", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], ['biosVfASPMSupport', 'biosVfAdjacentCacheLinePrefetch', 'biosVfAdvancedMemTest', 'biosVfAltitude', 'biosVfAssertNMIOnPERR', 'biosVfAssertNMIOnSERR', 'biosVfAutoCCState', 'biosVfAutonumousCstateEnable', 'biosVfBmeDmaMitigation', 'biosVfBootOptionRetry', 'biosVfBootPerformanceMode', 'biosVfCDNEnable', 'biosVfCDNSupport', 'biosVfCPUEnergyPerformance', 'biosVfCPUFrequencyFloor', 'biosVfCPUPerformance', 'biosVfCPUPowerManagement', 'biosVfCRQos', 'biosVfCiscoAdaptiveMemTraining', 'biosVfCiscoDebugLevel', 'biosVfCiscoOpromLaunchOptimization', 'biosVfCkeLowPolicy', 'biosVfCmciEnable', 'biosVfConfigTDPLevel', 'biosVfConsoleRedirection', 'biosVfCoreMultiProcessing', 'biosVfCrfastgoConfig', 'biosVfDCPMMFirmwareDowngrade', 'biosVfDCUPrefetch', 'biosVfDRAMClockThrottling', 'biosVfDemandScrub', 'biosVfDirectCacheAccess', 'biosVfDramRefreshRate', 'biosVfEPPEnable', 'biosVfEPPProfile', 'biosVfEnableClockSpreadSpec', 'biosVfEnergyEfficientTurbo', 'biosVfEnhancedIntelSpeedStepTech', 'biosVfExecuteDisableBit', 'biosVfExtendedAPIC', 'biosVfFRB2Enable', 'biosVfHWPMEnable', 'biosVfHardwarePrefetch', 'biosVfIMCInterleave', 'biosVfIOHResource', 'biosVfIPV4HTTP', 'biosVfIPV4PXE', 'biosVfIPV6HTTP', 'biosVfIPV6PXE', 'biosVfIntelHyperThreadingTech', 'biosVfIntelSpeedSelect', 'biosVfIntelTurboBoostTech', 'biosVfIntelVTForDirectedIO', 'biosVfIntelVirtualizationTechnology', 'biosVfKTIPrefetch', 'biosVfLLCPrefetch', 'biosVfLOMPortOptionROM', 'biosVfLegacyUSBSupport', 'biosVfLvDIMMSupport', 'biosVfMMCFGBase', 'biosVfMemoryInterleave', 'biosVfMemoryMappedIOAbove4GB', 'biosVfMemoryRefreshRate', 'biosVfMemorySizeLimit', 'biosVfMemoryThermalThrottling', 'biosVfMirroringMode', 'biosVfNUMAOptimized', 'biosVfNetworkStack', 'biosVfNvmdimmPerformConfig', 'biosVfOSBootWatchdogTimer', 'biosVfOSBootWatchdogTimerPolicy', 'biosVfOSBootWatchdogTimerTimeout', 'biosVfOnboardNIC', 'biosVfOnboardStorage', 'biosVfOnboardStorageSWStack', 'biosVfOutOfBandMgmtPort', 'biosVfPCIOptionROMs', 'biosVfPCISlotOptionROMEnable', 'biosVfPCIeRASSupport', 'biosVfPOSTErrorPause', 'biosVfPSata', 'biosVfPStateCoordType', 'biosVfPackageCStateLimit', 'biosVfPanicHighWatermark', 'biosVfPartialMirrorModeConfig', 'biosVfPartialMirrorPercent', 'biosVfPartialMirrorValue1', 'biosVfPartialMirrorValue2', 'biosVfPartialMirrorValue3', 'biosVfPartialMirrorValue4', 'biosVfPatrolScrub', 'biosVfPatrolScrubDuration', 'biosVfPchUsb30Mode', 'biosVfPciRomClp', 'biosVfPciePllSsc', 'biosVfPowerOnPasswordSupport', 'biosVfProcessorC1E', 'biosVfProcessorC3Report', 'biosVfProcessorC6Report', 'biosVfProcessorCState', 'biosVfPwrPerfTuning', 'biosVfQPIConfig', 'biosVfQpiLinkSpeed', 'biosVfQpiSnoopMode', 'biosVfSataModeSelect', 'biosVfSelectMemoryRASConfiguration', 'biosVfSelectPprType', 'biosVfSerialPortAEnable', 'biosVfSnoopyModeFor2LM', 'biosVfSnoopyModeForAD', 'biosVfSparingMode', 'biosVfSrIov', 'biosVfSubNumaClustering', 'biosVfTPMControl', 'biosVfTPMSupport', 'biosVfTXTSupport', 'biosVfUCSMBootOrderRuleControl', 'biosVfUFSDisable', 'biosVfUSBBootConfig', 'biosVfUSBEmulation', 'biosVfUSBPortsConfig', 'biosVfUsbXhciSupport', 'biosVfVgaPriority', 'biosVfWorkLoadConfig', 'biosVfXPTPrefetch'], ["Get"]),
        "BiosProfile": MoMeta("BiosProfile", "biosProfile", "bios-profile-[name]", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosProfileManagement'], ['biosProfileToken'], ["Get", "Set"]),
        "BiosProfileManagement": MoMeta("BiosProfileManagement", "biosProfileManagement", "profile-mgmt", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], ['biosProfile', 'uploadBiosProfile'], ["Get", "Set"]),
        "BiosProfileToken": MoMeta("BiosProfileToken", "biosProfileToken", "token-[name]", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosProfile'], [], ["Get"]),
        "BiosSettings": MoMeta("BiosSettings", "biosSettings", "bios-settings", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosUnit'], [], ["Get"]),
        "BiosUnit": MoMeta("BiosUnit", "biosUnit", "bios", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['biosBOT', 'biosPlatformDefaults', 'biosProfileManagement', 'biosSettings', 'firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable'], ["Get", "Set"]),
        "BiosVfASPMSupport": MoMeta("BiosVfASPMSupport", "biosVfASPMSupport", "ASPM-Support", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAdjacentCacheLinePrefetch": MoMeta("BiosVfAdjacentCacheLinePrefetch", "biosVfAdjacentCacheLinePrefetch", "Adjacent-Cache-Line-Prefetch", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAdvancedMemTest": MoMeta("BiosVfAdvancedMemTest", "biosVfAdvancedMemTest", "Advanced-Memory-Test", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfAltitude": MoMeta("BiosVfAltitude", "biosVfAltitude", "Altitude-Param", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAssertNMIOnPERR": MoMeta("BiosVfAssertNMIOnPERR", "biosVfAssertNMIOnPERR", "Assert-NMI-on-PERR", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAssertNMIOnSERR": MoMeta("BiosVfAssertNMIOnSERR", "biosVfAssertNMIOnSERR", "Assert-NMI-on-SERR", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfAutoCCState": MoMeta("BiosVfAutoCCState", "biosVfAutoCCState", "auto-cc-state", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfAutonumousCstateEnable": MoMeta("BiosVfAutonumousCstateEnable", "biosVfAutonumousCstateEnable", "Autonumous-Cstate-Enable", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfBmeDmaMitigation": MoMeta("BiosVfBmeDmaMitigation", "biosVfBmeDmaMitigation", "bme-dma-mitigation", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfBootOptionRetry": MoMeta("BiosVfBootOptionRetry", "biosVfBootOptionRetry", "Boot-option-retry", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfBootPerformanceMode": MoMeta("BiosVfBootPerformanceMode", "biosVfBootPerformanceMode", "Boot-Performance-Mode", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCDNEnable": MoMeta("BiosVfCDNEnable", "biosVfCDNEnable", "CDN-Enable", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCDNSupport": MoMeta("BiosVfCDNSupport", "biosVfCDNSupport", "CDN-Support", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUEnergyPerformance": MoMeta("BiosVfCPUEnergyPerformance", "biosVfCPUEnergyPerformance", "CPU-EngPerfBias", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUFrequencyFloor": MoMeta("BiosVfCPUFrequencyFloor", "biosVfCPUFrequencyFloor", "CPU-FreqFloor", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUPerformance": MoMeta("BiosVfCPUPerformance", "biosVfCPUPerformance", "CPU-Performance", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCPUPowerManagement": MoMeta("BiosVfCPUPowerManagement", "biosVfCPUPowerManagement", "CPU-PowerManagement", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCRQos": MoMeta("BiosVfCRQos", "biosVfCRQos", "CR-Qos", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCiscoAdaptiveMemTraining": MoMeta("BiosVfCiscoAdaptiveMemTraining", "biosVfCiscoAdaptiveMemTraining", "Cisco-Adap-Mem", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCiscoDebugLevel": MoMeta("BiosVfCiscoDebugLevel", "biosVfCiscoDebugLevel", "Cisco-Debug-Level", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCiscoOpromLaunchOptimization": MoMeta("BiosVfCiscoOpromLaunchOptimization", "biosVfCiscoOpromLaunchOptimization", "Cisco-Opromlaunch-Optimize", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfCkeLowPolicy": MoMeta("BiosVfCkeLowPolicy", "biosVfCkeLowPolicy", "Cke-Low-Policy", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCmciEnable": MoMeta("BiosVfCmciEnable", "biosVfCmciEnable", "Cmci-Enable", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfConfigTDPLevel": MoMeta("BiosVfConfigTDPLevel", "biosVfConfigTDPLevel", "Configurable-TDP-Level", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfConsoleRedirection": MoMeta("BiosVfConsoleRedirection", "biosVfConsoleRedirection", "Console-redirection", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCoreMultiProcessing": MoMeta("BiosVfCoreMultiProcessing", "biosVfCoreMultiProcessing", "Core-MultiProcessing", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfCrfastgoConfig": MoMeta("BiosVfCrfastgoConfig", "biosVfCrfastgoConfig", "CR-FastGo-Config", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfDCPMMFirmwareDowngrade": MoMeta("BiosVfDCPMMFirmwareDowngrade", "biosVfDCPMMFirmwareDowngrade", "DCPMM-Firmware-Downgrade", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfDCUPrefetch": MoMeta("BiosVfDCUPrefetch", "biosVfDCUPrefetch", "DCU-Prefetch", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDRAMClockThrottling": MoMeta("BiosVfDRAMClockThrottling", "biosVfDRAMClockThrottling", "DRAM-Clock-Throttling", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDemandScrub": MoMeta("BiosVfDemandScrub", "biosVfDemandScrub", "Demand-Scrub-Param", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDirectCacheAccess": MoMeta("BiosVfDirectCacheAccess", "biosVfDirectCacheAccess", "Direct-Cache-Access", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfDramRefreshRate": MoMeta("BiosVfDramRefreshRate", "biosVfDramRefreshRate", "dram-refresh-rate", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfEPPEnable": MoMeta("BiosVfEPPEnable", "biosVfEPPEnable", "Processor-EPP-Enable", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEPPProfile": MoMeta("BiosVfEPPProfile", "biosVfEPPProfile", "epp-profile", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEnableClockSpreadSpec": MoMeta("BiosVfEnableClockSpreadSpec", "biosVfEnableClockSpreadSpec", "External-SSC-Enable", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEnergyEfficientTurbo": MoMeta("BiosVfEnergyEfficientTurbo", "biosVfEnergyEfficientTurbo", "energy-efficient-turbo", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfEnhancedIntelSpeedStepTech": MoMeta("BiosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedIntelSpeedStepTech", "Enhanced-Intel-SpeedStep-Tech", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfExecuteDisableBit": MoMeta("BiosVfExecuteDisableBit", "biosVfExecuteDisableBit", "Execute-Disable-Bit", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfExtendedAPIC": MoMeta("BiosVfExtendedAPIC", "biosVfExtendedAPIC", "Extended-APIC", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfFRB2Enable": MoMeta("BiosVfFRB2Enable", "biosVfFRB2Enable", "FRB2-Enable", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfHWPMEnable": MoMeta("BiosVfHWPMEnable", "biosVfHWPMEnable", "HWPM-Enable", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfHardwarePrefetch": MoMeta("BiosVfHardwarePrefetch", "biosVfHardwarePrefetch", "Hardware-Prefetch", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIMCInterleave": MoMeta("BiosVfIMCInterleave", "biosVfIMCInterleave", "imc-interleave", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIOHResource": MoMeta("BiosVfIOHResource", "biosVfIOHResource", "ioh-resource", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIPV4HTTP": MoMeta("BiosVfIPV4HTTP", "biosVfIPV4HTTP", "IPV4-HTTP-Support", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIPV4PXE": MoMeta("BiosVfIPV4PXE", "biosVfIPV4PXE", "IPv4-Pxe", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIPV6HTTP": MoMeta("BiosVfIPV6HTTP", "biosVfIPV6HTTP", "IPV6-HTTP-Support", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIPV6PXE": MoMeta("BiosVfIPV6PXE", "biosVfIPV6PXE", "IPv6-Pxe", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelHyperThreadingTech": MoMeta("BiosVfIntelHyperThreadingTech", "biosVfIntelHyperThreadingTech", "Intel-HyperThreading-Tech", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelSpeedSelect": MoMeta("BiosVfIntelSpeedSelect", "biosVfIntelSpeedSelect", "Intel-Speed-Select", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfIntelTurboBoostTech": MoMeta("BiosVfIntelTurboBoostTech", "biosVfIntelTurboBoostTech", "Intel-Turbo-Boost-Tech", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelVTForDirectedIO": MoMeta("BiosVfIntelVTForDirectedIO", "biosVfIntelVTForDirectedIO", "Intel-VT-for-directed-IO", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfIntelVirtualizationTechnology": MoMeta("BiosVfIntelVirtualizationTechnology", "biosVfIntelVirtualizationTechnology", "Intel-Virtualization-Technology", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfKTIPrefetch": MoMeta("BiosVfKTIPrefetch", "biosVfKTIPrefetch", "kti-prefetch", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLLCPrefetch": MoMeta("BiosVfLLCPrefetch", "biosVfLLCPrefetch", "LLC-Prefetch", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLOMPortOptionROM": MoMeta("BiosVfLOMPortOptionROM", "biosVfLOMPortOptionROM", "LOMPort-OptionROM", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLegacyUSBSupport": MoMeta("BiosVfLegacyUSBSupport", "biosVfLegacyUSBSupport", "LegacyUSB-Support", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfLvDIMMSupport": MoMeta("BiosVfLvDIMMSupport", "biosVfLvDIMMSupport", "LvDIMM-Support", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMMCFGBase": MoMeta("BiosVfMMCFGBase", "biosVfMMCFGBase", "MMCFG-Base", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMemoryInterleave": MoMeta("BiosVfMemoryInterleave", "biosVfMemoryInterleave", "Memory-Interleave", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMemoryMappedIOAbove4GB": MoMeta("BiosVfMemoryMappedIOAbove4GB", "biosVfMemoryMappedIOAbove4GB", "Memory-mapped-IO-above-4GB", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfMemoryRefreshRate": MoMeta("BiosVfMemoryRefreshRate", "biosVfMemoryRefreshRate", "Memory-Refresh-Rate", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfMemorySizeLimit": MoMeta("BiosVfMemorySizeLimit", "biosVfMemorySizeLimit", "Memory-Size-Limit", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfMemoryThermalThrottling": MoMeta("BiosVfMemoryThermalThrottling", "biosVfMemoryThermalThrottling", "Memory-Thermal-Throttling-Mode", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfMirroringMode": MoMeta("BiosVfMirroringMode", "biosVfMirroringMode", "Mirroring-Mode", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfNUMAOptimized": MoMeta("BiosVfNUMAOptimized", "biosVfNUMAOptimized", "NUMA-optimized", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfNetworkStack": MoMeta("BiosVfNetworkStack", "biosVfNetworkStack", "Network-Stack", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfNvmdimmPerformConfig": MoMeta("BiosVfNvmdimmPerformConfig", "biosVfNvmdimmPerformConfig", "NVM-Performance-Setting", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfOSBootWatchdogTimer": MoMeta("BiosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimer", "OS-Boot-Watchdog-Timer-Param", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOSBootWatchdogTimerPolicy": MoMeta("BiosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerPolicy", "OS-Boot-Watchdog-Timer-Policy", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOSBootWatchdogTimerTimeout": MoMeta("BiosVfOSBootWatchdogTimerTimeout", "biosVfOSBootWatchdogTimerTimeout", "OS-Boot-Watchdog-Timer-Time-Out", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOnboardNIC": MoMeta("BiosVfOnboardNIC", "biosVfOnboardNIC", "Onboard-NIC", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOnboardStorage": MoMeta("BiosVfOnboardStorage", "biosVfOnboardStorage", "Onboard-Storage", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOnboardStorageSWStack": MoMeta("BiosVfOnboardStorageSWStack", "biosVfOnboardStorageSWStack", "Onboard-SCU-Storage-SWStack", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfOutOfBandMgmtPort": MoMeta("BiosVfOutOfBandMgmtPort", "biosVfOutOfBandMgmtPort", "OoB-MgmtPort", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPCIOptionROMs": MoMeta("BiosVfPCIOptionROMs", "biosVfPCIOptionROMs", "PCI-OptionROMs", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPCISlotOptionROMEnable": MoMeta("BiosVfPCISlotOptionROMEnable", "biosVfPCISlotOptionROMEnable", "PCI-Slot-OptionROM-Enable", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPCIeRASSupport": MoMeta("BiosVfPCIeRASSupport", "biosVfPCIeRASSupport", "PCIe-RAS-Support", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPOSTErrorPause": MoMeta("BiosVfPOSTErrorPause", "biosVfPOSTErrorPause", "POST-error-pause", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPSata": MoMeta("BiosVfPSata", "biosVfPSata", "PSata", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPStateCoordType": MoMeta("BiosVfPStateCoordType", "biosVfPStateCoordType", "p-state-coord", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPackageCStateLimit": MoMeta("BiosVfPackageCStateLimit", "biosVfPackageCStateLimit", "Package-CState-Limit", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPanicHighWatermark": MoMeta("BiosVfPanicHighWatermark", "biosVfPanicHighWatermark", "Panic-and-High-Watermark", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorModeConfig": MoMeta("BiosVfPartialMirrorModeConfig", "biosVfPartialMirrorModeConfig", "Partial-Mirror-Mode", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorPercent": MoMeta("BiosVfPartialMirrorPercent", "biosVfPartialMirrorPercent", "Partial-Mirror-Percent", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue1": MoMeta("BiosVfPartialMirrorValue1", "biosVfPartialMirrorValue1", "Partial-Mirror-Value1", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue2": MoMeta("BiosVfPartialMirrorValue2", "biosVfPartialMirrorValue2", "Partial-Mirror-Value2", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue3": MoMeta("BiosVfPartialMirrorValue3", "biosVfPartialMirrorValue3", "Partial-Mirror-Value3", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPartialMirrorValue4": MoMeta("BiosVfPartialMirrorValue4", "biosVfPartialMirrorValue4", "Partial-Mirror-Value4", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPatrolScrub": MoMeta("BiosVfPatrolScrub", "biosVfPatrolScrub", "Patrol-Scrub-Param", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPatrolScrubDuration": MoMeta("BiosVfPatrolScrubDuration", "biosVfPatrolScrubDuration", "Patrol-Scrub-Duration", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPchUsb30Mode": MoMeta("BiosVfPchUsb30Mode", "biosVfPchUsb30Mode", "PchUsb30-Mode", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPciRomClp": MoMeta("BiosVfPciRomClp", "biosVfPciRomClp", "pci-rom-clp", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPciePllSsc": MoMeta("BiosVfPciePllSsc", "biosVfPciePllSsc", "PCIe-PLL-SSC", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfPowerOnPasswordSupport": MoMeta("BiosVfPowerOnPasswordSupport", "biosVfPowerOnPasswordSupport", "POP-Support", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorC1E": MoMeta("BiosVfProcessorC1E", "biosVfProcessorC1E", "Processor-C1E", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorC3Report": MoMeta("BiosVfProcessorC3Report", "biosVfProcessorC3Report", "Processor-C3-Report", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorC6Report": MoMeta("BiosVfProcessorC6Report", "biosVfProcessorC6Report", "Processor-C6-Report", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfProcessorCState": MoMeta("BiosVfProcessorCState", "biosVfProcessorCState", "Processor-C-State", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfPwrPerfTuning": MoMeta("BiosVfPwrPerfTuning", "biosVfPwrPerfTuning", "Pwr-Perf-Tuning", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfQPIConfig": MoMeta("BiosVfQPIConfig", "biosVfQPIConfig", "QPI-Config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfQpiLinkSpeed": MoMeta("BiosVfQpiLinkSpeed", "biosVfQpiLinkSpeed", "UPI-Link-Frequency-Select", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfQpiSnoopMode": MoMeta("BiosVfQpiSnoopMode", "biosVfQpiSnoopMode", "QPI-Snoop-Mode", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfResumeOnACPowerLoss": MoMeta("BiosVfResumeOnACPowerLoss", "biosVfResumeOnACPowerLoss", "Resume-on-AC-power-loss", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get", "Set"]),
        "BiosVfSataModeSelect": MoMeta("BiosVfSataModeSelect", "biosVfSataModeSelect", "Pch-Sata-Mode", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSelectMemoryRASConfiguration": MoMeta("BiosVfSelectMemoryRASConfiguration", "biosVfSelectMemoryRASConfiguration", "SelectMemory-RAS-configuration", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSelectPprType": MoMeta("BiosVfSelectPprType", "biosVfSelectPprType", "select-ppr-type", VersionMeta.Version411c, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSerialPortAEnable": MoMeta("BiosVfSerialPortAEnable", "biosVfSerialPortAEnable", "Serial-port-A-enable", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSnoopyModeFor2LM": MoMeta("BiosVfSnoopyModeFor2LM", "biosVfSnoopyModeFor2LM", "Snoopy-mode-for-2LM", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSnoopyModeForAD": MoMeta("BiosVfSnoopyModeForAD", "biosVfSnoopyModeForAD", "Snoopy-mode-for-AD", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfSparingMode": MoMeta("BiosVfSparingMode", "biosVfSparingMode", "Sparing-Mode", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSrIov": MoMeta("BiosVfSrIov", "biosVfSrIov", "sr-iov", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfSubNumaClustering": MoMeta("BiosVfSubNumaClustering", "biosVfSubNumaClustering", "sub-numa-cluster", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfTPMControl": MoMeta("BiosVfTPMControl", "biosVfTPMControl", "TPM-Control", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfTPMSupport": MoMeta("BiosVfTPMSupport", "biosVfTPMSupport", "TPM-Support", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfTXTSupport": MoMeta("BiosVfTXTSupport", "biosVfTXTSupport", "TXT-Support", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfUCSMBootOrderRuleControl": MoMeta("BiosVfUCSMBootOrderRuleControl", "biosVfUCSMBootOrderRuleControl", "Boot-Order-Rules", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUFSDisable": MoMeta("BiosVfUFSDisable", "biosVfUFSDisable", "Uncore-Frequency-Scaling", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], [None]),
        "BiosVfUSBBootConfig": MoMeta("BiosVfUSBBootConfig", "biosVfUSBBootConfig", "USB-Boot-Config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUSBEmulation": MoMeta("BiosVfUSBEmulation", "biosVfUSBEmulation", "USBEmulation-Support", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUSBPortsConfig": MoMeta("BiosVfUSBPortsConfig", "biosVfUSBPortsConfig", "USB-Ports-Config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfUsbXhciSupport": MoMeta("BiosVfUsbXhciSupport", "biosVfUsbXhciSupport", "UsbXhci-Support", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfVgaPriority": MoMeta("BiosVfVgaPriority", "biosVfVgaPriority", "VgaPriority", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfWorkLoadConfig": MoMeta("BiosVfWorkLoadConfig", "biosVfWorkLoadConfig", "work-load-config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "BiosVfXPTPrefetch": MoMeta("BiosVfXPTPrefetch", "biosVfXPTPrefetch", "xpt-prefetch", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin"], ['biosPlatformDefaults', 'biosSettings'], [], ["Get", "Set"]),
        "CertificateManagement": MoMeta("CertificateManagement", "certificateManagement", "cert-mgmt", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['currentCertificate', 'generateCertificateSigningRequest', 'uploadCertificate', 'uploadExternalCertificate', 'uploadExternalPrivateKey'], ["Get"]),
        "CloudDeviceConnectorEp": MoMeta("CloudDeviceConnectorEp", "cloudDeviceConnectorEp", "device-connector", VersionMeta.Version411c, "OutputOnly", 0x1, [], ["read-only"], ['cloudMgmtSvc'], ['faultInst', 'mgmtController'], [None]),
        "CloudMgmtSvc": MoMeta("CloudMgmtSvc", "cloudMgmtSvc", "cloud-mgmt", VersionMeta.Version411c, "OutputOnly", 0x1, [], ["read-only"], ['topSystem'], ['cloudDeviceConnectorEp'], [None]),
        "CommHttp": MoMeta("CommHttp", "commHttp", "http-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommHttps": MoMeta("CommHttps", "commHttps", "https-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommIpmiLan": MoMeta("CommIpmiLan", "commIpmiLan", "ipmi-lan-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcRack'], [], ["Get", "Set"]),
        "CommKvm": MoMeta("CommKvm", "commKvm", "kvm-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcRack'], [], ["Get", "Set"]),
        "CommMailAlert": MoMeta("CommMailAlert", "commMailAlert", "mail-alert-svc", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], ['mailRecipient'], ["Get", "Set"]),
        "CommNtpProvider": MoMeta("CommNtpProvider", "commNtpProvider", "ntp-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommRedfish": MoMeta("CommRedfish", "commRedfish", "redfish-svc", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommSavedVMediaMap": MoMeta("CommSavedVMediaMap", "commSavedVMediaMap", "saved-vmmap-[volume_name]", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commVMedia'], [], ["Get", "Remove", "Set"]),
        "CommSnmp": MoMeta("CommSnmp", "commSnmp", "snmp-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], ['commSnmpConfigCommit', 'commSnmpTrap', 'commSnmpUser'], ["Get", "Set"]),
        "CommSnmpConfigCommit": MoMeta("CommSnmpConfigCommit", "commSnmpConfigCommit", "snmp-config-commit", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSnmp'], [], [None]),
        "CommSnmpTrap": MoMeta("CommSnmpTrap", "commSnmpTrap", "snmp-trap-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSnmp'], [], ["Get", "Set"]),
        "CommSnmpUser": MoMeta("CommSnmpUser", "commSnmpUser", "snmpv3-user-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSnmp'], [], ["Get", "Set"]),
        "CommSsh": MoMeta("CommSsh", "commSsh", "ssh-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], [], ["Get", "Set"]),
        "CommSvcEp": MoMeta("CommSvcEp", "commSvcEp", "svc-ext", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['commHttp', 'commHttps', 'commMailAlert', 'commNtpProvider', 'commRedfish', 'commSnmp', 'commSsh', 'commSyslog'], ["Get"]),
        "CommSyslog": MoMeta("CommSyslog", "commSyslog", "syslog", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcEp'], ['commSyslogClient'], ["Get", "Set"]),
        "CommSyslogClient": MoMeta("CommSyslogClient", "commSyslogClient", "client-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSyslog'], [], ["Get"]),
        "CommVMedia": MoMeta("CommVMedia", "commVMedia", "vmedia-svc", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commSvcRack'], ['commSavedVMediaMap', 'commVMediaMap'], ["Get", "Set"]),
        "CommVMediaMap": MoMeta("CommVMediaMap", "commVMediaMap", "vmmap-[volume_name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commVMedia'], [], ["Add", "Get"]),
        "ComputeBoard": MoMeta("ComputeBoard", "computeBoard", "board", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['biosVfResumeOnACPowerLoss', 'computeMbPowerStats', 'computeServerNodeMbTempStats', 'equipmentTpm', 'faultInst', 'graphicsCard', 'memoryArray', 'memoryPersistentMemoryConfiguration', 'memoryPersistentMemoryLogicalConfiguration', 'pidCatalog', 'processorUnit', 'storageController', 'storageControllerNVMe', 'storageFlexFlashController', 'storageLocalDiskSlotEp'], ["Get"]),
        "ComputeMbPowerStats": MoMeta("ComputeMbPowerStats", "computeMbPowerStats", "power-stats", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get"]),
        "CurrentCertificate": MoMeta("CurrentCertificate", "currentCertificate", "curr-cert", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "DownloadClientCertificate": MoMeta("DownloadClientCertificate", "downloadClientCertificate", "kmip-client-cert-download", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "DownloadClientPrivateKey": MoMeta("DownloadClientPrivateKey", "downloadClientPrivateKey", "kmip-private-key-download", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "DownloadLdapCACertificate": MoMeta("DownloadLdapCACertificate", "downloadLdapCACertificate", "ldap-ca-cert-download", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['ldapCACertificateManagement'], [], ["Get"]),
        "DownloadRootCACertificate": MoMeta("DownloadRootCACertificate", "downloadRootCACertificate", "kmip-ca-cert-download", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "EquipmentFan": MoMeta("EquipmentFan", "equipmentFan", "fan-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentFanModule'], ['faultInst'], ["Get"]),
        "EquipmentFanModule": MoMeta("EquipmentFanModule", "equipmentFanModule", "fan-module-[tray]-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode', 'equipmentChassis'], ['equipmentFan'], ["Get"]),
        "EquipmentIndicatorLed": MoMeta("EquipmentIndicatorLed", "equipmentIndicatorLed", "indicator-led-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode', 'equipmentChassis'], [], ["Get"]),
        "EquipmentLocatorLed": MoMeta("EquipmentLocatorLed", "equipmentLocatorLed", "locator-led", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get", "Set"]),
        "EquipmentPsu": MoMeta("EquipmentPsu", "equipmentPsu", "psu-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode', 'equipmentChassis'], ['faultInst'], ["Get"]),
        "EquipmentTpm": MoMeta("EquipmentTpm", "equipmentTpm", "tpm", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["read-only"], ['computeBoard'], [], ["Get"]),
        "Error": MoMeta("Error", "error", "", VersionMeta.Version2013e, "OutputOnly", 0x1, [], [""], [], [], [None]),
        "EventManagement": MoMeta("EventManagement", "eventManagement", "event-management", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], ['platformEventFilters'], ["Get", "Set"]),
        "ExportClientCertificate": MoMeta("ExportClientCertificate", "exportClientCertificate", "kmip-client-cert-export", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "ExportClientPrivateKey": MoMeta("ExportClientPrivateKey", "exportClientPrivateKey", "kmip-private-key-export", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "ExportLdapCACertificate": MoMeta("ExportLdapCACertificate", "exportLdapCACertificate", "ldap-ca-cert-export", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['ldapCACertificateManagement'], [], ["Get"]),
        "ExportRootCACertificate": MoMeta("ExportRootCACertificate", "exportRootCACertificate", "kmip-ca-cert-export", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], [None]),
        "FaultInst": MoMeta("FaultInst", "faultInst", "fault-[code]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit', 'cloudDeviceConnectorEp', 'computeBoard', 'computeServerNode', 'equipmentChassis', 'equipmentFan', 'equipmentPsu', 'equipmentSystemIOController', 'ioControllerNVMePhysicalDrive', 'memoryArray', 'memoryUnit', 'pciEquipSlot', 'powerBudget', 'processorUnit', 'storageController', 'storageControllerNVMe', 'storageEnclosureDiskSlotEp', 'storageFlexFlashController', 'storageFlexFlashPhysicalDrive', 'storageFlexFlashVirtualDrive', 'storageLocalDisk', 'storageLocalDiskEp', 'storageNVMePhysicalDrive', 'storageRaidBattery', 'storageSasExpander', 'storageVirtualDrive', 'sysdebugMEpLog', 'systemIOControllerNVMe'], [], ["Get"]),
        "FirmwareBootDefinition": MoMeta("FirmwareBootDefinition", "firmwareBootDefinition", "fw-boot-def", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit', 'mgmtController', 'storageController'], ['firmwareBootUnit'], ["Get"]),
        "FirmwareBootUnit": MoMeta("FirmwareBootUnit", "firmwareBootUnit", "bootunit-[type]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['firmwareBootDefinition'], [], ["Get", "Set"]),
        "FirmwareRunning": MoMeta("FirmwareRunning", "firmwareRunning", "fw-[deployment]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['biosUnit', 'mgmtController', 'storageController', 'storageControllerNVMe'], [], ["Get"]),
        "FirmwareUpdatable": MoMeta("FirmwareUpdatable", "firmwareUpdatable", "fw-updatable", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosUnit', 'mgmtController'], [], ["Get"]),
        "GenerateCertificateSigningRequest": MoMeta("GenerateCertificateSigningRequest", "generateCertificateSigningRequest", "gen-csr-req", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "GenerateRandomPassword": MoMeta("GenerateRandomPassword", "generateRandomPassword", "generate-random-pwd", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["admin", "user"], ['aaaUserEp'], [], ["Get"]),
        "GeneratedStorageControllerKeyId": MoMeta("GeneratedStorageControllerKeyId", "generatedStorageControllerKeyId", "gen-key-id", VersionMeta.Version303a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "GraphicsCard": MoMeta("GraphicsCard", "graphicsCard", "graphics-card-[id]", VersionMeta.Version411c, "OutputOnly", 0x1, [], ["read-only"], ['computeBoard'], [], [None]),
        "HuuController": MoMeta("HuuController", "huuController", "huu", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['huuFirmwareCatalog', 'huuFirmwareRunning', 'huuFirmwareUpdateCancel', 'huuFirmwareUpdater'], ["Get"]),
        "HuuFirmwareCatalog": MoMeta("HuuFirmwareCatalog", "huuFirmwareCatalog", "firmwareCatalog", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuController'], ['huuFirmwareCatalogComponent'], ["Get"]),
        "HuuFirmwareCatalogComponent": MoMeta("HuuFirmwareCatalogComponent", "huuFirmwareCatalogComponent", "id-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareCatalog'], [], ["Get"]),
        "HuuFirmwareComponent": MoMeta("HuuFirmwareComponent", "huuFirmwareComponent", "component-[component]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareRunning'], [], ["Get"]),
        "HuuFirmwareRunning": MoMeta("HuuFirmwareRunning", "huuFirmwareRunning", "currentFirmware", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuController'], ['huuFirmwareComponent'], ["Get"]),
        "HuuFirmwareUpdateCancel": MoMeta("HuuFirmwareUpdateCancel", "huuFirmwareUpdateCancel", "firmwareUpdateCancel", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['huuController'], [], ["Get", "Set"]),
        "HuuFirmwareUpdateStatus": MoMeta("HuuFirmwareUpdateStatus", "huuFirmwareUpdateStatus", "updateStatus", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareUpdater'], ['huuUpdateComponentStatus'], ["Get"]),
        "HuuFirmwareUpdater": MoMeta("HuuFirmwareUpdater", "huuFirmwareUpdater", "firmwareUpdater", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['huuController'], [], ["Get"]),
        "HuuUpdateComponentStatus": MoMeta("HuuUpdateComponentStatus", "huuUpdateComponentStatus", "component-[component]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['huuFirmwareUpdateStatus'], [], ["Get"]),
        "IodController": MoMeta("IodController", "iodController", "iod", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["read-only"], ['computeServerNode'], ['iodSnapshotCancel', 'iodSnapshotStart', 'iodSnapshotStatus'], ["Get"]),
        "IodSnapshotCancel": MoMeta("IodSnapshotCancel", "iodSnapshotCancel", "snapshotCancel", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['iodController'], [], [None]),
        "IodSnapshotStart": MoMeta("IodSnapshotStart", "iodSnapshotStart", "snapshotStart", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['iodController'], [], [None]),
        "IodSnapshotStatus": MoMeta("IodSnapshotStatus", "iodSnapshotStatus", "snapshotStatus", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["read-only"], ['iodController'], [], ["Get"]),
        "IpBlocking": MoMeta("IpBlocking", "ipBlocking", "ip-block", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mgmtIf'], [], ["Get", "Set"]),
        "IpFiltering": MoMeta("IpFiltering", "ipFiltering", "ip-filter", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mgmtIf'], [], ["Get", "Set"]),
        "KmipManagement": MoMeta("KmipManagement", "kmipManagement", "kmip-mgmt", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['downloadClientCertificate', 'downloadClientPrivateKey', 'downloadRootCACertificate', 'exportClientCertificate', 'exportClientPrivateKey', 'exportRootCACertificate', 'kmipServer', 'kmipServerLogin'], ["Get", "Set"]),
        "KmipServer": MoMeta("KmipServer", "kmipServer", "kmip-server-[id]", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], ["Get", "Set"]),
        "KmipServerLogin": MoMeta("KmipServerLogin", "kmipServerLogin", "kmip-login", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['kmipManagement'], [], ["Get", "Set"]),
        "LdapCACertificate": MoMeta("LdapCACertificate", "ldapCACertificate", "ldap-ca-cert", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['ldapCACertificateManagement'], [], ["Get", "Set"]),
        "LdapCACertificateManagement": MoMeta("LdapCACertificateManagement", "ldapCACertificateManagement", "ldap-ca-cert-mgmt", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaLdap'], ['downloadLdapCACertificate', 'exportLdapCACertificate', 'ldapCACertificate'], ["Get", "Set"]),
        "LsbootBootSecurity": MoMeta("LsbootBootSecurity", "lsbootBootSecurity", "boot-security", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "user"], ['lsbootDef'], [], ["Get", "Set"]),
        "LsbootDef": MoMeta("LsbootDef", "lsbootDef", "boot-policy", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['lsbootBootSecurity', 'lsbootEfi', 'lsbootLan', 'lsbootStorage', 'lsbootVirtualMedia'], ["Get", "Set"]),
        "LsbootDevPrecision": MoMeta("LsbootDevPrecision", "lsbootDevPrecision", "boot-precision", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['lsbootHdd', 'lsbootHttp', 'lsbootIscsi', 'lsbootNVMe', 'lsbootPchStorage', 'lsbootPxe', 'lsbootSan', 'lsbootSd', 'lsbootUefiShell', 'lsbootUsb', 'lsbootVMedia'], ["Get", "Set"]),
        "LsbootEfi": MoMeta("LsbootEfi", "lsbootEfi", "efi-read-only", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootHdd": MoMeta("LsbootHdd", "lsbootHdd", "hdd-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootHttp": MoMeta("LsbootHttp", "lsbootHttp", "http-[name]", VersionMeta.Version413a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], [None]),
        "LsbootIscsi": MoMeta("LsbootIscsi", "lsbootIscsi", "iscsi-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootLan": MoMeta("LsbootLan", "lsbootLan", "lan-read-only", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootLocalStorage": MoMeta("LsbootLocalStorage", "lsbootLocalStorage", "local-storage", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootStorage'], [], ["Get"]),
        "LsbootNVMe": MoMeta("LsbootNVMe", "lsbootNVMe", "nvme-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Get", "Set"]),
        "LsbootPchStorage": MoMeta("LsbootPchStorage", "lsbootPchStorage", "pchstorage-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootPxe": MoMeta("LsbootPxe", "lsbootPxe", "pxe-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootSan": MoMeta("LsbootSan", "lsbootSan", "san-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootSd": MoMeta("LsbootSd", "lsbootSd", "sd-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootStorage": MoMeta("LsbootStorage", "lsbootStorage", "storage-read-write", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootUefiShell": MoMeta("LsbootUefiShell", "lsbootUefiShell", "uefishell-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootUsb": MoMeta("LsbootUsb", "lsbootUsb", "usb-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootVMedia": MoMeta("LsbootVMedia", "lsbootVMedia", "vm-[name]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDevPrecision'], [], ["Add", "Get", "Remove", "Set"]),
        "LsbootVirtualMedia": MoMeta("LsbootVirtualMedia", "lsbootVirtualMedia", "vm-[access]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['lsbootDef'], [], ["Add", "Get"]),
        "MailRecipient": MoMeta("MailRecipient", "mailRecipient", "mail-recipient-[id]", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['commMailAlert'], [], ["Get", "Remove", "Set"]),
        "MemoryArray": MoMeta("MemoryArray", "memoryArray", "memarray-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'memoryPersistentMemoryUnit', 'memoryUnit'], ["Get", "Set"]),
        "MemoryPersistentMemoryBackup": MoMeta("MemoryPersistentMemoryBackup", "memoryPersistentMemoryBackup", "export-config", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], [], [None]),
        "MemoryPersistentMemoryConfigResult": MoMeta("MemoryPersistentMemoryConfigResult", "memoryPersistentMemoryConfigResult", "cfg-result", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], ['memoryPersistentMemoryNamespaceConfigResult'], [None]),
        "MemoryPersistentMemoryConfiguration": MoMeta("MemoryPersistentMemoryConfiguration", "memoryPersistentMemoryConfiguration", "pmemory-config", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['memoryPersistentMemoryBackup', 'memoryPersistentMemoryConfigResult', 'memoryPersistentMemoryImporter', 'memoryPersistentMemoryRegion'], [None]),
        "MemoryPersistentMemoryDimms": MoMeta("MemoryPersistentMemoryDimms", "memoryPersistentMemoryDimms", "pmemory-dimms-[socket_id]", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], [], [None]),
        "MemoryPersistentMemoryGoal": MoMeta("MemoryPersistentMemoryGoal", "memoryPersistentMemoryGoal", "goal-[socket_id]", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], [], [None]),
        "MemoryPersistentMemoryImporter": MoMeta("MemoryPersistentMemoryImporter", "memoryPersistentMemoryImporter", "import-config", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], [], [None]),
        "MemoryPersistentMemoryLocalSecurity": MoMeta("MemoryPersistentMemoryLocalSecurity", "memoryPersistentMemoryLocalSecurity", "local", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemorySecurity'], [], [None]),
        "MemoryPersistentMemoryLogicalConfiguration": MoMeta("MemoryPersistentMemoryLogicalConfiguration", "memoryPersistentMemoryLogicalConfiguration", "pmemory-lconfig", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['memoryPersistentMemoryDimms', 'memoryPersistentMemoryGoal', 'memoryPersistentMemoryLogicalNamespace', 'memoryPersistentMemorySecurity'], [None]),
        "MemoryPersistentMemoryLogicalNamespace": MoMeta("MemoryPersistentMemoryLogicalNamespace", "memoryPersistentMemoryLogicalNamespace", "lns-[name]", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], [], [None]),
        "MemoryPersistentMemoryNamespace": MoMeta("MemoryPersistentMemoryNamespace", "memoryPersistentMemoryNamespace", "ns-[uuid]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryRegion'], [], [None]),
        "MemoryPersistentMemoryNamespaceConfigResult": MoMeta("MemoryPersistentMemoryNamespaceConfigResult", "memoryPersistentMemoryNamespaceConfigResult", "nscr-[name]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfigResult'], [], [None]),
        "MemoryPersistentMemoryRegion": MoMeta("MemoryPersistentMemoryRegion", "memoryPersistentMemoryRegion", "region-[id]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryConfiguration'], ['memoryPersistentMemoryNamespace'], [None]),
        "MemoryPersistentMemorySecurity": MoMeta("MemoryPersistentMemorySecurity", "memoryPersistentMemorySecurity", "pmemory-security", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['memoryPersistentMemoryLogicalConfiguration'], ['memoryPersistentMemoryLocalSecurity'], [None]),
        "MemoryPersistentMemoryUnit": MoMeta("MemoryPersistentMemoryUnit", "memoryPersistentMemoryUnit", "pmem-[id]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryArray'], [], [None]),
        "MemoryUnit": MoMeta("MemoryUnit", "memoryUnit", "mem-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryArray'], ['faultInst', 'memoryUnitEnvStats'], ["Get"]),
        "MemoryUnitEnvStats": MoMeta("MemoryUnitEnvStats", "memoryUnitEnvStats", "dimm-env-stats", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['memoryUnit'], [], ["Get"]),
        "MgmtBackup": MoMeta("MgmtBackup", "mgmtBackup", "export-config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], [None]),
        "MgmtController": MoMeta("MgmtController", "mgmtController", "mgmt", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['adaptorUnit', 'cloudDeviceConnectorEp', 'computeServerNode', 'equipmentSharedIOModule', 'equipmentSystemIOController', 'storageSasExpander'], ['firmwareBootDefinition', 'firmwareRunning', 'firmwareUpdatable', 'mgmtIf', 'sysdebugMEpLog'], ["Get"]),
        "MgmtIf": MoMeta("MgmtIf", "mgmtIf", "if-1", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis', 'mgmtController'], ['ipBlocking', 'ipFiltering'], ["Get", "Set"]),
        "MgmtImporter": MoMeta("MgmtImporter", "mgmtImporter", "import-config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], [None]),
        "MgmtInventory": MoMeta("MgmtInventory", "mgmtInventory", "inventory", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], [None]),
        "NetworkAdapterEthIf": MoMeta("NetworkAdapterEthIf", "networkAdapterEthIf", "eth-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['networkAdapterUnit'], [], ["Get"]),
        "NetworkAdapterUnit": MoMeta("NetworkAdapterUnit", "networkAdapterUnit", "network-adapter-[slot]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['networkAdapterEthIf'], ["Get"]),
        "OneTimeBootDevice": MoMeta("OneTimeBootDevice", "oneTimeBootDevice", "boot-one-time", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get", "Set"]),
        "OneTimePrecisionBootDevice": MoMeta("OneTimePrecisionBootDevice", "oneTimePrecisionBootDevice", "one-time-precision-boot", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get", "Set"]),
        "OsiCancel": MoMeta("OsiCancel", "osiCancel", "osiCancel", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin"], ['osiController'], [], [None]),
        "OsiController": MoMeta("OsiController", "osiController", "osi", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["read-only"], ['computeServerNode'], ['osiCancel', 'osiStart', 'osiStatus'], ["Get"]),
        "OsiStart": MoMeta("OsiStart", "osiStart", "osiStart", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin"], ['osiController'], [], ["Get"]),
        "OsiStatus": MoMeta("OsiStatus", "osiStatus", "osiStatus", VersionMeta.Version301c, "OutputOnly", 0x1, [], ["read-only"], ['osiController'], [], ["Get"]),
        "PciEquipSlot": MoMeta("PciEquipSlot", "pciEquipSlot", "equipped-slot-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['faultInst', 'graphicsCardTemperature'], ["Get"]),
        "PidCatalog": MoMeta("PidCatalog", "pidCatalog", "pid", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['activatePIDCatalog', 'pidCatalogCpu', 'pidCatalogDimm', 'pidCatalogHdd', 'pidCatalogPCIAdapter'], ["Get"]),
        "PidCatalogCpu": MoMeta("PidCatalogCpu", "pidCatalogCpu", "pid-cpu-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PidCatalogDimm": MoMeta("PidCatalogDimm", "pidCatalogDimm", "pid-dimm-[name]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PidCatalogHdd": MoMeta("PidCatalogHdd", "pidCatalogHdd", "pid-hdd-[disk]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PidCatalogPCIAdapter": MoMeta("PidCatalogPCIAdapter", "pidCatalogPCIAdapter", "pid-pciadapter-[slot]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pidCatalog'], [], ["Get"]),
        "PlatformEventFilters": MoMeta("PlatformEventFilters", "platformEventFilters", "pef-[id]", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['eventManagement'], [], ["Get", "Set"]),
        "PowerBudget": MoMeta("PowerBudget", "powerBudget", "budget", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['customPowerProfile', 'faultInst', 'thermalPowerProfile'], ["Get", "Set"]),
        "PowerMonitor": MoMeta("PowerMonitor", "powerMonitor", "pwrmonitor-[domain]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get"]),
        "ProcessorEnvStats": MoMeta("ProcessorEnvStats", "processorEnvStats", "env-stats", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['processorUnit'], [], ["Get"]),
        "ProcessorUnit": MoMeta("ProcessorUnit", "processorUnit", "cpu-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'processorEnvStats'], ["Get"]),
        "SecureLdap": MoMeta("SecureLdap", "secureLdap", "secure-ldap", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['aaaLdap'], [], [None]),
        "SelfEncryptStorageController": MoMeta("SelfEncryptStorageController", "selfEncryptStorageController", "ctr-self-encrypt", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get", "Set"]),
        "ServerUtilization": MoMeta("ServerUtilization", "serverUtilization", "utilization", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get"]),
        "SolIf": MoMeta("SolIf", "solIf", "sol-if", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get", "Set"]),
        "StorageController": MoMeta("StorageController", "storageController", "storage-[type]-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'firmwareBootDefinition', 'firmwareRunning', 'generatedStorageControllerKeyId', 'selfEncryptStorageController', 'storageControllerHealth', 'storageControllerNextConsistencyCheckSchedule', 'storageControllerNextPatrolReadSchedule', 'storageControllerProps', 'storageControllerSettings', 'storageLocalDisk', 'storageLocalDiskEp', 'storageLocalDiskProps', 'storageRaidBattery', 'storageVirtualDrive', 'storageVirtualDriveCreatorUsingUnusedPhysicalDrive', 'storageVirtualDriveCreatorUsingVirtualDriveGroup', 'suggestedStorageControllerSecurityKey'], ["Get", "Set"]),
        "StorageControllerHealth": MoMeta("StorageControllerHealth", "storageControllerHealth", "controller-health", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "StorageControllerNVMe": MoMeta("StorageControllerNVMe", "storageControllerNVMe", "storage-NVMe-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'firmwareRunning', 'storageNVMePhysicalDrive'], ["Get"]),
        "StorageControllerNextConsistencyCheckSchedule": MoMeta("StorageControllerNextConsistencyCheckSchedule", "storageControllerNextConsistencyCheckSchedule", "consistency-check", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], [None]),
        "StorageControllerNextPatrolReadSchedule": MoMeta("StorageControllerNextPatrolReadSchedule", "storageControllerNextPatrolReadSchedule", "patrol-read", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], [None]),
        "StorageControllerProps": MoMeta("StorageControllerProps", "storageControllerProps", "controller-props", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "StorageControllerSettings": MoMeta("StorageControllerSettings", "storageControllerSettings", "controller-settings", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "StorageFlexFlashController": MoMeta("StorageFlexFlashController", "storageFlexFlashController", "storage-flexflash-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], ['faultInst', 'storageFlexFlashControllerProps', 'storageFlexFlashOperationalProfile', 'storageFlexFlashPhysicalDrive', 'storageFlexFlashVirtualDrive', 'storageFlexFlashVirtualDriveImageMap'], ["Get", "Set"]),
        "StorageFlexFlashControllerProps": MoMeta("StorageFlexFlashControllerProps", "storageFlexFlashControllerProps", "flexflashcontroller-props", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], [], ["Get"]),
        "StorageFlexFlashOperationalProfile": MoMeta("StorageFlexFlashOperationalProfile", "storageFlexFlashOperationalProfile", "oper-profile", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], [], ["Get", "Set"]),
        "StorageFlexFlashPhysicalDrive": MoMeta("StorageFlexFlashPhysicalDrive", "storageFlexFlashPhysicalDrive", "card-[physical_drive_id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], ['faultInst'], ["Get"]),
        "StorageFlexFlashVirtualDrive": MoMeta("StorageFlexFlashVirtualDrive", "storageFlexFlashVirtualDrive", "vd-[partition_id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], ['faultInst'], ["Get", "Set"]),
        "StorageFlexFlashVirtualDriveImageMap": MoMeta("StorageFlexFlashVirtualDriveImageMap", "storageFlexFlashVirtualDriveImageMap", "vdrive-map-[virtual_drive]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageFlexFlashController'], [], ["Get", "Set"]),
        "StorageLocalDisk": MoMeta("StorageLocalDisk", "storageLocalDisk", "pd-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], ['faultInst', 'storageLocalDiskProps', 'storageOperation'], ["Get", "Set"]),
        "StorageLocalDiskProps": MoMeta("StorageLocalDiskProps", "storageLocalDiskProps", "general-props", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController', 'storageLocalDisk'], [], ["Get"]),
        "StorageLocalDiskSlotEp": MoMeta("StorageLocalDiskSlotEp", "storageLocalDiskSlotEp", "disk-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get"]),
        "StorageLocalDiskUsage": MoMeta("StorageLocalDiskUsage", "storageLocalDiskUsage", "pd-[physical_drive]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageVirtualDrive'], [], ["Get"]),
        "StorageNVMePhysicalDrive": MoMeta("StorageNVMePhysicalDrive", "storageNVMePhysicalDrive", "pd-[id]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageControllerNVMe'], ['faultInst'], ["Get"]),
        "StorageOperation": MoMeta("StorageOperation", "storageOperation", "storage-operation", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageLocalDisk', 'storageVirtualDrive'], [], ["Get"]),
        "StorageRaidBattery": MoMeta("StorageRaidBattery", "storageRaidBattery", "raid-battery", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], ['faultInst'], ["Get", "Set"]),
        "StorageSasExpander": MoMeta("StorageSasExpander", "storageSasExpander", "sas-expander-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["read-only"], ['equipmentChassis'], ['faultInst', 'mgmtController', 'storageSasUplink'], ["Get"]),
        "StorageUnusedLocalDisk": MoMeta("StorageUnusedLocalDisk", "storageUnusedLocalDisk", "pd-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageVirtualDriveCreatorUsingUnusedPhysicalDrive'], [], ["Get"]),
        "StorageVirtualDrive": MoMeta("StorageVirtualDrive", "storageVirtualDrive", "vd-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['storageController'], ['faultInst', 'storageLocalDiskUsage', 'storageOperation'], ["Get", "Remove", "Set"]),
        "StorageVirtualDriveCreatorUsingUnusedPhysicalDrive": MoMeta("StorageVirtualDriveCreatorUsingUnusedPhysicalDrive", "storageVirtualDriveCreatorUsingUnusedPhysicalDrive", "virtual-drive-create", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['storageController'], ['storageUnusedLocalDisk'], ["Get", "Set"]),
        "StorageVirtualDriveCreatorUsingVirtualDriveGroup": MoMeta("StorageVirtualDriveCreatorUsingVirtualDriveGroup", "storageVirtualDriveCreatorUsingVirtualDriveGroup", "virtual-drive-carve", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['storageController'], ['storageVirtualDriveWithDriveGroupSpace'], ["Get", "Set"]),
        "StorageVirtualDriveWithDriveGroupSpace": MoMeta("StorageVirtualDriveWithDriveGroupSpace", "storageVirtualDriveWithDriveGroupSpace", "vd-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageVirtualDriveCreatorUsingVirtualDriveGroup'], [], ["Get"]),
        "SuggestedStorageControllerSecurityKey": MoMeta("SuggestedStorageControllerSecurityKey", "suggestedStorageControllerSecurityKey", "suggested-sec-key", VersionMeta.Version303a, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], [], ["Get"]),
        "SysdebugMEpLog": MoMeta("SysdebugMEpLog", "sysdebugMEpLog", "log-[type]-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['mgmtController'], ['faultInst'], ["Get", "Set"]),
        "SysdebugTechSupportExport": MoMeta("SysdebugTechSupportExport", "sysdebugTechSupportExport", "tech-support", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis', 'topSystem'], [], [None]),
        "TopRoot": MoMeta("TopRoot", "topRoot", "", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], [], ['topSystem'], ["Get"]),
        "TopSystem": MoMeta("TopSystem", "topSystem", "sys", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topRoot'], ['aaaLdap', 'aaaTacacsPlus', 'aaaUserEp', 'certificateManagement', 'cloudMgmtSvc', 'commSvcEp', 'equipmentChassis', 'sysdebugTechSupportExport'], ["Get", "Set"]),
        "UploadBiosProfile": MoMeta("UploadBiosProfile", "uploadBiosProfile", "upload-bios-profile", VersionMeta.Version301c, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['biosProfileManagement'], [], [None]),
        "UploadCertificate": MoMeta("UploadCertificate", "uploadCertificate", "upload-cert", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "UploadExternalCertificate": MoMeta("UploadExternalCertificate", "uploadExternalCertificate", "external-cert-upload", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "UploadExternalPrivateKey": MoMeta("UploadExternalPrivateKey", "uploadExternalPrivateKey", "external-pvt-key-upload", VersionMeta.Version412a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['certificateManagement'], [], [None]),
        "UploadPIDCatalog": MoMeta("UploadPIDCatalog", "uploadPIDCatalog", "upload-catalog", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['chassisPIDCatalog'], [], ["Get"]),
        "VicBackupAll": MoMeta("VicBackupAll", "vicBackupAll", "vic-all-exportconfig", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], ["Get", "Set"]),
        "VicImporterAll": MoMeta("VicImporterAll", "vicImporterAll", "vic-all-importconfig", VersionMeta.Version303a, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], ["Get", "Set"]),
        "AdapterSecureUpdate": MoMeta("AdapterSecureUpdate", "adapterSecureUpdate", "adapter-secure-update", VersionMeta.Version404b, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], [None]),
        "AutoPowerProfile": MoMeta("AutoPowerProfile", "autoPowerProfile", "auto-prof", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['chassisPowerBudget'], [], ["Get", "Set"]),
        "BmcResetReason": MoMeta("BmcResetReason", "bmcResetReason", "bmc-reset-reason", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get"]),
        "ChassisPIDCatalog": MoMeta("ChassisPIDCatalog", "chassisPIDCatalog", "pid", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], ['uploadPIDCatalog'], ["Get"]),
        "ChassisPowerBudget": MoMeta("ChassisPowerBudget", "chassisPowerBudget", "budget", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], ['autoPowerProfile'], ["Get"]),
        "ChassisPowerMonitor": MoMeta("ChassisPowerMonitor", "chassisPowerMonitor", "pwrmonitor", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], ["Get"]),
        "ChassisPowerUtilization": MoMeta("ChassisPowerUtilization", "chassisPowerUtilization", "utilization", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], ["Get"]),
        "CommEpIpmiLan": MoMeta("CommEpIpmiLan", "commEpIpmiLan", "cmc-ipmi-lan", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentSharedIOModule', 'equipmentSystemIOController'], [], ["Get", "Set"]),
        "CommSvcRack": MoMeta("CommSvcRack", "commSvcRack", "svc-ext", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], ['commIpmiLan', 'commKvm', 'commVMedia'], ["Get"]),
        "ComputeServerNode": MoMeta("ComputeServerNode", "computeServerNode", "server-[server_id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], ['adapterSecureUpdate', 'adaptorUnit', 'biosUnit', 'bmcResetReason', 'commSvcRack', 'computeBoard', 'equipmentFanModule', 'equipmentIndicatorLed', 'equipmentLocatorLed', 'equipmentPsu', 'faultInst', 'huuController', 'ioExpander', 'iodController', 'kmipManagement', 'lsbootDef', 'lsbootDevPrecision', 'mgmtBackupServer', 'mgmtController', 'mgmtImporterServer', 'networkAdapterUnit', 'oneTimeBootDevice', 'oneTimePrecisionBootDevice', 'osiController', 'pciEquipSlot', 'powerBudget', 'powerMonitor', 'serverUtilization', 'solIf'], ["Get", "Set"]),
        "ComputeServerNodeMbTempStats": MoMeta("ComputeServerNodeMbTempStats", "computeServerNodeMbTempStats", "temp-stats", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeBoard'], [], ["Get"]),
        "ComputeServerRef": MoMeta("ComputeServerRef", "computeServerRef", "server-ref-[ownership]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageEnclosureDiskSlotEp'], [], ["Get"]),
        "ComputeSharedIOMbPowerStats": MoMeta("ComputeSharedIOMbPowerStats", "computeSharedIOMbPowerStats", "power-stats", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentSharedIOModule'], [], ["Get"]),
        "ComputeSharedIOMbTempStats": MoMeta("ComputeSharedIOMbTempStats", "computeSharedIOMbTempStats", "temp-stats", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentSharedIOModule'], [], ["Get"]),
        "CustomPowerProfile": MoMeta("CustomPowerProfile", "customPowerProfile", "cust-prof", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['powerBudget'], [], ["Get", "Set"]),
        "EquipmentChassis": MoMeta("EquipmentChassis", "equipmentChassis", "chassis-1", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['topSystem'], ['chassisPIDCatalog', 'chassisPowerBudget', 'chassisPowerMonitor', 'chassisPowerUtilization', 'computeServerNode', 'equipmentChassisLocatorLed', 'equipmentFanModule', 'equipmentIndicatorLed', 'equipmentPsu', 'equipmentSystemIOController', 'eventManagement', 'faultInst', 'mgmtBackup', 'mgmtIf', 'mgmtImporter', 'mgmtInventory', 'storageEnclosure', 'storageSasExpander', 'sysdebugTechSupportExport', 'vicBackupAll', 'vicImporterAll'], ["Get"]),
        "EquipmentChassisLocatorLed": MoMeta("EquipmentChassisLocatorLed", "equipmentChassisLocatorLed", "chassis-locator-led", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], [], ["Get", "Set"]),
        "EquipmentSharedIOModule": MoMeta("EquipmentSharedIOModule", "equipmentSharedIOModule", "shared-io-module-[slot_id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentSystemIOController'], ['commEpIpmiLan', 'computeSharedIOMbPowerStats', 'computeSharedIOMbTempStats', 'mgmtController'], ["Get"]),
        "EquipmentSystemIOController": MoMeta("EquipmentSystemIOController", "equipmentSystemIOController", "slot-[id]", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], ['commEpIpmiLan', 'equipmentSharedIOModule', 'faultInst', 'mgmtController', 'siocResetReason', 'systemIOControllerNVMe'], ["Get", "Set"]),
        "GraphicsCardTemperature": MoMeta("GraphicsCardTemperature", "graphicsCardTemperature", "graphics-card-temp-[id]", VersionMeta.Version411c, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['pciEquipSlot'], [], [None]),
        "IoControllerNVMePhysicalDrive": MoMeta("IoControllerNVMePhysicalDrive", "ioControllerNVMePhysicalDrive", "pd-[id]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['systemIOControllerNVMe'], ['faultInst'], [None]),
        "IoExpander": MoMeta("IoExpander", "ioExpander", "io-expander", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get"]),
        "MgmtBackupServer": MoMeta("MgmtBackupServer", "mgmtBackupServer", "exporter-config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get", "Set"]),
        "MgmtImporterServer": MoMeta("MgmtImporterServer", "mgmtImporterServer", "importer-config", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['computeServerNode'], [], ["Get", "Set"]),
        "SiocResetReason": MoMeta("SiocResetReason", "siocResetReason", "sioc-reset-reason", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentSystemIOController'], [], ["Get"]),
        "StorageEnclosure": MoMeta("StorageEnclosure", "storageEnclosure", "enc-1", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['equipmentChassis'], ['storageEnclosureDisk', 'storageEnclosureDiskFwHelper', 'storageEnclosureDiskSlotEp', 'storageEnclosureDiskSlotZoneHelper'], ["Get", "Set"]),
        "StorageEnclosureDisk": MoMeta("StorageEnclosureDisk", "storageEnclosureDisk", "disk-[slot]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageEnclosure'], [], ["Get"]),
        "StorageEnclosureDiskFwHelper": MoMeta("StorageEnclosureDiskFwHelper", "storageEnclosureDiskFwHelper", "drive-fw-update", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['storageEnclosure'], [], ["Get", "Set"]),
        "StorageEnclosureDiskSlotEp": MoMeta("StorageEnclosureDiskSlotEp", "storageEnclosureDiskSlotEp", "disk-slot-[slot]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageEnclosure'], ['computeServerRef', 'faultInst'], ["Get"]),
        "StorageEnclosureDiskSlotZoneHelper": MoMeta("StorageEnclosureDiskSlotZoneHelper", "storageEnclosureDiskSlotZoneHelper", "zone-drive", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin"], ['storageEnclosure'], [], ["Get", "Set"]),
        "StorageLocalDiskEp": MoMeta("StorageLocalDiskEp", "storageLocalDiskEp", "diskRef-[id]", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['storageController'], ['faultInst'], ["Get"]),
        "StorageSasUplink": MoMeta("StorageSasUplink", "storageSasUplink", "uplink", VersionMeta.Version2013e, "OutputOnly", 0x1, [], ["read-only"], ['storageSasExpander'], [], ["Get"]),
        "SystemIOControllerNVMe": MoMeta("SystemIOControllerNVMe", "systemIOControllerNVMe", "sioc-NVMe-[id]", VersionMeta.Version404b, "OutputOnly", 0x1, [], ["admin", "read-only", "user"], ['equipmentSystemIOController'], ['faultInst', 'ioControllerNVMePhysicalDrive'], [None]),
        "ThermalPowerProfile": MoMeta("ThermalPowerProfile", "thermalPowerProfile", "thermal-prof", VersionMeta.Version2013e, "InputOutput", 0x1, [], ["admin", "read-only", "user"], ['powerBudget'], [], ["Get", "Set"]),
    }
}


METHOD_CLASS_ID = frozenset([
    "AaaGetComputeAuthTokens",
    "AaaKeepAlive",
    "AaaLogin",
    "AaaLogout",
    "AaaRefresh",
    "ConfigConfMo",
    "ConfigConfMos",
    "ConfigResolveChildren",
    "ConfigResolveClass",
    "ConfigResolveDn",
    "ConfigResolveParent",
    "EventSubscribe",
    "EventUnsubscribe",
])


OTHER_TYPE_CLASS_ID = {
    "Method": "imcbasetype",
    "AllbitsFilter": "imcfiltertype",
    "AndFilter": "imcfiltertype",
    "AnybitFilter": "imcfiltertype",
    "BwFilter": "imcfiltertype",
    "ConfigConfig": "imcbasetype",
    "ConfigMap": "imcbasetype",
    "ConfigSet": "imcbasetype",
    "EqFilter": "imcfiltertype",
    "FailedMo": "imcbasetype",
    "FailedMos": "imcbasetype",
    "FilterFilter": "imcbasetype",
    "GeFilter": "imcfiltertype",
    "GtFilter": "imcfiltertype",
    "LeFilter": "imcfiltertype",
    "LtFilter": "imcfiltertype",
    "NeFilter": "imcfiltertype",
    "NotFilter": "imcfiltertype",
    "OrFilter": "imcfiltertype",
    "Pair": "imcbasetype",
    "WcardFilter": "imcfiltertype",
}
