#include "main.hpp"

#if (U_ICU_VERSION_MAJOR_NUM >= 63)
#include "ucpmapptr.hpp"
#endif // (U_ICU_VERSION_MAJOR_NUM >= 63)

#include "usetptr.hpp"
#include <memory>
#include <pybind11/stl.h>
#include <unicode/uchar.h>

using namespace icu;

void init_uchar(py::module &m) {
#if (U_ICU_VERSION_MAJOR_NUM >= 52)
  py::enum_<UBidiPairedBracketType>(m, "UBidiPairedBracketType", py::arithmetic(),
                                    "Bidi Paired Bracket Type constants.")
      .value("U_BPT_NONE", U_BPT_NONE, "Not a paired bracket.")
      .value("U_BPT_OPEN", U_BPT_OPEN, "Open paired bracket.")
      .value("U_BPT_CLOSE", U_BPT_CLOSE, "Close paired bracket.")
#ifndef U_HIDE_DEPRECATED_API
      .value("U_BPT_COUNT", U_BPT_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();
#endif // (U_ICU_VERSION_MAJOR_NUM >= 52)

  py::enum_<UBlockCode>(m, "UBlockCode", py::arithmetic(),
                        "Constants for Unicode blocks, see the Unicode Data file Blocks.txt.")
      .value("UBLOCK_NO_BLOCK", UBLOCK_NO_BLOCK, "New No_Block value in Unicode 4.")
      .value("UBLOCK_BASIC_LATIN", UBLOCK_BASIC_LATIN)
      .value("UBLOCK_LATIN_1_SUPPLEMENT", UBLOCK_LATIN_1_SUPPLEMENT)
      .value("UBLOCK_LATIN_EXTENDED_A", UBLOCK_LATIN_EXTENDED_A)
      .value("UBLOCK_LATIN_EXTENDED_B", UBLOCK_LATIN_EXTENDED_B)
      .value("UBLOCK_IPA_EXTENSIONS", UBLOCK_IPA_EXTENSIONS)
      .value("UBLOCK_SPACING_MODIFIER_LETTERS", UBLOCK_SPACING_MODIFIER_LETTERS)
      .value("UBLOCK_COMBINING_DIACRITICAL_MARKS", UBLOCK_COMBINING_DIACRITICAL_MARKS)
      .value("UBLOCK_GREEK", UBLOCK_GREEK, "Unicode 3.2 renames this block to \"Greek and Coptic\".")
      .value("UBLOCK_CYRILLIC", UBLOCK_CYRILLIC)
      .value("UBLOCK_ARMENIAN", UBLOCK_ARMENIAN)
      .value("UBLOCK_HEBREW", UBLOCK_HEBREW)
      .value("UBLOCK_ARABIC", UBLOCK_ARABIC)
      .value("UBLOCK_SYRIAC", UBLOCK_SYRIAC)
      .value("UBLOCK_THAANA", UBLOCK_THAANA)
      .value("UBLOCK_DEVANAGARI", UBLOCK_DEVANAGARI)
      .value("UBLOCK_BENGALI", UBLOCK_BENGALI)
      .value("UBLOCK_GURMUKHI", UBLOCK_GURMUKHI)
      .value("UBLOCK_GUJARATI", UBLOCK_GUJARATI)
      .value("UBLOCK_ORIYA", UBLOCK_ORIYA)
      .value("UBLOCK_TAMIL", UBLOCK_TAMIL)
      .value("UBLOCK_TELUGU", UBLOCK_TELUGU)
      .value("UBLOCK_KANNADA", UBLOCK_KANNADA)
      .value("UBLOCK_MALAYALAM", UBLOCK_MALAYALAM)
      .value("UBLOCK_SINHALA", UBLOCK_SINHALA)
      .value("UBLOCK_THAI", UBLOCK_THAI)
      .value("UBLOCK_LAO", UBLOCK_LAO)
      .value("UBLOCK_TIBETAN", UBLOCK_TIBETAN)
      .value("UBLOCK_MYANMAR", UBLOCK_MYANMAR)
      .value("UBLOCK_GEORGIAN", UBLOCK_GEORGIAN)
      .value("UBLOCK_HANGUL_JAMO", UBLOCK_HANGUL_JAMO)
      .value("UBLOCK_ETHIOPIC", UBLOCK_ETHIOPIC)
      .value("UBLOCK_CHEROKEE", UBLOCK_CHEROKEE)
      .value("UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS)
      .value("UBLOCK_OGHAM", UBLOCK_OGHAM)
      .value("UBLOCK_RUNIC", UBLOCK_RUNIC)
      .value("UBLOCK_KHMER", UBLOCK_KHMER)
      .value("UBLOCK_MONGOLIAN", UBLOCK_MONGOLIAN)
      .value("UBLOCK_LATIN_EXTENDED_ADDITIONAL", UBLOCK_LATIN_EXTENDED_ADDITIONAL)
      .value("UBLOCK_GREEK_EXTENDED", UBLOCK_GREEK_EXTENDED)
      .value("UBLOCK_GENERAL_PUNCTUATION", UBLOCK_GENERAL_PUNCTUATION)
      .value("UBLOCK_SUPERSCRIPTS_AND_SUBSCRIPTS", UBLOCK_SUPERSCRIPTS_AND_SUBSCRIPTS)
      .value("UBLOCK_CURRENCY_SYMBOLS", UBLOCK_CURRENCY_SYMBOLS)
      .value("UBLOCK_COMBINING_MARKS_FOR_SYMBOLS", UBLOCK_COMBINING_MARKS_FOR_SYMBOLS,
             "Unicode 3.2 renames this block to \"Combining Diacritical Marks for Symbols\".")
      .value("UBLOCK_LETTERLIKE_SYMBOLS", UBLOCK_LETTERLIKE_SYMBOLS)
      .value("UBLOCK_NUMBER_FORMS", UBLOCK_NUMBER_FORMS)
      .value("UBLOCK_ARROWS", UBLOCK_ARROWS)
      .value("UBLOCK_MATHEMATICAL_OPERATORS", UBLOCK_MATHEMATICAL_OPERATORS)
      .value("UBLOCK_MISCELLANEOUS_TECHNICAL", UBLOCK_MISCELLANEOUS_TECHNICAL)
      .value("UBLOCK_CONTROL_PICTURES", UBLOCK_CONTROL_PICTURES)
      .value("UBLOCK_OPTICAL_CHARACTER_RECOGNITION", UBLOCK_OPTICAL_CHARACTER_RECOGNITION)
      .value("UBLOCK_ENCLOSED_ALPHANUMERICS", UBLOCK_ENCLOSED_ALPHANUMERICS)
      .value("UBLOCK_BOX_DRAWING", UBLOCK_BOX_DRAWING)
      .value("UBLOCK_BLOCK_ELEMENTS", UBLOCK_BLOCK_ELEMENTS)
      .value("UBLOCK_GEOMETRIC_SHAPES", UBLOCK_GEOMETRIC_SHAPES)
      .value("UBLOCK_MISCELLANEOUS_SYMBOLS", UBLOCK_MISCELLANEOUS_SYMBOLS)
      .value("UBLOCK_DINGBATS", UBLOCK_DINGBATS)
      .value("UBLOCK_BRAILLE_PATTERNS", UBLOCK_BRAILLE_PATTERNS)
      .value("UBLOCK_CJK_RADICALS_SUPPLEMENT", UBLOCK_CJK_RADICALS_SUPPLEMENT)
      .value("UBLOCK_KANGXI_RADICALS", UBLOCK_KANGXI_RADICALS)
      .value("UBLOCK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS", UBLOCK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS)
      .value("UBLOCK_CJK_SYMBOLS_AND_PUNCTUATION", UBLOCK_CJK_SYMBOLS_AND_PUNCTUATION)
      .value("UBLOCK_HIRAGANA", UBLOCK_HIRAGANA)
      .value("UBLOCK_KATAKANA", UBLOCK_KATAKANA)
      .value("UBLOCK_BOPOMOFO", UBLOCK_BOPOMOFO)
      .value("UBLOCK_HANGUL_COMPATIBILITY_JAMO", UBLOCK_HANGUL_COMPATIBILITY_JAMO)
      .value("UBLOCK_KANBUN", UBLOCK_KANBUN)
      .value("UBLOCK_BOPOMOFO_EXTENDED", UBLOCK_BOPOMOFO_EXTENDED)
      .value("UBLOCK_ENCLOSED_CJK_LETTERS_AND_MONTHS", UBLOCK_ENCLOSED_CJK_LETTERS_AND_MONTHS)
      .value("UBLOCK_CJK_COMPATIBILITY", UBLOCK_CJK_COMPATIBILITY)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS", UBLOCK_CJK_UNIFIED_IDEOGRAPHS)
      .value("UBLOCK_YI_SYLLABLES", UBLOCK_YI_SYLLABLES)
      .value("UBLOCK_YI_RADICALS", UBLOCK_YI_RADICALS)
      .value("UBLOCK_HANGUL_SYLLABLES", UBLOCK_HANGUL_SYLLABLES)
      .value("UBLOCK_HIGH_SURROGATES", UBLOCK_HIGH_SURROGATES)
      .value("UBLOCK_HIGH_PRIVATE_USE_SURROGATES", UBLOCK_HIGH_PRIVATE_USE_SURROGATES)
      .value("UBLOCK_LOW_SURROGATES", UBLOCK_LOW_SURROGATES)
      .value("UBLOCK_PRIVATE_USE_AREA", UBLOCK_PRIVATE_USE_AREA,
             "Same as UBLOCK_PRIVATE_USE.\n\n  "
             "Until Unicode 3.1.1, the corresponding block name was \"Private Use\", and multiple code point ranges "
             "had this block. Unicode 3.2 renames the block for the BMP PUA to \"Private Use Area\" and adds separate "
             "blocks for the supplementary PUAs.")
      .value("UBLOCK_PRIVATE_USE", UBLOCK_PRIVATE_USE,
             "Same as UBLOCK_PRIVATE_USE_AREA.\n\n  "
             "Until Unicode 3.1.1, the corresponding block name was \"Private Use\", and multiple code point ranges "
             "had this block. Unicode 3.2 renames the block for the BMP PUA to \"Private Use Area\" and adds separate "
             "blocks for the supplementary PUAs.")
      .value("UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS", UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS)
      .value("UBLOCK_ALPHABETIC_PRESENTATION_FORMS", UBLOCK_ALPHABETIC_PRESENTATION_FORMS)
      .value("UBLOCK_ARABIC_PRESENTATION_FORMS_A", UBLOCK_ARABIC_PRESENTATION_FORMS_A)
      .value("UBLOCK_COMBINING_HALF_MARKS", UBLOCK_COMBINING_HALF_MARKS)
      .value("UBLOCK_CJK_COMPATIBILITY_FORMS", UBLOCK_CJK_COMPATIBILITY_FORMS)
      .value("UBLOCK_SMALL_FORM_VARIANTS", UBLOCK_SMALL_FORM_VARIANTS)
      .value("UBLOCK_ARABIC_PRESENTATION_FORMS_B", UBLOCK_ARABIC_PRESENTATION_FORMS_B)
      .value("UBLOCK_SPECIALS", UBLOCK_SPECIALS)
      .value("UBLOCK_HALFWIDTH_AND_FULLWIDTH_FORMS", UBLOCK_HALFWIDTH_AND_FULLWIDTH_FORMS)
      .value("UBLOCK_OLD_ITALIC", UBLOCK_OLD_ITALIC)
      .value("UBLOCK_GOTHIC", UBLOCK_GOTHIC)
      .value("UBLOCK_DESERET", UBLOCK_DESERET)
      .value("UBLOCK_BYZANTINE_MUSICAL_SYMBOLS", UBLOCK_BYZANTINE_MUSICAL_SYMBOLS)
      .value("UBLOCK_MUSICAL_SYMBOLS", UBLOCK_MUSICAL_SYMBOLS)
      .value("UBLOCK_MATHEMATICAL_ALPHANUMERIC_SYMBOLS", UBLOCK_MATHEMATICAL_ALPHANUMERIC_SYMBOLS)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B)
      .value("UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT)
      .value("UBLOCK_TAGS", UBLOCK_TAGS)
      .value("UBLOCK_CYRILLIC_SUPPLEMENT", UBLOCK_CYRILLIC_SUPPLEMENT)
      .value("UBLOCK_CYRILLIC_SUPPLEMENTARY", UBLOCK_CYRILLIC_SUPPLEMENTARY,
             "Unicode 4.0.1 renames the \"Cyrillic Supplementary\" block to \"Cyrillic Supplement\".")
      .value("UBLOCK_TAGALOG", UBLOCK_TAGALOG)
      .value("UBLOCK_HANUNOO", UBLOCK_HANUNOO)
      .value("UBLOCK_BUHID", UBLOCK_BUHID)
      .value("UBLOCK_TAGBANWA", UBLOCK_TAGBANWA)
      .value("UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A)
      .value("UBLOCK_SUPPLEMENTAL_ARROWS_A", UBLOCK_SUPPLEMENTAL_ARROWS_A)
      .value("UBLOCK_SUPPLEMENTAL_ARROWS_B", UBLOCK_SUPPLEMENTAL_ARROWS_B)
      .value("UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B)
      .value("UBLOCK_SUPPLEMENTAL_MATHEMATICAL_OPERATORS", UBLOCK_SUPPLEMENTAL_MATHEMATICAL_OPERATORS)
      .value("UBLOCK_KATAKANA_PHONETIC_EXTENSIONS", UBLOCK_KATAKANA_PHONETIC_EXTENSIONS)
      .value("UBLOCK_VARIATION_SELECTORS", UBLOCK_VARIATION_SELECTORS)
      .value("UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_A", UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_A)
      .value("UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_B", UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_B)
      .value("UBLOCK_LIMBU", UBLOCK_LIMBU)
      .value("UBLOCK_TAI_LE", UBLOCK_TAI_LE)
      .value("UBLOCK_KHMER_SYMBOLS", UBLOCK_KHMER_SYMBOLS)
      .value("UBLOCK_PHONETIC_EXTENSIONS", UBLOCK_PHONETIC_EXTENSIONS)
      .value("UBLOCK_MISCELLANEOUS_SYMBOLS_AND_ARROWS", UBLOCK_MISCELLANEOUS_SYMBOLS_AND_ARROWS)
      .value("UBLOCK_YIJING_HEXAGRAM_SYMBOLS", UBLOCK_YIJING_HEXAGRAM_SYMBOLS)
      .value("UBLOCK_LINEAR_B_SYLLABARY", UBLOCK_LINEAR_B_SYLLABARY)
      .value("UBLOCK_LINEAR_B_IDEOGRAMS", UBLOCK_LINEAR_B_IDEOGRAMS)
      .value("UBLOCK_AEGEAN_NUMBERS", UBLOCK_AEGEAN_NUMBERS)
      .value("UBLOCK_UGARITIC", UBLOCK_UGARITIC)
      .value("UBLOCK_SHAVIAN", UBLOCK_SHAVIAN)
      .value("UBLOCK_OSMANYA", UBLOCK_OSMANYA)
      .value("UBLOCK_CYPRIOT_SYLLABARY", UBLOCK_CYPRIOT_SYLLABARY)
      .value("UBLOCK_TAI_XUAN_JING_SYMBOLS", UBLOCK_TAI_XUAN_JING_SYMBOLS)
      .value("UBLOCK_VARIATION_SELECTORS_SUPPLEMENT", UBLOCK_VARIATION_SELECTORS_SUPPLEMENT)
      .value("UBLOCK_ANCIENT_GREEK_MUSICAL_NOTATION", UBLOCK_ANCIENT_GREEK_MUSICAL_NOTATION)
      .value("UBLOCK_ANCIENT_GREEK_NUMBERS", UBLOCK_ANCIENT_GREEK_NUMBERS)
      .value("UBLOCK_ARABIC_SUPPLEMENT", UBLOCK_ARABIC_SUPPLEMENT)
      .value("UBLOCK_BUGINESE", UBLOCK_BUGINESE)
      .value("UBLOCK_CJK_STROKES", UBLOCK_CJK_STROKES)
      .value("UBLOCK_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT", UBLOCK_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT)
      .value("UBLOCK_COPTIC", UBLOCK_COPTIC)
      .value("UBLOCK_ETHIOPIC_EXTENDED", UBLOCK_ETHIOPIC_EXTENDED)
      .value("UBLOCK_ETHIOPIC_SUPPLEMENT", UBLOCK_ETHIOPIC_SUPPLEMENT)
      .value("UBLOCK_GEORGIAN_SUPPLEMENT", UBLOCK_GEORGIAN_SUPPLEMENT)
      .value("UBLOCK_GLAGOLITIC", UBLOCK_GLAGOLITIC)
      .value("UBLOCK_KHAROSHTHI", UBLOCK_KHAROSHTHI)
      .value("UBLOCK_MODIFIER_TONE_LETTERS", UBLOCK_MODIFIER_TONE_LETTERS)
      .value("UBLOCK_NEW_TAI_LUE", UBLOCK_NEW_TAI_LUE)
      .value("UBLOCK_OLD_PERSIAN", UBLOCK_OLD_PERSIAN)
      .value("UBLOCK_PHONETIC_EXTENSIONS_SUPPLEMENT", UBLOCK_PHONETIC_EXTENSIONS_SUPPLEMENT)
      .value("UBLOCK_SUPPLEMENTAL_PUNCTUATION", UBLOCK_SUPPLEMENTAL_PUNCTUATION)
      .value("UBLOCK_SYLOTI_NAGRI", UBLOCK_SYLOTI_NAGRI)
      .value("UBLOCK_TIFINAGH", UBLOCK_TIFINAGH)
      .value("UBLOCK_VERTICAL_FORMS", UBLOCK_VERTICAL_FORMS)
      .value("UBLOCK_NKO", UBLOCK_NKO)
      .value("UBLOCK_BALINESE", UBLOCK_BALINESE)
      .value("UBLOCK_LATIN_EXTENDED_C", UBLOCK_LATIN_EXTENDED_C)
      .value("UBLOCK_LATIN_EXTENDED_D", UBLOCK_LATIN_EXTENDED_D)
      .value("UBLOCK_PHAGS_PA", UBLOCK_PHAGS_PA)
      .value("UBLOCK_PHOENICIAN", UBLOCK_PHOENICIAN)
      .value("UBLOCK_CUNEIFORM", UBLOCK_CUNEIFORM)
      .value("UBLOCK_CUNEIFORM_NUMBERS_AND_PUNCTUATION", UBLOCK_CUNEIFORM_NUMBERS_AND_PUNCTUATION)
      .value("UBLOCK_COUNTING_ROD_NUMERALS", UBLOCK_COUNTING_ROD_NUMERALS)
      .value("UBLOCK_SUNDANESE", UBLOCK_SUNDANESE)
      .value("UBLOCK_LEPCHA", UBLOCK_LEPCHA)
      .value("UBLOCK_OL_CHIKI", UBLOCK_OL_CHIKI)
      .value("UBLOCK_CYRILLIC_EXTENDED_A", UBLOCK_CYRILLIC_EXTENDED_A)
      .value("UBLOCK_VAI", UBLOCK_VAI)
      .value("UBLOCK_CYRILLIC_EXTENDED_B", UBLOCK_CYRILLIC_EXTENDED_B)
      .value("UBLOCK_SAURASHTRA", UBLOCK_SAURASHTRA)
      .value("UBLOCK_KAYAH_LI", UBLOCK_KAYAH_LI)
      .value("UBLOCK_REJANG", UBLOCK_REJANG)
      .value("UBLOCK_CHAM", UBLOCK_CHAM)
      .value("UBLOCK_ANCIENT_SYMBOLS", UBLOCK_ANCIENT_SYMBOLS)
      .value("UBLOCK_PHAISTOS_DISC", UBLOCK_PHAISTOS_DISC)
      .value("UBLOCK_LYCIAN", UBLOCK_LYCIAN)
      .value("UBLOCK_CARIAN", UBLOCK_CARIAN)
      .value("UBLOCK_LYDIAN", UBLOCK_LYDIAN)
      .value("UBLOCK_MAHJONG_TILES", UBLOCK_MAHJONG_TILES)
      .value("UBLOCK_DOMINO_TILES", UBLOCK_DOMINO_TILES)
      .value("UBLOCK_SAMARITAN", UBLOCK_SAMARITAN)
      .value("UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED",
             UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED)
      .value("UBLOCK_TAI_THAM", UBLOCK_TAI_THAM)
      .value("UBLOCK_VEDIC_EXTENSIONS", UBLOCK_VEDIC_EXTENSIONS)
      .value("UBLOCK_LISU", UBLOCK_LISU)
      .value("UBLOCK_BAMUM", UBLOCK_BAMUM)
      .value("UBLOCK_COMMON_INDIC_NUMBER_FORMS", UBLOCK_COMMON_INDIC_NUMBER_FORMS)
      .value("UBLOCK_DEVANAGARI_EXTENDED", UBLOCK_DEVANAGARI_EXTENDED)
      .value("UBLOCK_HANGUL_JAMO_EXTENDED_A", UBLOCK_HANGUL_JAMO_EXTENDED_A)
      .value("UBLOCK_JAVANESE", UBLOCK_JAVANESE)
      .value("UBLOCK_MYANMAR_EXTENDED_A", UBLOCK_MYANMAR_EXTENDED_A)
      .value("UBLOCK_TAI_VIET", UBLOCK_TAI_VIET)
      .value("UBLOCK_MEETEI_MAYEK", UBLOCK_MEETEI_MAYEK)
      .value("UBLOCK_HANGUL_JAMO_EXTENDED_B", UBLOCK_HANGUL_JAMO_EXTENDED_B)
      .value("UBLOCK_IMPERIAL_ARAMAIC", UBLOCK_IMPERIAL_ARAMAIC)
      .value("UBLOCK_OLD_SOUTH_ARABIAN", UBLOCK_OLD_SOUTH_ARABIAN)
      .value("UBLOCK_AVESTAN", UBLOCK_AVESTAN)
      .value("UBLOCK_INSCRIPTIONAL_PARTHIAN", UBLOCK_INSCRIPTIONAL_PARTHIAN)
      .value("UBLOCK_INSCRIPTIONAL_PAHLAVI", UBLOCK_INSCRIPTIONAL_PAHLAVI)
      .value("UBLOCK_OLD_TURKIC", UBLOCK_OLD_TURKIC)
      .value("UBLOCK_RUMI_NUMERAL_SYMBOLS", UBLOCK_RUMI_NUMERAL_SYMBOLS)
      .value("UBLOCK_KAITHI", UBLOCK_KAITHI)
      .value("UBLOCK_EGYPTIAN_HIEROGLYPHS", UBLOCK_EGYPTIAN_HIEROGLYPHS)
      .value("UBLOCK_ENCLOSED_ALPHANUMERIC_SUPPLEMENT", UBLOCK_ENCLOSED_ALPHANUMERIC_SUPPLEMENT)
      .value("UBLOCK_ENCLOSED_IDEOGRAPHIC_SUPPLEMENT", UBLOCK_ENCLOSED_IDEOGRAPHIC_SUPPLEMENT)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C", UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C)
      .value("UBLOCK_MANDAIC", UBLOCK_MANDAIC)
      .value("UBLOCK_BATAK", UBLOCK_BATAK)
      .value("UBLOCK_ETHIOPIC_EXTENDED_A", UBLOCK_ETHIOPIC_EXTENDED_A)
      .value("UBLOCK_BRAHMI", UBLOCK_BRAHMI)
      .value("UBLOCK_BAMUM_SUPPLEMENT", UBLOCK_BAMUM_SUPPLEMENT)
      .value("UBLOCK_KANA_SUPPLEMENT", UBLOCK_KANA_SUPPLEMENT)
      .value("UBLOCK_PLAYING_CARDS", UBLOCK_PLAYING_CARDS)
      .value("UBLOCK_MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS", UBLOCK_MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS)
      .value("UBLOCK_EMOTICONS", UBLOCK_EMOTICONS)
      .value("UBLOCK_TRANSPORT_AND_MAP_SYMBOLS", UBLOCK_TRANSPORT_AND_MAP_SYMBOLS)
      .value("UBLOCK_ALCHEMICAL_SYMBOLS", UBLOCK_ALCHEMICAL_SYMBOLS)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D", UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D)
#if (U_ICU_VERSION_MAJOR_NUM >= 49)
      .value("UBLOCK_ARABIC_EXTENDED_A", UBLOCK_ARABIC_EXTENDED_A)
      .value("UBLOCK_ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS", UBLOCK_ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS)
      .value("UBLOCK_CHAKMA", UBLOCK_CHAKMA)
      .value("UBLOCK_MEETEI_MAYEK_EXTENSIONS", UBLOCK_MEETEI_MAYEK_EXTENSIONS)
      .value("UBLOCK_MEROITIC_CURSIVE", UBLOCK_MEROITIC_CURSIVE)
      .value("UBLOCK_MEROITIC_HIEROGLYPHS", UBLOCK_MEROITIC_HIEROGLYPHS)
      .value("UBLOCK_MIAO", UBLOCK_MIAO)
      .value("UBLOCK_SHARADA", UBLOCK_SHARADA)
      .value("UBLOCK_SORA_SOMPENG", UBLOCK_SORA_SOMPENG)
      .value("UBLOCK_SUNDANESE_SUPPLEMENT", UBLOCK_SUNDANESE_SUPPLEMENT)
      .value("UBLOCK_TAKRI", UBLOCK_TAKRI)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 49)
#if (U_ICU_VERSION_MAJOR_NUM >= 54)
      .value("UBLOCK_BASSA_VAH", UBLOCK_BASSA_VAH)
      .value("UBLOCK_CAUCASIAN_ALBANIAN", UBLOCK_CAUCASIAN_ALBANIAN)
      .value("UBLOCK_COPTIC_EPACT_NUMBERS", UBLOCK_COPTIC_EPACT_NUMBERS)
      .value("UBLOCK_COMBINING_DIACRITICAL_MARKS_EXTENDED", UBLOCK_COMBINING_DIACRITICAL_MARKS_EXTENDED)
      .value("UBLOCK_DUPLOYAN", UBLOCK_DUPLOYAN)
      .value("UBLOCK_ELBASAN", UBLOCK_ELBASAN)
      .value("UBLOCK_GEOMETRIC_SHAPES_EXTENDED", UBLOCK_GEOMETRIC_SHAPES_EXTENDED)
      .value("UBLOCK_GRANTHA", UBLOCK_GRANTHA)
      .value("UBLOCK_KHOJKI", UBLOCK_KHOJKI)
      .value("UBLOCK_KHUDAWADI", UBLOCK_KHUDAWADI)
      .value("UBLOCK_LATIN_EXTENDED_E", UBLOCK_LATIN_EXTENDED_E)
      .value("UBLOCK_LINEAR_A", UBLOCK_LINEAR_A)
      .value("UBLOCK_MAHAJANI", UBLOCK_MAHAJANI)
      .value("UBLOCK_MANICHAEAN", UBLOCK_MANICHAEAN)
      .value("UBLOCK_MENDE_KIKAKUI", UBLOCK_MENDE_KIKAKUI)
      .value("UBLOCK_MODI", UBLOCK_MODI)
      .value("UBLOCK_MRO", UBLOCK_MRO)
      .value("UBLOCK_MYANMAR_EXTENDED_B", UBLOCK_MYANMAR_EXTENDED_B)
      .value("UBLOCK_NABATAEAN", UBLOCK_NABATAEAN)
      .value("UBLOCK_OLD_NORTH_ARABIAN", UBLOCK_OLD_NORTH_ARABIAN)
      .value("UBLOCK_OLD_PERMIC", UBLOCK_OLD_PERMIC)
      .value("UBLOCK_ORNAMENTAL_DINGBATS", UBLOCK_ORNAMENTAL_DINGBATS)
      .value("UBLOCK_PAHAWH_HMONG", UBLOCK_PAHAWH_HMONG)
      .value("UBLOCK_PALMYRENE", UBLOCK_PALMYRENE)
      .value("UBLOCK_PAU_CIN_HAU", UBLOCK_PAU_CIN_HAU)
      .value("UBLOCK_PSALTER_PAHLAVI", UBLOCK_PSALTER_PAHLAVI)
      .value("UBLOCK_SHORTHAND_FORMAT_CONTROLS", UBLOCK_SHORTHAND_FORMAT_CONTROLS)
      .value("UBLOCK_SIDDHAM", UBLOCK_SIDDHAM)
      .value("UBLOCK_SINHALA_ARCHAIC_NUMBERS", UBLOCK_SINHALA_ARCHAIC_NUMBERS)
      .value("UBLOCK_SUPPLEMENTAL_ARROWS_C", UBLOCK_SUPPLEMENTAL_ARROWS_C)
      .value("UBLOCK_TIRHUTA", UBLOCK_TIRHUTA)
      .value("UBLOCK_WARANG_CITI", UBLOCK_WARANG_CITI)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 54)
#if (U_ICU_VERSION_MAJOR_NUM >= 56)
      .value("UBLOCK_AHOM", UBLOCK_AHOM)
      .value("UBLOCK_ANATOLIAN_HIEROGLYPHS", UBLOCK_ANATOLIAN_HIEROGLYPHS)
      .value("UBLOCK_CHEROKEE_SUPPLEMENT", UBLOCK_CHEROKEE_SUPPLEMENT)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E", UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E)
      .value("UBLOCK_EARLY_DYNASTIC_CUNEIFORM", UBLOCK_EARLY_DYNASTIC_CUNEIFORM)
      .value("UBLOCK_HATRAN", UBLOCK_HATRAN)
      .value("UBLOCK_MULTANI", UBLOCK_MULTANI)
      .value("UBLOCK_OLD_HUNGARIAN", UBLOCK_OLD_HUNGARIAN)
      .value("UBLOCK_SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS", UBLOCK_SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS)
      .value("UBLOCK_SUTTON_SIGNWRITING", UBLOCK_SUTTON_SIGNWRITING)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 56)
#if (U_ICU_VERSION_MAJOR_NUM >= 58)
      .value("UBLOCK_ADLAM", UBLOCK_ADLAM)
      .value("UBLOCK_BHAIKSUKI", UBLOCK_BHAIKSUKI)
      .value("UBLOCK_CYRILLIC_EXTENDED_C", UBLOCK_CYRILLIC_EXTENDED_C)
      .value("UBLOCK_GLAGOLITIC_SUPPLEMENT", UBLOCK_GLAGOLITIC_SUPPLEMENT)
      .value("UBLOCK_IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION", UBLOCK_IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION)
      .value("UBLOCK_MARCHEN", UBLOCK_MARCHEN)
      .value("UBLOCK_MONGOLIAN_SUPPLEMENT", UBLOCK_MONGOLIAN_SUPPLEMENT)
      .value("UBLOCK_NEWA", UBLOCK_NEWA)
      .value("UBLOCK_OSAGE", UBLOCK_OSAGE)
      .value("UBLOCK_TANGUT", UBLOCK_TANGUT)
      .value("UBLOCK_TANGUT_COMPONENTS", UBLOCK_TANGUT_COMPONENTS)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 58)
#if (U_ICU_VERSION_MAJOR_NUM >= 60)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F", UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F)
      .value("UBLOCK_KANA_EXTENDED_A", UBLOCK_KANA_EXTENDED_A)
      .value("UBLOCK_MASARAM_GONDI", UBLOCK_MASARAM_GONDI)
      .value("UBLOCK_NUSHU", UBLOCK_NUSHU)
      .value("UBLOCK_SOYOMBO", UBLOCK_SOYOMBO)
      .value("UBLOCK_SYRIAC_SUPPLEMENT", UBLOCK_SYRIAC_SUPPLEMENT)
      .value("UBLOCK_ZANABAZAR_SQUARE", UBLOCK_ZANABAZAR_SQUARE)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 60)
#if (U_ICU_VERSION_MAJOR_NUM >= 62)
      .value("UBLOCK_CHESS_SYMBOLS", UBLOCK_CHESS_SYMBOLS)
      .value("UBLOCK_DOGRA", UBLOCK_DOGRA)
      .value("UBLOCK_GEORGIAN_EXTENDED", UBLOCK_GEORGIAN_EXTENDED)
      .value("UBLOCK_GUNJALA_GONDI", UBLOCK_GUNJALA_GONDI)
      .value("UBLOCK_HANIFI_ROHINGYA", UBLOCK_HANIFI_ROHINGYA)
      .value("UBLOCK_INDIC_SIYAQ_NUMBERS", UBLOCK_INDIC_SIYAQ_NUMBERS)
      .value("UBLOCK_MAKASAR", UBLOCK_MAKASAR)
      .value("UBLOCK_MAYAN_NUMERALS", UBLOCK_MAYAN_NUMERALS)
      .value("UBLOCK_MEDEFAIDRIN", UBLOCK_MEDEFAIDRIN)
      .value("UBLOCK_OLD_SOGDIAN", UBLOCK_OLD_SOGDIAN)
      .value("UBLOCK_SOGDIAN", UBLOCK_SOGDIAN)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 62)
#if (U_ICU_VERSION_MAJOR_NUM >= 64)
      .value("UBLOCK_EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS", UBLOCK_EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS)
      .value("UBLOCK_ELYMAIC", UBLOCK_ELYMAIC)
      .value("UBLOCK_NANDINAGARI", UBLOCK_NANDINAGARI)
      .value("UBLOCK_NYIAKENG_PUACHUE_HMONG", UBLOCK_NYIAKENG_PUACHUE_HMONG)
      .value("UBLOCK_OTTOMAN_SIYAQ_NUMBERS", UBLOCK_OTTOMAN_SIYAQ_NUMBERS)
      .value("UBLOCK_SMALL_KANA_EXTENSION", UBLOCK_SMALL_KANA_EXTENSION)
      .value("UBLOCK_SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A", UBLOCK_SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A)
      .value("UBLOCK_TAMIL_SUPPLEMENT", UBLOCK_TAMIL_SUPPLEMENT)
      .value("UBLOCK_WANCHO", UBLOCK_WANCHO)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 64)
#if (U_ICU_VERSION_MAJOR_NUM >= 66)
      .value("UBLOCK_CHORASMIAN", UBLOCK_CHORASMIAN)
      .value("UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G", UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G)
      .value("UBLOCK_DIVES_AKURU", UBLOCK_DIVES_AKURU)
      .value("UBLOCK_KHITAN_SMALL_SCRIPT", UBLOCK_KHITAN_SMALL_SCRIPT)
      .value("UBLOCK_LISU_SUPPLEMENT", UBLOCK_LISU_SUPPLEMENT)
      .value("UBLOCK_SYMBOLS_FOR_LEGACY_COMPUTING", UBLOCK_SYMBOLS_FOR_LEGACY_COMPUTING)
      .value("UBLOCK_TANGUT_SUPPLEMENT", UBLOCK_TANGUT_SUPPLEMENT)
      .value("UBLOCK_YEZIDI", UBLOCK_YEZIDI)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 66)
#if (U_ICU_VERSION_MAJOR_NUM >= 70)
      .value("UBLOCK_ARABIC_EXTENDED_B", UBLOCK_ARABIC_EXTENDED_B)
      .value("UBLOCK_CYPRO_MINOAN", UBLOCK_CYPRO_MINOAN)
      .value("UBLOCK_ETHIOPIC_EXTENDED_B", UBLOCK_ETHIOPIC_EXTENDED_B)
      .value("UBLOCK_KANA_EXTENDED_B", UBLOCK_KANA_EXTENDED_B)
      .value("UBLOCK_LATIN_EXTENDED_F", UBLOCK_LATIN_EXTENDED_F)
      .value("UBLOCK_LATIN_EXTENDED_G", UBLOCK_LATIN_EXTENDED_G)
      .value("UBLOCK_OLD_UYGHUR", UBLOCK_OLD_UYGHUR)
      .value("UBLOCK_TANGSA", UBLOCK_TANGSA)
      .value("UBLOCK_TOTO", UBLOCK_TOTO)
      .value("UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_A",
             UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_A)
      .value("UBLOCK_VITHKUQI", UBLOCK_VITHKUQI)
      .value("UBLOCK_ZNAMENNY_MUSICAL_NOTATION", UBLOCK_ZNAMENNY_MUSICAL_NOTATION)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 70)
#ifndef U_HIDE_DEPRECATED_API
      .value("UBLOCK_COUNT", UBLOCK_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .value("UBLOCK_INVALID_CODE", UBLOCK_INVALID_CODE)
      .export_values();

  py::enum_<UCharCategory>(m, "UCharCategory", py::arithmetic(),
                           "Data for enumerated Unicode general category types.\n\n"
                           "See http://www.unicode.org/Public/UNIDATA/UnicodeData.html")
      .value("U_UNASSIGNED", U_UNASSIGNED, "Non-category for unassigned and non-character code points.")
      .value("U_GENERAL_OTHER_TYPES", U_GENERAL_OTHER_TYPES,
             "Cn \"Other, Not Assigned (no characters in [UnicodeData.txt] have this property)\" (same as "
             "*U_UNASSIGNED*!)")
      .value("U_UPPERCASE_LETTER", U_UPPERCASE_LETTER, "Lu.")
      .value("U_LOWERCASE_LETTER", U_LOWERCASE_LETTER, "Ll.")
      .value("U_TITLECASE_LETTER", U_TITLECASE_LETTER, "Lt.")
      .value("U_MODIFIER_LETTER", U_MODIFIER_LETTER, "Lm.")
      .value("U_OTHER_LETTER", U_OTHER_LETTER, "Lo.")
      .value("U_NON_SPACING_MARK", U_NON_SPACING_MARK, "Mn.")
      .value("U_ENCLOSING_MARK", U_ENCLOSING_MARK, "Me.")
      .value("U_COMBINING_SPACING_MARK", U_COMBINING_SPACING_MARK, "Mc.")
      .value("U_DECIMAL_DIGIT_NUMBER", U_DECIMAL_DIGIT_NUMBER, "Nd.")
      .value("U_LETTER_NUMBER", U_LETTER_NUMBER, "Nl.")
      .value("U_OTHER_NUMBER", U_OTHER_NUMBER, "No.")
      .value("U_SPACE_SEPARATOR", U_SPACE_SEPARATOR, "Zs.")
      .value("U_LINE_SEPARATOR", U_LINE_SEPARATOR, "Zl.")
      .value("U_PARAGRAPH_SEPARATOR", U_PARAGRAPH_SEPARATOR, "Zp.")
      .value("U_CONTROL_CHAR", U_CONTROL_CHAR, "Cc.")
      .value("U_FORMAT_CHAR", U_FORMAT_CHAR, "Cf.")
      .value("U_PRIVATE_USE_CHAR", U_PRIVATE_USE_CHAR, "Co.")
      .value("U_SURROGATE", U_SURROGATE, "Cs.")
      .value("U_DASH_PUNCTUATION", U_DASH_PUNCTUATION, "Pd.")
      .value("U_START_PUNCTUATION", U_START_PUNCTUATION, "Ps.")
      .value("U_END_PUNCTUATION", U_END_PUNCTUATION, "Pe.")
      .value("U_CONNECTOR_PUNCTUATION", U_CONNECTOR_PUNCTUATION, "Pc.")
      .value("U_OTHER_PUNCTUATION", U_OTHER_PUNCTUATION, "Po.")
      .value("U_MATH_SYMBOL", U_MATH_SYMBOL, "Sm.")
      .value("U_CURRENCY_SYMBOL", U_CURRENCY_SYMBOL, "Sc.")
      .value("U_MODIFIER_SYMBOL", U_MODIFIER_SYMBOL, "Sk.")
      .value("U_OTHER_SYMBOL", U_OTHER_SYMBOL, "So.")
      .value("U_INITIAL_PUNCTUATION", U_INITIAL_PUNCTUATION, "Pi.")
      .value("U_FINAL_PUNCTUATION", U_FINAL_PUNCTUATION, "Pf.")
      .value("U_CHAR_CATEGORY_COUNT", U_CHAR_CATEGORY_COUNT,
             "One higher than the last enum *UCharCategory* constant.\n\n  "
             "This numeric value is stable (will not change), see "
             "http://www.unicode.org/policies/stability_policy.html#Property_Value")
      .export_values();

  py::enum_<UCharDirection>(m, "UCharDirection", py::arithmetic(),
                            "This specifies the language directional property of a character set.")
      .value("U_LEFT_TO_RIGHT", U_LEFT_TO_RIGHT, "L.")
      .value("U_RIGHT_TO_LEFT", U_RIGHT_TO_LEFT, "R.")
      .value("U_EUROPEAN_NUMBER", U_EUROPEAN_NUMBER, "EN.")
      .value("U_EUROPEAN_NUMBER_SEPARATOR", U_EUROPEAN_NUMBER_SEPARATOR, "ES.")
      .value("U_EUROPEAN_NUMBER_TERMINATOR", U_EUROPEAN_NUMBER_TERMINATOR, "ET.")
      .value("U_ARABIC_NUMBER", U_ARABIC_NUMBER, "AN.")
      .value("U_COMMON_NUMBER_SEPARATOR", U_COMMON_NUMBER_SEPARATOR, "CS.")
      .value("U_BLOCK_SEPARATOR", U_BLOCK_SEPARATOR, "B.")
      .value("U_SEGMENT_SEPARATOR", U_SEGMENT_SEPARATOR, "S.")
      .value("U_WHITE_SPACE_NEUTRAL", U_WHITE_SPACE_NEUTRAL, "WS.")
      .value("U_OTHER_NEUTRAL", U_OTHER_NEUTRAL, "ON.")
      .value("U_LEFT_TO_RIGHT_EMBEDDING", U_LEFT_TO_RIGHT_EMBEDDING, "LRE.")
      .value("U_LEFT_TO_RIGHT_OVERRIDE", U_LEFT_TO_RIGHT_OVERRIDE, "LRO.")
      .value("U_RIGHT_TO_LEFT_ARABIC", U_RIGHT_TO_LEFT_ARABIC, "AL.")
      .value("U_RIGHT_TO_LEFT_EMBEDDING", U_RIGHT_TO_LEFT_EMBEDDING, "RLE.")
      .value("U_RIGHT_TO_LEFT_OVERRIDE", U_RIGHT_TO_LEFT_OVERRIDE, "RLO.")
      .value("U_POP_DIRECTIONAL_FORMAT", U_POP_DIRECTIONAL_FORMAT, "PDF.")
      .value("U_DIR_NON_SPACING_MARK", U_DIR_NON_SPACING_MARK, "NSM.")
      .value("U_BOUNDARY_NEUTRAL", U_BOUNDARY_NEUTRAL, "BN.")
      .value("U_FIRST_STRONG_ISOLATE", U_FIRST_STRONG_ISOLATE, "FSI.")
      .value("U_LEFT_TO_RIGHT_ISOLATE", U_LEFT_TO_RIGHT_ISOLATE, "LRI.")
      .value("U_RIGHT_TO_LEFT_ISOLATE", U_RIGHT_TO_LEFT_ISOLATE, "RLI.")
      .value("U_POP_DIRECTIONAL_ISOLATE", U_POP_DIRECTIONAL_ISOLATE, "PDI.")
#ifndef U_HIDE_DEPRECATED_API
      .value("U_CHAR_DIRECTION_COUNT", U_CHAR_DIRECTION_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UCharNameChoice>(m, "UCharNameChoice", py::arithmetic(),
                             "Selector constants for *u_char_name()*.\n\n"
                             "*u_char_name()* returns the \"modern\" name of a Unicode character; or the name that was "
                             "defined in Unicode version 1.0, before the Unicode standard merged with ISO-10646; or an "
                             "\"extended\" name that gives each Unicode code point a unique name.")
      .value("U_UNICODE_CHAR_NAME", U_UNICODE_CHAR_NAME, "Unicode character name (Name property).")
#ifndef U_HIDE_DEPRECATED_API
      .value("U_UNICODE_10_CHAR_NAME", U_UNICODE_10_CHAR_NAME, "**Deprecated:** ICU 49")
#endif // U_HIDE_DEPRECATED_API
      .value("U_EXTENDED_CHAR_NAME", U_EXTENDED_CHAR_NAME, "Standard or synthetic character name.")
      .value("U_CHAR_NAME_ALIAS", U_CHAR_NAME_ALIAS, "Corrected name from NameAliases.txt.")
#ifndef U_HIDE_DEPRECATED_API
      .value("U_CHAR_NAME_CHOICE_COUNT", U_CHAR_NAME_CHOICE_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UDecompositionType>(m, "UDecompositionType", py::arithmetic(), "Decomposition Type constants.")
      .value("U_DT_NONE", U_DT_NONE)
      .value("U_DT_CANONICAL", U_DT_CANONICAL)
      .value("U_DT_COMPAT", U_DT_COMPAT)
      .value("U_DT_CIRCLE", U_DT_CIRCLE)
      .value("U_DT_FINAL", U_DT_FINAL)
      .value("U_DT_FONT", U_DT_FONT)
      .value("U_DT_FRACTION", U_DT_FRACTION)
      .value("U_DT_INITIAL", U_DT_INITIAL)
      .value("U_DT_ISOLATED", U_DT_ISOLATED)
      .value("U_DT_MEDIAL", U_DT_MEDIAL)
      .value("U_DT_NARROW", U_DT_NARROW)
      .value("U_DT_NOBREAK", U_DT_NOBREAK)
      .value("U_DT_SMALL", U_DT_SMALL)
      .value("U_DT_SQUARE", U_DT_SQUARE)
      .value("U_DT_SUB", U_DT_SUB)
      .value("U_DT_SUPER", U_DT_SUPER)
      .value("U_DT_VERTICAL", U_DT_VERTICAL)
      .value("U_DT_WIDE", U_DT_WIDE)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_DT_COUNT", U_DT_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UEastAsianWidth>(m, "UEastAsianWidth", py::arithmetic(), "East Asian Width constants.")
      .value("U_EA_NEUTRAL", U_EA_NEUTRAL)
      .value("U_EA_AMBIGUOUS", U_EA_AMBIGUOUS)
      .value("U_EA_HALFWIDTH", U_EA_HALFWIDTH)
      .value("U_EA_FULLWIDTH", U_EA_FULLWIDTH)
      .value("U_EA_NARROW", U_EA_NARROW)
      .value("U_EA_WIDE", U_EA_WIDE)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_EA_COUNT", U_EA_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UGraphemeClusterBreak>(m, "UGraphemeClusterBreak", py::arithmetic(), "Grapheme Cluster Break constants.")
      .value("U_GCB_OTHER", U_GCB_OTHER)
      .value("U_GCB_CONTROL", U_GCB_CONTROL)
      .value("U_GCB_CR", U_GCB_CR)
      .value("U_GCB_EXTEND", U_GCB_EXTEND)
      .value("U_GCB_L", U_GCB_L)
      .value("U_GCB_LF", U_GCB_LF)
      .value("U_GCB_LV", U_GCB_LV)
      .value("U_GCB_LVT", U_GCB_LVT)
      .value("U_GCB_T", U_GCB_T)
      .value("U_GCB_V", U_GCB_V)
      .value("U_GCB_SPACING_MARK", U_GCB_SPACING_MARK)
      .value("U_GCB_PREPEND", U_GCB_PREPEND)
#if (U_ICU_VERSION_MAJOR_NUM >= 50)
      .value("U_GCB_REGIONAL_INDICATOR", U_GCB_REGIONAL_INDICATOR)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 50)
#if (U_ICU_VERSION_MAJOR_NUM >= 58)
      .value("U_GCB_E_BASE", U_GCB_E_BASE)
      .value("U_GCB_E_BASE_GAZ", U_GCB_E_BASE_GAZ)
      .value("U_GCB_E_MODIFIER", U_GCB_E_MODIFIER)
      .value("U_GCB_GLUE_AFTER_ZWJ", U_GCB_GLUE_AFTER_ZWJ)
      .value("U_GCB_ZWJ", U_GCB_ZWJ)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 58)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_GCB_COUNT", U_GCB_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UHangulSyllableType>(m, "UHangulSyllableType", py::arithmetic(), "Hangul Syllable Type constants.")
      .value("U_HST_NOT_APPLICABLE", U_HST_NOT_APPLICABLE)
      .value("U_HST_LEADING_JAMO", U_HST_LEADING_JAMO)
      .value("U_HST_VOWEL_JAMO", U_HST_VOWEL_JAMO)
      .value("U_HST_TRAILING_JAMO", U_HST_TRAILING_JAMO)
      .value("U_HST_LV_SYLLABLE", U_HST_LV_SYLLABLE)
      .value("U_HST_LVT_SYLLABLE", U_HST_LVT_SYLLABLE)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_HST_COUNT", U_HST_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

#if (U_ICU_VERSION_MAJOR_NUM >= 63)
  py::enum_<UIndicPositionalCategory>(m, "UIndicPositionalCategory", py::arithmetic(),
                                      "Indic Positional Category constants.")
      .value("U_INPC_NA", U_INPC_NA)
      .value("U_INPC_BOTTOM", U_INPC_BOTTOM)
      .value("U_INPC_BOTTOM_AND_LEFT", U_INPC_BOTTOM_AND_LEFT)
      .value("U_INPC_BOTTOM_AND_RIGHT", U_INPC_BOTTOM_AND_RIGHT)
      .value("U_INPC_LEFT", U_INPC_LEFT)
      .value("U_INPC_LEFT_AND_RIGHT", U_INPC_LEFT_AND_RIGHT)
      .value("U_INPC_OVERSTRUCK", U_INPC_OVERSTRUCK)
      .value("U_INPC_RIGHT", U_INPC_RIGHT)
      .value("U_INPC_TOP", U_INPC_TOP)
      .value("U_INPC_TOP_AND_BOTTOM", U_INPC_TOP_AND_BOTTOM)
      .value("U_INPC_TOP_AND_BOTTOM_AND_RIGHT", U_INPC_TOP_AND_BOTTOM_AND_RIGHT)
      .value("U_INPC_TOP_AND_LEFT", U_INPC_TOP_AND_LEFT)
      .value("U_INPC_TOP_AND_LEFT_AND_RIGHT", U_INPC_TOP_AND_LEFT_AND_RIGHT)
      .value("U_INPC_TOP_AND_RIGHT", U_INPC_TOP_AND_RIGHT)
      .value("U_INPC_VISUAL_ORDER_LEFT", U_INPC_VISUAL_ORDER_LEFT)
#if (U_ICU_VERSION_MAJOR_NUM >= 66)
      .value("U_INPC_TOP_AND_BOTTOM_AND_LEFT", U_INPC_TOP_AND_BOTTOM_AND_LEFT)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 66)
      .export_values();
#endif // (U_ICU_VERSION_MAJOR_NUM >= 63)

#if (U_ICU_VERSION_MAJOR_NUM >= 63)
  py::enum_<UIndicSyllabicCategory>(m, "UIndicSyllabicCategory", py::arithmetic(), "Indic Syllabic Category constants.")
      .value("U_INSC_OTHER", U_INSC_OTHER)
      .value("U_INSC_AVAGRAHA", U_INSC_AVAGRAHA)
      .value("U_INSC_BINDU", U_INSC_BINDU)
      .value("U_INSC_BRAHMI_JOINING_NUMBER", U_INSC_BRAHMI_JOINING_NUMBER)
      .value("U_INSC_CANTILLATION_MARK", U_INSC_CANTILLATION_MARK)
      .value("U_INSC_CONSONANT", U_INSC_CONSONANT)
      .value("U_INSC_CONSONANT_DEAD", U_INSC_CONSONANT_DEAD)
      .value("U_INSC_CONSONANT_FINAL", U_INSC_CONSONANT_FINAL)
      .value("U_INSC_CONSONANT_HEAD_LETTER", U_INSC_CONSONANT_HEAD_LETTER)
      .value("U_INSC_CONSONANT_INITIAL_POSTFIXED", U_INSC_CONSONANT_INITIAL_POSTFIXED)
      .value("U_INSC_CONSONANT_KILLER", U_INSC_CONSONANT_KILLER)
      .value("U_INSC_CONSONANT_MEDIAL", U_INSC_CONSONANT_MEDIAL)
      .value("U_INSC_CONSONANT_PLACEHOLDER", U_INSC_CONSONANT_PLACEHOLDER)
      .value("U_INSC_CONSONANT_PRECEDING_REPHA", U_INSC_CONSONANT_PRECEDING_REPHA)
      .value("U_INSC_CONSONANT_PREFIXED", U_INSC_CONSONANT_PREFIXED)
      .value("U_INSC_CONSONANT_SUBJOINED", U_INSC_CONSONANT_SUBJOINED)
      .value("U_INSC_CONSONANT_SUCCEEDING_REPHA", U_INSC_CONSONANT_SUCCEEDING_REPHA)
      .value("U_INSC_CONSONANT_WITH_STACKER", U_INSC_CONSONANT_WITH_STACKER)
      .value("U_INSC_GEMINATION_MARK", U_INSC_GEMINATION_MARK)
      .value("U_INSC_INVISIBLE_STACKER", U_INSC_INVISIBLE_STACKER)
      .value("U_INSC_JOINER", U_INSC_JOINER)
      .value("U_INSC_MODIFYING_LETTER", U_INSC_MODIFYING_LETTER)
      .value("U_INSC_NON_JOINER", U_INSC_NON_JOINER)
      .value("U_INSC_NUKTA", U_INSC_NUKTA)
      .value("U_INSC_NUMBER", U_INSC_NUMBER)
      .value("U_INSC_NUMBER_JOINER", U_INSC_NUMBER_JOINER)
      .value("U_INSC_PURE_KILLER", U_INSC_PURE_KILLER)
      .value("U_INSC_REGISTER_SHIFTER", U_INSC_REGISTER_SHIFTER)
      .value("U_INSC_SYLLABLE_MODIFIER", U_INSC_SYLLABLE_MODIFIER)
      .value("U_INSC_TONE_LETTER", U_INSC_TONE_LETTER)
      .value("U_INSC_TONE_MARK", U_INSC_TONE_MARK)
      .value("U_INSC_VIRAMA", U_INSC_VIRAMA)
      .value("U_INSC_VISARGA", U_INSC_VISARGA)
      .value("U_INSC_VOWEL", U_INSC_VOWEL)
      .value("U_INSC_VOWEL_DEPENDENT", U_INSC_VOWEL_DEPENDENT)
      .value("U_INSC_VOWEL_INDEPENDENT", U_INSC_VOWEL_INDEPENDENT)
      .export_values();
#endif // (U_ICU_VERSION_MAJOR_NUM >= 63)

  py::enum_<UJoiningGroup>(m, "UJoiningGroup", py::arithmetic(), "Joining Group constants.")
      .value("U_JG_NO_JOINING_GROUP", U_JG_NO_JOINING_GROUP)
      .value("U_JG_AIN", U_JG_AIN)
      .value("U_JG_ALAPH", U_JG_ALAPH)
      .value("U_JG_ALEF", U_JG_ALEF)
      .value("U_JG_BEH", U_JG_BEH)
      .value("U_JG_BETH", U_JG_BETH)
      .value("U_JG_DAL", U_JG_DAL)
      .value("U_JG_DALATH_RISH", U_JG_DALATH_RISH)
      .value("U_JG_E", U_JG_E)
      .value("U_JG_FEH", U_JG_FEH)
      .value("U_JG_FINAL_SEMKATH", U_JG_FINAL_SEMKATH)
      .value("U_JG_GAF", U_JG_GAF)
      .value("U_JG_GAMAL", U_JG_GAMAL)
      .value("U_JG_HAH", U_JG_HAH)
      .value("U_JG_TEH_MARBUTA_GOAL", U_JG_TEH_MARBUTA_GOAL)
      .value("U_JG_HAMZA_ON_HEH_GOAL", U_JG_HAMZA_ON_HEH_GOAL)
      .value("U_JG_HE", U_JG_HE)
      .value("U_JG_HEH", U_JG_HEH)
      .value("U_JG_HEH_GOAL", U_JG_HEH_GOAL)
      .value("U_JG_HETH", U_JG_HETH)
      .value("U_JG_KAF", U_JG_KAF)
      .value("U_JG_KAPH", U_JG_KAPH)
      .value("U_JG_KNOTTED_HEH", U_JG_KNOTTED_HEH)
      .value("U_JG_LAM", U_JG_LAM)
      .value("U_JG_LAMADH", U_JG_LAMADH)
      .value("U_JG_MEEM", U_JG_MEEM)
      .value("U_JG_MIM", U_JG_MIM)
      .value("U_JG_NOON", U_JG_NOON)
      .value("U_JG_NUN", U_JG_NUN)
      .value("U_JG_PE", U_JG_PE)
      .value("U_JG_QAF", U_JG_QAF)
      .value("U_JG_QAPH", U_JG_QAPH)
      .value("U_JG_REH", U_JG_REH)
      .value("U_JG_REVERSED_PE", U_JG_REVERSED_PE)
      .value("U_JG_SAD", U_JG_SAD)
      .value("U_JG_SADHE", U_JG_SADHE)
      .value("U_JG_SEEN", U_JG_SEEN)
      .value("U_JG_SEMKATH", U_JG_SEMKATH)
      .value("U_JG_SHIN", U_JG_SHIN)
      .value("U_JG_SWASH_KAF", U_JG_SWASH_KAF)
      .value("U_JG_SYRIAC_WAW", U_JG_SYRIAC_WAW)
      .value("U_JG_TAH", U_JG_TAH)
      .value("U_JG_TAW", U_JG_TAW)
      .value("U_JG_TEH_MARBUTA", U_JG_TEH_MARBUTA)
      .value("U_JG_TETH", U_JG_TETH)
      .value("U_JG_WAW", U_JG_WAW)
      .value("U_JG_YEH", U_JG_YEH)
      .value("U_JG_YEH_BARREE", U_JG_YEH_BARREE)
      .value("U_JG_YEH_WITH_TAIL", U_JG_YEH_WITH_TAIL)
      .value("U_JG_YUDH", U_JG_YUDH)
      .value("U_JG_YUDH_HE", U_JG_YUDH_HE)
      .value("U_JG_ZAIN", U_JG_ZAIN)
      .value("U_JG_FE", U_JG_FE)
      .value("U_JG_KHAPH", U_JG_KHAPH)
      .value("U_JG_ZHAIN", U_JG_ZHAIN)
      .value("U_JG_BURUSHASKI_YEH_BARREE", U_JG_BURUSHASKI_YEH_BARREE)
      .value("U_JG_FARSI_YEH", U_JG_FARSI_YEH)
      .value("U_JG_NYA", U_JG_NYA)
#if (U_ICU_VERSION_MAJOR_NUM >= 49)
      .value("U_JG_ROHINGYA_YEH", U_JG_ROHINGYA_YEH)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 49)
#if (U_ICU_VERSION_MAJOR_NUM >= 54)
      .value("U_JG_MANICHAEAN_ALEPH", U_JG_MANICHAEAN_ALEPH)
      .value("U_JG_MANICHAEAN_AYIN", U_JG_MANICHAEAN_AYIN)
      .value("U_JG_MANICHAEAN_BETH", U_JG_MANICHAEAN_BETH)
      .value("U_JG_MANICHAEAN_DALETH", U_JG_MANICHAEAN_DALETH)
      .value("U_JG_MANICHAEAN_DHAMEDH", U_JG_MANICHAEAN_DHAMEDH)
      .value("U_JG_MANICHAEAN_FIVE", U_JG_MANICHAEAN_FIVE)
      .value("U_JG_MANICHAEAN_GIMEL", U_JG_MANICHAEAN_GIMEL)
      .value("U_JG_MANICHAEAN_HETH", U_JG_MANICHAEAN_HETH)
      .value("U_JG_MANICHAEAN_HUNDRED", U_JG_MANICHAEAN_HUNDRED)
      .value("U_JG_MANICHAEAN_KAPH", U_JG_MANICHAEAN_KAPH)
      .value("U_JG_MANICHAEAN_LAMEDH", U_JG_MANICHAEAN_LAMEDH)
      .value("U_JG_MANICHAEAN_MEM", U_JG_MANICHAEAN_MEM)
      .value("U_JG_MANICHAEAN_NUN", U_JG_MANICHAEAN_NUN)
      .value("U_JG_MANICHAEAN_ONE", U_JG_MANICHAEAN_ONE)
      .value("U_JG_MANICHAEAN_PE", U_JG_MANICHAEAN_PE)
      .value("U_JG_MANICHAEAN_QOPH", U_JG_MANICHAEAN_QOPH)
      .value("U_JG_MANICHAEAN_RESH", U_JG_MANICHAEAN_RESH)
      .value("U_JG_MANICHAEAN_SADHE", U_JG_MANICHAEAN_SADHE)
      .value("U_JG_MANICHAEAN_SAMEKH", U_JG_MANICHAEAN_SAMEKH)
      .value("U_JG_MANICHAEAN_TAW", U_JG_MANICHAEAN_TAW)
      .value("U_JG_MANICHAEAN_TEN", U_JG_MANICHAEAN_TEN)
      .value("U_JG_MANICHAEAN_TETH", U_JG_MANICHAEAN_TETH)
      .value("U_JG_MANICHAEAN_THAMEDH", U_JG_MANICHAEAN_THAMEDH)
      .value("U_JG_MANICHAEAN_TWENTY", U_JG_MANICHAEAN_TWENTY)
      .value("U_JG_MANICHAEAN_WAW", U_JG_MANICHAEAN_WAW)
      .value("U_JG_MANICHAEAN_YODH", U_JG_MANICHAEAN_YODH)
      .value("U_JG_MANICHAEAN_ZAYIN", U_JG_MANICHAEAN_ZAYIN)
      .value("U_JG_STRAIGHT_WAW", U_JG_STRAIGHT_WAW)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 54)
#if (U_ICU_VERSION_MAJOR_NUM >= 58)
      .value("U_JG_AFRICAN_FEH", U_JG_AFRICAN_FEH)
      .value("U_JG_AFRICAN_NOON", U_JG_AFRICAN_NOON)
      .value("U_JG_AFRICAN_QAF", U_JG_AFRICAN_QAF)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 58)
#if (U_ICU_VERSION_MAJOR_NUM >= 60)
      .value("U_JG_MALAYALAM_BHA", U_JG_MALAYALAM_BHA)
      .value("U_JG_MALAYALAM_JA", U_JG_MALAYALAM_JA)
      .value("U_JG_MALAYALAM_LLA", U_JG_MALAYALAM_LLA)
      .value("U_JG_MALAYALAM_LLLA", U_JG_MALAYALAM_LLLA)
      .value("U_JG_MALAYALAM_NGA", U_JG_MALAYALAM_NGA)
      .value("U_JG_MALAYALAM_NNA", U_JG_MALAYALAM_NNA)
      .value("U_JG_MALAYALAM_NNNA", U_JG_MALAYALAM_NNNA)
      .value("U_JG_MALAYALAM_NYA", U_JG_MALAYALAM_NYA)
      .value("U_JG_MALAYALAM_RA", U_JG_MALAYALAM_RA)
      .value("U_JG_MALAYALAM_SSA", U_JG_MALAYALAM_SSA)
      .value("U_JG_MALAYALAM_TTA", U_JG_MALAYALAM_TTA)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 60)
#if (U_ICU_VERSION_MAJOR_NUM >= 62)
      .value("U_JG_HANIFI_ROHINGYA_KINNA_YA", U_JG_HANIFI_ROHINGYA_KINNA_YA)
      .value("U_JG_HANIFI_ROHINGYA_PA", U_JG_HANIFI_ROHINGYA_PA)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 62)
#if (U_ICU_VERSION_MAJOR_NUM >= 70)
      .value("U_JG_THIN_YEH", U_JG_THIN_YEH)
      .value("U_JG_VERTICAL_TAIL", U_JG_VERTICAL_TAIL)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 70)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_JG_COUNT", U_JG_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UJoiningType>(m, "UJoiningType", py::arithmetic(), "Joining Type constants.")
      .value("U_JT_NON_JOINING", U_JT_NON_JOINING)
      .value("U_JT_JOIN_CAUSING", U_JT_JOIN_CAUSING)
      .value("U_JT_DUAL_JOINING", U_JT_DUAL_JOINING)
      .value("U_JT_LEFT_JOINING", U_JT_LEFT_JOINING)
      .value("U_JT_RIGHT_JOINING", U_JT_RIGHT_JOINING)
      .value("U_JT_TRANSPARENT", U_JT_TRANSPARENT)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_JT_COUNT", U_JT_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<ULineBreak>(m, "ULineBreak", py::arithmetic(), "Line Break constants.")
      .value("U_LB_UNKNOWN", U_LB_UNKNOWN)
      .value("U_LB_AMBIGUOUS", U_LB_AMBIGUOUS)
      .value("U_LB_ALPHABETIC", U_LB_ALPHABETIC)
      .value("U_LB_BREAK_BOTH", U_LB_BREAK_BOTH)
      .value("U_LB_BREAK_AFTER", U_LB_BREAK_AFTER)
      .value("U_LB_BREAK_BEFORE", U_LB_BREAK_BEFORE)
      .value("U_LB_MANDATORY_BREAK", U_LB_MANDATORY_BREAK)
      .value("U_LB_CONTINGENT_BREAK", U_LB_CONTINGENT_BREAK)
      .value("U_LB_CLOSE_PUNCTUATION", U_LB_CLOSE_PUNCTUATION)
      .value("U_LB_COMBINING_MARK", U_LB_COMBINING_MARK)
      .value("U_LB_CARRIAGE_RETURN", U_LB_CARRIAGE_RETURN)
      .value("U_LB_EXCLAMATION", U_LB_EXCLAMATION)
      .value("U_LB_GLUE", U_LB_GLUE)
      .value("U_LB_HYPHEN", U_LB_HYPHEN)
      .value("U_LB_IDEOGRAPHIC", U_LB_IDEOGRAPHIC)
      .value("U_LB_INSEPARABLE", U_LB_INSEPARABLE,
             "Renamed from the misspelled \"inseperable\" in Unicode 4.0.1/ICU 3.0.")
      .value("U_LB_INSEPERABLE", U_LB_INSEPERABLE)
      .value("U_LB_INFIX_NUMERIC", U_LB_INFIX_NUMERIC)
      .value("U_LB_LINE_FEED", U_LB_LINE_FEED)
      .value("U_LB_NONSTARTER", U_LB_NONSTARTER)
      .value("U_LB_NUMERIC", U_LB_NUMERIC)
      .value("U_LB_OPEN_PUNCTUATION", U_LB_OPEN_PUNCTUATION)
      .value("U_LB_POSTFIX_NUMERIC", U_LB_POSTFIX_NUMERIC)
      .value("U_LB_PREFIX_NUMERIC", U_LB_PREFIX_NUMERIC)
      .value("U_LB_QUOTATION", U_LB_QUOTATION)
      .value("U_LB_COMPLEX_CONTEXT", U_LB_COMPLEX_CONTEXT)
      .value("U_LB_SURROGATE", U_LB_SURROGATE)
      .value("U_LB_SPACE", U_LB_SPACE)
      .value("U_LB_BREAK_SYMBOLS", U_LB_BREAK_SYMBOLS)
      .value("U_LB_ZWSPACE", U_LB_ZWSPACE)
      .value("U_LB_NEXT_LINE", U_LB_NEXT_LINE)
      .value("U_LB_WORD_JOINER", U_LB_WORD_JOINER)
      .value("U_LB_H2", U_LB_H2)
      .value("U_LB_H3", U_LB_H3)
      .value("U_LB_JL", U_LB_JL)
      .value("U_LB_JT", U_LB_JT)
      .value("U_LB_JV", U_LB_JV)
      .value("U_LB_CLOSE_PARENTHESIS", U_LB_CLOSE_PARENTHESIS)
#if (U_ICU_VERSION_MAJOR_NUM >= 49)
      .value("U_LB_CONDITIONAL_JAPANESE_STARTER", U_LB_CONDITIONAL_JAPANESE_STARTER)
      .value("U_LB_HEBREW_LETTER", U_LB_HEBREW_LETTER)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 49)
#if (U_ICU_VERSION_MAJOR_NUM >= 50)
      .value("U_LB_REGIONAL_INDICATOR", U_LB_REGIONAL_INDICATOR)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 50)
#if (U_ICU_VERSION_MAJOR_NUM >= 58)
      .value("U_LB_E_BASE", U_LB_E_BASE)
      .value("U_LB_E_MODIFIER", U_LB_E_MODIFIER)
      .value("U_LB_ZWJ", U_LB_ZWJ)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 58)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_LB_COUNT", U_LB_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UNumericType>(m, "UNumericType", py::arithmetic(), "Numeric Type constants.")
      .value("U_NT_NONE", U_NT_NONE)
      .value("U_NT_DECIMAL", U_NT_DECIMAL)
      .value("U_NT_DIGIT", U_NT_DIGIT)
      .value("U_NT_NUMERIC", U_NT_NUMERIC)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_NT_COUNT", U_NT_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<UProperty>(
      m, "UProperty", py::arithmetic(),
      "Selection constants for Unicode properties.\n\n"
      "These constants are used in functions like *u_has_binary_property* to select one of the Unicode properties.\n\n"
      "The properties APIs are intended to reflect Unicode properties as defined in the Unicode Character Database "
      "(UCD) and Unicode Technical Reports (UTR).\n\n"
      "For details about the properties see UAX #44: Unicode Character Database "
      "(http://www.unicode.org/reports/tr44/).\n\n"
      "Important: If ICU is built with UCD files from Unicode versions below, e.g., 3.2, then properties marked with "
      "\"new in Unicode 3.2\" are not or not fully available. Check *u_get_unicode_version* to be sure.")
      .value("UCHAR_ALPHABETIC", UCHAR_ALPHABETIC,
             "Binary property Alphabetic.\n\n  "
             "Same as *u_is_ualphabetic*, different from *u_isalpha*. Lu+Ll+Lt+Lm+Lo+Nl+Other_Alphabetic")
      .value("UCHAR_BINARY_START", UCHAR_BINARY_START, "First constant for binary Unicode properties.")
      .value("UCHAR_ASCII_HEX_DIGIT", UCHAR_ASCII_HEX_DIGIT,
             "Binary property ASCII_Hex_Digit.\n\n  "
             "0-9 A-F a-f")
      .value("UCHAR_BIDI_CONTROL", UCHAR_BIDI_CONTROL,
             "Binary property Bidi_Control.\n\n  "
             "Format controls which have specific functions in the Bidi Algorithm.")
      .value("UCHAR_BIDI_MIRRORED", UCHAR_BIDI_MIRRORED,
             "Binary property Bidi_Mirrored.\n\n  "
             "Characters that may change display in RTL text. Same as *u_is_mirrored*. See Bidi Algorithm, UTR 9.")
      .value("UCHAR_DASH", UCHAR_DASH,
             "Binary property Dash.\n\n  "
             "Variations of dashes.")
      .value("UCHAR_DEFAULT_IGNORABLE_CODE_POINT", UCHAR_DEFAULT_IGNORABLE_CODE_POINT,
             "Binary property Default_Ignorable_Code_Point (new in Unicode 3.2).\n\n  "
             "Ignorable in most processing. <2060..206F, FFF0..FFFB, "
             "E0000..E0FFF>+Other_Default_Ignorable_Code_Point+(Cf+Cc+Cs-White_Space)")
      .value("UCHAR_DEPRECATED", UCHAR_DEPRECATED,
             "Binary property Deprecated (new in Unicode 3.2).\n\n  "
             "The usage of deprecated characters is strongly discouraged.")
      .value("UCHAR_DIACRITIC", UCHAR_DIACRITIC,
             "Binary property Diacritic.\n\n  "
             "Characters that linguistically modify the meaning of another character to which they apply.")
      .value("UCHAR_EXTENDER", UCHAR_EXTENDER,
             "Binary property Extender.\n\n  "
             "Extend the value or shape of a preceding alphabetic character, e.g., length and iteration marks.")
      .value("UCHAR_FULL_COMPOSITION_EXCLUSION", UCHAR_FULL_COMPOSITION_EXCLUSION,
             "Binary property Full_Composition_Exclusion.\n\n  "
             "CompositionExclusions.txt+Singleton Decompositions+ Non-Starter Decompositions.")
      .value("UCHAR_GRAPHEME_BASE", UCHAR_GRAPHEME_BASE,
             "Binary property Grapheme_Base (new in Unicode 3.2).\n\n  "
             "For programmatic determination of grapheme cluster boundaries. "
             "[0..10FFFF]-Cc-Cf-Cs-Co-Cn-Zl-Zp-Grapheme_Link-Grapheme_Extend-CGJ")
      .value("UCHAR_GRAPHEME_EXTEND", UCHAR_GRAPHEME_EXTEND,
             "Binary property Grapheme_Extend (new in Unicode 3.2).\n\n  "
             "For programmatic determination of grapheme cluster boundaries. "
             "Me+Mn+Mc+Other_Grapheme_Extend-Grapheme_Link-CGJ")
      .value("UCHAR_GRAPHEME_LINK", UCHAR_GRAPHEME_LINK,
             "Binary property Grapheme_Link (new in Unicode 3.2).\n\n  "
             "For programmatic determination of grapheme cluster boundaries.")
      .value("UCHAR_HEX_DIGIT", UCHAR_HEX_DIGIT,
             "Binary property Hex_Digit.\n\n  "
             "Characters commonly used for hexadecimal numbers.")
      .value("UCHAR_HYPHEN", UCHAR_HYPHEN,
             "Binary property Hyphen.\n\n  "
             "Dashes used to mark connections between pieces of words, plus the Katakana middle dot.")
      .value("UCHAR_ID_CONTINUE", UCHAR_ID_CONTINUE,
             "Binary property ID_Continue.\n\n  "
             "Characters that can continue an identifier. DerivedCoreProperties.txt also says \"NOTE: Cf characters "
             "should be filtered out.\" ID_Start+Mn+Mc+Nd+Pc")
      .value("UCHAR_ID_START", UCHAR_ID_START,
             "Binary property ID_Start.\n\n  "
             "Characters that can start an identifier. Lu+Ll+Lt+Lm+Lo+Nl")
      .value("UCHAR_IDEOGRAPHIC", UCHAR_IDEOGRAPHIC,
             "Binary property Ideographic.\n\n  "
             "CJKV ideographs.")
      .value("UCHAR_IDS_BINARY_OPERATOR", UCHAR_IDS_BINARY_OPERATOR,
             "Binary property IDS_Binary_Operator (new in Unicode 3.2).\n\n  "
             "For programmatic determination of Ideographic Description Sequences.")
      .value("UCHAR_IDS_TRINARY_OPERATOR", UCHAR_IDS_TRINARY_OPERATOR,
             "Binary property IDS_Trinary_Operator (new in Unicode 3.2).\n\n  "
             "For programmatic determination of Ideographic Description Sequences.")
      .value("UCHAR_JOIN_CONTROL", UCHAR_JOIN_CONTROL,
             "Binary property Join_Control.\n\n  "
             "Format controls for cursive joining and ligation.")
      .value("UCHAR_LOGICAL_ORDER_EXCEPTION", UCHAR_LOGICAL_ORDER_EXCEPTION,
             "Binary property Logical_Order_Exception (new in Unicode 3.2).\n\n  "
             "Characters that do not use logical order and require special handling in most processing.")
      .value("UCHAR_LOWERCASE", UCHAR_LOWERCASE,
             "Binary property Lowercase.\n\n  "
             "Same as *u_is_ulowercase*, different from *u_is_lower*. Ll+Other_Lowercase")
      .value("UCHAR_MATH", UCHAR_MATH,
             "Binary property Math.\n\n  "
             "Sm+Other_Math")
      .value("UCHAR_NONCHARACTER_CODE_POINT", UCHAR_NONCHARACTER_CODE_POINT,
             "Binary property Noncharacter_Code_Point.\n\n  "
             "Code points that are explicitly defined as illegal for the encoding of characters.")
      .value("UCHAR_QUOTATION_MARK", UCHAR_QUOTATION_MARK, "Binary property Quotation_Mark.")
      .value("UCHAR_RADICAL", UCHAR_RADICAL,
             "Binary property Radical (new in Unicode 3.2).\n\n  "
             "For programmatic determination of Ideographic Description Sequences.")
      .value("UCHAR_SOFT_DOTTED", UCHAR_SOFT_DOTTED,
             "Binary property Soft_Dotted (new in Unicode 3.2).\n\n  "
             "Characters with a \"soft dot\", like i or j. An accent placed on these characters causes the dot to "
             "disappear.")
      .value("UCHAR_TERMINAL_PUNCTUATION", UCHAR_TERMINAL_PUNCTUATION,
             "Binary property Terminal_Punctuation.\n\n  "
             "Punctuation characters that generally mark the end of textual units.")
      .value("UCHAR_UNIFIED_IDEOGRAPH", UCHAR_UNIFIED_IDEOGRAPH,
             "Binary property Unified_Ideograph (new in Unicode 3.2).\n\n  "
             "For programmatic determination of Ideographic Description Sequences.")
      .value("UCHAR_UPPERCASE", UCHAR_UPPERCASE,
             "Binary property Uppercase.\n\n  "
             "Same as *u_is_uuppercase*, different from *u_isupper*. Lu+Other_Uppercase")
      .value("UCHAR_WHITE_SPACE", UCHAR_WHITE_SPACE,
             "Binary property White_Space.\n\n  "
             "Same as *u_is_uwhite_space*, different from *u_isspace* and *u_is_whitespace*. Space "
             "characters+TAB+CR+LF-ZWSP-ZWNBSP")
      .value("UCHAR_XID_CONTINUE", UCHAR_XID_CONTINUE,
             "Binary property XID_Continue.\n\n  "
             "ID_Continue modified to allow closure under normalization forms NFKC and NFKD.")
      .value("UCHAR_XID_START", UCHAR_XID_START,
             "Binary property XID_Start.\n\n  "
             "ID_Start modified to allow closure under normalization forms NFKC and NFKD.")
      .value("UCHAR_CASE_SENSITIVE", UCHAR_CASE_SENSITIVE,
             "Binary property Case_Sensitive.\n\n  "
             "Either the source of a case mapping or in the target of a case mapping. Not the same as the general "
             "category Cased_Letter.")
      .value("UCHAR_S_TERM", UCHAR_S_TERM,
             "Binary property STerm (new in Unicode 4.0.1).\n\n  "
             "Sentence Terminal. Used in UAX #29: Text Boundaries (http://www.unicode.org/reports/tr29/)")
      .value("UCHAR_VARIATION_SELECTOR", UCHAR_VARIATION_SELECTOR,
             "Binary property Variation_Selector (new in Unicode 4.0.1).\n\n  "
             "Indicates all those characters that qualify as Variation Selectors. For details on the behavior of these "
             "characters, see StandardizedVariants.html and 15.6 Variation Selectors.")
      .value("UCHAR_NFD_INERT", UCHAR_NFD_INERT,
             "Binary property NFD_Inert.\n\n  "
             "ICU-specific property for characters that are inert under NFD, i.e., they do not interact with adjacent "
             "characters. See the documentation for the *Normalizer2* class and the *Normalizer2::is_inert()* method.")
      .value("UCHAR_NFKD_INERT", UCHAR_NFKD_INERT,
             "Binary property NFKD_Inert.\n\n  "
             "ICU-specific property for characters that are inert under NFKD, i.e., they do not interact with adjacent "
             "characters. See the documentation for the *Normalizer2* class and the *Normalizer2::is_inert()* method.")
      .value("UCHAR_NFC_INERT", UCHAR_NFC_INERT,
             "Binary property NFC_Inert.\n\n  "
             "ICU-specific property for characters that are inert under NFC, i.e., they do not interact with adjacent "
             "characters. See the documentation for the *Normalizer2* class and the *Normalizer2::is_inert()* method.")
      .value("UCHAR_NFKC_INERT", UCHAR_NFKC_INERT,
             "Binary property NFKC_Inert.\n\n  "
             "ICU-specific property for characters that are inert under NFKC, i.e., they do not interact with adjacent "
             "characters. See the documentation for the *Normalizer2* class and the *Normalizer2::is_inert()* method.")
      .value("UCHAR_SEGMENT_STARTER", UCHAR_SEGMENT_STARTER,
             "Binary Property Segment_Starter.\n\n  "
             "ICU-specific property for characters that are starters in terms of Unicode normalization and combining "
             "character sequences. They have ccc=0 and do not occur in non-initial position of the canonical "
             "decomposition of any character (like a-umlaut in NFD and a Jamo T in an NFD(Hangul LVT)). ICU uses this "
             "property for segmenting a string for generating a set of canonically equivalent strings, e.g. for "
             "canonical closure while processing collation tailoring rules.")
      .value("UCHAR_PATTERN_SYNTAX", UCHAR_PATTERN_SYNTAX,
             "Binary property Pattern_Syntax (new in Unicode 4.1).\n\n  "
             "See UAX #31 Identifier and Pattern Syntax (http://www.unicode.org/reports/tr31/)")
      .value("UCHAR_PATTERN_WHITE_SPACE", UCHAR_PATTERN_WHITE_SPACE,
             "Binary property Pattern_White_Space (new in Unicode 4.1).\n\n  "
             "See UAX #31 Identifier and Pattern Syntax (http://www.unicode.org/reports/tr31/)")
      .value("UCHAR_POSIX_ALNUM", UCHAR_POSIX_ALNUM,
             "Binary property alnum (a C/POSIX character class).\n\n  "
             "Implemented according to the UTS #18 Annex C Standard Recommendation. See the uchar.h file "
             "documentation.")
      .value("UCHAR_POSIX_BLANK", UCHAR_POSIX_BLANK,
             "Binary property blank (a C/POSIX character class).\n\n  "
             "Implemented according to the UTS #18 Annex C Standard Recommendation. See the uchar.h file "
             "documentation.")
      .value("UCHAR_POSIX_GRAPH", UCHAR_POSIX_GRAPH,
             "Binary property graph (a C/POSIX character class).\n\n  "
             "Implemented according to the UTS #18 Annex C Standard Recommendation. See the uchar.h file "
             "documentation.")
      .value("UCHAR_POSIX_PRINT", UCHAR_POSIX_PRINT,
             "Binary property print (a C/POSIX character class).\n\n  "
             "Implemented according to the UTS #18 Annex C Standard Recommendation. See the uchar.h file "
             "documentation.")
      .value("UCHAR_POSIX_XDIGIT", UCHAR_POSIX_XDIGIT,
             "Binary property xdigit (a C/POSIX character class).\n\n  "
             "Implemented according to the UTS #18 Annex C Standard Recommendation. See the uchar.h file "
             "documentation.")
      .value("UCHAR_CASED", UCHAR_CASED,
             "Binary property Cased.\n\n  "
             "For Lowercase, Uppercase and Titlecase characters.")
      .value("UCHAR_CASE_IGNORABLE", UCHAR_CASE_IGNORABLE,
             "Binary property Case_Ignorable.\n\n  "
             "Used in context-sensitive case mappings.")
      .value("UCHAR_CHANGES_WHEN_LOWERCASED", UCHAR_CHANGES_WHEN_LOWERCASED, "Binary property Changes_When_Lowercased.")
      .value("UCHAR_CHANGES_WHEN_UPPERCASED", UCHAR_CHANGES_WHEN_UPPERCASED, "Binary property Changes_When_Uppercased.")
      .value("UCHAR_CHANGES_WHEN_TITLECASED", UCHAR_CHANGES_WHEN_TITLECASED, "Binary property Changes_When_Titlecased.")
      .value("UCHAR_CHANGES_WHEN_CASEFOLDED", UCHAR_CHANGES_WHEN_CASEFOLDED, "Binary property Changes_When_Casefolded.")
      .value("UCHAR_CHANGES_WHEN_CASEMAPPED", UCHAR_CHANGES_WHEN_CASEMAPPED, "Binary property Changes_When_Casemapped.")
      .value("UCHAR_CHANGES_WHEN_NFKC_CASEFOLDED", UCHAR_CHANGES_WHEN_NFKC_CASEFOLDED,
             "Binary property Changes_When_NFKC_Casefolded.")
#if (U_ICU_VERSION_MAJOR_NUM >= 57)
      .value("UCHAR_EMOJI", UCHAR_EMOJI,
             "Binary property Emoji.\n\n  "
             "See http://www.unicode.org/reports/tr51/#Emoji_Properties")
      .value("UCHAR_EMOJI_PRESENTATION", UCHAR_EMOJI_PRESENTATION,
             "Binary property Emoji_Presentation.\n\n  "
             "See http://www.unicode.org/reports/tr51/#Emoji_Properties")
      .value("UCHAR_EMOJI_MODIFIER", UCHAR_EMOJI_MODIFIER,
             "Binary property Emoji_Modifier.\n\n  "
             "See http://www.unicode.org/reports/tr51/#Emoji_Properties")
      .value("UCHAR_EMOJI_MODIFIER_BASE", UCHAR_EMOJI_MODIFIER_BASE,
             "Binary property Emoji_Modifier_Base.\n\n  "
             "See http://www.unicode.org/reports/tr51/#Emoji_Properties")
#endif // (U_ICU_VERSION_MAJOR_NUM >= 57)
#if (U_ICU_VERSION_MAJOR_NUM >= 60)
      .value("UCHAR_EMOJI_COMPONENT", UCHAR_EMOJI_COMPONENT,
             "Binary property Emoji_Component.\n\n  "
             "See http://www.unicode.org/reports/tr51/#Emoji_Properties")
      .value("UCHAR_REGIONAL_INDICATOR", UCHAR_REGIONAL_INDICATOR, "Binary property Regional_Indicator.")
      .value("UCHAR_PREPENDED_CONCATENATION_MARK", UCHAR_PREPENDED_CONCATENATION_MARK,
             "Binary property Prepended_Concatenation_Mark.")
#endif // (U_ICU_VERSION_MAJOR_NUM >= 60)
#if (U_ICU_VERSION_MAJOR_NUM >= 62)
      .value("UCHAR_EXTENDED_PICTOGRAPHIC", UCHAR_EXTENDED_PICTOGRAPHIC,
             "Binary property Extended_Pictographic.\n\n  "
             "See http://www.unicode.org/reports/tr51/#Emoji_Properties")
#endif // (U_ICU_VERSION_MAJOR_NUM >= 62)
#if (U_ICU_VERSION_MAJOR_NUM >= 70)
      .value("UCHAR_BASIC_EMOJI", UCHAR_BASIC_EMOJI,
             "Binary property of strings Basic_Emoji.\n\n  "
             "See https://www.unicode.org/reports/tr51/#Emoji_Sets")
      .value("UCHAR_EMOJI_KEYCAP_SEQUENCE", UCHAR_EMOJI_KEYCAP_SEQUENCE,
             "Binary property of strings Emoji_Keycap_Sequence.\n\n  "
             "See https://www.unicode.org/reports/tr51/#Emoji_Sets")
      .value("UCHAR_RGI_EMOJI_MODIFIER_SEQUENCE", UCHAR_RGI_EMOJI_MODIFIER_SEQUENCE,
             "Binary property of strings RGI_Emoji_Modifier_Sequence.\n\n  "
             "See https://www.unicode.org/reports/tr51/#Emoji_Sets")
      .value("UCHAR_RGI_EMOJI_FLAG_SEQUENCE", UCHAR_RGI_EMOJI_FLAG_SEQUENCE,
             "Binary property of strings RGI_Emoji_Flag_Sequence.\n\n  "
             "See https://www.unicode.org/reports/tr51/#Emoji_Sets")
      .value("UCHAR_RGI_EMOJI_TAG_SEQUENCE", UCHAR_RGI_EMOJI_TAG_SEQUENCE,
             "Binary property of strings RGI_Emoji_Tag_Sequence.\n\n  "
             "See https://www.unicode.org/reports/tr51/#Emoji_Sets")
      .value("UCHAR_RGI_EMOJI_ZWJ_SEQUENCE", UCHAR_RGI_EMOJI_ZWJ_SEQUENCE,
             "Binary property of strings RGI_Emoji_ZWJ_Sequence.\n\n  "
             "See https://www.unicode.org/reports/tr51/#Emoji_Sets")
      .value("UCHAR_RGI_EMOJI", UCHAR_RGI_EMOJI,
             "Binary property of strings RGI_Emoji.\n\n  "
             "See https://www.unicode.org/reports/tr51/#Emoji_Sets")
#endif // (U_ICU_VERSION_MAJOR_NUM >= 70)
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_BINARY_LIMIT", UCHAR_BINARY_LIMIT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_BIDI_CLASS", UCHAR_BIDI_CLASS,
             "Enumerated property Bidi_Class.\n\n  "
             "Same as *u_char_direction*, returns *UCharDirection* values.")
      .value("UCHAR_INT_START", UCHAR_INT_START, "First constant for enumerated/integer Unicode properties.")
      .value("UCHAR_BLOCK", UCHAR_BLOCK,
             "Enumerated property Block.\n\n  "
             "Same as *ublock_get_code*, returns *UBlockCode* values.")
      .value("UCHAR_CANONICAL_COMBINING_CLASS", UCHAR_CANONICAL_COMBINING_CLASS,
             "Enumerated property Canonical_Combining_Class.\n\n  "
             "Same as *u_get_combining_class*, returns 8-bit numeric values.")
      .value("UCHAR_DECOMPOSITION_TYPE", UCHAR_DECOMPOSITION_TYPE,
             "Enumerated property Decomposition_Type.\n\n  "
             "Returns *UDecompositionType* values.")
      .value("UCHAR_EAST_ASIAN_WIDTH", UCHAR_EAST_ASIAN_WIDTH,
             "Enumerated property East_Asian_Width.\n\n  "
             "See http://www.unicode.org/reports/tr11/ Returns *UEastAsianWidth* values.")
      .value("UCHAR_GENERAL_CATEGORY", UCHAR_GENERAL_CATEGORY,
             "Enumerated property General_Category.\n\n  "
             "Same as *u_char_type*, returns *UCharCategory* values.")
      .value("UCHAR_JOINING_GROUP", UCHAR_JOINING_GROUP,
             "Enumerated property Joining_Group.\n\n  "
             "Returns *UJoiningGroup* values.")
      .value("UCHAR_JOINING_TYPE", UCHAR_JOINING_TYPE,
             "Enumerated property Joining_Type.\n\n  "
             "Returns *UJoiningType* values.")
      .value("UCHAR_LINE_BREAK", UCHAR_LINE_BREAK,
             "Enumerated property Line_Break.\n\n  "
             "Returns *ULineBreak* values.")
      .value("UCHAR_NUMERIC_TYPE", UCHAR_NUMERIC_TYPE,
             "Enumerated property Numeric_Type.\n\n  "
             "Returns *UNumericType* values.")
      .value("UCHAR_SCRIPT", UCHAR_SCRIPT,
             "Enumerated property Script.\n\n  "
             "Same as *uscript_get_script*, returns *UScriptCode* values.")
      .value("UCHAR_HANGUL_SYLLABLE_TYPE", UCHAR_HANGUL_SYLLABLE_TYPE,
             "Enumerated property Hangul_Syllable_Type, new in Unicode 4.\n\n  "
             "Returns *UHangulSyllableType* values.")
      .value("UCHAR_NFD_QUICK_CHECK", UCHAR_NFD_QUICK_CHECK,
             "Enumerated property NFD_Quick_Check.\n\n  "
             "Returns *UNormalizationCheckResult* values.")
      .value("UCHAR_NFKD_QUICK_CHECK", UCHAR_NFKD_QUICK_CHECK,
             "Enumerated property NFKD_Quick_Check.\n\n  "
             "Returns *UNormalizationCheckResult* values.")
      .value("UCHAR_NFC_QUICK_CHECK", UCHAR_NFC_QUICK_CHECK,
             "Enumerated property NFC_Quick_Check.\n\n  "
             "Returns *UNormalizationCheckResult* values.")
      .value("UCHAR_NFKC_QUICK_CHECK", UCHAR_NFKC_QUICK_CHECK,
             "Enumerated property NFKC_Quick_Check.\n\n  "
             "Returns *UNormalizationCheckResult* values.")
      .value("UCHAR_LEAD_CANONICAL_COMBINING_CLASS", UCHAR_LEAD_CANONICAL_COMBINING_CLASS,
             "Enumerated property Lead_Canonical_Combining_Class.\n\n  "
             "ICU-specific property for the ccc of the first code point of the decomposition, "
             "or lccc(c)=ccc(NFD(c)[0]). Useful for checking for canonically ordered text; see UNORM_FCD and "
             "http://www.unicode.org/notes/tn5/#FCD . Returns 8-bit numeric values like "
             "*UCHAR_CANONICAL_COMBINING_CLASS*.")
      .value("UCHAR_TRAIL_CANONICAL_COMBINING_CLASS", UCHAR_TRAIL_CANONICAL_COMBINING_CLASS,
             "Enumerated property Trail_Canonical_Combining_Class.\n\n  "
             "ICU-specific property for the ccc of the last code point of the decomposition, or "
             "tccc(c)=ccc(NFD(c)[last]). Useful for checking for canonically ordered text; see UNORM_FCD and "
             "http://www.unicode.org/notes/tn5/#FCD . Returns 8-bit numeric values like "
             "*UCHAR_CANONICAL_COMBINING_CLASS*.")
      .value("UCHAR_GRAPHEME_CLUSTER_BREAK", UCHAR_GRAPHEME_CLUSTER_BREAK,
             "Enumerated property Grapheme_Cluster_Break (new in Unicode 4.1).\n\n  "
             "Used in UAX #29: Text Boundaries (http://www.unicode.org/reports/tr29/) Returns *UGraphemeClusterBreak* "
             "values.")
      .value("UCHAR_SENTENCE_BREAK", UCHAR_SENTENCE_BREAK,
             "Enumerated property Sentence_Break (new in Unicode 4.1).\n\n  "
             "Used in UAX #29: Text Boundaries (http://www.unicode.org/reports/tr29/) Returns *USentenceBreak* values.")
      .value("UCHAR_WORD_BREAK", UCHAR_WORD_BREAK,
             "Enumerated property Word_Break (new in Unicode 4.1).\n\n  "
             "Used in UAX #29: Text Boundaries (http://www.unicode.org/reports/tr29/) Returns *UWordBreakValues* "
             "values.")
#if (U_ICU_VERSION_MAJOR_NUM >= 52)
      .value("UCHAR_BIDI_PAIRED_BRACKET_TYPE", UCHAR_BIDI_PAIRED_BRACKET_TYPE,
             "Enumerated property Bidi_Paired_Bracket_Type (new in Unicode 6.3).\n\n  "
             "Used in UAX #9: Unicode Bidirectional Algorithm (http://www.unicode.org/reports/tr9/) Returns "
             "*UBidiPairedBracketType* values.")
#endif // (U_ICU_VERSION_MAJOR_NUM >= 52)
#if (U_ICU_VERSION_MAJOR_NUM >= 63)
      .value("UCHAR_INDIC_POSITIONAL_CATEGORY", UCHAR_INDIC_POSITIONAL_CATEGORY,
             "Enumerated property Indic_Positional_Category.\n\n  "
             "New in Unicode 6.0 as provisional property Indic_Matra_Category; renamed and changed to informative in "
             "Unicode 8.0. See http://www.unicode.org/reports/tr44/#IndicPositionalCategory.txt")
      .value("UCHAR_INDIC_SYLLABIC_CATEGORY", UCHAR_INDIC_SYLLABIC_CATEGORY,
             "Enumerated property Indic_Syllabic_Category.\n\n  "
             "New in Unicode 6.0 as provisional; informative since Unicode 8.0. See "
             "http://www.unicode.org/reports/tr44/#IndicSyllabicCategory.txt")
      .value("UCHAR_VERTICAL_ORIENTATION", UCHAR_VERTICAL_ORIENTATION,
             "Enumerated property Vertical_Orientation.\n\n  "
             "Used for UAX #50 Unicode Vertical Text Layout (https://www.unicode.org/reports/tr50/). New as a UCD "
             "property in Unicode 10.0.")
#endif // (U_ICU_VERSION_MAJOR_NUM >= 63)
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_INT_LIMIT", UCHAR_INT_LIMIT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_GENERAL_CATEGORY_MASK", UCHAR_GENERAL_CATEGORY_MASK,
             "Bitmask property General_Category_Mask.\n\n  "
             "This is the General_Category property returned as a bit mask. When used in "
             "*u_get_int_property_value(c)*, same as *u_mask(u_char_type(c))*, returns bit masks for *UCharCategory* "
             "values where exactly one bit is set. When used with *u_get_property_value_name()* and "
             "*u_get_property_value_enum()*, a multi-bit mask is used for sets of categories like \"Letters\". Mask "
             "values should be cast to uint32_t.")
      .value("UCHAR_MASK_START", UCHAR_MASK_START, "First constant for bit-mask Unicode properties.")
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_MASK_LIMIT", UCHAR_MASK_LIMIT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_NUMERIC_VALUE", UCHAR_NUMERIC_VALUE,
             "Double property Numeric_Value.\n\n  "
             "Corresponds to *u_get_numeric_value*.")
      .value("UCHAR_DOUBLE_START", UCHAR_DOUBLE_START, "First constant for double Unicode properties.")
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_DOUBLE_LIMIT", UCHAR_DOUBLE_LIMIT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_AGE", UCHAR_AGE,
             "String property Age.\n\n  "
             "Corresponds to *u_char_age*.")
      .value("UCHAR_STRING_START", UCHAR_STRING_START, "First constant for string Unicode properties.")
      .value("UCHAR_BIDI_MIRRORING_GLYPH", UCHAR_BIDI_MIRRORING_GLYPH,
             "String property Bidi_Mirroring_Glyph.\n\n  "
             "Corresponds to *u_char_mirror*.")
      .value("UCHAR_CASE_FOLDING", UCHAR_CASE_FOLDING,
             "String property Case_Folding.\n\n  "
             "Corresponds to *u_str_fold_case* in ustring.h.")
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_ISO_COMMENT", UCHAR_ISO_COMMENT, "**Deprecated:** ICU 49")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_LOWERCASE_MAPPING", UCHAR_LOWERCASE_MAPPING,
             "String property Lowercase_Mapping.\n\n  "
             "Corresponds to *u_str_to_lower* in ustring.h.")
      .value("UCHAR_NAME", UCHAR_NAME,
             "String property Name.\n\n  "
             "Corresponds to *u_char_name*.")
      .value("UCHAR_SIMPLE_CASE_FOLDING", UCHAR_SIMPLE_CASE_FOLDING,
             "String property Simple_Case_Folding.\n\n  "
             "Corresponds to *u_fold_case*.")
      .value("UCHAR_SIMPLE_LOWERCASE_MAPPING", UCHAR_SIMPLE_LOWERCASE_MAPPING,
             "String property Simple_Lowercase_Mapping.\n\n  "
             "Corresponds to *u_tolower*.")
      .value("UCHAR_SIMPLE_TITLECASE_MAPPING", UCHAR_SIMPLE_TITLECASE_MAPPING,
             "String property Simple_Titlecase_Mapping.\n\n  "
             "Corresponds to *u_totitle*.")
      .value("UCHAR_SIMPLE_UPPERCASE_MAPPING", UCHAR_SIMPLE_UPPERCASE_MAPPING,
             "String property Simple_Uppercase_Mapping.\n\n  "
             "Corresponds to *u_toupper*.")
      .value("UCHAR_TITLECASE_MAPPING", UCHAR_TITLECASE_MAPPING,
             "String property Titlecase_Mapping.\n\n  "
             "Corresponds to *u_str_to_title* in ustring.h.")
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_UNICODE_1_NAME", UCHAR_UNICODE_1_NAME, "**Deprecated:** ICU 49")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_UPPERCASE_MAPPING", UCHAR_UPPERCASE_MAPPING,
             "String property Uppercase_Mapping.\n\n  "
             "Corresponds to *u_str_to_upper* in ustring.h.")
      .value("UCHAR_BIDI_PAIRED_BRACKET", UCHAR_BIDI_PAIRED_BRACKET,
             "String property Bidi_Paired_Bracket (new in Unicode 6.3).\n\n  "
             "Corresponds to *u_get_bidi_paired_bracket*.")
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_STRING_LIMIT", UCHAR_STRING_LIMIT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_SCRIPT_EXTENSIONS", UCHAR_SCRIPT_EXTENSIONS,
             "Miscellaneous property Script_Extensions (new in Unicode 6.0).\n\n  "
             "Some characters are commonly used in multiple scripts. For more information, see UAX #24: "
             "http://www.unicode.org/reports/tr24/. Corresponds to *uscript_has_script* and "
             "*uscript_get_script_extensions* in uscript.h.")
      .value("UCHAR_OTHER_PROPERTY_START", UCHAR_OTHER_PROPERTY_START,
             "First constant for Unicode properties with unusual value types.")
#ifndef U_HIDE_DEPRECATED_API
      .value("UCHAR_OTHER_PROPERTY_LIMIT", UCHAR_OTHER_PROPERTY_LIMIT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .value("UCHAR_INVALID_CODE", UCHAR_INVALID_CODE,
             "Represents a nonexistent or invalid property or property value.")
      .export_values();

  py::enum_<UPropertyNameChoice>(
      m, "UPropertyNameChoice", py::arithmetic(),
      "Selector constants for *u_get_property_name()* and *u_get_property_value_name()*.\n\n"
      "These selectors are used to choose which name is returned for a given property or value. All properties and "
      "values have a long name. Most have a short name, but some do not. Unicode allows for additional names, beyond "
      "the long and short name, which would be indicated by *U_LONG_PROPERTY_NAME* + i, where i=1, 2,...")
      .value("U_SHORT_PROPERTY_NAME", U_SHORT_PROPERTY_NAME)
      .value("U_LONG_PROPERTY_NAME", U_LONG_PROPERTY_NAME)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_PROPERTY_NAME_CHOICE_COUNT", U_PROPERTY_NAME_CHOICE_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  py::enum_<USentenceBreak>(m, "USentenceBreak", py::arithmetic(), "Sentence Break constants.")
      .value("U_SB_OTHER", U_SB_OTHER)
      .value("U_SB_ATERM", U_SB_ATERM)
      .value("U_SB_CLOSE", U_SB_CLOSE)
      .value("U_SB_FORMAT", U_SB_FORMAT)
      .value("U_SB_LOWER", U_SB_LOWER)
      .value("U_SB_NUMERIC", U_SB_NUMERIC)
      .value("U_SB_OLETTER", U_SB_OLETTER)
      .value("U_SB_SEP", U_SB_SEP)
      .value("U_SB_SP", U_SB_SP)
      .value("U_SB_STERM", U_SB_STERM)
      .value("U_SB_UPPER", U_SB_UPPER)
      .value("U_SB_CR", U_SB_CR)
      .value("U_SB_EXTEND", U_SB_EXTEND)
      .value("U_SB_LF", U_SB_LF)
      .value("U_SB_SCONTINUE", U_SB_SCONTINUE)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_SB_COUNT", U_SB_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

#if (U_ICU_VERSION_MAJOR_NUM >= 63)
  py::enum_<UVerticalOrientation>(m, "UVerticalOrientation", py::arithmetic(), "Vertical Orientation constants.")
      .value("U_VO_ROTATED", U_VO_ROTATED)
      .value("U_VO_TRANSFORMED_ROTATED", U_VO_TRANSFORMED_ROTATED)
      .value("U_VO_TRANSFORMED_UPRIGHT", U_VO_TRANSFORMED_UPRIGHT)
      .value("U_VO_UPRIGHT", U_VO_UPRIGHT)
      .export_values();
#endif // (U_ICU_VERSION_MAJOR_NUM >= 63)

  py::enum_<UWordBreakValues>(m, "UWordBreakValues", py::arithmetic(),
                              "Word Break constants.\n\n"
                              "(*UWordBreak* is a pre-existing enum type in ubrk.h for word break status tags.)")
      .value("U_WB_OTHER", U_WB_OTHER)
      .value("U_WB_ALETTER", U_WB_ALETTER)
      .value("U_WB_FORMAT", U_WB_FORMAT)
      .value("U_WB_KATAKANA", U_WB_KATAKANA)
      .value("U_WB_MIDLETTER", U_WB_MIDLETTER)
      .value("U_WB_MIDNUM", U_WB_MIDNUM)
      .value("U_WB_NUMERIC", U_WB_NUMERIC)
      .value("U_WB_EXTENDNUMLET", U_WB_EXTENDNUMLET)
      .value("U_WB_CR", U_WB_CR)
      .value("U_WB_EXTEND", U_WB_EXTEND)
      .value("U_WB_LF", U_WB_LF)
      .value("U_WB_MIDNUMLET", U_WB_MIDNUMLET)
      .value("U_WB_NEWLINE", U_WB_NEWLINE)
#if (U_ICU_VERSION_MAJOR_NUM >= 50)
      .value("U_WB_REGIONAL_INDICATOR", U_WB_REGIONAL_INDICATOR)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 50)
#if (U_ICU_VERSION_MAJOR_NUM >= 52)
      .value("U_WB_HEBREW_LETTER", U_WB_HEBREW_LETTER)
      .value("U_WB_SINGLE_QUOTE", U_WB_SINGLE_QUOTE)
      .value("U_WB_DOUBLE_QUOTE", U_WB_DOUBLE_QUOTE)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 52)
#if (U_ICU_VERSION_MAJOR_NUM >= 58)
      .value("U_WB_E_BASE", U_WB_E_BASE)
      .value("U_WB_E_BASE_GAZ", U_WB_E_BASE_GAZ)
      .value("U_WB_E_MODIFIER", U_WB_E_MODIFIER)
      .value("U_WB_GLUE_AFTER_ZWJ", U_WB_GLUE_AFTER_ZWJ)
      .value("U_WB_ZWJ", U_WB_ZWJ)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 58)
#if (U_ICU_VERSION_MAJOR_NUM >= 62)
      .value("U_WB_WSEGSPACE", U_WB_WSEGSPACE)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 62)
#ifndef U_HIDE_DEPRECATED_API
      .value("U_WB_COUNT", U_WB_COUNT,
             "**Deprecated:** ICU 58 The numeric value may change over time, see ICU ticket #12420.")
#endif // U_HIDE_DEPRECATED_API
      .export_values();

  m.def(
      "u_get_gc_mask", [](UChar32 c) { return U_GET_GC_MASK(c); }, py::arg("c"));
  m.def(
      "u_mask", [](UChar32 c) { return U_MASK(c); }, py::arg("c"));

  m.def(
      "u_char_age",
      [](UChar32 c) {
        UVersionInfo info;
        u_charAge(c, info);
        std::vector<uint8_t> result(info, info + sizeof(info));
        return result;
      },
      py::arg("c"));
  m.def("u_char_digit_value", &u_charDigitValue, py::arg("c"));
  m.def("u_char_direction", &u_charDirection, py::arg("c"));
  m.def(
      "u_char_from_name",
      [](UCharNameChoice name_choice, const char *name) {
        ErrorCode error_code;
        auto result = u_charFromName(name_choice, name, error_code);
        if (error_code.isFailure()) {
          throw ICUError(error_code);
        }
        return result;
      },
      py::arg("name_choice"), py::arg("name"));
  m.def("u_char_mirror", &u_charMirror, py::arg("c"));
  m.def(
      "u_char_name",
      [](UChar32 code, UCharNameChoice name_choice) {
        ErrorCode error_code;
        const auto length = u_charName(code, name_choice, nullptr, 0, error_code);
        std::string result(length, '\0');
        error_code.reset();
        u_charName(code, name_choice, result.data(), static_cast<int32_t>(result.size()), error_code);
        if (error_code.isFailure()) {
          throw ICUError(error_code);
        }
        return result;
      },
      py::arg("code"), py::arg("name_choice"));
  m.def("u_char_type", &u_charType, py::arg("c"));
  m.def("u_digit", &u_digit, py::arg("ch"), py::arg("radix"));
  m.def("u_fold_case", &u_foldCase, py::arg("c"), py::arg("options"));
  m.def("u_for_digit", &u_forDigit, py::arg("digit"), py::arg("radix"));
#if (U_ICU_VERSION_MAJOR_NUM >= 52)
  m.def("u_get_bidi_paired_bracket", &u_getBidiPairedBracket, py::arg("c"));
#endif // (U_ICU_VERSION_MAJOR_NUM >= 52)
#if (U_ICU_VERSION_MAJOR_NUM >= 63)
  m.def(
      "u_get_binary_property_set",
      [](UProperty property) {
        ErrorCode error_code;
        auto uset = u_getBinaryPropertySet(property, error_code);
        if (error_code.isFailure()) {
          throw ICUError(error_code);
        }
        return std::make_unique<_ConstUSetPtr>(uset);
      },
      py::arg("property_"));
#endif // (U_ICU_VERSION_MAJOR_NUM >= 63)
  m.def("u_get_combining_class", &u_getCombiningClass, py::arg("c"));
  m.def(
      "u_get_fc_nfkc_closure",
      [](UChar32 c) {
        ErrorCode error_code;
        const auto length = u_getFC_NFKC_Closure(c, nullptr, 0, error_code);
        std::u16string result(length, u'\0');
        error_code.reset();
        u_getFC_NFKC_Closure(c, result.data(), static_cast<int32_t>(result.size()), error_code);
        if (error_code.isFailure()) {
          throw ICUError(error_code);
        }
        return result;
      },
      py::arg("c"));
#if (U_ICU_VERSION_MAJOR_NUM >= 63)
  m.def(
      "u_get_int_property_map",
      [](UProperty property) {
        ErrorCode error_code;
        auto map = u_getIntPropertyMap(property, error_code);
        if (error_code.isFailure()) {
          throw ICUError(error_code);
        }
        return std::make_unique<_ConstUCPMapPtr>(map);
      },
      py::return_value_policy::reference, py::arg("property_"));
#endif // (U_ICU_VERSION_MAJOR_NUM >= 63)
  m.def("u_get_int_property_max_value", &u_getIntPropertyMaxValue, py::arg("which"));
  m.def("u_get_int_property_min_value", &u_getIntPropertyMinValue, py::arg("which"));
  m.def("u_get_int_property_value", &u_getIntPropertyValue, py::arg("c"), py::arg("which"));
  m.def("u_get_numeric_value", &u_getNumericValue, py::arg("c"));
  m.def("u_get_property_enum", &u_getPropertyEnum, py::arg("alias"));
  m.def("u_get_property_name", &u_getPropertyName, py::arg("property_"), py::arg("name_choice"),
        py::return_value_policy::reference);
  m.def("u_get_property_value_enum", &u_getPropertyValueEnum, py::arg("property_"), py::arg("alias"));
  m.def("u_get_property_value_name", &u_getPropertyValueName, py::arg("property_"), py::arg("value"),
        py::arg("name_choice"));
  m.def("u_get_unicode_version", []() {
    UVersionInfo info;
    u_getUnicodeVersion(info);
    std::vector<uint8_t> result(info, info + sizeof(info));
    return result;
  });
  m.def("u_has_binary_property", &u_hasBinaryProperty, py::arg("c"), py::arg("which"));
  m.def("u_isalnum", &u_isalnum, py::arg("c"));
  m.def("u_isalpha", &u_isalpha, py::arg("c"));
  m.def("u_isbase", &u_isbase, py::arg("c"));
  m.def("u_isblank", &u_isblank, py::arg("c"));
  m.def("u_iscntrl", &u_iscntrl, py::arg("c"));
  m.def("u_isdefined", &u_isdefined, py::arg("c"));
  m.def("u_isdigit", &u_isdigit, py::arg("c"));
  m.def("u_isgraph", &u_isgraph, py::arg("c"));
  m.def("u_is_id_ignorable", &u_isIDIgnorable, py::arg("c"));
  m.def("u_is_id_part", &u_isIDPart, py::arg("c"));
  m.def("u_is_id_start", &u_isIDStart, py::arg("c"));
  m.def("u_is_iso_control", &u_isISOControl, py::arg("c"));
  m.def("u_is_java_id_part", &u_isJavaIDPart, py::arg("c"));
  m.def("u_is_java_id_start", &u_isJavaIDStart, py::arg("c"));
  m.def("u_is_java_space_char", &u_isJavaSpaceChar, py::arg("c"));
  m.def("u_islower", &u_islower, py::arg("c"));
  m.def("u_is_mirrored", &u_isMirrored, py::arg("c"));
  m.def("u_isprint", &u_isprint, py::arg("c"));
  m.def("u_ispunct", &u_ispunct, py::arg("c"));
  m.def("u_isspace", &u_isspace, py::arg("c"));
  m.def("u_istitle", &u_istitle, py::arg("c"));
  m.def("u_is_ualphabetic", &u_isUAlphabetic, py::arg("c"));
  m.def("u_is_ulowercase", &u_isULowercase, py::arg("c"));
  m.def("u_isupper", &u_isupper, py::arg("c"));
  m.def("u_is_uuppercase", &u_isUUppercase, py::arg("c"));
  m.def("u_is_uwhite_space", &u_isUWhiteSpace, py::arg("c"));
  m.def("u_is_whitespace", &u_isWhitespace, py::arg("c"));
  m.def("u_isxdigit", &u_isxdigit, py::arg("c"));
  m.def("u_tolower", &u_tolower, py::arg("c"));
  m.def("u_totitle", &u_totitle, py::arg("c"));
  m.def("u_toupper", &u_toupper, py::arg("c"));
  m.def("ublock_get_code", &ublock_getCode, py::arg("c"));

  m.attr("U_NO_NUMERIC_VALUE") = U_NO_NUMERIC_VALUE;
  m.attr("U_UNICODE_VERSION") = U_UNICODE_VERSION;
  m.attr("UCHAR_MAX_VALUE") = UCHAR_MAX_VALUE;
  m.attr("UCHAR_MIN_VALUE") = UCHAR_MIN_VALUE;
}
