# -*- coding: utf-8 -*-

"""
Django settings for mysite project.

Generated by 'django-admin startproject' using Django 1.8.5.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'z4_1u0s82j$e$)s)23ha+oqryrgx9#lnp68-#h(##%m4y0k1$t'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']

HOST_NAME = 'localhost:8000'

# Application definition

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'djangoplus',
    'djangoplus.docs',
    'djangoplus.test',
    'djangoplus.admin',
    'djangoplus.ui',
    'djangoplus.ui.components.forms',
    'djangoplus.ui.components.calendar',
    'djangoplus.ui.components.select',
    'djangoplus.ui.components.navigation',
    'djangoplus.ui.components.paginator',
    'djangoplus.ui.components.panel',
    'djangoplus.ui.components.utils',
    'djangoplus.ui.components.editor',
)

APP_MAPPING = {
    'admin': 'djangoplus.admin',
    'guide': 'djangoplus.ui.components.guide',
    'docs': 'djangoplus.docs'
}

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'djangoplus.ui.ComponenteResponseMiddleware',
]

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'djangoplus.admin.context_processors.context_processor'
            ],
            'builtins': [
                'djangoplus.templatetags',
                'djangoplus.ui.components.paginator.templatetags'
            ],
        },
    },
]

# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'pt-br'

TIME_ZONE = 'America/Recife'

USE_I18N = True

USE_L10N = True

USE_TZ = False

STATIC_URL = '/static/'

MEDIA_URL = '/media/'

AUTH_USER_MODEL = 'admin.User'

EXTRA_JS = []

EXTRA_CSS = []

DEFAULT_SUPERUSER = 'admin'
DEFAULT_PASSWORD = 'senha'
USERNAME_MASK = None
DROPBOX_TOKEN = ''
BACKUP_FILES = ['media', 'sqlite.db']

LOGGING_ = {
    'version': 1,
    'filters': {
        'require_debug_true': {
            '()': 'django.utils.log.RequireDebugTrue',
        }
    },
    'handlers': {
        'console': {
            'level': 'DEBUG',
            'filters': ['require_debug_true'],
            'class': 'djangoplus.utils.logging.CustomStreamHandler',
        }
    },
    'loggers': {
        'django.db.backends': {
            'level': 'DEBUG',
            'handlers': ['console'],
        }
    }
}

GRADIENT = ('#aeb6bf', '#85929e', '#5d6d7e', '#d6dbdf', '#34495e', '#2e4053')

CAPTCHA_KEY = '6Lcpc1IUAAAAADXT-pykYw7_duD4NkrQ54VXjlfJ'
CAPTCHA_SECRET = '6Lcpc1IUAAAAABiWOqddzw63lR6ZEaQTtpuM-X5m'

EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'
