
/* Select2  */
var selects = [];

function reloadSelects(){
    if(selects.length>0) {
        var item = selects.pop();
        var value = item[0];
        var description = item[1];
        var id = '#' + item[2];
        $(id).append($("<option value=" + value + ">" + description + "</option>"));
        $(id).val(value);
        $(id).trigger("change");
    }
}

function checkWidgets(checkbox){
    var scope = $(checkbox).attr('data-scope');
    var checked = $(checkbox).prop('checked');
    if(checked) enableWidgets($(checkbox).closest(scope));
    else disableWidgets($(checkbox).closest(scope));
}

function disableWidgets(scope){
    scope.find('select.form-control').prop('disabled', true);
    scope.find('input.form-control').prop('disabled', true);
    scope.find('.select2-selection--single').css('cursor', 'not-allowed');
}
function enableWidgets(scope){
    scope.find('.select2-selection--single').css('cursor', 'default');
    scope.find('select.form-control').prop('disabled', false);
    scope.find('input.form-control').prop('disabled', false);
}

function showPlaceHolders(){
    var options = $('select:visible option').filter(function() {
        return !this.value || $.trim(this.value).length == 0 || $.trim(this.text).length == 0;
    })
    for(var i=0; i<options.length; i++){
        var option = options[i];
        option.innerHTML = option.parentNode.getAttribute('data-placeholder')
    }
}

/* Popup */

var stack = [];


function scrollTop(dontScrool){
    if(dontScrool!=true && top!=null){
        $('html, body').animate({scrollTop: 0}, 1000);
    }
}

function popup(url, reloadOnClose){
    if(reloadOnClose!=false) stack.push([url, $( "#app-modal-content" ).children().detach()]);

    $(".popover").popover("hide");
    var url = addPopupParam(url);
    function success(html){
        if(html=='..'){
            closePopup();
            loadUrl(document.location.href, true);
        } else {
            $('#app-modal-content').hide().html(html).fadeIn(1000);
            initialize('#app-modal-content');
            if($('#app-modal-content').find('form').length>0) {
                $('#modal-form-submit-label').parent().show();
                $('#modal-form-submit-label').html($('#form-submit-label').val());
                $('#modal-form-submit-label').parent().addClass($('#form-submit-style').val());
            } else {
                $('#modal-form-submit-label').parent().hide();
            }
            $('#app_modal').modal('show');
        }
    }
    $.ajax({type:'GET', url:url, success:success, error:error, async: true});

}

function cancelPopup(){
    var item = stack.pop()
    $('#overlay').fadeOut(800);
    return $('#app_modal').modal('hide');
}

function closePopup(redirectTo){

    var item = stack.pop()
    $('#overlay').fadeOut(800);
    if(item==null) return $('#app_modal').modal('hide');

    var url = item[0];
    var nodes = item[1]
    if(stack.length>0 || url.indexOf('select=')>=0){
        $('#app-modal-content').empty();
        item[1].hide().appendTo('#app-modal-content').fadeIn(1000);
        reloadSelects();
        if(stack.length==0) $('#app_modal').modal('hide');
    } else {
        var item = stack[stack.length-1];
        if(item!=null) {
            var url = item[0];
            loadUrl(url, true);
        } else {
            if(redirectTo) loadUrl(redirectTo, true);
            else loadUrl(document.location.href, true);
        }
        $('#app_modal').modal('hide');
    }
}

/* Ajax */

function error(xhr, ajaxOptions, thrownError) {
    $('body').removeClass('waiting');
    var html = xhr.responseText.replace(/\n/g,'<br/>');
    $('#app-modal-content').hide().html(html).fadeIn(1000);
    $('#app_modal').modal('show');
    $('#modal-form-submit-label').parent().hide();
    $('#overlay').fadeOut(800);
}

function load(html, dontScrool){
    Pace.start();
    fullscreen = $('.panel-fullscreen').prop('id')
    $('body').html(html);
    if(fullscreen) $('#'+fullscreen).addClass('panel-fullscreen');
    initialize();
    Pace.stop();
    scrollTop(dontScrool);
}

function loadBinaryData(blob){
    $('#overlay').fadeOut(800);
    var file = window.URL.createObjectURL(blob);
    var a = document.createElement("a");
    a.href = file;
    if(blob.type.indexOf('excel')>=0) a.download = 'Download.xls';
    else if(blob.type.indexOf('pdf')>=0) a.download = 'Download.pdf';
    else if(blob.type.indexOf('zip')>=0) a.download = 'Download.zip';
    else if(blob.type.indexOf('json')>=0) a.download = 'Download.json';
    else if(blob.type.indexOf('csv')>=0) a.download = 'Download.csv';
    document.body.appendChild(a);
    a.click();
}

function loadUrl(url, dontScrool){
    $('#overlay').show();
    function success(blob){
        if(blob.type.indexOf('text')>=0){
            var reader = new FileReader();
            reader.onload = function (event) {
                updateAddressBar(url);
                data = reader.result;
                if (data[0] == '.'){
                    loadUrl(referrer, true);
                }
                else if (data[0] == '/') {
                    loadUrl(data, dontScrool);
                } else {
                    load(data, dontScrool);
                }
                reloadSelects();
                $('#overlay').fadeOut(800);
            };
            reader.readAsText(blob);
        } else {
            loadBinaryData(blob)
        }
    }
    $.ajax({dataType:'blob', type:'GET', url:url, success:success, error:error, async: true});

}
var referrer = document.location.href;
function updateAddressBar(url){
    url = url.replace('/breadcrumbs/reset', '');
    if(document.location.href!=url && url.indexOf('&ids=')==-1){
        referrer = document.location.href;
        window.history.pushState("string", "Title", url);
    }
}

function getParameterNames(url){
    var names = [];
    var tokens = url.split('&');
    for(var i=0; i<tokens.length; i++){
        names[names.length]=tokens[i].split('=')[0];
    }
    return names;
}

function removeURLParameter(url, parameter) {
    var urlparts= url.split('?');
    if (urlparts.length>=2) {
        var prefix= encodeURIComponent(parameter)+'=';
        var pars= urlparts[1].split(/[&;]/g);
        for (var i= pars.length; i-- > 0;) {
            //idiom for string.startsWith
            if (pars[i].lastIndexOf(prefix, 0) !== -1) {
                pars.splice(i, 1);
            }
        }
        url= urlparts[0]+'?'+pars.join('&');
    }
    if(url[url.length-1]=='?') url = url.substring(0, url.length-1);
    return url;
}

function addParam(type, url){
    if(url.indexOf(type+'=1')==-1) if(url.indexOf('?')>=0) url = url.replace('?', '?'+type+'=1&'); else url = url + '?'+type+'=1';
    return url;
}

function addPopupParam(url){
    return addParam('popup', url);
}


/* Form Submission */
function callback(blob){
    if(blob.type.indexOf('text')>=0){
        var reader = new FileReader();
        reader.onload = function (event) {
            html = reader.result;
            if(html[0]=='/'){
                loadUrl(html);
            } else if(html=='..'){
                loadUrl(referrer);
            } else {
                $('body').html(html);
                initialize('body');
                scrollTop();
                $('#overlay').fadeOut(800);
            }
            $('body').removeClass('waiting');
        };
        reader.readAsText(blob);
    } else {
        $('body').removeClass('waiting');
        loadBinaryData(blob)
    }
}
function modalCallback(blob){
    if(blob.type.indexOf('text')>=0){
        var reader = new FileReader();
        reader.onload = function (event) {
            data = reader.result;
            if(data[0].trim()!='' && !isNaN(data[0])){
                selects.push(data.split('|'));
                closePopup();
            }
            else if(data[0]=='/'){
                closePopup(data);
            }
            else if(data=='..'){
                closePopup();
            }
            else {
                $('#app-modal-content').html(data);
                initialize('#app-modal-content');
                $('#submit_panel').hide();
                $('#app-modal-content').animate({scrollTop: 0}, 1000);
                $('#overlay').fadeOut(800);
            }
            $('body').removeClass('waiting');
        };
        reader.readAsText(blob);
    } else {
        $('body').removeClass('waiting');
        loadBinaryData(blob)
    }
}

/* Page Loadig */

function initialize(element){
    if (!element) element = 'body';
    var context = jQuery(element);

   /* Configure Paginators Forms */
   context.find( ".table-form" ).submit(function( event ) {
        var id = this.id;
        var url = document.location.href;
        var paramsUrl = $('#'+id).serialize();
        var paramNames = getParameterNames(paramsUrl);
        for(var i=0; i<paramNames.length; i++)
            url = removeURLParameter(url, paramNames[i]);

        if(url.indexOf('?')==-1) var prefix='?'; else var prefix = '&';
        var queryString = prefix+paramsUrl;
        url = url+queryString;

        $('html, body').animate({scrollTop: $("#table"+id).offset().top}, 1000);

        $.get(url, function(html){
            var div = document.createElement('div');
            fullscreen = $('.panel-fullscreen').prop('id')
            $(div).html(html);
            $(' #table'+id).html($(div).find(' #table'+id).html());
            if(fullscreen) $('#'+fullscreen).addClass('panel-fullscreen');
            initialize('#table'+id);
            //updateAddressBar(url);
            window.history.replaceState( {} , document.location.href, url);
        });
        event.preventDefault();
    });

    /* Configure Popup Buttons and Links */
   var links = context.find('.popup');

   for (var i = 0; i < links.length; i++) {
        var link = links[i];

        if (jQuery(link).hasClass( "pdf" )){
            link.onclick = function (e) {
                var url = addPopupParam(this.title);
                $( '#app-modal-content' ).html('<embed src="'+url+'" width="100%" height="600">');
                $('#modal-form-submit-label').parent().hide();
            };
        } else {
            link.onclick = function (e) {
                popup(this.href);
                e.preventDefault();
            };
        }
    }


    /* Configure Ajax Buttons and Links */
    context.find('.ajax').click(function (e) {
        e.preventDefault();
        $(".popover").popover("hide");
        loadUrl(this.href);
    });


    /* Configure Form Submission */
    context.find( ".ajax-form" ).keypress(function (e) {
      if (e.which == 13 && e.target.tagName != 'TEXTAREA') {
        $(this).submit();
        return false;
      }
    });

    if(window['initializeMenu']) initializeMenu(document.location.pathname, '#__searchinput__', '#__lateralmenu__', '#__welcomemessage__', 200);


    $('.file-input').change(function()	{
		var filename = $(this).val().split('\\').pop();
		$(this).parent().find('span').attr('data-title',filename);
		$(this).parent().find('label').attr('data-title','Altere o arquivo');
		$(this).parent().find('label').addClass('selected');
	});

    context.find( ".ajax-form" ).submit(function( event2 ) {
        $('#overlay').show();
        $('body').addClass('waiting');
        var success = callback;
        var url = $(this).attr('action');
        var method = $(this).attr('method').toUpperCase();
        var data = null;

        if(method=='GET'){
            data = $(this).serialize();
            updateAddressBar(url+'?'+data);
        } else {
            data = new FormData(this);
            if($(this).hasClass('popup-form')){
                data.append("popup", "1");
                success = modalCallback;
            }
        }
        event2.preventDefault();
        $.ajax({dataType:'blob', url: url,type: method,data: data,async: true,success: success, error:error,cache: false,contentType: false,processData: false});

    });

    context.find(".fullscreen-action").click(function (e) {
        e.preventDefault();

        var $this = $(this);

        if ($this.children('i').hasClass('glyphicon-resize-full'))
        {
            $this.children('i').removeClass('glyphicon-resize-full');
            $this.children('i').addClass('glyphicon-resize-small');
        }
        else if ($this.children('i').hasClass('glyphicon-resize-small'))
        {
            $this.children('i').removeClass('glyphicon-resize-small');
            $this.children('i').addClass('glyphicon-resize-full');
        }
        $(this).closest('.panel').toggleClass('panel-fullscreen');
    });



    //scroll to top of the page
    $("#scroll-to-top").click(function()	{
        $("html, body").animate({ scrollTop: 0 }, 600);
         return false;
    });

    //Tool tips
    $("[data-toggle=tooltip]").tooltip();

    // Images
    $('.materialboxed').materialbox();

    var slice = 3;
    if (location.pathname.indexOf('/add/')==0 || location.pathname.indexOf('/view/')==0) slice = 4;
    var funcName = location.pathname.substr(0, location.pathname.length-1).split('/').slice(1, slice).join('__');
    if(window[funcName]) window[funcName]();

    // Tree
    $('.tree').treegrid({
          'initialState': 'collapsed',
          'saveState': true,
        });

    var checkboxes = $('.one-to-many-checkbox, .one-to-one-checkbox');
    for(var i=0; i<checkboxes.length; i++) checkWidgets(checkboxes[i]);
    showPlaceHolders();

    /* Sidebar */
    context.find('#menu-toggle').click(function (e) {
        $.ajax({type:'GET', url:'/admin/toggle_menu/'})
    });

}


// Endless theme
$(window).on('load', function() {
    /* Initialize Menu */
    $('#overlay').fadeOut(800);
	initialize();
});

$(window).scroll(function(){

	 var position = $(window).scrollTop();

	 //Display a scroll to top button
	 if(position >= 200)	{
		$('#scroll-to-top').attr('style','bottom:8px;');
	 }
	 else	{
		$('#scroll-to-top').removeAttr('style');
	 }
});


