/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileTopDown;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileTopDown3
extends AbstractGtile {
    protected final Gtile tile1;
    protected final Gtile tile2;
    protected final Gtile tile3;
    private final Dimension2D dim1;
    private final Dimension2D dim2;
    private final Dimension2D dim3;
    private final UTranslate pos1;
    private final UTranslate pos2;
    private final UTranslate pos3;

    public GtileTopDown3(Gtile tile1, Gtile tile2, Gtile tile3) {
        super(tile1.getStringBounder(), tile1.skinParam());
        GtileTopDown tile12 = new GtileTopDown(tile1, tile2);
        GtileTopDown tile123 = new GtileTopDown(tile12, tile3);
        this.tile1 = tile1;
        this.tile2 = tile2;
        this.tile3 = tile3;
        this.dim1 = tile1.calculateDimension(this.stringBounder);
        this.dim2 = tile2.calculateDimension(this.stringBounder);
        this.dim3 = tile3.calculateDimension(this.stringBounder);
        this.pos1 = tile123.getPos1().compose(tile12.getPos1());
        this.pos2 = tile123.getPos1().compose(tile12.getPos2());
        this.pos3 = tile123.getPos2();
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        if (name.equals("NORTH_HOOK")) {
            return this.getPos1().compose(this.tile1.getCoord(name));
        }
        if (name.equals("SOUTH_HOOK")) {
            return this.getPos3().compose(this.tile3.getCoord(name));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Swimlane getSwimlane(String name) {
        if (name.equals("NORTH_HOOK")) {
            return this.tile1.getSwimlane(name);
        }
        if (name.equals("SOUTH_HOOK")) {
            return this.tile3.getSwimlane(name);
        }
        throw new UnsupportedOperationException();
    }

    protected UTranslate getPos1() {
        return this.pos1;
    }

    protected UTranslate getPos2() {
        return this.pos2;
    }

    protected UTranslate getPos3() {
        return this.pos3;
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        ug.apply(this.getPos1()).draw(this.tile1);
        ug.apply(this.getPos2()).draw(this.tile2);
        ug.apply(this.getPos3()).draw(this.tile3);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D corner1 = this.getPos1().getTranslated(this.dim1);
        Dimension2D corner2 = this.getPos2().getTranslated(this.dim2);
        Dimension2D corner3 = this.getPos3().getTranslated(this.dim3);
        return MathUtils.max(corner1, corner2, corner3);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        result.addAll(this.tile1.getSwimlanes());
        result.addAll(this.tile2.getSwimlanes());
        result.addAll(this.tile3.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }
}

