# coding: utf-8

"""
    Event Detection API

     Event detection occurs when ThousandEyes identifies that error signals related to a component (proxy, network node, AS, server etc) have deviated from the baselines established by events. * To determine this, ThousandEyes takes the test results from all accounts groups within an organization, and analyzes that data. * Noisy test results (those that have too many errors in a short window) are removed until they stabilize, and the rest of the results are tagged with the components associated with that test result (for example, proxy, network, or server). * Next, any increase in failures from the test results and each component helps in determining the problem domain and which component may be at fault. * When this failure rate increases beyond a pre-defined threshold (set by the algorithm), an event is triggered and an email notification is sent to the user (if they've enabled email alerts).  With the Events API, you can perform the following tasks on the ThousandEyes platform: * **Retrieve Events**: Obtain a list of events and detailed information for each event. For more information about events, see [Event Detection](https://docs.thousandeyes.com/product-documentation/event-detection). 

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class TestType(str, Enum):
    """
    This is a read only value, as test type is implicit in the test creation url.
    """

    """
    allowed enum values
    """
    API = 'api'
    AGENT_MINUS_TO_MINUS_AGENT = 'agent-to-agent'
    AGENT_MINUS_TO_MINUS_SERVER = 'agent-to-server'
    BGP = 'bgp'
    HTTP_MINUS_SERVER = 'http-server'
    PAGE_MINUS_LOAD = 'page-load'
    WEB_MINUS_TRANSACTIONS = 'web-transactions'
    FTP_MINUS_SERVER = 'ftp-server'
    DNS_MINUS_TRACE = 'dns-trace'
    DNS_MINUS_SERVER = 'dns-server'
    DNSSEC = 'dnssec'
    SIP_MINUS_SERVER = 'sip-server'
    VOICE = 'voice'
    UNKNOWN = 'unknown'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TestType from a JSON string"""
        return cls(json.loads(json_str))

    @classmethod
    def _missing_(cls, value):
        """Handle unknown values"""
        return cls.UNKNOWN

