# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-07-28 19:45
from __future__ import unicode_literals

from django.db import migrations


def migrate_command_datetimes(apps, schema_editor):
    """
    Migrate start_datetime and finish_datetime values from RawDataCommand
    """
    RawDataVersion = apps.get_model("calaccess_raw", "RawDataVersion")
    
    # for each version
    for v in RawDataVersion.objects.all():
        # get all downloads for the version
        downloads = v.command_logs.filter(
            command='downloadcalaccessrawdata',
        )
        # if there are downloads, get the last one started
        if downloads:
            d = downloads.latest('start_datetime')
            # set the version's download start and finish datetimes
            v.download_start_datetime = d.start_datetime
            v.download_finish_datetime = d.finish_datetime
        
        # get all extractions for the version
        extracts = v.command_logs.filter(
            command='extractcalaccessrawfiles',
        )
        # if there are extraction, get the last one started
        if extracts:
            e = extracts.latest('start_datetime')
            # set the version's extract start and finish datetimes
            v.extract_start_datetime = e.start_datetime
            v.extract_finish_datetime = e.finish_datetime

        # get all updates for the version
        updates = v.command_logs.filter(
            command__contains='update',
        )
        # if there are updates, get the last one started
        if updates:
            u = updates.latest('start_datetime')
            # set the version's update start and finish datetimes
            v.update_start_datetime = u.start_datetime
            v.update_finish_datetime = u.finish_datetime

        # save changes to the RawDataVersion
        v.save()

        # for each of the version's files
        for f in v.files.all():
            # get all the files clean jobs
            cleans = v.command_logs.filter(
                command='cleancalaccessrawfile',
                file_name=f.file_name,
            )
            # if there are clean jobs, get the last one started
            if cleans:
                c = cleans.latest('start_datetime')
                # set the file version's clean start and finish times
                f.clean_start_datetime = c.start_datetime
                f.clean_finish_datetime = c.finish_datetime

            # get all the files load jobs
            loads = v.command_logs.filter(
                command='loadcalaccessrawfile',
                file_name=f.file_name,
            )
            # if there are load jobs, get the last one started
            if loads:
                l = loads.latest('start_datetime')
                # set the file version's load start and finish times
                f.load_start_datetime = l.start_datetime
                f.load_finish_datetime = l.finish_datetime

            # save changes to the RawDataFile
            f.save()


class Migration(migrations.Migration):

    dependencies = [
        ('calaccess_raw', '0011_auto_20160728_1944'),
    ]

    operations = [
        migrations.RunPython(migrate_command_datetimes)
    ]
