# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['cl',
 'cl.asr_models',
 'cl.examples',
 'cl.info',
 'cl.methods',
 'cl.utils',
 'cl.vad']

package_data = \
{'': ['*'], 'cl': ['hparams_examples/*'], 'cl.vad': ['hparams/*']}

install_requires = \
['pandas>=1.4.0,<1.5.0',
 'pre-commit>=2.3.0',
 'speechbrain-geoph9==0.5.12a0',
 'transformers==4.4.0']

entry_points = \
{'console_scripts': ['cl = cl.cli_dispatcher:dispatch']}

setup_kwargs = {
    'name': 'speechbrain-cl',
    'version': '1.0a0',
    'description': 'Implementation of multiple curriculum learning methods for speechbrain ASR (mirror from private repo).',
    'long_description': "# Curriculum Learning Methods for Speechbrain\n\n[![PyPI](https://img.shields.io/pypi/v/speechbrain-cl.svg)][pypi_]\n[![Status](https://img.shields.io/pypi/status/speechbrain-cl.svg)][status]\n[![Python Version](https://img.shields.io/pypi/pyversions/speechbrain-cl)][python version]\n[![License](https://img.shields.io/pypi/l/speechbrain-cl)][license]\n\n[![Read the documentation at https://speechbrain-cl.readthedocs.io/](https://img.shields.io/readthedocs/speechbrain-cl/latest.svg?label=Read%20the%20Docs)][read the docs]\n<!-- [![Tests](https://github.com/geoph9/speechbrain-cl/workflows/Tests/badge.svg)][tests] -->\n<!-- [![Codecov](https://codecov.io/gh/geoph9/speechbrain-cl/branch/main/graph/badge.svg)][codecov] -->\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)][pre-commit]\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)][black]\n\n[pypi_]: https://pypi.org/project/speechbrain-cl/\n[status]: https://pypi.org/project/speechbrain-cl/\n[python version]: https://pypi.org/project/speechbrain-cl\n[read the docs]: https://speechbrain-cl.readthedocs.io/\n<!-- [tests]: https://github.com/geoph9/speechbrain-cl/actions?workflow=Tests -->\n<!-- [codecov]: https://app.codecov.io/gh/geoph9/speechbrain-cl -->\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[black]: https://github.com/psf/black\n\n## Features\n\n- Implementation of multiple curriculum learning methods.\n- Scoring functions: shown to improve performance (on the expense of training time).\n- Pacing functions: improve training time (performance is on par to speechbrain's baseline).\n- Works as a library on top of `speechbrain`.\n\n\n## Installation\n\nYou can install _Speechbrain Cl_ via [pip] from [PyPI]:\n\n```console\n$ pip install speechbrain-cl\n```\n\nIf you are using poetry, then do `poetry add speechbrain-cl`.\n\n**Important Note:** This is intended to work on linux systems and you will probably encounter issues if you try to run this package on windows (and OS-X, too, probably).\n\n### From Github\n\n*Has only been tested on linux systems.*\n\n```bash\n# Clone repository\ngit clone git@github.com:aalto-speech/speechbrain-cl.git\n# Create a virtual environment\npython -m venv env\n# Source environment\nsource ./env/bin/activate\n```\n\n- **Option 1:** Non-editable mode\n```bash\n# Install `build` and build the package\npython -m pip install build && python -m build\n# Install the created .whl file\npython -m pip install dist/cl-1.0a0-py2.py3-none-any.whl\n```\n\n- **Option 2:** Editable mode (you can perform changes to the source code):\n```bash\n# Install package in editable mode\n# You first need to install `wheel` to avoid bdist_wheel errors.\npython -m pip install wheel\npython -m pip install -e .\n```\n\n## Usage\n\nPlease see the [Command-line Reference] for details.\n\nThe installed package is called `cl` and it can be used both as library and a CLI tool. The CLI is primarily intended for analyzing results of already trained models and may be buggy. Of course, they could still be useful and that's why the CLI options are documented. To check them, run `cl --help`.\n\nAs a library, `cl` offers two main interfaces:\n    - `cl.train_utils.fit`: Use this to fit a model based on some hyperparameters.\n    - `cl.asr_models.ASR`: The default ASR model implementation. Assumes a CRDNN encoder and an RNN with attention as the decoder. If you want to use a different architecture then it is advised to base you code on this class.\n\nCheck `examples/train.py` for an example of how to utilize them.\n\nThe CL strategies are defined in the `cl.curriculum` file, while the `cl.base_asr_model.BaseASR` is the base class that handles updating the data loader (each time the CL strategy updates the ordering) and logging the necessary information.\n\n### Command Line Interface\n\n### More Advanced Usage\n\nLet's say you have your own repository named `myasr` and want to test this package while also having the ability to tweak it. A simple way to do it would be to clone this repo inside your repository and then install it. An alternative would be to add this project as a submodule to your git repo which will make it easier for you to pull changes. Example (assuming you are in an already existing python venv):\n\n```bash\n# Add a submodule with the name `cl`\ngit submodule add git@github.com:aalto-speech/speechbrain-cl.git cl\n# (Optional) You will probably also have to pull from the submodule:\ngit submodule update --init --recursive\n# Install submodule\npython -m pip install -e cl\n# You can now either import the package or use its CLI:\ncl --help  # print help message\n```\n\nNow if you want to update the package:\n\n```bash\ngit submodule update --remote --merge\n# Check if everything went fine and that the installation still works\npython -m pip install -e cl\n```\n\n## Available CL methods\n\n- **Metric-based**: The training set is sorted based on the results of a metric (e.g. WER or CER). By default we use the same model that we are trying to train in order to extract these values.\n- **Loss-based**: Similar to the above, but instead uses seq2seq or seq2seq+ctc loss.\n- **Random**: The training set is randomly shuffled at the beginning of the training. If you stop and restart training, the same (shuffled) training set will be loaded (contrary to the default behavior of speechbrain which would shuffle every time we create a dataloader).\n- **Duration-based**: The default of speechbrain. Either ascending or descending. Leads to good results and also helps avoid using extra padding.\n- **No sorting**: The training set will be processed in the same order as the data appear in the input file(e.g. `train.csv` file).\n\n### CL sub-methods:\n\n- **Transfer CL**: The training set is sorted based on an already trained model, but the sortings may change, depending on the performance on the currently training model. The new sortings will be taken by using one of the basic CL methods discussed above.\n- **Transfer-fixed CL**: Same as above, except that the sortings never change (this is advised).\n- **Subsample CL**: Every `N` epochs (`N` is a hyperparameter) a provided percentage of the training set is sampled and used for training for the next `N` epochs. The order of the training set is determined by using either transfer CL or any of the standard methods.\n- **Subsample-incremental CL**: Same as above, but every `N` epochs we also increase the percentage of the training set that we are going to use for training.\n- **Noisy CL**: Can we used with any of the above methods (except *No sorting* and *Duration-based*). It separates the training set into three categories: easy, medium-level and hard examples (the distinction happens by usign the sortings provided from the methods above). It then procceeds to add some hard and medium-level examples among the easy ones. This has helped with overfitting issues.\n\nNOTE: The *Subsample* methods refer to curriculum learning with a combination of a scoring and a pacing function. The latter controls the flow with which the model sees the available training data. Check the subsampling area of the example recipe for more details.\n\n\n## How to Use\n\n1. Clone the project.\n2. (Optional) Create a virtual env.\n3. Install the package: `python -m pip install -e .` (in editable mode).\n4. Create a `.yaml` hyperparameters file. Check `cl/examples/hyperparameters.yaml` for an example. This is not very well documented yet.\n5. Copy the `train.py` file under `cl/examples` and adjust it to your needs. TODO: Maybe add the training option as part of the CLI.\n\n### Adjustment of the hyperparameters\n\nChoosing a CL method:\n\n- `wer`: metric-based scoring function that uses the word error rate to rank the training samples. This means that a decoding pass is required at each training epoch.\n- `cer`: similar to `wer` but uses character error rate instead.\n- `seq_loss`: loss-based scoring function using the sequence-to-sequence loss to rank the training samples.\n- `seq_ctc_loss`: Also uses the CTC loss values if CTC training is enabled.\n- `ctc_loss`: CTC only loss-based scoring function.\n- `random`: randomly shuffles the training data at the start of the first epoch. The same ranking will be kept even if you stop and resume training.\n- `no`: the training set is read as it is and no re-ordering occurs. This can be seen as a special case of the `random` method.\n- `ascending` and `descending`: duration-based CL.\n- `char`/`word`/`token`: The ordering of the training samples occurs before the first epoch (just like with duration-based cl), but the criterion for the score of each utterance is the amount of rare characters/words/tokens in their content.\n\n## Future Work:\n\n- More CL methods (especially based on pacing functions).\n- Add the training option as part of the CLI (the `prepare_dataset` function should be taken as an argument).\n- Add tests.\n\n\n## Contributing\n\nContributions are very welcome.\nTo learn more, see the [Contributor Guide].\n\n## License\n\nDistributed under the terms of the [MIT license][license],\n_Speechbrain Cl_ is free and open source software.\n\n## Issues\n\nIf you encounter any problems,\nplease [file an issue] along with a detailed description.\n\nSome well known issues:\n- For `numpy` to work you need to have BLAS/LAPACK (and probably fortran, too). To install them on Ubuntu, run: `sudo apt-get -y install liblapack-dev libblas-dev gfortran`.\n\n## Credits\n\nThis project was generated from [@cjolowicz]'s [Hypermodern Python Cookiecutter] template.\n\n[@cjolowicz]: https://github.com/cjolowicz\n[pypi]: https://pypi.org/\n[hypermodern python cookiecutter]: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n[file an issue]: https://github.com/geoph9/speechbrain-cl/issues\n[pip]: https://pip.pypa.io/\n\n<!-- github-only -->\n\n[license]: https://github.com/geoph9/speechbrain-cl/blob/main/LICENSE\n[contributor guide]: https://github.com/geoph9/speechbrain-cl/blob/main/CONTRIBUTING.md\n[command-line reference]: https://speechbrain-cl.readthedocs.io/en/latest/usage.html",
    'author': 'Georgios K.',
    'author_email': 'geoph9@protonmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/geoph9/speechbrain-cl',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.10',
}


setup(**setup_kwargs)
