"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ClientAffinity = exports.ConnectionProtocol = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 */
var ConnectionProtocol;
(function (ConnectionProtocol) {
    /**
     * TCP
     */
    ConnectionProtocol["TCP"] = "TCP";
    /**
     * UDP
     */
    ConnectionProtocol["UDP"] = "UDP";
})(ConnectionProtocol = exports.ConnectionProtocol || (exports.ConnectionProtocol = {}));
/**
 * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
 * regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
 * route each client to the same specific endpoint. If you want a given client to always be routed to the same
 * endpoint, set client affinity to SOURCE_IP.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 */
var ClientAffinity;
(function (ClientAffinity) {
    /**
     * default affinity
     */
    ClientAffinity["NONE"] = "NONE";
    /**
     * affinity by source IP
     */
    ClientAffinity["SOURCE_IP"] = "SOURCE_IP";
})(ClientAffinity = exports.ClientAffinity || (exports.ClientAffinity = {}));
/**
 * The construct for the Listener
 */
class Listener extends cdk.Resource {
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        const resource = new ga.CfnListener(this, 'Resource', {
            acceleratorArn: props.accelerator.acceleratorArn,
            portRanges: props.portRanges.map(m => ({
                fromPort: m.fromPort,
                toPort: m.toPort,
            })),
            protocol: (_a = props.protocol) !== null && _a !== void 0 ? _a : ConnectionProtocol.TCP,
            clientAffinity: (_b = props.clientAffinity) !== null && _b !== void 0 ? _b : ClientAffinity.NONE,
        });
        this.listenerArn = resource.attrListenerArn;
        this.listenerName = (_c = props.listenerName) !== null && _c !== void 0 ? _c : resource.logicalId;
    }
    /**
     * import from ARN
     */
    static fromListenerArn(scope, id, listenerArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.listenerArn = listenerArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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