"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props = {}) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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