"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({ produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            } });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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